/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.util.ArrayList;
import org.openjdk.asmtools.jasm.AnnotationData;
import org.openjdk.asmtools.jasm.AttrData;
import org.openjdk.asmtools.jasm.ClassData;
import org.openjdk.asmtools.jasm.DataVectorAttr;
import org.openjdk.asmtools.jasm.Modifiers;
import org.openjdk.asmtools.jasm.Tables;
import org.openjdk.asmtools.jasm.TypeAnnotationData;

public class MemberData {
    protected int access;
    protected AttrData syntheticAttr;
    protected AttrData deprecatedAttr;
    protected DataVectorAttr<AnnotationData> annotAttrVis = null;
    protected DataVectorAttr<AnnotationData> annotAttrInv = null;
    protected DataVectorAttr<TypeAnnotationData> type_annotAttrVis = null;
    protected DataVectorAttr<TypeAnnotationData> type_annotAttrInv = null;
    protected ClassData cls;

    public MemberData(ClassData cls, int access) {
        this.cls = cls;
        this.init(access);
    }

    public void init(int access) {
        this.access = access;
    }

    public void createPseudoMod() {
        if (Modifiers.isSyntheticPseudoMod(this.access)) {
            this.syntheticAttr = new AttrData(this.cls, Tables.AttrTag.ATT_Synthetic.parsekey());
            this.access &= 0xFFFEFFFF;
        }
        if (Modifiers.isDeprecatedPseudoMod(this.access)) {
            this.deprecatedAttr = new AttrData(this.cls, Tables.AttrTag.ATT_Deprecated.parsekey());
            this.access &= 0xFFFDFFFF;
        }
    }

    public void addAnnotations(ArrayList<AnnotationData> annttns) {
        for (AnnotationData annot : annttns) {
            boolean invisible = annot.invisible;
            if (annot instanceof TypeAnnotationData) {
                TypeAnnotationData tannot = (TypeAnnotationData)annot;
                if (invisible) {
                    if (this.type_annotAttrInv == null) {
                        this.type_annotAttrInv = new DataVectorAttr(this.cls, Tables.AttrTag.ATT_RuntimeInvisibleTypeAnnotations.parsekey());
                    }
                    this.type_annotAttrInv.add(tannot);
                    continue;
                }
                if (this.type_annotAttrVis == null) {
                    this.type_annotAttrVis = new DataVectorAttr(this.cls, Tables.AttrTag.ATT_RuntimeVisibleTypeAnnotations.parsekey());
                }
                this.type_annotAttrVis.add(tannot);
                continue;
            }
            if (invisible) {
                if (this.annotAttrInv == null) {
                    this.annotAttrInv = new DataVectorAttr(this.cls, Tables.AttrTag.ATT_RuntimeInvisibleAnnotations.parsekey());
                }
                this.annotAttrInv.add(annot);
                continue;
            }
            if (this.annotAttrVis == null) {
                this.annotAttrVis = new DataVectorAttr(this.cls, Tables.AttrTag.ATT_RuntimeVisibleAnnotations.parsekey());
            }
            this.annotAttrVis.add(annot);
        }
    }
}

