/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ConstantPool;
import org.openjdk.asmtools.jasm.Data;

class InnerClassData
implements Data {
    int access;
    ConstantPool.ConstCell name;
    ConstantPool.ConstCell innerClass;
    ConstantPool.ConstCell outerClass;

    public InnerClassData(int access, ConstantPool.ConstCell name, ConstantPool.ConstCell innerClass, ConstantPool.ConstCell outerClass) {
        this.access = access;
        this.name = name;
        this.innerClass = innerClass;
        this.outerClass = outerClass;
    }

    @Override
    public int getLength() {
        return 8;
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException {
        out.writeShort(this.innerClass.arg);
        if (this.outerClass.isSet()) {
            out.writeShort(this.outerClass.arg);
        } else {
            out.writeShort(0);
        }
        if (this.name.isSet()) {
            out.writeShort(this.name.arg);
        } else {
            out.writeShort(0);
        }
        out.writeShort(this.access);
    }
}

