/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import org.openjdk.asmtools.jasm.Argument;
import org.openjdk.asmtools.jasm.AttrData;
import org.openjdk.asmtools.jasm.CPXAttr;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ClassData;
import org.openjdk.asmtools.jasm.ConstantPool;
import org.openjdk.asmtools.jasm.DataVector;
import org.openjdk.asmtools.jasm.MemberData;
import org.openjdk.asmtools.jasm.Modifiers;
import org.openjdk.asmtools.jasm.Parser;
import org.openjdk.asmtools.jasm.Tables;

class FieldData
extends MemberData {
    protected ConstantPool.ConstValue_Pair nape;
    private AttrData initValue;

    public FieldData(ClassData cls, int acc, ConstantPool.ConstValue_Pair nape) {
        super(cls, acc);
        this.nape = nape;
        if (Modifiers.hasPseudoMod(acc)) {
            this.createPseudoMod();
        }
    }

    public void SetValue(Argument value_cpx) {
        this.initValue = new CPXAttr(this.cls, Tables.AttrTag.ATT_ConstantValue.parsekey(), value_cpx);
    }

    public void write(CheckedDataOutputStream out) throws IOException, Parser.CompilerError {
        out.writeShort(this.access);
        out.writeShort(this.nape.left.arg);
        out.writeShort(this.nape.right.arg);
        DataVector<AttrData> attrs = new DataVector<AttrData>();
        if (this.initValue != null) {
            attrs.add(this.initValue);
        }
        if (this.syntheticAttr != null) {
            attrs.add(this.syntheticAttr);
        }
        if (this.deprecatedAttr != null) {
            attrs.add(this.deprecatedAttr);
        }
        if (this.annotAttrVis != null) {
            attrs.add(this.annotAttrVis);
        }
        if (this.annotAttrInv != null) {
            attrs.add(this.annotAttrInv);
        }
        if (this.type_annotAttrVis != null) {
            attrs.add(this.type_annotAttrVis);
        }
        if (this.type_annotAttrInv != null) {
            attrs.add(this.type_annotAttrInv);
        }
        attrs.write(out);
    }
}

