/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.openjdk.asmtools.jasm.AttrData;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ClassData;
import org.openjdk.asmtools.jasm.Data;

class DataVectorAttr<T extends Data>
extends AttrData
implements Iterable<T> {
    private ArrayList<T> elements;
    private boolean byteIndex;

    public DataVectorAttr(ClassData cls, String name, boolean byteIndex, ArrayList<T> initialData) {
        super(cls, name);
        this.elements = initialData;
        this.byteIndex = byteIndex;
    }

    public DataVectorAttr(ClassData cls, String name, ArrayList<T> initialData) {
        this(cls, name, false, initialData);
    }

    public DataVectorAttr(ClassData cls, String name) {
        this(cls, name, false, new ArrayList());
    }

    public DataVectorAttr(ClassData cls, String name, boolean byteIndex) {
        this(cls, name, byteIndex, new ArrayList());
    }

    public T get(int index) {
        return (T)((Data)this.elements.get(index));
    }

    public void add(T element) {
        this.elements.add(element);
    }

    public void add(int i, T element) {
        this.elements.add(i, element);
    }

    public int size() {
        return this.elements.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.elements.iterator();
    }

    @Override
    public int attrLength() {
        int length = 0;
        for (Data elem : this.elements) {
            length += elem.getLength();
        }
        length = this.byteIndex ? ++length : (length += 2);
        return length;
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException {
        super.write(out);
        if (this.byteIndex) {
            out.writeByte(this.elements.size());
        } else {
            out.writeShort(this.elements.size());
        }
        for (Data elem : this.elements) {
            elem.write(out);
        }
    }
}

