/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.openjdk.asmtools.jasm.Argument;
import org.openjdk.asmtools.jasm.AttrData;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ClassData;
import org.openjdk.asmtools.jasm.ConstantPool;
import org.openjdk.asmtools.jasm.Data;
import org.openjdk.asmtools.jasm.DataVector;
import org.openjdk.asmtools.jasm.DataVectorAttr;
import org.openjdk.asmtools.jasm.Environment;
import org.openjdk.asmtools.jasm.Instr;
import org.openjdk.asmtools.jasm.MethodData;
import org.openjdk.asmtools.jasm.OpcodeTables;
import org.openjdk.asmtools.jasm.Parser;
import org.openjdk.asmtools.jasm.StackMapData;
import org.openjdk.asmtools.jasm.SwitchTable;
import org.openjdk.asmtools.jasm.Tables;

class CodeAttr
extends AttrData {
    protected MethodData mtd;
    protected ClassData cls;
    protected Environment env;
    protected Argument max_stack;
    protected Argument max_locals;
    protected Instr zeroInstr;
    protected Instr lastInstr;
    protected int cur_pc = 0;
    protected DataVector<TrapData> trap_table = new DataVector(0);
    protected DataVectorAttr<LineNumData> lin_num_tb;
    protected int lastln = 0;
    protected DataVectorAttr<LocVarData> loc_var_tb;
    protected DataVector<DataVectorAttr<? extends Data>> attrs;
    protected ArrayList<Integer> slots;
    protected HashMap<String, LocVarData> locvarsHash;
    protected HashMap<String, Label> labelsHash;
    protected HashMap<String, Trap> trapsHash;
    protected StackMapData curMapEntry = null;
    protected DataVectorAttr<StackMapData> stackMap;

    public CodeAttr(MethodData mtd, int pos, int paramcnt, Argument max_stack, Argument max_locals) {
        super(mtd.cls, Tables.AttrTag.ATT_Code.parsekey());
        this.mtd = mtd;
        this.cls = mtd.cls;
        this.env = this.cls.env;
        this.max_stack = max_stack;
        this.max_locals = max_locals;
        this.lastInstr = this.zeroInstr = new Instr();
        this.trap_table = new DataVector(0);
        this.attrs = new DataVector();
        if (this.env.debugInfoFlag) {
            this.lin_num_tb = new DataVectorAttr(this.cls, Tables.AttrTag.ATT_LineNumberTable.parsekey());
            this.attrs.add(this.lin_num_tb);
        }
        this.slots = new ArrayList(paramcnt);
        for (int k = 0; k < paramcnt; ++k) {
            this.slots.add(k, 1);
        }
    }

    void endCode() {
        this.checkTraps();
        this.checkLocVars();
        this.checkLabels();
    }

    Trap trapDecl(int pos, String name) {
        Trap local;
        if (this.trapsHash == null) {
            this.trapsHash = new HashMap(10);
            local = null;
        } else {
            local = this.trapsHash.get(name);
        }
        if (local == null) {
            local = new Trap(pos, name);
            this.trapsHash.put(name, local);
        }
        return local;
    }

    void beginTrap(int pos, String name) {
        Trap trap = this.trapDecl(pos, name);
        if (trap.start_pc != -1) {
            this.env.error("trap.tryredecl", (Object)name);
            return;
        }
        trap.start_pc = this.cur_pc;
    }

    void endTrap(int pos, String name) {
        Trap trap = this.trapDecl(pos, name);
        if (trap.end_pc != -1) {
            this.env.error("trap.endtryredecl", (Object)name);
            return;
        }
        trap.end_pc = this.cur_pc;
    }

    void trapHandler(int pos, String name, Argument type) {
        Trap trap = this.trapDecl(pos, name);
        trap.refd = true;
        TrapData trapData = new TrapData(pos, trap, this.cur_pc, type);
        this.trap_table.addElement(trapData);
    }

    void checkTraps() {
        if (this.trapsHash == null) {
            return;
        }
        for (Trap trap : this.trapsHash.values()) {
            if (trap.refd) continue;
            this.env.error(trap.pos, "warn.trap.notref", (Object)trap.name);
        }
        for (TrapData trapData : this.trap_table) {
            Trap trapLabel = trapData.trap;
            if (trapLabel.start_pc == -1) {
                this.env.error(trapData.pos, "trap.notry", (Object)trapLabel.name);
            }
            if (trapLabel.end_pc != -1) continue;
            this.env.error(trapData.pos, "trap.noendtry", (Object)trapLabel.name);
        }
    }

    Label labelDecl(String name) {
        Label local;
        if (this.labelsHash == null) {
            this.labelsHash = new HashMap(10);
            local = null;
        } else {
            local = this.labelsHash.get(name);
        }
        if (local == null) {
            local = new Label(name);
            this.labelsHash.put(name, local);
        }
        return local;
    }

    public Label LabelDef(int pos, String name) {
        Label label = this.labelDecl(name);
        if (label.defd) {
            this.env.error(pos, "label.redecl", (Object)name);
            return null;
        }
        label.defd = true;
        label.arg = this.cur_pc;
        return label;
    }

    public Label LabelRef(String name) {
        Label label = this.labelDecl(name);
        label.refd = true;
        return label;
    }

    void checkLabels() {
        if (this.labelsHash == null) {
            return;
        }
        for (Label local : this.labelsHash.values()) {
            if (local.defd) continue;
            this.env.error("label.undecl", (Object)local.name);
        }
    }

    LocVarData locvarDecl(String name) {
        LocVarData local;
        if (this.locvarsHash == null) {
            this.locvarsHash = new HashMap(10);
            local = null;
        } else {
            local = this.locvarsHash.get(name);
        }
        if (local == null) {
            local = new LocVarData(name);
            this.locvarsHash.put(name, local);
        }
        return local;
    }

    public void LocVarDataDef(int slot) {
        this.slots.set(slot, 1);
        if (this.max_locals != null && this.max_locals.arg < this.slots.size()) {
            this.env.error("warn.illslot", (Object)new Integer(slot).toString());
        }
    }

    public void LocVarDataDef(String name, ConstantPool.ConstCell type) {
        int k;
        LocVarData locvar;
        block4: {
            locvar = this.locvarDecl(name);
            if (locvar.defd) {
                this.env.error("locvar.redecl", (Object)name);
                return;
            }
            locvar.defd = true;
            locvar.start_pc = (short)this.cur_pc;
            locvar.name_cpx = this.cls.pool.FindCellAsciz(name);
            locvar.sig_cpx = type;
            for (k = 0; k < this.slots.size(); ++k) {
                if (this.slots.get(k) != 0) {
                    continue;
                }
                break block4;
            }
            k = this.slots.size();
        }
        this.LocVarDataDef(k);
        locvar.arg = k;
        if (this.loc_var_tb == null) {
            this.loc_var_tb = new DataVectorAttr(this.cls, Tables.AttrTag.ATT_LocalVariableTable.parsekey());
            this.attrs.add(this.loc_var_tb);
        }
        this.loc_var_tb.add(locvar);
    }

    public Argument LocVarDataRef(String name) {
        LocVarData locvar = this.locvarDecl(name);
        if (!locvar.defd) {
            this.env.error("locvar.undecl", (Object)name);
            locvar.defd = true;
        }
        locvar.refd = true;
        return locvar;
    }

    public void LocVarDataEnd(int slot) {
        this.slots.set(slot, 0);
    }

    public void LocVarDataEnd(String name) {
        LocVarData locvar = this.locvarsHash.get(name);
        if (locvar == null) {
            this.env.error("locvar.undecl", (Object)name);
            return;
        }
        if (!locvar.defd) {
            this.env.error("locvar.undecl", (Object)name);
            return;
        }
        locvar.length = (short)(this.cur_pc - locvar.start_pc);
        this.slots.set(locvar.arg, 0);
        this.locvarsHash.put(name, new LocVarData(name));
    }

    void checkLocVars() {
        if (this.locvarsHash == null) {
            return;
        }
        for (LocVarData locvar : this.locvarsHash.values()) {
            if (!locvar.defd || this.slots.get(locvar.arg) != 1) continue;
            locvar.length = (short)(this.cur_pc - locvar.start_pc);
            this.slots.set(locvar.arg, 0);
        }
    }

    public StackMapData getStackMap() {
        if (this.curMapEntry == null) {
            this.curMapEntry = new StackMapData(this.env);
            if (this.cls.cfv.major_version() >= 50) {
                this.curMapEntry.setIsStackMapTable(true);
            }
        }
        return this.curMapEntry;
    }

    void addInstr(int mnenoc_pos, OpcodeTables.Opcode opcode, Argument arg, Object arg2) {
        int ln;
        Instr newInstr;
        this.lastInstr.next = newInstr = new Instr(this.cur_pc, this.cls.env.pos, opcode, arg, arg2);
        this.lastInstr = newInstr;
        int len = opcode.length();
        switch (opcode) {
            case opc_tableswitch: {
                len = ((SwitchTable)arg2).recalcTableSwitch(this.cur_pc);
                break;
            }
            case opc_lookupswitch: {
                len = ((SwitchTable)arg2).calcLookupSwitch(this.cur_pc);
                break;
            }
            case opc_ldc: {
                ((ConstantPool.ConstCell)arg).setRank(0);
                break;
            }
            default: {
                if (!(arg instanceof ConstantPool.ConstCell)) break;
                ((ConstantPool.ConstCell)arg).setRank(1);
            }
        }
        if (this.env.debugInfoFlag && (ln = this.env.lineNumber(mnenoc_pos)) != this.lastln) {
            this.lin_num_tb.add(new LineNumData(this.cur_pc, ln));
            this.lastln = ln;
        }
        if (this.curMapEntry != null) {
            this.curMapEntry.pc = this.cur_pc;
            StackMapData prevStackFrame = null;
            if (this.stackMap == null) {
                this.stackMap = this.cls.cfv.major_version() >= 50 ? new DataVectorAttr(this.cls, Tables.AttrTag.ATT_StackMapTable.parsekey()) : new DataVectorAttr(this.cls, Tables.AttrTag.ATT_StackMap.parsekey());
                this.attrs.add(this.stackMap);
            } else if (this.stackMap.size() > 0) {
                prevStackFrame = this.stackMap.get(this.stackMap.size() - 1);
            }
            this.curMapEntry.setOffset(prevStackFrame);
            this.stackMap.add(this.curMapEntry);
            this.curMapEntry = null;
        }
        this.cur_pc += len;
    }

    @Override
    public int attrLength() {
        return 8 + this.cur_pc + this.trap_table.getLength() + this.attrs.getLength();
    }

    @Override
    public void write(CheckedDataOutputStream out) throws IOException, Parser.CompilerError {
        int mxstck = this.max_stack != null ? this.max_stack.arg : 0;
        int mxloc = this.max_locals != null ? this.max_locals.arg : this.slots.size();
        super.write(out);
        out.writeShort(mxstck);
        out.writeShort(mxloc);
        out.writeInt(this.cur_pc);
        Instr instr = this.zeroInstr.next;
        while (instr != null) {
            instr.write(out, this.env);
            instr = instr.next;
        }
        this.trap_table.write(out);
        this.attrs.write(out);
    }

    class TrapData
    implements Data {
        int pos;
        Trap trap;
        int handler_pc;
        Argument catchType;

        public TrapData(int pos, Trap trap, int handler_pc, Argument catchType) {
            this.pos = pos;
            this.trap = trap;
            this.handler_pc = handler_pc;
            this.catchType = catchType;
        }

        @Override
        public int getLength() {
            return 8;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeShort(this.trap.start_pc);
            out.writeShort(this.trap.end_pc);
            out.writeShort(this.handler_pc);
            if (this.catchType.isSet()) {
                out.writeShort(this.catchType.arg);
            } else {
                out.writeShort(0);
            }
        }
    }

    class Trap
    extends Local {
        int start_pc;
        int end_pc;
        int pos;

        Trap(int pos, String name) {
            super(name);
            this.start_pc = -1;
            this.end_pc = -1;
            this.pos = pos;
        }
    }

    class LineNumData
    implements Data {
        int start_pc;
        int line_number;

        public LineNumData(int start_pc, int line_number) {
            this.start_pc = start_pc;
            this.line_number = line_number;
        }

        @Override
        public int getLength() {
            return 4;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeShort(this.start_pc);
            out.writeShort(this.line_number);
        }
    }

    class LocVarData
    extends Local
    implements Data {
        short start_pc;
        short length;
        ConstantPool.ConstCell name_cpx;
        ConstantPool.ConstCell sig_cpx;

        public LocVarData(String name) {
            super(name);
        }

        @Override
        public int getLength() {
            return 10;
        }

        @Override
        public void write(CheckedDataOutputStream out) throws IOException {
            out.writeShort(this.start_pc);
            out.writeShort(this.length);
            out.writeShort(this.name_cpx.arg);
            out.writeShort(this.sig_cpx.arg);
            out.writeShort(this.arg);
        }
    }

    public static class Label
    extends Local {
        public Label(String name) {
            super(name);
        }
    }

    public static class Local
    extends Argument {
        String name;
        boolean defd = false;
        boolean refd = false;

        public Local(String name) {
            this.name = name;
        }
    }
}

