/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jasm;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.openjdk.asmtools.jasm.Argument;
import org.openjdk.asmtools.jasm.AttrData;
import org.openjdk.asmtools.jasm.BootstrapMethodData;
import org.openjdk.asmtools.jasm.CFVersion;
import org.openjdk.asmtools.jasm.CPXAttr;
import org.openjdk.asmtools.jasm.CheckedDataOutputStream;
import org.openjdk.asmtools.jasm.ConstantPool;
import org.openjdk.asmtools.jasm.DataVector;
import org.openjdk.asmtools.jasm.DataVectorAttr;
import org.openjdk.asmtools.jasm.Environment;
import org.openjdk.asmtools.jasm.FieldData;
import org.openjdk.asmtools.jasm.InnerClassData;
import org.openjdk.asmtools.jasm.MemberData;
import org.openjdk.asmtools.jasm.MethodData;
import org.openjdk.asmtools.jasm.Modifiers;
import org.openjdk.asmtools.jasm.ModuleAttr;
import org.openjdk.asmtools.jasm.Tables;

class ClassData
extends MemberData {
    CFVersion cfv;
    ConstantPool.ConstCell me;
    ConstantPool.ConstCell father;
    String myClassName;
    AttrData sourceFileNameAttr;
    ArrayList<Argument> interfaces;
    ArrayList<FieldData> fields = new ArrayList();
    ArrayList<MethodData> methods = new ArrayList();
    DataVectorAttr<InnerClassData> innerClasses = null;
    DataVectorAttr<BootstrapMethodData> bootstrapMethodsAttr = null;
    ModuleAttr moduleAttribute = null;
    Environment env;
    protected ConstantPool pool;
    private static final String DEFAULT_EXTENSION = ".class";
    String fileExtension = ".class";
    public CDOutputStream cdos;
    MethodData curMethod;
    static char fileSeparator;

    public final void init(int access, ConstantPool.ConstCell me, ConstantPool.ConstCell father, ArrayList<Argument> interfaces) {
        this.access = access;
        if (Modifiers.hasPseudoMod(access)) {
            this.createPseudoMod();
        }
        this.me = me;
        if (father == null) {
            father = this.pool.FindCellClassByName("java/lang/Object");
        }
        this.father = father;
        this.interfaces = interfaces;
        this.cfv.initClassDefaults();
    }

    public final void initAsModule() {
        this.access = 32768;
        this.me = this.pool.FindCellClassByName("module-info");
        this.father = new ConstantPool.ConstCell(0);
        this.cfv.initModuleDefaults();
    }

    public ClassData(Environment env, CFVersion cfv) {
        super(null, 0);
        this.cls = this;
        this.env = env;
        this.cfv = cfv;
        this.pool = new ConstantPool(env);
        this.cdos = new CDOutputStream();
    }

    public final boolean isInterface() {
        return Modifiers.isInterface(this.access);
    }

    protected void relinkBootstrapMethods() {
        if (this.bootstrapMethodsAttr == null) {
            return;
        }
        this.env.traceln("relinkBootstrapMethods");
        for (ConstantPool.ConstCell cell : this.pool) {
            BootstrapMethodData realbsmdata;
            ConstantPool.ConstValue ref = null;
            if (cell != null) {
                ref = cell.ref;
            }
            if (ref == null || ref.tag != Tables.ConstType.CONSTANT_INVOKEDYNAMIC && ref.tag != Tables.ConstType.CONSTANT_DYNAMIC) continue;
            ConstantPool.ConstValue_IndyOrCondyPair refval = (ConstantPool.ConstValue_IndyOrCondyPair)ref;
            BootstrapMethodData bsmdata = refval.bsmData;
            if (bsmdata == null || !bsmdata.isPlaceholder()) continue;
            int bsmindex = bsmdata.placeholder_index;
            if (bsmindex < 0 || bsmindex > this.bootstrapMethodsAttr.size()) {
                this.env.traceln("Warning: (ClassData.relinkBootstrapMethods()): Bad bootstrapMethods index: " + bsmindex);
                bsmdata.arg = bsmindex;
                continue;
            }
            refval.bsmData = realbsmdata = this.bootstrapMethodsAttr.get(bsmindex);
        }
    }

    protected void numberBootstrapMethods() {
        this.env.traceln("Numbering Bootstrap Methods");
        if (this.bootstrapMethodsAttr == null) {
            return;
        }
        int index = 0;
        for (BootstrapMethodData data : this.bootstrapMethodsAttr) {
            data.arg = index++;
        }
    }

    public ConstantPool.ConstValue_Pair mkNape(ConstantPool.ConstCell name, ConstantPool.ConstCell sig) {
        return new ConstantPool.ConstValue_Pair(Tables.ConstType.CONSTANT_NAMEANDTYPE, name, sig);
    }

    public ConstantPool.ConstValue_Pair mkNape(String name, String sig) {
        return this.mkNape(this.pool.FindCellAsciz(name), this.pool.FindCellAsciz(sig));
    }

    public void setSourceFileName(String name) {
    }

    public FieldData addField(int access, ConstantPool.ConstValue_Pair nape) {
        this.env.traceln(" [ClassData.addField]:  #" + nape.left.arg + ":#" + nape.right.arg);
        FieldData res = new FieldData(this, access, nape);
        this.fields.add(res);
        return res;
    }

    public FieldData addField(int access, ConstantPool.ConstCell name, ConstantPool.ConstCell sig) {
        return this.addField(access, this.mkNape(name, sig));
    }

    public FieldData addField(int access, String name, String type) {
        return this.addField(access, this.pool.FindCellAsciz(name), this.pool.FindCellAsciz(type));
    }

    public ConstantPool.ConstCell LocalFieldRef(FieldData field) {
        return this.pool.FindCell(Tables.ConstType.CONSTANT_FIELD, this.me, this.pool.FindCell(field.nape));
    }

    public ConstantPool.ConstCell LocalFieldRef(ConstantPool.ConstValue nape) {
        return this.pool.FindCell(Tables.ConstType.CONSTANT_FIELD, this.me, this.pool.FindCell(nape));
    }

    public ConstantPool.ConstCell LocalFieldRef(ConstantPool.ConstCell name, ConstantPool.ConstCell sig) {
        return this.LocalFieldRef(this.mkNape(name, sig));
    }

    public ConstantPool.ConstCell LocalFieldRef(String name, String sig) {
        return this.LocalFieldRef(this.pool.FindCellAsciz(name), this.pool.FindCellAsciz(sig));
    }

    public MethodData StartMethod(int access, ConstantPool.ConstCell name, ConstantPool.ConstCell sig, ArrayList exc_table) {
        this.EndMethod();
        this.env.traceln(" [ClassData.StartMethod]:  #" + name.arg + ":#" + sig.arg);
        this.curMethod = new MethodData(this, access, name, sig, exc_table);
        this.methods.add(this.curMethod);
        return this.curMethod;
    }

    public void EndMethod() {
        this.curMethod = null;
    }

    public ConstantPool.ConstCell LocalMethodRef(ConstantPool.ConstValue nape) {
        return this.pool.FindCell(Tables.ConstType.CONSTANT_METHOD, this.me, this.pool.FindCell(nape));
    }

    public ConstantPool.ConstCell LocalMethodRef(ConstantPool.ConstCell name, ConstantPool.ConstCell sig) {
        return this.LocalMethodRef(this.mkNape(name, sig));
    }

    void addLocVarData(int opc, Argument arg) {
    }

    public void addInnerClass(int access, ConstantPool.ConstCell name, ConstantPool.ConstCell innerClass, ConstantPool.ConstCell outerClass) {
        this.env.traceln("addInnerClass (with indexes: Name (" + name.toString() + "), Inner (" + innerClass.toString() + "), Outer (" + outerClass.toString() + ").");
        if (this.innerClasses == null) {
            this.innerClasses = new DataVectorAttr(this, Tables.AttrTag.ATT_InnerClasses.parsekey());
        }
        this.innerClasses.add(new InnerClassData(access, name, innerClass, outerClass));
    }

    public void addBootstrapMethod(BootstrapMethodData bsmData) {
        this.env.traceln("addBootstrapMethod");
        if (this.bootstrapMethodsAttr == null) {
            this.bootstrapMethodsAttr = new DataVectorAttr(this, Tables.AttrTag.ATT_BootstrapMethods.parsekey());
        }
        this.bootstrapMethodsAttr.add(bsmData);
    }

    public void endClass() {
        this.sourceFileNameAttr = new CPXAttr(this, Tables.AttrTag.ATT_SourceFile.parsekey(), this.pool.FindCellAsciz(this.env.getSourceName()));
        this.pool.NumberizePool();
        this.pool.CheckGlobals();
        this.numberBootstrapMethods();
        try {
            this.me = this.pool.uncheckedGetCell(this.me.arg);
            this.env.traceln("me=" + this.me);
            ConstantPool.ConstValue_Cell me_value = (ConstantPool.ConstValue_Cell)this.me.ref;
            ConstantPool.ConstCell ascicell = me_value.cell;
            this.env.traceln("ascicell=" + ascicell);
            ConstantPool.ConstValue_String me_str = (ConstantPool.ConstValue_String)ascicell.ref;
            this.myClassName = me_str.value;
            this.env.traceln("--------------------------------------------");
            this.env.traceln("-- Constant Pool --");
            this.env.traceln("-------------------");
            this.pool.printPool();
            this.env.traceln("--------------------------------------------");
            this.env.traceln(" ");
            this.env.traceln(" ");
            this.env.traceln("--------------------------------------------");
            this.env.traceln("-- Inner Classes --");
            this.env.traceln("-------------------");
            this.printInnerClasses();
        }
        catch (Throwable e) {
            this.env.traceln("check name:" + e);
            this.env.error("no.classname");
            e.printStackTrace();
        }
    }

    public void endModule(ModuleAttr moduleAttr) {
        this.moduleAttribute = moduleAttr.build();
        this.pool.NumberizePool();
        this.pool.CheckGlobals();
        this.myClassName = "module-info";
    }

    private void printInnerClasses() {
        if (this.innerClasses != null) {
            int i = 1;
            for (InnerClassData entry : this.innerClasses) {
                this.env.trace(" InnerClass[" + i + "]: (" + Modifiers.toString(entry.access, Tables.CF_Context.CTX_INNERCLASS) + "]), ");
                this.env.trace("Name:  " + entry.name.toString() + " ");
                this.env.trace("IC_info:  " + entry.innerClass.toString() + " ");
                this.env.trace("OC_info:  " + entry.outerClass.toString() + " ");
                this.env.traceln(" ");
                ++i;
            }
        } else {
            this.env.traceln("<< NO INNER CLASSES >>");
        }
    }

    public void write(CheckedDataOutputStream out) throws IOException {
        out.writeInt(-889275714);
        out.writeShort(this.cfv.minor_version());
        out.writeShort(this.cfv.major_version());
        this.pool.write(out);
        out.writeShort(this.access);
        out.writeShort(this.me.arg);
        out.writeShort(this.father.arg);
        if (this.interfaces != null) {
            out.writeShort(this.interfaces.size());
            for (Argument intf : this.interfaces) {
                out.writeShort(intf.arg);
            }
        } else {
            out.writeShort(0);
        }
        if (this.fields != null) {
            out.writeShort(this.fields.size());
            for (FieldData field : this.fields) {
                field.write(out);
            }
        } else {
            out.writeShort(0);
        }
        if (this.methods != null) {
            out.writeShort(this.methods.size());
            for (MethodData method : this.methods) {
                method.write(out);
            }
        } else {
            out.writeShort(0);
        }
        DataVector<AttrData> attrs = new DataVector<AttrData>();
        if (this.moduleAttribute != null) {
            if (this.annotAttrVis != null) {
                attrs.add(this.annotAttrVis);
            }
            if (this.annotAttrInv != null) {
                attrs.add(this.annotAttrInv);
            }
            attrs.add(this.moduleAttribute);
        } else {
            attrs.add(this.sourceFileNameAttr);
            if (this.innerClasses != null) {
                attrs.add(this.innerClasses);
            }
            if (this.syntheticAttr != null) {
                attrs.add(this.syntheticAttr);
            }
            if (this.deprecatedAttr != null) {
                attrs.add(this.deprecatedAttr);
            }
            if (this.annotAttrVis != null) {
                attrs.add(this.annotAttrVis);
            }
            if (this.annotAttrInv != null) {
                attrs.add(this.annotAttrInv);
            }
            if (this.type_annotAttrVis != null) {
                attrs.add(this.type_annotAttrVis);
            }
            if (this.type_annotAttrInv != null) {
                attrs.add(this.type_annotAttrInv);
            }
            if (this.bootstrapMethodsAttr != null) {
                attrs.add(this.bootstrapMethodsAttr);
            }
        }
        attrs.write(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File destdir) throws IOException {
        File outfile;
        if (destdir == null) {
            int startofname = this.myClassName.lastIndexOf("/");
            if (startofname != -1) {
                this.myClassName = this.myClassName.substring(startofname + 1);
            }
            outfile = new File(this.myClassName + this.fileExtension);
        } else {
            File outdir;
            this.env.traceln("writing -d " + destdir.getPath());
            if (fileSeparator == '\u0000') {
                fileSeparator = System.getProperty("file.separator").charAt(0);
            }
            if (fileSeparator != '/') {
                this.myClassName = this.myClassName.replace('/', fileSeparator);
            }
            if (!(outdir = new File((outfile = new File(destdir, this.myClassName + this.fileExtension)).getParent())).exists() && !outdir.mkdirs()) {
                this.env.error("cannot.write", (Object)outdir.getPath());
                return;
            }
        }
        this.cdos.setDataOutputStream(dos);
        try (DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outfile)));){
            this.write(this.cdos);
        }
    }

    public void setByteLimit(int bytelimit) {
        this.cdos.enable();
        this.cdos.setLimit(bytelimit);
    }

    private static class CDOutputStream
    implements CheckedDataOutputStream {
        private int bytelimit;
        private DataOutputStream dos;
        public boolean enabled = false;

        public CDOutputStream() {
            this.dos = null;
        }

        public CDOutputStream(OutputStream out) {
            this.setOutputStream(out);
        }

        public final void setOutputStream(OutputStream out) {
            this.dos = new DataOutputStream(out);
        }

        public void setDataOutputStream(DataOutputStream dos) {
            this.dos = dos;
        }

        public void setLimit(int lim) {
            this.bytelimit = lim;
        }

        public void enable() {
            this.enabled = true;
        }

        private synchronized void check(String loc) throws IOException {
            if (this.enabled && this.dos.size() >= this.bytelimit) {
                throw new IOException(loc);
            }
        }

        @Override
        public synchronized void write(int b) throws IOException {
            this.dos.write(b);
            this.check("Writing byte: " + b);
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) throws IOException {
            this.dos.write(b, off, len);
            this.check("Writing byte-array: " + b);
        }

        @Override
        public final void writeBoolean(boolean v) throws IOException {
            this.dos.writeBoolean(v);
            this.check("Writing writeBoolean: " + (v ? "true" : "false"));
        }

        @Override
        public final void writeByte(int v) throws IOException {
            this.dos.writeByte(v);
            this.check("Writing writeByte: " + v);
        }

        @Override
        public void writeShort(int v) throws IOException {
            this.dos.writeShort(v);
            this.check("Writing writeShort: " + v);
        }

        @Override
        public void writeChar(int v) throws IOException {
            this.dos.writeChar(v);
            this.check("Writing writeChar: " + v);
        }

        @Override
        public void writeInt(int v) throws IOException {
            this.dos.writeInt(v);
            this.check("Writing writeInt: " + v);
        }

        @Override
        public void writeLong(long v) throws IOException {
            this.dos.writeLong(v);
            this.check("Writing writeLong: " + v);
        }

        @Override
        public void writeFloat(float v) throws IOException {
            this.dos.writeFloat(v);
            this.check("Writing writeFloat: " + v);
        }

        @Override
        public void writeDouble(double v) throws IOException {
            this.dos.writeDouble(v);
            this.check("Writing writeDouble: " + v);
        }

        @Override
        public void writeBytes(String s) throws IOException {
            this.dos.writeBytes(s);
            this.check("Writing writeBytes: " + s);
        }

        @Override
        public void writeChars(String s) throws IOException {
            this.dos.writeChars(s);
            this.check("Writing writeChars: " + s);
        }

        @Override
        public void writeUTF(String s) throws IOException {
            this.dos.writeUTF(s);
            this.check("Writing writeUTF: " + s);
        }
    }
}

