/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public final class Module {
    public final Header header;
    public final Set<Uses> uses;
    public final Set<Dependence> requires;
    public final Map<Exported, Set<String>> exports;
    public final Map<Opened, Set<String>> opens;
    public final Map<Provided, Set<String>> provides;

    private Module(Builder builder) {
        this.header = builder.header;
        this.requires = Collections.unmodifiableSet(builder.requires);
        this.exports = Collections.unmodifiableMap(builder.exports);
        this.opens = Collections.unmodifiableMap(builder.opens);
        this.uses = Collections.unmodifiableSet(builder.uses);
        this.provides = Collections.unmodifiableMap(builder.provides);
    }

    public String getModuleFlags() {
        return Modifier.getModuleModifiers(this.header.getFlags());
    }

    public String getModuleName() {
        return this.header.getModuleName();
    }

    public String getModuleVersion() {
        return this.header.getModuleVersion();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int l = 0;
        this.requires.stream().sorted().forEach(d -> sb.append(String.format("  requires %s;%s%n", d.toString(), d.getModuleVersion() == null ? "" : " // @" + d.getModuleVersion())));
        l = this.newLine(sb, l);
        this.exports.entrySet().stream().filter(e -> ((Set)e.getValue()).isEmpty()).sorted(Map.Entry.comparingByKey()).map(e -> String.format("  exports %s;%n", ((Exported)e.getKey()).toString())).forEach(sb::append);
        this.exports.entrySet().stream().filter(e -> !((Set)e.getValue()).isEmpty()).sorted(Map.Entry.comparingByKey()).map(e -> String.format("  exports %s to%n%s;%n", ((Exported)e.getKey()).toString(), ((Set)e.getValue()).stream().sorted().map(mn -> String.format("          %s", mn)).collect(Collectors.joining(",\n")))).forEach(sb::append);
        l = this.newLine(sb, l);
        this.opens.entrySet().stream().filter(e -> ((Set)e.getValue()).isEmpty()).sorted(Map.Entry.comparingByKey()).map(e -> String.format("  opens %s;%n", ((Opened)e.getKey()).toString())).forEach(sb::append);
        this.opens.entrySet().stream().filter(e -> !((Set)e.getValue()).isEmpty()).sorted(Map.Entry.comparingByKey()).map(e -> String.format("  opens %s to%n%s;%n", ((Opened)e.getKey()).toString(), ((Set)e.getValue()).stream().sorted().map(mn -> String.format("          %s", mn)).collect(Collectors.joining(",\n")))).forEach(sb::append);
        l = this.newLine(sb, l);
        this.uses.stream().sorted().map(s -> String.format("  uses %s;%n", s)).forEach(sb::append);
        l = this.newLine(sb, l);
        this.provides.entrySet().stream().filter(e -> !((Set)e.getValue()).isEmpty()).sorted(Map.Entry.comparingByKey()).map(e -> String.format("  provides %s with%n%s;%n", ((Provided)e.getKey()).toString(), ((Set)e.getValue()).stream().sorted().map(mn -> String.format("          %s", mn)).collect(Collectors.joining(",\n")))).forEach(sb::append);
        if (Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private int newLine(StringBuilder sb, int length) {
        if (sb.length() > length) {
            sb.append("\n");
            return sb.length() + 1;
        }
        return length;
    }

    public static final class Builder {
        final Header header;
        final Set<Dependence> requires = new HashSet<Dependence>();
        final Map<Exported, Set<String>> exports = new HashMap<Exported, Set<String>>();
        final Map<Opened, Set<String>> opens = new HashMap<Opened, Set<String>>();
        final Set<Uses> uses = new HashSet<Uses>();
        final Map<Provided, Set<String>> provides = new HashMap<Provided, Set<String>>();

        public Builder() {
            this("", Modifier.ACC_NONE.asInt(), null);
        }

        public Builder(String moduleName, int moduleFlags, String moduleVersion) {
            this.header = new Header(moduleName, moduleFlags, moduleVersion);
        }

        public Builder setModuleFlags(int moduleFlags) {
            this.header.setFlag(this.header.getFlags() | moduleFlags);
            return this;
        }

        public Builder setModuleFlags(Modifier ... moduleFlags) {
            for (Modifier m : moduleFlags) {
                this.setModuleFlags(m.value);
            }
            return this;
        }

        public Builder setModuleName(String value) {
            this.header.setTypeName(value);
            return this;
        }

        public Builder require(String d, boolean transitive, boolean staticPhase, String version) {
            this.requires.add(new Dependence(d, transitive, staticPhase, version));
            return this;
        }

        public Builder require(String d, int requiresFlag, String version) {
            this.requires.add(new Dependence(d, requiresFlag, version));
            return this;
        }

        public Builder require(String d, int requiresFlag) {
            this.requires.add(new Dependence(d, requiresFlag, null));
            return this;
        }

        public Builder opens(Opened p, Set<String> ms) {
            return this.add(this.opens, p, ms);
        }

        public Builder opens(String packageName, int exportFlags, Set<String> ms) {
            return this.add(this.opens, new Opened(packageName, exportFlags), ms);
        }

        public Builder opens(String packageName, int exportFlags) {
            return this.add(this.opens, new Opened(packageName, exportFlags), new HashSet<String>());
        }

        public Builder exports(Exported p, Set<String> ms) {
            return this.add(this.exports, p, ms);
        }

        public Builder exports(String packageName, int exportFlags, Set<String> ms) {
            return this.add(this.exports, new Exported(packageName, exportFlags), ms);
        }

        public Builder exports(String packageName, int exportFlags) {
            return this.add(this.exports, new Exported(packageName, exportFlags), new HashSet<String>());
        }

        public Builder uses(String serviceName) {
            this.uses.add(new Uses(serviceName));
            return this;
        }

        public Builder uses(Set<String> serviceNames) {
            this.uses.addAll(serviceNames.stream().map(Uses::new).collect(Collectors.toList()));
            return this;
        }

        public Builder provides(Provided t, Set<String> implementations) {
            return this.add(this.provides, t, implementations);
        }

        public Builder provides(String serviceName, Set<String> implementations) {
            return this.add(this.provides, new Provided(serviceName), implementations);
        }

        public Module build() {
            return new Module(this);
        }

        private <T extends TargetType> Builder add(Map<T, Set<String>> collection, T source, Set<String> target) {
            Objects.requireNonNull(source);
            Objects.requireNonNull(target);
            if (!collection.containsKey(source)) {
                collection.put(source, new HashSet());
            }
            collection.get(source).addAll(target);
            return this;
        }
    }

    public static class TargetType
    implements Comparable<TargetType> {
        private String typeName;

        TargetType(String typeName) {
            this.typeName = typeName;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public void setTypeName(String value) {
            this.typeName = value;
        }

        public boolean isFlagged() {
            return false;
        }

        public int hashCode() {
            return this.typeName.hashCode() * 11;
        }

        public boolean equals(Object o) {
            if (o instanceof TargetType) {
                TargetType t = (TargetType)o;
                return this.typeName.equals(t.getTypeName());
            }
            return false;
        }

        @Override
        public int compareTo(TargetType t) {
            return this.typeName.compareTo(t.getTypeName());
        }

        public String toString() {
            return this.typeName;
        }
    }

    public static class FlaggedTargetType
    extends TargetType {
        private int flag;

        FlaggedTargetType(String typeName, int flag) {
            super(typeName);
            this.flag = flag;
        }

        @Override
        public boolean isFlagged() {
            return true;
        }

        public int getFlags() {
            return this.flag;
        }

        public void setFlag(int value) {
            this.flag = value;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.flag;
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o) && ((FlaggedTargetType)o).flag == this.flag;
        }

        @Override
        public String toString() {
            return Modifier.getStatementModifiers(this.flag) + super.toString();
        }
    }

    public static class VersionedFlaggedTargetType
    extends FlaggedTargetType {
        private String version;

        VersionedFlaggedTargetType(String typeName, int flag) {
            this(typeName, flag, null);
        }

        VersionedFlaggedTargetType(String typeName, int flag, String version) {
            super(typeName, flag);
            this.version = version != null && !version.isEmpty() ? version : null;
        }

        public String getVersion() {
            return this.version;
        }

        @Override
        public int hashCode() {
            int code = this.version == null ? 0 : this.version.hashCode();
            return code + super.hashCode();
        }
    }

    public static final class Exported
    extends FlaggedTargetType {
        public Exported(String typeName) {
            super(typeName, 0);
        }

        public Exported(String typeName, int exportsFlags) {
            super(typeName, exportsFlags);
        }
    }

    public static final class Opened
    extends FlaggedTargetType {
        public Opened(String typeName) {
            super(typeName, 0);
        }

        public Opened(String typeName, int opensFlags) {
            super(typeName, opensFlags);
        }
    }

    public static final class Provided
    extends TargetType {
        public Provided(String typeName) {
            super(typeName);
        }
    }

    public static final class Uses
    extends TargetType {
        public Uses(String typeName) {
            super(typeName);
        }
    }

    public static final class Dependence
    extends VersionedFlaggedTargetType {
        public Dependence(String moduleName, int flag) {
            this(moduleName, flag, null);
        }

        public Dependence(String moduleName, int flag, String moduleVersion) {
            super(moduleName, flag, moduleVersion);
        }

        public Dependence(String moduleName, boolean transitive, boolean staticPhase) {
            this(moduleName, transitive, staticPhase, null);
        }

        public Dependence(String moduleName, boolean transitive, boolean staticPhase, String moduleVersion) {
            this(moduleName, (transitive ? Modifier.ACC_TRANSITIVE.value : Modifier.ACC_NONE.value) | (staticPhase ? Modifier.ACC_STATIC_PHASE.value : Modifier.ACC_NONE.value), moduleVersion);
        }

        public String getModuleVersion() {
            return this.getVersion();
        }
    }

    public static final class Header
    extends VersionedFlaggedTargetType {
        Header(String typeName, int flag) {
            this(typeName, flag, null);
        }

        Header(String typeName, int flag, String moduleVersion) {
            super(typeName, flag, moduleVersion);
        }

        public String getModuleName() {
            return this.getTypeName();
        }

        public int getModuleFlags() {
            return this.getFlags();
        }

        public String getModuleVersion() {
            return this.getVersion();
        }
    }

    public static enum Modifier {
        ACC_NONE(0, "", ""),
        ACC_OPEN(32, "open", "ACC_OPEN"),
        ACC_TRANSITIVE(32, "transitive", "ACC_TRANSITIVE"),
        ACC_STATIC_PHASE(64, "static", "ACC_STATIC_PHASE"),
        ACC_SYNTHETIC(4096, "", "ACC_SYNTHETIC"),
        ACC_MANDATED(32768, "", "ACC_MANDATED");

        private final int value;
        private final String keyword;
        private final String flag;

        private Modifier(int value, String keyword, String flagName) {
            this.value = value;
            this.keyword = keyword;
            this.flag = flagName;
        }

        public int asInt() {
            return this.value;
        }

        public static String getModuleModifiers(int flag) {
            return Modifier.asString(flag, false, ACC_TRANSITIVE);
        }

        public static String getModuleFlags(int flag) {
            return Modifier.asString(flag, true, ACC_TRANSITIVE);
        }

        public static String getStatementModifiers(int flag) {
            return Modifier.asString(flag, false, ACC_OPEN);
        }

        public static String getStatementFlags(int flag) {
            return Modifier.asString(flag, true, ACC_OPEN);
        }

        private static String asString(int value, boolean flagFormat, Modifier skipped) {
            String buf = "";
            for (Modifier m : Modifier.values()) {
                if (m == skipped || (value & m.value) == 0) continue;
                buf = buf + (flagFormat ? m.flag : m.keyword) + " ";
                value ^= m.value;
            }
            if (flagFormat && value != 0) {
                buf = buf + String.format("0x%04X ", value);
            }
            return buf;
        }
    }
}

