/*
 * Decompiled with CFR 0.152.
 */
package com.sun.demo.scripting.jconsole;

import com.sun.demo.scripting.jconsole.ScriptShellPanel;
import com.sun.tools.jconsole.JConsolePlugin;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.swing.JPanel;
import javax.swing.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptJConsolePlugin
extends JConsolePlugin
implements ScriptShellPanel.CommandProcessor {
    private volatile ScriptShellPanel window;
    private Map<String, JPanel> tabs;
    private volatile ScriptEngine engine;
    private CountDownLatch engineReady = new CountDownLatch(1);
    private String extension;
    private volatile String prompt;
    private static final String LANGUAGE_KEY = "com.sun.demo.jconsole.console.language";

    @Override
    public Map<String, JPanel> getTabs() {
        this.createScriptEngine();
        this.window = new ScriptShellPanel(this);
        this.tabs = new HashMap<String, JPanel>();
        this.tabs.put("Script Shell", this.window);
        new Thread(new Runnable(){

            public void run() {
                ScriptJConsolePlugin.this.initScriptEngine();
                ScriptJConsolePlugin.this.engineReady.countDown();
            }
        }).start();
        return this.tabs;
    }

    @Override
    public SwingWorker<?, ?> newSwingWorker() {
        return null;
    }

    @Override
    public void dispose() {
        this.window.dispose();
    }

    @Override
    public String getPrompt() {
        return this.prompt;
    }

    @Override
    public String executeCommand(String cmd) {
        String res;
        try {
            this.engineReady.await();
            Object tmp = this.engine.eval(cmd);
            res = tmp == null ? null : tmp.toString();
        }
        catch (InterruptedException ie) {
            res = ie.getMessage();
        }
        catch (ScriptException se) {
            res = se.getMessage();
        }
        return res;
    }

    private void createScriptEngine() {
        ScriptEngineManager manager = new ScriptEngineManager();
        String language = this.getScriptLanguage();
        this.engine = manager.getEngineByName(language);
        if (this.engine == null) {
            throw new RuntimeException("cannot load " + language + " engine");
        }
        this.extension = this.engine.getFactory().getExtensions().get(0);
        this.prompt = this.extension + ">";
        this.engine.setBindings(this.createBindings(), 100);
    }

    private String getScriptLanguage() {
        String lang = System.getProperty(LANGUAGE_KEY);
        if (lang == null) {
            lang = "JavaScript";
        }
        return lang;
    }

    private Bindings createBindings() {
        Map<String, Object> map = Collections.synchronizedMap(new HashMap());
        return new SimpleBindings(map);
    }

    private void initScriptEngine() {
        this.setGlobals();
        this.loadInitFile();
        this.loadUserInitFile();
    }

    private void setGlobals() {
        this.engine.put("engine", this.engine);
        this.engine.put("window", this.window);
        this.engine.put("plugin", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadInitFile() {
        String oldFilename = (String)this.engine.get("javax.script.filename");
        this.engine.put("javax.script.filename", "<built-in jconsole." + this.extension + ">");
        try {
            Class<?> myClass = this.getClass();
            InputStream stream = myClass.getResourceAsStream("/resources/jconsole." + this.extension);
            if (stream != null) {
                this.engine.eval(new InputStreamReader(new BufferedInputStream(stream)));
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        finally {
            this.engine.put("javax.script.filename", oldFilename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUserInitFile() {
        String oldFilename = (String)this.engine.get("javax.script.filename");
        String home = System.getProperty("user.home");
        if (home == null) {
            return;
        }
        String fileName = home + File.separator + "jconsole." + this.extension;
        if (!new File(fileName).exists()) {
            return;
        }
        this.engine.put("javax.script.filename", fileName);
        try {
            this.engine.eval(new FileReader(fileName));
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        finally {
            this.engine.put("javax.script.filename", oldFilename);
        }
    }
}

