/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.util.Random;
import javax.swing.tree.DefaultMutableTreeNode;

public class DynamicTreeNode
extends DefaultMutableTreeNode {
    protected static float nameCount;
    protected static String[] names;
    protected static Font[] fonts;
    protected static Random nameGen;
    protected static final int DefaultChildrenCount = 7;
    protected boolean hasLoaded;

    public DynamicTreeNode(Object o) {
        super(o);
    }

    public boolean isLeaf() {
        return false;
    }

    public int getChildCount() {
        if (!this.hasLoaded) {
            this.loadChildren();
        }
        return super.getChildCount();
    }

    protected void loadChildren() {
        for (int counter = 0; counter < 7; ++counter) {
            int randomIndex = (int)(nameGen.nextFloat() * nameCount);
            Font font = fonts != null ? fonts[randomIndex] : null;
            SampleData data = counter % 2 == 0 ? new SampleData(font, Color.red, names[randomIndex]) : new SampleData(font, Color.blue, names[randomIndex]);
            DynamicTreeNode newNode = new DynamicTreeNode(data);
            this.insert(newNode, counter);
        }
        this.hasLoaded = true;
    }

    static {
        String[] fontNames;
        try {
            fontNames = Toolkit.getDefaultToolkit().getFontList();
        }
        catch (Exception e) {
            fontNames = null;
        }
        if (fontNames == null || fontNames.length == 0) {
            names = new String[]{"Mark Andrews", "Tom Ball", "Alan Chung", "Rob Davis", "Jeff Dinkins", "Amy Fowler", "James Gosling", "David Karlton", "Dave Kloba", "Dave Moore", "Hans Muller", "Rick Levenson", "Tim Prinzing", "Chester Rose", "Ray Ryan", "Georges Saab", "Scott Violet", "Kathy Walrath", "Arnaud Weber"};
        } else {
            int fontSize = 12;
            names = fontNames;
            fonts = new Font[names.length];
            int maxCounter = names.length;
            for (int counter = 0; counter < maxCounter; ++counter) {
                try {
                    DynamicTreeNode.fonts[counter] = new Font(fontNames[counter], 0, fontSize);
                }
                catch (Exception e) {
                    DynamicTreeNode.fonts[counter] = null;
                }
                fontSize = (fontSize + 2 - 12) % 12 + 12;
            }
        }
        nameCount = names.length;
        nameGen = new Random(System.currentTimeMillis());
    }
}

