/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.security.cert.X509Certificate;
import javax.swing.JDialog;
import javax.swing.UIManager;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.security.AccessWarningPane;
import net.sourceforge.jnlp.security.AppletWarningPane;
import net.sourceforge.jnlp.security.CertVerifier;
import net.sourceforge.jnlp.security.CertWarningPane;
import net.sourceforge.jnlp.security.CertsInfoPane;
import net.sourceforge.jnlp.security.MoreInfoPane;
import net.sourceforge.jnlp.security.NotAllSignedWarningPane;
import net.sourceforge.jnlp.security.SecurityDialogPanel;
import net.sourceforge.jnlp.security.SingleCertInfoPane;

public class SecurityWarningDialog
extends JDialog {
    private DialogType dialogType;
    private AccessType accessType;
    private SecurityDialogPanel panel;
    private JNLPFile file;
    private CertVerifier certVerifier;
    private X509Certificate cert;
    private Object[] extras;
    private boolean initialized = false;
    private Object value;

    public SecurityWarningDialog(DialogType dialogType, AccessType accessType, JNLPFile file) {
        this.dialogType = dialogType;
        this.accessType = accessType;
        this.file = file;
        this.certVerifier = null;
        this.initialized = true;
        this.initDialog();
    }

    public SecurityWarningDialog(DialogType dialogType, AccessType accessType, JNLPFile file, CertVerifier jarSigner) {
        this.dialogType = dialogType;
        this.accessType = accessType;
        this.file = file;
        this.certVerifier = jarSigner;
        this.initialized = true;
        this.initDialog();
    }

    public SecurityWarningDialog(DialogType dialogType, AccessType accessType, CertVerifier certVerifier) {
        this.dialogType = dialogType;
        this.accessType = accessType;
        this.file = null;
        this.certVerifier = certVerifier;
        this.initialized = true;
        this.initDialog();
    }

    public SecurityWarningDialog(DialogType dialogType, AccessType accessType, JNLPFile file, Object[] extras) {
        this.dialogType = dialogType;
        this.accessType = accessType;
        this.file = file;
        this.certVerifier = null;
        this.initialized = true;
        this.extras = extras;
        this.initDialog();
    }

    public SecurityWarningDialog(DialogType dialogType, X509Certificate c) {
        this.dialogType = dialogType;
        this.accessType = null;
        this.file = null;
        this.certVerifier = null;
        this.cert = c;
        this.initialized = true;
        this.initDialog();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public static boolean showAccessWarningDialog(AccessType accessType, JNLPFile file) {
        return SecurityWarningDialog.showAccessWarningDialog(accessType, file, null);
    }

    public static boolean showAccessWarningDialog(AccessType accessType, JNLPFile file, Object[] extras) {
        SecurityWarningDialog dialog = new SecurityWarningDialog(DialogType.ACCESS_WARNING, accessType, file, extras);
        dialog.setVisible(true);
        dialog.dispose();
        Object selectedValue = dialog.getValue();
        if (selectedValue == null) {
            return false;
        }
        if (selectedValue instanceof Integer) {
            return (Integer)selectedValue == 0;
        }
        return false;
    }

    public static boolean showNotAllSignedWarningDialog(JNLPFile file) {
        SecurityWarningDialog dialog = new SecurityWarningDialog(DialogType.NOTALLSIGNED_WARNING, AccessType.NOTALLSIGNED, file, new Object[0]);
        dialog.setVisible(true);
        dialog.dispose();
        Object selectedValue = dialog.getValue();
        if (selectedValue == null) {
            return false;
        }
        if (selectedValue instanceof Integer) {
            return (Integer)selectedValue == 0;
        }
        return false;
    }

    public static boolean showCertWarningDialog(AccessType accessType, JNLPFile file, CertVerifier jarSigner) {
        SecurityWarningDialog dialog = new SecurityWarningDialog(DialogType.CERT_WARNING, accessType, file, jarSigner);
        dialog.setVisible(true);
        dialog.dispose();
        Object selectedValue = dialog.getValue();
        if (selectedValue == null) {
            return false;
        }
        if (selectedValue instanceof Integer) {
            return (Integer)selectedValue == 0;
        }
        return false;
    }

    public static void showMoreInfoDialog(CertVerifier jarSigner, SecurityWarningDialog parent) {
        SecurityWarningDialog dialog = new SecurityWarningDialog(DialogType.MORE_INFO, null, null, jarSigner);
        dialog.setVisible(true);
        dialog.dispose();
    }

    public static void showCertInfoDialog(CertVerifier jarSigner, SecurityWarningDialog parent) {
        SecurityWarningDialog dialog = new SecurityWarningDialog(DialogType.CERT_INFO, null, null, jarSigner);
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        dialog.dispose();
    }

    public static void showSingleCertInfoDialog(X509Certificate c, JDialog parent) {
        SecurityWarningDialog dialog = new SecurityWarningDialog(DialogType.SINGLE_CERT_INFO, c);
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        dialog.dispose();
    }

    public static int showAppletWarning() {
        SecurityWarningDialog dialog = new SecurityWarningDialog(DialogType.APPLET_WARNING, null, null, (CertVerifier)null);
        dialog.setVisible(true);
        dialog.dispose();
        Object selectedValue = dialog.getValue();
        if (selectedValue == null) {
            return 2;
        }
        if (selectedValue instanceof Integer) {
            return (Integer)selectedValue;
        }
        return 2;
    }

    private void initDialog() {
        this.setSystemLookAndFeel();
        String dialogTitle = "";
        if (this.dialogType == DialogType.CERT_WARNING) {
            dialogTitle = "Warning - Security";
        } else if (this.dialogType == DialogType.MORE_INFO) {
            dialogTitle = "More Information";
        } else if (this.dialogType == DialogType.CERT_INFO) {
            dialogTitle = "Details - Certificate";
        } else if (this.dialogType == DialogType.ACCESS_WARNING) {
            dialogTitle = "Security Warning";
        } else if (this.dialogType == DialogType.APPLET_WARNING) {
            dialogTitle = "Applet Warning";
        } else if (this.dialogType == DialogType.NOTALLSIGNED_WARNING) {
            dialogTitle = "Security Warning";
        }
        this.setTitle(dialogTitle);
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.installPanel();
        this.pack();
        WindowAdapter adapter = new WindowAdapter(){
            private boolean gotFocus = false;

            @Override
            public void windowClosing(WindowEvent we) {
                SecurityWarningDialog.this.setValue(null);
            }

            @Override
            public void windowGainedFocus(WindowEvent we) {
                if (!this.gotFocus) {
                    SecurityWarningDialog.this.selectDefaultButton();
                    this.gotFocus = true;
                }
            }

            @Override
            public void windowOpened(WindowEvent e) {
                if (e.getSource() instanceof SecurityWarningDialog) {
                    SecurityWarningDialog dialog = (SecurityWarningDialog)e.getSource();
                    dialog.setResizable(true);
                    SecurityWarningDialog.centerDialog(dialog);
                    dialog.setValue(null);
                }
            }
        };
        this.addWindowListener(adapter);
        this.addWindowFocusListener(adapter);
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    public JNLPFile getFile() {
        return this.file;
    }

    public CertVerifier getJarSigner() {
        return this.certVerifier;
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    private void installPanel() {
        if (this.dialogType == DialogType.CERT_WARNING) {
            this.panel = new CertWarningPane(this, this.certVerifier);
        } else if (this.dialogType == DialogType.MORE_INFO) {
            this.panel = new MoreInfoPane(this, this.certVerifier);
        } else if (this.dialogType == DialogType.CERT_INFO) {
            this.panel = new CertsInfoPane(this, this.certVerifier);
        } else if (this.dialogType == DialogType.SINGLE_CERT_INFO) {
            this.panel = new SingleCertInfoPane(this, this.certVerifier);
        } else if (this.dialogType == DialogType.ACCESS_WARNING) {
            this.panel = new AccessWarningPane(this, this.extras, this.certVerifier);
        } else if (this.dialogType == DialogType.APPLET_WARNING) {
            this.panel = new AppletWarningPane(this, this.certVerifier);
        } else if (this.dialogType == DialogType.NOTALLSIGNED_WARNING) {
            this.panel = new NotAllSignedWarningPane(this);
        }
        this.add((Component)this.panel, "Center");
    }

    private static void centerDialog(JDialog dialog) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = dialog.getSize();
        dialog.setLocation((screen.width - dialogSize.width) / 2, (screen.height - dialogSize.height) / 2);
    }

    private void selectDefaultButton() {
        if (this.panel == null) {
            System.out.println("initial value panel is null");
        }
        this.panel.requestFocusOnDefaultButton();
    }

    protected void setValue(Object value) {
        if (JNLPRuntime.isDebug()) {
            System.out.println("Setting value:" + value);
        }
        this.value = value;
    }

    protected Object getValue() {
        if (JNLPRuntime.isDebug()) {
            System.out.println("Returning value:" + this.value);
        }
        return this.value;
    }

    protected void setSystemLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static enum AccessType {
        READ_FILE,
        WRITE_FILE,
        CREATE_DESTKOP_SHORTCUT,
        CLIPBOARD_READ,
        CLIPBOARD_WRITE,
        PRINTER,
        NETWORK,
        VERIFIED,
        UNVERIFIED,
        NOTALLSIGNED,
        SIGNING_ERROR;

    }

    public static enum DialogType {
        CERT_WARNING,
        MORE_INFO,
        CERT_INFO,
        SINGLE_CERT_INFO,
        ACCESS_WARNING,
        NOTALLSIGNED_WARNING,
        APPLET_WARNING;

    }
}

