/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.awt.Frame;
import java.awt.Window;
import java.lang.ref.WeakReference;
import java.net.SocketPermission;
import java.security.AccessControlException;
import java.security.AllPermission;
import java.security.Permission;
import java.security.SecurityPermission;
import javax.swing.JWindow;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.security.SecurityWarningDialog;
import net.sourceforge.jnlp.services.ServiceUtil;
import net.sourceforge.jnlp.util.WeakList;

class JNLPSecurityManager
extends SecurityManager {
    private Object exitClass = null;
    private SecurityException closeAppEx = new SecurityException(JNLPRuntime.getMessage("RShutdown"));
    private WeakList weakWindows = new WeakList();
    private WeakList weakApplications = new WeakList();
    private WeakReference activeApplication = null;
    private boolean exitAllowed = true;

    private static String R(String key) {
        return JNLPRuntime.getMessage(key);
    }

    JNLPSecurityManager() {
        if (!JNLPRuntime.isHeadless()) {
            new JWindow().getOwner();
        }
    }

    public boolean isExitClass() {
        return this.isExitClass(this.getClassContext());
    }

    private boolean isExitClass(Class[] stack) {
        if (this.exitClass == null) {
            return true;
        }
        for (int i = 0; i < stack.length; ++i) {
            if (stack[i] != this.exitClass) continue;
            return true;
        }
        return false;
    }

    public void setExitClass(Class exitClass) throws IllegalStateException {
        if (this.exitClass != null) {
            throw new IllegalStateException(JNLPSecurityManager.R("RExitTaken"));
        }
        this.exitClass = exitClass;
    }

    protected ApplicationInstance getApplication() {
        return this.getApplication(this.getClassContext(), 0);
    }

    protected ApplicationInstance getApplication(Window window) {
        int i = this.weakWindows.size();
        while (i-- > 0) {
            Window w = (Window)this.weakWindows.get(i);
            if (w == null) {
                this.weakWindows.remove(i);
                this.weakApplications.remove(i);
            }
            if (w != window) continue;
            return (ApplicationInstance)this.weakApplications.get(i);
        }
        return null;
    }

    protected ApplicationInstance getApplication(Class[] stack, int maxDepth) {
        if (maxDepth <= 0) {
            maxDepth = stack.length;
        }
        for (int i = 0; i < stack.length && i < maxDepth; ++i) {
            JNLPClassLoader loader;
            if (!(stack[i].getClassLoader() instanceof JNLPClassLoader) || (loader = (JNLPClassLoader)stack[i].getClassLoader()) == null || loader.getApplication() == null) continue;
            return loader.getApplication();
        }
        return null;
    }

    @Override
    public ThreadGroup getThreadGroup() {
        ApplicationInstance app = this.getApplication();
        if (app == null) {
            return super.getThreadGroup();
        }
        return app.getThreadGroup();
    }

    @Override
    public void checkPermission(Permission perm) {
        block21: {
            String name = perm.getName();
            if (!JNLPRuntime.isWebstartApplication() && ("setPolicy".equals(name) || "setSecurityManager".equals(name))) {
                throw new SecurityException(JNLPSecurityManager.R("RCantReplaceSM"));
            }
            try {
                try {
                    super.checkPermission(perm);
                }
                catch (SecurityException se) {
                    if (JNLPRuntime.isDebug()) {
                        System.err.println("Requesting permission: " + perm.toString());
                    }
                    Permission tmpPerm = null;
                    if (perm instanceof SocketPermission) {
                        String[] hostComponents;
                        int length;
                        tmpPerm = new SocketPermission(perm.getName(), "connect,accept");
                        ApplicationInstance app = this.getApplication();
                        JNLPFile file = app.getJNLPFile();
                        String srcHost = file.getSourceLocation().getAuthority();
                        String destHost = name;
                        if (destHost.indexOf(58) >= 0) {
                            destHost = destHost.substring(0, destHost.indexOf(58));
                        }
                        if ((length = (hostComponents = destHost.split("\\.")).length) >= 2) {
                            destHost = hostComponents[length - 2] + "." + hostComponents[length - 1];
                            boolean isDestHostName = false;
                            try {
                                Integer.parseInt(hostComponents[length - 1]);
                            }
                            catch (NumberFormatException e) {
                                isDestHostName = true;
                            }
                            if (isDestHostName && srcHost.endsWith(destHost)) {
                                this.addPermission(tmpPerm);
                                return;
                            }
                        }
                    } else if (perm instanceof SecurityPermission) {
                        if (perm.equals(new SecurityPermission("putProviderProperty.SunJCE")) && this.inTrustedCallChain("com.sun.crypto.provider.SunJCE", "run")) {
                            return;
                        }
                    } else if (perm instanceof RuntimePermission) {
                        if (perm.equals(new SecurityPermission("accessClassInPackage.sun.security.internal.spec")) && this.inTrustedCallChain("javax.crypto.KeyGenerator", "init")) {
                            return;
                        }
                    } else {
                        tmpPerm = perm;
                    }
                    if (tmpPerm == null) break block21;
                    if (this.askPermission(tmpPerm)) {
                        this.addPermission(tmpPerm);
                        break block21;
                    }
                    throw se;
                }
            }
            catch (SecurityException ex) {
                if (JNLPRuntime.isDebug()) {
                    System.out.println("Denying permission: " + perm);
                }
                throw ex;
            }
        }
    }

    private boolean inTrustedCallChain(String className, String methodName) {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        for (int i = 0; i < stack.length; ++i) {
            if (!stack[i].getClass().getProtectionDomain().implies(new AllPermission())) {
                return false;
            }
            if (!stack[i].getClassName().equals(className) || !stack[i].getMethodName().equals(methodName)) continue;
            return true;
        }
        return false;
    }

    private boolean askPermission(Permission perm) {
        ApplicationInstance app = this.getApplication();
        return app != null && !app.isSigned() && perm instanceof SocketPermission && ServiceUtil.checkAccess(SecurityWarningDialog.AccessType.NETWORK, perm.getName());
    }

    private void addPermission(Permission perm) {
        if (JNLPRuntime.getApplication().getClassLoader() instanceof JNLPClassLoader) {
            JNLPClassLoader cl = (JNLPClassLoader)JNLPRuntime.getApplication().getClassLoader();
            cl.addPermission(perm);
            if (JNLPRuntime.isDebug()) {
                if (cl.getPermissions(null).implies(perm)) {
                    System.err.println("Added permission: " + perm.toString());
                } else {
                    System.err.println("Unable to add permission: " + perm.toString());
                }
            }
        } else if (JNLPRuntime.isDebug()) {
            System.err.println("Unable to add permission: " + perm + ", classloader not JNLP.");
        }
    }

    public boolean checkTopLevelWindow(Object window) {
        Window w;
        ApplicationInstance app = this.getApplication();
        if (app != null && window instanceof Window) {
            w = (Window)window;
            if (JNLPRuntime.isDebug()) {
                System.err.println("SM: app: " + app.getTitle() + " is adding a window: " + window);
            }
            this.weakWindows.add(window);
            this.weakApplications.add(app);
            app.addWindow(w);
        }
        if (window instanceof Window) {
            for (w = (Window)window; w != null; w = w.getOwner()) {
                if (!(window instanceof Frame)) continue;
                ((Frame)window).setIconImage(JNLPRuntime.getWindowIcon());
            }
        }
        return super.checkTopLevelWindow(window);
    }

    @Override
    public void checkExit(int status) {
        boolean realCall;
        Class[] stack = this.getClassContext();
        if (!this.exitAllowed) {
            for (int i = 0; i < stack.length; ++i) {
                if (stack[i].getClassLoader() == null) continue;
                throw new AccessControlException("Applets may not call System.exit()");
            }
        }
        super.checkExit(status);
        boolean bl = realCall = stack[1] == Runtime.class;
        if (this.isExitClass(stack)) {
            return;
        }
        if (!realCall) {
            super.checkExit(status);
            return;
        }
        ApplicationInstance app = this.getApplication(stack, 0);
        if (app == null) {
            if (this.activeApplication != null) {
                app = (ApplicationInstance)this.activeApplication.get();
            }
            if (app == null) {
                throw new SecurityException(JNLPSecurityManager.R("RExitNoApp"));
            }
        }
        app.destroy();
        throw this.closeAppEx;
    }

    protected void disableExit() {
        this.exitAllowed = false;
    }
}

