/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import net.sourceforge.jnlp.AppletDesc;
import net.sourceforge.jnlp.ApplicationDesc;
import net.sourceforge.jnlp.AssociationDesc;
import net.sourceforge.jnlp.ComponentDesc;
import net.sourceforge.jnlp.ExtensionDesc;
import net.sourceforge.jnlp.IconDesc;
import net.sourceforge.jnlp.InformationDesc;
import net.sourceforge.jnlp.InstallerDesc;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.JREDesc;
import net.sourceforge.jnlp.MenuDesc;
import net.sourceforge.jnlp.Node;
import net.sourceforge.jnlp.PackageDesc;
import net.sourceforge.jnlp.ParseException;
import net.sourceforge.jnlp.PropertyDesc;
import net.sourceforge.jnlp.RelatedContentDesc;
import net.sourceforge.jnlp.ResourcesDesc;
import net.sourceforge.jnlp.SecurityDesc;
import net.sourceforge.jnlp.ShortcutDesc;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.nanoxml.XMLElement;

class Parser {
    private static Version supportedVersions = new Version("1.0 1.5 1.6 6.0");
    private JNLPFile file;
    private Node root;
    private Version spec;
    private URL base;
    private URL codebase;
    private URL fileLocation;
    private boolean strict;
    private boolean allowExtensions;

    private static String R(String key) {
        return JNLPRuntime.getMessage(key);
    }

    private static String R(String key, Object p1) {
        return Parser.R(key, p1, null);
    }

    private static String R(String key, Object p1, Object p2) {
        return Parser.R(key, p1, p2, null);
    }

    private static String R(String key, Object p1, Object p2, Object p3) {
        return JNLPRuntime.getMessage(key, new Object[]{p1, p2, p3});
    }

    public Parser(JNLPFile file, URL base, Node root, boolean strict, boolean allowExtensions) throws ParseException {
        this.file = file;
        this.root = root;
        this.strict = strict;
        this.allowExtensions = allowExtensions;
        if (root == null || !root.getNodeName().equals("jnlp")) {
            throw new ParseException(Parser.R("PInvalidRoot"));
        }
        this.spec = this.getVersion(root, "spec", "1.0+");
        this.codebase = this.addSlash(this.getURL(root, "codebase", base));
        this.base = this.codebase != null ? this.codebase : base;
        this.fileLocation = this.getURL(root, "href", this.base);
        if (!supportedVersions.matchesAny(this.spec)) {
            throw new ParseException(Parser.R("PSpecUnsupported", supportedVersions));
        }
        root.normalize();
    }

    public static Version getSupportedVersions() {
        return supportedVersions;
    }

    public Version getFileVersion() {
        return this.getVersion(this.root, "version", null);
    }

    public URL getFileLocation() {
        return this.fileLocation;
    }

    public URL getCodeBase() {
        return this.codebase;
    }

    public Version getSpecVersion() {
        return this.spec;
    }

    public List getResources(Node parent, boolean j2se) throws ParseException {
        ArrayList<ResourcesDesc> result = new ArrayList<ResourcesDesc>();
        Node[] resources = Parser.getChildNodes(parent, "resources");
        if (resources.length == 0 && !j2se) {
            throw new ParseException(Parser.R("PNoResources"));
        }
        for (int i = 0; i < resources.length; ++i) {
            result.add(this.getResourcesDesc(resources[i], j2se));
        }
        return result;
    }

    public ResourcesDesc getResourcesDesc(Node node, boolean j2se) throws ParseException {
        boolean mainFlag = false;
        ResourcesDesc resources = new ResourcesDesc(this.file, this.getLocales(node), this.splitString(this.getAttribute(node, "os", null)), this.splitString(this.getAttribute(node, "arch", null)));
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String name = child.getNodeName();
            if ("nativelib".equals(name) && !this.isTrustedEnvironment()) {
                throw new ParseException(Parser.R("PUntrustedNative"));
            }
            if ("j2se".equals(name) || "java".equals(name)) {
                if (Parser.getChildNode(this.root, "component-desc") != null && this.strict) {
                    throw new ParseException(Parser.R("PExtensionHasJ2SE"));
                }
                if (!j2se) {
                    resources.addResource(this.getJRE(child));
                } else {
                    throw new ParseException(Parser.R("PInnerJ2SE"));
                }
            }
            if ("jar".equals(name) || "nativelib".equals(name)) {
                JARDesc jar = this.getJAR(child);
                if (jar.isMain()) {
                    if (mainFlag && this.strict) {
                        throw new ParseException(Parser.R("PTwoMains"));
                    }
                    mainFlag = true;
                }
                resources.addResource(jar);
            }
            if ("extension".equals(name)) {
                resources.addResource(this.getExtension(child));
            }
            if ("property".equals(name)) {
                resources.addResource(this.getProperty(child));
            }
            if (!"package".equals(name)) continue;
            resources.addResource(this.getPackage(child));
        }
        return resources;
    }

    public JREDesc getJRE(Node node) throws ParseException {
        Version version = this.getVersion(node, "version", null);
        URL location = this.getURL(node, "href", this.base);
        String vmArgs = this.getAttribute(node, "java-vm-args", null);
        try {
            this.checkVMArgs(vmArgs);
        }
        catch (IllegalArgumentException argumentException) {
            vmArgs = null;
        }
        String initialHeap = this.getAttribute(node, "initial-heap-size", null);
        String maxHeap = this.getAttribute(node, "max-heap-size", null);
        List resources = this.getResources(node, true);
        this.getRequiredAttribute(node, "version", null);
        return new JREDesc(version, location, vmArgs, initialHeap, maxHeap, resources);
    }

    public JARDesc getJAR(Node node) throws ParseException {
        boolean nativeJar = "nativelib".equals(node.getNodeName());
        URL location = this.getRequiredURL(node, "href", this.base);
        Version version = this.getVersion(node, "version", null);
        String part = this.getAttribute(node, "part", null);
        boolean main = "true".equals(this.getAttribute(node, "main", "false"));
        boolean lazy = "lazy".equals(this.getAttribute(node, "download", "eager"));
        int size = Integer.parseInt(this.getAttribute(node, "size", "0"));
        if (nativeJar && main && this.strict) {
            throw new ParseException(Parser.R("PNativeHasMain"));
        }
        return new JARDesc(location, version, part, lazy, main, nativeJar, true);
    }

    public ExtensionDesc getExtension(Node node) throws ParseException {
        String name = this.getAttribute(node, "name", null);
        Version version = this.getVersion(node, "version", null);
        URL location = this.getRequiredURL(node, "href", this.base);
        ExtensionDesc ext = new ExtensionDesc(name, version, location);
        Node[] dload = Parser.getChildNodes(node, "ext-download");
        for (int i = 0; i < dload.length; ++i) {
            boolean lazy = "lazy".equals(this.getAttribute(dload[i], "download", "eager"));
            ext.addPart(this.getRequiredAttribute(dload[i], "ext-part", null), this.getAttribute(dload[i], "part", null), lazy);
        }
        return ext;
    }

    public PropertyDesc getProperty(Node node) throws ParseException {
        String name = this.getRequiredAttribute(node, "name", null);
        String value = this.getRequiredAttribute(node, "value", "");
        return new PropertyDesc(name, value);
    }

    public PackageDesc getPackage(Node node) throws ParseException {
        String name = this.getRequiredAttribute(node, "name", null);
        String part = this.getRequiredAttribute(node, "part", "");
        boolean recursive = this.getAttribute(node, "recursive", "false").equals("true");
        return new PackageDesc(name, part, recursive);
    }

    public List getInfo(Node parent) throws ParseException {
        ArrayList<InformationDesc> result = new ArrayList<InformationDesc>();
        Node[] info = Parser.getChildNodes(parent, "information");
        if (info.length == 0) {
            throw new ParseException(Parser.R("PNoInfoElement"));
        }
        for (int i = 0; i < info.length; ++i) {
            result.add(this.getInformationDesc(info[i]));
        }
        return result;
    }

    public InformationDesc getInformationDesc(Node node) throws ParseException {
        ArrayList<String> descriptionsUsed = new ArrayList<String>();
        Locale[] locales = this.getLocales(node);
        InformationDesc info = new InformationDesc(this.file, locales);
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String name = child.getNodeName();
            if ("title".equals(name)) {
                this.addInfo(info, child, null, this.getSpanText(child));
            }
            if ("vendor".equals(name)) {
                this.addInfo(info, child, null, this.getSpanText(child));
            }
            if ("description".equals(name)) {
                String kind = this.getAttribute(child, "kind", "default");
                if (descriptionsUsed.contains(kind) && this.strict) {
                    throw new ParseException(Parser.R("PTwoDescriptions", kind));
                }
                descriptionsUsed.add(kind);
                this.addInfo(info, child, kind, this.getSpanText(child));
            }
            if ("homepage".equals(name)) {
                this.addInfo(info, child, null, this.getRequiredURL(child, "href", this.base));
            }
            if ("icon".equals(name)) {
                this.addInfo(info, child, this.getAttribute(child, "kind", "default"), this.getIcon(child));
            }
            if ("offline-allowed".equals(name)) {
                this.addInfo(info, child, null, Boolean.TRUE);
            }
            if ("sharing-allowed".equals(name)) {
                if (this.strict && !this.allowExtensions) {
                    throw new ParseException(Parser.R("PSharing"));
                }
                this.addInfo(info, child, null, Boolean.TRUE);
            }
            if ("association".equals(name)) {
                this.addInfo(info, child, null, this.getAssociation(child));
            }
            if ("shortcut".equals(name)) {
                this.addInfo(info, child, null, this.getShortcut(child));
            }
            if (!"related-content".equals(name)) continue;
            this.addInfo(info, child, null, this.getRelatedContent(child));
        }
        return info;
    }

    protected void addInfo(InformationDesc info, Node node, String mod, Object value) {
        String modStr;
        String string = modStr = mod == null ? "" : "-" + mod;
        if (node == null) {
            return;
        }
        info.addItem(node.getNodeName() + modStr, value);
    }

    public IconDesc getIcon(Node node) throws ParseException {
        int width = Integer.parseInt(this.getAttribute(node, "width", "-1"));
        int height = Integer.parseInt(this.getAttribute(node, "height", "-1"));
        int size = Integer.parseInt(this.getAttribute(node, "size", "-1"));
        int depth = Integer.parseInt(this.getAttribute(node, "depth", "-1"));
        URL location = this.getRequiredURL(node, "href", this.base);
        String kind = this.getAttribute(node, "kind", "default");
        return new IconDesc(location, kind, width, height, depth, size);
    }

    public SecurityDesc getSecurity(Node parent) throws ParseException {
        Node[] nodes = Parser.getChildNodes(parent, "security");
        if (nodes.length > 1 && this.strict) {
            throw new ParseException(Parser.R("PTwoSecurity"));
        }
        Object type = SecurityDesc.SANDBOX_PERMISSIONS;
        if (nodes.length == 0) {
            type = SecurityDesc.SANDBOX_PERMISSIONS;
        } else if (null != Parser.getChildNode(nodes[0], "all-permissions")) {
            type = SecurityDesc.ALL_PERMISSIONS;
        } else if (null != Parser.getChildNode(nodes[0], "j2ee-application-client-permissions")) {
            type = SecurityDesc.J2EE_PERMISSIONS;
        } else if (this.strict) {
            throw new ParseException(Parser.R("PEmptySecurity"));
        }
        if (this.base != null) {
            return new SecurityDesc(this.file, type, this.base.getHost());
        }
        return new SecurityDesc(this.file, type, null);
    }

    protected boolean isTrustedEnvironment() {
        Node security = Parser.getChildNode(this.root, "security");
        return security != null && (Parser.getChildNode(security, "all-permissions") != null || Parser.getChildNode(security, "j2ee-application-client-permissions") != null);
    }

    public Object getLauncher(Node parent) throws ParseException {
        if (1 != Parser.getChildNodes(parent, "applet-desc").length + Parser.getChildNodes(parent, "application-desc").length + Parser.getChildNodes(parent, "component-desc").length + Parser.getChildNodes(parent, "installer-desc").length) {
            throw new ParseException(Parser.R("PTwoDescriptors"));
        }
        for (Node child = parent.getFirstChild(); child != null; child = child.getNextSibling()) {
            String name = child.getNodeName();
            if ("applet-desc".equals(name)) {
                return this.getApplet(child);
            }
            if ("application-desc".equals(name)) {
                return this.getApplication(child);
            }
            if ("component-desc".equals(name)) {
                return this.getComponent(child);
            }
            if (!"installer-desc".equals(name)) continue;
            return this.getInstaller(child);
        }
        return null;
    }

    public AppletDesc getApplet(Node node) throws ParseException {
        String name = this.getRequiredAttribute(node, "name", Parser.R("PUnknownApplet"));
        String main = this.getRequiredAttribute(node, "main-class", null);
        URL docbase = this.getURL(node, "documentbase", this.base);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        int width = 0;
        int height = 0;
        try {
            width = Integer.parseInt(this.getRequiredAttribute(node, "width", "100"));
            height = Integer.parseInt(this.getRequiredAttribute(node, "height", "100"));
        }
        catch (NumberFormatException nfe) {
            if (width <= 0) {
                throw new ParseException(Parser.R("PBadWidth"));
            }
            throw new ParseException(Parser.R("PBadWidth"));
        }
        Node[] params = Parser.getChildNodes(node, "param");
        for (int i = 0; i < params.length; ++i) {
            paramMap.put(this.getRequiredAttribute(params[i], "name", null), this.getRequiredAttribute(params[i], "value", ""));
        }
        return new AppletDesc(name, main, docbase, width, height, paramMap);
    }

    public ApplicationDesc getApplication(Node node) throws ParseException {
        String main = this.getAttribute(node, "main-class", null);
        ArrayList<String> argsList = new ArrayList<String>();
        Node[] args = Parser.getChildNodes(node, "argument");
        for (int i = 0; i < args.length; ++i) {
            argsList.add(this.getSpanText(args[i]));
        }
        String[] argStrings = argsList.toArray(new String[argsList.size()]);
        return new ApplicationDesc(main, argStrings);
    }

    public ComponentDesc getComponent(Node node) {
        return new ComponentDesc();
    }

    public InstallerDesc getInstaller(Node node) {
        String main = this.getAttribute(node, "main-class", null);
        return new InstallerDesc(main);
    }

    public AssociationDesc getAssociation(Node node) throws ParseException {
        String[] extensions = this.getRequiredAttribute(node, "extensions", null).split(" ");
        String mimeType = this.getRequiredAttribute(node, "mime-type", null);
        return new AssociationDesc(mimeType, extensions);
    }

    public ShortcutDesc getShortcut(Node node) throws ParseException {
        String online = this.getAttribute(node, "online", "true");
        boolean shortcutIsOnline = Boolean.valueOf(online);
        boolean showOnDesktop = false;
        MenuDesc menu = null;
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String name = child.getNodeName();
            if ("desktop".equals(name)) {
                if (showOnDesktop && this.strict) {
                    throw new ParseException(Parser.R("PTwoDesktops"));
                }
                showOnDesktop = true;
                continue;
            }
            if (!"menu".equals(name)) continue;
            if (menu != null && this.strict) {
                throw new ParseException(Parser.R("PTwoMenus"));
            }
            menu = this.getMenu(child);
        }
        ShortcutDesc shortcut = new ShortcutDesc(shortcutIsOnline, showOnDesktop);
        if (menu != null) {
            shortcut.addMenu(menu);
        }
        return shortcut;
    }

    public MenuDesc getMenu(Node node) {
        String subMenu = this.getAttribute(node, "submenu", null);
        return new MenuDesc(subMenu);
    }

    public RelatedContentDesc getRelatedContent(Node node) throws ParseException {
        this.getRequiredAttribute(node, "href", null);
        URL location = this.getURL(node, "href", this.base);
        String title = null;
        String description = null;
        IconDesc icon = null;
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String name = child.getNodeName();
            if ("title".equals(name)) {
                if (title != null && this.strict) {
                    throw new ParseException(Parser.R("PTwoTitles"));
                }
                title = this.getSpanText(child);
                continue;
            }
            if ("description".equals(name)) {
                if (description != null && this.strict) {
                    throw new ParseException(Parser.R("PTwoDescriptions"));
                }
                description = this.getSpanText(child);
                continue;
            }
            if (!"icon".equals(name)) continue;
            if (icon != null && this.strict) {
                throw new ParseException(Parser.R("PTwoIcons"));
            }
            icon = this.getIcon(child);
        }
        RelatedContentDesc relatedContent = new RelatedContentDesc(location);
        relatedContent.setDescription(description);
        relatedContent.setIconDesc(icon);
        relatedContent.setTitle(title);
        return relatedContent;
    }

    public String[] splitString(String source) {
        if (source == null) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(source, " ");
        StringBuffer part = new StringBuffer();
        while (st.hasMoreTokens()) {
            part.setLength(0);
            while (true) {
                part.append(st.nextToken());
                if (!st.hasMoreTokens() || part.charAt(part.length() - 1) != '\\') break;
                part.setCharAt(part.length() - 1, ' ');
            }
            int i = part.length();
            while (i-- > 0) {
                if (part.charAt(i) != '\\') continue;
                part.deleteCharAt(i--);
            }
            result.add(part.toString());
        }
        return result.toArray(new String[result.size()]);
    }

    public Locale[] getLocales(Node node) {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        String[] localeParts = this.splitString(this.getAttribute(node, "locale", ""));
        for (int i = 0; i < localeParts.length; ++i) {
            Locale l = this.getLocale(localeParts[i]);
            if (l == null) continue;
            locales.add(l);
        }
        return locales.toArray(new Locale[locales.size()]);
    }

    public Locale getLocale(String localeStr) {
        if (localeStr.length() < 2) {
            return null;
        }
        String language = localeStr.substring(0, 2);
        String country = localeStr.length() < 5 ? "" : localeStr.substring(3, 5);
        String variant = localeStr.length() < 7 ? "" : localeStr.substring(6, 8);
        return new Locale(language, country, variant);
    }

    public String getSpanText(Node node) throws ParseException {
        if (node == null) {
            return null;
        }
        return node.getNodeValue();
    }

    public static Node getChildNode(Node node, String name) {
        Node[] result = Parser.getChildNodes(node, name);
        if (result.length == 0) {
            return null;
        }
        return result[0];
    }

    public static Node[] getChildNodes(Node node, String name) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!child.getNodeName().equals(name)) continue;
            result.add(child);
        }
        return result.toArray(new Node[result.size()]);
    }

    private URL addSlash(URL source) {
        if (source == null) {
            return null;
        }
        if (!source.toString().endsWith("/")) {
            try {
                source = new URL(source.toString() + "/");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return source;
    }

    public URL getRequiredURL(Node node, String name, URL base) throws ParseException {
        this.getRequiredAttribute(node, name, "");
        return this.getURL(node, name, base);
    }

    /*
     * Loose catch block
     */
    public URL getURL(Node node, String name, URL base) throws ParseException {
        String href;
        block8: {
            href = this.getAttribute(node, name, null);
            if (href == null) {
                return null;
            }
            if (base != null) break block8;
            return new URL(href);
            {
                catch (MalformedURLException ex) {
                    if (base == null) {
                        throw new ParseException(Parser.R("PBadNonrelativeUrl", node.getNodeName(), href));
                    }
                    throw new ParseException(Parser.R("PBadRelativeUrl", node.getNodeName(), href, base));
                }
            }
        }
        try {
            return new URL(href);
        }
        catch (MalformedURLException ex) {
            URL result = new URL(base, href);
            if (!result.toString().startsWith(base.toString()) && this.strict) {
                throw new ParseException(Parser.R("PUrlNotInCodebase", node.getNodeName(), href, base));
            }
            return result;
        }
    }

    public Version getVersion(Node node, String name, String defaultValue) {
        String version = this.getAttribute(node, name, defaultValue);
        if (version == null) {
            return null;
        }
        return new Version(version);
    }

    private void checkVMArgs(String vmArgs) throws IllegalArgumentException {
        if (vmArgs == null) {
            return;
        }
        List<String> validArguments = Arrays.asList(this.getValidVMArguments());
        List<String> validStartingArguments = Arrays.asList(this.getValidStartingVMArguments());
        String[] arguments = vmArgs.split(" ");
        boolean argumentIsValid = false;
        for (String argument : arguments) {
            argumentIsValid = false;
            if (validArguments.contains(argument)) {
                argumentIsValid = true;
            } else {
                for (String validStartingArgument : validStartingArguments) {
                    if (!argument.startsWith(validStartingArgument)) continue;
                    argumentIsValid = true;
                    break;
                }
            }
            if (argumentIsValid) continue;
            throw new IllegalArgumentException(argument);
        }
    }

    private String[] getValidVMArguments() {
        return new String[]{"-d32", "-client", "-server", "-verbose", "-version", "-showversion", "-help", "-X", "-ea", "-enableassertions", "-da", "-disableassertions", "-esa", "-enablesystemassertions", "-dsa", "-disablesystemassertions", "-Xmixed", "-Xint", "-Xnoclassgc", "-Xincgc", "-Xbatch", "-Xprof", "-Xdebug", "-Xfuture", "-Xrs", "-XX:+ForceTimeHighResolution", "-XX:-ForceTimeHighResolution"};
    }

    private String[] getValidStartingVMArguments() {
        return new String[]{"-ea", "-enableassertions", "-da", "-disableassertions", "-verbose", "-Xms", "-Xmx", "-Xss", "-XX:NewRatio", "-XX:NewSize", "-XX:MaxNewSize", "-XX:PermSize", "-XX:MaxPermSize", "-XX:MaxHeapFreeRatio", "-XX:MinHeapFreeRatio", "-XX:UseSerialGC", "-XX:ThreadStackSize", "-XX:MaxInlineSize", "-XX:ReservedCodeCacheSize", "-XX:MaxDirectMemorySize"};
    }

    public String getRequiredAttribute(Node node, String name, String defaultValue) throws ParseException {
        String result = this.getAttribute(node, name, null);
        if (!(result != null && result.length() != 0 || !this.strict && defaultValue != null)) {
            throw new ParseException(Parser.R("PNeedsAttribute", node.getNodeName(), name));
        }
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public String getAttribute(Node node, String name, String defaultValue) {
        String result = node.getAttribute(name);
        if (result == null || result.length() == 0) {
            return defaultValue;
        }
        return result;
    }

    public static Node getRootNode(InputStream input) throws ParseException {
        try {
            BufferedInputStream bs = new BufferedInputStream(input);
            XMLElement xml = new XMLElement();
            PipedInputStream pin = new PipedInputStream();
            final PipedOutputStream pout = new PipedOutputStream(pin);
            final InputStreamReader isr = new InputStreamReader((InputStream)bs, Parser.getEncoding(bs));
            new Thread(new Runnable(){

                @Override
                public void run() {
                    new XMLElement().sanitizeInput(isr, pout);
                    try {
                        pout.close();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }).start();
            xml.parseFromReader(new InputStreamReader(pin));
            Node jnlpNode = new Node(xml);
            return jnlpNode;
        }
        catch (Exception ex) {
            throw new ParseException(Parser.R("PBadXML"), ex);
        }
    }

    private static String getEncoding(InputStream input) throws IOException {
        int[] s = new int[4];
        String encoding = "UTF-8";
        input.mark(4);
        for (int i = 0; i < 4; ++i) {
            s[i] = input.read();
        }
        input.reset();
        if (s[0] == 255) {
            if (s[1] == 254) {
                encoding = s[2] != 0 || s[3] != 0 ? "UnicodeLittle" : "X-UTF-32LE-BOM";
            }
        } else if (s[0] == 254 && s[1] == 255 && (s[2] != 0 || s[3] != 0)) {
            encoding = "UTF-16";
        } else if (s[0] == 0 && s[1] == 0 && s[2] == 254 && s[3] == 255) {
            encoding = "X-UTF-32BE-BOM";
        } else if (s[0] == 0 && s[1] == 0 && s[2] == 0 && s[3] == 60) {
            encoding = "UTF-32BE";
        } else if (s[0] == 60 && s[1] == 0 && s[2] == 0 && s[3] == 0) {
            encoding = "UTF-32LE";
        } else if (s[0] == 0 && s[1] == 60 && s[2] == 0 && s[3] == 63) {
            encoding = "UTF-16BE";
        } else if (s[0] == 60 && s[1] == 0 && s[2] == 63 && s[3] == 0) {
            encoding = "UTF-16LE";
        }
        return encoding;
    }
}

