/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.tools.example.debug.tty.Env;
import com.sun.tools.example.debug.tty.MessageOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ThreadInfo {
    private static List<ThreadInfo> threads = Collections.synchronizedList(new ArrayList());
    private static boolean gotInitialThreads = false;
    private static ThreadInfo current = null;
    private static ThreadGroupReference group = null;
    private final ThreadReference thread;
    private int currentFrameIndex = 0;

    private ThreadInfo(ThreadReference thread) {
        this.thread = thread;
        if (thread == null) {
            MessageOutput.fatalError("Internal error: null ThreadInfo created");
        }
    }

    private static void initThreads() {
        if (!gotInitialThreads) {
            for (ThreadReference thread : Env.vm().allThreads()) {
                threads.add(new ThreadInfo(thread));
            }
            gotInitialThreads = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addThread(ThreadReference thread) {
        List<ThreadInfo> list = threads;
        synchronized (list) {
            ThreadInfo.initThreads();
            ThreadInfo ti = new ThreadInfo(thread);
            if (ThreadInfo.getThreadInfo(thread) == null) {
                threads.add(ti);
            }
        }
    }

    static void removeThread(ThreadReference thread) {
        if (thread.equals(current)) {
            String currentThreadName;
            try {
                currentThreadName = "\"" + thread.name() + "\"";
            }
            catch (Exception e) {
                currentThreadName = "";
            }
            ThreadInfo.setCurrentThread(null);
            MessageOutput.println();
            MessageOutput.println("Current thread died. Execution continuing...", currentThreadName);
        }
        threads.remove(ThreadInfo.getThreadInfo(thread));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<ThreadInfo> threads() {
        List<ThreadInfo> list = threads;
        synchronized (list) {
            ThreadInfo.initThreads();
            return new ArrayList<ThreadInfo>(threads);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void invalidateAll() {
        current = null;
        group = null;
        List<ThreadInfo> list = threads;
        synchronized (list) {
            for (ThreadInfo ti : ThreadInfo.threads()) {
                ti.invalidate();
            }
        }
    }

    static void setThreadGroup(ThreadGroupReference tg) {
        group = tg;
    }

    static void setCurrentThread(ThreadReference tr) {
        if (tr == null) {
            ThreadInfo.setCurrentThreadInfo(null);
        } else {
            ThreadInfo tinfo = ThreadInfo.getThreadInfo(tr);
            ThreadInfo.setCurrentThreadInfo(tinfo);
        }
    }

    static void setCurrentThreadInfo(ThreadInfo tinfo) {
        current = tinfo;
        if (current != null) {
            current.invalidate();
        }
    }

    static ThreadInfo getCurrentThreadInfo() {
        return current;
    }

    ThreadReference getThread() {
        return this.thread;
    }

    static ThreadGroupReference group() {
        if (group == null) {
            ThreadInfo.setThreadGroup(Env.vm().topLevelThreadGroups().get(0));
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ThreadInfo getThreadInfo(long id) {
        ThreadInfo retInfo = null;
        List<ThreadInfo> list = threads;
        synchronized (list) {
            for (ThreadInfo ti : ThreadInfo.threads()) {
                if (ti.thread.uniqueID() != id) continue;
                retInfo = ti;
                break;
            }
        }
        return retInfo;
    }

    static ThreadInfo getThreadInfo(ThreadReference tr) {
        return ThreadInfo.getThreadInfo(tr.uniqueID());
    }

    static ThreadInfo getThreadInfo(String idToken) {
        ThreadInfo tinfo = null;
        if (idToken.startsWith("t@")) {
            idToken = idToken.substring(2);
        }
        try {
            long threadId = Long.decode(idToken);
            tinfo = ThreadInfo.getThreadInfo(threadId);
        }
        catch (NumberFormatException e) {
            tinfo = null;
        }
        return tinfo;
    }

    List getStack() throws IncompatibleThreadStateException {
        return this.thread.frames();
    }

    StackFrame getCurrentFrame() throws IncompatibleThreadStateException {
        if (this.thread.frameCount() == 0) {
            return null;
        }
        return this.thread.frame(this.currentFrameIndex);
    }

    void invalidate() {
        this.currentFrameIndex = 0;
    }

    private void assureSuspended() throws IncompatibleThreadStateException {
        if (!this.thread.isSuspended()) {
            throw new IncompatibleThreadStateException();
        }
    }

    int getCurrentFrameIndex() {
        return this.currentFrameIndex;
    }

    void setCurrentFrameIndex(int nFrame) throws IncompatibleThreadStateException {
        this.assureSuspended();
        if (nFrame < 0 || nFrame >= this.thread.frameCount()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.currentFrameIndex = nFrame;
    }

    void up(int nFrames) throws IncompatibleThreadStateException {
        this.setCurrentFrameIndex(this.currentFrameIndex + nFrames);
    }

    void down(int nFrames) throws IncompatibleThreadStateException {
        this.setCurrentFrameIndex(this.currentFrameIndex - nFrames);
    }
}

