/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PathSearchingVirtualMachine;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import com.sun.jdi.request.StepRequest;
import com.sun.tools.example.debug.expr.ExpressionParser;
import com.sun.tools.example.debug.tty.BreakpointSpec;
import com.sun.tools.example.debug.tty.Env;
import com.sun.tools.example.debug.tty.EventRequestSpec;
import com.sun.tools.example.debug.tty.ExceptionSpec;
import com.sun.tools.example.debug.tty.MalformedMemberNameException;
import com.sun.tools.example.debug.tty.MessageOutput;
import com.sun.tools.example.debug.tty.ThreadGroupIterator;
import com.sun.tools.example.debug.tty.ThreadInfo;
import com.sun.tools.example.debug.tty.ThreadIterator;
import com.sun.tools.example.debug.tty.VMConnection;
import com.sun.tools.example.debug.tty.VMNotConnectedException;
import com.sun.tools.example.debug.tty.WatchpointSpec;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Commands {
    static String methodTraceCommand = null;

    Commands() {
    }

    private Value evaluate(String expr) {
        Value result = null;
        ExpressionParser.GetFrame frameGetter = null;
        try {
            final ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
            if (threadInfo != null && threadInfo.getCurrentFrame() != null) {
                frameGetter = new ExpressionParser.GetFrame(){

                    public StackFrame get() throws IncompatibleThreadStateException {
                        return threadInfo.getCurrentFrame();
                    }
                };
            }
            result = ExpressionParser.evaluate(expr, Env.vm(), frameGetter);
        }
        catch (InvocationException ie) {
            MessageOutput.println("Exception in expression:", ie.exception().referenceType().name());
        }
        catch (Exception ex) {
            String s;
            String exMessage = ex.getMessage();
            if (exMessage == null) {
                MessageOutput.printException(exMessage, ex);
            }
            try {
                s = MessageOutput.format(exMessage);
            }
            catch (MissingResourceException mex) {
                s = ex.toString();
            }
            MessageOutput.printDirectln(s);
        }
        return result;
    }

    private String getStringValue() {
        Value val = null;
        String valStr = null;
        try {
            val = ExpressionParser.getMassagedValue();
            valStr = val.toString();
        }
        catch (com.sun.tools.example.debug.expr.ParseException e) {
            String s;
            String msg = e.getMessage();
            if (msg == null) {
                MessageOutput.printException(msg, e);
            }
            try {
                s = MessageOutput.format(msg);
            }
            catch (MissingResourceException mex) {
                s = e.toString();
            }
            MessageOutput.printDirectln(s);
        }
        return valStr;
    }

    private ThreadInfo doGetThread(String idToken) {
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo(idToken);
        if (threadInfo == null) {
            MessageOutput.println("is not a valid thread id", idToken);
        }
        return threadInfo;
    }

    String typedName(Method method) {
        StringBuffer buf = new StringBuffer();
        buf.append(method.name());
        buf.append("(");
        List<String> args = method.argumentTypeNames();
        int lastParam = args.size() - 1;
        for (int ii = 0; ii < lastParam; ++ii) {
            buf.append(args.get(ii));
            buf.append(", ");
        }
        if (lastParam >= 0) {
            String lastStr = args.get(lastParam);
            if (method.isVarArgs()) {
                buf.append(lastStr.substring(0, lastStr.length() - 2));
                buf.append("...");
            } else {
                buf.append(lastStr);
            }
        }
        buf.append(")");
        return buf.toString();
    }

    void commandConnectors(VirtualMachineManager vmm) {
        Iterator<Connector> iter = vmm.allConnectors().iterator();
        if (iter.hasNext()) {
            MessageOutput.println("Connectors available");
        }
        while (iter.hasNext()) {
            Connector cc = iter.next();
            String transportName = cc.transport() == null ? "null" : cc.transport().name();
            MessageOutput.println();
            MessageOutput.println("Connector and Transport name", new Object[]{cc.name(), transportName});
            MessageOutput.println("Connector description", cc.description());
            Iterator<Connector.Argument> argIter = cc.defaultArguments().values().iterator();
            if (!argIter.hasNext()) continue;
            while (argIter.hasNext()) {
                Connector.Argument aa = argIter.next();
                MessageOutput.println();
                boolean requiredArgument = aa.mustSpecify();
                if (aa.value() == null || aa.value() == "") {
                    MessageOutput.println(requiredArgument ? "Connector required argument nodefault" : "Connector argument nodefault", aa.name());
                } else {
                    MessageOutput.println(requiredArgument ? "Connector required argument default" : "Connector argument default", new Object[]{aa.name(), aa.value()});
                }
                MessageOutput.println("Connector description", aa.description());
            }
        }
    }

    void commandClasses() {
        List<ReferenceType> list = Env.vm().allClasses();
        StringBuffer classList = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            ReferenceType refType = list.get(i);
            classList.append(refType.name());
            classList.append("\n");
        }
        MessageOutput.print("** classes list **", classList.toString());
    }

    void commandClass(StringTokenizer t) {
        ReferenceType type;
        List<ReferenceType> list = Env.vm().allClasses();
        if (!t.hasMoreTokens()) {
            MessageOutput.println("No class specified.");
            return;
        }
        String idClass = t.nextToken();
        boolean showAll = false;
        if (t.hasMoreTokens()) {
            if (t.nextToken().toLowerCase().equals("all")) {
                showAll = true;
            } else {
                MessageOutput.println("Invalid option on class command");
                return;
            }
        }
        if ((type = Env.getReferenceTypeFromToken(idClass)) == null) {
            MessageOutput.println("is not a valid id or class name", idClass);
            return;
        }
        if (type instanceof ClassType) {
            ClassType clazz = (ClassType)type;
            MessageOutput.println("Class:", clazz.name());
            ClassType superclass = clazz.superclass();
            while (superclass != null) {
                MessageOutput.println("extends:", superclass.name());
                superclass = showAll ? superclass.superclass() : null;
            }
            List<InterfaceType> interfaces = showAll ? clazz.allInterfaces() : clazz.interfaces();
            for (InterfaceType interfaze : interfaces) {
                MessageOutput.println("implements:", interfaze.name());
            }
            List<ClassType> subs = clazz.subclasses();
            for (ClassType sub : subs) {
                MessageOutput.println("subclass:", sub.name());
            }
            List<ReferenceType> nested = clazz.nestedTypes();
            for (ReferenceType nest : nested) {
                MessageOutput.println("nested:", nest.name());
            }
        } else if (type instanceof InterfaceType) {
            InterfaceType interfaze = (InterfaceType)type;
            MessageOutput.println("Interface:", interfaze.name());
            List<InterfaceType> supers = interfaze.superinterfaces();
            for (InterfaceType superinterface : supers) {
                MessageOutput.println("extends:", superinterface.name());
            }
            List<InterfaceType> subs = interfaze.subinterfaces();
            for (InterfaceType sub : subs) {
                MessageOutput.println("subinterface:", sub.name());
            }
            List<ClassType> implementors = interfaze.implementors();
            for (ClassType implementor : implementors) {
                MessageOutput.println("implementor:", implementor.name());
            }
            List<ReferenceType> nested = interfaze.nestedTypes();
            for (ReferenceType nest : nested) {
                MessageOutput.println("nested:", nest.name());
            }
        } else {
            ArrayType array = (ArrayType)type;
            MessageOutput.println("Array:", array.name());
        }
    }

    void commandMethods(StringTokenizer t) {
        if (!t.hasMoreTokens()) {
            MessageOutput.println("No class specified.");
            return;
        }
        String idClass = t.nextToken();
        ReferenceType cls = Env.getReferenceTypeFromToken(idClass);
        if (cls != null) {
            List<Method> methods = cls.allMethods();
            StringBuffer methodsList = new StringBuffer();
            for (int i = 0; i < methods.size(); ++i) {
                Method method = methods.get(i);
                methodsList.append(method.declaringType().name());
                methodsList.append(" ");
                methodsList.append(this.typedName(method));
                methodsList.append('\n');
            }
            MessageOutput.print("** methods list **", methodsList.toString());
        } else {
            MessageOutput.println("is not a valid id or class name", idClass);
        }
    }

    void commandFields(StringTokenizer t) {
        if (!t.hasMoreTokens()) {
            MessageOutput.println("No class specified.");
            return;
        }
        String idClass = t.nextToken();
        ReferenceType cls = Env.getReferenceTypeFromToken(idClass);
        if (cls != null) {
            List<Field> fields = cls.allFields();
            List<Field> visible = cls.visibleFields();
            StringBuffer fieldsList = new StringBuffer();
            for (int i = 0; i < fields.size(); ++i) {
                Field field = fields.get(i);
                String s = !visible.contains(field) ? MessageOutput.format("list field typename and name hidden", new Object[]{field.typeName(), field.name()}) : (!((Object)field.declaringType()).equals(cls) ? MessageOutput.format("list field typename and name inherited", new Object[]{field.typeName(), field.name(), field.declaringType().name()}) : MessageOutput.format("list field typename and name", new Object[]{field.typeName(), field.name()}));
                fieldsList.append(s);
            }
            MessageOutput.print("** fields list **", fieldsList.toString());
        } else {
            MessageOutput.println("is not a valid id or class name", idClass);
        }
    }

    private void printThreadGroup(ThreadGroupReference tg) {
        ThreadReference thr;
        ThreadIterator threadIter = new ThreadIterator(tg);
        MessageOutput.println("Thread Group:", tg.name());
        int maxIdLength = 0;
        int maxNameLength = 0;
        while (threadIter.hasNext()) {
            thr = (ThreadReference)threadIter.next();
            maxIdLength = Math.max(maxIdLength, Env.description(thr).length());
            maxNameLength = Math.max(maxNameLength, thr.name().length());
        }
        threadIter = new ThreadIterator(tg);
        while (threadIter.hasNext()) {
            String statusFormat;
            thr = (ThreadReference)threadIter.next();
            if (thr.threadGroup() == null) continue;
            if (!thr.threadGroup().equals(tg)) {
                tg = thr.threadGroup();
                MessageOutput.println("Thread Group:", tg.name());
            }
            StringBuffer idBuffer = new StringBuffer(Env.description(thr));
            for (int i = idBuffer.length(); i < maxIdLength; ++i) {
                idBuffer.append(" ");
            }
            StringBuffer nameBuffer = new StringBuffer(thr.name());
            for (int i = nameBuffer.length(); i < maxNameLength; ++i) {
                nameBuffer.append(" ");
            }
            switch (thr.status()) {
                case -1: {
                    if (thr.isAtBreakpoint()) {
                        statusFormat = "Thread description name unknownStatus BP";
                        break;
                    }
                    statusFormat = "Thread description name unknownStatus";
                    break;
                }
                case 0: {
                    if (thr.isAtBreakpoint()) {
                        statusFormat = "Thread description name zombieStatus BP";
                        break;
                    }
                    statusFormat = "Thread description name zombieStatus";
                    break;
                }
                case 1: {
                    if (thr.isAtBreakpoint()) {
                        statusFormat = "Thread description name runningStatus BP";
                        break;
                    }
                    statusFormat = "Thread description name runningStatus";
                    break;
                }
                case 2: {
                    if (thr.isAtBreakpoint()) {
                        statusFormat = "Thread description name sleepingStatus BP";
                        break;
                    }
                    statusFormat = "Thread description name sleepingStatus";
                    break;
                }
                case 3: {
                    if (thr.isAtBreakpoint()) {
                        statusFormat = "Thread description name waitingStatus BP";
                        break;
                    }
                    statusFormat = "Thread description name waitingStatus";
                    break;
                }
                case 4: {
                    if (thr.isAtBreakpoint()) {
                        statusFormat = "Thread description name condWaitstatus BP";
                        break;
                    }
                    statusFormat = "Thread description name condWaitstatus";
                    break;
                }
                default: {
                    throw new InternalError(MessageOutput.format("Invalid thread status."));
                }
            }
            MessageOutput.println(statusFormat, new Object[]{idBuffer.toString(), nameBuffer.toString()});
        }
    }

    void commandThreads(StringTokenizer t) {
        if (!t.hasMoreTokens()) {
            this.printThreadGroup(ThreadInfo.group());
            return;
        }
        String name = t.nextToken();
        ThreadGroupReference tg = ThreadGroupIterator.find(name);
        if (tg == null) {
            MessageOutput.println("is not a valid threadgroup name", name);
        } else {
            this.printThreadGroup(tg);
        }
    }

    void commandThreadGroups() {
        ThreadGroupIterator it = new ThreadGroupIterator();
        int cnt = 0;
        while (it.hasNext()) {
            ThreadGroupReference tg = it.nextThreadGroup();
            MessageOutput.println("thread group number description name", new Object[]{new Integer(++cnt), Env.description(tg), tg.name()});
        }
    }

    void commandThread(StringTokenizer t) {
        if (!t.hasMoreTokens()) {
            MessageOutput.println("Thread number not specified.");
            return;
        }
        ThreadInfo threadInfo = this.doGetThread(t.nextToken());
        if (threadInfo != null) {
            ThreadInfo.setCurrentThreadInfo(threadInfo);
        }
    }

    void commandThreadGroup(StringTokenizer t) {
        if (!t.hasMoreTokens()) {
            MessageOutput.println("Threadgroup name not specified.");
            return;
        }
        String name = t.nextToken();
        ThreadGroupReference tg = ThreadGroupIterator.find(name);
        if (tg == null) {
            MessageOutput.println("is not a valid threadgroup name", name);
        } else {
            ThreadInfo.setThreadGroup(tg);
        }
    }

    void commandRun(StringTokenizer t) {
        String args;
        VMConnection connection = Env.connection();
        if (!connection.isLaunch()) {
            if (!t.hasMoreTokens()) {
                this.commandCont();
            } else {
                MessageOutput.println("run <args> command is valid only with launched VMs");
            }
            return;
        }
        if (connection.isOpen()) {
            MessageOutput.println("VM already running. use cont to continue after events.");
            return;
        }
        if (t.hasMoreTokens()) {
            args = t.nextToken("");
            boolean argsSet = connection.setConnectorArg("main", args);
            if (!argsSet) {
                MessageOutput.println("Unable to set main class and arguments");
                return;
            }
        } else {
            args = connection.connectorArg("main");
            if (args.length() == 0) {
                MessageOutput.println("Main class and arguments must be specified");
                return;
            }
        }
        MessageOutput.println("run", args);
        connection.open();
    }

    void commandLoad(StringTokenizer t) {
        MessageOutput.println("The load command is no longer supported.");
    }

    private List<ThreadReference> allThreads(ThreadGroupReference group) {
        ArrayList<ThreadReference> list = new ArrayList<ThreadReference>();
        list.addAll(group.threads());
        for (ThreadGroupReference child : group.threadGroups()) {
            list.addAll(this.allThreads(child));
        }
        return list;
    }

    void commandSuspend(StringTokenizer t) {
        if (!t.hasMoreTokens()) {
            Env.vm().suspend();
            MessageOutput.println("All threads suspended.");
        } else {
            while (t.hasMoreTokens()) {
                ThreadInfo threadInfo = this.doGetThread(t.nextToken());
                if (threadInfo == null) continue;
                threadInfo.getThread().suspend();
            }
        }
    }

    void commandResume(StringTokenizer t) {
        if (!t.hasMoreTokens()) {
            ThreadInfo.invalidateAll();
            Env.vm().resume();
            MessageOutput.println("All threads resumed.");
        } else {
            while (t.hasMoreTokens()) {
                ThreadInfo threadInfo = this.doGetThread(t.nextToken());
                if (threadInfo == null) continue;
                threadInfo.invalidate();
                threadInfo.getThread().resume();
            }
        }
    }

    void commandCont() {
        if (ThreadInfo.getCurrentThreadInfo() == null) {
            MessageOutput.println("Nothing suspended.");
            return;
        }
        ThreadInfo.invalidateAll();
        Env.vm().resume();
    }

    void clearPreviousStep(ThreadReference thread) {
        EventRequestManager mgr = Env.vm().eventRequestManager();
        List<StepRequest> requests = mgr.stepRequests();
        for (StepRequest request : requests) {
            if (!request.thread().equals(thread)) continue;
            mgr.deleteEventRequest(request);
            break;
        }
    }

    void commandStep(StringTokenizer t) {
        ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
        if (threadInfo == null) {
            MessageOutput.println("Nothing suspended.");
            return;
        }
        int depth = t.hasMoreTokens() && t.nextToken().toLowerCase().equals("up") ? 3 : 1;
        this.clearPreviousStep(threadInfo.getThread());
        EventRequestManager reqMgr = Env.vm().eventRequestManager();
        StepRequest request = reqMgr.createStepRequest(threadInfo.getThread(), -2, depth);
        if (depth == 1) {
            Env.addExcludes(request);
        }
        request.addCountFilter(1);
        request.enable();
        ThreadInfo.invalidateAll();
        Env.vm().resume();
    }

    void commandStepi() {
        ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
        if (threadInfo == null) {
            MessageOutput.println("Nothing suspended.");
            return;
        }
        this.clearPreviousStep(threadInfo.getThread());
        EventRequestManager reqMgr = Env.vm().eventRequestManager();
        StepRequest request = reqMgr.createStepRequest(threadInfo.getThread(), -1, 1);
        Env.addExcludes(request);
        request.addCountFilter(1);
        request.enable();
        ThreadInfo.invalidateAll();
        Env.vm().resume();
    }

    void commandNext() {
        ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
        if (threadInfo == null) {
            MessageOutput.println("Nothing suspended.");
            return;
        }
        this.clearPreviousStep(threadInfo.getThread());
        EventRequestManager reqMgr = Env.vm().eventRequestManager();
        StepRequest request = reqMgr.createStepRequest(threadInfo.getThread(), -2, 2);
        Env.addExcludes(request);
        request.addCountFilter(1);
        request.enable();
        ThreadInfo.invalidateAll();
        Env.vm().resume();
    }

    void doKill(ThreadReference thread, StringTokenizer t) {
        if (!t.hasMoreTokens()) {
            MessageOutput.println("No exception object specified.");
            return;
        }
        String expr = t.nextToken("");
        Value val = this.evaluate(expr);
        if (val != null && val instanceof ObjectReference) {
            try {
                thread.stop((ObjectReference)val);
                MessageOutput.println("killed", thread.toString());
            }
            catch (InvalidTypeException e) {
                MessageOutput.println("Invalid exception object");
            }
        } else {
            MessageOutput.println("Expression must evaluate to an object");
        }
    }

    void doKillThread(final ThreadReference threadToKill, final StringTokenizer tokenizer) {
        new AsyncExecution(){

            void action() {
                Commands.this.doKill(threadToKill, tokenizer);
            }
        };
    }

    void commandKill(StringTokenizer t) {
        if (!t.hasMoreTokens()) {
            MessageOutput.println("Usage: kill <thread id> <throwable>");
            return;
        }
        ThreadInfo threadInfo = this.doGetThread(t.nextToken());
        if (threadInfo != null) {
            MessageOutput.println("killing thread:", threadInfo.getThread().name());
            this.doKillThread(threadInfo.getThread(), t);
            return;
        }
    }

    void listCaughtExceptions() {
        boolean noExceptions = true;
        for (EventRequestSpec spec : Env.specList.eventRequestSpecs()) {
            if (!(spec instanceof ExceptionSpec)) continue;
            if (noExceptions) {
                noExceptions = false;
                MessageOutput.println("Exceptions caught:");
            }
            MessageOutput.println("tab", spec.toString());
        }
        if (noExceptions) {
            MessageOutput.println("No exceptions caught.");
        }
    }

    private EventRequestSpec parseExceptionSpec(StringTokenizer t) {
        String notification = t.nextToken();
        boolean notifyCaught = false;
        boolean notifyUncaught = false;
        EventRequestSpec spec = null;
        String classPattern = null;
        if (notification.equals("uncaught")) {
            notifyCaught = false;
            notifyUncaught = true;
        } else if (notification.equals("caught")) {
            notifyCaught = true;
            notifyUncaught = false;
        } else if (notification.equals("all")) {
            notifyCaught = true;
            notifyUncaught = true;
        } else {
            notifyCaught = true;
            notifyUncaught = true;
            classPattern = notification;
        }
        if (classPattern == null && t.hasMoreTokens()) {
            classPattern = t.nextToken();
        }
        if (classPattern != null && (notifyCaught || notifyUncaught)) {
            try {
                spec = Env.specList.createExceptionCatch(classPattern, notifyCaught, notifyUncaught);
            }
            catch (ClassNotFoundException exc) {
                MessageOutput.println("is not a valid class name", classPattern);
            }
        }
        return spec;
    }

    void commandCatchException(StringTokenizer t) {
        if (!t.hasMoreTokens()) {
            this.listCaughtExceptions();
        } else {
            EventRequestSpec spec = this.parseExceptionSpec(t);
            if (spec != null) {
                this.resolveNow(spec);
            } else {
                MessageOutput.println("Usage: catch exception");
            }
        }
    }

    void commandIgnoreException(StringTokenizer t) {
        if (!t.hasMoreTokens()) {
            this.listCaughtExceptions();
        } else {
            EventRequestSpec spec = this.parseExceptionSpec(t);
            if (Env.specList.delete(spec)) {
                MessageOutput.println("Removed:", spec.toString());
            } else {
                if (spec != null) {
                    MessageOutput.println("Not found:", spec.toString());
                }
                MessageOutput.println("Usage: ignore exception");
            }
        }
    }

    void commandUp(StringTokenizer t) {
        ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
        if (threadInfo == null) {
            MessageOutput.println("Current thread not set.");
            return;
        }
        int nLevels = 1;
        if (t.hasMoreTokens()) {
            int i;
            String idToken = t.nextToken();
            try {
                NumberFormat nf = NumberFormat.getNumberInstance();
                nf.setParseIntegerOnly(true);
                Number n = nf.parse(idToken);
                i = n.intValue();
            }
            catch (ParseException jtpe) {
                i = 0;
            }
            if (i <= 0) {
                MessageOutput.println("Usage: up [n frames]");
                return;
            }
            nLevels = i;
        }
        try {
            threadInfo.up(nLevels);
        }
        catch (IncompatibleThreadStateException e) {
            MessageOutput.println("Current thread isnt suspended.");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            MessageOutput.println("End of stack.");
        }
    }

    void commandDown(StringTokenizer t) {
        ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
        if (threadInfo == null) {
            MessageOutput.println("Current thread not set.");
            return;
        }
        int nLevels = 1;
        if (t.hasMoreTokens()) {
            int i;
            String idToken = t.nextToken();
            try {
                NumberFormat nf = NumberFormat.getNumberInstance();
                nf.setParseIntegerOnly(true);
                Number n = nf.parse(idToken);
                i = n.intValue();
            }
            catch (ParseException jtpe) {
                i = 0;
            }
            if (i <= 0) {
                MessageOutput.println("Usage: down [n frames]");
                return;
            }
            nLevels = i;
        }
        try {
            threadInfo.down(nLevels);
        }
        catch (IncompatibleThreadStateException e) {
            MessageOutput.println("Current thread isnt suspended.");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            MessageOutput.println("End of stack.");
        }
    }

    private void dumpStack(ThreadInfo threadInfo, boolean showPC) {
        List stack = null;
        try {
            stack = threadInfo.getStack();
        }
        catch (IncompatibleThreadStateException e) {
            MessageOutput.println("Current thread isnt suspended.");
            return;
        }
        if (stack == null) {
            MessageOutput.println("Thread is not running (no stack).");
        } else {
            int nFrames = stack.size();
            for (int i = threadInfo.getCurrentFrameIndex(); i < nFrames; ++i) {
                StackFrame frame = (StackFrame)stack.get(i);
                this.dumpFrame(i, showPC, frame);
            }
        }
    }

    private void dumpFrame(int frameNumber, boolean showPC, StackFrame frame) {
        Location loc = frame.location();
        long pc = -1L;
        if (showPC) {
            pc = loc.codeIndex();
        }
        Method meth = loc.method();
        long lineNumber = loc.lineNumber();
        String methodInfo = null;
        if (meth instanceof Method && meth.isNative()) {
            methodInfo = MessageOutput.format("native method");
        } else if (lineNumber != -1L) {
            try {
                methodInfo = loc.sourceName() + MessageOutput.format("line number", new Object[]{new Long(lineNumber)});
            }
            catch (AbsentInformationException e) {
                methodInfo = MessageOutput.format("unknown");
            }
        }
        if (pc != -1L) {
            MessageOutput.println("stack frame dump with pc", new Object[]{new Integer(frameNumber + 1), meth.declaringType().name(), meth.name(), methodInfo, new Long(pc)});
        } else {
            MessageOutput.println("stack frame dump", new Object[]{new Integer(frameNumber + 1), meth.declaringType().name(), meth.name(), methodInfo});
        }
    }

    void commandWhere(StringTokenizer t, boolean showPC) {
        if (!t.hasMoreTokens()) {
            ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
            if (threadInfo == null) {
                MessageOutput.println("No thread specified.");
                return;
            }
            this.dumpStack(threadInfo, showPC);
        } else {
            String token = t.nextToken();
            if (token.toLowerCase().equals("all")) {
                for (ThreadInfo threadInfo : ThreadInfo.threads()) {
                    MessageOutput.println("Thread:", threadInfo.getThread().name());
                    this.dumpStack(threadInfo, showPC);
                }
            } else {
                ThreadInfo threadInfo = this.doGetThread(token);
                if (threadInfo != null) {
                    ThreadInfo.setCurrentThreadInfo(threadInfo);
                    this.dumpStack(threadInfo, showPC);
                }
            }
        }
    }

    void commandInterrupt(StringTokenizer t) {
        if (!t.hasMoreTokens()) {
            ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
            if (threadInfo == null) {
                MessageOutput.println("No thread specified.");
                return;
            }
            threadInfo.getThread().interrupt();
        } else {
            ThreadInfo threadInfo = this.doGetThread(t.nextToken());
            if (threadInfo != null) {
                threadInfo.getThread().interrupt();
            }
        }
    }

    void commandMemory() {
        MessageOutput.println("The memory command is no longer supported.");
    }

    void commandGC() {
        MessageOutput.println("The gc command is no longer necessary.");
    }

    static String locationString(Location loc) {
        return MessageOutput.format("locationString", new Object[]{loc.declaringType().name(), loc.method().name(), new Integer(loc.lineNumber()), new Long(loc.codeIndex())});
    }

    void listBreakpoints() {
        boolean noBreakpoints = true;
        for (EventRequestSpec spec : Env.specList.eventRequestSpecs()) {
            if (!(spec instanceof BreakpointSpec)) continue;
            if (noBreakpoints) {
                noBreakpoints = false;
                MessageOutput.println("Breakpoints set:");
            }
            MessageOutput.println("tab", spec.toString());
        }
        if (noBreakpoints) {
            MessageOutput.println("No breakpoints set.");
        }
    }

    private void printBreakpointCommandUsage(String atForm, String inForm) {
        MessageOutput.println("printbreakpointcommandusage", new Object[]{atForm, inForm});
    }

    protected BreakpointSpec parseBreakpointSpec(StringTokenizer t, String atForm, String inForm) {
        EventRequestSpec breakpoint = null;
        try {
            String rest;
            String token = t.nextToken(":( \t\n\r");
            try {
                rest = t.nextToken("").trim();
            }
            catch (NoSuchElementException e) {
                rest = null;
            }
            if (rest != null && rest.startsWith(":")) {
                t = new StringTokenizer(rest.substring(1));
                String classId = token;
                String lineToken = t.nextToken();
                NumberFormat nf = NumberFormat.getNumberInstance();
                nf.setParseIntegerOnly(true);
                Number n = nf.parse(lineToken);
                int lineNumber = n.intValue();
                if (t.hasMoreTokens()) {
                    this.printBreakpointCommandUsage(atForm, inForm);
                    return null;
                }
                try {
                    breakpoint = Env.specList.createBreakpoint(classId, lineNumber);
                }
                catch (ClassNotFoundException exc) {
                    MessageOutput.println("is not a valid class name", classId);
                }
            } else {
                int idot = token.lastIndexOf(".");
                if (idot <= 0 || idot >= token.length() - 1) {
                    this.printBreakpointCommandUsage(atForm, inForm);
                    return null;
                }
                String methodName = token.substring(idot + 1);
                String classId = token.substring(0, idot);
                ArrayList<String> argumentList = null;
                if (rest != null) {
                    if (!rest.startsWith("(") || !rest.endsWith(")")) {
                        MessageOutput.println("Invalid method specification:", methodName + rest);
                        this.printBreakpointCommandUsage(atForm, inForm);
                        return null;
                    }
                    rest = rest.substring(1, rest.length() - 1);
                    argumentList = new ArrayList<String>();
                    t = new StringTokenizer(rest, ",");
                    while (t.hasMoreTokens()) {
                        argumentList.add(t.nextToken());
                    }
                }
                try {
                    breakpoint = Env.specList.createBreakpoint(classId, methodName, argumentList);
                }
                catch (MalformedMemberNameException exc) {
                    MessageOutput.println("is not a valid method name", methodName);
                }
                catch (ClassNotFoundException exc) {
                    MessageOutput.println("is not a valid class name", classId);
                }
            }
        }
        catch (Exception e) {
            this.printBreakpointCommandUsage(atForm, inForm);
            return null;
        }
        return (BreakpointSpec)breakpoint;
    }

    private void resolveNow(EventRequestSpec spec) {
        boolean success = Env.specList.addEagerlyResolve(spec);
        if (success && !spec.isResolved()) {
            MessageOutput.println("Deferring.", spec.toString());
        }
    }

    void commandStop(StringTokenizer t) {
        String atIn;
        int suspendPolicy = 2;
        if (t.hasMoreTokens()) {
            atIn = t.nextToken();
            if (atIn.equals("go") && t.hasMoreTokens()) {
                suspendPolicy = 0;
                atIn = t.nextToken();
            } else if (atIn.equals("thread") && t.hasMoreTokens()) {
                suspendPolicy = 1;
                atIn = t.nextToken();
            }
        } else {
            this.listBreakpoints();
            return;
        }
        BreakpointSpec spec = this.parseBreakpointSpec(t, "stop at", "stop in");
        if (spec != null) {
            if (atIn.equals("at") && spec.isMethodBreakpoint()) {
                MessageOutput.println("Use stop at to set a breakpoint at a line number");
                this.printBreakpointCommandUsage("stop at", "stop in");
                return;
            }
            spec.suspendPolicy = suspendPolicy;
            this.resolveNow(spec);
        }
    }

    void commandClear(StringTokenizer t) {
        if (!t.hasMoreTokens()) {
            this.listBreakpoints();
            return;
        }
        BreakpointSpec spec = this.parseBreakpointSpec(t, "clear", "clear");
        if (spec != null) {
            if (Env.specList.delete(spec)) {
                MessageOutput.println("Removed:", spec.toString());
            } else {
                MessageOutput.println("Not found:", spec.toString());
            }
        }
    }

    private List<EventRequestSpec> parseWatchpointSpec(StringTokenizer t) {
        ArrayList<EventRequestSpec> list = new ArrayList<EventRequestSpec>();
        boolean access = false;
        boolean modification = false;
        int suspendPolicy = 2;
        String fieldName = t.nextToken();
        if (fieldName.equals("go")) {
            suspendPolicy = 0;
            fieldName = t.nextToken();
        } else if (fieldName.equals("thread")) {
            suspendPolicy = 1;
            fieldName = t.nextToken();
        }
        if (fieldName.equals("access")) {
            access = true;
            fieldName = t.nextToken();
        } else if (fieldName.equals("all")) {
            access = true;
            modification = true;
            fieldName = t.nextToken();
        } else {
            modification = true;
        }
        int dot = fieldName.lastIndexOf(46);
        if (dot < 0) {
            MessageOutput.println("Class containing field must be specified.");
            return list;
        }
        String className = fieldName.substring(0, dot);
        fieldName = fieldName.substring(dot + 1);
        try {
            EventRequestSpec spec;
            if (access) {
                spec = Env.specList.createAccessWatchpoint(className, fieldName);
                spec.suspendPolicy = suspendPolicy;
                list.add(spec);
            }
            if (modification) {
                spec = Env.specList.createModificationWatchpoint(className, fieldName);
                spec.suspendPolicy = suspendPolicy;
                list.add(spec);
            }
        }
        catch (MalformedMemberNameException exc) {
            MessageOutput.println("is not a valid field name", fieldName);
        }
        catch (ClassNotFoundException exc) {
            MessageOutput.println("is not a valid class name", className);
        }
        return list;
    }

    void commandWatch(StringTokenizer t) {
        if (!t.hasMoreTokens()) {
            MessageOutput.println("Field to watch not specified");
            return;
        }
        Iterator<EventRequestSpec> iter = this.parseWatchpointSpec(t).iterator();
        while (iter.hasNext()) {
            this.resolveNow((WatchpointSpec)iter.next());
        }
    }

    void commandUnwatch(StringTokenizer t) {
        if (!t.hasMoreTokens()) {
            MessageOutput.println("Field to unwatch not specified");
            return;
        }
        for (WatchpointSpec watchpointSpec : this.parseWatchpointSpec(t)) {
            if (Env.specList.delete(watchpointSpec)) {
                MessageOutput.println("Removed:", watchpointSpec.toString());
                continue;
            }
            MessageOutput.println("Not found:", watchpointSpec.toString());
        }
    }

    void turnOnExitTrace(ThreadInfo threadInfo, int suspendPolicy) {
        EventRequestManager erm = Env.vm().eventRequestManager();
        MethodExitRequest exit = erm.createMethodExitRequest();
        if (threadInfo != null) {
            exit.addThreadFilter(threadInfo.getThread());
        }
        Env.addExcludes(exit);
        exit.setSuspendPolicy(suspendPolicy);
        exit.enable();
    }

    void commandTrace(StringTokenizer t) {
        int suspendPolicy = 2;
        ThreadInfo threadInfo = null;
        String goStr = " ";
        if (t.hasMoreTokens()) {
            String modif = t.nextToken();
            if (modif.equals("go")) {
                suspendPolicy = 0;
                goStr = " go ";
                if (t.hasMoreTokens()) {
                    modif = t.nextToken();
                }
            } else if (modif.equals("thread")) {
                suspendPolicy = 1;
                if (t.hasMoreTokens()) {
                    modif = t.nextToken();
                }
            }
            if (modif.equals("method")) {
                String traceCmd = null;
                if (t.hasMoreTokens()) {
                    String modif1 = t.nextToken();
                    if (modif1.equals("exits") || modif1.equals("exit")) {
                        if (t.hasMoreTokens()) {
                            threadInfo = this.doGetThread(t.nextToken());
                        }
                        if (modif1.equals("exit")) {
                            StackFrame frame;
                            try {
                                frame = ThreadInfo.getCurrentThreadInfo().getCurrentFrame();
                            }
                            catch (IncompatibleThreadStateException ee) {
                                MessageOutput.println("Current thread isnt suspended.");
                                return;
                            }
                            Env.setAtExitMethod(frame.location().method());
                            traceCmd = MessageOutput.format("trace" + goStr + "method exit " + "in effect for", Env.atExitMethod().toString());
                        } else {
                            traceCmd = MessageOutput.format("trace" + goStr + "method exits " + "in effect");
                        }
                        this.commandUntrace(new StringTokenizer("methods"));
                        this.turnOnExitTrace(threadInfo, suspendPolicy);
                        methodTraceCommand = traceCmd;
                        return;
                    }
                } else {
                    MessageOutput.println("Can only trace");
                    return;
                }
            }
            if (modif.equals("methods")) {
                MethodEntryRequest entry;
                EventRequestManager erm = Env.vm().eventRequestManager();
                if (t.hasMoreTokens()) {
                    threadInfo = this.doGetThread(t.nextToken());
                }
                if (threadInfo != null) {
                    entry = erm.createMethodEntryRequest();
                    entry.addThreadFilter(threadInfo.getThread());
                } else {
                    this.commandUntrace(new StringTokenizer("methods"));
                    entry = erm.createMethodEntryRequest();
                }
                Env.addExcludes(entry);
                entry.setSuspendPolicy(suspendPolicy);
                entry.enable();
                this.turnOnExitTrace(threadInfo, suspendPolicy);
                methodTraceCommand = MessageOutput.format("trace" + goStr + "methods in effect");
                return;
            }
            MessageOutput.println("Can only trace");
            return;
        }
        if (methodTraceCommand != null) {
            MessageOutput.printDirectln(methodTraceCommand);
        }
    }

    void commandUntrace(StringTokenizer t) {
        String modif = null;
        EventRequestManager erm = Env.vm().eventRequestManager();
        if (t.hasMoreTokens()) {
            modif = t.nextToken();
        }
        if (modif == null || modif.equals("methods")) {
            erm.deleteEventRequests(erm.methodEntryRequests());
            erm.deleteEventRequests(erm.methodExitRequests());
            Env.setAtExitMethod(null);
            methodTraceCommand = null;
        }
    }

    void commandList(StringTokenizer t) {
        StackFrame frame = null;
        ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
        if (threadInfo == null) {
            MessageOutput.println("No thread specified.");
            return;
        }
        try {
            frame = threadInfo.getCurrentFrame();
        }
        catch (IncompatibleThreadStateException e) {
            MessageOutput.println("Current thread isnt suspended.");
            return;
        }
        if (frame == null) {
            MessageOutput.println("No frames on the current call stack");
            return;
        }
        Location loc = frame.location();
        if (loc.method().isNative()) {
            MessageOutput.println("Current method is native");
            return;
        }
        String sourceFileName = null;
        try {
            sourceFileName = loc.sourceName();
            ReferenceType refType = loc.declaringType();
            int lineno = loc.lineNumber();
            if (t.hasMoreTokens()) {
                String id = t.nextToken();
                try {
                    NumberFormat nf = NumberFormat.getNumberInstance();
                    nf.setParseIntegerOnly(true);
                    Number n = nf.parse(id);
                    lineno = n.intValue();
                }
                catch (ParseException jtpe) {
                    List<Method> meths = refType.methodsByName(id);
                    if (meths == null || meths.size() == 0) {
                        MessageOutput.println("is not a valid line number or method name for", new Object[]{id, refType.name()});
                        return;
                    }
                    if (meths.size() > 1) {
                        MessageOutput.println("is an ambiguous method name in", new Object[]{id, refType.name()});
                        return;
                    }
                    loc = meths.get(0).location();
                    lineno = loc.lineNumber();
                }
            }
            int startLine = Math.max(lineno - 4, 1);
            int endLine = startLine + 9;
            if (lineno < 0) {
                MessageOutput.println("Line number information not available for");
            } else if (Env.sourceLine(loc, lineno) == null) {
                MessageOutput.println("is an invalid line number for", new Object[]{new Integer(lineno), refType.name()});
            } else {
                String sourceLine;
                for (int i = startLine; i <= endLine && (sourceLine = Env.sourceLine(loc, i)) != null; ++i) {
                    if (i == lineno) {
                        MessageOutput.println("source line number current line and line", new Object[]{new Integer(i), sourceLine});
                        continue;
                    }
                    MessageOutput.println("source line number and line", new Object[]{new Integer(i), sourceLine});
                }
            }
        }
        catch (AbsentInformationException e) {
            MessageOutput.println("No source information available for:", loc.toString());
        }
        catch (FileNotFoundException exc) {
            MessageOutput.println("Source file not found:", sourceFileName);
        }
        catch (IOException exc) {
            MessageOutput.println("I/O exception occurred:", exc.toString());
        }
    }

    void commandLines(StringTokenizer t) {
        if (!t.hasMoreTokens()) {
            MessageOutput.println("Specify class and method");
        } else {
            String idClass = t.nextToken();
            String idMethod = t.hasMoreTokens() ? t.nextToken() : null;
            try {
                ReferenceType refType = Env.getReferenceTypeFromToken(idClass);
                if (refType != null) {
                    List<Location> lines = null;
                    if (idMethod == null) {
                        lines = refType.allLineLocations();
                    } else {
                        List<Method> methods = refType.allMethods();
                        for (Method method : methods) {
                            if (!method.name().equals(idMethod)) continue;
                            lines = method.allLineLocations();
                        }
                        if (lines == null) {
                            MessageOutput.println("is not a valid method name", idMethod);
                        }
                    }
                    for (Location line : lines) {
                        MessageOutput.printDirectln(line.toString());
                    }
                } else {
                    MessageOutput.println("is not a valid id or class name", idClass);
                }
            }
            catch (AbsentInformationException e) {
                MessageOutput.println("Line number information not available for", idClass);
            }
        }
    }

    void commandClasspath(StringTokenizer t) {
        if (Env.vm() instanceof PathSearchingVirtualMachine) {
            PathSearchingVirtualMachine vm = (PathSearchingVirtualMachine)Env.vm();
            MessageOutput.println("base directory:", vm.baseDirectory());
            MessageOutput.println("classpath:", vm.classPath().toString());
            MessageOutput.println("bootclasspath:", vm.bootClassPath().toString());
        } else {
            MessageOutput.println("The VM does not use paths");
        }
    }

    void commandUse(StringTokenizer t) {
        if (!t.hasMoreTokens()) {
            MessageOutput.printDirectln(Env.getSourcePath());
        } else {
            Env.setSourcePath(t.nextToken("").trim());
        }
    }

    private void printVar(LocalVariable var, Value value) {
        MessageOutput.println("expr is value", new Object[]{var.name(), value == null ? "null" : value.toString()});
    }

    void commandLocals() {
        ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
        if (threadInfo == null) {
            MessageOutput.println("No default thread specified:");
            return;
        }
        try {
            Value val;
            StackFrame frame = threadInfo.getCurrentFrame();
            if (frame == null) {
                throw new AbsentInformationException();
            }
            List<LocalVariable> vars = frame.visibleVariables();
            if (vars.size() == 0) {
                MessageOutput.println("No local variables");
                return;
            }
            Map<LocalVariable, Value> values = frame.getValues(vars);
            MessageOutput.println("Method arguments:");
            for (LocalVariable var : vars) {
                if (!var.isArgument()) continue;
                val = values.get(var);
                this.printVar(var, val);
            }
            MessageOutput.println("Local variables:");
            for (LocalVariable var : vars) {
                if (var.isArgument()) continue;
                val = values.get(var);
                this.printVar(var, val);
            }
        }
        catch (AbsentInformationException aie) {
            MessageOutput.println("Local variable information not available.");
        }
        catch (IncompatibleThreadStateException exc) {
            MessageOutput.println("Current thread isnt suspended.");
        }
    }

    private void dump(ObjectReference obj, ReferenceType refType, ReferenceType refTypeBase) {
        Iterator<Mirror> it = refType.fields().iterator();
        while (it.hasNext()) {
            StringBuffer o = new StringBuffer();
            Field field = it.next();
            o.append("    ");
            if (!((Object)refType).equals(refTypeBase)) {
                o.append(refType.name());
                o.append(".");
            }
            o.append(field.name());
            o.append(MessageOutput.format("colon space"));
            o.append(obj.getValue(field));
            MessageOutput.printDirectln(o.toString());
        }
        if (refType instanceof ClassType) {
            ClassType sup = ((ClassType)refType).superclass();
            if (sup != null) {
                this.dump(obj, sup, refTypeBase);
            }
        } else if (refType instanceof InterfaceType) {
            List<InterfaceType> sups = ((InterfaceType)refType).superinterfaces();
            Iterator<InterfaceType> it2 = sups.iterator();
            while (it2.hasNext()) {
                this.dump(obj, it2.next(), refTypeBase);
            }
        } else if (obj instanceof ArrayReference) {
            it = ((ArrayReference)obj).getValues().iterator();
            while (it.hasNext()) {
                MessageOutput.printDirect(((Object)it.next()).toString());
                if (!it.hasNext()) continue;
                MessageOutput.printDirect(", ");
            }
            MessageOutput.println();
        }
    }

    void doPrint(StringTokenizer t, boolean dumpObject) {
        if (!t.hasMoreTokens()) {
            MessageOutput.println("No objects specified.");
            return;
        }
        while (t.hasMoreTokens()) {
            String expr = t.nextToken("");
            Value val = this.evaluate(expr);
            if (val == null) {
                MessageOutput.println("expr is null", expr.toString());
                continue;
            }
            if (dumpObject && val instanceof ObjectReference && !(val instanceof StringReference)) {
                ObjectReference obj = (ObjectReference)val;
                ReferenceType refType = obj.referenceType();
                MessageOutput.println("expr is value", new Object[]{expr.toString(), MessageOutput.format("grouping begin character")});
                this.dump(obj, refType, refType);
                MessageOutput.println("grouping end character");
                continue;
            }
            String strVal = this.getStringValue();
            if (strVal == null) continue;
            MessageOutput.println("expr is value", new Object[]{expr.toString(), strVal});
        }
    }

    void commandPrint(final StringTokenizer t, final boolean dumpObject) {
        new AsyncExecution(){

            void action() {
                Commands.this.doPrint(t, dumpObject);
            }
        };
    }

    void commandSet(StringTokenizer t) {
        String all = t.nextToken("");
        if (all.indexOf(61) == -1) {
            MessageOutput.println("Invalid assignment syntax");
            MessageOutput.printPrompt();
            return;
        }
        this.commandPrint(new StringTokenizer(all), false);
    }

    void doLock(StringTokenizer t) {
        if (!t.hasMoreTokens()) {
            MessageOutput.println("No object specified.");
            return;
        }
        String expr = t.nextToken("");
        Value val = this.evaluate(expr);
        try {
            if (val != null && val instanceof ObjectReference) {
                ThreadReference owner;
                ObjectReference object = (ObjectReference)val;
                String strVal = this.getStringValue();
                if (strVal != null) {
                    MessageOutput.println("Monitor information for expr", new Object[]{expr.trim(), strVal});
                }
                if ((owner = object.owningThread()) == null) {
                    MessageOutput.println("Not owned");
                } else {
                    MessageOutput.println("Owned by:", new Object[]{owner.name(), new Integer(object.entryCount())});
                }
                List<ThreadReference> waiters = object.waitingThreads();
                if (waiters.size() == 0) {
                    MessageOutput.println("No waiters");
                } else {
                    for (ThreadReference waiter : waiters) {
                        MessageOutput.println("Waiting thread:", waiter.name());
                    }
                }
            } else {
                MessageOutput.println("Expression must evaluate to an object");
            }
        }
        catch (IncompatibleThreadStateException e) {
            MessageOutput.println("Threads must be suspended");
        }
    }

    void commandLock(final StringTokenizer t) {
        new AsyncExecution(){

            void action() {
                Commands.this.doLock(t);
            }
        };
    }

    private void printThreadLockInfo(ThreadInfo threadInfo) {
        ThreadReference thread = threadInfo.getThread();
        try {
            MessageOutput.println("Monitor information for thread", thread.name());
            List<ObjectReference> owned = thread.ownedMonitors();
            if (owned.size() == 0) {
                MessageOutput.println("No monitors owned");
            } else {
                for (ObjectReference monitor : owned) {
                    MessageOutput.println("Owned monitor:", monitor.toString());
                }
            }
            ObjectReference waiting = thread.currentContendedMonitor();
            if (waiting == null) {
                MessageOutput.println("Not waiting for a monitor");
            } else {
                MessageOutput.println("Waiting for monitor:", waiting.toString());
            }
        }
        catch (IncompatibleThreadStateException e) {
            MessageOutput.println("Threads must be suspended");
        }
    }

    void commandThreadlocks(StringTokenizer t) {
        if (!t.hasMoreTokens()) {
            ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
            if (threadInfo == null) {
                MessageOutput.println("Current thread not set.");
            } else {
                this.printThreadLockInfo(threadInfo);
            }
            return;
        }
        String token = t.nextToken();
        if (token.toLowerCase().equals("all")) {
            for (ThreadInfo threadInfo : ThreadInfo.threads()) {
                this.printThreadLockInfo(threadInfo);
            }
        } else {
            ThreadInfo threadInfo = this.doGetThread(token);
            if (threadInfo != null) {
                ThreadInfo.setCurrentThreadInfo(threadInfo);
                this.printThreadLockInfo(threadInfo);
            }
        }
    }

    void doDisableGC(StringTokenizer t) {
        if (!t.hasMoreTokens()) {
            MessageOutput.println("No object specified.");
            return;
        }
        String expr = t.nextToken("");
        Value val = this.evaluate(expr);
        if (val != null && val instanceof ObjectReference) {
            ObjectReference object = (ObjectReference)val;
            object.disableCollection();
            String strVal = this.getStringValue();
            if (strVal != null) {
                MessageOutput.println("GC Disabled for", strVal);
            }
        } else {
            MessageOutput.println("Expression must evaluate to an object");
        }
    }

    void commandDisableGC(final StringTokenizer t) {
        new AsyncExecution(){

            void action() {
                Commands.this.doDisableGC(t);
            }
        };
    }

    void doEnableGC(StringTokenizer t) {
        if (!t.hasMoreTokens()) {
            MessageOutput.println("No object specified.");
            return;
        }
        String expr = t.nextToken("");
        Value val = this.evaluate(expr);
        if (val != null && val instanceof ObjectReference) {
            ObjectReference object = (ObjectReference)val;
            object.enableCollection();
            String strVal = this.getStringValue();
            if (strVal != null) {
                MessageOutput.println("GC Enabled for", strVal);
            }
        } else {
            MessageOutput.println("Expression must evaluate to an object");
        }
    }

    void commandEnableGC(final StringTokenizer t) {
        new AsyncExecution(){

            void action() {
                Commands.this.doEnableGC(t);
            }
        };
    }

    void doSave(StringTokenizer t) {
        if (!t.hasMoreTokens()) {
            MessageOutput.println("No save index specified.");
            return;
        }
        String key = t.nextToken();
        if (!t.hasMoreTokens()) {
            MessageOutput.println("No expression specified.");
            return;
        }
        String expr = t.nextToken("");
        Value val = this.evaluate(expr);
        if (val != null) {
            Env.setSavedValue(key, val);
            String strVal = this.getStringValue();
            if (strVal != null) {
                MessageOutput.println("saved", strVal);
            }
        } else {
            MessageOutput.println("Expression cannot be void");
        }
    }

    void commandSave(final StringTokenizer t) {
        if (!t.hasMoreTokens()) {
            Set keys = Env.getSaveKeys();
            Iterator iter = keys.iterator();
            if (!iter.hasNext()) {
                MessageOutput.println("No saved values");
                return;
            }
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Value value = Env.getSavedValue(key);
                if (value instanceof ObjectReference && ((ObjectReference)value).isCollected()) {
                    MessageOutput.println("expr is value <collected>", new Object[]{key, value.toString()});
                    continue;
                }
                if (value == null) {
                    MessageOutput.println("expr is null", key);
                    continue;
                }
                MessageOutput.println("expr is value", new Object[]{key, value.toString()});
            }
        } else {
            new AsyncExecution(){

                void action() {
                    Commands.this.doSave(t);
                }
            };
        }
    }

    void commandBytecodes(StringTokenizer t) {
        if (!t.hasMoreTokens()) {
            MessageOutput.println("No class specified.");
            return;
        }
        String className = t.nextToken();
        if (!t.hasMoreTokens()) {
            MessageOutput.println("No method specified.");
            return;
        }
        String methodName = t.nextToken();
        List<ReferenceType> classes = Env.vm().classesByName(className);
        if (classes.size() == 0) {
            if (className.indexOf(46) < 0) {
                MessageOutput.println("not found (try the full name)", className);
            } else {
                MessageOutput.println("not found", className);
            }
            return;
        }
        ReferenceType rt = classes.get(0);
        if (!(rt instanceof ClassType)) {
            MessageOutput.println("not a class", className);
            return;
        }
        byte[] bytecodes = null;
        List<Method> list = rt.methodsByName(methodName);
        for (Method method : list) {
            if (method.isAbstract()) continue;
            bytecodes = method.bytecodes();
            break;
        }
        StringBuffer line = new StringBuffer(80);
        line.append("0000: ");
        for (int i = 0; i < bytecodes.length; ++i) {
            int val;
            String str;
            if (i > 0 && i % 16 == 0) {
                MessageOutput.printDirectln(line.toString());
                line.setLength(0);
                line.append(String.valueOf(i));
                line.append(": ");
                int len = line.length();
                for (int j = 0; j < 6 - len; ++j) {
                    line.insert(0, '0');
                }
            }
            if ((str = Integer.toHexString(val = 0xFF & bytecodes[i])).length() == 1) {
                line.append('0');
            }
            line.append(str);
            line.append(' ');
        }
        if (line.length() > 6) {
            MessageOutput.printDirectln(line.toString());
        }
    }

    void commandExclude(StringTokenizer t) {
        if (!t.hasMoreTokens()) {
            MessageOutput.printDirectln(Env.excludesString());
        } else {
            String rest = t.nextToken("");
            if (rest.equals("none")) {
                rest = "";
            }
            Env.setExcludes(rest);
        }
    }

    void commandRedefine(StringTokenizer t) {
        if (!t.hasMoreTokens()) {
            MessageOutput.println("Specify classes to redefine");
        } else {
            String className = t.nextToken();
            List<ReferenceType> classes = Env.vm().classesByName(className);
            if (classes.size() == 0) {
                MessageOutput.println("No class named", className);
                return;
            }
            if (classes.size() > 1) {
                MessageOutput.println("More than one class named", className);
                return;
            }
            Env.setSourcePath(Env.getSourcePath());
            ReferenceType refType = classes.get(0);
            if (!t.hasMoreTokens()) {
                MessageOutput.println("Specify file name for class", className);
                return;
            }
            String fileName = t.nextToken();
            File phyl = new File(fileName);
            byte[] bytes = new byte[(int)phyl.length()];
            try {
                FileInputStream in = new FileInputStream(phyl);
                ((InputStream)in).read(bytes);
                ((InputStream)in).close();
            }
            catch (Exception exc) {
                MessageOutput.println("Error reading file", new Object[]{fileName, exc.toString()});
                return;
            }
            HashMap<ReferenceType, byte[]> map = new HashMap<ReferenceType, byte[]>();
            map.put(refType, bytes);
            try {
                Env.vm().redefineClasses(map);
            }
            catch (Throwable exc) {
                MessageOutput.println("Error redefining class to file", new Object[]{className, fileName, exc});
            }
        }
    }

    void commandPopFrames(StringTokenizer t, boolean reenter) {
        ThreadInfo threadInfo;
        if (t.hasMoreTokens()) {
            String token = t.nextToken();
            threadInfo = this.doGetThread(token);
            if (threadInfo == null) {
                return;
            }
        } else {
            threadInfo = ThreadInfo.getCurrentThreadInfo();
            if (threadInfo == null) {
                MessageOutput.println("No thread specified.");
                return;
            }
        }
        try {
            StackFrame frame = threadInfo.getCurrentFrame();
            threadInfo.getThread().popFrames(frame);
            threadInfo = ThreadInfo.getCurrentThreadInfo();
            ThreadInfo.setCurrentThreadInfo(threadInfo);
            if (reenter) {
                this.commandStepi();
            }
        }
        catch (Throwable exc) {
            MessageOutput.println("Error popping frame", exc.toString());
        }
    }

    void commandExtension(StringTokenizer t) {
        if (!t.hasMoreTokens()) {
            MessageOutput.println("No class specified.");
            return;
        }
        String idClass = t.nextToken();
        ReferenceType cls = Env.getReferenceTypeFromToken(idClass);
        String extension = null;
        if (cls != null) {
            try {
                extension = cls.sourceDebugExtension();
                MessageOutput.println("sourcedebugextension", extension);
            }
            catch (AbsentInformationException e) {
                MessageOutput.println("No sourcedebugextension specified");
            }
        } else {
            MessageOutput.println("is not a valid id or class name", idClass);
        }
    }

    void commandVersion(String debuggerName, VirtualMachineManager vmm) {
        MessageOutput.println("minus version", new Object[]{debuggerName, new Integer(vmm.majorInterfaceVersion()), new Integer(vmm.minorInterfaceVersion()), System.getProperty("java.version")});
        if (Env.connection() != null) {
            try {
                MessageOutput.printDirectln(Env.vm().description());
            }
            catch (VMNotConnectedException e) {
                MessageOutput.println("No VM connected");
            }
        }
    }

    abstract class AsyncExecution {
        abstract void action();

        AsyncExecution() {
            this.execute();
        }

        void execute() {
            final ThreadInfo threadInfo = ThreadInfo.getCurrentThreadInfo();
            final int stackFrame = threadInfo == null ? 0 : threadInfo.getCurrentFrameIndex();
            Thread thread = new Thread("asynchronous jdb command"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    block23: {
                        block19: {
                            AsyncExecution.this.action();
                            if (threadInfo == null) break block19;
                            ThreadInfo.setCurrentThreadInfo(threadInfo);
                            try {
                                threadInfo.setCurrentFrameIndex(stackFrame);
                            }
                            catch (IncompatibleThreadStateException e) {
                                MessageOutput.println("Current thread isnt suspended.");
                            }
                            catch (ArrayIndexOutOfBoundsException e) {
                                MessageOutput.println("Requested stack frame is no longer active:", new Object[]{new Integer(stackFrame)});
                            }
                        }
                        MessageOutput.printPrompt();
                        break block23;
                        catch (UnsupportedOperationException uoe) {
                            block20: {
                                MessageOutput.println("Operation is not supported on the target VM");
                                if (threadInfo == null) break block20;
                                ThreadInfo.setCurrentThreadInfo(threadInfo);
                                try {
                                    threadInfo.setCurrentFrameIndex(stackFrame);
                                }
                                catch (IncompatibleThreadStateException e) {
                                    MessageOutput.println("Current thread isnt suspended.");
                                }
                                catch (ArrayIndexOutOfBoundsException e) {
                                    MessageOutput.println("Requested stack frame is no longer active:", new Object[]{new Integer(stackFrame)});
                                }
                            }
                            MessageOutput.printPrompt();
                        }
                        catch (Exception e) {
                            block21: {
                                MessageOutput.println("Internal exception during operation:", e.getMessage());
                                if (threadInfo == null) break block21;
                                {
                                    catch (Throwable throwable) {
                                        if (threadInfo != null) {
                                            ThreadInfo.setCurrentThreadInfo(threadInfo);
                                            try {
                                                threadInfo.setCurrentFrameIndex(stackFrame);
                                            }
                                            catch (IncompatibleThreadStateException e2) {
                                                MessageOutput.println("Current thread isnt suspended.");
                                            }
                                            catch (ArrayIndexOutOfBoundsException e3) {
                                                MessageOutput.println("Requested stack frame is no longer active:", new Object[]{new Integer(stackFrame)});
                                            }
                                        }
                                        MessageOutput.printPrompt();
                                        throw throwable;
                                    }
                                }
                                ThreadInfo.setCurrentThreadInfo(threadInfo);
                                try {
                                    threadInfo.setCurrentFrameIndex(stackFrame);
                                }
                                catch (IncompatibleThreadStateException e4) {
                                    MessageOutput.println("Current thread isnt suspended.");
                                }
                                catch (ArrayIndexOutOfBoundsException e5) {
                                    MessageOutput.println("Requested stack frame is no longer active:", new Object[]{new Integer(stackFrame)});
                                }
                            }
                            MessageOutput.printPrompt();
                        }
                    }
                }
            };
            thread.start();
        }
    }
}

