/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.bdi.NoSessionException;
import com.sun.tools.example.debug.bdi.SessionListener;
import com.sun.tools.example.debug.event.JDIAdapter;
import com.sun.tools.example.debug.event.JDIListener;
import com.sun.tools.example.debug.event.ThreadDeathEventSet;
import com.sun.tools.example.debug.event.ThreadStartEventSet;
import com.sun.tools.example.debug.event.VMDisconnectEventSet;
import com.sun.tools.example.debug.gui.ClassManager;
import com.sun.tools.example.debug.gui.CommandInterpreter;
import com.sun.tools.example.debug.gui.Environment;
import com.sun.tools.example.debug.gui.SearchPath;
import com.sun.tools.example.debug.gui.SingleLeafTreeSelectionModel;
import com.sun.tools.example.debug.gui.SourceManager;
import java.awt.BorderLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadTreeTool
extends JPanel {
    private Environment env;
    private ExecutionManager runtime;
    private SourceManager sourceManager;
    private ClassManager classManager;
    private JTree tree;
    private DefaultTreeModel treeModel;
    private ThreadTreeNode root;
    private SearchPath sourcePath;
    private CommandInterpreter interpreter;
    private static String HEADING = "THREADS";
    HashMap<ThreadReference, List<String>> threadTable = new HashMap();

    public ThreadTreeTool(Environment env) {
        super(new BorderLayout());
        this.env = env;
        this.runtime = env.getExecutionManager();
        this.sourceManager = env.getSourceManager();
        this.interpreter = new CommandInterpreter(env);
        this.root = this.createThreadTree(HEADING);
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.treeModel);
        this.tree.setSelectionModel(new SingleLeafTreeSelectionModel());
        MouseAdapter ml = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ThreadTreeNode node;
                int selRow = ThreadTreeTool.this.tree.getRowForLocation(e.getX(), e.getY());
                TreePath selPath = ThreadTreeTool.this.tree.getPathForLocation(e.getX(), e.getY());
                if (selRow != -1 && e.getClickCount() == 1 && (node = (ThreadTreeNode)selPath.getLastPathComponent()).isLeaf()) {
                    ThreadTreeTool.this.tree.setSelectionPath(selPath);
                    ThreadTreeTool.this.interpreter.executeCommand("thread " + node.getThreadId() + "  (\"" + node.getName() + "\")");
                }
            }
        };
        this.tree.addMouseListener(ml);
        JScrollPane treeView = new JScrollPane(this.tree);
        this.add(treeView);
        ThreadTreeToolListener listener = new ThreadTreeToolListener();
        this.runtime.addJDIListener(listener);
        this.runtime.addSessionListener(listener);
    }

    private List<String> threadPath(ThreadReference thread) {
        ArrayList<String> l = new ArrayList<String>();
        l.add(0, thread.name());
        for (ThreadGroupReference group = thread.threadGroup(); group != null; group = group.parent()) {
            l.add(0, group.name());
        }
        return l;
    }

    ThreadTreeNode createThreadTree(String label) {
        return new ThreadTreeNode(label, null);
    }

    class ThreadTreeNode
    extends DefaultMutableTreeNode {
        String name;
        ThreadReference thread;
        long uid;
        String description;

        ThreadTreeNode(String name, ThreadReference thread) {
            if (name == null) {
                name = "<unnamed>";
            }
            this.name = name;
            this.thread = thread;
            if (thread == null) {
                this.uid = -1L;
                this.description = name;
            } else {
                this.uid = thread.uniqueID();
                this.description = name + " (t@" + Long.toHexString(this.uid) + ")";
            }
        }

        public String toString() {
            return this.description;
        }

        public String getName() {
            return this.name;
        }

        public ThreadReference getThread() {
            return this.thread;
        }

        public String getThreadId() {
            return "t@" + Long.toHexString(this.uid);
        }

        private boolean isThreadGroup() {
            return this.thread == null;
        }

        public boolean isLeaf() {
            return !this.isThreadGroup();
        }

        public void addThread(ThreadReference thread) {
            if (ThreadTreeTool.this.threadTable.get(thread) == null) {
                try {
                    List path = ThreadTreeTool.this.threadPath(thread);
                    try {
                        ThreadTreeTool.this.threadTable.put(thread, path);
                        this.addThread(path, thread);
                    }
                    catch (Throwable tt) {
                        throw new RuntimeException("ThreadTree corrupted");
                    }
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
        }

        private void addThread(List threadPath, ThreadReference thread) {
            int size = threadPath.size();
            if (size == 0) {
                return;
            }
            if (size == 1) {
                String name = (String)threadPath.get(0);
                this.insertNode(name, thread);
            } else {
                String head = (String)threadPath.get(0);
                List tail = threadPath.subList(1, size);
                ThreadTreeNode child = this.insertNode(head, null);
                child.addThread(tail, thread);
            }
        }

        private ThreadTreeNode insertNode(String name, ThreadReference thread) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                ThreadTreeNode child = (ThreadTreeNode)this.getChildAt(i);
                int cmp = name.compareTo(child.getName());
                if (cmp == 0 && thread == null) {
                    return child;
                }
                if (cmp >= 0) continue;
                ThreadTreeNode newChild = new ThreadTreeNode(name, thread);
                ThreadTreeTool.this.treeModel.insertNodeInto(newChild, this, i);
                return newChild;
            }
            ThreadTreeNode newChild = new ThreadTreeNode(name, thread);
            ThreadTreeTool.this.treeModel.insertNodeInto(newChild, this, this.getChildCount());
            return newChild;
        }

        public void removeThread(ThreadReference thread) {
            List<String> threadPath = ThreadTreeTool.this.threadTable.get(thread);
            if (threadPath != null) {
                this.removeThread(threadPath, thread);
            }
        }

        private void removeThread(List threadPath, ThreadReference thread) {
            int size = threadPath.size();
            if (size == 0) {
                return;
            }
            if (size == 1) {
                String name = (String)threadPath.get(0);
                ThreadTreeNode child = this.findLeafNode(thread, name);
                ThreadTreeTool.this.treeModel.removeNodeFromParent(child);
            } else {
                String head = (String)threadPath.get(0);
                List tail = threadPath.subList(1, size);
                ThreadTreeNode child = this.findInternalNode(head);
                child.removeThread(tail, thread);
                if (child.isThreadGroup() && child.getChildCount() < 1) {
                    ThreadTreeTool.this.treeModel.removeNodeFromParent(child);
                }
            }
        }

        private ThreadTreeNode findLeafNode(ThreadReference thread, String name) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                ThreadTreeNode child = (ThreadTreeNode)this.getChildAt(i);
                if (child.getThread() != thread) continue;
                if (!name.equals(child.getName())) {
                    throw new RuntimeException("name mismatch");
                }
                return child;
            }
            throw new RuntimeException("not found");
        }

        private ThreadTreeNode findInternalNode(String name) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                ThreadTreeNode child = (ThreadTreeNode)this.getChildAt(i);
                if (!name.equals(child.getName())) continue;
                return child;
            }
            throw new RuntimeException("not found");
        }
    }

    private class ThreadTreeToolListener
    extends JDIAdapter
    implements JDIListener,
    SessionListener {
        private ThreadTreeToolListener() {
        }

        public void sessionStart(EventObject e) {
            try {
                for (ThreadReference thread : ThreadTreeTool.this.runtime.allThreads()) {
                    ThreadTreeTool.this.root.addThread(thread);
                }
            }
            catch (VMDisconnectedException ee) {
            }
            catch (NoSessionException noSessionException) {
                // empty catch block
            }
        }

        public void sessionInterrupt(EventObject e) {
        }

        public void sessionContinue(EventObject e) {
        }

        public void threadStart(ThreadStartEventSet e) {
            ThreadTreeTool.this.root.addThread(e.getThread());
        }

        public void threadDeath(ThreadDeathEventSet e) {
            ThreadTreeTool.this.root.removeThread(e.getThread());
        }

        public void vmDisconnect(VMDisconnectEventSet e) {
            ThreadTreeTool.this.root = ThreadTreeTool.this.createThreadTree(HEADING);
            ThreadTreeTool.this.treeModel = new DefaultTreeModel(ThreadTreeTool.this.root);
            ThreadTreeTool.this.tree.setModel(ThreadTreeTool.this.treeModel);
            ThreadTreeTool.this.threadTable = new HashMap();
        }
    }
}

