/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.StackFrame;
import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.bdi.ThreadInfo;
import com.sun.tools.example.debug.bdi.VMNotInterruptedException;
import com.sun.tools.example.debug.gui.ContextListener;
import com.sun.tools.example.debug.gui.ContextManager;
import com.sun.tools.example.debug.gui.CurrentFrameChangedEvent;
import com.sun.tools.example.debug.gui.Environment;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class StackTraceTool
extends JPanel {
    private Environment env;
    private ExecutionManager runtime;
    private ContextManager context;
    private ThreadInfo tinfo;
    private JList list;
    private ListModel stackModel;

    public StackTraceTool(Environment env) {
        super(new BorderLayout());
        this.env = env;
        this.runtime = env.getExecutionManager();
        this.context = env.getContextManager();
        this.stackModel = new DefaultListModel();
        this.list = new JList(this.stackModel);
        this.list.setCellRenderer(new StackFrameRenderer());
        JScrollPane listView = new JScrollPane(this.list);
        this.add(listView);
        StackTraceToolListener listener = new StackTraceToolListener();
        this.context.addContextListener(listener);
        this.list.addListSelectionListener(listener);
    }

    private void showStack(ThreadInfo tinfo, int selectFrame) {
        StackTraceListModel model = new StackTraceListModel(tinfo);
        this.stackModel = model;
        this.list.setModel(this.stackModel);
        this.list.setSelectedIndex(selectFrame);
        this.list.ensureIndexIsVisible(selectFrame);
    }

    private static class StackTraceListModel
    extends AbstractListModel {
        private final ThreadInfo tinfo;

        public StackTraceListModel(ThreadInfo tinfo) {
            this.tinfo = tinfo;
        }

        public Object getElementAt(int index) {
            try {
                return this.tinfo == null ? null : this.tinfo.getFrame(index);
            }
            catch (VMNotInterruptedException e) {
                return null;
            }
        }

        public int getSize() {
            try {
                return this.tinfo == null ? 1 : this.tinfo.getFrameCount();
            }
            catch (VMNotInterruptedException e) {
                return 0;
            }
        }
    }

    private class StackFrameRenderer
    extends DefaultListCellRenderer {
        private StackFrameRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                this.setText("<unavailable>");
            } else {
                StackFrame frame = (StackFrame)value;
                Location loc = frame.location();
                Method meth = loc.method();
                String methName = meth.declaringType().name() + '.' + meth.name();
                String position = "";
                if (meth instanceof Method && meth.isNative()) {
                    position = " (native method)";
                } else if (loc.lineNumber() != -1) {
                    position = ":" + loc.lineNumber();
                } else {
                    long pc = loc.codeIndex();
                    if (pc != -1L) {
                        position = ", pc = " + pc;
                    }
                }
                this.setText("[" + (index + 1) + "] " + methName + position);
            }
            return this;
        }
    }

    private class StackTraceToolListener
    implements ContextListener,
    ListSelectionListener {
        private StackTraceToolListener() {
        }

        public void currentFrameChanged(CurrentFrameChangedEvent e) {
            int frameIndex = e.getIndex();
            ThreadInfo ti = e.getThreadInfo();
            if (e.getInvalidate() || StackTraceTool.this.tinfo != ti) {
                StackTraceTool.this.tinfo = ti;
                StackTraceTool.this.showStack(ti, frameIndex);
            } else if (frameIndex < StackTraceTool.this.stackModel.getSize()) {
                StackTraceTool.this.list.setSelectedIndex(frameIndex);
                StackTraceTool.this.list.ensureIndexIsVisible(frameIndex);
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            int index = StackTraceTool.this.list.getSelectedIndex();
            if (index != -1) {
                try {
                    StackTraceTool.this.context.setCurrentFrameIndex(index);
                }
                catch (VMNotInterruptedException vMNotInterruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

