/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.gui.ClassManager;
import com.sun.tools.example.debug.gui.CommandInterpreter;
import com.sun.tools.example.debug.gui.Environment;
import com.sun.tools.example.debug.gui.SearchPath;
import com.sun.tools.example.debug.gui.SingleLeafTreeSelectionModel;
import com.sun.tools.example.debug.gui.SourceListener;
import com.sun.tools.example.debug.gui.SourceManager;
import com.sun.tools.example.debug.gui.SourcepathChangedEvent;
import java.awt.BorderLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SourceTreeTool
extends JPanel {
    private Environment env;
    private ExecutionManager runtime;
    private SourceManager sourceManager;
    private ClassManager classManager;
    private JTree tree;
    private SourceTreeNode root;
    private SearchPath sourcePath;
    private CommandInterpreter interpreter;
    private static String HEADING = "SOURCES";
    private static FilenameFilter filter = new SourceOrDirectoryFilter();

    public SourceTreeTool(Environment env) {
        super(new BorderLayout());
        this.env = env;
        this.runtime = env.getExecutionManager();
        this.sourceManager = env.getSourceManager();
        this.interpreter = new CommandInterpreter(env);
        this.sourcePath = this.sourceManager.getSourcePath();
        this.root = this.createDirectoryTree(HEADING);
        this.tree = new JTree(new DefaultTreeModel(this.root));
        this.tree.setSelectionModel(new SingleLeafTreeSelectionModel());
        MouseAdapter ml = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                SourceTreeNode node;
                int selRow = SourceTreeTool.this.tree.getRowForLocation(e.getX(), e.getY());
                TreePath selPath = SourceTreeTool.this.tree.getPathForLocation(e.getX(), e.getY());
                if (selRow != -1 && e.getClickCount() == 1 && (node = (SourceTreeNode)selPath.getLastPathComponent()).isLeaf()) {
                    SourceTreeTool.this.tree.setSelectionPath(selPath);
                    SourceTreeTool.this.interpreter.executeCommand("view " + node.getRelativePath());
                }
            }
        };
        this.tree.addMouseListener(ml);
        JScrollPane treeView = new JScrollPane(this.tree);
        this.add(treeView);
        SourceTreeToolListener listener = new SourceTreeToolListener();
        this.sourceManager.addSourceListener(listener);
    }

    SourceTreeNode createDirectoryTree(String label) {
        try {
            return new SourceTreeNode(label, null, "", true);
        }
        catch (SecurityException e) {
            this.env.failure("Cannot access source file or directory");
            return null;
        }
    }

    class SourceTreeNode
    implements TreeNode {
        private String name;
        private boolean isDirectory;
        private SourceTreeNode parent;
        private SourceTreeNode[] children;
        private String relativePath;
        private boolean isExpanded;

        private SourceTreeNode(String label, SourceTreeNode parent, String relativePath, boolean isDirectory) {
            this.name = label;
            this.relativePath = relativePath;
            this.parent = parent;
            this.isDirectory = isDirectory;
        }

        public String toString() {
            return this.name;
        }

        public String getRelativePath() {
            return this.relativePath;
        }

        private void expandIfNeeded() {
            try {
                if (!this.isExpanded && this.isDirectory) {
                    String[] files = SourceTreeTool.this.sourcePath.children(this.relativePath, filter);
                    this.children = new SourceTreeNode[files.length];
                    for (int i = 0; i < files.length; ++i) {
                        String childName = this.relativePath.equals("") ? files[i] : this.relativePath + File.separator + files[i];
                        File file = SourceTreeTool.this.sourcePath.resolve(childName);
                        boolean isDir = file != null && file.isDirectory();
                        this.children[i] = new SourceTreeNode(files[i], this, childName, isDir);
                    }
                }
                this.isExpanded = true;
            }
            catch (SecurityException e) {
                this.children = null;
                SourceTreeTool.this.env.failure("Cannot access source file or directory");
            }
        }

        public TreeNode getChildAt(int childIndex) {
            this.expandIfNeeded();
            return this.children[childIndex];
        }

        public int getChildCount() {
            this.expandIfNeeded();
            return this.children.length;
        }

        public TreeNode getParent() {
            return this.parent;
        }

        public int getIndex(TreeNode node) {
            this.expandIfNeeded();
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] != node) continue;
                return i;
            }
            return -1;
        }

        public boolean getAllowsChildren() {
            return this.isDirectory;
        }

        public boolean isLeaf() {
            this.expandIfNeeded();
            return !this.isDirectory;
        }

        public Enumeration children() {
            this.expandIfNeeded();
            return new Enumeration(){
                int i = 0;

                public boolean hasMoreElements() {
                    return this.i < SourceTreeNode.this.children.length;
                }

                public Object nextElement() throws NoSuchElementException {
                    if (this.i >= SourceTreeNode.this.children.length) {
                        throw new NoSuchElementException();
                    }
                    return SourceTreeNode.this.children[this.i++];
                }
            };
        }
    }

    private static class SourceOrDirectoryFilter
    implements FilenameFilter {
        private SourceOrDirectoryFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".java") || new File(dir, name).isDirectory();
        }
    }

    private class SourceTreeToolListener
    implements SourceListener {
        private SourceTreeToolListener() {
        }

        public void sourcepathChanged(SourcepathChangedEvent e) {
            SourceTreeTool.this.sourcePath = SourceTreeTool.this.sourceManager.getSourcePath();
            SourceTreeTool.this.root = SourceTreeTool.this.createDirectoryTree(HEADING);
            SourceTreeTool.this.tree.setModel(new DefaultTreeModel(SourceTreeTool.this.root));
        }
    }
}

