/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.bdi.SpecErrorEvent;
import com.sun.tools.example.debug.bdi.SpecEvent;
import com.sun.tools.example.debug.bdi.SpecListener;
import com.sun.tools.example.debug.gui.CommandInterpreter;
import com.sun.tools.example.debug.gui.ContextListener;
import com.sun.tools.example.debug.gui.ContextManager;
import com.sun.tools.example.debug.gui.CurrentFrameChangedEvent;
import com.sun.tools.example.debug.gui.Environment;
import com.sun.tools.example.debug.gui.Icons;
import com.sun.tools.example.debug.gui.SearchPath;
import com.sun.tools.example.debug.gui.SourceListener;
import com.sun.tools.example.debug.gui.SourceManager;
import com.sun.tools.example.debug.gui.SourceModel;
import com.sun.tools.example.debug.gui.SourcepathChangedEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListModel;

public class SourceTool
extends JPanel {
    private Environment env;
    private ExecutionManager runtime;
    private ContextManager context;
    private SourceManager sourceManager;
    private JList list;
    private ListModel sourceModel;
    private String sourceName;
    private Location sourceLocn;
    private CommandInterpreter interpreter;

    public SourceTool(Environment env) {
        super(new BorderLayout());
        this.env = env;
        this.runtime = env.getExecutionManager();
        this.sourceManager = env.getSourceManager();
        this.context = env.getContextManager();
        this.interpreter = new CommandInterpreter(env, true);
        this.sourceModel = new DefaultListModel();
        this.list = new JList(this.sourceModel);
        this.list.setCellRenderer(new SourceLineRenderer());
        this.list.setPrototypeCellValue(SourceModel.prototypeCellValue);
        SourceToolListener listener = new SourceToolListener();
        this.context.addContextListener(listener);
        this.runtime.addSpecListener(listener);
        this.sourceManager.addSourceListener(listener);
        STMouseListener squeek = new STMouseListener();
        this.list.addMouseListener(squeek);
        this.add(new JScrollPane(this.list));
    }

    public void setTextFont(Font f) {
        this.list.setFont(f);
        this.list.setPrototypeCellValue(SourceModel.prototypeCellValue);
    }

    private void showSourceContext(ThreadReference thread, int index) {
        StackFrame frame = null;
        if (thread != null) {
            try {
                frame = thread.frame(index);
            }
            catch (IncompatibleThreadStateException e) {
                // empty catch block
            }
        }
        if (frame == null) {
            return;
        }
        Location locn = frame.location();
        this.showSourceForLocation(locn);
    }

    public boolean showSourceForLocation(Location locn) {
        SourceModel source;
        this.sourceName = null;
        this.sourceLocn = locn;
        int lineNo = locn.lineNumber();
        if (lineNo != -1 && (source = this.sourceManager.sourceForLocation(locn)) != null) {
            this.showSourceAtLine(source, lineNo - 1);
            return true;
        }
        this.showSourceUnavailable();
        return false;
    }

    public boolean showSourceFile(String fileName) {
        SourceModel source;
        File file;
        this.sourceLocn = null;
        if (!fileName.startsWith(File.separator)) {
            this.sourceName = fileName;
            SearchPath sourcePath = this.sourceManager.getSourcePath();
            file = sourcePath.resolve(fileName);
            if (file == null) {
                this.showSourceUnavailable();
                return false;
            }
        } else {
            this.sourceName = null;
            file = new File(fileName);
        }
        if ((source = this.sourceManager.sourceForFile(file)) != null) {
            this.showSource(source);
            return true;
        }
        this.showSourceUnavailable();
        return false;
    }

    private void showSource(SourceModel model) {
        this.setViewModel(model);
    }

    private void showSourceAtLine(SourceModel model, int lineNo) {
        this.setViewModel(model);
        if (model.isActuallySource && lineNo < model.getSize()) {
            this.list.setSelectedIndex(lineNo);
            if (lineNo + 4 < model.getSize()) {
                this.list.ensureIndexIsVisible(lineNo + 4);
            }
            this.list.ensureIndexIsVisible(lineNo);
        }
    }

    private void showSourceUnavailable() {
        SourceModel model = new SourceModel("[Source code is not available]");
        this.setViewModel(model);
    }

    private void setViewModel(SourceModel model) {
        if (model != this.sourceModel) {
            this.list.setModel(model);
            this.sourceModel = model;
        }
    }

    private class STMouseListener
    extends MouseAdapter
    implements MouseListener {
        private STMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopupMenu((Component)e.getSource(), e.getX(), e.getY());
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopupMenu((Component)e.getSource(), e.getX(), e.getY());
            }
        }

        private void showPopupMenu(Component invoker, int x, int y) {
            JList list = (JList)invoker;
            int ln = list.getSelectedIndex() + 1;
            SourceModel.Line line = (SourceModel.Line)list.getSelectedValue();
            JPopupMenu popup = new JPopupMenu();
            if (line == null) {
                popup.add(new JMenuItem("please select a line"));
            } else if (line.isExecutable()) {
                String className = line.refType.name();
                if (line.hasBreakpoint()) {
                    popup.add(this.commandItem("Clear Breakpoint", "clear " + className + ":" + ln));
                } else {
                    popup.add(this.commandItem("Set Breakpoint", "stop at " + className + ":" + ln));
                }
            } else {
                popup.add(new JMenuItem("not an executable line"));
            }
            popup.show(invoker, x + popup.getWidth() / 2, y + popup.getHeight() / 2);
        }

        private JMenuItem commandItem(String label, final String cmd) {
            JMenuItem item = new JMenuItem(label);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    SourceTool.this.interpreter.executeCommand(cmd);
                }
            });
            return item;
        }
    }

    private class SourceLineRenderer
    extends DefaultListCellRenderer {
        private SourceLineRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            SourceModel.Line line = (SourceModel.Line)value;
            this.setText(line.text);
            if (line.hasBreakpoint) {
                this.setIcon(Icons.stopSignIcon);
            } else if (line.isExecutable()) {
                this.setIcon(Icons.execIcon);
            } else {
                this.setIcon(Icons.blankIcon);
            }
            return this;
        }

        public Dimension getPreferredSize() {
            Dimension dim = super.getPreferredSize();
            return new Dimension(dim.width, dim.height - 5);
        }
    }

    private class SourceToolListener
    implements ContextListener,
    SourceListener,
    SpecListener {
        private SourceToolListener() {
        }

        public void currentFrameChanged(CurrentFrameChangedEvent e) {
            SourceTool.this.showSourceContext(e.getThread(), e.getIndex());
        }

        public void sourcepathChanged(SourcepathChangedEvent e) {
            if (SourceTool.this.sourceName != null) {
                SourceTool.this.showSourceFile(SourceTool.this.sourceName);
            } else if (SourceTool.this.sourceLocn != null) {
                SourceTool.this.showSourceForLocation(SourceTool.this.sourceLocn);
            }
        }

        public void breakpointSet(SpecEvent e) {
            this.breakpointResolved(e);
        }

        public void breakpointDeferred(SpecEvent e) {
        }

        public void breakpointDeleted(SpecEvent e) {
            BreakpointRequest req = (BreakpointRequest)e.getEventRequest();
            Location loc = req.location();
            if (loc != null) {
                try {
                    SourceModel sm = SourceTool.this.sourceManager.sourceForLocation(loc);
                    sm.showBreakpoint(loc.lineNumber(), false);
                    SourceTool.this.showSourceForLocation(loc);
                }
                catch (Exception exc) {
                    // empty catch block
                }
            }
        }

        public void breakpointResolved(SpecEvent e) {
            BreakpointRequest req = (BreakpointRequest)e.getEventRequest();
            Location loc = req.location();
            try {
                SourceModel sm = SourceTool.this.sourceManager.sourceForLocation(loc);
                sm.showBreakpoint(loc.lineNumber(), true);
                SourceTool.this.showSourceForLocation(loc);
            }
            catch (Exception exc) {
                // empty catch block
            }
        }

        public void breakpointError(SpecErrorEvent e) {
            this.breakpointDeleted(e);
        }

        public void watchpointSet(SpecEvent e) {
        }

        public void watchpointDeferred(SpecEvent e) {
        }

        public void watchpointDeleted(SpecEvent e) {
        }

        public void watchpointResolved(SpecEvent e) {
        }

        public void watchpointError(SpecErrorEvent e) {
        }

        public void exceptionInterceptSet(SpecEvent e) {
        }

        public void exceptionInterceptDeferred(SpecEvent e) {
        }

        public void exceptionInterceptDeleted(SpecEvent e) {
        }

        public void exceptionInterceptResolved(SpecEvent e) {
        }

        public void exceptionInterceptError(SpecErrorEvent e) {
        }
    }
}

