/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.tools.example.debug.event.ClassPrepareEventSet;
import com.sun.tools.example.debug.event.ClassUnloadEventSet;
import com.sun.tools.example.debug.event.JDIAdapter;
import com.sun.tools.example.debug.event.JDIListener;
import com.sun.tools.example.debug.gui.Environment;
import com.sun.tools.example.debug.gui.SearchPath;
import com.sun.tools.example.debug.gui.SourceListener;
import com.sun.tools.example.debug.gui.SourceModel;
import com.sun.tools.example.debug.gui.SourcepathChangedEvent;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class SourceManager {
    private List<SourceModel> sourceList;
    private SearchPath sourcePath;
    private Vector<SourceListener> sourceListeners = new Vector();
    private Map<ReferenceType, SourceModel> classToSource = new HashMap<ReferenceType, SourceModel>();
    private Environment env;
    private SMClassListener classListener = new SMClassListener();

    public SourceManager(Environment env) {
        this(env, new SearchPath(""));
    }

    public SourceManager(Environment env, SearchPath sourcePath) {
        this.env = env;
        this.sourceList = new LinkedList<SourceModel>();
        this.sourcePath = sourcePath;
        env.getExecutionManager().addJDIListener(this.classListener);
    }

    public void setSourcePath(SearchPath sp) {
        this.sourcePath = sp;
        this.sourceList = new LinkedList<SourceModel>();
        this.notifySourcepathChanged();
        this.classToSource = new HashMap<ReferenceType, SourceModel>();
    }

    public void addSourceListener(SourceListener l) {
        this.sourceListeners.addElement(l);
    }

    public void removeSourceListener(SourceListener l) {
        this.sourceListeners.removeElement(l);
    }

    private void notifySourcepathChanged() {
        Vector l = (Vector)this.sourceListeners.clone();
        SourcepathChangedEvent evt = new SourcepathChangedEvent(this);
        for (int i = 0; i < l.size(); ++i) {
            ((SourceListener)l.elementAt(i)).sourcepathChanged(evt);
        }
    }

    public SearchPath getSourcePath() {
        return this.sourcePath;
    }

    public SourceModel sourceForLocation(Location loc) {
        return this.sourceForClass(loc.declaringType());
    }

    public SourceModel sourceForClass(ReferenceType refType) {
        SourceModel sm = this.classToSource.get(refType);
        if (sm != null) {
            return sm;
        }
        try {
            String filename = refType.sourceName();
            String refName = refType.name();
            int iDot = refName.lastIndexOf(46);
            String pkgName = iDot >= 0 ? refName.substring(0, iDot + 1) : "";
            String full = pkgName.replace('.', File.separatorChar) + filename;
            File path = this.sourcePath.resolve(full);
            if (path != null) {
                sm = this.sourceForFile(path);
                this.classToSource.put(refType, sm);
                return sm;
            }
            return null;
        }
        catch (AbsentInformationException e) {
            return null;
        }
    }

    public SourceModel sourceForFile(File path) {
        Iterator<SourceModel> iter = this.sourceList.iterator();
        SourceModel sm = null;
        while (iter.hasNext()) {
            SourceModel candidate = iter.next();
            if (!candidate.fileName().equals(path)) continue;
            sm = candidate;
            iter.remove();
            break;
        }
        if (sm == null && path.exists()) {
            sm = new SourceModel(this.env, path);
        }
        if (sm != null) {
            this.sourceList.add(0, sm);
        }
        return sm;
    }

    private class SMClassListener
    extends JDIAdapter
    implements JDIListener {
        private SMClassListener() {
        }

        public void classPrepare(ClassPrepareEventSet e) {
            ReferenceType refType = e.getReferenceType();
            SourceModel sm = SourceManager.this.sourceForClass(refType);
            if (sm != null) {
                sm.addClass(refType);
            }
        }

        public void classUnload(ClassUnloadEventSet e) {
        }
    }
}

