/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.bdi.VMNotInterruptedException;
import com.sun.tools.example.debug.expr.ExpressionParser;
import com.sun.tools.example.debug.expr.ParseException;
import com.sun.tools.example.debug.gui.ContextManager;
import com.sun.tools.example.debug.gui.Environment;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MonitorTool
extends JPanel {
    private ExecutionManager runtime;
    private ContextManager context;
    private JList list;

    public MonitorTool(Environment env) {
        super(new BorderLayout());
        this.runtime = env.getExecutionManager();
        this.context = env.getContextManager();
        this.list = new JList(env.getMonitorListModel());
        this.list.setCellRenderer(new MonitorRenderer());
        JScrollPane listView = new JScrollPane(this.list);
        this.add(listView);
        MonitorToolListener listener = new MonitorToolListener();
        this.list.addListSelectionListener(listener);
    }

    private Value evaluate(String expr) throws ParseException, InvocationException, InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException {
        ExpressionParser.GetFrame frameGetter = new ExpressionParser.GetFrame(){

            public StackFrame get() throws IncompatibleThreadStateException {
                try {
                    return MonitorTool.this.context.getCurrentFrame();
                }
                catch (VMNotInterruptedException exc) {
                    throw new IncompatibleThreadStateException();
                }
            }
        };
        return ExpressionParser.evaluate(expr, this.runtime.vm(), frameGetter);
    }

    private class MonitorRenderer
    extends DefaultListCellRenderer {
        private MonitorRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null) {
                this.setText("<unavailable>");
            } else {
                String expr = (String)value;
                try {
                    Value result = MonitorTool.this.evaluate(expr);
                    this.setText(expr + " = " + result);
                }
                catch (ParseException exc) {
                    this.setText(expr + " ? " + exc.getMessage());
                }
                catch (IncompatibleThreadStateException exc) {
                    this.setText(expr + " ...");
                }
                catch (Exception exc) {
                    this.setText(expr + " ? " + exc);
                }
            }
            return this;
        }
    }

    private class MonitorToolListener
    implements ListSelectionListener {
        private MonitorToolListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            int index = MonitorTool.this.list.getSelectedIndex();
            if (index != -1) {
                // empty if block
            }
        }
    }
}

