/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.tools.example.debug.gui.ContextListener;
import com.sun.tools.example.debug.gui.CurrentFrameChangedEvent;
import com.sun.tools.example.debug.gui.Environment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitorListModel
extends AbstractListModel {
    private final List<String> monitors = new ArrayList<String>();

    MonitorListModel(Environment env) {
        MonitorListListener listener = new MonitorListListener();
        env.getContextManager().addContextListener(listener);
    }

    @Override
    public Object getElementAt(int index) {
        return this.monitors.get(index);
    }

    @Override
    public int getSize() {
        return this.monitors.size();
    }

    public void add(String expr) {
        this.monitors.add(expr);
        int newIndex = this.monitors.size() - 1;
        this.fireIntervalAdded(this, newIndex, newIndex);
    }

    public void remove(String expr) {
        int index = this.monitors.indexOf(expr);
        this.remove(index);
    }

    public void remove(int index) {
        this.monitors.remove(index);
        this.fireIntervalRemoved(this, index, index);
    }

    public List<String> monitors() {
        return Collections.unmodifiableList(this.monitors);
    }

    public Iterator iterator() {
        return this.monitors().iterator();
    }

    private void invalidate() {
        this.fireContentsChanged(this, 0, this.monitors.size() - 1);
    }

    private class MonitorListListener
    implements ContextListener {
        private MonitorListListener() {
        }

        public void currentFrameChanged(CurrentFrameChangedEvent e) {
            MonitorListModel.this.invalidate();
        }
    }
}

