/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.Connector;
import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.bdi.VMLaunchFailureException;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

class LaunchTool {
    private final ExecutionManager runtime;

    private LaunchTool(ExecutionManager runtime) {
        this.runtime = runtime;
    }

    private Connector selectConnector() {
        final JDialog dialog = new JDialog();
        Container content = dialog.getContentPane();
        JPanel radioPanel = new JPanel();
        final ButtonGroup radioGroup = new ButtonGroup();
        VirtualMachineManager manager = Bootstrap.virtualMachineManager();
        List<Connector> all = manager.allConnectors();
        HashMap<ButtonModel, Connector> modelToConnector = new HashMap<ButtonModel, Connector>(all.size(), 0.5f);
        dialog.setModal(true);
        dialog.setTitle("Select Connector Type");
        radioPanel.setLayout(new BoxLayout(radioPanel, 1));
        for (Connector connector : all) {
            JRadioButton radio = new JRadioButton(connector.description());
            modelToConnector.put(radio.getModel(), connector);
            radioPanel.add(radio);
            radioGroup.add(radio);
        }
        content.add(radioPanel);
        final boolean[] oked = new boolean[]{false};
        JPanel buttonPanel = this.okCancel(dialog, new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (radioGroup.getSelection() == null) {
                    JOptionPane.showMessageDialog(dialog, "Please select a connector type", "No Selection", 0);
                } else {
                    oked[0] = true;
                    dialog.setVisible(false);
                    dialog.dispose();
                }
            }
        });
        content.add("South", buttonPanel);
        dialog.pack();
        dialog.show();
        return oked[0] ? (Connector)modelToConnector.get(radioGroup.getSelection()) : null;
    }

    private void configureAndConnect(final Connector connector) {
        final JDialog dialog = new JDialog();
        final Map<String, Connector.Argument> args = connector.defaultArguments();
        dialog.setModal(true);
        dialog.setTitle("Connector Arguments");
        Container content = dialog.getContentPane();
        JPanel guts = new JPanel();
        Border etched = BorderFactory.createEtchedBorder();
        TitledBorder titled = BorderFactory.createTitledBorder(etched, connector.description(), 1, 2);
        guts.setBorder(etched);
        guts.setLayout(new BoxLayout(guts, 1));
        final ArrayList<BooleanArgRep> argReps = new ArrayList<BooleanArgRep>(args.size());
        for (Connector.Argument arg : args.values()) {
            ArgRep ar = arg instanceof Connector.BooleanArgument ? new BooleanArgRep((Connector.BooleanArgument)arg, guts) : new StringArgRep(arg, guts);
            argReps.add((BooleanArgRep)ar);
        }
        content.add(guts);
        JPanel buttonPanel = this.okCancel(dialog, new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                for (ArgRep ar : argReps) {
                    if (!ar.isSpecified()) {
                        JOptionPane.showMessageDialog(dialog, ar.arg.label() + ": Argument must be specified", "No argument", 0);
                        return;
                    }
                    if (!ar.isValid()) {
                        JOptionPane.showMessageDialog(dialog, ar.arg.label() + ": Bad argument value: " + ar.getText(), "Bad argument", 0);
                        return;
                    }
                    ar.install();
                }
                try {
                    if (LaunchTool.this.runtime.explictStart(connector, args)) {
                        dialog.setVisible(false);
                        dialog.dispose();
                    } else {
                        JOptionPane.showMessageDialog(dialog, "Bad arguments values: See diagnostics window.", "Bad arguments", 0);
                    }
                }
                catch (VMLaunchFailureException exc) {
                    JOptionPane.showMessageDialog(dialog, "Launch Failure: " + exc, "Launch Failed", 0);
                }
            }
        });
        content.add("South", buttonPanel);
        dialog.pack();
        dialog.show();
    }

    private JPanel okCancel(final JDialog dialog, ActionListener okListener) {
        JPanel buttonPanel = new JPanel();
        JButton ok = new JButton("OK");
        JButton cancel = new JButton("Cancel");
        buttonPanel.add(ok);
        buttonPanel.add(cancel);
        ok.addActionListener(okListener);
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        return buttonPanel;
    }

    static void queryAndLaunchVM(ExecutionManager runtime) throws VMLaunchFailureException {
        LaunchTool lt = new LaunchTool(runtime);
        Connector connector = lt.selectConnector();
        if (connector != null) {
            lt.configureAndConnect(connector);
        }
    }

    private class BooleanArgRep
    extends ArgRep {
        final JCheckBox check;

        BooleanArgRep(Connector.BooleanArgument barg, JPanel comp) {
            super(barg);
            this.check = new JCheckBox(barg.label());
            this.check.setSelected(barg.booleanValue());
            this.panel.add(this.check);
            comp.add(this.panel);
        }

        String getText() {
            return ((Connector.BooleanArgument)this.arg).stringValueOf(this.check.getModel().isSelected());
        }
    }

    private class StringArgRep
    extends ArgRep {
        final JTextField textField;

        StringArgRep(Connector.Argument arg, JPanel comp) {
            super(arg);
            this.textField = new JTextField(arg.value(), 50);
            this.textField.setBorder(BorderFactory.createLoweredBevelBorder());
            this.panel.add(new JLabel(arg.label(), 4));
            this.panel.add(this.textField);
            comp.add(this.panel);
        }

        String getText() {
            return this.textField.getText();
        }
    }

    private abstract class ArgRep {
        final Connector.Argument arg;
        final JPanel panel;

        ArgRep(Connector.Argument arg) {
            this.arg = arg;
            this.panel = new JPanel();
            Border etched = BorderFactory.createEtchedBorder();
            TitledBorder titled = BorderFactory.createTitledBorder(etched, arg.description(), 1, 2);
            this.panel.setBorder(titled);
        }

        abstract String getText();

        boolean isValid() {
            return this.arg.isValid(this.getText());
        }

        boolean isSpecified() {
            String value = this.getText();
            return value != null && value.length() > 0 || !this.arg.mustSpecify();
        }

        void install() {
            this.arg.setValue(this.getText());
        }
    }
}

