/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.gui.ClassManager;
import com.sun.tools.example.debug.gui.CommandInterpreter;
import com.sun.tools.example.debug.gui.Environment;
import com.sun.tools.example.debug.gui.JDBFileFilter;
import com.sun.tools.example.debug.gui.SourceManager;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

class JDBMenuBar
extends JMenuBar {
    Environment env;
    ExecutionManager runtime;
    ClassManager classManager;
    SourceManager sourceManager;
    CommandInterpreter interpreter;

    JDBMenuBar(Environment env) {
        this.env = env;
        this.runtime = env.getExecutionManager();
        this.classManager = env.getClassManager();
        this.sourceManager = env.getSourceManager();
        this.interpreter = new CommandInterpreter(env, true);
        JMenu fileMenu = new JMenu("File");
        JMenuItem openItem = new JMenuItem("Open...", 79);
        openItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JDBMenuBar.this.openCommand();
            }
        });
        fileMenu.add(openItem);
        this.addTool(fileMenu, "Exit debugger", "Exit", "exit");
        JMenu cmdMenu = new JMenu("Commands");
        this.addTool(cmdMenu, "Step into next line", "Step", "step");
        this.addTool(cmdMenu, "Step over next line", "Next", "next");
        cmdMenu.addSeparator();
        this.addTool(cmdMenu, "Step into next instruction", "Step Instruction", "stepi");
        this.addTool(cmdMenu, "Step over next instruction", "Next Instruction", "nexti");
        cmdMenu.addSeparator();
        this.addTool(cmdMenu, "Step out of current method call", "Step Up", "step up");
        cmdMenu.addSeparator();
        this.addTool(cmdMenu, "Suspend execution", "Interrupt", "interrupt");
        this.addTool(cmdMenu, "Continue execution", "Continue", "cont");
        cmdMenu.addSeparator();
        this.addTool(cmdMenu, "Display current stack", "Where", "where");
        cmdMenu.addSeparator();
        this.addTool(cmdMenu, "Move up one stack frame", "Up", "up");
        this.addTool(cmdMenu, "Move down one stack frame", "Down", "down");
        cmdMenu.addSeparator();
        JMenuItem monitorItem = new JMenuItem("Monitor Expression...", 77);
        monitorItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JDBMenuBar.this.monitorCommand();
            }
        });
        cmdMenu.add(monitorItem);
        JMenuItem unmonitorItem = new JMenuItem("Unmonitor Expression...");
        unmonitorItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JDBMenuBar.this.unmonitorCommand();
            }
        });
        cmdMenu.add(unmonitorItem);
        JMenu breakpointMenu = new JMenu("Breakpoint");
        JMenuItem stopItem = new JMenuItem("Stop in...", 83);
        stopItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JDBMenuBar.this.buildBreakpoint();
            }
        });
        breakpointMenu.add(stopItem);
        JMenu helpMenu = new JMenu("Help");
        this.addTool(helpMenu, "Display command list", "Help", "help");
        this.add(fileMenu);
        this.add(cmdMenu);
        this.add(helpMenu);
    }

    private void buildBreakpoint() {
        Frame frame = JOptionPane.getRootFrame();
        JDialog dialog = new JDialog(frame, "Specify Breakpoint");
        Container contents = dialog.getContentPane();
        Vector<String> classes = new Vector<String>();
        classes.add("Foo");
        classes.add("Bar");
        JList list = new JList(classes);
        JScrollPane scrollPane = new JScrollPane(list);
        contents.add(scrollPane);
        dialog.show();
    }

    private void monitorCommand() {
        String expr = (String)JOptionPane.showInputDialog(null, "Expression to monitor:", "Add Monitor", 3, null, null, null);
        if (expr != null) {
            this.interpreter.executeCommand("monitor " + expr);
        }
    }

    private void unmonitorCommand() {
        List<String> monitors = this.env.getMonitorListModel().monitors();
        String expr = (String)JOptionPane.showInputDialog(null, "Expression to unmonitor:", "Remove Monitor", 3, null, monitors.toArray(), monitors.get(monitors.size() - 1));
        if (expr != null) {
            this.interpreter.executeCommand("unmonitor " + expr);
        }
    }

    private void openCommand() {
        JFileChooser chooser = new JFileChooser();
        JDBFileFilter filter = new JDBFileFilter("java", "Java source code");
        chooser.setFileFilter(filter);
        int result = chooser.showOpenDialog(this);
        if (result == 0) {
            System.out.println("Chose file: " + chooser.getSelectedFile().getName());
        }
    }

    private void addTool(JMenu menu, String toolTip, String labelText, String command) {
        JMenuItem mi = new JMenuItem(labelText);
        mi.setToolTipText(toolTip);
        final String cmd = command;
        mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JDBMenuBar.this.interpreter.executeCommand(cmd);
            }
        });
        menu.add(mi);
    }
}

