/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.gui.ApplicationTool;
import com.sun.tools.example.debug.gui.ClassTreeTool;
import com.sun.tools.example.debug.gui.CommandTool;
import com.sun.tools.example.debug.gui.ContextManager;
import com.sun.tools.example.debug.gui.Environment;
import com.sun.tools.example.debug.gui.JDBMenuBar;
import com.sun.tools.example.debug.gui.JDBToolBar;
import com.sun.tools.example.debug.gui.MonitorTool;
import com.sun.tools.example.debug.gui.SearchPath;
import com.sun.tools.example.debug.gui.SourceTool;
import com.sun.tools.example.debug.gui.SourceTreeTool;
import com.sun.tools.example.debug.gui.StackTraceTool;
import com.sun.tools.example.debug.gui.ThreadTreeTool;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class GUI
extends JPanel {
    private CommandTool cmdTool;
    private ApplicationTool appTool;
    public static SourceTool srcTool;
    private SourceTreeTool sourceTreeTool;
    private ClassTreeTool classTreeTool;
    private ThreadTreeTool threadTreeTool;
    private StackTraceTool stackTool;
    private MonitorTool monitorTool;
    public static final String progname = "javadt";
    public static final String version = "1.0Beta";
    public static final String windowBanner = "Java(tm) platform Debug Tool";
    private Font fixedFont = new Font("monospaced", 0, 10);

    private GUI(Environment env) {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.add((Component)new JDBToolBar(env), "North");
        srcTool = new SourceTool(env);
        srcTool.setPreferredSize(new Dimension(500, 300));
        srcTool.setTextFont(this.fixedFont);
        this.stackTool = new StackTraceTool(env);
        this.stackTool.setPreferredSize(new Dimension(500, 100));
        this.monitorTool = new MonitorTool(env);
        this.monitorTool.setPreferredSize(new Dimension(500, 50));
        JSplitPane right = new JSplitPane(0, srcTool, new JSplitPane(0, this.stackTool, this.monitorTool));
        this.sourceTreeTool = new SourceTreeTool(env);
        this.sourceTreeTool.setPreferredSize(new Dimension(200, 450));
        this.classTreeTool = new ClassTreeTool(env);
        this.classTreeTool.setPreferredSize(new Dimension(200, 450));
        this.threadTreeTool = new ThreadTreeTool(env);
        this.threadTreeTool.setPreferredSize(new Dimension(200, 450));
        JTabbedPane treePane = new JTabbedPane(3);
        treePane.addTab("Source", null, this.sourceTreeTool);
        treePane.addTab("Classes", null, this.classTreeTool);
        treePane.addTab("Threads", null, this.threadTreeTool);
        JSplitPane centerTop = new JSplitPane(1, treePane, right);
        this.cmdTool = new CommandTool(env);
        this.cmdTool.setPreferredSize(new Dimension(700, 150));
        this.appTool = new ApplicationTool(env);
        this.appTool.setPreferredSize(new Dimension(700, 200));
        JSplitPane centerBottom = new JSplitPane(0, this.cmdTool, this.appTool);
        JSplitPane center = new JSplitPane(0, centerTop, centerBottom);
        this.add((Component)center, "Center");
    }

    private static void usage() {
        String separator = File.pathSeparator;
        System.out.println("Usage: javadt <options> <class> <arguments>");
        System.out.println();
        System.out.println("where options include:");
        System.out.println("    -help             print out this message and exit");
        System.out.println("    -sourcepath <directories separated by \"" + separator + "\">");
        System.out.println("                      list directories in which to look for source files");
        System.out.println("    -remote <hostname>:<port-number>");
        System.out.println("                      host machine and port number of interpreter to attach to");
        System.out.println("    -dbgtrace [flags] print info for debugging javadt");
        System.out.println();
        System.out.println("options forwarded to debuggee process:");
        System.out.println("    -v -verbose[:class|gc|jni]");
        System.out.println("                      turn on verbose mode");
        System.out.println("    -D<name>=<value>  set a system property");
        System.out.println("    -classpath <directories separated by \"" + separator + "\">");
        System.out.println("                      list directories in which to look for classes");
        System.out.println("    -X<option>        non-standard debuggee VM option");
        System.out.println();
        System.out.println("<class> is the name of the class to begin debugging");
        System.out.println("<arguments> are the arguments passed to the main() method of <class>");
        System.out.println();
        System.out.println("For command help type 'help' at javadt prompt");
    }

    public static void main(String[] argv) {
        Object remote = null;
        String clsName = "";
        String progArgs = "";
        String javaArgs = "";
        boolean verbose = false;
        final Environment env = new Environment();
        GUI mainPanel = new GUI(env);
        ContextManager context = env.getContextManager();
        ExecutionManager runtime = env.getExecutionManager();
        for (int i = 0; i < argv.length; ++i) {
            String token = argv[i];
            if (token.equals("-dbgtrace")) {
                if (i == argv.length - 1 || !Character.isDigit(argv[i + 1].charAt(0))) {
                    runtime.setTraceMode(0xFFFFFF);
                    continue;
                }
                String flagStr = argv[++i];
                runtime.setTraceMode(Integer.decode(flagStr));
                continue;
            }
            if (token.equals("-X")) {
                System.out.println("Use 'java -X' to see the available non-standard options");
                System.out.println();
                GUI.usage();
                System.exit(1);
                continue;
            }
            if (token.equals("-v") || token.startsWith("-v:") || token.startsWith("-verbose") || token.startsWith("-D") || token.startsWith("-X") || token.equals("-noasyncgc") || token.equals("-prof") || token.equals("-verify") || token.equals("-noverify") || token.equals("-verifyremote") || token.equals("-verbosegc") || token.startsWith("-ms") || token.startsWith("-mx") || token.startsWith("-ss") || token.startsWith("-oss")) {
                javaArgs = javaArgs + token + " ";
                continue;
            }
            if (token.equals("-sourcepath")) {
                if (i == argv.length - 1) {
                    System.out.println("No sourcepath specified.");
                    GUI.usage();
                    System.exit(1);
                }
                env.getSourceManager().setSourcePath(new SearchPath(argv[++i]));
                continue;
            }
            if (token.equals("-classpath")) {
                if (i == argv.length - 1) {
                    System.out.println("No classpath specified.");
                    GUI.usage();
                    System.exit(1);
                }
                env.getClassManager().setClassPath(new SearchPath(argv[++i]));
                continue;
            }
            if (token.equals("-remote")) {
                if (i == argv.length - 1) {
                    System.out.println("No remote specified.");
                    GUI.usage();
                    System.exit(1);
                }
                env.getContextManager().setRemotePort(argv[++i]);
                continue;
            }
            if (token.equals("-help")) {
                GUI.usage();
                System.exit(0);
                continue;
            }
            if (token.equals("-version")) {
                System.out.println("javadt version 1.0Beta");
                System.exit(0);
                continue;
            }
            if (token.startsWith("-")) {
                System.out.println("invalid option: " + token);
                GUI.usage();
                System.exit(1);
                continue;
            }
            clsName = token;
            ++i;
            while (i < argv.length) {
                progArgs = progArgs + argv[i] + " ";
                ++i;
            }
            break;
        }
        context.setMainClassName(clsName);
        context.setProgramArguments(progArgs);
        context.setVmArguments(javaArgs);
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exc) {
            System.err.println("Error loading L&F: " + exc);
        }
        JFrame frame = new JFrame();
        frame.setBackground(Color.lightGray);
        frame.setTitle(windowBanner);
        frame.setJMenuBar(new JDBMenuBar(env));
        frame.setContentPane(mainPanel);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                env.terminate();
            }
        });
        frame.pack();
        frame.show();
    }
}

