/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.bdi.FrameIndexOutOfBoundsException;
import com.sun.tools.example.debug.bdi.SessionListener;
import com.sun.tools.example.debug.bdi.ThreadInfo;
import com.sun.tools.example.debug.bdi.VMNotInterruptedException;
import com.sun.tools.example.debug.event.ExceptionEventSet;
import com.sun.tools.example.debug.event.JDIAdapter;
import com.sun.tools.example.debug.event.JDIListener;
import com.sun.tools.example.debug.event.LocationTriggerEventSet;
import com.sun.tools.example.debug.event.VMDisconnectEventSet;
import com.sun.tools.example.debug.gui.ClassManager;
import com.sun.tools.example.debug.gui.ContextListener;
import com.sun.tools.example.debug.gui.CurrentFrameChangedEvent;
import com.sun.tools.example.debug.gui.Environment;
import com.sun.tools.example.debug.gui.SearchPath;
import java.io.File;
import java.util.EventObject;
import java.util.Vector;

public class ContextManager {
    private ClassManager classManager;
    private ExecutionManager runtime;
    private String mainClassName;
    private String vmArguments;
    private String commandArguments;
    private String remotePort;
    private ThreadReference currentThread;
    private boolean verbose;
    private Vector<ContextListener> contextListeners = new Vector();

    public ContextManager(Environment env) {
        this.classManager = env.getClassManager();
        this.runtime = env.getExecutionManager();
        this.mainClassName = "";
        this.vmArguments = "";
        this.commandArguments = "";
        this.currentThread = null;
        ContextManagerListener listener = new ContextManagerListener();
        this.runtime.addJDIListener(listener);
        this.runtime.addSessionListener(listener);
    }

    public String getMainClassName() {
        return this.mainClassName;
    }

    public void setMainClassName(String mainClassName) {
        this.mainClassName = mainClassName;
    }

    public String getVmArguments() {
        return this.processClasspathDefaults(this.vmArguments);
    }

    public void setVmArguments(String vmArguments) {
        this.vmArguments = vmArguments;
    }

    public String getProgramArguments() {
        return this.commandArguments;
    }

    public void setProgramArguments(String commandArguments) {
        this.commandArguments = commandArguments;
    }

    public String getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(String remotePort) {
        this.remotePort = remotePort;
    }

    public boolean getVerboseFlag() {
        return this.verbose;
    }

    public void setVerboseFlag(boolean verbose) {
        this.verbose = verbose;
    }

    public ThreadReference getCurrentThread() {
        return this.currentThread;
    }

    public void setCurrentThread(ThreadReference t) {
        if (t != this.currentThread) {
            this.currentThread = t;
            this.notifyCurrentThreadChanged(t);
        }
    }

    public void setCurrentThreadInvalidate(ThreadReference t) {
        this.currentThread = t;
        this.notifyCurrentFrameChanged(this.runtime.threadInfo(t), 0, true);
    }

    public void invalidateCurrentThread() {
        this.notifyCurrentFrameChanged(null, 0, true);
    }

    public int getCurrentFrameIndex(ThreadReference t) {
        return this.getCurrentFrameIndex(this.runtime.threadInfo(t));
    }

    public int getCurrentFrameIndex(ThreadInfo tinfo) {
        if (tinfo == null) {
            return 0;
        }
        Integer currentFrame = (Integer)tinfo.getUserObject();
        if (currentFrame == null) {
            return 0;
        }
        return currentFrame;
    }

    public int moveCurrentFrameIndex(ThreadReference t, int count) throws VMNotInterruptedException {
        return this.setCurrentFrameIndex(t, count, true);
    }

    public int setCurrentFrameIndex(ThreadReference t, int newIndex) throws VMNotInterruptedException {
        return this.setCurrentFrameIndex(t, newIndex, false);
    }

    public int setCurrentFrameIndex(int newIndex) throws VMNotInterruptedException {
        if (this.currentThread == null) {
            return 0;
        }
        return this.setCurrentFrameIndex(this.currentThread, newIndex, false);
    }

    private int setCurrentFrameIndex(ThreadReference t, int x, boolean relative) throws VMNotInterruptedException {
        int newIndex;
        boolean sameThread = t.equals(this.currentThread);
        ThreadInfo tinfo = this.runtime.threadInfo(t);
        if (tinfo == null) {
            return 0;
        }
        int maxIndex = tinfo.getFrameCount() - 1;
        int oldIndex = this.getCurrentFrameIndex(tinfo);
        int n = newIndex = relative ? oldIndex + x : x;
        if (newIndex > maxIndex) {
            newIndex = maxIndex;
        } else if (newIndex < 0) {
            newIndex = 0;
        }
        if (!sameThread || newIndex != oldIndex) {
            this.setCurrentFrameIndex(tinfo, newIndex);
        }
        return newIndex - oldIndex;
    }

    private void setCurrentFrameIndex(ThreadInfo tinfo, int index) {
        tinfo.setUserObject(new Integer(index));
        this.notifyCurrentFrameChanged(tinfo.thread(), index);
    }

    public StackFrame getCurrentFrame() throws VMNotInterruptedException {
        return this.getCurrentFrame(this.runtime.threadInfo(this.currentThread));
    }

    public StackFrame getCurrentFrame(ThreadReference t) throws VMNotInterruptedException {
        return this.getCurrentFrame(this.runtime.threadInfo(t));
    }

    public StackFrame getCurrentFrame(ThreadInfo tinfo) throws VMNotInterruptedException {
        int index = this.getCurrentFrameIndex(tinfo);
        try {
            return tinfo.getFrame(index);
        }
        catch (FrameIndexOutOfBoundsException e) {
            return null;
        }
    }

    public void addContextListener(ContextListener cl) {
        this.contextListeners.add(cl);
    }

    public void removeContextListener(ContextListener cl) {
        this.contextListeners.remove(cl);
    }

    private void notifyCurrentThreadChanged(ThreadReference t) {
        ThreadInfo tinfo = null;
        int index = 0;
        if (t != null) {
            tinfo = this.runtime.threadInfo(t);
            index = this.getCurrentFrameIndex(tinfo);
        }
        this.notifyCurrentFrameChanged(tinfo, index, false);
    }

    private void notifyCurrentFrameChanged(ThreadReference t, int index) {
        this.notifyCurrentFrameChanged(this.runtime.threadInfo(t), index, false);
    }

    private void notifyCurrentFrameChanged(ThreadInfo tinfo, int index, boolean invalidate) {
        Vector l = (Vector)this.contextListeners.clone();
        CurrentFrameChangedEvent evt = new CurrentFrameChangedEvent(this, tinfo, index, invalidate);
        for (int i = 0; i < l.size(); ++i) {
            ((ContextListener)l.elementAt(i)).currentFrameChanged(evt);
        }
    }

    private String processClasspathDefaults(String javaArgs) {
        if (javaArgs.indexOf("-classpath ") == -1) {
            StringBuffer munged = new StringBuffer(javaArgs);
            SearchPath classpath = this.classManager.getClassPath();
            if (classpath.isEmpty()) {
                String envcp = System.getProperty("env.class.path");
                if (envcp != null && envcp.length() > 0) {
                    munged.append(" -classpath " + envcp);
                }
            } else {
                munged.append(" -classpath " + classpath.asString());
            }
            return munged.toString();
        }
        return javaArgs;
    }

    private String appendPath(String path1, String path2) {
        if (path1 == null || path1.length() == 0) {
            return path2 == null ? "." : path2;
        }
        if (path2 == null || path2.length() == 0) {
            return path1;
        }
        return path1 + File.pathSeparator + path2;
    }

    private class ContextManagerListener
    extends JDIAdapter
    implements SessionListener,
    JDIListener {
        private ContextManagerListener() {
        }

        public void sessionStart(EventObject e) {
            ContextManager.this.invalidateCurrentThread();
        }

        public void sessionInterrupt(EventObject e) {
            ContextManager.this.setCurrentThreadInvalidate(ContextManager.this.currentThread);
        }

        public void sessionContinue(EventObject e) {
            ContextManager.this.invalidateCurrentThread();
        }

        public void locationTrigger(LocationTriggerEventSet e) {
            ContextManager.this.setCurrentThreadInvalidate(e.getThread());
        }

        public void exception(ExceptionEventSet e) {
            ContextManager.this.setCurrentThreadInvalidate(e.getThread());
        }

        public void vmDisconnect(VMDisconnectEventSet e) {
            ContextManager.this.invalidateCurrentThread();
        }
    }
}

