/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.jdi.Location;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.tools.example.debug.bdi.EventRequestSpec;
import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.bdi.OutputListener;
import com.sun.tools.example.debug.bdi.SessionListener;
import com.sun.tools.example.debug.bdi.SpecErrorEvent;
import com.sun.tools.example.debug.bdi.SpecEvent;
import com.sun.tools.example.debug.bdi.SpecListener;
import com.sun.tools.example.debug.bdi.Utils;
import com.sun.tools.example.debug.event.AccessWatchpointEventSet;
import com.sun.tools.example.debug.event.ClassPrepareEventSet;
import com.sun.tools.example.debug.event.ClassUnloadEventSet;
import com.sun.tools.example.debug.event.ExceptionEventSet;
import com.sun.tools.example.debug.event.JDIListener;
import com.sun.tools.example.debug.event.LocatableEventSet;
import com.sun.tools.example.debug.event.LocationTriggerEventSet;
import com.sun.tools.example.debug.event.ModificationWatchpointEventSet;
import com.sun.tools.example.debug.event.ThreadDeathEventSet;
import com.sun.tools.example.debug.event.ThreadStartEventSet;
import com.sun.tools.example.debug.event.VMDeathEventSet;
import com.sun.tools.example.debug.event.VMDisconnectEventSet;
import com.sun.tools.example.debug.event.VMStartEventSet;
import com.sun.tools.example.debug.gui.CommandInterpreter;
import com.sun.tools.example.debug.gui.ContextListener;
import com.sun.tools.example.debug.gui.ContextManager;
import com.sun.tools.example.debug.gui.CurrentFrameChangedEvent;
import com.sun.tools.example.debug.gui.Environment;
import com.sun.tools.example.debug.gui.SourceManager;
import com.sun.tools.example.debug.gui.TypeScript;
import com.sun.tools.example.debug.gui.TypeScriptOutputListener;
import com.sun.tools.example.debug.gui.TypeScriptWriter;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.util.EventObject;
import javax.swing.JPanel;

public class CommandTool
extends JPanel {
    private Environment env;
    private ContextManager context;
    private ExecutionManager runtime;
    private SourceManager sourceManager;
    private TypeScript script;
    private static final String DEFAULT_CMD_PROMPT = "Command:";

    public CommandTool(Environment env) {
        super(new BorderLayout());
        this.env = env;
        this.context = env.getContextManager();
        this.runtime = env.getExecutionManager();
        this.sourceManager = env.getSourceManager();
        this.script = new TypeScript(DEFAULT_CMD_PROMPT, false);
        this.add(this.script);
        final CommandInterpreter interpreter = new CommandInterpreter(env);
        this.script.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                interpreter.executeCommand(CommandTool.this.script.readln());
            }
        });
        TypeScriptOutputListener diagnosticsListener = new TypeScriptOutputListener(this.script, true);
        this.runtime.addDiagnosticsListener(diagnosticsListener);
        env.setTypeScript(new PrintWriter(new TypeScriptWriter(this.script)));
        TTYDebugListener listener = new TTYDebugListener(diagnosticsListener);
        this.runtime.addJDIListener(listener);
        this.runtime.addSessionListener(listener);
        this.runtime.addSpecListener(listener);
        this.context.addContextListener(listener);
    }

    private String locationString(LocatableEventSet e) {
        Location loc = e.getLocation();
        return "thread=\"" + e.getThread().name() + "\", " + Utils.locationString(loc);
    }

    private void setThread(LocatableEventSet e) {
        if (!e.suspendedNone()) {
            Thread.yield();
            this.script.setPrompt(this.promptString(e.getThread(), 0));
        }
    }

    private String promptString(ThreadReference thread, int frameIndex) {
        if (thread == null) {
            return DEFAULT_CMD_PROMPT;
        }
        return thread.name() + "[" + (frameIndex + 1) + "]:";
    }

    private class TTYDebugListener
    implements JDIListener,
    SessionListener,
    SpecListener,
    ContextListener {
        private OutputListener diagnostics;

        TTYDebugListener(OutputListener diagnostics) {
            this.diagnostics = diagnostics;
        }

        public void accessWatchpoint(AccessWatchpointEventSet e) {
            CommandTool.this.setThread(e);
            EventIterator it = e.eventIterator();
            while (it.hasNext()) {
                Event evt = it.nextEvent();
                this.diagnostics.putString("Watchpoint hit: " + CommandTool.this.locationString(e));
            }
        }

        public void classPrepare(ClassPrepareEventSet e) {
            if (CommandTool.this.context.getVerboseFlag()) {
                String name = e.getReferenceType().name();
                this.diagnostics.putString("Class " + name + " loaded");
            }
        }

        public void classUnload(ClassUnloadEventSet e) {
            if (CommandTool.this.context.getVerboseFlag()) {
                this.diagnostics.putString("Class " + e.getClassName() + " unloaded.");
            }
        }

        public void exception(ExceptionEventSet e) {
            CommandTool.this.setThread(e);
            String name = e.getException().referenceType().name();
            this.diagnostics.putString("Exception: " + name);
        }

        public void locationTrigger(LocationTriggerEventSet e) {
            String locString = CommandTool.this.locationString(e);
            CommandTool.this.setThread(e);
            EventIterator it = e.eventIterator();
            while (it.hasNext()) {
                Event evt = it.nextEvent();
                if (evt instanceof BreakpointEvent) {
                    this.diagnostics.putString("Breakpoint hit: " + locString);
                    continue;
                }
                if (evt instanceof StepEvent) {
                    this.diagnostics.putString("Step completed: " + locString);
                    continue;
                }
                if (evt instanceof MethodEntryEvent) {
                    this.diagnostics.putString("Method entered: " + locString);
                    continue;
                }
                if (evt instanceof MethodExitEvent) {
                    this.diagnostics.putString("Method exited: " + locString);
                    continue;
                }
                this.diagnostics.putString("UNKNOWN event: " + e);
            }
        }

        public void modificationWatchpoint(ModificationWatchpointEventSet e) {
            CommandTool.this.setThread(e);
            EventIterator it = e.eventIterator();
            while (it.hasNext()) {
                Event evt = it.nextEvent();
                this.diagnostics.putString("Watchpoint hit: " + CommandTool.this.locationString(e));
            }
        }

        public void threadDeath(ThreadDeathEventSet e) {
            if (CommandTool.this.context.getVerboseFlag()) {
                this.diagnostics.putString("Thread " + e.getThread() + " ended.");
            }
        }

        public void threadStart(ThreadStartEventSet e) {
            if (CommandTool.this.context.getVerboseFlag()) {
                this.diagnostics.putString("Thread " + e.getThread() + " started.");
            }
        }

        public void vmDeath(VMDeathEventSet e) {
            CommandTool.this.script.setPrompt(CommandTool.DEFAULT_CMD_PROMPT);
            this.diagnostics.putString("VM exited");
        }

        public void vmDisconnect(VMDisconnectEventSet e) {
            CommandTool.this.script.setPrompt(CommandTool.DEFAULT_CMD_PROMPT);
            this.diagnostics.putString("Disconnected from VM");
        }

        public void vmStart(VMStartEventSet e) {
            CommandTool.this.script.setPrompt(CommandTool.DEFAULT_CMD_PROMPT);
            this.diagnostics.putString("VM started");
        }

        public void sessionStart(EventObject e) {
        }

        public void sessionInterrupt(EventObject e) {
            Thread.yield();
            this.diagnostics.putString("VM interrupted by user.");
            CommandTool.this.script.setPrompt(CommandTool.DEFAULT_CMD_PROMPT);
        }

        public void sessionContinue(EventObject e) {
            this.diagnostics.putString("Execution resumed.");
            CommandTool.this.script.setPrompt(CommandTool.DEFAULT_CMD_PROMPT);
        }

        public void breakpointSet(SpecEvent e) {
            EventRequestSpec spec = e.getEventRequestSpec();
            this.diagnostics.putString("Breakpoint set at " + spec + ".");
        }

        public void breakpointDeferred(SpecEvent e) {
            EventRequestSpec spec = e.getEventRequestSpec();
            this.diagnostics.putString("Breakpoint will be set at " + spec + " when its class is loaded.");
        }

        public void breakpointDeleted(SpecEvent e) {
            EventRequestSpec spec = e.getEventRequestSpec();
            this.diagnostics.putString("Breakpoint at " + spec.toString() + " deleted.");
        }

        public void breakpointResolved(SpecEvent e) {
            EventRequestSpec spec = e.getEventRequestSpec();
            this.diagnostics.putString("Breakpoint resolved to " + spec.toString() + ".");
        }

        public void breakpointError(SpecErrorEvent e) {
            EventRequestSpec spec = e.getEventRequestSpec();
            this.diagnostics.putString("Deferred breakpoint at " + spec + " could not be resolved:" + e.getReason());
        }

        public void watchpointSet(SpecEvent e) {
        }

        public void watchpointDeferred(SpecEvent e) {
        }

        public void watchpointDeleted(SpecEvent e) {
        }

        public void watchpointResolved(SpecEvent e) {
        }

        public void watchpointError(SpecErrorEvent e) {
        }

        public void exceptionInterceptSet(SpecEvent e) {
        }

        public void exceptionInterceptDeferred(SpecEvent e) {
        }

        public void exceptionInterceptDeleted(SpecEvent e) {
        }

        public void exceptionInterceptResolved(SpecEvent e) {
        }

        public void exceptionInterceptError(SpecErrorEvent e) {
        }

        public void currentFrameChanged(CurrentFrameChangedEvent e) {
            ThreadReference thread = e.getThread();
            if (thread == CommandTool.this.context.getCurrentThread()) {
                CommandTool.this.script.setPrompt(CommandTool.this.promptString(thread, e.getIndex()));
            }
        }
    }
}

