/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.bdi.NoSessionException;
import com.sun.tools.example.debug.bdi.SessionListener;
import com.sun.tools.example.debug.event.ClassPrepareEventSet;
import com.sun.tools.example.debug.event.ClassUnloadEventSet;
import com.sun.tools.example.debug.event.JDIAdapter;
import com.sun.tools.example.debug.event.JDIListener;
import com.sun.tools.example.debug.event.VMDisconnectEventSet;
import com.sun.tools.example.debug.gui.ClassManager;
import com.sun.tools.example.debug.gui.CommandInterpreter;
import com.sun.tools.example.debug.gui.Environment;
import com.sun.tools.example.debug.gui.SearchPath;
import com.sun.tools.example.debug.gui.SingleLeafTreeSelectionModel;
import com.sun.tools.example.debug.gui.SourceManager;
import java.awt.BorderLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ClassTreeTool
extends JPanel {
    private Environment env;
    private ExecutionManager runtime;
    private SourceManager sourceManager;
    private ClassManager classManager;
    private JTree tree;
    private DefaultTreeModel treeModel;
    private ClassTreeNode root;
    private SearchPath sourcePath;
    private CommandInterpreter interpreter;
    private static String HEADING = "CLASSES";

    public ClassTreeTool(Environment env) {
        super(new BorderLayout());
        this.env = env;
        this.runtime = env.getExecutionManager();
        this.sourceManager = env.getSourceManager();
        this.interpreter = new CommandInterpreter(env);
        this.root = this.createClassTree(HEADING);
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.treeModel);
        this.tree.setSelectionModel(new SingleLeafTreeSelectionModel());
        MouseAdapter ml = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                ClassTreeNode node;
                int selRow = ClassTreeTool.this.tree.getRowForLocation(e.getX(), e.getY());
                TreePath selPath = ClassTreeTool.this.tree.getPathForLocation(e.getX(), e.getY());
                if (selRow != -1 && e.getClickCount() == 1 && (node = (ClassTreeNode)selPath.getLastPathComponent()).isLeaf()) {
                    ClassTreeTool.this.tree.setSelectionPath(selPath);
                    ClassTreeTool.this.interpreter.executeCommand("view " + node.getReferenceTypeName());
                }
            }
        };
        this.tree.addMouseListener(ml);
        JScrollPane treeView = new JScrollPane(this.tree);
        this.add(treeView);
        ClassTreeToolListener listener = new ClassTreeToolListener();
        this.runtime.addJDIListener(listener);
        this.runtime.addSessionListener(listener);
    }

    ClassTreeNode createClassTree(String label) {
        return new ClassTreeNode(label, null);
    }

    class ClassTreeNode
    extends DefaultMutableTreeNode {
        private String name;
        private ReferenceType refTy;

        ClassTreeNode(String name, ReferenceType refTy) {
            this.name = name;
            this.refTy = refTy;
        }

        public String toString() {
            return this.name;
        }

        public ReferenceType getReferenceType() {
            return this.refTy;
        }

        public String getReferenceTypeName() {
            return this.refTy.name();
        }

        private boolean isPackage() {
            return this.refTy == null;
        }

        public boolean isLeaf() {
            return !this.isPackage();
        }

        public void addClass(ReferenceType refTy) {
            this.addClass(refTy.name(), refTy);
        }

        private void addClass(String className, ReferenceType refTy) {
            if (className.equals("")) {
                return;
            }
            int pos = className.indexOf(46);
            if (pos < 0) {
                this.insertNode(className, refTy);
            } else {
                String head = className.substring(0, pos);
                String tail = className.substring(pos + 1);
                ClassTreeNode child = this.insertNode(head, null);
                child.addClass(tail, refTy);
            }
        }

        private ClassTreeNode insertNode(String name, ReferenceType refTy) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                ClassTreeNode child = (ClassTreeNode)this.getChildAt(i);
                int cmp = name.compareTo(child.toString());
                if (cmp == 0) {
                    return child;
                }
                if (cmp >= 0) continue;
                ClassTreeNode newChild = new ClassTreeNode(name, refTy);
                ClassTreeTool.this.treeModel.insertNodeInto(newChild, this, i);
                return newChild;
            }
            ClassTreeNode newChild = new ClassTreeNode(name, refTy);
            ClassTreeTool.this.treeModel.insertNodeInto(newChild, this, this.getChildCount());
            return newChild;
        }

        public void removeClass(String className) {
            if (className.equals("")) {
                return;
            }
            int pos = className.indexOf(46);
            if (pos < 0) {
                ClassTreeNode child = this.findNode(className);
                if (!this.isPackage()) {
                    ClassTreeTool.this.treeModel.removeNodeFromParent(child);
                }
            } else {
                String head = className.substring(0, pos);
                String tail = className.substring(pos + 1);
                ClassTreeNode child = this.findNode(head);
                child.removeClass(tail);
                if (this.isPackage() && child.getChildCount() < 1) {
                    ClassTreeTool.this.treeModel.removeNodeFromParent(child);
                }
            }
        }

        private ClassTreeNode findNode(String name) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                ClassTreeNode child = (ClassTreeNode)this.getChildAt(i);
                int cmp = name.compareTo(child.toString());
                if (cmp == 0) {
                    return child;
                }
                if (cmp <= 0) continue;
                return null;
            }
            return null;
        }
    }

    private class ClassTreeToolListener
    extends JDIAdapter
    implements JDIListener,
    SessionListener {
        private ClassTreeToolListener() {
        }

        public void sessionStart(EventObject e) {
            try {
                for (ReferenceType type : ClassTreeTool.this.runtime.allClasses()) {
                    ClassTreeTool.this.root.addClass(type);
                }
            }
            catch (VMDisconnectedException ee) {
            }
            catch (NoSessionException noSessionException) {
                // empty catch block
            }
        }

        public void sessionInterrupt(EventObject e) {
        }

        public void sessionContinue(EventObject e) {
        }

        public void classPrepare(ClassPrepareEventSet e) {
            ClassTreeTool.this.root.addClass(e.getReferenceType());
        }

        public void classUnload(ClassUnloadEventSet e) {
            ClassTreeTool.this.root.removeClass(e.getClassName());
        }

        public void vmDisconnect(VMDisconnectEventSet e) {
            ClassTreeTool.this.root = ClassTreeTool.this.createClassTree(HEADING);
            ClassTreeTool.this.treeModel = new DefaultTreeModel(ClassTreeTool.this.root);
            ClassTreeTool.this.tree.setModel(ClassTreeTool.this.treeModel);
        }
    }
}

