/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.bdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.InvalidLineNumberException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.tools.example.debug.bdi.ReferenceTypeSpec;

class SourceNameReferenceTypeSpec
implements ReferenceTypeSpec {
    final String sourceName;
    final int linenumber;

    SourceNameReferenceTypeSpec(String sourceName, int linenumber) {
        this.sourceName = sourceName;
        this.linenumber = linenumber;
    }

    public boolean matches(ReferenceType refType) {
        block6: {
            try {
                if (!refType.sourceName().equals(this.sourceName)) break block6;
                try {
                    refType.locationsOfLine(this.linenumber);
                    return true;
                }
                catch (AbsentInformationException exc) {
                }
                catch (ObjectCollectedException exc) {
                }
                catch (InvalidLineNumberException exc) {
                }
            }
            catch (AbsentInformationException absentInformationException) {
                // empty catch block
            }
        }
        return false;
    }

    public int hashCode() {
        return this.sourceName.hashCode() + this.linenumber;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SourceNameReferenceTypeSpec) {
            SourceNameReferenceTypeSpec spec = (SourceNameReferenceTypeSpec)obj;
            return this.sourceName.equals(spec.sourceName) && this.linenumber == spec.linenumber;
        }
        return false;
    }

    public String toString() {
        return this.sourceName + "@" + this.linenumber;
    }
}

