/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.bdi;

import com.sun.jdi.ReferenceType;
import com.sun.tools.example.debug.bdi.ReferenceTypeSpec;
import com.sun.tools.example.debug.bdi.Utils;
import java.util.StringTokenizer;

class PatternReferenceTypeSpec
implements ReferenceTypeSpec {
    final boolean isWild;
    final String classId;

    PatternReferenceTypeSpec(String classId) {
        this.isWild = classId.startsWith("*.");
        this.classId = this.isWild ? classId.substring(1) : classId;
    }

    public boolean matches(ReferenceType refType) {
        if (this.isWild) {
            return refType.name().endsWith(this.classId);
        }
        return refType.name().equals(this.classId);
    }

    public int hashCode() {
        return this.classId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof PatternReferenceTypeSpec) {
            PatternReferenceTypeSpec spec = (PatternReferenceTypeSpec)obj;
            return this.classId.equals(spec.classId) && this.isWild == spec.isWild;
        }
        return false;
    }

    private void checkClassName(String className) throws ClassNotFoundException {
        StringTokenizer tokenizer = new StringTokenizer(className, ".");
        boolean first = true;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!(Utils.isJavaIdentifier(token) || first && token.equals("*"))) {
                throw new ClassNotFoundException();
            }
            first = false;
        }
    }

    public String toString() {
        return this.isWild ? "*" + this.classId : this.classId;
    }
}

