/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.bdi;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.bdi.Session;
import com.sun.tools.example.debug.event.AbstractEventSet;
import com.sun.tools.example.debug.event.AccessWatchpointEventSet;
import com.sun.tools.example.debug.event.ClassPrepareEventSet;
import com.sun.tools.example.debug.event.ClassUnloadEventSet;
import com.sun.tools.example.debug.event.ExceptionEventSet;
import com.sun.tools.example.debug.event.JDIListener;
import com.sun.tools.example.debug.event.LocationTriggerEventSet;
import com.sun.tools.example.debug.event.ModificationWatchpointEventSet;
import com.sun.tools.example.debug.event.ThreadDeathEventSet;
import com.sun.tools.example.debug.event.ThreadStartEventSet;
import com.sun.tools.example.debug.event.VMDeathEventSet;
import com.sun.tools.example.debug.event.VMDisconnectEventSet;
import com.sun.tools.example.debug.event.VMStartEventSet;
import javax.swing.SwingUtilities;

class JDIEventSource
extends Thread {
    private EventQueue queue;
    private Session session;
    private ExecutionManager runtime;
    private final JDIListener firstListener = new FirstListener();
    private boolean wantInterrupt;

    JDIEventSource(Session session) {
        super("JDI Event Set Dispatcher");
        this.session = session;
        this.runtime = session.runtime;
        this.queue = session.vm.eventQueue();
    }

    public void run() {
        try {
            this.runLoop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.session.running = false;
    }

    private void runLoop() throws InterruptedException {
        AbstractEventSet es;
        do {
            EventSet jdiEventSet = this.queue.remove();
            es = AbstractEventSet.toSpecificEventSet(jdiEventSet);
            this.session.interrupted = es.suspendedAll();
            this.dispatchEventSet(es);
        } while (!(es instanceof VMDisconnectEventSet));
    }

    private void dispatchEventSet(final AbstractEventSet es) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean interrupted = es.suspendedAll();
                es.notify(JDIEventSource.this.firstListener);
                boolean wantInterrupt = JDIEventSource.this.wantInterrupt;
                for (JDIListener jl : ((JDIEventSource)JDIEventSource.this).session.runtime.jdiListeners) {
                    es.notify(jl);
                }
                if (interrupted && !wantInterrupt) {
                    ((JDIEventSource)JDIEventSource.this).session.interrupted = false;
                    try {
                        ((JDIEventSource)JDIEventSource.this).session.vm.resume();
                    }
                    catch (VMDisconnectedException ee) {
                        // empty catch block
                    }
                }
                if (es instanceof ThreadDeathEventSet) {
                    ThreadReference t = ((ThreadDeathEventSet)es).getThread();
                    ((JDIEventSource)JDIEventSource.this).session.runtime.removeThreadInfo(t);
                }
            }
        });
    }

    private void finalizeEventSet(AbstractEventSet es) {
        if (this.session.interrupted && !this.wantInterrupt) {
            this.session.interrupted = false;
            try {
                this.session.vm.resume();
            }
            catch (VMDisconnectedException ee) {
                // empty catch block
            }
        }
        if (es instanceof ThreadDeathEventSet) {
            ThreadReference t = ((ThreadDeathEventSet)es).getThread();
            this.session.runtime.removeThreadInfo(t);
        }
    }

    private class FirstListener
    implements JDIListener {
        private FirstListener() {
        }

        public void accessWatchpoint(AccessWatchpointEventSet e) {
            ((JDIEventSource)JDIEventSource.this).session.runtime.validateThreadInfo();
            JDIEventSource.this.wantInterrupt = true;
        }

        public void classPrepare(ClassPrepareEventSet e) {
            JDIEventSource.this.wantInterrupt = false;
            JDIEventSource.this.runtime.resolve(e.getReferenceType());
        }

        public void classUnload(ClassUnloadEventSet e) {
            JDIEventSource.this.wantInterrupt = false;
        }

        public void exception(ExceptionEventSet e) {
            JDIEventSource.this.wantInterrupt = true;
        }

        public void locationTrigger(LocationTriggerEventSet e) {
            ((JDIEventSource)JDIEventSource.this).session.runtime.validateThreadInfo();
            JDIEventSource.this.wantInterrupt = true;
        }

        public void modificationWatchpoint(ModificationWatchpointEventSet e) {
            ((JDIEventSource)JDIEventSource.this).session.runtime.validateThreadInfo();
            JDIEventSource.this.wantInterrupt = true;
        }

        public void threadDeath(ThreadDeathEventSet e) {
            JDIEventSource.this.wantInterrupt = false;
        }

        public void threadStart(ThreadStartEventSet e) {
            JDIEventSource.this.wantInterrupt = false;
        }

        public void vmDeath(VMDeathEventSet e) {
            JDIEventSource.this.wantInterrupt = false;
        }

        public void vmDisconnect(VMDisconnectEventSet e) {
            JDIEventSource.this.wantInterrupt = false;
            ((JDIEventSource)JDIEventSource.this).session.runtime.endSession();
        }

        public void vmStart(VMStartEventSet e) {
            JDIEventSource.this.wantInterrupt = false;
        }
    }
}

