/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.bdi;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.EventRequest;
import com.sun.tools.example.debug.bdi.EventRequestSpecList;
import com.sun.tools.example.debug.bdi.ReferenceTypeSpec;
import com.sun.tools.example.debug.bdi.SpecErrorEvent;
import com.sun.tools.example.debug.bdi.SpecEvent;
import com.sun.tools.example.debug.bdi.SpecListener;
import com.sun.tools.example.debug.bdi.Utils;

public abstract class EventRequestSpec {
    static final int STATUS_UNRESOLVED = 1;
    static final int STATUS_RESOLVED = 2;
    static final int STATUS_ERROR = 3;
    static final Object specPropertyKey = "spec";
    final EventRequestSpecList specs;
    final ReferenceTypeSpec refSpec;
    EventRequest request = null;
    int status = 1;

    EventRequestSpec(EventRequestSpecList specs, ReferenceTypeSpec refSpec) {
        this.specs = specs;
        this.refSpec = refSpec;
    }

    void setRequest(EventRequest request) {
        this.request = request;
        request.putProperty(specPropertyKey, this);
        request.enable();
    }

    abstract void resolve(ReferenceType var1) throws Exception;

    abstract void notifySet(SpecListener var1, SpecEvent var2);

    abstract void notifyDeferred(SpecListener var1, SpecEvent var2);

    abstract void notifyResolved(SpecListener var1, SpecEvent var2);

    abstract void notifyDeleted(SpecListener var1, SpecEvent var2);

    abstract void notifyError(SpecListener var1, SpecErrorEvent var2);

    void resolveNotify(ReferenceType refType) {
        try {
            this.resolve(refType);
            this.status = 2;
            this.specs.notifyResolved(this);
        }
        catch (Exception exc) {
            this.status = 3;
            this.specs.notifyError(this, exc);
        }
    }

    void attemptResolve(ReferenceType refType) {
        if (!this.isResolved() && this.refSpec.matches(refType)) {
            this.resolveNotify(refType);
        }
    }

    void attemptImmediateResolve(VirtualMachine vm) {
        for (ReferenceType refType : vm.allClasses()) {
            if (!this.refSpec.matches(refType)) continue;
            try {
                this.resolve(refType);
                this.status = 2;
                this.specs.notifySet(this);
            }
            catch (Exception exc) {
                this.status = 3;
                this.specs.notifyError(this, exc);
            }
            return;
        }
        this.specs.notifyDeferred(this);
    }

    public EventRequest getEventRequest() {
        return this.request;
    }

    public boolean isResolved() {
        return this.status == 2;
    }

    public boolean isUnresolved() {
        return this.status == 1;
    }

    public boolean isErroneous() {
        return this.status == 3;
    }

    public String getStatusString() {
        switch (this.status) {
            case 2: {
                return "resolved";
            }
            case 1: {
                return "deferred";
            }
            case 3: {
                return "erroneous";
            }
        }
        return "unknown";
    }

    boolean isJavaIdentifier(String s) {
        return Utils.isJavaIdentifier(s);
    }

    public String errorMessageFor(Exception e) {
        if (e instanceof IllegalArgumentException) {
            return "Invalid command syntax";
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        return "Internal error; unable to set" + this;
    }
}

