/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.net.MalformedURLException;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class VerboseGC {
    private MBeanServerConnection server;
    private JMXConnector jmxc;

    public VerboseGC(String hostname, int port) {
        System.out.println("Connecting to " + hostname + ":" + port);
        String urlPath = "/jndi/rmi://" + hostname + ":" + port + "/jmxrmi";
        this.connect(urlPath);
    }

    public void dump(long interval, long samples) {
        try {
            PrintGCStat pstat = new PrintGCStat(this.server);
            int i = 0;
            while ((long)i < samples) {
                pstat.printVerboseGc();
                try {
                    Thread.sleep(interval);
                }
                catch (InterruptedException e) {
                    System.exit(1);
                }
                ++i;
            }
        }
        catch (IOException e) {
            System.err.println("\nCommunication error: " + e.getMessage());
            System.exit(1);
        }
    }

    private void connect(String urlPath) {
        try {
            JMXServiceURL url = new JMXServiceURL("rmi", "", 0, urlPath);
            this.jmxc = JMXConnectorFactory.connect(url);
            this.server = this.jmxc.getMBeanServerConnection();
        }
        catch (MalformedURLException e) {
        }
        catch (IOException e) {
            System.err.println("\nCommunication error: " + e.getMessage());
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            VerboseGC.usage();
        }
        String hostname = "";
        int port = -1;
        long interval = 5000L;
        long mins = 5L;
        for (int argIndex = 0; argIndex < args.length; ++argIndex) {
            String arg = args[argIndex];
            if (args[argIndex].startsWith("-")) {
                if (arg.equals("-h") || arg.equals("-help") || arg.equals("-?")) {
                    VerboseGC.usage();
                    continue;
                }
                if (arg.startsWith("-interval=")) {
                    try {
                        interval = Integer.parseInt(arg.substring(10)) * 1000;
                    }
                    catch (NumberFormatException ex) {
                        VerboseGC.usage();
                    }
                    continue;
                }
                if (arg.startsWith("-duration=")) {
                    try {
                        mins = Integer.parseInt(arg.substring(10));
                    }
                    catch (NumberFormatException ex) {
                        VerboseGC.usage();
                    }
                    continue;
                }
                System.err.println("Unrecognized option: " + arg);
                VerboseGC.usage();
                continue;
            }
            String[] arg2 = arg.split(":");
            if (arg2.length != 2) {
                VerboseGC.usage();
            }
            hostname = arg2[0];
            try {
                port = Integer.parseInt(arg2[1]);
            }
            catch (NumberFormatException x) {
                VerboseGC.usage();
            }
            if (port >= 0) continue;
            VerboseGC.usage();
        }
        VerboseGC vgc = new VerboseGC(hostname, port);
        long samples = mins * 60L * 1000L / interval;
        vgc.dump(interval, samples);
    }

    private static void usage() {
        System.out.print("Usage: java VerboseGC <hostname>:<port> ");
        System.out.println(" [-interval=seconds] [-duration=minutes]");
    }
}

