/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.MalformedURLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JTop
extends JPanel {
    private MBeanServerConnection server;
    private ThreadMXBean tmbean;
    private MyTableModel tmodel = new MyTableModel();

    public JTop() {
        super(new GridLayout(1, 0));
        JTable table = new JTable(this.tmodel);
        table.setPreferredScrollableViewportSize(new Dimension(500, 300));
        table.setDefaultRenderer(Double.class, new DoubleRenderer());
        table.setIntercellSpacing(new Dimension(6, 3));
        table.setRowHeight(table.getRowHeight() + 4);
        JScrollPane scrollPane = new JScrollPane(table);
        this.add(scrollPane);
    }

    public void setMBeanServerConnection(MBeanServerConnection mbs) {
        this.server = mbs;
        try {
            this.tmbean = ManagementFactory.newPlatformMXBeanProxy(this.server, "java.lang:type=Threading", ThreadMXBean.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!this.tmbean.isThreadCpuTimeSupported()) {
            System.err.println("This VM does not support thread CPU time monitoring");
        } else {
            this.tmbean.setThreadCpuTimeEnabled(true);
        }
    }

    private List<Map.Entry<Long, ThreadInfo>> getThreadList() {
        long[] tids = this.tmbean.getAllThreadIds();
        ThreadInfo[] tinfos = this.tmbean.getThreadInfo(tids);
        TreeMap<Long, ThreadInfo> map = new TreeMap<Long, ThreadInfo>();
        for (int i = 0; i < tids.length; ++i) {
            long cpuTime = this.tmbean.getThreadCpuTime(tids[i]);
            if (cpuTime == -1L || tinfos[i] == null) continue;
            map.put(new Long(cpuTime), tinfos[i]);
        }
        Set set = map.entrySet();
        ArrayList<Map.Entry<Long, ThreadInfo>> list = new ArrayList<Map.Entry<Long, ThreadInfo>>(set);
        Collections.reverse(list);
        return list;
    }

    public SwingWorker<?, ?> newSwingWorker() {
        return new Worker(this.tmodel);
    }

    public static void main(String[] args) throws Exception {
        String[] arg2;
        if (args.length != 1) {
            JTop.usage();
        }
        if ((arg2 = args[0].split(":")).length != 2) {
            JTop.usage();
        }
        String hostname = arg2[0];
        int port = -1;
        try {
            port = Integer.parseInt(arg2[1]);
        }
        catch (NumberFormatException x) {
            JTop.usage();
        }
        if (port < 0) {
            JTop.usage();
        }
        final JTop jtop = new JTop();
        MBeanServerConnection server = JTop.connect(hostname, port);
        jtop.setMBeanServerConnection(server);
        TimerTask timerTask = new TimerTask(){

            public void run() {
                jtop.newSwingWorker().execute();
            }
        };
        SwingUtilities.invokeAndWait(new Runnable(){

            public void run() {
                JTop.createAndShowGUI(jtop);
            }
        });
        Timer timer = new Timer("JTop Sampling thread");
        timer.schedule(timerTask, 0L, 2000L);
    }

    private static MBeanServerConnection connect(String hostname, int port) {
        String urlPath = "/jndi/rmi://" + hostname + ":" + port + "/jmxrmi";
        MBeanServerConnection server = null;
        try {
            JMXServiceURL url = new JMXServiceURL("rmi", "", 0, urlPath);
            JMXConnector jmxc = JMXConnectorFactory.connect(url);
            server = jmxc.getMBeanServerConnection();
        }
        catch (MalformedURLException e) {
        }
        catch (IOException e) {
            System.err.println("\nCommunication error: " + e.getMessage());
            System.exit(1);
        }
        return server;
    }

    private static void usage() {
        System.out.println("Usage: java JTop <hostname>:<port>");
        System.exit(1);
    }

    private static void createAndShowGUI(JPanel jtop) {
        JFrame frame = new JFrame("JTop");
        frame.setDefaultCloseOperation(3);
        JComponent contentPane = (JComponent)frame.getContentPane();
        contentPane.add((Component)jtop, "Center");
        contentPane.setOpaque(true);
        contentPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        frame.setContentPane(contentPane);
        frame.pack();
        frame.setVisible(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Worker
    extends SwingWorker<List<Map.Entry<Long, ThreadInfo>>, Object> {
        private MyTableModel tmodel;

        Worker(MyTableModel tmodel) {
            this.tmodel = tmodel;
        }

        @Override
        public List<Map.Entry<Long, ThreadInfo>> doInBackground() {
            return JTop.this.getThreadList();
        }

        @Override
        protected void done() {
            try {
                this.tmodel.setThreadList((List)this.get());
                this.tmodel.fireTableDataChanged();
            }
            catch (InterruptedException e) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
    }

    class DoubleRenderer
    extends DefaultTableCellRenderer {
        NumberFormat formatter;

        public DoubleRenderer() {
            this.setHorizontalAlignment(4);
        }

        public void setValue(Object value) {
            if (this.formatter == null) {
                this.formatter = NumberFormat.getInstance();
                this.formatter.setMinimumFractionDigits(4);
            }
            this.setText(value == null ? "" : this.formatter.format(value));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyTableModel
    extends AbstractTableModel {
        private String[] columnNames = new String[]{"ThreadName", "CPU(sec)", "State"};
        private List<Map.Entry<Long, ThreadInfo>> threadList = Collections.EMPTY_LIST;

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.threadList.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            Map.Entry<Long, ThreadInfo> me = this.threadList.get(row);
            switch (col) {
                case 0: {
                    return me.getValue().getThreadName();
                }
                case 1: {
                    long ns = me.getKey();
                    double sec = ns / 1000000000L;
                    return new Double(sec);
                }
                case 2: {
                    return me.getValue().getThreadState();
                }
            }
            return null;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        void setThreadList(List<Map.Entry<Long, ThreadInfo>> list) {
            this.threadList = list;
        }
    }
}

