/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.InputStream;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalTheme;
import javax.swing.plaf.metal.OceanTheme;

public class MetalworksFrame
extends JFrame {
    JMenuBar menuBar;
    JDesktopPane desktop;
    JInternalFrame toolPalette;
    JCheckBoxMenuItem showToolPaletteMenuItem;
    static final Integer DOCLAYER = new Integer(5);
    static final Integer TOOLLAYER = new Integer(6);
    static final Integer HELPLAYER = new Integer(7);
    static final String ABOUTMSG = "Metalworks \n \nAn application written to show off the Java Look & Feel. \n \nWritten by the JavaSoft Look & Feel Team \n  Michael Albers\n  Tom Santos\n  Jeff Shapiro\n  Steve Wilson";

    public MetalworksFrame() {
        super("Metalworks");
        int inset = 50;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(50, 50, screenSize.width - 100, screenSize.height - 100);
        this.buildContent();
        this.buildMenus();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MetalworksFrame.this.quit();
            }
        });
        UIManager.addPropertyChangeListener(new UISwitchListener(this.getRootPane()));
    }

    protected void buildMenus() {
        this.menuBar = new JMenuBar();
        this.menuBar.setOpaque(true);
        JMenu file = this.buildFileMenu();
        JMenu edit = this.buildEditMenu();
        JMenu views = this.buildViewsMenu();
        JMenu speed = this.buildSpeedMenu();
        JMenu help = this.buildHelpMenu();
        PropertiesMetalTheme myTheme = null;
        try {
            InputStream istream = this.getClass().getResourceAsStream("/resources/MyTheme.theme");
            myTheme = new PropertiesMetalTheme(istream);
        }
        catch (NullPointerException e) {
            System.out.println(e);
        }
        MetalTheme[] themes = new MetalTheme[]{new OceanTheme(), new DefaultMetalTheme(), new GreenMetalTheme(), new AquaMetalTheme(), new KhakiMetalTheme(), new DemoMetalTheme(), new ContrastMetalTheme(), new BigContrastMetalTheme(), myTheme};
        MetalThemeMenu themeMenu = new MetalThemeMenu("Theme", themes);
        this.menuBar.add(file);
        this.menuBar.add(edit);
        this.menuBar.add(views);
        this.menuBar.add(themeMenu);
        this.menuBar.add(speed);
        this.menuBar.add(help);
        this.setJMenuBar(this.menuBar);
    }

    protected JMenu buildFileMenu() {
        JMenu file = new JMenu("File");
        JMenuItem newWin = new JMenuItem("New");
        JMenuItem open = new JMenuItem("Open");
        JMenuItem quit = new JMenuItem("Quit");
        newWin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MetalworksFrame.this.newDocument();
            }
        });
        open.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MetalworksFrame.this.openDocument();
            }
        });
        quit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MetalworksFrame.this.quit();
            }
        });
        file.add(newWin);
        file.add(open);
        file.addSeparator();
        file.add(quit);
        return file;
    }

    protected JMenu buildEditMenu() {
        JMenu edit = new JMenu("Edit");
        JMenuItem undo = new JMenuItem("Undo");
        JMenuItem copy = new JMenuItem("Copy");
        JMenuItem cut = new JMenuItem("Cut");
        JMenuItem paste = new JMenuItem("Paste");
        JMenuItem prefs = new JMenuItem("Preferences...");
        undo.setEnabled(false);
        copy.setEnabled(false);
        cut.setEnabled(false);
        paste.setEnabled(false);
        prefs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MetalworksFrame.this.openPrefsWindow();
            }
        });
        edit.add(undo);
        edit.addSeparator();
        edit.add(cut);
        edit.add(copy);
        edit.add(paste);
        edit.addSeparator();
        edit.add(prefs);
        return edit;
    }

    protected JMenu buildViewsMenu() {
        JMenu views = new JMenu("Views");
        JMenuItem inBox = new JMenuItem("Open In-Box");
        JMenuItem outBox = new JMenuItem("Open Out-Box");
        outBox.setEnabled(false);
        inBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MetalworksFrame.this.openInBox();
            }
        });
        views.add(inBox);
        views.add(outBox);
        return views;
    }

    protected JMenu buildSpeedMenu() {
        JMenu speed = new JMenu("Drag");
        JRadioButtonMenuItem live = new JRadioButtonMenuItem("Live");
        JRadioButtonMenuItem outline = new JRadioButtonMenuItem("Outline");
        JRadioButtonMenuItem slow = new JRadioButtonMenuItem("Old and Slow");
        ButtonGroup group = new ButtonGroup();
        group.add(live);
        group.add(outline);
        group.add(slow);
        live.setSelected(true);
        slow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MetalworksFrame.this.desktop.setDragMode(-1);
            }
        });
        live.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MetalworksFrame.this.desktop.setDragMode(0);
            }
        });
        outline.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MetalworksFrame.this.desktop.setDragMode(1);
            }
        });
        speed.add(live);
        speed.add(outline);
        speed.add(slow);
        return speed;
    }

    protected JMenu buildHelpMenu() {
        JMenu help = new JMenu("Help");
        JMenuItem about = new JMenuItem("About Metalworks...");
        JMenuItem openHelp = new JMenuItem("Open Help Window");
        about.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MetalworksFrame.this.showAboutBox();
            }
        });
        openHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MetalworksFrame.this.openHelpWindow();
            }
        });
        help.add(about);
        help.add(openHelp);
        return help;
    }

    protected void buildContent() {
        this.desktop = new JDesktopPane();
        this.getContentPane().add(this.desktop);
    }

    public void quit() {
        System.exit(0);
    }

    public void newDocument() {
        MetalworksDocumentFrame doc = new MetalworksDocumentFrame();
        this.desktop.add((Component)doc, DOCLAYER);
        try {
            doc.setVisible(true);
            doc.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void openDocument() {
        JFileChooser chooser = new JFileChooser();
        chooser.showOpenDialog(this);
    }

    public void openHelpWindow() {
        MetalworksHelp help = new MetalworksHelp();
        this.desktop.add((Component)help, HELPLAYER);
        try {
            help.setVisible(true);
            help.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public void showAboutBox() {
        JOptionPane.showMessageDialog(this, ABOUTMSG);
    }

    public void openPrefsWindow() {
        MetalworksPrefs dialog = new MetalworksPrefs(this);
        dialog.show();
    }

    public void openInBox() {
        MetalworksInBox doc = new MetalworksInBox();
        this.desktop.add((Component)doc, DOCLAYER);
        try {
            doc.setVisible(true);
            doc.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }
}

