/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class MetalThemeMenu
extends JMenu
implements ActionListener {
    MetalTheme[] themes;

    public MetalThemeMenu(String name, MetalTheme[] themeArray) {
        super(name);
        this.themes = themeArray;
        ButtonGroup group = new ButtonGroup();
        for (int i = 0; i < this.themes.length; ++i) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(this.themes[i].getName());
            group.add(item);
            this.add(item);
            item.setActionCommand(i + "");
            item.addActionListener(this);
            if (i != 0) continue;
            item.setSelected(true);
        }
    }

    public void actionPerformed(ActionEvent e) {
        String numStr = e.getActionCommand();
        MetalTheme selectedTheme = this.themes[Integer.parseInt(numStr)];
        MetalLookAndFeel.setCurrentTheme(selectedTheme);
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        }
        catch (Exception ex) {
            System.out.println("Failed loading Metal");
            System.out.println(ex);
        }
    }
}

