/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Container;
import java.awt.Cursor;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;

class HtmlPane
extends JScrollPane
implements HyperlinkListener {
    JEditorPane html;

    public HtmlPane() {
        try {
            URL url = this.getClass().getResource("/resources/HelpFiles/toc.html");
            this.html = new JEditorPane(url);
            this.html.setEditable(false);
            this.html.addHyperlinkListener(this);
            this.html.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            JViewport vp = this.getViewport();
            vp.add(this.html);
        }
        catch (MalformedURLException e) {
            System.out.println("Malformed URL: " + e);
        }
        catch (IOException e) {
            System.out.println("IOException: " + e);
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.linkActivated(e.getURL());
        }
    }

    protected void linkActivated(URL u) {
        Cursor c = this.html.getCursor();
        Cursor waitCursor = Cursor.getPredefinedCursor(3);
        this.html.setCursor(waitCursor);
        SwingUtilities.invokeLater(new PageLoader(u, c));
    }

    class PageLoader
    implements Runnable {
        URL url;
        Cursor cursor;

        PageLoader(URL u, Cursor c) {
            this.url = u;
            this.cursor = c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.url == null) {
                HtmlPane.this.html.setCursor(this.cursor);
                Container parent = HtmlPane.this.html.getParent();
                parent.repaint();
            } else {
                Document doc = HtmlPane.this.html.getDocument();
                try {
                    HtmlPane.this.html.setPage(this.url);
                }
                catch (IOException ioe) {
                    HtmlPane.this.html.setDocument(doc);
                    HtmlPane.this.getToolkit().beep();
                }
                finally {
                    this.url = null;
                    SwingUtilities.invokeLater(this);
                }
            }
        }
    }
}

