/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html.parser;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.io.Serializable;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.DTD;
import javax.swing.text.html.parser.DocumentParser;
import javax.swing.text.html.parser.ResourceLoader;

public class ParserDelegator
extends HTMLEditorKit.Parser
implements Serializable {
    private static DTD dtd = null;

    protected static synchronized void setDefaultDTD() {
        if (dtd == null) {
            DTD _dtd = null;
            String nm = "html32";
            try {
                _dtd = DTD.getDTD(nm);
            }
            catch (IOException e) {
                System.out.println("Throw an exception: could not get default dtd: " + nm);
            }
            dtd = ParserDelegator.createDTD(_dtd, nm);
        }
    }

    protected static DTD createDTD(DTD dtd, String name) {
        InputStream in = null;
        boolean debug = true;
        try {
            String path = name + ".bdtd";
            in = ParserDelegator.getResourceAsStream(path);
            if (in != null) {
                dtd.read(new DataInputStream(new BufferedInputStream(in)));
                DTD.putDTDHash(name, dtd);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return dtd;
    }

    public ParserDelegator() {
        if (dtd == null) {
            ParserDelegator.setDefaultDTD();
        }
    }

    @Override
    public void parse(Reader r, HTMLEditorKit.ParserCallback cb, boolean ignoreCharSet) throws IOException {
        new DocumentParser(dtd).parse(r, cb, ignoreCharSet);
    }

    static InputStream getResourceAsStream(String name) {
        try {
            return ResourceLoader.getResourceAsStream(name);
        }
        catch (Throwable e) {
            return ParserDelegator.class.getResourceAsStream(name);
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        if (dtd == null) {
            ParserDelegator.setDefaultDTD();
        }
    }
}

