/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.BreakIterator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.FlowView;
import javax.swing.text.GlyphPainter2;
import javax.swing.text.GlyphView;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import sun.font.BidiUtils;
import sun.swing.SwingUtilities2;

class TextLayoutStrategy
extends FlowView.FlowStrategy {
    private LineBreakMeasurer measurer;
    private AttributedSegment text = new AttributedSegment();

    @Override
    public void insertUpdate(FlowView fv, DocumentEvent e, Rectangle alloc) {
        this.sync(fv);
        super.insertUpdate(fv, e, alloc);
    }

    @Override
    public void removeUpdate(FlowView fv, DocumentEvent e, Rectangle alloc) {
        this.sync(fv);
        super.removeUpdate(fv, e, alloc);
    }

    @Override
    public void changedUpdate(FlowView fv, DocumentEvent e, Rectangle alloc) {
        this.sync(fv);
        super.changedUpdate(fv, e, alloc);
    }

    @Override
    public void layout(FlowView fv) {
        super.layout(fv);
    }

    @Override
    protected int layoutRow(FlowView fv, int rowIndex, int p0) {
        int n;
        int p1 = super.layoutRow(fv, rowIndex, p0);
        View row = fv.getView(rowIndex);
        Document doc = fv.getDocument();
        Object i18nFlag = doc.getProperty("i18n");
        if (i18nFlag != null && i18nFlag.equals(Boolean.TRUE) && (n = row.getViewCount()) > 1) {
            AbstractDocument d = (AbstractDocument)fv.getDocument();
            Element bidiRoot = d.getBidiRootElement();
            byte[] levels = new byte[n];
            Object[] reorder = new View[n];
            for (int i = 0; i < n; ++i) {
                View v = row.getView(i);
                int bidiIndex = bidiRoot.getElementIndex(v.getStartOffset());
                Element bidiElem = bidiRoot.getElement(bidiIndex);
                levels[i] = (byte)StyleConstants.getBidiLevel(bidiElem.getAttributes());
                reorder[i] = v;
            }
            BidiUtils.reorderVisually(levels, reorder);
            row.replace(0, n, (View[])reorder);
        }
        return p1;
    }

    @Override
    protected void adjustRow(FlowView fv, int rowIndex, int desiredSpan, int x) {
    }

    @Override
    protected View createView(FlowView fv, int startOffset, int spanLeft, int rowIndex) {
        View lv = this.getLogicalView(fv);
        View row = fv.getView(rowIndex);
        boolean requireNextWord = this.viewBuffer.size() != 0;
        int childIndex = lv.getViewIndex(startOffset, Position.Bias.Forward);
        View v = lv.getView(childIndex);
        int endOffset = this.getLimitingOffset(v, startOffset, spanLeft, requireNextWord);
        if (endOffset == startOffset) {
            return null;
        }
        View frag = startOffset == v.getStartOffset() && endOffset == v.getEndOffset() ? v : v.createFragment(startOffset, endOffset);
        if (frag instanceof GlyphView && this.measurer != null) {
            TextLayout tl;
            Segment s;
            char ch;
            boolean isTab = false;
            int p0 = frag.getStartOffset();
            int p1 = frag.getEndOffset();
            if (p1 - p0 == 1 && (ch = (s = ((GlyphView)frag).getText(p0, p1)).first()) == '\t') {
                isTab = true;
            }
            TextLayout textLayout = tl = isTab ? null : this.measurer.nextLayout(spanLeft, this.text.toIteratorIndex(endOffset), requireNextWord);
            if (tl != null) {
                ((GlyphView)frag).setGlyphPainter(new GlyphPainter2(tl));
            }
        }
        return frag;
    }

    int getLimitingOffset(View v, int startOffset, int spanLeft, boolean requireNextWord) {
        AbstractDocument d;
        Element bidiRoot;
        int endOffset = v.getEndOffset();
        Document doc = v.getDocument();
        if (doc instanceof AbstractDocument && (bidiRoot = (d = (AbstractDocument)doc).getBidiRootElement()).getElementCount() > 1) {
            int bidiIndex = bidiRoot.getElementIndex(startOffset);
            Element bidiElem = bidiRoot.getElement(bidiIndex);
            endOffset = Math.min(bidiElem.getEndOffset(), endOffset);
        }
        if (v instanceof GlyphView) {
            Segment s = ((GlyphView)v).getText(startOffset, endOffset);
            char ch = s.first();
            if (ch == '\t') {
                endOffset = startOffset + 1;
            } else {
                ch = s.next();
                while (ch != '\uffff') {
                    if (ch == '\t') {
                        endOffset = startOffset + s.getIndex() - s.getBeginIndex();
                        break;
                    }
                    ch = s.next();
                }
            }
        }
        int limitIndex = this.text.toIteratorIndex(endOffset);
        if (this.measurer != null) {
            int index = this.text.toIteratorIndex(startOffset);
            if (this.measurer.getPosition() != index) {
                this.measurer.setPosition(index);
            }
            limitIndex = this.measurer.nextOffset(spanLeft, limitIndex, requireNextWord);
        }
        int pos = this.text.toModelPosition(limitIndex);
        return pos;
    }

    void sync(FlowView fv) {
        View lv = this.getLogicalView(fv);
        this.text.setView(lv);
        Container container = fv.getContainer();
        FontRenderContext frc = SwingUtilities2.getFontRenderContext(container);
        Container c = fv.getContainer();
        BreakIterator iter = c != null ? BreakIterator.getLineInstance(c.getLocale()) : BreakIterator.getLineInstance();
        this.measurer = new LineBreakMeasurer(this.text, iter, frc);
        int n = lv.getViewCount();
        for (int i = 0; i < n; ++i) {
            View child = lv.getView(i);
            if (!(child instanceof GlyphView)) continue;
            int p0 = child.getStartOffset();
            int p1 = child.getEndOffset();
            this.measurer.setPosition(this.text.toIteratorIndex(p0));
            TextLayout layout = this.measurer.nextLayout(Float.MAX_VALUE, this.text.toIteratorIndex(p1), false);
            ((GlyphView)child).setGlyphPainter(new GlyphPainter2(layout));
        }
        this.measurer.setPosition(this.text.getBeginIndex());
    }

    static class AttributedSegment
    extends Segment
    implements AttributedCharacterIterator {
        View v;
        static Set keys = new HashSet();

        AttributedSegment() {
        }

        View getView() {
            return this.v;
        }

        void setView(View v) {
            this.v = v;
            Document doc = v.getDocument();
            int p0 = v.getStartOffset();
            int p1 = v.getEndOffset();
            try {
                doc.getText(p0, p1 - p0, this);
            }
            catch (BadLocationException bl) {
                throw new IllegalArgumentException("Invalid view");
            }
            this.first();
        }

        int getFontBoundary(int childIndex, int dir) {
            Font next;
            View child = this.v.getView(childIndex);
            Font f = this.getFont(childIndex);
            childIndex += dir;
            while (childIndex >= 0 && childIndex < this.v.getViewCount() && (next = this.getFont(childIndex)) == f) {
                child = this.v.getView(childIndex);
                childIndex += dir;
            }
            return dir < 0 ? child.getStartOffset() : child.getEndOffset();
        }

        Font getFont(int childIndex) {
            View child = this.v.getView(childIndex);
            if (child instanceof GlyphView) {
                return ((GlyphView)child).getFont();
            }
            return null;
        }

        int toModelPosition(int index) {
            return this.v.getStartOffset() + (index - this.getBeginIndex());
        }

        int toIteratorIndex(int pos) {
            return pos - this.v.getStartOffset() + this.getBeginIndex();
        }

        @Override
        public int getRunStart() {
            int pos = this.toModelPosition(this.getIndex());
            int i = this.v.getViewIndex(pos, Position.Bias.Forward);
            View child = this.v.getView(i);
            return this.toIteratorIndex(child.getStartOffset());
        }

        @Override
        public int getRunStart(AttributedCharacterIterator.Attribute attribute) {
            if (attribute instanceof TextAttribute) {
                int pos = this.toModelPosition(this.getIndex());
                int i = this.v.getViewIndex(pos, Position.Bias.Forward);
                if (attribute == TextAttribute.FONT) {
                    return this.toIteratorIndex(this.getFontBoundary(i, -1));
                }
            }
            return this.getBeginIndex();
        }

        @Override
        public int getRunStart(Set<? extends AttributedCharacterIterator.Attribute> attributes) {
            int index = this.getBeginIndex();
            Object[] a = attributes.toArray();
            for (int i = 0; i < a.length; ++i) {
                TextAttribute attr = (TextAttribute)a[i];
                index = Math.max(this.getRunStart(attr), index);
            }
            return Math.min(this.getIndex(), index);
        }

        @Override
        public int getRunLimit() {
            int pos = this.toModelPosition(this.getIndex());
            int i = this.v.getViewIndex(pos, Position.Bias.Forward);
            View child = this.v.getView(i);
            return this.toIteratorIndex(child.getEndOffset());
        }

        @Override
        public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
            if (attribute instanceof TextAttribute) {
                int pos = this.toModelPosition(this.getIndex());
                int i = this.v.getViewIndex(pos, Position.Bias.Forward);
                if (attribute == TextAttribute.FONT) {
                    return this.toIteratorIndex(this.getFontBoundary(i, 1));
                }
            }
            return this.getEndIndex();
        }

        @Override
        public int getRunLimit(Set<? extends AttributedCharacterIterator.Attribute> attributes) {
            int index = this.getEndIndex();
            Object[] a = attributes.toArray();
            for (int i = 0; i < a.length; ++i) {
                TextAttribute attr = (TextAttribute)a[i];
                index = Math.min(this.getRunLimit(attr), index);
            }
            return Math.max(this.getIndex(), index);
        }

        public Map getAttributes() {
            Object[] ka = keys.toArray();
            Hashtable<TextAttribute, Object> h = new Hashtable<TextAttribute, Object>();
            for (int i = 0; i < ka.length; ++i) {
                TextAttribute a = (TextAttribute)ka[i];
                Object value = this.getAttribute(a);
                if (value == null) continue;
                h.put(a, value);
            }
            return h;
        }

        @Override
        public Object getAttribute(AttributedCharacterIterator.Attribute attribute) {
            int pos = this.toModelPosition(this.getIndex());
            int childIndex = this.v.getViewIndex(pos, Position.Bias.Forward);
            if (attribute == TextAttribute.FONT) {
                return this.getFont(childIndex);
            }
            if (attribute == TextAttribute.RUN_DIRECTION) {
                return this.v.getDocument().getProperty(TextAttribute.RUN_DIRECTION);
            }
            return null;
        }

        public Set getAllAttributeKeys() {
            return keys;
        }

        static {
            keys.add(TextAttribute.FONT);
            keys.add(TextAttribute.RUN_DIRECTION);
        }
    }
}

