/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ToolBarUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.LazyActionMap;
import sun.swing.DefaultLookup;
import sun.swing.UIAction;

public class BasicToolBarUI
extends ToolBarUI
implements SwingConstants {
    protected JToolBar toolBar;
    private boolean floating;
    private int floatingX;
    private int floatingY;
    private JFrame floatingFrame;
    private RootPaneContainer floatingToolBar;
    protected DragWindow dragWindow;
    private Container dockingSource;
    private int dockingSensitivity = 0;
    protected int focusedCompIndex = -1;
    protected Color dockingColor = null;
    protected Color floatingColor = null;
    protected Color dockingBorderColor = null;
    protected Color floatingBorderColor = null;
    protected MouseInputListener dockingListener;
    protected PropertyChangeListener propertyListener;
    protected ContainerListener toolBarContListener;
    protected FocusListener toolBarFocusListener;
    private Handler handler;
    protected String constraintBeforeFloating = "North";
    private static String IS_ROLLOVER = "JToolBar.isRollover";
    private static Border rolloverBorder;
    private static Border nonRolloverBorder;
    private static Border nonRolloverToggleBorder;
    private boolean rolloverBorders = false;
    private HashMap borderTable = new HashMap();
    private Hashtable rolloverTable = new Hashtable();
    @Deprecated
    protected KeyStroke upKey;
    @Deprecated
    protected KeyStroke downKey;
    @Deprecated
    protected KeyStroke leftKey;
    @Deprecated
    protected KeyStroke rightKey;
    private static String FOCUSED_COMP_INDEX;

    public static ComponentUI createUI(JComponent c) {
        return new BasicToolBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.toolBar = (JToolBar)c;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        this.installKeyboardActions();
        this.dockingSensitivity = 0;
        this.floating = false;
        this.floatingY = 0;
        this.floatingX = 0;
        this.floatingToolBar = null;
        this.setOrientation(this.toolBar.getOrientation());
        LookAndFeel.installProperty(c, "opaque", Boolean.TRUE);
        if (c.getClientProperty(FOCUSED_COMP_INDEX) != null) {
            this.focusedCompIndex = (Integer)c.getClientProperty(FOCUSED_COMP_INDEX);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallDefaults();
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        if (this.isFloating()) {
            this.setFloating(false, null);
        }
        this.floatingToolBar = null;
        this.dragWindow = null;
        this.dockingSource = null;
        c.putClientProperty(FOCUSED_COMP_INDEX, new Integer(this.focusedCompIndex));
    }

    protected void installDefaults() {
        Object rolloverProp;
        LookAndFeel.installBorder(this.toolBar, "ToolBar.border");
        LookAndFeel.installColorsAndFont(this.toolBar, "ToolBar.background", "ToolBar.foreground", "ToolBar.font");
        if (this.dockingColor == null || this.dockingColor instanceof UIResource) {
            this.dockingColor = UIManager.getColor("ToolBar.dockingBackground");
        }
        if (this.floatingColor == null || this.floatingColor instanceof UIResource) {
            this.floatingColor = UIManager.getColor("ToolBar.floatingBackground");
        }
        if (this.dockingBorderColor == null || this.dockingBorderColor instanceof UIResource) {
            this.dockingBorderColor = UIManager.getColor("ToolBar.dockingForeground");
        }
        if (this.floatingBorderColor == null || this.floatingBorderColor instanceof UIResource) {
            this.floatingBorderColor = UIManager.getColor("ToolBar.floatingForeground");
        }
        if ((rolloverProp = this.toolBar.getClientProperty(IS_ROLLOVER)) == null) {
            rolloverProp = UIManager.get("ToolBar.isRollover");
        }
        if (rolloverProp != null) {
            this.rolloverBorders = (Boolean)rolloverProp;
        }
        if (rolloverBorder == null) {
            rolloverBorder = this.createRolloverBorder();
        }
        if (nonRolloverBorder == null) {
            nonRolloverBorder = this.createNonRolloverBorder();
        }
        if (nonRolloverToggleBorder == null) {
            nonRolloverToggleBorder = this.createNonRolloverToggleBorder();
        }
        this.setRolloverBorders(this.isRolloverBorders());
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.toolBar);
        this.dockingColor = null;
        this.floatingColor = null;
        this.dockingBorderColor = null;
        this.floatingBorderColor = null;
        this.installNormalBorders(this.toolBar);
        rolloverBorder = null;
        nonRolloverBorder = null;
        nonRolloverToggleBorder = null;
    }

    protected void installComponents() {
    }

    protected void uninstallComponents() {
    }

    protected void installListeners() {
        this.dockingListener = this.createDockingListener();
        if (this.dockingListener != null) {
            this.toolBar.addMouseMotionListener(this.dockingListener);
            this.toolBar.addMouseListener(this.dockingListener);
        }
        this.propertyListener = this.createPropertyListener();
        if (this.propertyListener != null) {
            this.toolBar.addPropertyChangeListener(this.propertyListener);
        }
        this.toolBarContListener = this.createToolBarContListener();
        if (this.toolBarContListener != null) {
            this.toolBar.addContainerListener(this.toolBarContListener);
        }
        this.toolBarFocusListener = this.createToolBarFocusListener();
        if (this.toolBarFocusListener != null) {
            Component[] components = this.toolBar.getComponents();
            for (int i = 0; i < components.length; ++i) {
                components[i].addFocusListener(this.toolBarFocusListener);
            }
        }
    }

    protected void uninstallListeners() {
        if (this.dockingListener != null) {
            this.toolBar.removeMouseMotionListener(this.dockingListener);
            this.toolBar.removeMouseListener(this.dockingListener);
            this.dockingListener = null;
        }
        if (this.propertyListener != null) {
            this.toolBar.removePropertyChangeListener(this.propertyListener);
            this.propertyListener = null;
        }
        if (this.toolBarContListener != null) {
            this.toolBar.removeContainerListener(this.toolBarContListener);
            this.toolBarContListener = null;
        }
        if (this.toolBarFocusListener != null) {
            Component[] components = this.toolBar.getComponents();
            for (int i = 0; i < components.length; ++i) {
                components[i].removeFocusListener(this.toolBarFocusListener);
            }
            this.toolBarFocusListener = null;
        }
        this.handler = null;
    }

    protected void installKeyboardActions() {
        InputMap km = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.toolBar, 1, km);
        LazyActionMap.installLazyActionMap(this.toolBar, BasicToolBarUI.class, "ToolBar.actionMap");
    }

    InputMap getInputMap(int condition) {
        if (condition == 1) {
            return (InputMap)DefaultLookup.get(this.toolBar, this, "ToolBar.ancestorInputMap");
        }
        return null;
    }

    static void loadActionMap(LazyActionMap map) {
        map.put(new Actions("navigateRight"));
        map.put(new Actions("navigateLeft"));
        map.put(new Actions("navigateUp"));
        map.put(new Actions("navigateDown"));
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.toolBar, null);
        SwingUtilities.replaceUIInputMap(this.toolBar, 1, null);
    }

    protected void navigateFocusedComp(int direction) {
        int nComp = this.toolBar.getComponentCount();
        block0 : switch (direction) {
            case 3: 
            case 5: {
                if (this.focusedCompIndex < 0 || this.focusedCompIndex >= nComp) break;
                int j = this.focusedCompIndex + 1;
                while (j != this.focusedCompIndex) {
                    Component comp;
                    if (j >= nComp) {
                        j = 0;
                    }
                    if ((comp = this.toolBar.getComponentAtIndex(j++)) == null || !comp.isFocusTraversable() || !comp.isEnabled()) continue;
                    comp.requestFocus();
                    break block0;
                }
                break;
            }
            case 1: 
            case 7: {
                if (this.focusedCompIndex < 0 || this.focusedCompIndex >= nComp) break;
                int j = this.focusedCompIndex - 1;
                while (j != this.focusedCompIndex) {
                    Component comp;
                    if (j < 0) {
                        j = nComp - 1;
                    }
                    if ((comp = this.toolBar.getComponentAtIndex(j--)) == null || !comp.isFocusTraversable() || !comp.isEnabled()) continue;
                    comp.requestFocus();
                    break block0;
                }
                break;
            }
        }
    }

    protected Border createRolloverBorder() {
        Object border = UIManager.get("ToolBar.rolloverBorder");
        if (border != null) {
            return (Border)border;
        }
        UIDefaults table = UIManager.getLookAndFeelDefaults();
        return new CompoundBorder(new BasicBorders.RolloverButtonBorder(table.getColor("controlShadow"), table.getColor("controlDkShadow"), table.getColor("controlHighlight"), table.getColor("controlLtHighlight")), new BasicBorders.RolloverMarginBorder());
    }

    protected Border createNonRolloverBorder() {
        Object border = UIManager.get("ToolBar.nonrolloverBorder");
        if (border != null) {
            return (Border)border;
        }
        UIDefaults table = UIManager.getLookAndFeelDefaults();
        return new CompoundBorder(new BasicBorders.ButtonBorder(table.getColor("Button.shadow"), table.getColor("Button.darkShadow"), table.getColor("Button.light"), table.getColor("Button.highlight")), new BasicBorders.RolloverMarginBorder());
    }

    private Border createNonRolloverToggleBorder() {
        UIDefaults table = UIManager.getLookAndFeelDefaults();
        return new CompoundBorder(new BasicBorders.RadioButtonBorder(table.getColor("ToggleButton.shadow"), table.getColor("ToggleButton.darkShadow"), table.getColor("ToggleButton.light"), table.getColor("ToggleButton.highlight")), new BasicBorders.RolloverMarginBorder());
    }

    protected JFrame createFloatingFrame(JToolBar toolbar) {
        Window window = SwingUtilities.getWindowAncestor(toolbar);
        JFrame frame = new JFrame(toolbar.getName(), window != null ? window.getGraphicsConfiguration() : null){

            @Override
            protected JRootPane createRootPane() {
                JRootPane rootPane = new JRootPane(){
                    private boolean packing = false;

                    @Override
                    public void validate() {
                        super.validate();
                        if (!this.packing) {
                            this.packing = true;
                            this.pack();
                            this.packing = false;
                        }
                    }
                };
                rootPane.setOpaque(true);
                return rootPane;
            }
        };
        frame.getRootPane().setName("ToolBar.FloatingFrame");
        frame.setResizable(false);
        WindowListener wl = this.createFrameListener();
        frame.addWindowListener(wl);
        return frame;
    }

    protected RootPaneContainer createFloatingWindow(JToolBar toolbar) {
        Window window = SwingUtilities.getWindowAncestor(toolbar);
        class ToolBarDialog
        extends JDialog {
            public ToolBarDialog(Frame owner, String title, boolean modal) {
                super(owner, title, modal);
            }

            public ToolBarDialog(Dialog owner, String title, boolean modal) {
                super(owner, title, modal);
            }

            @Override
            protected JRootPane createRootPane() {
                JRootPane rootPane = new JRootPane(){
                    private boolean packing = false;

                    @Override
                    public void validate() {
                        super.validate();
                        if (!this.packing) {
                            this.packing = true;
                            this.pack();
                            this.packing = false;
                        }
                    }
                };
                rootPane.setOpaque(true);
                return rootPane;
            }
        }
        ToolBarDialog dialog = window instanceof Frame ? new ToolBarDialog((Frame)window, toolbar.getName(), false) : (window instanceof Dialog ? new ToolBarDialog((Dialog)window, toolbar.getName(), false) : new ToolBarDialog((Frame)null, toolbar.getName(), false));
        dialog.getRootPane().setName("ToolBar.FloatingWindow");
        dialog.setTitle(toolbar.getName());
        dialog.setResizable(false);
        WindowListener wl = this.createFrameListener();
        dialog.addWindowListener(wl);
        return dialog;
    }

    protected DragWindow createDragWindow(JToolBar toolbar) {
        Window frame = null;
        if (this.toolBar != null) {
            Container p;
            for (p = this.toolBar.getParent(); p != null && !(p instanceof Window); p = p.getParent()) {
            }
            if (p != null && p instanceof Window) {
                frame = (Window)p;
            }
        }
        if (this.floatingToolBar == null) {
            this.floatingToolBar = this.createFloatingWindow(this.toolBar);
        }
        if (this.floatingToolBar instanceof Window) {
            frame = (Window)((Object)this.floatingToolBar);
        }
        DragWindow dragWindow = new DragWindow(frame);
        return dragWindow;
    }

    public boolean isRolloverBorders() {
        return this.rolloverBorders;
    }

    public void setRolloverBorders(boolean rollover) {
        this.rolloverBorders = rollover;
        if (this.rolloverBorders) {
            this.installRolloverBorders(this.toolBar);
        } else {
            this.installNonRolloverBorders(this.toolBar);
        }
    }

    protected void installRolloverBorders(JComponent c) {
        Component[] components = c.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof JComponent)) continue;
            ((JComponent)components[i]).updateUI();
            this.setBorderToRollover(components[i]);
        }
    }

    protected void installNonRolloverBorders(JComponent c) {
        Component[] components = c.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof JComponent)) continue;
            ((JComponent)components[i]).updateUI();
            this.setBorderToNonRollover(components[i]);
        }
    }

    protected void installNormalBorders(JComponent c) {
        Component[] components = c.getComponents();
        for (int i = 0; i < components.length; ++i) {
            this.setBorderToNormal(components[i]);
        }
    }

    protected void setBorderToRollover(Component c) {
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            Border border = (Border)this.borderTable.get(b);
            if (border == null || border instanceof UIResource) {
                this.borderTable.put(b, b.getBorder());
            }
            if (b.getBorder() instanceof UIResource) {
                b.setBorder(this.getRolloverBorder(b));
            }
            this.rolloverTable.put(b, b.isRolloverEnabled() ? Boolean.TRUE : Boolean.FALSE);
            b.setRolloverEnabled(true);
        }
    }

    protected Border getRolloverBorder(AbstractButton b) {
        return rolloverBorder;
    }

    protected void setBorderToNonRollover(Component c) {
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            Border border = (Border)this.borderTable.get(b);
            if (border == null || border instanceof UIResource) {
                this.borderTable.put(b, b.getBorder());
            }
            if (b.getBorder() instanceof UIResource) {
                b.setBorder(this.getNonRolloverBorder(b));
            }
            this.rolloverTable.put(b, b.isRolloverEnabled() ? Boolean.TRUE : Boolean.FALSE);
            b.setRolloverEnabled(false);
        }
    }

    protected Border getNonRolloverBorder(AbstractButton b) {
        if (b instanceof JToggleButton) {
            return nonRolloverToggleBorder;
        }
        return nonRolloverBorder;
    }

    protected void setBorderToNormal(Component c) {
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            Border border = (Border)this.borderTable.remove(b);
            b.setBorder(border);
            Boolean value = (Boolean)this.rolloverTable.remove(b);
            if (value != null) {
                b.setRolloverEnabled(value);
            }
        }
    }

    public void setFloatingLocation(int x, int y) {
        this.floatingX = x;
        this.floatingY = y;
    }

    public boolean isFloating() {
        return this.floating;
    }

    public void setFloating(boolean b, Point p) {
        if (this.toolBar.isFloatable()) {
            boolean visible = false;
            Window ancestor = SwingUtilities.getWindowAncestor(this.toolBar);
            if (ancestor != null) {
                visible = ancestor.isVisible();
            }
            if (this.dragWindow != null) {
                this.dragWindow.setVisible(false);
            }
            this.floating = b;
            if (this.floatingToolBar == null) {
                this.floatingToolBar = this.createFloatingWindow(this.toolBar);
            }
            if (b) {
                if (this.dockingSource == null) {
                    this.dockingSource = this.toolBar.getParent();
                    this.dockingSource.remove(this.toolBar);
                }
                this.constraintBeforeFloating = this.calculateConstraint();
                if (this.propertyListener != null) {
                    UIManager.addPropertyChangeListener(this.propertyListener);
                }
                this.floatingToolBar.getContentPane().add((Component)this.toolBar, "Center");
                if (this.floatingToolBar instanceof Window) {
                    ((Window)((Object)this.floatingToolBar)).pack();
                    ((Window)((Object)this.floatingToolBar)).setLocation(this.floatingX, this.floatingY);
                    if (visible) {
                        ((Window)((Object)this.floatingToolBar)).show();
                    } else {
                        ancestor.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowOpened(WindowEvent e) {
                                ((Window)((Object)BasicToolBarUI.this.floatingToolBar)).show();
                            }
                        });
                    }
                }
            } else {
                if (this.floatingToolBar == null) {
                    this.floatingToolBar = this.createFloatingWindow(this.toolBar);
                }
                if (this.floatingToolBar instanceof Window) {
                    ((Window)((Object)this.floatingToolBar)).setVisible(false);
                }
                this.floatingToolBar.getContentPane().remove(this.toolBar);
                String constraint = this.getDockingConstraint(this.dockingSource, p);
                if (constraint == null) {
                    constraint = "North";
                }
                int orientation = this.mapConstraintToOrientation(constraint);
                this.setOrientation(orientation);
                if (this.dockingSource == null) {
                    this.dockingSource = this.toolBar.getParent();
                }
                if (this.propertyListener != null) {
                    UIManager.removePropertyChangeListener(this.propertyListener);
                }
                this.dockingSource.add(constraint, this.toolBar);
            }
            this.dockingSource.invalidate();
            Container dockingSourceParent = this.dockingSource.getParent();
            if (dockingSourceParent != null) {
                dockingSourceParent.validate();
            }
            this.dockingSource.repaint();
        }
    }

    private int mapConstraintToOrientation(String constraint) {
        int orientation = this.toolBar.getOrientation();
        if (constraint != null) {
            if (constraint.equals("East") || constraint.equals("West")) {
                orientation = 1;
            } else if (constraint.equals("North") || constraint.equals("South")) {
                orientation = 0;
            }
        }
        return orientation;
    }

    public void setOrientation(int orientation) {
        this.toolBar.setOrientation(orientation);
        if (this.dragWindow != null) {
            this.dragWindow.setOrientation(orientation);
        }
    }

    public Color getDockingColor() {
        return this.dockingColor;
    }

    public void setDockingColor(Color c) {
        this.dockingColor = c;
    }

    public Color getFloatingColor() {
        return this.floatingColor;
    }

    public void setFloatingColor(Color c) {
        this.floatingColor = c;
    }

    private boolean isBlocked(Component comp, Object constraint) {
        Container cont;
        LayoutManager lm;
        if (comp instanceof Container && (lm = (cont = (Container)comp).getLayout()) instanceof BorderLayout) {
            BorderLayout blm = (BorderLayout)lm;
            Component c = blm.getLayoutComponent(cont, constraint);
            return c != null && c != this.toolBar;
        }
        return false;
    }

    public boolean canDock(Component c, Point p) {
        return p != null && this.getDockingConstraint(c, p) != null;
    }

    private String calculateConstraint() {
        String constraint = null;
        LayoutManager lm = this.dockingSource.getLayout();
        if (lm instanceof BorderLayout) {
            constraint = (String)((BorderLayout)lm).getConstraints(this.toolBar);
        }
        return constraint != null ? constraint : this.constraintBeforeFloating;
    }

    private String getDockingConstraint(Component c, Point p) {
        if (p == null) {
            return this.constraintBeforeFloating;
        }
        if (c.contains(p)) {
            int n = this.dockingSensitivity = this.toolBar.getOrientation() == 0 ? this.toolBar.getSize().height : this.toolBar.getSize().width;
            if (p.y < this.dockingSensitivity && !this.isBlocked(c, "North")) {
                return "North";
            }
            if (p.x >= c.getWidth() - this.dockingSensitivity && !this.isBlocked(c, "East")) {
                return "East";
            }
            if (p.x < this.dockingSensitivity && !this.isBlocked(c, "West")) {
                return "West";
            }
            if (p.y >= c.getHeight() - this.dockingSensitivity && !this.isBlocked(c, "South")) {
                return "South";
            }
        }
        return null;
    }

    protected void dragTo(Point position, Point origin) {
        if (this.toolBar.isFloatable()) {
            try {
                Point offset;
                if (this.dragWindow == null) {
                    this.dragWindow = this.createDragWindow(this.toolBar);
                }
                if ((offset = this.dragWindow.getOffset()) == null) {
                    Dimension size = this.toolBar.getPreferredSize();
                    offset = new Point(size.width / 2, size.height / 2);
                    this.dragWindow.setOffset(offset);
                }
                Point global = new Point(origin.x + position.x, origin.y + position.y);
                Point dragPoint = new Point(global.x - offset.x, global.y - offset.y);
                if (this.dockingSource == null) {
                    this.dockingSource = this.toolBar.getParent();
                }
                this.constraintBeforeFloating = this.calculateConstraint();
                Point dockingPosition = this.dockingSource.getLocationOnScreen();
                Point comparisonPoint = new Point(global.x - dockingPosition.x, global.y - dockingPosition.y);
                if (this.canDock(this.dockingSource, comparisonPoint)) {
                    this.dragWindow.setBackground(this.getDockingColor());
                    String constraint = this.getDockingConstraint(this.dockingSource, comparisonPoint);
                    int orientation = this.mapConstraintToOrientation(constraint);
                    this.dragWindow.setOrientation(orientation);
                    this.dragWindow.setBorderColor(this.dockingBorderColor);
                } else {
                    this.dragWindow.setBackground(this.getFloatingColor());
                    this.dragWindow.setBorderColor(this.floatingBorderColor);
                    this.dragWindow.setOrientation(this.toolBar.getOrientation());
                }
                this.dragWindow.setLocation(dragPoint.x, dragPoint.y);
                if (!this.dragWindow.isVisible()) {
                    Dimension size = this.toolBar.getPreferredSize();
                    this.dragWindow.setSize(size.width, size.height);
                    this.dragWindow.show();
                }
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    protected void floatAt(Point position, Point origin) {
        if (this.toolBar.isFloatable()) {
            try {
                Point offset = this.dragWindow.getOffset();
                if (offset == null) {
                    offset = position;
                    this.dragWindow.setOffset(offset);
                }
                Point global = new Point(origin.x + position.x, origin.y + position.y);
                this.setFloatingLocation(global.x - offset.x, global.y - offset.y);
                if (this.dockingSource != null) {
                    Point dockingPosition = this.dockingSource.getLocationOnScreen();
                    Point comparisonPoint = new Point(global.x - dockingPosition.x, global.y - dockingPosition.y);
                    if (this.canDock(this.dockingSource, comparisonPoint)) {
                        this.setFloating(false, comparisonPoint);
                    } else {
                        this.setFloating(true, null);
                    }
                } else {
                    this.setFloating(true, null);
                }
                this.dragWindow.setOffset(null);
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected ContainerListener createToolBarContListener() {
        return this.getHandler();
    }

    protected FocusListener createToolBarFocusListener() {
        return this.getHandler();
    }

    protected PropertyChangeListener createPropertyListener() {
        return this.getHandler();
    }

    protected MouseInputListener createDockingListener() {
        this.getHandler().tb = this.toolBar;
        return this.getHandler();
    }

    protected WindowListener createFrameListener() {
        return new FrameListener();
    }

    protected void paintDragWindow(Graphics g) {
        g.setColor(this.dragWindow.getBackground());
        int w = this.dragWindow.getWidth();
        int h = this.dragWindow.getHeight();
        g.fillRect(0, 0, w, h);
        g.setColor(this.dragWindow.getBorderColor());
        g.drawRect(0, 0, w - 1, h - 1);
    }

    static {
        FOCUSED_COMP_INDEX = "JToolBar.focusedCompIndex";
    }

    protected class DragWindow
    extends Window {
        Color borderColor;
        int orientation;
        Point offset;

        DragWindow(Window w) {
            super(w);
            this.borderColor = Color.gray;
            this.orientation = BasicToolBarUI.this.toolBar.getOrientation();
        }

        public int getOrientation() {
            return this.orientation;
        }

        public void setOrientation(int o) {
            if (this.isShowing()) {
                if (o == this.orientation) {
                    return;
                }
                this.orientation = o;
                Dimension size = this.getSize();
                this.setSize(new Dimension(size.height, size.width));
                if (this.offset != null) {
                    if (BasicGraphicsUtils.isLeftToRight(BasicToolBarUI.this.toolBar)) {
                        this.setOffset(new Point(this.offset.y, this.offset.x));
                    } else if (o == 0) {
                        this.setOffset(new Point(size.height - this.offset.y, this.offset.x));
                    } else {
                        this.setOffset(new Point(this.offset.y, size.width - this.offset.x));
                    }
                }
                this.repaint();
            }
        }

        public Point getOffset() {
            return this.offset;
        }

        public void setOffset(Point p) {
            this.offset = p;
        }

        public void setBorderColor(Color c) {
            if (this.borderColor == c) {
                return;
            }
            this.borderColor = c;
            this.repaint();
        }

        public Color getBorderColor() {
            return this.borderColor;
        }

        @Override
        public void paint(Graphics g) {
            BasicToolBarUI.this.paintDragWindow(g);
            super.paint(g);
        }

        @Override
        public Insets getInsets() {
            return new Insets(1, 1, 1, 1);
        }
    }

    public class DockingListener
    implements MouseInputListener {
        protected JToolBar toolBar;
        protected boolean isDragging = false;
        protected Point origin = null;

        public DockingListener(JToolBar t) {
            this.toolBar = t;
            ((BasicToolBarUI)BasicToolBarUI.this).getHandler().tb = t;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            BasicToolBarUI.this.getHandler().mouseClicked(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            ((BasicToolBarUI)BasicToolBarUI.this).getHandler().tb = this.toolBar;
            BasicToolBarUI.this.getHandler().mousePressed(e);
            this.isDragging = ((BasicToolBarUI)BasicToolBarUI.this).getHandler().isDragging;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            ((BasicToolBarUI)BasicToolBarUI.this).getHandler().tb = this.toolBar;
            ((BasicToolBarUI)BasicToolBarUI.this).getHandler().isDragging = this.isDragging;
            ((BasicToolBarUI)BasicToolBarUI.this).getHandler().origin = this.origin;
            BasicToolBarUI.this.getHandler().mouseReleased(e);
            this.isDragging = ((BasicToolBarUI)BasicToolBarUI.this).getHandler().isDragging;
            this.origin = ((BasicToolBarUI)BasicToolBarUI.this).getHandler().origin;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            BasicToolBarUI.this.getHandler().mouseEntered(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            BasicToolBarUI.this.getHandler().mouseExited(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            ((BasicToolBarUI)BasicToolBarUI.this).getHandler().tb = this.toolBar;
            ((BasicToolBarUI)BasicToolBarUI.this).getHandler().origin = this.origin;
            BasicToolBarUI.this.getHandler().mouseDragged(e);
            this.isDragging = ((BasicToolBarUI)BasicToolBarUI.this).getHandler().isDragging;
            this.origin = ((BasicToolBarUI)BasicToolBarUI.this).getHandler().origin;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            BasicToolBarUI.this.getHandler().mouseMoved(e);
        }
    }

    protected class PropertyListener
    implements PropertyChangeListener {
        protected PropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            BasicToolBarUI.this.getHandler().propertyChange(e);
        }
    }

    protected class ToolBarFocusListener
    implements FocusListener {
        protected ToolBarFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            BasicToolBarUI.this.getHandler().focusGained(e);
        }

        @Override
        public void focusLost(FocusEvent e) {
            BasicToolBarUI.this.getHandler().focusLost(e);
        }
    }

    protected class ToolBarContListener
    implements ContainerListener {
        protected ToolBarContListener() {
        }

        @Override
        public void componentAdded(ContainerEvent e) {
            BasicToolBarUI.this.getHandler().componentAdded(e);
        }

        @Override
        public void componentRemoved(ContainerEvent e) {
            BasicToolBarUI.this.getHandler().componentRemoved(e);
        }
    }

    protected class FrameListener
    extends WindowAdapter {
        protected FrameListener() {
        }

        @Override
        public void windowClosing(WindowEvent w) {
            if (BasicToolBarUI.this.toolBar.isFloatable()) {
                if (BasicToolBarUI.this.dragWindow != null) {
                    BasicToolBarUI.this.dragWindow.setVisible(false);
                }
                BasicToolBarUI.this.floating = false;
                if (BasicToolBarUI.this.floatingToolBar == null) {
                    BasicToolBarUI.this.floatingToolBar = BasicToolBarUI.this.createFloatingWindow(BasicToolBarUI.this.toolBar);
                }
                if (BasicToolBarUI.this.floatingToolBar instanceof Window) {
                    ((Window)((Object)BasicToolBarUI.this.floatingToolBar)).setVisible(false);
                }
                BasicToolBarUI.this.floatingToolBar.getContentPane().remove(BasicToolBarUI.this.toolBar);
                String constraint = BasicToolBarUI.this.constraintBeforeFloating;
                if (BasicToolBarUI.this.toolBar.getOrientation() == 0) {
                    if (constraint == "West" || constraint == "East") {
                        constraint = "North";
                    }
                } else if (constraint == "North" || constraint == "South") {
                    constraint = "West";
                }
                if (BasicToolBarUI.this.dockingSource == null) {
                    BasicToolBarUI.this.dockingSource = BasicToolBarUI.this.toolBar.getParent();
                }
                if (BasicToolBarUI.this.propertyListener != null) {
                    UIManager.removePropertyChangeListener(BasicToolBarUI.this.propertyListener);
                }
                BasicToolBarUI.this.dockingSource.add((Component)BasicToolBarUI.this.toolBar, constraint);
                BasicToolBarUI.this.dockingSource.invalidate();
                Container dockingSourceParent = BasicToolBarUI.this.dockingSource.getParent();
                if (dockingSourceParent != null) {
                    dockingSourceParent.validate();
                }
                BasicToolBarUI.this.dockingSource.repaint();
            }
        }
    }

    private class Handler
    implements ContainerListener,
    FocusListener,
    MouseInputListener,
    PropertyChangeListener {
        JToolBar tb;
        boolean isDragging = false;
        Point origin = null;

        private Handler() {
        }

        @Override
        public void componentAdded(ContainerEvent evt) {
            Component c = evt.getChild();
            if (BasicToolBarUI.this.toolBarFocusListener != null) {
                c.addFocusListener(BasicToolBarUI.this.toolBarFocusListener);
            }
            if (BasicToolBarUI.this.isRolloverBorders()) {
                BasicToolBarUI.this.setBorderToRollover(c);
            } else {
                BasicToolBarUI.this.setBorderToNonRollover(c);
            }
        }

        @Override
        public void componentRemoved(ContainerEvent evt) {
            Component c = evt.getChild();
            if (BasicToolBarUI.this.toolBarFocusListener != null) {
                c.removeFocusListener(BasicToolBarUI.this.toolBarFocusListener);
            }
            BasicToolBarUI.this.setBorderToNormal(c);
        }

        @Override
        public void focusGained(FocusEvent evt) {
            Component c = evt.getComponent();
            BasicToolBarUI.this.focusedCompIndex = BasicToolBarUI.this.toolBar.getComponentIndex(c);
        }

        @Override
        public void focusLost(FocusEvent evt) {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (!this.tb.isEnabled()) {
                return;
            }
            this.isDragging = false;
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (!this.tb.isEnabled()) {
                return;
            }
            if (this.isDragging) {
                Point position = evt.getPoint();
                if (this.origin == null) {
                    this.origin = evt.getComponent().getLocationOnScreen();
                }
                BasicToolBarUI.this.floatAt(position, this.origin);
            }
            this.origin = null;
            this.isDragging = false;
        }

        @Override
        public void mouseDragged(MouseEvent evt) {
            if (!this.tb.isEnabled()) {
                return;
            }
            this.isDragging = true;
            Point position = evt.getPoint();
            if (this.origin == null) {
                this.origin = evt.getComponent().getLocationOnScreen();
            }
            BasicToolBarUI.this.dragTo(position, this.origin);
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
        }

        @Override
        public void mouseExited(MouseEvent evt) {
        }

        @Override
        public void mouseMoved(MouseEvent evt) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (propertyName == "lookAndFeel") {
                BasicToolBarUI.this.toolBar.updateUI();
            } else if (propertyName == "orientation") {
                Component[] components = BasicToolBarUI.this.toolBar.getComponents();
                int orientation = (Integer)evt.getNewValue();
                for (int i = 0; i < components.length; ++i) {
                    if (!(components[i] instanceof JToolBar.Separator)) continue;
                    JToolBar.Separator separator = (JToolBar.Separator)components[i];
                    if (orientation == 0) {
                        separator.setOrientation(1);
                    } else {
                        separator.setOrientation(0);
                    }
                    Dimension size = separator.getSeparatorSize();
                    if (size == null || size.width == size.height) continue;
                    Dimension newSize = new Dimension(size.height, size.width);
                    separator.setSeparatorSize(newSize);
                }
            } else if (propertyName == IS_ROLLOVER) {
                BasicToolBarUI.this.installNormalBorders(BasicToolBarUI.this.toolBar);
                BasicToolBarUI.this.setRolloverBorders((Boolean)evt.getNewValue());
            }
        }
    }

    private static class Actions
    extends UIAction {
        private static final String NAVIGATE_RIGHT = "navigateRight";
        private static final String NAVIGATE_LEFT = "navigateLeft";
        private static final String NAVIGATE_UP = "navigateUp";
        private static final String NAVIGATE_DOWN = "navigateDown";

        public Actions(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String key = this.getName();
            JToolBar toolBar = (JToolBar)evt.getSource();
            BasicToolBarUI ui = (BasicToolBarUI)BasicLookAndFeel.getUIOfType(toolBar.getUI(), BasicToolBarUI.class);
            if (NAVIGATE_RIGHT == key) {
                ui.navigateFocusedComp(3);
            } else if (NAVIGATE_LEFT == key) {
                ui.navigateFocusedComp(7);
            } else if (NAVIGATE_UP == key) {
                ui.navigateFocusedComp(1);
            } else if (NAVIGATE_DOWN == key) {
                ui.navigateFocusedComp(5);
            }
        }
    }
}

