/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.GTKConstants;
import com.sun.java.swing.plaf.gtk.GTKPainter;
import com.sun.java.swing.plaf.gtk.GTKRegion;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import java.awt.Graphics;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JToolBar;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.SynthIcon;

class GTKIconFactory {
    static final int CHECK_ICON_EXTRA_INSET = 1;
    static final int DEFAULT_ICON_SPACING = 2;
    static final int DEFAULT_ICON_SIZE = 13;
    static final int DEFAULT_TOGGLE_MENU_ITEM_SIZE = 12;
    private static final String RADIO_BUTTON_ICON = "paintRadioButtonIcon";
    private static final String CHECK_BOX_ICON = "paintCheckBoxIcon";
    private static final String MENU_ARROW_ICON = "paintMenuArrowIcon";
    private static final String CHECK_BOX_MENU_ITEM_CHECK_ICON = "paintCheckBoxMenuItemCheckIcon";
    private static final String RADIO_BUTTON_MENU_ITEM_CHECK_ICON = "paintRadioButtonMenuItemCheckIcon";
    private static final String TREE_EXPANDED_ICON = "paintTreeExpandedIcon";
    private static final String TREE_COLLAPSED_ICON = "paintTreeCollapsedIcon";
    private static final String ASCENDING_SORT_ICON = "paintAscendingSortIcon";
    private static final String DESCENDING_SORT_ICON = "paintDescendingSortIcon";
    private static final String TOOL_BAR_HANDLE_ICON = "paintToolBarHandleIcon";
    private static Map<String, DelegatingIcon> iconsPool = Collections.synchronizedMap(new HashMap());

    GTKIconFactory() {
    }

    private static DelegatingIcon getIcon(String methodName) {
        DelegatingIcon result = iconsPool.get(methodName);
        if (result == null) {
            result = methodName == TREE_COLLAPSED_ICON || methodName == TREE_EXPANDED_ICON ? new SynthExpanderIcon(methodName) : (methodName == TOOL_BAR_HANDLE_ICON ? new ToolBarHandleIcon() : (methodName == MENU_ARROW_ICON ? new MenuArrowIcon() : new DelegatingIcon(methodName)));
            iconsPool.put(methodName, result);
        }
        return result;
    }

    public static Icon getAscendingSortIcon() {
        return GTKIconFactory.getIcon(ASCENDING_SORT_ICON);
    }

    public static Icon getDescendingSortIcon() {
        return GTKIconFactory.getIcon(DESCENDING_SORT_ICON);
    }

    public static SynthIcon getTreeExpandedIcon() {
        return GTKIconFactory.getIcon(TREE_EXPANDED_ICON);
    }

    public static SynthIcon getTreeCollapsedIcon() {
        return GTKIconFactory.getIcon(TREE_COLLAPSED_ICON);
    }

    public static SynthIcon getRadioButtonIcon() {
        return GTKIconFactory.getIcon(RADIO_BUTTON_ICON);
    }

    public static SynthIcon getCheckBoxIcon() {
        return GTKIconFactory.getIcon(CHECK_BOX_ICON);
    }

    public static SynthIcon getMenuArrowIcon() {
        return GTKIconFactory.getIcon(MENU_ARROW_ICON);
    }

    public static SynthIcon getCheckBoxMenuItemCheckIcon() {
        return GTKIconFactory.getIcon(CHECK_BOX_MENU_ITEM_CHECK_ICON);
    }

    public static SynthIcon getRadioButtonMenuItemCheckIcon() {
        return GTKIconFactory.getIcon(RADIO_BUTTON_MENU_ITEM_CHECK_ICON);
    }

    public static SynthIcon getToolBarHandleIcon() {
        return GTKIconFactory.getIcon(TOOL_BAR_HANDLE_ICON);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resetIcons() {
        Map<String, DelegatingIcon> map = iconsPool;
        synchronized (map) {
            for (DelegatingIcon di : iconsPool.values()) {
                di.resetIconDimensions();
            }
        }
    }

    private static class MenuArrowIcon
    extends DelegatingIcon {
        private static final Class[] PARAM_TYPES = new Class[]{SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, GTKConstants.ArrowType.class};

        public MenuArrowIcon() {
            super(GTKIconFactory.MENU_ARROW_ICON);
        }

        @Override
        protected Class[] getMethodParamTypes() {
            return PARAM_TYPES;
        }

        @Override
        public void paintIcon(SynthContext context, Graphics g, int x, int y, int w, int h) {
            GTKConstants.ArrowType arrowDir = GTKConstants.ArrowType.RIGHT;
            if (!context.getComponent().getComponentOrientation().isLeftToRight()) {
                arrowDir = GTKConstants.ArrowType.LEFT;
            }
            GTKPainter.INSTANCE.paintIcon(context, g, this.getMethod(), x, y, w, h, (Object)arrowDir);
        }
    }

    private static class ToolBarHandleIcon
    extends DelegatingIcon {
        private static final Class[] PARAM_TYPES = new Class[]{SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, GTKConstants.Orientation.class};
        private SynthStyle style;

        public ToolBarHandleIcon() {
            super(GTKIconFactory.TOOL_BAR_HANDLE_ICON);
        }

        @Override
        protected Class[] getMethodParamTypes() {
            return PARAM_TYPES;
        }

        @Override
        public void paintIcon(SynthContext context, Graphics g, int x, int y, int w, int h) {
            GTKConstants.Orientation orientation;
            JToolBar toolbar = (JToolBar)context.getComponent();
            GTKConstants.Orientation orientation2 = orientation = toolbar.getOrientation() == 0 ? GTKConstants.Orientation.HORIZONTAL : GTKConstants.Orientation.VERTICAL;
            if (this.style == null) {
                this.style = SynthLookAndFeel.getStyleFactory().getStyle(context.getComponent(), GTKRegion.HANDLE_BOX);
            }
            context = new SynthContext(toolbar, GTKRegion.HANDLE_BOX, this.style, 1);
            GTKPainter.INSTANCE.paintIcon(context, g, this.getMethod(), x, y, w, h, (Object)orientation);
        }

        @Override
        public int getIconWidth(SynthContext context) {
            if (context == null) {
                return 10;
            }
            if (((JToolBar)context.getComponent()).getOrientation() == 0) {
                return 10;
            }
            return context.getComponent().getWidth();
        }

        @Override
        public int getIconHeight(SynthContext context) {
            if (context == null) {
                return 10;
            }
            if (((JToolBar)context.getComponent()).getOrientation() == 0) {
                return context.getComponent().getHeight();
            }
            return 10;
        }
    }

    private static class SynthExpanderIcon
    extends DelegatingIcon {
        SynthExpanderIcon(String method) {
            super(method);
        }

        @Override
        public void paintIcon(SynthContext context, Graphics g, int x, int y, int w, int h) {
            if (context != null) {
                super.paintIcon(context, g, x, y, w, h);
                this.updateSizeIfNecessary(context);
            }
        }

        @Override
        int getIconDimension(SynthContext context) {
            this.updateSizeIfNecessary(context);
            return this.iconDimension == -1 ? 13 : this.iconDimension;
        }

        private void updateSizeIfNecessary(SynthContext context) {
            if (this.iconDimension == -1 && context != null) {
                this.iconDimension = context.getStyle().getInt(context, "Tree.expanderSize", 10);
            }
        }
    }

    private static class DelegatingIcon
    extends SynthIcon
    implements UIResource {
        private static final Class[] PARAM_TYPES = new Class[]{SynthContext.class, Graphics.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
        private Object method;
        int iconDimension = -1;

        DelegatingIcon(String methodName) {
            this.method = methodName;
        }

        @Override
        public void paintIcon(SynthContext context, Graphics g, int x, int y, int w, int h) {
            if (context != null) {
                GTKPainter.INSTANCE.paintIcon(context, g, this.getMethod(), x, y, w, h);
            }
        }

        @Override
        public int getIconWidth(SynthContext context) {
            return this.getIconDimension(context);
        }

        @Override
        public int getIconHeight(SynthContext context) {
            return this.getIconDimension(context);
        }

        void resetIconDimensions() {
            this.iconDimension = -1;
        }

        protected Method getMethod() {
            if (this.method instanceof String) {
                this.method = this.resolveMethod((String)this.method);
            }
            return (Method)this.method;
        }

        protected Class[] getMethodParamTypes() {
            return PARAM_TYPES;
        }

        private Method resolveMethod(String name) {
            try {
                return GTKPainter.class.getMethod(name, this.getMethodParamTypes());
            }
            catch (NoSuchMethodException e) {
                assert (false);
                return null;
            }
        }

        int getIconDimension(SynthContext context) {
            if (this.iconDimension >= 0) {
                return this.iconDimension;
            }
            if (context == null) {
                return 13;
            }
            Region region = context.getRegion();
            GTKStyle style = (GTKStyle)context.getStyle();
            this.iconDimension = style.getClassSpecificIntValue(context, "indicator-size", region == Region.CHECK_BOX_MENU_ITEM || region == Region.RADIO_BUTTON_MENU_ITEM ? 12 : 13);
            if (region == Region.CHECK_BOX || region == Region.RADIO_BUTTON) {
                this.iconDimension += 2 * style.getClassSpecificIntValue(context, "indicator-spacing", 2);
            } else if (region == Region.CHECK_BOX_MENU_ITEM || region == Region.RADIO_BUTTON_MENU_ITEM) {
                this.iconDimension += 2;
            }
            return this.iconDimension;
        }
    }
}

