/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.jvm.hotspot.HotSpotAgent;
import sun.jvm.hotspot.HotSpotTypeDataBase;
import sun.jvm.hotspot.code.CodeBlob;
import sun.jvm.hotspot.code.CodeCacheVisitor;
import sun.jvm.hotspot.code.NMethod;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.memory.Universe;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.RawHeapVisitor;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.oops.UnknownOopException;
import sun.jvm.hotspot.runtime.CompiledVFrame;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.JavaVFrame;
import sun.jvm.hotspot.runtime.Threads;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.tools.ObjectHistogram;
import sun.jvm.hotspot.tools.PMap;
import sun.jvm.hotspot.tools.PStack;
import sun.jvm.hotspot.tools.StackTrace;
import sun.jvm.hotspot.types.CIntegerType;
import sun.jvm.hotspot.types.Field;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.basic.BasicType;
import sun.jvm.hotspot.ui.classbrowser.HTMLGenerator;
import sun.jvm.hotspot.ui.tree.CTypeTreeNodeAdapter;
import sun.jvm.hotspot.ui.tree.FieldTreeNodeAdapter;
import sun.jvm.hotspot.ui.tree.OopTreeNodeAdapter;
import sun.jvm.hotspot.ui.tree.SimpleTreeNode;
import sun.jvm.hotspot.utilities.AddressOps;
import sun.jvm.hotspot.utilities.Assert;
import sun.jvm.hotspot.utilities.ObjectReader;
import sun.jvm.hotspot.utilities.PointerFinder;
import sun.jvm.hotspot.utilities.PointerLocation;
import sun.jvm.hotspot.utilities.RobustOopDeterminator;
import sun.jvm.hotspot.utilities.SystemDictionaryHelper;
import sun.jvm.hotspot.utilities.soql.JSJavaFactory;
import sun.jvm.hotspot.utilities.soql.JSJavaFactoryImpl;
import sun.jvm.hotspot.utilities.soql.JSJavaScriptEngine;

public class CommandProcessor {
    private final Command[] commandList = new Command[]{new Command("reattach", true){

        public void doit(Tokens t) {
            int tokens = t.countTokens();
            if (tokens != 0) {
                this.usage();
                return;
            }
            CommandProcessor.this.preAttach();
            CommandProcessor.this.debugger.reattach();
            CommandProcessor.this.postAttach();
        }
    }, new Command("attach", "attach pid | exec core", true){

        public void doit(Tokens t) {
            int tokens = t.countTokens();
            if (tokens == 1) {
                CommandProcessor.this.preAttach();
                CommandProcessor.this.debugger.attach(t.nextToken());
                CommandProcessor.this.postAttach();
            } else if (tokens == 2) {
                CommandProcessor.this.preAttach();
                CommandProcessor.this.debugger.attach(t.nextToken(), t.nextToken());
                CommandProcessor.this.postAttach();
            } else {
                this.usage();
            }
        }
    }, new Command("detach", false){

        public void doit(Tokens t) {
            if (t.countTokens() != 0) {
                this.usage();
            } else {
                CommandProcessor.this.debugger.detach();
            }
        }
    }, new Command("examine", "examine [ address/count ] | [ address,address]", false){
        Pattern args1;
        Pattern args2;
        {
            this.args1 = Pattern.compile("^(0x[0-9a-f]+)(/([0-9]*)([a-z]*))?$");
            this.args2 = Pattern.compile("^(0x[0-9a-f]+),(0x[0-9a-f]+)(/[a-z]*)?$");
        }

        String fill(Address a, int width) {
            String s = "0x0";
            if (a != null) {
                s = a.toString();
            }
            if (s.length() != width) {
                return s.substring(0, 2) + "000000000000000000000".substring(0, width - s.length()) + s.substring(2);
            }
            return s;
        }

        public void doit(Tokens t) {
            if (t.countTokens() != 1) {
                this.usage();
            } else {
                String arg = t.nextToken();
                Matcher m1 = this.args1.matcher(arg);
                Matcher m2 = this.args2.matcher(arg);
                Address start = null;
                Address end = null;
                String format = "";
                int formatSize = (int)VM.getVM().getAddressSize();
                if (m1.matches()) {
                    start = VM.getVM().getDebugger().parseAddress(m1.group(1));
                    int count = 1;
                    if (m1.group(2) != null) {
                        count = Integer.parseInt(m1.group(3));
                    }
                    end = start.addOffsetTo(count * formatSize);
                } else if (m2.matches()) {
                    start = VM.getVM().getDebugger().parseAddress(m2.group(1));
                    end = VM.getVM().getDebugger().parseAddress(m2.group(2));
                } else {
                    this.usage();
                    return;
                }
                int line = 80;
                int formatWidth = formatSize * 8 / 4 + 2;
                CommandProcessor.this.out.print(this.fill(start, formatWidth));
                CommandProcessor.this.out.print(": ");
                int width = line - formatWidth - 2;
                boolean needsPrintln = true;
                while (start != null && start.lessThan(end)) {
                    Address val = start.getAddressAt(0L);
                    CommandProcessor.this.out.print(this.fill(val, formatWidth));
                    needsPrintln = true;
                    start = start.addOffsetTo(formatSize);
                    if ((width -= formatWidth) <= formatWidth) {
                        CommandProcessor.this.out.println();
                        needsPrintln = false;
                        if (!start.lessThan(end)) continue;
                        CommandProcessor.this.out.print(this.fill(start, formatWidth));
                        CommandProcessor.this.out.print(": ");
                        width = line - formatWidth - 2;
                        continue;
                    }
                    CommandProcessor.this.out.print(" ");
                    --width;
                }
                if (needsPrintln) {
                    CommandProcessor.this.out.println();
                }
            }
        }
    }, new Command("findpc", "findpc address", false){

        public void doit(Tokens t) {
            if (t.countTokens() != 1) {
                this.usage();
            } else {
                Address a = VM.getVM().getDebugger().parseAddress(t.nextToken());
                PointerLocation loc = PointerFinder.find(a);
                loc.printOn(CommandProcessor.this.out);
            }
        }
    }, new Command("flags", "flags [ flag ]", false){

        public void doit(Tokens t) {
            int tokens = t.countTokens();
            if (tokens != 0 && tokens != 1) {
                this.usage();
            } else {
                String name = tokens > 0 ? t.nextToken() : null;
                VM.Flag[] flags = VM.getVM().getCommandLineFlags();
                if (flags == null) {
                    CommandProcessor.this.out.println("Command Flag info not available (use 1.4.1_03 or later)!");
                } else {
                    boolean printed = false;
                    for (int f = 0; f < flags.length; ++f) {
                        VM.Flag flag = flags[f];
                        if (name != null && !flag.getName().equals(name)) continue;
                        CommandProcessor.this.out.println(flag.getName() + " = " + flag.getValue());
                        printed = true;
                    }
                    if (name != null && !printed) {
                        CommandProcessor.this.out.println("Couldn't find flag: " + name);
                    }
                }
            }
        }
    }, new Command("help", "help [ command ]", true){

        public void doit(Tokens t) {
            int tokens = t.countTokens();
            Command cmd = null;
            if (tokens == 1) {
                cmd = CommandProcessor.this.findCommand(t.nextToken());
            }
            if (cmd != null) {
                cmd.usage();
            } else if (tokens == 0) {
                CommandProcessor.this.out.println("Available commands:");
                Object[] keys = CommandProcessor.this.commands.keySet().toArray();
                Arrays.sort(keys, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        return o1.toString().compareTo(o2.toString());
                    }
                });
                for (int i = 0; i < keys.length; ++i) {
                    CommandProcessor.this.out.print("  ");
                    CommandProcessor.this.out.println(((Command)((CommandProcessor)CommandProcessor.this).commands.get((Object)keys[i])).usage);
                }
            }
        }
    }, new Command("history", "history", true){

        public void doit(Tokens t) {
            int tokens = t.countTokens();
            if (!(tokens == 0 || tokens == 1 && t.nextToken().equals("-h"))) {
                this.usage();
                return;
            }
            boolean printIndex = tokens == 0;
            for (int i = 0; i < CommandProcessor.this.history.size(); ++i) {
                if (printIndex) {
                    CommandProcessor.this.out.print(i + " ");
                }
                CommandProcessor.this.out.println(CommandProcessor.this.history.get(i));
            }
        }
    }, new Command("inspect", "inspect expression", false){

        public void doit(Tokens t) {
            if (t.countTokens() != 1) {
                this.usage();
            } else {
                Type type;
                Address a = VM.getVM().getDebugger().parseAddress(t.nextToken());
                FieldTreeNodeAdapter node = null;
                if (VM.getVM().getUniverse().heap().isInReserved(a)) {
                    OopHandle handle = a.addOffsetToAsOopHandle(0L);
                    Oop oop = VM.getVM().getObjectHeap().newOop(handle);
                    node = new OopTreeNodeAdapter(oop, null);
                    CommandProcessor.this.out.println("instance of " + node.getValue() + " @ " + a + " (size = " + oop.getObjectSize() + ")");
                } else if (VM.getVM().getCodeCache().contains(a)) {
                    CodeBlob blob = VM.getVM().getCodeCache().findBlobUnsafe(a);
                    a = blob.headerBegin();
                }
                if (node == null && (type = VM.getVM().getTypeDataBase().guessTypeForAddress(a)) != null) {
                    CommandProcessor.this.out.println("Type is " + type.getName() + " (size of " + type.getSize() + ")");
                    node = new CTypeTreeNodeAdapter(a, type, null);
                }
                if (node != null) {
                    this.printNode(node);
                }
            }
        }
    }, new Command("jhisto", "jhisto", false){

        public void doit(Tokens t) {
            ObjectHistogram histo = new ObjectHistogram();
            histo.run(CommandProcessor.this.out, CommandProcessor.this.err);
        }
    }, new Command("jstack", "jstack [-v]", false){

        public void doit(Tokens t) {
            boolean verbose = false;
            if (t.countTokens() > 0 && t.nextToken().equals("-v")) {
                verbose = true;
            }
            StackTrace jstack = new StackTrace(verbose, true);
            jstack.run(CommandProcessor.this.out);
        }
    }, new Command("print", "print expression", false){

        public void doit(Tokens t) {
            if (t.countTokens() != 1) {
                this.usage();
            } else {
                Address a = VM.getVM().getDebugger().parseAddress(t.nextToken());
                HTMLGenerator gen = new HTMLGenerator(false);
                CommandProcessor.this.out.println(gen.genHTML(a));
            }
        }
    }, new Command("printas", "printas type expression", false){

        public void doit(Tokens t) {
            if (t.countTokens() != 2) {
                this.usage();
            } else {
                Type type = CommandProcessor.this.agent.getTypeDataBase().lookupType(t.nextToken());
                Address a = VM.getVM().getDebugger().parseAddress(t.nextToken());
                CTypeTreeNodeAdapter node = new CTypeTreeNodeAdapter(a, type, null);
                CommandProcessor.this.out.println("pointer to " + type + " @ " + a + " (size = " + type.getSize() + ")");
                this.printNode(node);
            }
        }
    }, new Command("symbol", "symbol name", false){

        public void doit(Tokens t) {
            if (t.countTokens() != 1) {
                this.usage();
            } else {
                String symbol = t.nextToken();
                Address a = CommandProcessor.this.lookup(symbol);
                CommandProcessor.this.out.println(symbol + " = " + a);
            }
        }
    }, new Command("printstatics", "printstatics [ type ]", false){

        public void doit(Tokens t) {
            if (t.countTokens() > 1) {
                this.usage();
            } else if (t.countTokens() == 0) {
                CommandProcessor.this.out.println("All known static fields");
                this.printNode(new CTypeTreeNodeAdapter(CommandProcessor.this.agent.getTypeDataBase().getTypes()));
            } else {
                Type type = CommandProcessor.this.agent.getTypeDataBase().lookupType(t.nextToken());
                CommandProcessor.this.out.println("Static fields of " + type.getName());
                this.printNode(new CTypeTreeNodeAdapter(type));
            }
        }
    }, new Command("pmap", "pmap", false){

        public void doit(Tokens t) {
            PMap pmap = new PMap();
            pmap.run(CommandProcessor.this.out, CommandProcessor.this.debugger.getAgent().getDebugger());
        }
    }, new Command("pstack", "pstack [-v]", false){

        public void doit(Tokens t) {
            boolean verbose = false;
            if (t.countTokens() > 0 && t.nextToken().equals("-v")) {
                verbose = true;
            }
            PStack pstack = new PStack(verbose, true);
            pstack.run(CommandProcessor.this.out, CommandProcessor.this.debugger.getAgent().getDebugger());
        }
    }, new Command("quit", true){

        public void doit(Tokens t) {
            if (t.countTokens() != 0) {
                this.usage();
            } else {
                CommandProcessor.this.debugger.detach();
                System.exit(0);
            }
        }
    }, new Command("echo", "echo [ true | false ]", true){

        public void doit(Tokens t) {
            if (t.countTokens() == 0) {
                CommandProcessor.this.out.println("echo is " + CommandProcessor.this.doEcho);
            } else if (t.countTokens() == 1) {
                CommandProcessor.this.doEcho = Boolean.valueOf(t.nextToken());
            } else {
                this.usage();
            }
        }
    }, new Command("versioncheck", "versioncheck [ true | false ]", true){

        public void doit(Tokens t) {
            if (t.countTokens() == 0) {
                CommandProcessor.this.out.println("versioncheck is " + (System.getProperty("sun.jvm.hotspot.runtime.VM.disableVersionCheck") == null));
            } else if (t.countTokens() == 1) {
                if (Boolean.valueOf(t.nextToken()).booleanValue()) {
                    System.setProperty("sun.jvm.hotspot.runtime.VM.disableVersionCheck", null);
                } else {
                    System.setProperty("sun.jvm.hotspot.runtime.VM.disableVersionCheck", "true");
                }
            } else {
                this.usage();
            }
        }
    }, new Command("scanoops", "scanoops start end [ type ]", false){

        public void doit(Tokens t) {
            if (t.countTokens() != 2 && t.countTokens() != 3) {
                this.usage();
            } else {
                long stride = VM.getVM().getAddressSize();
                Address base = VM.getVM().getDebugger().parseAddress(t.nextToken());
                Address end = VM.getVM().getDebugger().parseAddress(t.nextToken());
                InstanceKlass klass = null;
                if (t.countTokens() == 1) {
                    klass = SystemDictionaryHelper.findInstanceKlass(t.nextToken());
                }
                while (base != null && base.lessThan(end)) {
                    long step = stride;
                    OopHandle handle = base.addOffsetToAsOopHandle(0L);
                    if (RobustOopDeterminator.oopLooksValid(handle)) {
                        try {
                            Oop oop = VM.getVM().getObjectHeap().newOop(handle);
                            if (klass == null || oop.getKlass().isSubtypeOf(klass)) {
                                CommandProcessor.this.out.println(handle.toString() + " " + oop.getKlass().getName().asString());
                            }
                            step = oop.getObjectSize();
                        }
                        catch (UnknownOopException ex) {
                        }
                        catch (RuntimeException ex) {
                            ex.printStackTrace();
                        }
                    }
                    base = base.addOffsetTo(step);
                }
            }
        }
    }, new Command("field", "field [ type [ name fieldtype isStatic offset address ] ]", true){

        public void doit(Tokens t) {
            if (t.countTokens() != 1 && t.countTokens() != 0 && t.countTokens() != 6) {
                this.usage();
                return;
            }
            if (t.countTokens() == 1) {
                Type type = CommandProcessor.this.agent.getTypeDataBase().lookupType(t.nextToken());
                CommandProcessor.this.dumpFields(type);
            } else if (t.countTokens() == 0) {
                Iterator i = CommandProcessor.this.agent.getTypeDataBase().getTypes();
                while (i.hasNext()) {
                    CommandProcessor.this.dumpFields((Type)i.next());
                }
            } else {
                BasicType containingType = (BasicType)CommandProcessor.this.agent.getTypeDataBase().lookupType(t.nextToken());
                String fieldName = t.nextToken();
                Type fieldType = CommandProcessor.this.agent.getTypeDataBase().lookupType(t.nextToken());
                boolean isStatic = Boolean.valueOf(t.nextToken());
                long offset = Long.parseLong(t.nextToken());
                Address staticAddress = CommandProcessor.this.parseAddress(t.nextToken());
                if (isStatic && staticAddress == null) {
                    staticAddress = CommandProcessor.this.lookup(containingType.getName() + "::" + fieldName);
                }
                Iterator i = containingType.getFields();
                while (i.hasNext()) {
                    Field f = (Field)i.next();
                    if (!f.getName().equals(fieldName)) continue;
                    if (f.isStatic() != isStatic) {
                        throw new RuntimeException("static/nonstatic mismatch: " + t.input);
                    }
                    if (!isStatic) {
                        if (f.getOffset() != offset) {
                            throw new RuntimeException("bad redefinition of field offset: " + t.input);
                        }
                    } else if (!((Object)f.getStaticFieldAddress()).equals(staticAddress)) {
                        throw new RuntimeException("bad redefinition of field location: " + t.input);
                    }
                    if (f.getType() != fieldType) {
                        throw new RuntimeException("bad redefinition of field type: " + t.input);
                    }
                    return;
                }
                HotSpotTypeDataBase db = (HotSpotTypeDataBase)CommandProcessor.this.agent.getTypeDataBase();
                db.createField(containingType, fieldName, fieldType, isStatic, offset, staticAddress);
            }
        }
    }, new Command("tokenize", "tokenize ...", true){

        public void doit(Tokens t) {
            while (t.hasMoreTokens()) {
                CommandProcessor.this.out.println("\"" + t.nextToken() + "\"");
            }
        }
    }, new Command("type", "type [ type [ name super isOop isInteger isUnsigned size ] ]", true){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void doit(Tokens t) {
            if (t.countTokens() != 1 && t.countTokens() != 0 && t.countTokens() != 6) {
                this.usage();
                return;
            }
            if (t.countTokens() == 6) {
                String typeName = t.nextToken();
                String superclassName = t.nextToken();
                if (superclassName.equals("null")) {
                    superclassName = null;
                }
                boolean isOop = Boolean.valueOf(t.nextToken());
                boolean isInteger = Boolean.valueOf(t.nextToken());
                boolean isUnsigned = Boolean.valueOf(t.nextToken());
                long size = Long.parseLong(t.nextToken());
                BasicType type = null;
                try {
                    type = (BasicType)CommandProcessor.this.agent.getTypeDataBase().lookupType(typeName);
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
                if (type != null) {
                    if (type.isOopType() != isOop) {
                        throw new RuntimeException("oop mismatch in type definition: " + t.input);
                    }
                    if (type.isCIntegerType() != isInteger) {
                        throw new RuntimeException("integer type mismatch in type definition: " + t.input);
                    }
                    if (type.isCIntegerType() && ((CIntegerType)((Object)type)).isUnsigned() != isUnsigned) {
                        throw new RuntimeException("unsigned mismatch in type definition: " + t.input);
                    }
                    if (type.getSuperclass() == null) {
                        if (superclassName != null) {
                            if (type.getSize() != -1L) throw new RuntimeException("unexpected superclass in type definition: " + t.input);
                            type.setSuperclass(CommandProcessor.this.agent.getTypeDataBase().lookupType(superclassName));
                        }
                    } else {
                        if (superclassName == null) {
                            throw new RuntimeException("missing superclass in type definition: " + t.input);
                        }
                        if (!type.getSuperclass().getName().equals(superclassName)) {
                            throw new RuntimeException("incorrect superclass in type definition: " + t.input);
                        }
                    }
                    if (type.getSize() == size) return;
                    if (type.getSize() != -1L) throw new RuntimeException("size mismatch in type definition: " + t.input);
                    type.setSize(size);
                    throw new RuntimeException("size mismatch in type definition: " + t.input);
                }
                HotSpotTypeDataBase db = (HotSpotTypeDataBase)CommandProcessor.this.agent.getTypeDataBase();
                db.createType(typeName, superclassName, isOop, isInteger, isUnsigned, size);
                return;
            }
            if (t.countTokens() == 1) {
                Type type = CommandProcessor.this.agent.getTypeDataBase().lookupType(t.nextToken());
                CommandProcessor.this.dumpType(type);
                return;
            } else {
                Iterator i = CommandProcessor.this.agent.getTypeDataBase().getTypes();
                while (i.hasNext()) {
                    CommandProcessor.this.dumpType((Type)i.next());
                }
            }
        }
    }, new Command("source", "source filename", true){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doit(Tokens t) {
            if (t.countTokens() != 1) {
                this.usage();
                return;
            }
            String file = t.nextToken();
            BufferedReader savedInput = CommandProcessor.this.in;
            try {
                BufferedReader input = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                CommandProcessor.this.in = input;
                CommandProcessor.this.run(false);
            }
            catch (Exception e) {
                CommandProcessor.this.out.println("Error: " + e);
                if (CommandProcessor.this.verboseExceptions) {
                    e.printStackTrace(CommandProcessor.this.out);
                }
            }
            finally {
                CommandProcessor.this.in = savedInput;
            }
        }
    }, new Command("search", "search [ heap | codecache | threads ] value", false){

        public void doit(Tokens t) {
            if (t.countTokens() != 2) {
                this.usage();
            } else {
                String type = t.nextToken();
                final Address value = VM.getVM().getDebugger().parseAddress(t.nextToken());
                final long stride = VM.getVM().getAddressSize();
                if (type.equals("threads")) {
                    Threads threads = VM.getVM().getThreads();
                    for (JavaThread thread = threads.first(); thread != null; thread = thread.next()) {
                        Address base = thread.getBaseOfStackPointer();
                        Address end = thread.getLastJavaSP();
                        if (end == null) continue;
                        if (end.lessThan(base)) {
                            Address tmp = base;
                            base = end;
                            end = tmp;
                        }
                        CommandProcessor.this.out.println("Searching " + base + " " + end);
                        while (base != null && base.lessThan(end)) {
                            Address val = base.getAddressAt(0L);
                            if (AddressOps.equal(val, value)) {
                                CommandProcessor.this.out.println(base);
                            }
                            base = base.addOffsetTo(stride);
                        }
                    }
                } else if (type.equals("heap")) {
                    RawHeapVisitor iterator = new RawHeapVisitor(){

                        public void prologue(long used) {
                        }

                        public void visitAddress(Address addr) {
                            Address val = addr.getAddressAt(0L);
                            if (AddressOps.equal(val, value)) {
                                CommandProcessor.this.out.println("found at " + addr);
                            }
                        }

                        public void visitCompOopAddress(Address addr) {
                            Address val = addr.getCompOopAddressAt(0L);
                            if (AddressOps.equal(val, value)) {
                                CommandProcessor.this.out.println("found at " + addr);
                            }
                        }

                        public void epilogue() {
                        }
                    };
                    VM.getVM().getObjectHeap().iterateRaw(iterator);
                } else if (type.equals("codecache")) {
                    CodeCacheVisitor v = new CodeCacheVisitor(){

                        public void prologue(Address start, Address end) {
                        }

                        public void visit(CodeBlob blob) {
                            Address base;
                            boolean printed = false;
                            Address end = base.addOffsetTo(blob.getSize());
                            for (base = blob.getAddress(); base != null && base.lessThan(end); base = base.addOffsetTo(stride)) {
                                Address val = base.getAddressAt(0L);
                                if (!AddressOps.equal(val, value)) continue;
                                if (!printed) {
                                    printed = true;
                                    blob.printOn(CommandProcessor.this.out);
                                }
                                CommandProcessor.this.out.println("found at " + base + "\n");
                            }
                        }

                        public void epilogue() {
                        }
                    };
                    VM.getVM().getCodeCache().iterate(v);
                }
            }
        }
    }, new Command("dumpcodecache", "dumpcodecache", false){

        public void doit(Tokens t) {
            if (t.countTokens() != 0) {
                this.usage();
            } else {
                final PrintStream fout = CommandProcessor.this.out;
                final HTMLGenerator gen = new HTMLGenerator(false);
                CodeCacheVisitor v = new CodeCacheVisitor(){

                    public void prologue(Address start, Address end) {
                    }

                    public void visit(CodeBlob blob) {
                        fout.println(gen.genHTML(blob.instructionsBegin()));
                    }

                    public void epilogue() {
                    }
                };
                VM.getVM().getCodeCache().iterate(v);
            }
        }
    }, new Command("where", "where { -a | id }", false){

        public void doit(Tokens t) {
            if (t.countTokens() != 1) {
                this.usage();
            } else {
                String name = t.nextToken();
                Threads threads = VM.getVM().getThreads();
                boolean all = name.equals("-a");
                for (JavaThread thread = threads.first(); thread != null; thread = thread.next()) {
                    StringWriter sw = new StringWriter();
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    thread.printThreadIDOn(new PrintStream(bos));
                    if (!all && !bos.toString().equals(name)) continue;
                    HTMLGenerator gen = new HTMLGenerator(false);
                    CommandProcessor.this.out.println(gen.genHTMLForJavaStackTrace(thread));
                    if (all) continue;
                    return;
                }
                if (!all) {
                    CommandProcessor.this.out.println("Couldn't find thread " + name);
                }
            }
        }
    }, new Command("threads", false){

        public void doit(Tokens t) {
            if (t.countTokens() != 0) {
                this.usage();
            } else {
                Threads threads = VM.getVM().getThreads();
                for (JavaThread thread = threads.first(); thread != null; thread = thread.next()) {
                    thread.printThreadIDOn(CommandProcessor.this.out);
                    CommandProcessor.this.out.println(" " + thread.getThreadName());
                }
            }
        }
    }, new Command("livenmethods", false){

        public void doit(Tokens t) {
            if (t.countTokens() != 0) {
                this.usage();
            } else {
                ArrayList<NMethod> nmethods = new ArrayList<NMethod>();
                Threads threads = VM.getVM().getThreads();
                HTMLGenerator gen = new HTMLGenerator(false);
                for (JavaThread thread = threads.first(); thread != null; thread = thread.next()) {
                    try {
                        for (JavaVFrame vf = thread.getLastJavaVFrameDbg(); vf != null; vf = vf.javaSender()) {
                            NMethod c;
                            if (!(vf instanceof CompiledVFrame) || nmethods.contains(c = ((CompiledVFrame)vf).getCode())) continue;
                            nmethods.add(c);
                            CommandProcessor.this.out.println(gen.genHTML(c));
                        }
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }, new Command("universe", false){

        public void doit(Tokens t) {
            if (t.countTokens() != 0) {
                this.usage();
            } else {
                Universe u = VM.getVM().getUniverse();
                CommandProcessor.this.out.println("Heap Parameters:");
                u.heap().printOn(CommandProcessor.this.out);
            }
        }
    }, new Command("verbose", "verbose true | false", true){

        public void doit(Tokens t) {
            if (t.countTokens() != 1) {
                this.usage();
            } else {
                CommandProcessor.this.verboseExceptions = Boolean.valueOf(t.nextToken());
            }
        }
    }, new Command("assert", "assert true | false", true){

        public void doit(Tokens t) {
            if (t.countTokens() != 1) {
                this.usage();
            } else {
                Assert.ASSERTS_ENABLED = Boolean.valueOf(t.nextToken());
            }
        }
    }};
    private boolean verboseExceptions = false;
    private ArrayList history = new ArrayList();
    private HashMap commands = new HashMap();
    private boolean doEcho = false;
    private DebuggerInterface debugger;
    private HotSpotAgent agent;
    private JSJavaScriptEngine jsengine;
    private BufferedReader in;
    private PrintStream out;
    private PrintStream err;
    static Pattern historyPattern = Pattern.compile("((!\\*)|(!\\$)|(!!-?)|(!-?[0-9][0-9]*))");

    void quote(String s) {
        if (s.indexOf(" ") == -1) {
            this.out.print(s);
        } else {
            this.out.print("\"");
            this.out.print(s);
            this.out.print("\"");
        }
    }

    void dumpType(Type type) {
        this.out.print("type ");
        this.quote(type.getName());
        this.out.print(" ");
        if (type.getSuperclass() != null) {
            this.quote(type.getSuperclass().getName());
            this.out.print(" ");
        } else {
            this.out.print("null ");
        }
        this.out.print(type.isOopType());
        this.out.print(" ");
        if (type.isCIntegerType()) {
            this.out.print("true ");
            this.out.print(((CIntegerType)type).isUnsigned());
            this.out.print(" ");
        } else {
            this.out.print("false false ");
        }
        this.out.print(type.getSize());
        this.out.println();
    }

    void dumpFields(Type type) {
        Iterator i = type.getFields();
        while (i.hasNext()) {
            Field f = (Field)i.next();
            this.out.print("field ");
            this.quote(type.getName());
            this.out.print(" ");
            this.out.print(f.getName());
            this.out.print(" ");
            this.quote(f.getType().getName());
            this.out.print(" ");
            this.out.print(f.isStatic());
            this.out.print(" ");
            if (f.isStatic()) {
                this.out.print("0 ");
                this.out.print(f.getStaticFieldAddress());
            } else {
                this.out.print(f.getOffset());
                this.out.print(" 0x0");
            }
            this.out.println();
        }
    }

    Address lookup(String symbol) {
        if (symbol.indexOf("::") != -1) {
            String[] parts = symbol.split("::");
            StringBuffer mangled = new StringBuffer("__1c");
            for (int i = 0; i < parts.length; ++i) {
                int len = parts[i].length();
                if (len >= 26) {
                    mangled.append((char)(97 + len / 26));
                    len %= 26;
                }
                mangled.append((char)(65 + len));
                mangled.append(parts[i]);
            }
            mangled.append("_");
            symbol = mangled.toString();
        }
        return VM.getVM().getDebugger().lookup(null, symbol);
    }

    Address parseAddress(String addr) {
        return VM.getVM().getDebugger().parseAddress(addr);
    }

    private Command findCommand(String key) {
        return (Command)this.commands.get(key);
    }

    public void printPrompt() {
        this.out.print("hsdb> ");
    }

    private void preAttach() {
    }

    private void postAttach() {
        this.jsengine = new JSJavaScriptEngine(){
            private ObjectReader reader = new ObjectReader();
            private JSJavaFactory factory = new JSJavaFactoryImpl();

            public ObjectReader getObjectReader() {
                return this.reader;
            }

            public JSJavaFactory getJSJavaFactory() {
                return this.factory;
            }

            protected void quit() {
                CommandProcessor.this.debugger.detach();
                System.exit(0);
            }

            protected BufferedReader getInputReader() {
                return CommandProcessor.this.in;
            }

            protected PrintStream getOutputStream() {
                return CommandProcessor.this.out;
            }

            protected PrintStream getErrorStream() {
                return CommandProcessor.this.err;
            }
        };
        try {
            this.jsengine.defineFunction(this, this.getClass().getMethod("registerCommand", String.class, String.class, String.class));
        }
        catch (NoSuchMethodException exp) {
            exp.printStackTrace();
        }
        this.jsengine.start();
    }

    public void registerCommand(String cmd, String usage, final String func) {
        this.commands.put(cmd, new Command(cmd, usage, false){

            public void doit(Tokens t) {
                int len = t.countTokens();
                Object[] args = new Object[len];
                for (int i = 0; i < len; ++i) {
                    args[i] = t.nextToken();
                }
                CommandProcessor.this.jsengine.call(func, args);
            }
        });
    }

    public void setOutput(PrintStream o) {
        this.out = o;
    }

    public void setErr(PrintStream e) {
        this.err = e;
    }

    public CommandProcessor(DebuggerInterface debugger, BufferedReader in, PrintStream out, PrintStream err) {
        this.debugger = debugger;
        this.agent = debugger.getAgent();
        this.in = in;
        this.out = out;
        this.err = err;
        for (int i = 0; i < this.commandList.length; ++i) {
            Command c = this.commandList[i];
            this.commands.put(c.name, c);
        }
        if (debugger.isAttached()) {
            this.postAttach();
        }
    }

    public void run(boolean prompt) {
        while (true) {
            if (prompt) {
                this.printPrompt();
            }
            String ln = null;
            try {
                ln = this.in.readLine();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (ln == null) {
                if (prompt) {
                    this.err.println("Input stream closed.");
                }
                return;
            }
            this.executeCommand(ln);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCommand(String ln) {
        if (ln.indexOf(33) != -1) {
            int size = this.history.size();
            if (size == 0) {
                ln = "";
                this.err.println("History is empty");
            } else {
                StringBuffer result = new StringBuffer();
                Matcher m = historyPattern.matcher(ln);
                int start = 0;
                while (m.find()) {
                    Tokens item;
                    if (m.start() > start) {
                        result.append(ln.substring(start, m.start() - start));
                    }
                    start = m.end();
                    String cmd = m.group();
                    if (cmd.equals("!!")) {
                        result.append((String)this.history.get(this.history.size() - 1));
                        continue;
                    }
                    if (cmd.equals("!!-")) {
                        item = new Tokens((String)this.history.get(this.history.size() - 1));
                        item.trim(1);
                        result.append(item.join(" "));
                        continue;
                    }
                    if (cmd.equals("!*")) {
                        item = new Tokens((String)this.history.get(this.history.size() - 1));
                        item.nextToken();
                        result.append(item.join(" "));
                        continue;
                    }
                    if (cmd.equals("!$")) {
                        item = new Tokens((String)this.history.get(this.history.size() - 1));
                        result.append(item.at(item.countTokens() - 1));
                        continue;
                    }
                    String tail = cmd.substring(1);
                    int index = Integer.parseInt(tail);
                    if (index < 0) {
                        index = this.history.size() + index;
                    }
                    if (index > size) {
                        this.err.println("No such history item");
                        continue;
                    }
                    result.append((String)this.history.get(index));
                }
                if (result.length() == 0) {
                    this.err.println("malformed history reference");
                    ln = "";
                } else {
                    if (start < ln.length()) {
                        result.append(ln.substring(start));
                    }
                    ln = result.toString();
                    if (!this.doEcho) {
                        this.out.println(ln);
                    }
                }
            }
        }
        if (this.doEcho) {
            this.out.println("+ " + ln);
        }
        PrintStream redirect = null;
        Tokens t = new Tokens(ln);
        if (t.hasMoreTokens()) {
            String r;
            boolean error = false;
            this.history.add(ln);
            int len = t.countTokens();
            if (len > 2 && ((r = t.at(len - 2)).equals(">") || r.equals(">>"))) {
                boolean append = r.length() == 2;
                String file = t.at(len - 1);
                try {
                    redirect = new PrintStream(new BufferedOutputStream(new FileOutputStream(file, append)));
                    t.trim(2);
                }
                catch (Exception e) {
                    this.out.println("Error: " + e);
                    if (this.verboseExceptions) {
                        e.printStackTrace(this.out);
                    }
                    error = true;
                }
            }
            if (!error) {
                PrintStream savedout = this.out;
                if (redirect != null) {
                    this.out = redirect;
                }
                try {
                    this.executeCommand(t);
                }
                catch (Exception e) {
                    this.err.println("Error: " + e);
                    if (this.verboseExceptions) {
                        e.printStackTrace(this.err);
                    }
                }
                finally {
                    if (redirect != null) {
                        this.out = savedout;
                        redirect.close();
                    }
                }
            }
        }
    }

    void executeCommand(Tokens args) {
        block6: {
            String cmd = args.nextToken();
            Command doit = this.findCommand(cmd);
            if (doit == null) {
                this.out.println("Unrecognized command.  Try help...");
            } else if (!this.debugger.isAttached() && !doit.okIfDisconnected) {
                this.out.println("Command not valid until the attached to a VM");
            } else {
                try {
                    doit.doit(args);
                }
                catch (Exception e) {
                    this.out.println("Error: " + e);
                    if (!this.verboseExceptions) break block6;
                    e.printStackTrace(this.out);
                }
            }
        }
    }

    abstract class Command {
        final String name;
        final String usage;
        final boolean okIfDisconnected;

        Command(String n, String u, boolean ok) {
            this.name = n;
            this.usage = u;
            this.okIfDisconnected = ok;
        }

        Command(String n, boolean ok) {
            this.name = n;
            this.usage = n;
            this.okIfDisconnected = ok;
        }

        abstract void doit(Tokens var1);

        void usage() {
            CommandProcessor.this.out.println("Usage: " + this.usage);
        }

        void printOopValue(Oop oop) {
            if (oop != null) {
                Klass k = oop.getKlass();
                Symbol s = k.getName();
                if (s != null) {
                    CommandProcessor.this.out.print("Oop for " + s.asString() + " @ ");
                } else {
                    CommandProcessor.this.out.print("Oop @ ");
                }
                Oop.printOopAddressOn(oop, CommandProcessor.this.out);
            } else {
                CommandProcessor.this.out.print("null");
            }
        }

        void printNode(SimpleTreeNode node) {
            int count = node.getChildCount();
            for (int i = 0; i < count; ++i) {
                try {
                    SimpleTreeNode field = node.getChild(i);
                    if (field instanceof OopTreeNodeAdapter) {
                        CommandProcessor.this.out.print(field);
                        CommandProcessor.this.out.print(" ");
                        this.printOopValue(((OopTreeNodeAdapter)field).getOop());
                        CommandProcessor.this.out.println();
                        continue;
                    }
                    CommandProcessor.this.out.println(field);
                    continue;
                }
                catch (Exception e) {
                    CommandProcessor.this.out.println();
                    CommandProcessor.this.out.println("Error: " + e);
                    if (!CommandProcessor.this.verboseExceptions) continue;
                    e.printStackTrace(CommandProcessor.this.out);
                }
            }
        }
    }

    static class Tokens {
        final String input;
        int i;
        String[] tokens;
        int length;

        String[] splitWhitespace(String cmd) {
            String[] t = cmd.split("\\s");
            if (t.length == 1 && t[0].length() == 0) {
                return new String[0];
            }
            return t;
        }

        void add(String s, ArrayList t) {
            if (s.length() > 0) {
                t.add(s);
            }
        }

        Tokens(String cmd) {
            this.input = cmd;
            int quote = cmd.indexOf(34);
            ArrayList t = new ArrayList();
            if (quote != -1) {
                while (cmd.length() > 0) {
                    if (quote != -1) {
                        int endquote = cmd.indexOf(34, quote + 1);
                        if (endquote == -1) {
                            throw new RuntimeException("mismatched quotes: " + this.input);
                        }
                        String before = cmd.substring(0, quote).trim();
                        String quoted = cmd.substring(quote + 1, endquote);
                        cmd = cmd.substring(endquote + 1).trim();
                        if (before.length() > 0) {
                            String[] w = this.splitWhitespace(before);
                            for (int i = 0; i < w.length; ++i) {
                                this.add(w[i], t);
                            }
                        }
                        this.add(quoted, t);
                        quote = cmd.indexOf(34);
                        continue;
                    }
                    String[] w = this.splitWhitespace(cmd);
                    for (int i = 0; i < w.length; ++i) {
                        this.add(w[i], t);
                    }
                    cmd = "";
                }
            } else {
                String[] w = this.splitWhitespace(cmd);
                for (int i = 0; i < w.length; ++i) {
                    this.add(w[i], t);
                }
            }
            this.tokens = t.toArray(new String[0]);
            this.i = 0;
            this.length = this.tokens.length;
        }

        String nextToken() {
            return this.tokens[this.i++];
        }

        boolean hasMoreTokens() {
            return this.i < this.length;
        }

        int countTokens() {
            return this.length - this.i;
        }

        void trim(int n) {
            if (this.length >= n) {
                this.length -= n;
            } else {
                throw new IndexOutOfBoundsException(String.valueOf(n));
            }
        }

        String join(String sep) {
            StringBuffer result = new StringBuffer();
            for (int w = this.i; w < this.length; ++w) {
                result.append(this.tokens[w]);
                if (w + 1 >= this.length) continue;
                result.append(sep);
            }
            return result.toString();
        }

        String at(int i) {
            if (i < 0 || i >= this.length) {
                throw new IndexOutOfBoundsException(String.valueOf(i));
            }
            return this.tokens[i];
        }
    }

    public static abstract class DebuggerInterface {
        public abstract HotSpotAgent getAgent();

        public abstract boolean isAttached();

        public abstract void attach(String var1);

        public abstract void attach(String var1, String var2);

        public abstract void detach();

        public abstract void reattach();
    }
}

