/* xkblayout.c generated by valac 0.43.91, the Vala compiler
 * generated from xkblayout.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2014 Red Hat, Inc.
 * Copyright(c) 2014 Peng Huang <shawn.p.huang@gmail.com>
 * Copyright(c) 2014 Takao Fujiwara <tfujiwar@redhat.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <stdio.h>
#include <ibus.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>

#define TYPE_XKB_LAYOUT (xkb_layout_get_type ())
#define XKB_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_XKB_LAYOUT, XKBLayout))
#define XKB_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_XKB_LAYOUT, XKBLayoutClass))
#define IS_XKB_LAYOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_XKB_LAYOUT))
#define IS_XKB_LAYOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_XKB_LAYOUT))
#define XKB_LAYOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_XKB_LAYOUT, XKBLayoutClass))

typedef struct _XKBLayout XKBLayout;
typedef struct _XKBLayoutClass XKBLayoutClass;
typedef struct _XKBLayoutPrivate XKBLayoutPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecXKBLayout ParamSpecXKBLayout;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _XKBLayout {
	GTypeInstance parent_instance;
	volatile int ref_count;
	XKBLayoutPrivate * priv;
};

struct _XKBLayoutClass {
	GTypeClass parent_class;
	void (*finalize) (XKBLayout *self);
};

struct _XKBLayoutPrivate {
	gchar** m_xkb_latin_layouts;
	gint m_xkb_latin_layouts_length1;
	gint _m_xkb_latin_layouts_size_;
	gchar* m_default_layout;
	gchar* m_default_variant;
	gchar* m_default_option;
	gboolean m_use_xmodmap;
};

struct _ParamSpecXKBLayout {
	GParamSpec parent_instance;
};

static gint XKBLayout_private_offset;
static gpointer xkb_layout_parent_class = NULL;

gpointer xkb_layout_ref (gpointer instance);
void xkb_layout_unref (gpointer instance);
GParamSpec* param_spec_xkb_layout (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
void value_set_xkb_layout (GValue* value,
                           gpointer v_object);
void value_take_xkb_layout (GValue* value,
                            gpointer v_object);
gpointer value_get_xkb_layout (const GValue* value);
GType xkb_layout_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (XKBLayout, xkb_layout_unref)
#define XKB_LAYOUT_XKB_COMMAND "setxkbmap"
#define XKB_LAYOUT_XKB_QUERY_ARG "-query"
#define XKB_LAYOUT_XKB_LAYOUT_ARG "-layout"
#define XKB_LAYOUT_XMODMAP_COMMAND "xmodmap"
XKBLayout* xkb_layout_new (void);
XKBLayout* xkb_layout_construct (GType object_type);
void xkb_layout_set_latin_layouts (XKBLayout* self,
                                   gchar** xkb_latin_layouts,
                                   gint xkb_latin_layouts_length1);
static gchar** _vala_array_dup6 (gchar** self,
                          int length);
void xkb_layout_get_layout (gchar* * layout,
                            gchar* * variant,
                            gchar* * option);
static void _vala_array_add26 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static void _vala_array_add27 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
void xkb_layout_set_layout (XKBLayout* self,
                            IBusEngineDesc* engine);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      int stack_length,
                                      const gchar* needle);
static void _vala_array_add28 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static void _vala_array_add29 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static void _vala_array_add30 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static void _vala_array_add31 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static void _vala_array_add32 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static void _vala_array_add33 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static void _vala_array_add34 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static void _vala_array_add35 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
void xkb_layout_run_xmodmap (XKBLayout* self);
void xkb_layout_set_use_xmodmap (XKBLayout* self,
                                 gboolean use_xmodmap);
static void xkb_layout_finalize (XKBLayout * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const gchar* XKB_LAYOUT_XMODMAP_KNOWN_FILES[4] = {".xmodmap", ".xmodmaprc", ".Xmodmap", ".Xmodmaprc"};

static inline gpointer
xkb_layout_get_instance_private (XKBLayout* self)
{
	return G_STRUCT_MEMBER_P (self, XKBLayout_private_offset);
}

XKBLayout*
xkb_layout_construct (GType object_type)
{
	XKBLayout* self = NULL;
	self = (XKBLayout*) g_type_create_instance (object_type);
	return self;
}

XKBLayout*
xkb_layout_new (void)
{
	return xkb_layout_construct (TYPE_XKB_LAYOUT);
}

static gchar**
_vala_array_dup6 (gchar** self,
                  int length)
{
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}

void
xkb_layout_set_latin_layouts (XKBLayout* self,
                              gchar** xkb_latin_layouts,
                              gint xkb_latin_layouts_length1)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = (xkb_latin_layouts != NULL) ? _vala_array_dup6 (xkb_latin_layouts, xkb_latin_layouts_length1) : ((gpointer) xkb_latin_layouts);
	_tmp0__length1 = xkb_latin_layouts_length1;
	self->priv->m_xkb_latin_layouts = (_vala_array_free (self->priv->m_xkb_latin_layouts, self->priv->m_xkb_latin_layouts_length1, (GDestroyNotify) g_free), NULL);
	self->priv->m_xkb_latin_layouts = _tmp0_;
	self->priv->m_xkb_latin_layouts_length1 = _tmp0__length1;
	self->priv->_m_xkb_latin_layouts_size_ = self->priv->m_xkb_latin_layouts_length1;
}

static void
_vala_array_add26 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add27 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}

void
xkb_layout_get_layout (gchar* * layout,
                       gchar* * variant,
                       gchar* * option)
{
	gchar* _vala_layout = NULL;
	gchar* _vala_variant = NULL;
	gchar* _vala_option = NULL;
	gchar** exec_command = NULL;
	gchar** _tmp0_;
	gint exec_command_length1;
	gint _exec_command_size_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp4_;
	gchar* standard_output = NULL;
	gchar* standard_error = NULL;
	gint exit_status = 0;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar** _tmp20_;
	gchar** _tmp21_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	exec_command = _tmp0_;
	exec_command_length1 = 0;
	_exec_command_size_ = exec_command_length1;
	_tmp1_ = exec_command;
	_tmp1__length1 = exec_command_length1;
	_tmp2_ = g_strdup (XKB_LAYOUT_XKB_COMMAND);
	_vala_array_add26 (&exec_command, &exec_command_length1, &_exec_command_size_, _tmp2_);
	_tmp3_ = exec_command;
	_tmp3__length1 = exec_command_length1;
	_tmp4_ = g_strdup (XKB_LAYOUT_XKB_QUERY_ARG);
	_vala_array_add27 (&exec_command, &exec_command_length1, &_exec_command_size_, _tmp4_);
	standard_output = NULL;
	standard_error = NULL;
	exit_status = 0;
	_tmp5_ = g_strdup ("");
	_g_free0 (_vala_layout);
	_vala_layout = _tmp5_;
	_tmp6_ = g_strdup ("");
	_g_free0 (_vala_variant);
	_vala_variant = _tmp6_;
	_tmp7_ = g_strdup ("");
	_g_free0 (_vala_option);
	_vala_option = _tmp7_;
	{
		gchar** _tmp8_;
		gint _tmp8__length1;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		_tmp8_ = exec_command;
		_tmp8__length1 = exec_command_length1;
		g_spawn_sync (NULL, _tmp8_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp9_, &_tmp10_, &_tmp11_, &_inner_error0_);
		_g_free0 (standard_output);
		standard_output = _tmp9_;
		_g_free0 (standard_error);
		standard_error = _tmp10_;
		exit_status = _tmp11_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch14_g_spawn_error;
			}
			_g_free0 (standard_error);
			_g_free0 (standard_output);
			exec_command = (_vala_array_free (exec_command, exec_command_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally14;
	__catch14_g_spawn_error:
	{
		GError* err = NULL;
		FILE* _tmp12_;
		GError* _tmp13_;
		const gchar* _tmp14_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp12_ = stderr;
		_tmp13_ = err;
		_tmp14_ = _tmp13_->message;
		fprintf (_tmp12_, "IBUS_ERROR: %s\n", _tmp14_);
		_g_error_free0 (err);
	}
	__finally14:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (standard_error);
		_g_free0 (standard_output);
		exec_command = (_vala_array_free (exec_command, exec_command_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (exit_status != 0) {
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_;
		FILE* _tmp17_;
		_tmp16_ = standard_error;
		_tmp15_ = _tmp16_;
		if (_tmp15_ == NULL) {
			_tmp15_ = "";
		}
		_tmp17_ = stderr;
		fprintf (_tmp17_, "IBUS_ERROR: %s\n", _tmp15_);
	}
	_tmp18_ = standard_output;
	if (_tmp18_ == NULL) {
		_g_free0 (standard_error);
		_g_free0 (standard_output);
		exec_command = (_vala_array_free (exec_command, exec_command_length1, (GDestroyNotify) g_free), NULL);
		if (layout) {
			*layout = _vala_layout;
		} else {
			_g_free0 (_vala_layout);
		}
		if (variant) {
			*variant = _vala_variant;
		} else {
			_g_free0 (_vala_variant);
		}
		if (option) {
			*option = _vala_option;
		} else {
			_g_free0 (_vala_option);
		}
		return;
	}
	_tmp19_ = standard_output;
	_tmp21_ = _tmp20_ = g_strsplit (_tmp19_, "\n", 0);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp21_;
		line_collection_length1 = _vala_array_length (_tmp20_);
		for (line_it = 0; line_it < _vala_array_length (_tmp20_); line_it = line_it + 1) {
			gchar* _tmp22_;
			gchar* line = NULL;
			_tmp22_ = g_strdup (line_collection[line_it]);
			line = _tmp22_;
			{
				gchar* element = NULL;
				gchar* _tmp23_;
				gchar* retval = NULL;
				gchar* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				const gchar* _tmp42_;
				const gchar* _tmp43_;
				gchar* _tmp57_;
				gchar* _tmp58_;
				const gchar* _tmp59_;
				const gchar* _tmp60_;
				_tmp23_ = g_strdup ("layout:");
				element = _tmp23_;
				_tmp24_ = g_strdup ("");
				retval = _tmp24_;
				_tmp25_ = line;
				_tmp26_ = element;
				if (g_str_has_prefix (_tmp25_, _tmp26_)) {
					const gchar* _tmp27_;
					const gchar* _tmp28_;
					gint _tmp29_;
					gint _tmp30_;
					const gchar* _tmp31_;
					gint _tmp32_;
					gint _tmp33_;
					gchar* _tmp34_;
					const gchar* _tmp35_;
					const gchar* _tmp38_;
					gchar* _tmp39_;
					_tmp27_ = line;
					_tmp28_ = element;
					_tmp29_ = strlen (_tmp28_);
					_tmp30_ = _tmp29_;
					_tmp31_ = line;
					_tmp32_ = strlen (_tmp31_);
					_tmp33_ = _tmp32_;
					_tmp34_ = string_slice (_tmp27_, (glong) _tmp30_, (glong) _tmp33_);
					_g_free0 (retval);
					retval = _tmp34_;
					_tmp35_ = retval;
					if (_tmp35_ != NULL) {
						const gchar* _tmp36_;
						gchar* _tmp37_;
						_tmp36_ = retval;
						_tmp37_ = string_strip (_tmp36_);
						_g_free0 (retval);
						retval = _tmp37_;
					}
					_tmp38_ = retval;
					_tmp39_ = g_strdup (_tmp38_);
					_g_free0 (_vala_layout);
					_vala_layout = _tmp39_;
				}
				_tmp40_ = g_strdup ("variant:");
				_g_free0 (element);
				element = _tmp40_;
				_tmp41_ = g_strdup ("");
				_g_free0 (retval);
				retval = _tmp41_;
				_tmp42_ = line;
				_tmp43_ = element;
				if (g_str_has_prefix (_tmp42_, _tmp43_)) {
					const gchar* _tmp44_;
					const gchar* _tmp45_;
					gint _tmp46_;
					gint _tmp47_;
					const gchar* _tmp48_;
					gint _tmp49_;
					gint _tmp50_;
					gchar* _tmp51_;
					const gchar* _tmp52_;
					const gchar* _tmp55_;
					gchar* _tmp56_;
					_tmp44_ = line;
					_tmp45_ = element;
					_tmp46_ = strlen (_tmp45_);
					_tmp47_ = _tmp46_;
					_tmp48_ = line;
					_tmp49_ = strlen (_tmp48_);
					_tmp50_ = _tmp49_;
					_tmp51_ = string_slice (_tmp44_, (glong) _tmp47_, (glong) _tmp50_);
					_g_free0 (retval);
					retval = _tmp51_;
					_tmp52_ = retval;
					if (_tmp52_ != NULL) {
						const gchar* _tmp53_;
						gchar* _tmp54_;
						_tmp53_ = retval;
						_tmp54_ = string_strip (_tmp53_);
						_g_free0 (retval);
						retval = _tmp54_;
					}
					_tmp55_ = retval;
					_tmp56_ = g_strdup (_tmp55_);
					_g_free0 (_vala_variant);
					_vala_variant = _tmp56_;
				}
				_tmp57_ = g_strdup ("options:");
				_g_free0 (element);
				element = _tmp57_;
				_tmp58_ = g_strdup ("");
				_g_free0 (retval);
				retval = _tmp58_;
				_tmp59_ = line;
				_tmp60_ = element;
				if (g_str_has_prefix (_tmp59_, _tmp60_)) {
					const gchar* _tmp61_;
					const gchar* _tmp62_;
					gint _tmp63_;
					gint _tmp64_;
					const gchar* _tmp65_;
					gint _tmp66_;
					gint _tmp67_;
					gchar* _tmp68_;
					const gchar* _tmp69_;
					const gchar* _tmp72_;
					gchar* _tmp73_;
					_tmp61_ = line;
					_tmp62_ = element;
					_tmp63_ = strlen (_tmp62_);
					_tmp64_ = _tmp63_;
					_tmp65_ = line;
					_tmp66_ = strlen (_tmp65_);
					_tmp67_ = _tmp66_;
					_tmp68_ = string_slice (_tmp61_, (glong) _tmp64_, (glong) _tmp67_);
					_g_free0 (retval);
					retval = _tmp68_;
					_tmp69_ = retval;
					if (_tmp69_ != NULL) {
						const gchar* _tmp70_;
						gchar* _tmp71_;
						_tmp70_ = retval;
						_tmp71_ = string_strip (_tmp70_);
						_g_free0 (retval);
						retval = _tmp71_;
					}
					_tmp72_ = retval;
					_tmp73_ = g_strdup (_tmp72_);
					_g_free0 (_vala_option);
					_vala_option = _tmp73_;
				}
				_g_free0 (retval);
				_g_free0 (element);
				_g_free0 (line);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_free0 (standard_error);
	_g_free0 (standard_output);
	exec_command = (_vala_array_free (exec_command, exec_command_length1, (GDestroyNotify) g_free), NULL);
	if (layout) {
		*layout = _vala_layout;
	} else {
		_g_free0 (_vala_layout);
	}
	if (variant) {
		*variant = _vala_variant;
	} else {
		_g_free0 (_vala_variant);
	}
	if (option) {
		*option = _vala_option;
	} else {
		_g_free0 (_vala_option);
	}
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             int stack_length,
                             const gchar* needle)
{
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static void
_vala_array_add28 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add29 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add30 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add31 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add32 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add33 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add34 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add35 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
xkb_layout_set_layout (XKBLayout* self,
                       IBusEngineDesc* engine)
{
	gchar* layout = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* variant = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* option = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	gboolean need_us_layout = FALSE;
	const gchar* _tmp16_;
	gboolean _tmp19_ = FALSE;
	const gchar* _tmp26_;
	gboolean _tmp30_ = FALSE;
	const gchar* _tmp31_;
	const gchar* _tmp37_;
	gboolean _tmp38_ = FALSE;
	const gchar* _tmp39_;
	gchar** args = NULL;
	gchar** _tmp59_;
	gint args_length1;
	gint _args_size_;
	gchar** _tmp60_;
	gint _tmp60__length1;
	gchar* _tmp61_;
	gchar** _tmp62_;
	gint _tmp62__length1;
	gchar* _tmp63_;
	gchar** _tmp64_;
	gint _tmp64__length1;
	const gchar* _tmp65_;
	gchar* _tmp66_;
	gboolean _tmp67_ = FALSE;
	gboolean _tmp68_ = FALSE;
	const gchar* _tmp69_;
	gboolean _tmp77_ = FALSE;
	gboolean _tmp78_ = FALSE;
	const gchar* _tmp79_;
	gchar* standard_error = NULL;
	gint exit_status = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = ibus_engine_desc_get_layout (engine);
	_tmp1_ = g_strdup (_tmp0_);
	layout = _tmp1_;
	_tmp2_ = ibus_engine_desc_get_layout_variant (engine);
	_tmp3_ = g_strdup (_tmp2_);
	variant = _tmp3_;
	_tmp4_ = ibus_engine_desc_get_layout_option (engine);
	_tmp5_ = g_strdup (_tmp4_);
	option = _tmp5_;
	_tmp6_ = layout;
	_vala_assert (_tmp6_ != NULL, "layout != null");
	_tmp9_ = layout;
	if (g_strcmp0 (_tmp9_, "default") == 0) {
		gboolean _tmp10_ = FALSE;
		const gchar* _tmp11_;
		_tmp11_ = variant;
		if (g_strcmp0 (_tmp11_, "default") == 0) {
			_tmp10_ = TRUE;
		} else {
			const gchar* _tmp12_;
			_tmp12_ = variant;
			_tmp10_ = g_strcmp0 (_tmp12_, "") == 0;
		}
		_tmp8_ = _tmp10_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		gboolean _tmp13_ = FALSE;
		const gchar* _tmp14_;
		_tmp14_ = option;
		if (g_strcmp0 (_tmp14_, "default") == 0) {
			_tmp13_ = TRUE;
		} else {
			const gchar* _tmp15_;
			_tmp15_ = option;
			_tmp13_ = g_strcmp0 (_tmp15_, "") == 0;
		}
		_tmp7_ = _tmp13_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		return;
	}
	need_us_layout = FALSE;
	_tmp16_ = variant;
	if (g_strcmp0 (_tmp16_, "eng") != 0) {
		const gchar* _tmp17_;
		gchar** _tmp18_;
		gint _tmp18__length1;
		_tmp17_ = layout;
		_tmp18_ = self->priv->m_xkb_latin_layouts;
		_tmp18__length1 = self->priv->m_xkb_latin_layouts_length1;
		need_us_layout = _vala_string_array_contains (_tmp18_, _tmp18__length1, _tmp17_);
	}
	if (!need_us_layout) {
		const gchar* _tmp20_;
		_tmp20_ = variant;
		_tmp19_ = _tmp20_ != NULL;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar** _tmp25_;
		gint _tmp25__length1;
		_tmp21_ = layout;
		_tmp22_ = variant;
		_tmp23_ = g_strdup_printf ("%s(%s)", _tmp21_, _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = self->priv->m_xkb_latin_layouts;
		_tmp25__length1 = self->priv->m_xkb_latin_layouts_length1;
		need_us_layout = _vala_string_array_contains (_tmp25_, _tmp25__length1, _tmp24_);
		_g_free0 (_tmp24_);
	}
	_tmp26_ = self->priv->m_default_layout;
	if (g_strcmp0 (_tmp26_, "") == 0) {
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		xkb_layout_get_layout (&_tmp27_, &_tmp28_, &_tmp29_);
		_g_free0 (self->priv->m_default_layout);
		self->priv->m_default_layout = _tmp27_;
		_g_free0 (self->priv->m_default_variant);
		self->priv->m_default_variant = _tmp28_;
		_g_free0 (self->priv->m_default_option);
		self->priv->m_default_option = _tmp29_;
	}
	_tmp31_ = layout;
	if (g_strcmp0 (_tmp31_, "default") == 0) {
		_tmp30_ = TRUE;
	} else {
		const gchar* _tmp32_;
		_tmp32_ = layout;
		_tmp30_ = g_strcmp0 (_tmp32_, "") == 0;
	}
	if (_tmp30_) {
		const gchar* _tmp33_;
		gchar* _tmp34_;
		const gchar* _tmp35_;
		gchar* _tmp36_;
		_tmp33_ = self->priv->m_default_layout;
		_tmp34_ = g_strdup (_tmp33_);
		_g_free0 (layout);
		layout = _tmp34_;
		_tmp35_ = self->priv->m_default_variant;
		_tmp36_ = g_strdup (_tmp35_);
		_g_free0 (variant);
		variant = _tmp36_;
	}
	_tmp37_ = layout;
	if (g_strcmp0 (_tmp37_, "") == 0) {
		g_warning ("xkblayout.vala:148: Could not get the correct layout");
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		return;
	}
	_tmp39_ = option;
	if (g_strcmp0 (_tmp39_, "default") == 0) {
		_tmp38_ = TRUE;
	} else {
		const gchar* _tmp40_;
		_tmp40_ = option;
		_tmp38_ = g_strcmp0 (_tmp40_, "") == 0;
	}
	if (_tmp38_) {
		const gchar* _tmp41_;
		gchar* _tmp42_;
		_tmp41_ = self->priv->m_default_option;
		_tmp42_ = g_strdup (_tmp41_);
		_g_free0 (option);
		option = _tmp42_;
	} else {
		const gchar* _tmp43_;
		const gchar* _tmp44_;
		gchar** _tmp45_;
		gchar** _tmp46_;
		gchar** _tmp47_;
		gint _tmp47__length1;
		gboolean _tmp48_;
		_tmp43_ = option;
		_tmp44_ = self->priv->m_default_option;
		_tmp46_ = _tmp45_ = g_strsplit (_tmp44_, ",", 0);
		_tmp47_ = _tmp46_;
		_tmp47__length1 = _vala_array_length (_tmp45_);
		_tmp48_ = !_vala_string_array_contains (_tmp47_, _vala_array_length (_tmp45_), _tmp43_);
		_tmp47_ = (_vala_array_free (_tmp47_, _tmp47__length1, (GDestroyNotify) g_free), NULL);
		if (_tmp48_) {
			const gchar* _tmp49_;
			const gchar* _tmp50_;
			gchar* _tmp51_;
			_tmp49_ = self->priv->m_default_option;
			_tmp50_ = option;
			_tmp51_ = g_strdup_printf ("%s,%s", _tmp49_, _tmp50_);
			_g_free0 (option);
			option = _tmp51_;
		} else {
			const gchar* _tmp52_;
			gchar* _tmp53_;
			_tmp52_ = self->priv->m_default_option;
			_tmp53_ = g_strdup (_tmp52_);
			_g_free0 (option);
			option = _tmp53_;
		}
	}
	if (need_us_layout) {
		const gchar* _tmp54_;
		gchar* _tmp55_;
		const gchar* _tmp56_;
		_tmp54_ = layout;
		_tmp55_ = g_strconcat (_tmp54_, ",us", NULL);
		_g_free0 (layout);
		layout = _tmp55_;
		_tmp56_ = variant;
		if (_tmp56_ != NULL) {
			const gchar* _tmp57_;
			gchar* _tmp58_;
			_tmp57_ = variant;
			_tmp58_ = g_strconcat (_tmp57_, ",", NULL);
			_g_free0 (variant);
			variant = _tmp58_;
		}
	}
	_tmp59_ = g_new0 (gchar*, 0 + 1);
	args = _tmp59_;
	args_length1 = 0;
	_args_size_ = args_length1;
	_tmp60_ = args;
	_tmp60__length1 = args_length1;
	_tmp61_ = g_strdup (XKB_LAYOUT_XKB_COMMAND);
	_vala_array_add28 (&args, &args_length1, &_args_size_, _tmp61_);
	_tmp62_ = args;
	_tmp62__length1 = args_length1;
	_tmp63_ = g_strdup (XKB_LAYOUT_XKB_LAYOUT_ARG);
	_vala_array_add29 (&args, &args_length1, &_args_size_, _tmp63_);
	_tmp64_ = args;
	_tmp64__length1 = args_length1;
	_tmp65_ = layout;
	_tmp66_ = g_strdup (_tmp65_);
	_vala_array_add30 (&args, &args_length1, &_args_size_, _tmp66_);
	_tmp69_ = variant;
	if (_tmp69_ != NULL) {
		const gchar* _tmp70_;
		_tmp70_ = variant;
		_tmp68_ = g_strcmp0 (_tmp70_, "") != 0;
	} else {
		_tmp68_ = FALSE;
	}
	if (_tmp68_) {
		const gchar* _tmp71_;
		_tmp71_ = variant;
		_tmp67_ = g_strcmp0 (_tmp71_, "default") != 0;
	} else {
		_tmp67_ = FALSE;
	}
	if (_tmp67_) {
		gchar** _tmp72_;
		gint _tmp72__length1;
		gchar* _tmp73_;
		gchar** _tmp74_;
		gint _tmp74__length1;
		const gchar* _tmp75_;
		gchar* _tmp76_;
		_tmp72_ = args;
		_tmp72__length1 = args_length1;
		_tmp73_ = g_strdup ("-variant");
		_vala_array_add31 (&args, &args_length1, &_args_size_, _tmp73_);
		_tmp74_ = args;
		_tmp74__length1 = args_length1;
		_tmp75_ = variant;
		_tmp76_ = g_strdup (_tmp75_);
		_vala_array_add32 (&args, &args_length1, &_args_size_, _tmp76_);
	}
	_tmp79_ = option;
	if (_tmp79_ != NULL) {
		const gchar* _tmp80_;
		_tmp80_ = option;
		_tmp78_ = g_strcmp0 (_tmp80_, "") != 0;
	} else {
		_tmp78_ = FALSE;
	}
	if (_tmp78_) {
		const gchar* _tmp81_;
		_tmp81_ = option;
		_tmp77_ = g_strcmp0 (_tmp81_, "default") != 0;
	} else {
		_tmp77_ = FALSE;
	}
	if (_tmp77_) {
		gchar** _tmp82_;
		gint _tmp82__length1;
		gchar* _tmp83_;
		gchar** _tmp84_;
		gint _tmp84__length1;
		gchar* _tmp85_;
		gchar** _tmp86_;
		gint _tmp86__length1;
		const gchar* _tmp87_;
		gchar* _tmp88_;
		_tmp82_ = args;
		_tmp82__length1 = args_length1;
		_tmp83_ = g_strdup ("-option");
		_vala_array_add33 (&args, &args_length1, &_args_size_, _tmp83_);
		_tmp84_ = args;
		_tmp84__length1 = args_length1;
		_tmp85_ = g_strdup ("-option");
		_vala_array_add34 (&args, &args_length1, &_args_size_, _tmp85_);
		_tmp86_ = args;
		_tmp86__length1 = args_length1;
		_tmp87_ = option;
		_tmp88_ = g_strdup (_tmp87_);
		_vala_array_add35 (&args, &args_length1, &_args_size_, _tmp88_);
	}
	standard_error = NULL;
	exit_status = 0;
	{
		gboolean _tmp89_ = FALSE;
		gchar** _tmp90_;
		gint _tmp90__length1;
		gchar* _tmp91_ = NULL;
		gint _tmp92_ = 0;
		gboolean _tmp93_;
		_tmp90_ = args;
		_tmp90__length1 = args_length1;
		_tmp93_ = g_spawn_sync (NULL, _tmp90_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_tmp91_, &_tmp92_, &_inner_error0_);
		_g_free0 (standard_error);
		standard_error = _tmp91_;
		exit_status = _tmp92_;
		_tmp89_ = _tmp93_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch15_g_spawn_error;
			}
			_g_free0 (standard_error);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (option);
			_g_free0 (variant);
			_g_free0 (layout);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		if (!_tmp89_) {
			const gchar* _tmp94_;
			_tmp94_ = ibus_engine_desc_get_layout (engine);
			g_warning ("xkblayout.vala:195: Switch xkb layout to %s failed.", _tmp94_);
		}
	}
	goto __finally15;
	__catch15_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp95_;
		const gchar* _tmp96_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp95_ = e;
		_tmp96_ = _tmp95_->message;
		g_warning ("xkblayout.vala:198: Execute setxkbmap failed: %s", _tmp96_);
		_g_error_free0 (e);
		_g_free0 (standard_error);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		return;
	}
	__finally15:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (standard_error);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (exit_status != 0) {
		const gchar* _tmp97_ = NULL;
		const gchar* _tmp98_;
		_tmp98_ = standard_error;
		_tmp97_ = _tmp98_;
		if (_tmp97_ == NULL) {
			_tmp97_ = "(null)";
		}
		g_warning ("xkblayout.vala:203: Execute setxkbmap failed: %s", _tmp97_);
	}
	xkb_layout_run_xmodmap (self);
	_g_free0 (standard_error);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (option);
	_g_free0 (variant);
	_g_free0 (layout);
}

void
xkb_layout_run_xmodmap (XKBLayout* self)
{
	gchar* homedir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (!self->priv->m_use_xmodmap) {
		return;
	}
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	homedir = _tmp1_;
	{
		const gchar** xmodmap_file_collection = NULL;
		gint xmodmap_file_collection_length1 = 0;
		gint _xmodmap_file_collection_size_ = 0;
		gint xmodmap_file_it = 0;
		xmodmap_file_collection = XKB_LAYOUT_XMODMAP_KNOWN_FILES;
		xmodmap_file_collection_length1 = G_N_ELEMENTS (XKB_LAYOUT_XMODMAP_KNOWN_FILES);
		for (xmodmap_file_it = 0; xmodmap_file_it < G_N_ELEMENTS (XKB_LAYOUT_XMODMAP_KNOWN_FILES); xmodmap_file_it = xmodmap_file_it + 1) {
			gchar* _tmp2_;
			gchar* xmodmap_file = NULL;
			_tmp2_ = g_strdup (xmodmap_file_collection[xmodmap_file_it]);
			xmodmap_file = _tmp2_;
			{
				gchar* xmodmap_filepath = NULL;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				gchar* _tmp5_;
				const gchar* _tmp6_;
				gchar** args = NULL;
				gchar* _tmp7_;
				const gchar* _tmp8_;
				gchar* _tmp9_;
				gchar** _tmp10_;
				gint args_length1;
				gint _args_size_;
				_tmp3_ = homedir;
				_tmp4_ = xmodmap_file;
				_tmp5_ = g_build_filename (_tmp3_, _tmp4_, NULL);
				xmodmap_filepath = _tmp5_;
				_tmp6_ = xmodmap_filepath;
				if (!g_file_test (_tmp6_, G_FILE_TEST_EXISTS)) {
					_g_free0 (xmodmap_filepath);
					_g_free0 (xmodmap_file);
					continue;
				}
				_tmp7_ = g_strdup (XKB_LAYOUT_XMODMAP_COMMAND);
				_tmp8_ = xmodmap_filepath;
				_tmp9_ = g_strdup (_tmp8_);
				_tmp10_ = g_new0 (gchar*, 2 + 1);
				_tmp10_[0] = _tmp7_;
				_tmp10_[1] = _tmp9_;
				args = _tmp10_;
				args_length1 = 2;
				_args_size_ = args_length1;
				{
					gchar** _tmp11_;
					gint _tmp11__length1;
					_tmp11_ = args;
					_tmp11__length1 = args_length1;
					g_spawn_async (NULL, _tmp11_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == G_SPAWN_ERROR) {
							goto __catch16_g_spawn_error;
						}
						args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (xmodmap_filepath);
						_g_free0 (xmodmap_file);
						_g_free0 (homedir);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				goto __finally16;
				__catch16_g_spawn_error:
				{
					GError* e = NULL;
					GError* _tmp12_;
					const gchar* _tmp13_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp12_ = e;
					_tmp13_ = _tmp12_->message;
					g_warning ("xkblayout.vala:241: Execute xmodmap is failed: %s\n", _tmp13_);
					_g_error_free0 (e);
					args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (xmodmap_filepath);
					_g_free0 (xmodmap_file);
					_g_free0 (homedir);
					return;
				}
				__finally16:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (xmodmap_filepath);
					_g_free0 (xmodmap_file);
					_g_free0 (homedir);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (xmodmap_filepath);
				_g_free0 (xmodmap_file);
				break;
			}
		}
	}
	_g_free0 (homedir);
}

void
xkb_layout_set_use_xmodmap (XKBLayout* self,
                            gboolean use_xmodmap)
{
	g_return_if_fail (self != NULL);
	self->priv->m_use_xmodmap = use_xmodmap;
}

static void
value_xkb_layout_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_xkb_layout_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		xkb_layout_unref (value->data[0].v_pointer);
	}
}

static void
value_xkb_layout_copy_value (const GValue* src_value,
                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = xkb_layout_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_xkb_layout_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_xkb_layout_collect_value (GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		XKBLayout * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = xkb_layout_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_xkb_layout_lcopy_value (const GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	XKBLayout ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = xkb_layout_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_xkb_layout (const gchar* name,
                       const gchar* nick,
                       const gchar* blurb,
                       GType object_type,
                       GParamFlags flags)
{
	ParamSpecXKBLayout* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_XKB_LAYOUT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_xkb_layout (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_XKB_LAYOUT), NULL);
	return value->data[0].v_pointer;
}

void
value_set_xkb_layout (GValue* value,
                      gpointer v_object)
{
	XKBLayout * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_XKB_LAYOUT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_XKB_LAYOUT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		xkb_layout_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		xkb_layout_unref (old);
	}
}

void
value_take_xkb_layout (GValue* value,
                       gpointer v_object)
{
	XKBLayout * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_XKB_LAYOUT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_XKB_LAYOUT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		xkb_layout_unref (old);
	}
}

static void
xkb_layout_class_init (XKBLayoutClass * klass,
                       gpointer klass_data)
{
	xkb_layout_parent_class = g_type_class_peek_parent (klass);
	((XKBLayoutClass *) klass)->finalize = xkb_layout_finalize;
	g_type_class_adjust_private_offset (klass, &XKBLayout_private_offset);
}

static void
xkb_layout_instance_init (XKBLayout * self,
                          gpointer klass)
{
	gchar** _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	self->priv = xkb_layout_get_instance_private (self);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	self->priv->m_xkb_latin_layouts = _tmp0_;
	self->priv->m_xkb_latin_layouts_length1 = 0;
	self->priv->_m_xkb_latin_layouts_size_ = self->priv->m_xkb_latin_layouts_length1;
	_tmp1_ = g_strdup ("");
	self->priv->m_default_layout = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->priv->m_default_variant = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->priv->m_default_option = _tmp3_;
	self->priv->m_use_xmodmap = TRUE;
	self->ref_count = 1;
}

static void
xkb_layout_finalize (XKBLayout * obj)
{
	XKBLayout * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_XKB_LAYOUT, XKBLayout);
	g_signal_handlers_destroy (self);
	self->priv->m_xkb_latin_layouts = (_vala_array_free (self->priv->m_xkb_latin_layouts, self->priv->m_xkb_latin_layouts_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->m_default_layout);
	_g_free0 (self->priv->m_default_variant);
	_g_free0 (self->priv->m_default_option);
}

GType
xkb_layout_get_type (void)
{
	static volatile gsize xkb_layout_type_id__volatile = 0;
	if (g_once_init_enter (&xkb_layout_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_xkb_layout_init, value_xkb_layout_free_value, value_xkb_layout_copy_value, value_xkb_layout_peek_pointer, "p", value_xkb_layout_collect_value, "p", value_xkb_layout_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (XKBLayoutClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xkb_layout_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XKBLayout), 0, (GInstanceInitFunc) xkb_layout_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType xkb_layout_type_id;
		xkb_layout_type_id = g_type_register_fundamental (g_type_fundamental_next (), "XKBLayout", &g_define_type_info, &g_define_type_fundamental_info, 0);
		XKBLayout_private_offset = g_type_add_instance_private (xkb_layout_type_id, sizeof (XKBLayoutPrivate));
		g_once_init_leave (&xkb_layout_type_id__volatile, xkb_layout_type_id);
	}
	return xkb_layout_type_id__volatile;
}

gpointer
xkb_layout_ref (gpointer instance)
{
	XKBLayout * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
xkb_layout_unref (gpointer instance)
{
	XKBLayout * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		XKB_LAYOUT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

