/* panelbinding.c generated by valac 0.38.2, the Vala compiler
 * generated from panelbinding.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2018 Peng Huang <shawn.p.huang@gmail.com>
 * Copyright(c) 2018 Takao Fujwiara <takao.fujiwara1@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include <glib.h>
#include <glib-object.h>
#include <ibus.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <gdk/gdkx.h>


#define TYPE_PANEL_BINDING (panel_binding_get_type ())
#define PANEL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PANEL_BINDING, PanelBinding))
#define PANEL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PANEL_BINDING, PanelBindingClass))
#define IS_PANEL_BINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PANEL_BINDING))
#define IS_PANEL_BINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PANEL_BINDING))
#define PANEL_BINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PANEL_BINDING, PanelBindingClass))

typedef struct _PanelBinding PanelBinding;
typedef struct _PanelBindingClass PanelBindingClass;
typedef struct _PanelBindingPrivate PanelBindingPrivate;

#define TYPE_IBUS_EMOJIER (ibus_emojier_get_type ())
#define IBUS_EMOJIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IBUS_EMOJIER, IBusEmojier))
#define IBUS_EMOJIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IBUS_EMOJIER, IBusEmojierClass))
#define IS_IBUS_EMOJIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IBUS_EMOJIER))
#define IS_IBUS_EMOJIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IBUS_EMOJIER))
#define IBUS_EMOJIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IBUS_EMOJIER, IBusEmojierClass))

typedef struct _IBusEmojier IBusEmojier;
typedef struct _IBusEmojierClass IBusEmojierClass;
enum  {
	PANEL_BINDING_DUMMY_PROPERTY,
	PANEL_BINDING_LAST_PROPERTY
};
static GParamSpec* panel_binding_properties[PANEL_BINDING_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
#define __vala_GdkEvent_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEvent_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PanelBinding {
	IBusPanelService parent_instance;
	PanelBindingPrivate * priv;
};

struct _PanelBindingClass {
	IBusPanelServiceClass parent_class;
};

struct _PanelBindingPrivate {
	IBusBus* m_bus;
	GtkApplication* m_application;
	GSettings* m_settings_panel;
	GSettings* m_settings_emoji;
	gchar* m_current_context_path;
	gchar* m_real_current_context_path;
	IBusEmojier* m_emojier;
	guint m_emojier_set_emoji_lang_id;
	guint m_emojier_focus_commit_text_id;
	gchar** m_emojier_favorites;
	gint m_emojier_favorites_length1;
	gint _m_emojier_favorites_size_;
	GtkCssProvider* m_css_provider;
	gboolean m_load_emoji_at_startup;
	gboolean m_loaded_emoji;
	gboolean m_load_unicode_at_startup;
	gboolean m_loaded_unicode;
};


static gpointer panel_binding_parent_class = NULL;

GType panel_binding_get_type (void) G_GNUC_CONST;
GType ibus_emojier_get_type (void) G_GNUC_CONST;
#define PANEL_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PANEL_BINDING, PanelBindingPrivate))
#define PANEL_BINDING_PRELOAD_ENGINES_DELAY_TIME ((guint) 30000)
PanelBinding* panel_binding_new (IBusBus* bus, GtkApplication* application);
PanelBinding* panel_binding_construct (GType object_type, IBusBus* bus, GtkApplication* application);
static void panel_binding_init_settings (PanelBinding* self);
static void __lambda24_ (PanelBinding* self, const gchar* key);
void binding_common_set_custom_font (GSettings* settings_panel, GSettings* settings_emoji, GtkCssProvider* * css_provider);
static void ___lambda24__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda25_ (PanelBinding* self, const gchar* key);
static void ___lambda25__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda26_ (PanelBinding* self, const gchar* key);
static void ___lambda26__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda27_ (PanelBinding* self, const gchar* key);
static void panel_binding_set_emoji_favorites (PanelBinding* self);
static void ___lambda27__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda28_ (PanelBinding* self, const gchar* key);
static void ___lambda28__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda29_ (PanelBinding* self, const gchar* key);
static void panel_binding_set_emoji_lang (PanelBinding* self);
static void ___lambda29__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda31_ (PanelBinding* self, const gchar* key);
static void panel_binding_set_emoji_partial_match (PanelBinding* self);
static void ___lambda31__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda32_ (PanelBinding* self, const gchar* key);
static void ___lambda32__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda33_ (PanelBinding* self, const gchar* key);
static void ___lambda33__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda34_ (PanelBinding* self, const gchar* key);
static void panel_binding_set_load_emoji_at_startup (PanelBinding* self);
static void ___lambda34__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void __lambda35_ (PanelBinding* self, const gchar* key);
static void panel_binding_set_load_unicode_at_startup (PanelBinding* self);
static void ___lambda35__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
void ibus_emojier_set_favorites (gchar** unowned_favorites, int unowned_favorites_length1, gchar** unowned_favorite_annotations, int unowned_favorite_annotations_length1);
static gboolean __lambda30_ (PanelBinding* self);
void ibus_emojier_set_annotation_lang (const gchar* lang);
void ibus_emojier_load_unicode_dict (void);
static gboolean ___lambda30__gsource_func (gpointer self);
void ibus_emojier_set_partial_match (gboolean has_partial_match);
void ibus_emojier_set_partial_match_length (gint length);
void ibus_emojier_set_partial_match_condition (gint condition);
void panel_binding_load_settings (PanelBinding* self);
void panel_binding_disconnect_signals (PanelBinding* self);
static void panel_binding_show_emojier (PanelBinding* self, GdkEvent* event);
IBusEmojier* ibus_emojier_new (void);
IBusEmojier* ibus_emojier_construct (GType object_type);
gchar* ibus_emojier_run (IBusEmojier* self, const gchar* input_context_path, GdkEvent* event);
static void panel_binding_emojier_focus_commit (PanelBinding* self);
static void panel_binding_handle_emoji_typing (PanelBinding* self, GdkEvent* event);
gboolean ibus_emojier_is_running (IBusEmojier* self);
void ibus_emojier_present_centralize (IBusEmojier* self, GdkEvent* event);
static gboolean panel_binding_emojier_focus_commit_real (PanelBinding* self);
gchar* ibus_emojier_get_selected_string (IBusEmojier* self);
gchar* ibus_emojier_get_input_context_path (IBusEmojier* self);
static void _vala_array_add8 (gchar** * array, int* length, int* size, gchar* value);
static gboolean ___lambda36_ (PanelBinding* self);
static gboolean ____lambda36__gsource_func (gpointer self);
static void panel_binding_real_focus_in (IBusPanelService* base, const gchar* input_context_path);
static void panel_binding_real_focus_out (IBusPanelService* base, const gchar* input_context_path);
static void panel_binding_real_panel_extension_received (IBusPanelService* base, GVariant* data);
static void _vala_GdkEvent_free (GdkEvent* self);
static void panel_binding_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


PanelBinding* panel_binding_construct (GType object_type, IBusBus* bus, GtkApplication* application) {
	PanelBinding * self = NULL;
	IBusBus* _tmp0_;
	gboolean _tmp1_;
	IBusBus* _tmp2_;
	GDBusConnection* _tmp3_;
	IBusBus* _tmp4_;
	IBusBus* _tmp5_;
	GtkApplication* _tmp6_;
	GtkApplication* _tmp7_;
	g_return_val_if_fail (bus != NULL, NULL);
	g_return_val_if_fail (application != NULL, NULL);
	_tmp0_ = bus;
	_tmp1_ = ibus_bus_is_connected (_tmp0_);
	_vala_assert (_tmp1_, "bus.is_connected()");
	_tmp2_ = bus;
	_tmp3_ = ibus_bus_get_connection (_tmp2_);
	self = (PanelBinding*) g_object_new (object_type, "connection", _tmp3_, "object-path", IBUS_PATH_PANEL_EXTENSION, NULL);
	_tmp4_ = bus;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->m_bus);
	self->priv->m_bus = _tmp5_;
	_tmp6_ = application;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (self->priv->m_application);
	self->priv->m_application = _tmp7_;
	panel_binding_init_settings (self);
	return self;
}


PanelBinding* panel_binding_new (IBusBus* bus, GtkApplication* application) {
	return panel_binding_construct (TYPE_PANEL_BINDING, bus, application);
}


static void __lambda24_ (PanelBinding* self, const gchar* key) {
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->m_settings_panel;
	_tmp1_ = self->priv->m_settings_emoji;
	binding_common_set_custom_font (_tmp0_, _tmp1_, &self->priv->m_css_provider);
}


static void ___lambda24__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda24_ ((PanelBinding*) self, key);
}


static void __lambda25_ (PanelBinding* self, const gchar* key) {
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->m_settings_panel;
	_tmp1_ = self->priv->m_settings_emoji;
	binding_common_set_custom_font (_tmp0_, _tmp1_, &self->priv->m_css_provider);
}


static void ___lambda25__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda25_ ((PanelBinding*) self, key);
}


static void __lambda26_ (PanelBinding* self, const gchar* key) {
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->m_settings_panel;
	_tmp1_ = self->priv->m_settings_emoji;
	binding_common_set_custom_font (_tmp0_, _tmp1_, &self->priv->m_css_provider);
}


static void ___lambda26__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda26_ ((PanelBinding*) self, key);
}


static void __lambda27_ (PanelBinding* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_binding_set_emoji_favorites (self);
}


static void ___lambda27__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda27_ ((PanelBinding*) self, key);
}


static void __lambda28_ (PanelBinding* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_binding_set_emoji_favorites (self);
}


static void ___lambda28__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda28_ ((PanelBinding*) self, key);
}


static void __lambda29_ (PanelBinding* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_binding_set_emoji_lang (self);
}


static void ___lambda29__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda29_ ((PanelBinding*) self, key);
}


static void __lambda31_ (PanelBinding* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_binding_set_emoji_partial_match (self);
}


static void ___lambda31__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda31_ ((PanelBinding*) self, key);
}


static void __lambda32_ (PanelBinding* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_binding_set_emoji_partial_match (self);
}


static void ___lambda32__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda32_ ((PanelBinding*) self, key);
}


static void __lambda33_ (PanelBinding* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_binding_set_emoji_partial_match (self);
}


static void ___lambda33__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda33_ ((PanelBinding*) self, key);
}


static void __lambda34_ (PanelBinding* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_binding_set_load_emoji_at_startup (self);
}


static void ___lambda34__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda34_ ((PanelBinding*) self, key);
}


static void __lambda35_ (PanelBinding* self, const gchar* key) {
	g_return_if_fail (key != NULL);
	panel_binding_set_load_unicode_at_startup (self);
}


static void ___lambda35__g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	__lambda35_ ((PanelBinding*) self, key);
}


static void panel_binding_init_settings (PanelBinding* self) {
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	GSettings* _tmp7_;
	GSettings* _tmp8_;
	GSettings* _tmp9_;
	GSettings* _tmp10_;
	GSettings* _tmp11_;
	GSettings* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.freedesktop.ibus.panel");
	_g_object_unref0 (self->priv->m_settings_panel);
	self->priv->m_settings_panel = _tmp0_;
	_tmp1_ = g_settings_new ("org.freedesktop.ibus.panel.emoji");
	_g_object_unref0 (self->priv->m_settings_emoji);
	self->priv->m_settings_emoji = _tmp1_;
	_tmp2_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp2_, "changed::custom-font", (GCallback) ___lambda24__g_settings_changed, self, 0);
	_tmp3_ = self->priv->m_settings_panel;
	g_signal_connect_object (_tmp3_, "changed::use-custom-font", (GCallback) ___lambda25__g_settings_changed, self, 0);
	_tmp4_ = self->priv->m_settings_emoji;
	g_signal_connect_object (_tmp4_, "changed::font", (GCallback) ___lambda26__g_settings_changed, self, 0);
	_tmp5_ = self->priv->m_settings_emoji;
	g_signal_connect_object (_tmp5_, "changed::favorites", (GCallback) ___lambda27__g_settings_changed, self, 0);
	_tmp6_ = self->priv->m_settings_emoji;
	g_signal_connect_object (_tmp6_, "changed::favorite-annotations", (GCallback) ___lambda28__g_settings_changed, self, 0);
	_tmp7_ = self->priv->m_settings_emoji;
	g_signal_connect_object (_tmp7_, "changed::lang", (GCallback) ___lambda29__g_settings_changed, self, 0);
	_tmp8_ = self->priv->m_settings_emoji;
	g_signal_connect_object (_tmp8_, "changed::has-partial-match", (GCallback) ___lambda31__g_settings_changed, self, 0);
	_tmp9_ = self->priv->m_settings_emoji;
	g_signal_connect_object (_tmp9_, "changed::partial-match-length", (GCallback) ___lambda32__g_settings_changed, self, 0);
	_tmp10_ = self->priv->m_settings_emoji;
	g_signal_connect_object (_tmp10_, "changed::partial-match-condition", (GCallback) ___lambda33__g_settings_changed, self, 0);
	_tmp11_ = self->priv->m_settings_emoji;
	g_signal_connect_object (_tmp11_, "changed::load-emoji-at-startup", (GCallback) ___lambda34__g_settings_changed, self, 0);
	_tmp12_ = self->priv->m_settings_emoji;
	g_signal_connect_object (_tmp12_, "changed::load-unicode-at-startup", (GCallback) ___lambda35__g_settings_changed, self, 0);
}


static void panel_binding_set_emoji_favorites (PanelBinding* self) {
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	GSettings* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_emoji;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, "favorites");
	self->priv->m_emojier_favorites = (_vala_array_free (self->priv->m_emojier_favorites, self->priv->m_emojier_favorites_length1, (GDestroyNotify) g_free), NULL);
	self->priv->m_emojier_favorites = _tmp2_;
	self->priv->m_emojier_favorites_length1 = _vala_array_length (_tmp1_);
	self->priv->_m_emojier_favorites_size_ = self->priv->m_emojier_favorites_length1;
	_tmp3_ = self->priv->m_emojier_favorites;
	_tmp3__length1 = self->priv->m_emojier_favorites_length1;
	_tmp4_ = self->priv->m_settings_emoji;
	_tmp6_ = _tmp5_ = g_settings_get_strv (_tmp4_, "favorite-annotations");
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _vala_array_length (_tmp5_);
	ibus_emojier_set_favorites (_tmp3_, _tmp3__length1, _tmp7_, _vala_array_length (_tmp5_));
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
}


static gboolean __lambda30_ (PanelBinding* self) {
	gboolean result = FALSE;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	_tmp0_ = self->priv->m_settings_emoji;
	_tmp1_ = g_settings_get_string (_tmp0_, "lang");
	_tmp2_ = _tmp1_;
	ibus_emojier_set_annotation_lang (_tmp2_);
	_g_free0 (_tmp2_);
	self->priv->m_emojier_set_emoji_lang_id = (guint) 0;
	self->priv->m_loaded_emoji = TRUE;
	_tmp4_ = self->priv->m_load_unicode_at_startup;
	if (_tmp4_) {
		gboolean _tmp5_;
		_tmp5_ = self->priv->m_loaded_unicode;
		_tmp3_ = !_tmp5_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ibus_emojier_load_unicode_dict ();
		self->priv->m_loaded_unicode = TRUE;
	}
	result = FALSE;
	return result;
}


static gboolean ___lambda30__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda30_ ((PanelBinding*) self);
	return result;
}


static void panel_binding_set_emoji_lang (PanelBinding* self) {
	guint _tmp0_;
	guint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_emojier_set_emoji_lang_id;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->m_emojier_set_emoji_lang_id;
		g_source_remove (_tmp1_);
		self->priv->m_emojier_set_emoji_lang_id = (guint) 0;
	}
	_tmp2_ = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda30__gsource_func, g_object_ref (self), g_object_unref);
	self->priv->m_emojier_set_emoji_lang_id = _tmp2_;
}


static void panel_binding_set_emoji_partial_match (PanelBinding* self) {
	GSettings* _tmp0_;
	gboolean _tmp1_;
	GSettings* _tmp2_;
	gint _tmp3_;
	GSettings* _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_emoji;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "has-partial-match");
	ibus_emojier_set_partial_match (_tmp1_);
	_tmp2_ = self->priv->m_settings_emoji;
	_tmp3_ = g_settings_get_int (_tmp2_, "partial-match-length");
	ibus_emojier_set_partial_match_length (_tmp3_);
	_tmp4_ = self->priv->m_settings_emoji;
	_tmp5_ = g_settings_get_int (_tmp4_, "partial-match-condition");
	ibus_emojier_set_partial_match_condition (_tmp5_);
}


static void panel_binding_set_load_emoji_at_startup (PanelBinding* self) {
	GSettings* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_emoji;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "load-emoji-at-startup");
	self->priv->m_load_emoji_at_startup = _tmp1_;
}


static void panel_binding_set_load_unicode_at_startup (PanelBinding* self) {
	GSettings* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_settings_emoji;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "load-unicode-at-startup");
	self->priv->m_load_unicode_at_startup = _tmp1_;
}


void panel_binding_load_settings (PanelBinding* self) {
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	panel_binding_set_load_emoji_at_startup (self);
	panel_binding_set_load_unicode_at_startup (self);
	_tmp0_ = self->priv->m_settings_panel;
	_tmp1_ = self->priv->m_settings_emoji;
	binding_common_set_custom_font (_tmp0_, _tmp1_, &self->priv->m_css_provider);
	panel_binding_set_emoji_favorites (self);
	_tmp3_ = self->priv->m_load_emoji_at_startup;
	if (_tmp3_) {
		gboolean _tmp4_;
		_tmp4_ = self->priv->m_loaded_emoji;
		_tmp2_ = !_tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		panel_binding_set_emoji_lang (self);
	}
	panel_binding_set_emoji_partial_match (self);
}


/**
     * disconnect_signals:
     *
     * Call this API before m_panel = null so that the ref_count becomes 0
     */
void panel_binding_disconnect_signals (PanelBinding* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_emojier_set_emoji_lang_id;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->m_emojier_set_emoji_lang_id;
		g_source_remove (_tmp1_);
		self->priv->m_emojier_set_emoji_lang_id = (guint) 0;
	}
	_g_object_unref0 (self->priv->m_application);
	self->priv->m_application = NULL;
}


static void panel_binding_show_emojier (PanelBinding* self, GdkEvent* event) {
	gboolean _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	IBusEmojier* _tmp4_;
	GtkApplication* _tmp5_;
	IBusEmojier* _tmp6_;
	gchar* emoji = NULL;
	IBusEmojier* _tmp7_;
	const gchar* _tmp8_;
	GdkEvent* _tmp9_;
	gchar* _tmp10_;
	GtkApplication* _tmp11_;
	IBusEmojier* _tmp12_;
	const gchar* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = self->priv->m_loaded_emoji;
	if (!_tmp0_) {
		panel_binding_set_emoji_lang (self);
	}
	_tmp2_ = self->priv->m_loaded_unicode;
	if (!_tmp2_) {
		gboolean _tmp3_;
		_tmp3_ = self->priv->m_loaded_emoji;
		_tmp1_ = _tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ibus_emojier_load_unicode_dict ();
		self->priv->m_loaded_unicode = TRUE;
	}
	_tmp4_ = ibus_emojier_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->m_emojier);
	self->priv->m_emojier = _tmp4_;
	_tmp5_ = self->priv->m_application;
	_tmp6_ = self->priv->m_emojier;
	gtk_application_add_window (_tmp5_, (GtkWindow*) _tmp6_);
	_tmp7_ = self->priv->m_emojier;
	_tmp8_ = self->priv->m_real_current_context_path;
	_tmp9_ = event;
	_tmp10_ = ibus_emojier_run (_tmp7_, _tmp8_, _tmp9_);
	emoji = _tmp10_;
	_tmp11_ = self->priv->m_application;
	_tmp12_ = self->priv->m_emojier;
	gtk_application_remove_window (_tmp11_, (GtkWindow*) _tmp12_);
	_tmp13_ = emoji;
	if (_tmp13_ == NULL) {
		_g_object_unref0 (self->priv->m_emojier);
		self->priv->m_emojier = NULL;
		_g_free0 (emoji);
		return;
	}
	panel_binding_emojier_focus_commit (self);
	_g_free0 (emoji);
}


static void panel_binding_handle_emoji_typing (PanelBinding* self, GdkEvent* event) {
	gboolean _tmp0_ = FALSE;
	IBusEmojier* _tmp1_;
	GdkEvent* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp1_ = self->priv->m_emojier;
	if (_tmp1_ != NULL) {
		IBusEmojier* _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = self->priv->m_emojier;
		_tmp3_ = ibus_emojier_is_running (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		IBusEmojier* _tmp4_;
		GdkEvent* _tmp5_;
		_tmp4_ = self->priv->m_emojier;
		_tmp5_ = event;
		ibus_emojier_present_centralize (_tmp4_, _tmp5_);
		return;
	}
	_tmp6_ = event;
	panel_binding_show_emojier (self, _tmp6_);
}


static void _vala_array_add8 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean panel_binding_emojier_focus_commit_real (PanelBinding* self) {
	gboolean result = FALSE;
	IBusEmojier* _tmp0_;
	gchar* selected_string = NULL;
	IBusEmojier* _tmp1_;
	gchar* _tmp2_;
	gchar* prev_context_path = NULL;
	IBusEmojier* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_emojier;
	if (_tmp0_ == NULL) {
		result = TRUE;
		return result;
	}
	_tmp1_ = self->priv->m_emojier;
	_tmp2_ = ibus_emojier_get_selected_string (_tmp1_);
	selected_string = _tmp2_;
	_tmp3_ = self->priv->m_emojier;
	_tmp4_ = ibus_emojier_get_input_context_path (_tmp3_);
	prev_context_path = _tmp4_;
	_tmp7_ = selected_string;
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_;
		_tmp8_ = prev_context_path;
		_tmp6_ = g_strcmp0 (_tmp8_, "") != 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp9_ = prev_context_path;
		_tmp10_ = self->priv->m_current_context_path;
		_tmp5_ = g_strcmp0 (_tmp9_, _tmp10_) == 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		IBusText* text = NULL;
		const gchar* _tmp11_;
		IBusText* _tmp12_;
		IBusText* _tmp13_;
		gboolean has_favorite = FALSE;
		gchar** _tmp14_;
		gint _tmp14__length1;
		gboolean _tmp17_;
		_tmp11_ = selected_string;
		_tmp12_ = ibus_text_new_from_string (_tmp11_);
		g_object_ref_sink (_tmp12_);
		text = _tmp12_;
		_tmp13_ = text;
		ibus_panel_service_commit_text ((IBusPanelService*) self, _tmp13_);
		_g_object_unref0 (self->priv->m_emojier);
		self->priv->m_emojier = NULL;
		has_favorite = FALSE;
		_tmp14_ = self->priv->m_emojier_favorites;
		_tmp14__length1 = self->priv->m_emojier_favorites_length1;
		{
			gchar** favorite_collection = NULL;
			gint favorite_collection_length1 = 0;
			gint _favorite_collection_size_ = 0;
			gint favorite_it = 0;
			favorite_collection = _tmp14_;
			favorite_collection_length1 = _tmp14__length1;
			for (favorite_it = 0; favorite_it < _tmp14__length1; favorite_it = favorite_it + 1) {
				const gchar* favorite = NULL;
				favorite = favorite_collection[favorite_it];
				{
					const gchar* _tmp15_;
					const gchar* _tmp16_;
					_tmp15_ = favorite;
					_tmp16_ = selected_string;
					if (g_strcmp0 (_tmp15_, _tmp16_) == 0) {
						has_favorite = TRUE;
						break;
					}
				}
			}
		}
		_tmp17_ = has_favorite;
		if (!_tmp17_) {
			gchar** _tmp18_;
			gint _tmp18__length1;
			const gchar* _tmp19_;
			gchar* _tmp20_;
			GSettings* _tmp21_;
			gchar** _tmp22_;
			gint _tmp22__length1;
			_tmp18_ = self->priv->m_emojier_favorites;
			_tmp18__length1 = self->priv->m_emojier_favorites_length1;
			_tmp19_ = selected_string;
			_tmp20_ = g_strdup (_tmp19_);
			_vala_array_add8 (&self->priv->m_emojier_favorites, &self->priv->m_emojier_favorites_length1, &self->priv->_m_emojier_favorites_size_, _tmp20_);
			_tmp21_ = self->priv->m_settings_emoji;
			_tmp22_ = self->priv->m_emojier_favorites;
			_tmp22__length1 = self->priv->m_emojier_favorites_length1;
			g_settings_set_strv (_tmp21_, "favorites", _tmp22_);
		}
		result = TRUE;
		_g_object_unref0 (text);
		_g_free0 (prev_context_path);
		_g_free0 (selected_string);
		return result;
	}
	result = FALSE;
	_g_free0 (prev_context_path);
	_g_free0 (selected_string);
	return result;
}


static gpointer _g_main_context_ref0 (gpointer self) {
	return self ? g_main_context_ref (self) : NULL;
}


static gboolean ___lambda36_ (PanelBinding* self) {
	gboolean result = FALSE;
	panel_binding_emojier_focus_commit_real (self);
	self->priv->m_emojier_focus_commit_text_id = (guint) -1;
	result = FALSE;
	return result;
}


static gboolean ____lambda36__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda36_ ((PanelBinding*) self);
	return result;
}


static void panel_binding_emojier_focus_commit (PanelBinding* self) {
	IBusEmojier* _tmp0_;
	gchar* selected_string = NULL;
	IBusEmojier* _tmp1_;
	gchar* _tmp2_;
	gchar* prev_context_path = NULL;
	IBusEmojier* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_emojier;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->m_emojier;
	_tmp2_ = ibus_emojier_get_selected_string (_tmp1_);
	selected_string = _tmp2_;
	_tmp3_ = self->priv->m_emojier;
	_tmp4_ = ibus_emojier_get_input_context_path (_tmp3_);
	prev_context_path = _tmp4_;
	_tmp7_ = selected_string;
	if (_tmp7_ == NULL) {
		const gchar* _tmp8_;
		_tmp8_ = prev_context_path;
		_tmp6_ = g_strcmp0 (_tmp8_, "") != 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		IBusEmojier* _tmp9_;
		gboolean _tmp10_;
		_tmp9_ = self->priv->m_emojier;
		_tmp10_ = ibus_emojier_is_running (_tmp9_);
		_tmp5_ = _tmp10_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		GMainContext* context = NULL;
		GMainContext* _tmp11_;
		GMainContext* _tmp12_;
		gboolean _tmp13_ = FALSE;
		guint _tmp14_;
		guint _tmp19_;
		_tmp11_ = g_main_context_default ();
		_tmp12_ = _g_main_context_ref0 (_tmp11_);
		context = _tmp12_;
		_tmp14_ = self->priv->m_emojier_focus_commit_text_id;
		if (_tmp14_ > ((guint) 0)) {
			GMainContext* _tmp15_;
			guint _tmp16_;
			GSource* _tmp17_;
			_tmp15_ = context;
			_tmp16_ = self->priv->m_emojier_focus_commit_text_id;
			_tmp17_ = g_main_context_find_source_by_id (_tmp15_, _tmp16_);
			_tmp13_ = _tmp17_ != NULL;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			guint _tmp18_;
			_tmp18_ = self->priv->m_emojier_focus_commit_text_id;
			g_source_remove (_tmp18_);
		}
		_tmp19_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ____lambda36__gsource_func, g_object_ref (self), g_object_unref);
		self->priv->m_emojier_focus_commit_text_id = _tmp19_;
		_g_main_context_unref0 (context);
	} else {
		gboolean _tmp20_;
		_tmp20_ = panel_binding_emojier_focus_commit_real (self);
		if (_tmp20_) {
			GMainContext* context = NULL;
			GMainContext* _tmp21_;
			GMainContext* _tmp22_;
			gboolean _tmp23_ = FALSE;
			guint _tmp24_;
			_tmp21_ = g_main_context_default ();
			_tmp22_ = _g_main_context_ref0 (_tmp21_);
			context = _tmp22_;
			_tmp24_ = self->priv->m_emojier_focus_commit_text_id;
			if (_tmp24_ > ((guint) 0)) {
				GMainContext* _tmp25_;
				guint _tmp26_;
				GSource* _tmp27_;
				_tmp25_ = context;
				_tmp26_ = self->priv->m_emojier_focus_commit_text_id;
				_tmp27_ = g_main_context_find_source_by_id (_tmp25_, _tmp26_);
				_tmp23_ = _tmp27_ != NULL;
			} else {
				_tmp23_ = FALSE;
			}
			if (_tmp23_) {
				guint _tmp28_;
				_tmp28_ = self->priv->m_emojier_focus_commit_text_id;
				g_source_remove (_tmp28_);
			}
			self->priv->m_emojier_focus_commit_text_id = (guint) -1;
			_g_main_context_unref0 (context);
		}
	}
	_g_free0 (prev_context_path);
	_g_free0 (selected_string);
}


static void panel_binding_real_focus_in (IBusPanelService* base, const gchar* input_context_path) {
	PanelBinding * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	self = (PanelBinding*) base;
	g_return_if_fail (input_context_path != NULL);
	_tmp0_ = input_context_path;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->m_current_context_path);
	self->priv->m_current_context_path = _tmp1_;
	_tmp2_ = input_context_path;
	_tmp3_ = g_str_has_suffix (_tmp2_, "InputContext_1");
	if (!_tmp3_) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = self->priv->m_current_context_path;
		_tmp5_ = g_strdup (_tmp4_);
		_g_free0 (self->priv->m_real_current_context_path);
		self->priv->m_real_current_context_path = _tmp5_;
		panel_binding_emojier_focus_commit (self);
	}
}


static void panel_binding_real_focus_out (IBusPanelService* base, const gchar* input_context_path) {
	PanelBinding * self;
	gchar* _tmp0_;
	self = (PanelBinding*) base;
	g_return_if_fail (input_context_path != NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (self->priv->m_current_context_path);
	self->priv->m_current_context_path = _tmp0_;
}


static void _vala_GdkEvent_free (GdkEvent* self) {
	g_boxed_free (gdk_event_get_type (), self);
}


static void panel_binding_real_panel_extension_received (IBusPanelService* base, GVariant* data) {
	PanelBinding * self;
	IBusXEvent* xevent = NULL;
	GVariant* _tmp0_;
	IBusSerializable* _tmp1_;
	IBusXEvent* _tmp2_;
	IBusXEvent* _tmp3_;
	IBusXEvent* _tmp4_;
	const gchar* _tmp5_;
	GdkEventType event_type = 0;
	IBusXEvent* _tmp12_;
	IBusXEventType _tmp13_;
	GdkEvent* event = NULL;
	GdkEventType _tmp20_;
	GdkEvent* _tmp21_;
	guint32 time = 0U;
	IBusXEvent* _tmp22_;
	guint32 _tmp23_;
	guint32 _tmp24_;
	GdkEvent* _tmp26_;
	GdkEventKey* _tmp27_;
	GdkEventKey* _tmp28_;
	guint32 _tmp29_;
	Window xid = 0;
	IBusXEvent* _tmp30_;
	guint32 _tmp31_;
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp32_;
	GdkDisplay* _tmp33_;
	GdkWindow* window = NULL;
	gboolean _tmp34_ = FALSE;
	GdkWindow* _tmp35_;
	gboolean _tmp41_ = FALSE;
	GdkWindow* _tmp42_;
	GdkWindow* _tmp47_;
	GdkEvent* _tmp51_;
	GdkEventKey* _tmp52_;
	GdkEventKey* _tmp53_;
	GdkWindow* _tmp54_;
	GdkEvent* _tmp55_;
	self = (PanelBinding*) base;
	g_return_if_fail (data != NULL);
	_tmp0_ = data;
	_tmp1_ = ibus_serializable_deserialize_object (_tmp0_);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, ibus_x_event_get_type ()) ? ((IBusXEvent*) _tmp1_) : NULL);
	xevent = _tmp2_;
	_tmp3_ = xevent;
	if (_tmp3_ == NULL) {
		g_warning ("panelbinding.vala:306: Failed to deserialize IBusXEvent");
		_g_object_unref0 (xevent);
		return;
	}
	_tmp4_ = xevent;
	_tmp5_ = ibus_x_event_get_purpose (_tmp4_);
	if (g_strcmp0 (_tmp5_, "emoji") != 0) {
		gchar* format = NULL;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		IBusXEvent* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp6_ = g_strdup ("The purpose %s is not implemented in PanelExtension");
		format = _tmp6_;
		_tmp7_ = format;
		_tmp8_ = xevent;
		_tmp9_ = ibus_x_event_get_purpose (_tmp8_);
		_tmp10_ = g_strdup_printf (_tmp7_, _tmp9_);
		_tmp11_ = _tmp10_;
		g_warning ("panelbinding.vala:311: %s", _tmp11_);
		_g_free0 (_tmp11_);
		_g_free0 (format);
		_g_object_unref0 (xevent);
		return;
	}
	_tmp12_ = xevent;
	_tmp13_ = ibus_x_event_get_event_type (_tmp12_);
	if (_tmp13_ == IBUS_X_EVENT_KEY_PRESS) {
		event_type = GDK_KEY_PRESS;
	} else {
		IBusXEvent* _tmp14_;
		IBusXEventType _tmp15_;
		_tmp14_ = xevent;
		_tmp15_ = ibus_x_event_get_event_type (_tmp14_);
		if (_tmp15_ == IBUS_X_EVENT_KEY_RELEASE) {
			event_type = GDK_KEY_RELEASE;
		} else {
			IBusXEvent* _tmp16_;
			IBusXEventType _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp16_ = xevent;
			_tmp17_ = ibus_x_event_get_event_type (_tmp16_);
			_tmp18_ = g_strdup_printf ("Not supported type %d", (gint) _tmp17_);
			_tmp19_ = _tmp18_;
			g_warning ("panelbinding.vala:320: %s", _tmp19_);
			_g_free0 (_tmp19_);
			_g_object_unref0 (xevent);
			return;
		}
	}
	_tmp20_ = event_type;
	_tmp21_ = gdk_event_new (_tmp20_);
	event = _tmp21_;
	_tmp22_ = xevent;
	_tmp23_ = ibus_x_event_get_time (_tmp22_);
	time = _tmp23_;
	_tmp24_ = time;
	if (_tmp24_ == ((guint32) 0)) {
		guint32 _tmp25_;
		_tmp25_ = gtk_get_current_event_time ();
		time = _tmp25_;
	}
	_tmp26_ = event;
	_tmp27_ = (GdkEventKey *) (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = time;
	_tmp28_->time = _tmp29_;
	_tmp30_ = xevent;
	_tmp31_ = ibus_x_event_get_window (_tmp30_);
	xid = (Window) _tmp31_;
	_tmp32_ = gdk_display_get_default ();
	_tmp33_ = _g_object_ref0 (_tmp32_);
	display = _tmp33_;
	window = NULL;
	_tmp35_ = window;
	if (_tmp35_ == NULL) {
		Window _tmp36_;
		_tmp36_ = xid;
		_tmp34_ = _tmp36_ != ((Window) 0);
	} else {
		_tmp34_ = FALSE;
	}
	if (_tmp34_) {
		GdkDisplay* _tmp37_;
		Window _tmp38_;
		GdkX11Window* _tmp39_;
		GdkWindow* _tmp40_;
		_tmp37_ = display;
		_tmp38_ = xid;
		_tmp39_ = gdk_x11_window_lookup_for_display (G_TYPE_CHECK_INSTANCE_TYPE (_tmp37_, gdk_x11_display_get_type ()) ? ((GdkX11Display*) _tmp37_) : NULL, _tmp38_);
		_tmp40_ = _g_object_ref0 ((GdkWindow*) _tmp39_);
		_g_object_unref0 (window);
		window = _tmp40_;
	}
	_tmp42_ = window;
	if (_tmp42_ == NULL) {
		Window _tmp43_;
		_tmp43_ = xid;
		_tmp41_ = _tmp43_ != ((Window) 0);
	} else {
		_tmp41_ = FALSE;
	}
	if (_tmp41_) {
		GdkDisplay* _tmp44_;
		Window _tmp45_;
		GdkX11Window* _tmp46_;
		_tmp44_ = display;
		_tmp45_ = xid;
		_tmp46_ = (GdkX11Window*) gdk_x11_window_foreign_new_for_display (G_TYPE_CHECK_INSTANCE_TYPE (_tmp44_, gdk_x11_display_get_type ()) ? ((GdkX11Display*) _tmp44_) : NULL, _tmp45_);
		_g_object_unref0 (window);
		window = (GdkWindow*) _tmp46_;
	}
	_tmp47_ = window;
	if (_tmp47_ == NULL) {
		GdkWindow* _tmp48_;
		GdkWindow* _tmp49_;
		GdkWindow* _tmp50_;
		_tmp48_ = gdk_get_default_root_window ();
		_tmp49_ = _g_object_ref0 (_tmp48_);
		_g_object_unref0 (window);
		window = _tmp49_;
		_tmp50_ = window;
		g_object_ref ((GObject*) _tmp50_);
	}
	_tmp51_ = event;
	_tmp52_ = (GdkEventKey *) (_tmp51_);
	_tmp53_ = _tmp52_;
	_tmp54_ = window;
	_tmp53_->window = _tmp54_;
	_tmp55_ = event;
	panel_binding_handle_emoji_typing (self, _tmp55_);
	_g_object_unref0 (window);
	_g_object_unref0 (display);
	__vala_GdkEvent_free0 (event);
	_g_object_unref0 (xevent);
}


static void panel_binding_class_init (PanelBindingClass * klass) {
	panel_binding_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PanelBindingPrivate));
	((IBusPanelServiceClass *) klass)->focus_in = (void (*) (IBusPanelService *, const gchar*)) panel_binding_real_focus_in;
	((IBusPanelServiceClass *) klass)->focus_out = (void (*) (IBusPanelService *, const gchar*)) panel_binding_real_focus_out;
	((IBusPanelServiceClass *) klass)->panel_extension_received = (void (*) (IBusPanelService *, GVariant*)) panel_binding_real_panel_extension_received;
	G_OBJECT_CLASS (klass)->finalize = panel_binding_finalize;
}


static void panel_binding_instance_init (PanelBinding * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	self->priv = PANEL_BINDING_GET_PRIVATE (self);
	self->priv->m_settings_panel = NULL;
	self->priv->m_settings_emoji = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->m_current_context_path = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->m_real_current_context_path = _tmp1_;
	_tmp2_ = g_new0 (gchar*, 0 + 1);
	self->priv->m_emojier_favorites = _tmp2_;
	self->priv->m_emojier_favorites_length1 = 0;
	self->priv->_m_emojier_favorites_size_ = self->priv->m_emojier_favorites_length1;
	self->priv->m_loaded_emoji = FALSE;
	self->priv->m_loaded_unicode = FALSE;
}


static void panel_binding_finalize (GObject * obj) {
	PanelBinding * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PANEL_BINDING, PanelBinding);
	_g_object_unref0 (self->priv->m_bus);
	_g_object_unref0 (self->priv->m_application);
	_g_object_unref0 (self->priv->m_settings_panel);
	_g_object_unref0 (self->priv->m_settings_emoji);
	_g_free0 (self->priv->m_current_context_path);
	_g_free0 (self->priv->m_real_current_context_path);
	_g_object_unref0 (self->priv->m_emojier);
	self->priv->m_emojier_favorites = (_vala_array_free (self->priv->m_emojier_favorites, self->priv->m_emojier_favorites_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->m_css_provider);
	G_OBJECT_CLASS (panel_binding_parent_class)->finalize (obj);
}


GType panel_binding_get_type (void) {
	static volatile gsize panel_binding_type_id__volatile = 0;
	if (g_once_init_enter (&panel_binding_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PanelBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) panel_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PanelBinding), 0, (GInstanceInitFunc) panel_binding_instance_init, NULL };
		GType panel_binding_type_id;
		panel_binding_type_id = g_type_register_static (ibus_panel_service_get_type (), "PanelBinding", &g_define_type_info, 0);
		g_once_init_leave (&panel_binding_type_id__volatile, panel_binding_type_id);
	}
	return panel_binding_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



