/* indicator.c generated by valac 0.38.2, the Vala compiler
 * generated from indicator.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2015-2017 Takao Fujiwara <takao.fujiwara1@gmail.com>
 * Copyright(c) 2015 Red Hat, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */
/* This class extends AppIndicator because
 * AppIndicator misses "Activate" dbus method in the definition
 * for left click on the indicator.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <ibus.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <gdk/gdkx.h>
#include <cairo.h>
#include <gtk/gtk.h>


#define TYPE_INDICATOR (indicator_get_type ())
#define INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INDICATOR, Indicator))
#define INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INDICATOR, IndicatorClass))
#define IS_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INDICATOR))
#define IS_INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INDICATOR))
#define INDICATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INDICATOR, IndicatorClass))

typedef struct _Indicator Indicator;
typedef struct _IndicatorClass IndicatorClass;
typedef struct _IndicatorPrivate IndicatorPrivate;
enum  {
	INDICATOR_DUMMY_PROPERTY,
	INDICATOR_ID_PROPERTY,
	INDICATOR_CATEGORY_S_PROPERTY,
	INDICATOR_STATUS_S_PROPERTY,
	INDICATOR_ICON_NAME_PROPERTY,
	INDICATOR_ICON_DESC_PROPERTY,
	INDICATOR_ATTENTION_ICON_NAME_PROPERTY,
	INDICATOR_ATTENTION_ICON_DESC_PROPERTY,
	INDICATOR_TITLE_PROPERTY,
	INDICATOR_ICON_THEME_PATH_PROPERTY,
	INDICATOR_CONNECTED_PROPERTY,
	INDICATOR_LABEL_S_PROPERTY,
	INDICATOR_LABEL_GUIDE_S_PROPERTY,
	INDICATOR_ORDERING_INDEX_PROPERTY,
	INDICATOR_ICON_VECTOR_PROPERTY,
	INDICATOR_LAST_PROPERTY
};
static GParamSpec* indicator_properties[INDICATOR_LAST_PROPERTY];

#define INDICATOR_TYPE_CATEGORY (indicator_category_get_type ())

#define INDICATOR_TYPE_STATUS (indicator_status_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_dbus_node_info_unref0(var) ((var == NULL) ? NULL : (var = (g_dbus_node_info_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
enum  {
	INDICATOR_CONTEXT_MENU_SIGNAL,
	INDICATOR_ACTIVATE_SIGNAL,
	INDICATOR_REGISTERED_STATUS_NOTIFIER_ITEM_SIGNAL,
	INDICATOR_LAST_SIGNAL
};
static guint indicator_signals[INDICATOR_LAST_SIGNAL] = {0};

struct _Indicator {
	IBusService parent_instance;
	IndicatorPrivate * priv;
};

struct _IndicatorClass {
	IBusServiceClass parent_class;
};

struct _IndicatorPrivate {
	gchar* _id;
	gchar* _category_s;
	gchar* _status_s;
	gchar* _icon_name;
	gchar* _icon_desc;
	gchar* _attention_icon_name;
	gchar* _attention_icon_desc;
	gchar* _title;
	gchar* _icon_theme_path;
	gboolean _connected;
	gchar* _label_s;
	gchar* _label_guide_s;
	guint32 _ordering_index;
	GVariant* _icon_vector;
	GDBusNodeInfo* m_watcher_node_info;
	GDBusInterfaceInfo* m_watcher_interface_info;
	GDBusProxy* m_proxy;
	gint m_context_menu_x;
	gint m_context_menu_y;
	gint m_activate_menu_x;
	gint m_activate_menu_y;
	GdkWindow* m_indicator_window;
};

typedef enum  {
	INDICATOR_CATEGORY_APPLICATION_STATUS,
	INDICATOR_CATEGORY_COMMUNICATIONS,
	INDICATOR_CATEGORY_SYSTEM_SERVICES,
	INDICATOR_CATEGORY_HARDWARE,
	INDICATOR_CATEGORY_OTHER
} IndicatorCategory;

typedef enum  {
	INDICATOR_STATUS_PASSIVE,
	INDICATOR_STATUS_ACTIVE,
	INDICATOR_STATUS_ATTENTION
} IndicatorStatus;


extern gchar* _notification_item;
extern gchar* _notification_watcher;
static gpointer indicator_parent_class = NULL;

GType indicator_get_type (void) G_GNUC_CONST;
#define INDICATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_INDICATOR, IndicatorPrivate))
GType indicator_category_get_type (void) G_GNUC_CONST;
gchar* indicator_category_to_nick (IndicatorCategory self);
GType indicator_status_get_type (void) G_GNUC_CONST;
gchar* indicator_status_to_nick (IndicatorStatus self);
#define INDICATOR_DEFAULT_ITEM_PATH "/org/ayatana/NotificationItem"
#define INDICATOR_NOTIFICATION_ITEM_DBUS_IFACE "org.kde.StatusNotifierItem"
#define INDICATOR_NOTIFICATION_WATCHER_DBUS_IFACE "org.kde.StatusNotifierWatcher"
#define INDICATOR_NOTIFICATION_WATCHER_DBUS_ADDR "org.kde.StatusNotifierWatcher"
#define INDICATOR_NOTIFICATION_WATCHER_DBUS_OBJ "/StatusNotifierWatcher"
Indicator* indicator_new (const gchar* id, GDBusConnection* connection, IndicatorCategory category);
Indicator* indicator_construct (GType object_type, const gchar* id, GDBusConnection* connection, IndicatorCategory category);
void indicator_set_status_s (Indicator* self, const gchar* value);
void indicator_set_icon_name (Indicator* self, const gchar* value);
void indicator_set_icon_desc (Indicator* self, const gchar* value);
void indicator_set_title (Indicator* self, const gchar* value);
void indicator_set_icon_theme_path (Indicator* self, const gchar* value);
void indicator_set_attention_icon_name (Indicator* self, const gchar* value);
void indicator_set_attention_icon_desc (Indicator* self, const gchar* value);
void indicator_set_label_s (Indicator* self, const gchar* value);
void indicator_set_label_guide_s (Indicator* self, const gchar* value);
static void indicator_check_connect (Indicator* self);
static void ___lambda4_ (Indicator* self, GObject* obj, GAsyncResult* res);
static void indicator_bus_watcher_ready (Indicator* self, GObject* obj, GAsyncResult* res);
static void ____lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void ___lambda5_ (Indicator* self, GObject* obj, GParamSpec* pspec);
static void ____lambda5__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda6_ (Indicator* self, GObject* p_obj, GAsyncResult* p_res);
static void ___lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _indicator_context_menu_cb (Indicator* self, GDBusConnection* connection, GVariant* parameters, GDBusMethodInvocation* invocation);
static GdkWindow* indicator_query_gdk_window (Indicator* self);
static void _indicator_activate_menu_cb (Indicator* self, GDBusConnection* connection, GVariant* parameters, GDBusMethodInvocation* invocation);
static GVariant* _indicator_get_id (Indicator* self, GDBusConnection* connection);
const gchar* indicator_get_id (Indicator* self);
static GVariant* _indicator_get_category (Indicator* self, GDBusConnection* connection);
const gchar* indicator_get_category_s (Indicator* self);
static GVariant* _indicator_get_status (Indicator* self, GDBusConnection* connection);
const gchar* indicator_get_status_s (Indicator* self);
static GVariant* _indicator_get_icon_name (Indicator* self, GDBusConnection* connection);
const gchar* indicator_get_icon_name (Indicator* self);
static GVariant* _indicator_get_icon_vector (Indicator* self, GDBusConnection* connection);
GVariant* indicator_get_icon_vector (Indicator* self);
static GVariant* _indicator_get_icon_desc (Indicator* self, GDBusConnection* connection);
const gchar* indicator_get_icon_desc (Indicator* self);
static GVariant* _indicator_get_attention_icon_name (Indicator* self, GDBusConnection* connection);
const gchar* indicator_get_attention_icon_name (Indicator* self);
static GVariant* _indicator_get_attention_icon_desc (Indicator* self, GDBusConnection* connection);
const gchar* indicator_get_attention_icon_desc (Indicator* self);
static GVariant* _indicator_get_title (Indicator* self, GDBusConnection* connection);
const gchar* indicator_get_title (Indicator* self);
static GVariant* _indicator_get_icon_theme_path (Indicator* self, GDBusConnection* connection);
const gchar* indicator_get_icon_theme_path (Indicator* self);
static GVariant* _indicator_get_menu (Indicator* self, GDBusConnection* connection);
static GVariant* _indicator_get_xayatana_label (Indicator* self, GDBusConnection* connection);
const gchar* indicator_get_label_s (Indicator* self);
static GVariant* _indicator_get_xayatana_label_guide (Indicator* self, GDBusConnection* connection);
const gchar* indicator_get_label_guide_s (Indicator* self);
static GVariant* _indicator_get_xayatana_ordering_index (Indicator* self, GDBusConnection* connection);
guint32 indicator_get_ordering_index (Indicator* self);
static void indicator_real_service_method_call (IBusService* base, GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation);
static GVariant* indicator_real_service_get_property (IBusService* base, GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error);
static gboolean indicator_real_service_set_property (IBusService* base, GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error);
void indicator_set_status (Indicator* self, IndicatorStatus status);
void indicator_set_icon_full (Indicator* self, const gchar* icon_name, const gchar* icon_desc);
void indicator_set_icon_vector (Indicator* self, GVariant* value);
void indicator_set_cairo_image_surface_full (Indicator* self, cairo_surface_t* image, const gchar* icon_desc);
void indicator_position_context_menu (Indicator* self, GtkMenu* menu, gint* x, gint* y, gboolean* push_in);
void indicator_position_activate_menu (Indicator* self, GtkMenu* menu, gint* x, gint* y, gboolean* push_in);
void indicator_unregister_connection (Indicator* self);
static void indicator_set_id (Indicator* self, const gchar* value);
static void indicator_set_category_s (Indicator* self, const gchar* value);
gboolean indicator_get_connected (Indicator* self);
void indicator_set_connected (Indicator* self, gboolean value);
void indicator_set_ordering_index (Indicator* self, guint32 value);
static void g_cclosure_user_marshal_VOID__INT_INT_OBJECT_UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__INT_INT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void indicator_finalize (GObject * obj);
static void _vala_indicator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_indicator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


gchar* indicator_category_to_nick (IndicatorCategory self) {
	gchar* result = NULL;
	switch (self) {
		case INDICATOR_CATEGORY_APPLICATION_STATUS:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("ApplicationStatus");
			result = _tmp0_;
			return result;
		}
		case INDICATOR_CATEGORY_COMMUNICATIONS:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("Communications");
			result = _tmp1_;
			return result;
		}
		case INDICATOR_CATEGORY_SYSTEM_SERVICES:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("SystemServices");
			result = _tmp2_;
			return result;
		}
		case INDICATOR_CATEGORY_HARDWARE:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("Hardware");
			result = _tmp3_;
			return result;
		}
		case INDICATOR_CATEGORY_OTHER:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("Other");
			result = _tmp4_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


GType indicator_category_get_type (void) {
	static volatile gsize indicator_category_type_id__volatile = 0;
	if (g_once_init_enter (&indicator_category_type_id__volatile)) {
		static const GEnumValue values[] = {{INDICATOR_CATEGORY_APPLICATION_STATUS, "INDICATOR_CATEGORY_APPLICATION_STATUS", "application-status"}, {INDICATOR_CATEGORY_COMMUNICATIONS, "INDICATOR_CATEGORY_COMMUNICATIONS", "communications"}, {INDICATOR_CATEGORY_SYSTEM_SERVICES, "INDICATOR_CATEGORY_SYSTEM_SERVICES", "system-services"}, {INDICATOR_CATEGORY_HARDWARE, "INDICATOR_CATEGORY_HARDWARE", "hardware"}, {INDICATOR_CATEGORY_OTHER, "INDICATOR_CATEGORY_OTHER", "other"}, {0, NULL, NULL}};
		GType indicator_category_type_id;
		indicator_category_type_id = g_enum_register_static ("IndicatorCategory", values);
		g_once_init_leave (&indicator_category_type_id__volatile, indicator_category_type_id);
	}
	return indicator_category_type_id__volatile;
}


gchar* indicator_status_to_nick (IndicatorStatus self) {
	gchar* result = NULL;
	switch (self) {
		case INDICATOR_STATUS_PASSIVE:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("Passive");
			result = _tmp0_;
			return result;
		}
		case INDICATOR_STATUS_ACTIVE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("Active");
			result = _tmp1_;
			return result;
		}
		case INDICATOR_STATUS_ATTENTION:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("NeedsAttention");
			result = _tmp2_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


GType indicator_status_get_type (void) {
	static volatile gsize indicator_status_type_id__volatile = 0;
	if (g_once_init_enter (&indicator_status_type_id__volatile)) {
		static const GEnumValue values[] = {{INDICATOR_STATUS_PASSIVE, "INDICATOR_STATUS_PASSIVE", "passive"}, {INDICATOR_STATUS_ACTIVE, "INDICATOR_STATUS_ACTIVE", "active"}, {INDICATOR_STATUS_ATTENTION, "INDICATOR_STATUS_ATTENTION", "attention"}, {0, NULL, NULL}};
		GType indicator_status_type_id;
		indicator_status_type_id = g_enum_register_static ("IndicatorStatus", values);
		g_once_init_leave (&indicator_status_type_id__volatile, indicator_status_type_id);
	}
	return indicator_status_type_id__volatile;
}


static gchar* string_delimit (const gchar* self, const gchar* delimiters, gchar new_delimiter) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (delimiters != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	_tmp2_ = delimiters;
	_tmp3_ = new_delimiter;
	g_strdelimit (_tmp1_, _tmp2_, _tmp3_);
	result = _result_;
	return result;
}


Indicator* indicator_construct (GType object_type, const gchar* id, GDBusConnection* connection, IndicatorCategory category) {
	Indicator * self = NULL;
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GDBusConnection* _tmp6_;
	IndicatorCategory _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GDBusConnection* _tmp12_;
	const gchar* _tmp13_;
	GDBusNodeInfo* _tmp29_;
	GDBusInterfaceInfo* _tmp30_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (connection != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = g_strconcat (INDICATOR_DEFAULT_ITEM_PATH "/", _tmp0_, NULL);
	path = _tmp1_;
	_tmp2_ = path;
	_tmp3_ = string_delimit (_tmp2_, "-", '_');
	_g_free0 (path);
	path = _tmp3_;
	_tmp4_ = path;
	_tmp5_ = id;
	_tmp6_ = connection;
	_tmp7_ = category;
	_tmp8_ = indicator_category_to_nick (_tmp7_);
	_tmp9_ = _tmp8_;
	self = (Indicator*) g_object_new (object_type, "object-path", _tmp4_, "id", _tmp5_, "connection", _tmp6_, "category-s", _tmp9_, NULL);
	_g_free0 (_tmp9_);
	_tmp10_ = indicator_status_to_nick (INDICATOR_STATUS_PASSIVE);
	_tmp11_ = _tmp10_;
	indicator_set_status_s (self, _tmp11_);
	_g_free0 (_tmp11_);
	indicator_set_icon_name (self, "");
	indicator_set_icon_desc (self, "");
	indicator_set_title (self, "");
	indicator_set_icon_theme_path (self, "");
	indicator_set_attention_icon_name (self, "");
	indicator_set_attention_icon_desc (self, "");
	indicator_set_label_s (self, "");
	indicator_set_label_guide_s (self, "");
	_tmp12_ = connection;
	ibus_service_unregister ((IBusService*) self, _tmp12_);
	_tmp13_ = _notification_item;
	ibus_service_class_add_interfaces (IBUS_SERVICE_CLASS (G_OBJECT_GET_CLASS (self)), _tmp13_);
	{
		gboolean _tmp14_ = FALSE;
		GDBusConnection* _tmp15_;
		gboolean _tmp16_;
		_tmp15_ = connection;
		_tmp16_ = ibus_service_register ((IBusService*) self, _tmp15_, &_inner_error_);
		_tmp14_ = _tmp16_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
		if (!_tmp14_) {
			_g_free0 (path);
			return self;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		_tmp19_ = g_strconcat ("Failed to register the application indicator xml: ", _tmp18_, NULL);
		_tmp20_ = _tmp19_;
		g_warning ("indicator.vala:129: %s", _tmp20_);
		_g_free0 (_tmp20_);
		_g_error_free0 (e);
		_g_free0 (path);
		return self;
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		GDBusNodeInfo* _tmp21_ = NULL;
		const gchar* _tmp22_;
		GDBusNodeInfo* _tmp23_;
		GDBusNodeInfo* _tmp24_;
		_tmp22_ = _notification_watcher;
		_tmp23_ = g_dbus_node_info_new_for_xml (_tmp22_, &_inner_error_);
		_tmp21_ = _tmp23_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch6_g_error;
		}
		_tmp24_ = _tmp21_;
		_tmp21_ = NULL;
		_g_dbus_node_info_unref0 (self->priv->m_watcher_node_info);
		self->priv->m_watcher_node_info = _tmp24_;
		_g_dbus_node_info_unref0 (_tmp21_);
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		GError* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp25_ = e;
		_tmp26_ = _tmp25_->message;
		_tmp27_ = g_strconcat ("Failed to create dbus node info: ", _tmp26_, NULL);
		_tmp28_ = _tmp27_;
		g_warning ("indicator.vala:138: %s", _tmp28_);
		_g_free0 (_tmp28_);
		_g_error_free0 (e);
		_g_free0 (path);
		return self;
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp29_ = self->priv->m_watcher_node_info;
	_tmp30_ = g_dbus_node_info_lookup_interface (_tmp29_, INDICATOR_NOTIFICATION_WATCHER_DBUS_IFACE);
	self->priv->m_watcher_interface_info = _tmp30_;
	indicator_check_connect (self);
	_g_free0 (path);
	return self;
}


Indicator* indicator_new (const gchar* id, GDBusConnection* connection, IndicatorCategory category) {
	return indicator_construct (TYPE_INDICATOR, id, connection, category);
}


static void ___lambda4_ (Indicator* self, GObject* obj, GAsyncResult* res) {
	GObject* _tmp0_;
	GAsyncResult* _tmp1_;
	g_return_if_fail (res != NULL);
	_tmp0_ = obj;
	_tmp1_ = res;
	indicator_bus_watcher_ready (self, _tmp0_, _tmp1_);
}


static void ____lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda4_ ((Indicator*) self, source_object, res);
	g_object_unref (self);
}


static void indicator_check_connect (Indicator* self) {
	GDBusProxy* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_proxy;
	if (_tmp0_ == NULL) {
		GDBusConnection* _tmp1_;
		GDBusConnection* _tmp2_;
		GDBusInterfaceInfo* _tmp3_;
		_tmp1_ = ibus_service_get_connection ((IBusService*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = self->priv->m_watcher_interface_info;
		g_dbus_proxy_new (_tmp2_, G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES | G_DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS, _tmp3_, INDICATOR_NOTIFICATION_WATCHER_DBUS_ADDR, INDICATOR_NOTIFICATION_WATCHER_DBUS_OBJ, INDICATOR_NOTIFICATION_WATCHER_DBUS_IFACE, NULL, ____lambda4__gasync_ready_callback, g_object_ref (self));
	} else {
		indicator_bus_watcher_ready (self, NULL, NULL);
	}
}


static void ___lambda5_ (Indicator* self, GObject* obj, GParamSpec* pspec) {
	gchar* name = NULL;
	GDBusProxy* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->m_proxy;
	_tmp1_ = g_dbus_proxy_get_name_owner (_tmp0_);
	name = _tmp1_;
	_tmp2_ = name;
	if (_tmp2_ != NULL) {
		indicator_check_connect (self);
	}
	_g_free0 (name);
}


static void ____lambda5__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	___lambda5_ ((Indicator*) self, _sender, pspec);
}


static void __lambda6_ (Indicator* self, GObject* p_obj, GAsyncResult* p_res) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (p_res != NULL);
	{
		GDBusProxy* _tmp0_;
		GAsyncResult* _tmp1_;
		GVariant* _tmp2_;
		GVariant* _tmp3_;
		_tmp0_ = self->priv->m_proxy;
		_tmp1_ = p_res;
		_tmp2_ = g_dbus_proxy_call_finish (_tmp0_, _tmp1_, &_inner_error_);
		_tmp3_ = _tmp2_;
		_g_variant_unref0 (_tmp3_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch8_g_error;
		}
		g_signal_emit (self, indicator_signals[INDICATOR_REGISTERED_STATUS_NOTIFIER_ITEM_SIGNAL], 0);
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		_tmp6_ = g_strconcat ("Failed to call " "RegisterStatusNotifierItem: ", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		g_warning ("indicator.vala:199: %s", _tmp7_);
		_g_free0 (_tmp7_);
		_g_error_free0 (e);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda6_ ((Indicator*) self, source_object, res);
	g_object_unref (self);
}


static void indicator_bus_watcher_ready (Indicator* self, GObject* obj, GAsyncResult* res) {
	GAsyncResult* _tmp0_;
	gchar* name = NULL;
	GDBusProxy* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	GDBusProxy* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	GVariant* _tmp16_;
	GVariant* _tmp17_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = res;
	if (_tmp0_ != NULL) {
		GDBusProxy* _tmp9_;
		{
			GDBusProxy* _tmp1_ = NULL;
			GAsyncResult* _tmp2_;
			GDBusProxy* _tmp3_;
			GDBusProxy* _tmp4_;
			_tmp2_ = res;
			_tmp3_ = g_dbus_proxy_new_finish (_tmp2_, &_inner_error_);
			_tmp1_ = _tmp3_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_IO_ERROR) {
					goto __catch7_g_io_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp4_ = _tmp1_;
			_tmp1_ = NULL;
			_g_object_unref0 (self->priv->m_proxy);
			self->priv->m_proxy = _tmp4_;
			_g_object_unref0 (_tmp1_);
		}
		goto __finally7;
		__catch7_g_io_error:
		{
			GError* e = NULL;
			GError* _tmp5_;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp5_ = e;
			_tmp6_ = _tmp5_->message;
			_tmp7_ = g_strconcat ("Failed to call dbus proxy: ", _tmp6_, NULL);
			_tmp8_ = _tmp7_;
			g_warning ("indicator.vala:173: %s", _tmp8_);
			_g_free0 (_tmp8_);
			_g_error_free0 (e);
			return;
		}
		__finally7:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp9_ = self->priv->m_proxy;
		g_signal_connect_object ((GObject*) _tmp9_, "notify::g-name-owner", (GCallback) ____lambda5__g_object_notify, self, 0);
	}
	_tmp10_ = self->priv->m_proxy;
	_tmp11_ = g_dbus_proxy_get_name_owner (_tmp10_);
	name = _tmp11_;
	_tmp12_ = name;
	if (_tmp12_ == NULL) {
		_g_free0 (name);
		return;
	}
	_tmp13_ = self->priv->m_proxy;
	_tmp14_ = ibus_service_get_object_path ((IBusService*) self);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_variant_new ("(s)", _tmp15_, NULL);
	g_variant_ref_sink (_tmp16_);
	_tmp17_ = _tmp16_;
	g_dbus_proxy_call (_tmp13_, "RegisterStatusNotifierItem", _tmp17_, G_DBUS_CALL_FLAGS_NONE, -1, NULL, ___lambda6__gasync_ready_callback, g_object_ref (self));
	_g_variant_unref0 (_tmp17_);
	_g_free0 (name);
}


static void _indicator_context_menu_cb (Indicator* self, GDBusConnection* connection, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariant* var_x = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* var_y = NULL;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	gint32 _tmp4_;
	gint32 _tmp5_;
	GdkWindow* window = NULL;
	GdkWindow* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (parameters != NULL);
	g_return_if_fail (invocation != NULL);
	_tmp0_ = parameters;
	_tmp1_ = g_variant_get_child_value (_tmp0_, (gsize) 0);
	var_x = _tmp1_;
	_tmp2_ = parameters;
	_tmp3_ = g_variant_get_child_value (_tmp2_, (gsize) 1);
	var_y = _tmp3_;
	_tmp4_ = g_variant_get_int32 (var_x);
	self->priv->m_context_menu_x = (gint) _tmp4_;
	_tmp5_ = g_variant_get_int32 (var_y);
	self->priv->m_context_menu_y = (gint) _tmp5_;
	_tmp6_ = indicator_query_gdk_window (self);
	window = _tmp6_;
	_tmp7_ = self->priv->m_context_menu_x;
	_tmp8_ = self->priv->m_context_menu_y;
	g_signal_emit (self, indicator_signals[INDICATOR_CONTEXT_MENU_SIGNAL], 0, _tmp7_, _tmp8_, window, (guint) 2, (guint) 0);
	_g_object_unref0 (window);
	_g_variant_unref0 (var_y);
	_g_variant_unref0 (var_x);
}


static void _indicator_activate_menu_cb (Indicator* self, GDBusConnection* connection, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariant* var_x = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* var_y = NULL;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	gint32 _tmp4_;
	gint32 _tmp5_;
	GdkWindow* window = NULL;
	GdkWindow* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (parameters != NULL);
	g_return_if_fail (invocation != NULL);
	_tmp0_ = parameters;
	_tmp1_ = g_variant_get_child_value (_tmp0_, (gsize) 0);
	var_x = _tmp1_;
	_tmp2_ = parameters;
	_tmp3_ = g_variant_get_child_value (_tmp2_, (gsize) 1);
	var_y = _tmp3_;
	_tmp4_ = g_variant_get_int32 (var_x);
	self->priv->m_activate_menu_x = (gint) _tmp4_;
	_tmp5_ = g_variant_get_int32 (var_y);
	self->priv->m_activate_menu_y = (gint) _tmp5_;
	_tmp6_ = indicator_query_gdk_window (self);
	window = _tmp6_;
	_tmp7_ = self->priv->m_activate_menu_x;
	_tmp8_ = self->priv->m_activate_menu_y;
	g_signal_emit (self, indicator_signals[INDICATOR_ACTIVATE_SIGNAL], 0, _tmp7_, _tmp8_, window);
	_g_object_unref0 (window);
	_g_variant_unref0 (var_y);
	_g_variant_unref0 (var_x);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GdkWindow* indicator_query_gdk_window (Indicator* self) {
	GdkWindow* result = NULL;
	GdkWindow* _tmp0_;
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp3_;
	GdkDisplay* _tmp4_;
	Display* xdisplay = NULL;
	GdkDisplay* _tmp5_;
	Display* _tmp6_;
	Window current = 0;
	Display* _tmp7_;
	Window _tmp8_;
	Window parent = 0;
	Window child = 0;
	gint root_x = 0;
	gint root_y = 0;
	gint win_x = 0;
	gint win_y = 0;
	guint mask = 0U;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gboolean retval = FALSE;
	gboolean _tmp25_;
	Window _tmp39_;
	Display* _tmp40_;
	Window _tmp41_;
	GdkDisplay* _tmp42_;
	Window _tmp43_;
	GdkX11Window* _tmp44_;
	GdkWindow* _tmp45_;
	GdkWindow* _tmp46_;
	GdkDisplay* _tmp49_;
	Window _tmp50_;
	GdkX11Window* _tmp51_;
	GdkWindow* _tmp52_;
	GdkWindow* _tmp53_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_indicator_window;
	if (_tmp0_ != NULL) {
		GdkWindow* _tmp1_;
		GdkWindow* _tmp2_;
		_tmp1_ = self->priv->m_indicator_window;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = gdk_display_get_default ();
	_tmp4_ = _g_object_ref0 (_tmp3_);
	display = _tmp4_;
	_tmp5_ = display;
	_tmp6_ = gdk_x11_display_get_xdisplay (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, gdk_x11_display_get_type ()) ? ((GdkX11Display*) _tmp5_) : NULL);
	xdisplay = _tmp6_;
	_tmp7_ = xdisplay;
	_tmp8_ = DefaultRootWindow (_tmp7_);
	current = _tmp8_;
	parent = (Window) 0;
	child = (Window) 0;
	mask = (guint) 0;
	win_y = 0;
	_tmp9_ = win_y;
	win_x = _tmp9_;
	_tmp10_ = win_x;
	root_y = _tmp10_;
	_tmp11_ = root_y;
	root_x = _tmp11_;
	while (TRUE) {
		Display* _tmp12_;
		Window _tmp13_;
		Window _tmp14_ = 0;
		Window _tmp15_ = 0;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		guint _tmp20_ = 0U;
		gboolean _tmp21_;
		gboolean _tmp22_;
		Window _tmp23_;
		Window _tmp24_;
		_tmp12_ = xdisplay;
		_tmp13_ = current;
		_tmp21_ = XQueryPointer (_tmp12_, _tmp13_, &_tmp14_, &_tmp15_, &_tmp16_, &_tmp17_, &_tmp18_, &_tmp19_, &_tmp20_);
		parent = _tmp14_;
		child = _tmp15_;
		root_x = _tmp16_;
		root_y = _tmp17_;
		win_x = _tmp18_;
		win_y = _tmp19_;
		mask = _tmp20_;
		retval = _tmp21_;
		_tmp22_ = retval;
		if (!_tmp22_) {
			break;
		}
		_tmp23_ = child;
		if (_tmp23_ == ((Window) 0)) {
			break;
		}
		_tmp24_ = child;
		current = _tmp24_;
	}
	_tmp25_ = retval;
	if (!_tmp25_) {
		gchar* format = NULL;
		gchar* _tmp26_;
		gchar* message = NULL;
		const gchar* _tmp27_;
		Window _tmp28_;
		Display* _tmp29_;
		Window _tmp30_;
		Window _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		guint _tmp36_;
		gchar* _tmp37_;
		const gchar* _tmp38_;
		_tmp26_ = g_strdup ("XQueryPointer is failed: current: %x root: %x " "child: %x (%d, %d), (%d, %d), %u");
		format = _tmp26_;
		_tmp27_ = format;
		_tmp28_ = current;
		_tmp29_ = xdisplay;
		_tmp30_ = DefaultRootWindow (_tmp29_);
		_tmp31_ = child;
		_tmp32_ = root_x;
		_tmp33_ = root_y;
		_tmp34_ = win_x;
		_tmp35_ = win_y;
		_tmp36_ = mask;
		_tmp37_ = g_strdup_printf (_tmp27_, (guint) _tmp28_, (guint) _tmp30_, (guint) _tmp31_, _tmp32_, _tmp33_, _tmp34_, _tmp35_, _tmp36_);
		message = _tmp37_;
		_tmp38_ = message;
		g_warning ("indicator.vala:264: XQueryPointer is failed: %s", _tmp38_);
		result = NULL;
		_g_free0 (message);
		_g_free0 (format);
		_g_object_unref0 (display);
		return result;
	}
	_tmp39_ = current;
	_tmp40_ = xdisplay;
	_tmp41_ = DefaultRootWindow (_tmp40_);
	if (_tmp39_ == _tmp41_) {
		g_warning ("indicator.vala:268: The query window is root window");
	}
	_tmp42_ = display;
	_tmp43_ = current;
	_tmp44_ = gdk_x11_window_lookup_for_display (G_TYPE_CHECK_INSTANCE_TYPE (_tmp42_, gdk_x11_display_get_type ()) ? ((GdkX11Display*) _tmp42_) : NULL, _tmp43_);
	_tmp45_ = _g_object_ref0 ((GdkWindow*) _tmp44_);
	_g_object_unref0 (self->priv->m_indicator_window);
	self->priv->m_indicator_window = _tmp45_;
	_tmp46_ = self->priv->m_indicator_window;
	if (_tmp46_ != NULL) {
		GdkWindow* _tmp47_;
		GdkWindow* _tmp48_;
		_tmp47_ = self->priv->m_indicator_window;
		_tmp48_ = _g_object_ref0 (_tmp47_);
		result = _tmp48_;
		_g_object_unref0 (display);
		return result;
	}
	_tmp49_ = display;
	_tmp50_ = current;
	_tmp51_ = (GdkX11Window*) gdk_x11_window_foreign_new_for_display (G_TYPE_CHECK_INSTANCE_TYPE (_tmp49_, gdk_x11_display_get_type ()) ? ((GdkX11Display*) _tmp49_) : NULL, _tmp50_);
	_g_object_unref0 (self->priv->m_indicator_window);
	self->priv->m_indicator_window = (GdkWindow*) _tmp51_;
	_tmp52_ = self->priv->m_indicator_window;
	_tmp53_ = _g_object_ref0 (_tmp52_);
	result = _tmp53_;
	_g_object_unref0 (display);
	return result;
}


static GVariant* _indicator_get_id (Indicator* self, GDBusConnection* connection) {
	GVariant* result = NULL;
	const gchar* _tmp0_;
	GVariant* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (connection != NULL, NULL);
	_tmp0_ = self->priv->_id;
	_tmp1_ = g_variant_new_string (_tmp0_);
	g_variant_ref_sink (_tmp1_);
	result = _tmp1_;
	return result;
}


static GVariant* _indicator_get_category (Indicator* self, GDBusConnection* connection) {
	GVariant* result = NULL;
	const gchar* _tmp0_;
	GVariant* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (connection != NULL, NULL);
	_tmp0_ = self->priv->_category_s;
	_tmp1_ = g_variant_new_string (_tmp0_);
	g_variant_ref_sink (_tmp1_);
	result = _tmp1_;
	return result;
}


static GVariant* _indicator_get_status (Indicator* self, GDBusConnection* connection) {
	GVariant* result = NULL;
	const gchar* _tmp0_;
	GVariant* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (connection != NULL, NULL);
	_tmp0_ = self->priv->_status_s;
	_tmp1_ = g_variant_new_string (_tmp0_);
	g_variant_ref_sink (_tmp1_);
	result = _tmp1_;
	return result;
}


static GVariant* _indicator_get_icon_name (Indicator* self, GDBusConnection* connection) {
	GVariant* result = NULL;
	const gchar* _tmp0_;
	GVariant* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (connection != NULL, NULL);
	_tmp0_ = self->priv->_icon_name;
	_tmp1_ = g_variant_new_string (_tmp0_);
	g_variant_ref_sink (_tmp1_);
	result = _tmp1_;
	return result;
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static GVariant* _indicator_get_icon_vector (Indicator* self, GDBusConnection* connection) {
	GVariant* result = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (connection != NULL, NULL);
	_tmp0_ = self->priv->_icon_vector;
	_tmp1_ = _g_variant_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static GVariant* _indicator_get_icon_desc (Indicator* self, GDBusConnection* connection) {
	GVariant* result = NULL;
	const gchar* _tmp0_;
	GVariant* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (connection != NULL, NULL);
	_tmp0_ = self->priv->_icon_desc;
	_tmp1_ = g_variant_new_string (_tmp0_);
	g_variant_ref_sink (_tmp1_);
	result = _tmp1_;
	return result;
}


static GVariant* _indicator_get_attention_icon_name (Indicator* self, GDBusConnection* connection) {
	GVariant* result = NULL;
	const gchar* _tmp0_;
	GVariant* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (connection != NULL, NULL);
	_tmp0_ = self->priv->_attention_icon_name;
	_tmp1_ = g_variant_new_string (_tmp0_);
	g_variant_ref_sink (_tmp1_);
	result = _tmp1_;
	return result;
}


static GVariant* _indicator_get_attention_icon_desc (Indicator* self, GDBusConnection* connection) {
	GVariant* result = NULL;
	const gchar* _tmp0_;
	GVariant* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (connection != NULL, NULL);
	_tmp0_ = self->priv->_attention_icon_desc;
	_tmp1_ = g_variant_new_string (_tmp0_);
	g_variant_ref_sink (_tmp1_);
	result = _tmp1_;
	return result;
}


static GVariant* _indicator_get_title (Indicator* self, GDBusConnection* connection) {
	GVariant* result = NULL;
	const gchar* _tmp0_;
	GVariant* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (connection != NULL, NULL);
	_tmp0_ = self->priv->_title;
	_tmp1_ = g_variant_new_string (_tmp0_);
	g_variant_ref_sink (_tmp1_);
	result = _tmp1_;
	return result;
}


static GVariant* _indicator_get_icon_theme_path (Indicator* self, GDBusConnection* connection) {
	GVariant* result = NULL;
	const gchar* _tmp0_;
	GVariant* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (connection != NULL, NULL);
	_tmp0_ = self->priv->_icon_theme_path;
	_tmp1_ = g_variant_new_string (_tmp0_);
	g_variant_ref_sink (_tmp1_);
	result = _tmp1_;
	return result;
}


static GVariant* _indicator_get_menu (Indicator* self, GDBusConnection* connection) {
	GVariant* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (connection != NULL, NULL);
	result = NULL;
	return result;
}


static GVariant* _indicator_get_xayatana_label (Indicator* self, GDBusConnection* connection) {
	GVariant* result = NULL;
	const gchar* _tmp0_;
	GVariant* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (connection != NULL, NULL);
	_tmp0_ = self->priv->_label_s;
	_tmp1_ = g_variant_new_string (_tmp0_);
	g_variant_ref_sink (_tmp1_);
	result = _tmp1_;
	return result;
}


static GVariant* _indicator_get_xayatana_label_guide (Indicator* self, GDBusConnection* connection) {
	GVariant* result = NULL;
	const gchar* _tmp0_;
	GVariant* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (connection != NULL, NULL);
	_tmp0_ = self->priv->_label_guide_s;
	_tmp1_ = g_variant_new_string (_tmp0_);
	g_variant_ref_sink (_tmp1_);
	result = _tmp1_;
	return result;
}


static GVariant* _indicator_get_xayatana_ordering_index (Indicator* self, GDBusConnection* connection) {
	GVariant* result = NULL;
	guint32 _tmp0_;
	GVariant* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (connection != NULL, NULL);
	_tmp0_ = self->priv->_ordering_index;
	_tmp1_ = g_variant_new_uint32 (_tmp0_);
	g_variant_ref_sink (_tmp1_);
	result = _tmp1_;
	return result;
}


static void indicator_real_service_method_call (IBusService* base, GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation) {
	Indicator * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp8_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	self = (Indicator*) base;
	g_return_if_fail (connection != NULL);
	g_return_if_fail (sender != NULL);
	g_return_if_fail (object_path != NULL);
	g_return_if_fail (interface_name != NULL);
	g_return_if_fail (method_name != NULL);
	g_return_if_fail (parameters != NULL);
	g_return_if_fail (invocation != NULL);
	_tmp0_ = object_path;
	_tmp1_ = ibus_service_get_object_path ((IBusService*) self);
	_tmp2_ = _tmp1_;
	g_return_if_fail (g_strcmp0 (_tmp0_, _tmp2_) == 0);
	_tmp3_ = interface_name;
	g_return_if_fail (g_strcmp0 (_tmp3_, INDICATOR_NOTIFICATION_ITEM_DBUS_IFACE) == 0);
	_tmp4_ = method_name;
	if (g_strcmp0 (_tmp4_, "Activate") == 0) {
		GDBusConnection* _tmp5_;
		GVariant* _tmp6_;
		GDBusMethodInvocation* _tmp7_;
		_tmp5_ = connection;
		_tmp6_ = parameters;
		_tmp7_ = invocation;
		_indicator_activate_menu_cb (self, _tmp5_, _tmp6_, _tmp7_);
		return;
	}
	_tmp8_ = method_name;
	if (g_strcmp0 (_tmp8_, "ContextMenu") == 0) {
		GDBusConnection* _tmp9_;
		GVariant* _tmp10_;
		GDBusMethodInvocation* _tmp11_;
		_tmp9_ = connection;
		_tmp10_ = parameters;
		_tmp11_ = invocation;
		_indicator_context_menu_cb (self, _tmp9_, _tmp10_, _tmp11_);
		return;
	}
	_tmp12_ = method_name;
	_tmp13_ = g_strconcat ("service_method_call() does not handle the method: ", _tmp12_, NULL);
	_tmp14_ = _tmp13_;
	g_warning ("indicator.vala:376: %s", _tmp14_);
	_g_free0 (_tmp14_);
}


static GVariant* indicator_real_service_get_property (IBusService* base, GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error) {
	Indicator * self;
	GVariant* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp7_;
	const gchar* _tmp10_;
	const gchar* _tmp13_;
	const gchar* _tmp16_;
	const gchar* _tmp19_;
	const gchar* _tmp22_;
	const gchar* _tmp25_;
	const gchar* _tmp28_;
	const gchar* _tmp31_;
	const gchar* _tmp34_;
	const gchar* _tmp37_;
	const gchar* _tmp40_;
	const gchar* _tmp43_;
	const gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	self = (Indicator*) base;
	g_return_val_if_fail (connection != NULL, NULL);
	g_return_val_if_fail (sender != NULL, NULL);
	g_return_val_if_fail (object_path != NULL, NULL);
	g_return_val_if_fail (interface_name != NULL, NULL);
	g_return_val_if_fail (property_name != NULL, NULL);
	_tmp0_ = object_path;
	_tmp1_ = ibus_service_get_object_path ((IBusService*) self);
	_tmp2_ = _tmp1_;
	g_return_val_if_fail (g_strcmp0 (_tmp0_, _tmp2_) == 0, NULL);
	_tmp3_ = interface_name;
	g_return_val_if_fail (g_strcmp0 (_tmp3_, INDICATOR_NOTIFICATION_ITEM_DBUS_IFACE) == 0, NULL);
	_tmp4_ = property_name;
	if (g_strcmp0 (_tmp4_, "Id") == 0) {
		GDBusConnection* _tmp5_;
		GVariant* _tmp6_;
		_tmp5_ = connection;
		_tmp6_ = _indicator_get_id (self, _tmp5_);
		result = _tmp6_;
		return result;
	}
	_tmp7_ = property_name;
	if (g_strcmp0 (_tmp7_, "Category") == 0) {
		GDBusConnection* _tmp8_;
		GVariant* _tmp9_;
		_tmp8_ = connection;
		_tmp9_ = _indicator_get_category (self, _tmp8_);
		result = _tmp9_;
		return result;
	}
	_tmp10_ = property_name;
	if (g_strcmp0 (_tmp10_, "Status") == 0) {
		GDBusConnection* _tmp11_;
		GVariant* _tmp12_;
		_tmp11_ = connection;
		_tmp12_ = _indicator_get_status (self, _tmp11_);
		result = _tmp12_;
		return result;
	}
	_tmp13_ = property_name;
	if (g_strcmp0 (_tmp13_, "IconName") == 0) {
		GDBusConnection* _tmp14_;
		GVariant* _tmp15_;
		_tmp14_ = connection;
		_tmp15_ = _indicator_get_icon_name (self, _tmp14_);
		result = _tmp15_;
		return result;
	}
	_tmp16_ = property_name;
	if (g_strcmp0 (_tmp16_, "IconPixmap") == 0) {
		GDBusConnection* _tmp17_;
		GVariant* _tmp18_;
		_tmp17_ = connection;
		_tmp18_ = _indicator_get_icon_vector (self, _tmp17_);
		result = _tmp18_;
		return result;
	}
	_tmp19_ = property_name;
	if (g_strcmp0 (_tmp19_, "IconAccessibleDesc") == 0) {
		GDBusConnection* _tmp20_;
		GVariant* _tmp21_;
		_tmp20_ = connection;
		_tmp21_ = _indicator_get_icon_desc (self, _tmp20_);
		result = _tmp21_;
		return result;
	}
	_tmp22_ = property_name;
	if (g_strcmp0 (_tmp22_, "AttentionIconName") == 0) {
		GDBusConnection* _tmp23_;
		GVariant* _tmp24_;
		_tmp23_ = connection;
		_tmp24_ = _indicator_get_attention_icon_name (self, _tmp23_);
		result = _tmp24_;
		return result;
	}
	_tmp25_ = property_name;
	if (g_strcmp0 (_tmp25_, "AttentionAccessibleDesc") == 0) {
		GDBusConnection* _tmp26_;
		GVariant* _tmp27_;
		_tmp26_ = connection;
		_tmp27_ = _indicator_get_attention_icon_desc (self, _tmp26_);
		result = _tmp27_;
		return result;
	}
	_tmp28_ = property_name;
	if (g_strcmp0 (_tmp28_, "Title") == 0) {
		GDBusConnection* _tmp29_;
		GVariant* _tmp30_;
		_tmp29_ = connection;
		_tmp30_ = _indicator_get_title (self, _tmp29_);
		result = _tmp30_;
		return result;
	}
	_tmp31_ = property_name;
	if (g_strcmp0 (_tmp31_, "IconThemePath") == 0) {
		GDBusConnection* _tmp32_;
		GVariant* _tmp33_;
		_tmp32_ = connection;
		_tmp33_ = _indicator_get_icon_theme_path (self, _tmp32_);
		result = _tmp33_;
		return result;
	}
	_tmp34_ = property_name;
	if (g_strcmp0 (_tmp34_, "Menu") == 0) {
		GDBusConnection* _tmp35_;
		GVariant* _tmp36_;
		_tmp35_ = connection;
		_tmp36_ = _indicator_get_menu (self, _tmp35_);
		result = _tmp36_;
		return result;
	}
	_tmp37_ = property_name;
	if (g_strcmp0 (_tmp37_, "XAyatanaLabel") == 0) {
		GDBusConnection* _tmp38_;
		GVariant* _tmp39_;
		_tmp38_ = connection;
		_tmp39_ = _indicator_get_xayatana_label (self, _tmp38_);
		result = _tmp39_;
		return result;
	}
	_tmp40_ = property_name;
	if (g_strcmp0 (_tmp40_, "XAyatanaLabelGuide") == 0) {
		GDBusConnection* _tmp41_;
		GVariant* _tmp42_;
		_tmp41_ = connection;
		_tmp42_ = _indicator_get_xayatana_label_guide (self, _tmp41_);
		result = _tmp42_;
		return result;
	}
	_tmp43_ = property_name;
	if (g_strcmp0 (_tmp43_, "XAyatanaOrderingIndex") == 0) {
		GDBusConnection* _tmp44_;
		GVariant* _tmp45_;
		_tmp44_ = connection;
		_tmp45_ = _indicator_get_xayatana_ordering_index (self, _tmp44_);
		result = _tmp45_;
		return result;
	}
	_tmp46_ = property_name;
	_tmp47_ = g_strconcat ("service_get_property() does not handle the property: ", _tmp46_, NULL);
	_tmp48_ = _tmp47_;
	g_warning ("indicator.vala:421: %s", _tmp48_);
	_g_free0 (_tmp48_);
	result = NULL;
	return result;
}


static gboolean indicator_real_service_set_property (IBusService* base, GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error) {
	Indicator * self;
	gboolean result = FALSE;
	self = (Indicator*) base;
	g_return_val_if_fail (connection != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	g_return_val_if_fail (object_path != NULL, FALSE);
	g_return_val_if_fail (interface_name != NULL, FALSE);
	g_return_val_if_fail (property_name != NULL, FALSE);
	g_return_val_if_fail (value != NULL, FALSE);
	result = FALSE;
	return result;
}


void indicator_set_status (Indicator* self, IndicatorStatus status) {
	gchar* status_s = NULL;
	IndicatorStatus _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GDBusConnection* _tmp5_;
	GDBusConnection* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = status;
	_tmp1_ = indicator_status_to_nick (_tmp0_);
	status_s = _tmp1_;
	_tmp2_ = self->priv->_status_s;
	_tmp3_ = status_s;
	if (g_strcmp0 (_tmp2_, _tmp3_) == 0) {
		_g_free0 (status_s);
		return;
	}
	_tmp4_ = status_s;
	indicator_set_status_s (self, _tmp4_);
	_tmp5_ = ibus_service_get_connection ((IBusService*) self);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == NULL) {
		_g_free0 (status_s);
		return;
	}
	{
		GDBusConnection* _tmp7_;
		GDBusConnection* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		GVariant* _tmp12_;
		GVariant* _tmp13_;
		_tmp7_ = ibus_service_get_connection ((IBusService*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = ibus_service_get_object_path ((IBusService*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = status_s;
		_tmp12_ = g_variant_new ("(s)", _tmp11_, NULL);
		g_variant_ref_sink (_tmp12_);
		_tmp13_ = _tmp12_;
		g_dbus_connection_emit_signal (_tmp8_, NULL, _tmp10_, INDICATOR_NOTIFICATION_ITEM_DBUS_IFACE, "NewStatus", _tmp13_, &_inner_error_);
		_g_variant_unref0 (_tmp13_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch9_g_error;
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("indicator.vala:460: Unable to send signal for NewIcon: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (status_s);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (status_s);
}


void indicator_set_icon_full (Indicator* self, const gchar* icon_name, const gchar* icon_desc) {
	gboolean changed = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp6_;
	GDBusConnection* _tmp7_;
	GDBusConnection* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_name != NULL);
	changed = FALSE;
	_tmp0_ = self->priv->_icon_name;
	_tmp1_ = icon_name;
	if (g_strcmp0 (_tmp0_, _tmp1_) != 0) {
		const gchar* _tmp2_;
		_tmp2_ = icon_name;
		indicator_set_icon_name (self, _tmp2_);
		indicator_set_icon_vector (self, NULL);
		changed = TRUE;
	}
	_tmp3_ = self->priv->_icon_desc;
	_tmp4_ = icon_desc;
	if (g_strcmp0 (_tmp3_, _tmp4_) != 0) {
		const gchar* _tmp5_;
		_tmp5_ = icon_desc;
		indicator_set_icon_desc (self, _tmp5_);
		changed = TRUE;
	}
	_tmp6_ = changed;
	if (!_tmp6_) {
		return;
	}
	_tmp7_ = ibus_service_get_connection ((IBusService*) self);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == NULL) {
		return;
	}
	{
		GDBusConnection* _tmp9_;
		GDBusConnection* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp9_ = ibus_service_get_connection ((IBusService*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = ibus_service_get_object_path ((IBusService*) self);
		_tmp12_ = _tmp11_;
		g_dbus_connection_emit_signal (_tmp10_, NULL, _tmp12_, INDICATOR_NOTIFICATION_ITEM_DBUS_IFACE, "NewIcon", NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch10_g_error;
		}
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = e;
		_tmp14_ = _tmp13_->message;
		g_warning ("indicator.vala:494: Unable to send signal for NewIcon: %s", _tmp14_);
		_g_error_free0 (e);
	}
	__finally10:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void indicator_set_cairo_image_surface_full (Indicator* self, cairo_surface_t* image, const gchar* icon_desc) {
	gint width = 0;
	cairo_surface_t* _tmp0_;
	gint _tmp1_;
	gint height = 0;
	cairo_surface_t* _tmp2_;
	gint _tmp3_;
	gint stride = 0;
	cairo_surface_t* _tmp4_;
	gint _tmp5_;
	guint8* data = NULL;
	cairo_surface_t* _tmp6_;
	guchar* _tmp7_;
	gint data_length1;
	gint _data_size_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GBytes* bytes = NULL;
	guint8* _tmp11_;
	gint _tmp11__length1;
	GBytes* _tmp12_;
	GVariant* bs = NULL;
	const GVariantType* _tmp13_;
	GBytes* _tmp14_;
	GVariant* _tmp15_;
	GVariantBuilder* builder = NULL;
	GVariantType* _tmp16_;
	GVariantType* _tmp17_;
	GVariantBuilder* _tmp18_;
	GVariantBuilder* _tmp19_;
	GVariantBuilder* _tmp20_;
	GVariantType* _tmp21_;
	GVariantType* _tmp22_;
	GVariantBuilder* _tmp23_;
	gint _tmp24_;
	GVariantBuilder* _tmp25_;
	gint _tmp26_;
	GVariantBuilder* _tmp27_;
	GVariant* _tmp28_;
	GVariantBuilder* _tmp29_;
	GVariantBuilder* _tmp30_;
	GVariant* _tmp31_;
	GVariant* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	GDBusConnection* _tmp36_;
	GDBusConnection* _tmp37_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (image != NULL);
	_tmp0_ = image;
	_tmp1_ = cairo_image_surface_get_width (_tmp0_);
	width = _tmp1_;
	_tmp2_ = image;
	_tmp3_ = cairo_image_surface_get_height (_tmp2_);
	height = _tmp3_;
	_tmp4_ = image;
	_tmp5_ = cairo_image_surface_get_stride (_tmp4_);
	stride = _tmp5_;
	_tmp6_ = image;
	_tmp7_ = cairo_image_surface_get_data (_tmp6_);
	data = (guint8*) _tmp7_;
	data_length1 = (-1 * sizeof (guchar)) / sizeof (guint8);
	_data_size_ = data_length1;
	_tmp8_ = stride;
	_tmp9_ = height;
	data_length1 = _tmp8_ * _tmp9_;
	_tmp10_ = data_length1;
	_tmp11_ = data;
	_tmp11__length1 = data_length1;
	_tmp12_ = g_bytes_new (_tmp11_, _tmp11__length1);
	bytes = _tmp12_;
	_tmp13_ = G_VARIANT_TYPE_BYTESTRING;
	_tmp14_ = bytes;
	_tmp15_ = g_variant_new_from_bytes (_tmp13_, _tmp14_, TRUE);
	g_variant_ref_sink (_tmp15_);
	bs = _tmp15_;
	_tmp16_ = g_variant_type_new ("a(iiay)");
	_tmp17_ = _tmp16_;
	_tmp18_ = g_variant_builder_new (_tmp17_);
	_tmp19_ = _tmp18_;
	_g_variant_type_free0 (_tmp17_);
	builder = _tmp19_;
	_tmp20_ = builder;
	_tmp21_ = g_variant_type_new ("(iiay)");
	_tmp22_ = _tmp21_;
	g_variant_builder_open (_tmp20_, _tmp22_);
	_g_variant_type_free0 (_tmp22_);
	_tmp23_ = builder;
	_tmp24_ = width;
	g_variant_builder_add (_tmp23_, "i", _tmp24_, NULL);
	_tmp25_ = builder;
	_tmp26_ = height;
	g_variant_builder_add (_tmp25_, "i", _tmp26_, NULL);
	_tmp27_ = builder;
	_tmp28_ = bs;
	g_variant_builder_add_value (_tmp27_, _tmp28_);
	_tmp29_ = builder;
	g_variant_builder_close (_tmp29_);
	_tmp30_ = builder;
	_tmp31_ = g_variant_new ("a(iiay)", _tmp30_, NULL);
	g_variant_ref_sink (_tmp31_);
	_tmp32_ = _tmp31_;
	indicator_set_icon_vector (self, _tmp32_);
	_g_variant_unref0 (_tmp32_);
	indicator_set_icon_name (self, "");
	_tmp33_ = self->priv->_icon_desc;
	_tmp34_ = icon_desc;
	if (g_strcmp0 (_tmp33_, _tmp34_) != 0) {
		const gchar* _tmp35_;
		_tmp35_ = icon_desc;
		indicator_set_icon_desc (self, _tmp35_);
	}
	_tmp36_ = ibus_service_get_connection ((IBusService*) self);
	_tmp37_ = _tmp36_;
	if (_tmp37_ == NULL) {
		_g_variant_builder_unref0 (builder);
		_g_variant_unref0 (bs);
		_g_bytes_unref0 (bytes);
		return;
	}
	{
		GDBusConnection* _tmp38_;
		GDBusConnection* _tmp39_;
		const gchar* _tmp40_;
		const gchar* _tmp41_;
		_tmp38_ = ibus_service_get_connection ((IBusService*) self);
		_tmp39_ = _tmp38_;
		_tmp40_ = ibus_service_get_object_path ((IBusService*) self);
		_tmp41_ = _tmp40_;
		g_dbus_connection_emit_signal (_tmp39_, NULL, _tmp41_, INDICATOR_NOTIFICATION_ITEM_DBUS_IFACE, "NewIcon", NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch11_g_error;
		}
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		GError* _tmp42_;
		const gchar* _tmp43_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp42_ = e;
		_tmp43_ = _tmp42_->message;
		g_warning ("indicator.vala:538: Unable to send signal for NewIcon: %s", _tmp43_);
		_g_error_free0 (e);
	}
	__finally11:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_variant_builder_unref0 (builder);
		_g_variant_unref0 (bs);
		_g_bytes_unref0 (bytes);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_variant_builder_unref0 (builder);
	_g_variant_unref0 (bs);
	_g_bytes_unref0 (bytes);
}


void indicator_position_context_menu (Indicator* self, GtkMenu* menu, gint* x, gint* y, gboolean* push_in) {
	gint _vala_x = 0;
	gint _vala_y = 0;
	gboolean _vala_push_in = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	_tmp0_ = self->priv->m_context_menu_x;
	_vala_x = _tmp0_;
	_tmp1_ = self->priv->m_context_menu_y;
	_vala_y = _tmp1_;
	_vala_push_in = FALSE;
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (push_in) {
		*push_in = _vala_push_in;
	}
}


void indicator_position_activate_menu (Indicator* self, GtkMenu* menu, gint* x, gint* y, gboolean* push_in) {
	gint _vala_x = 0;
	gint _vala_y = 0;
	gboolean _vala_push_in = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	_tmp0_ = self->priv->m_activate_menu_x;
	_vala_x = _tmp0_;
	_tmp1_ = self->priv->m_activate_menu_y;
	_vala_y = _tmp1_;
	_vala_push_in = FALSE;
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (push_in) {
		*push_in = _vala_push_in;
	}
}


/**
     * unregister_connection:
     *
     * "Destroy" dbus method is not called for the indicator's connection
     * when panel's connection is disconneted because the dbus connection
     * is a shared session bus so need to call
     * g_dbus_connection_unregister_object() by manual here
     * so that g_object_unref(m_panel) will be called later with an idle method,
     * which was assigned in the arguments of
     * g_dbus_connection_register_object()
     */
void indicator_unregister_connection (Indicator* self) {
	GDBusConnection* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = ibus_service_get_connection ((IBusService*) self);
	ibus_service_unregister ((IBusService*) self, _tmp0_);
}


const gchar* indicator_get_id (Indicator* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void indicator_set_id (Indicator* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, indicator_get_id (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_id);
		self->priv->_id = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, indicator_properties[INDICATOR_ID_PROPERTY]);
	}
}


const gchar* indicator_get_category_s (Indicator* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_category_s;
	result = _tmp0_;
	return result;
}


static void indicator_set_category_s (Indicator* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, indicator_get_category_s (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_category_s);
		self->priv->_category_s = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, indicator_properties[INDICATOR_CATEGORY_S_PROPERTY]);
	}
}


const gchar* indicator_get_status_s (Indicator* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_status_s;
	result = _tmp0_;
	return result;
}


void indicator_set_status_s (Indicator* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, indicator_get_status_s (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_status_s);
		self->priv->_status_s = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, indicator_properties[INDICATOR_STATUS_S_PROPERTY]);
	}
}


const gchar* indicator_get_icon_name (Indicator* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon_name;
	result = _tmp0_;
	return result;
}


void indicator_set_icon_name (Indicator* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, indicator_get_icon_name (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_icon_name);
		self->priv->_icon_name = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, indicator_properties[INDICATOR_ICON_NAME_PROPERTY]);
	}
}


const gchar* indicator_get_icon_desc (Indicator* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon_desc;
	result = _tmp0_;
	return result;
}


void indicator_set_icon_desc (Indicator* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, indicator_get_icon_desc (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_icon_desc);
		self->priv->_icon_desc = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, indicator_properties[INDICATOR_ICON_DESC_PROPERTY]);
	}
}


const gchar* indicator_get_attention_icon_name (Indicator* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_attention_icon_name;
	result = _tmp0_;
	return result;
}


void indicator_set_attention_icon_name (Indicator* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, indicator_get_attention_icon_name (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_attention_icon_name);
		self->priv->_attention_icon_name = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, indicator_properties[INDICATOR_ATTENTION_ICON_NAME_PROPERTY]);
	}
}


const gchar* indicator_get_attention_icon_desc (Indicator* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_attention_icon_desc;
	result = _tmp0_;
	return result;
}


void indicator_set_attention_icon_desc (Indicator* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, indicator_get_attention_icon_desc (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_attention_icon_desc);
		self->priv->_attention_icon_desc = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, indicator_properties[INDICATOR_ATTENTION_ICON_DESC_PROPERTY]);
	}
}


const gchar* indicator_get_title (Indicator* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_title;
	result = _tmp0_;
	return result;
}


void indicator_set_title (Indicator* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, indicator_get_title (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_title);
		self->priv->_title = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, indicator_properties[INDICATOR_TITLE_PROPERTY]);
	}
}


const gchar* indicator_get_icon_theme_path (Indicator* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon_theme_path;
	result = _tmp0_;
	return result;
}


void indicator_set_icon_theme_path (Indicator* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, indicator_get_icon_theme_path (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_icon_theme_path);
		self->priv->_icon_theme_path = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, indicator_properties[INDICATOR_ICON_THEME_PATH_PROPERTY]);
	}
}


gboolean indicator_get_connected (Indicator* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_connected;
	result = _tmp0_;
	return result;
}


void indicator_set_connected (Indicator* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (indicator_get_connected (self) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_connected = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, indicator_properties[INDICATOR_CONNECTED_PROPERTY]);
	}
}


const gchar* indicator_get_label_s (Indicator* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label_s;
	result = _tmp0_;
	return result;
}


void indicator_set_label_s (Indicator* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, indicator_get_label_s (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_label_s);
		self->priv->_label_s = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, indicator_properties[INDICATOR_LABEL_S_PROPERTY]);
	}
}


const gchar* indicator_get_label_guide_s (Indicator* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label_guide_s;
	result = _tmp0_;
	return result;
}


void indicator_set_label_guide_s (Indicator* self, const gchar* value) {
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, indicator_get_label_guide_s (self)) != 0) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (self->priv->_label_guide_s);
		self->priv->_label_guide_s = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, indicator_properties[INDICATOR_LABEL_GUIDE_S_PROPERTY]);
	}
}


guint32 indicator_get_ordering_index (Indicator* self) {
	guint32 result;
	guint32 _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_ordering_index;
	result = _tmp0_;
	return result;
}


void indicator_set_ordering_index (Indicator* self, guint32 value) {
	g_return_if_fail (self != NULL);
	if (indicator_get_ordering_index (self) != value) {
		guint32 _tmp0_;
		_tmp0_ = value;
		self->priv->_ordering_index = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, indicator_properties[INDICATOR_ORDERING_INDEX_PROPERTY]);
	}
}


GVariant* indicator_get_icon_vector (Indicator* self) {
	GVariant* result;
	GVariant* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon_vector;
	result = _tmp0_;
	return result;
}


void indicator_set_icon_vector (Indicator* self, GVariant* value) {
	g_return_if_fail (self != NULL);
	if (indicator_get_icon_vector (self) != value) {
		GVariant* _tmp0_;
		GVariant* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_variant_ref0 (_tmp0_);
		_g_variant_unref0 (self->priv->_icon_vector);
		self->priv->_icon_vector = _tmp1_;
		g_object_notify_by_pspec ((GObject *) self, indicator_properties[INDICATOR_ICON_VECTOR_PROPERTY]);
	}
}


static void g_cclosure_user_marshal_VOID__INT_INT_OBJECT_UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT_OBJECT_UINT_UINT) (gpointer data1, gint arg_1, gint arg_2, gpointer arg_3, guint arg_4, guint arg_5, gpointer data2);
	register GMarshalFunc_VOID__INT_INT_OBJECT_UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 6);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT_OBJECT_UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), g_value_get_object (param_values + 3), g_value_get_uint (param_values + 4), g_value_get_uint (param_values + 5), data2);
}


static void g_cclosure_user_marshal_VOID__INT_INT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT_OBJECT) (gpointer data1, gint arg_1, gint arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__INT_INT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), g_value_get_object (param_values + 3), data2);
}


static void indicator_class_init (IndicatorClass * klass) {
	indicator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (IndicatorPrivate));
	((IBusServiceClass *) klass)->service_method_call = (void (*) (IBusService *, GDBusConnection*, const gchar*, const gchar*, const gchar*, const gchar*, GVariant*, GDBusMethodInvocation*)) indicator_real_service_method_call;
	((IBusServiceClass *) klass)->service_get_property = (GVariant* (*) (IBusService *, GDBusConnection*, const gchar*, const gchar*, const gchar*, const gchar*, GError**)) indicator_real_service_get_property;
	((IBusServiceClass *) klass)->service_set_property = (gboolean (*) (IBusService *, GDBusConnection*, const gchar*, const gchar*, const gchar*, const gchar*, GVariant*, GError**)) indicator_real_service_set_property;
	G_OBJECT_CLASS (klass)->get_property = _vala_indicator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_indicator_set_property;
	G_OBJECT_CLASS (klass)->finalize = indicator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), INDICATOR_ID_PROPERTY, indicator_properties[INDICATOR_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), INDICATOR_CATEGORY_S_PROPERTY, indicator_properties[INDICATOR_CATEGORY_S_PROPERTY] = g_param_spec_string ("category-s", "category-s", "category-s", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), INDICATOR_STATUS_S_PROPERTY, indicator_properties[INDICATOR_STATUS_S_PROPERTY] = g_param_spec_string ("status-s", "status-s", "status-s", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), INDICATOR_ICON_NAME_PROPERTY, indicator_properties[INDICATOR_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), INDICATOR_ICON_DESC_PROPERTY, indicator_properties[INDICATOR_ICON_DESC_PROPERTY] = g_param_spec_string ("icon-desc", "icon-desc", "icon-desc", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), INDICATOR_ATTENTION_ICON_NAME_PROPERTY, indicator_properties[INDICATOR_ATTENTION_ICON_NAME_PROPERTY] = g_param_spec_string ("attention-icon-name", "attention-icon-name", "attention-icon-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), INDICATOR_ATTENTION_ICON_DESC_PROPERTY, indicator_properties[INDICATOR_ATTENTION_ICON_DESC_PROPERTY] = g_param_spec_string ("attention-icon-desc", "attention-icon-desc", "attention-icon-desc", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), INDICATOR_TITLE_PROPERTY, indicator_properties[INDICATOR_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), INDICATOR_ICON_THEME_PATH_PROPERTY, indicator_properties[INDICATOR_ICON_THEME_PATH_PROPERTY] = g_param_spec_string ("icon-theme-path", "icon-theme-path", "icon-theme-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), INDICATOR_CONNECTED_PROPERTY, indicator_properties[INDICATOR_CONNECTED_PROPERTY] = g_param_spec_boolean ("connected", "connected", "connected", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), INDICATOR_LABEL_S_PROPERTY, indicator_properties[INDICATOR_LABEL_S_PROPERTY] = g_param_spec_string ("label-s", "label-s", "label-s", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), INDICATOR_LABEL_GUIDE_S_PROPERTY, indicator_properties[INDICATOR_LABEL_GUIDE_S_PROPERTY] = g_param_spec_string ("label-guide-s", "label-guide-s", "label-guide-s", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), INDICATOR_ORDERING_INDEX_PROPERTY, indicator_properties[INDICATOR_ORDERING_INDEX_PROPERTY] = g_param_spec_uint ("ordering-index", "ordering-index", "ordering-index", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), INDICATOR_ICON_VECTOR_PROPERTY, indicator_properties[INDICATOR_ICON_VECTOR_PROPERTY] = g_param_spec_variant ("icon-vector", "icon-vector", "icon-vector", G_VARIANT_TYPE_ANY, NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	indicator_signals[INDICATOR_CONTEXT_MENU_SIGNAL] = g_signal_new ("context-menu", TYPE_INDICATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT_OBJECT_UINT_UINT, G_TYPE_NONE, 5, G_TYPE_INT, G_TYPE_INT, gdk_window_get_type (), G_TYPE_UINT, G_TYPE_UINT);
	indicator_signals[INDICATOR_ACTIVATE_SIGNAL] = g_signal_new ("activate", TYPE_INDICATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT_OBJECT, G_TYPE_NONE, 3, G_TYPE_INT, G_TYPE_INT, gdk_window_get_type ());
	indicator_signals[INDICATOR_REGISTERED_STATUS_NOTIFIER_ITEM_SIGNAL] = g_signal_new ("registered-status-notifier-item", TYPE_INDICATOR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void indicator_instance_init (Indicator * self) {
	self->priv = INDICATOR_GET_PRIVATE (self);
}


static void indicator_finalize (GObject * obj) {
	Indicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_INDICATOR, Indicator);
	_g_free0 (self->priv->_id);
	_g_free0 (self->priv->_category_s);
	_g_free0 (self->priv->_status_s);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_icon_desc);
	_g_free0 (self->priv->_attention_icon_name);
	_g_free0 (self->priv->_attention_icon_desc);
	_g_free0 (self->priv->_title);
	_g_free0 (self->priv->_icon_theme_path);
	_g_free0 (self->priv->_label_s);
	_g_free0 (self->priv->_label_guide_s);
	_g_variant_unref0 (self->priv->_icon_vector);
	_g_dbus_node_info_unref0 (self->priv->m_watcher_node_info);
	_g_object_unref0 (self->priv->m_proxy);
	_g_object_unref0 (self->priv->m_indicator_window);
	G_OBJECT_CLASS (indicator_parent_class)->finalize (obj);
}


GType indicator_get_type (void) {
	static volatile gsize indicator_type_id__volatile = 0;
	if (g_once_init_enter (&indicator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IndicatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) indicator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Indicator), 0, (GInstanceInitFunc) indicator_instance_init, NULL };
		GType indicator_type_id;
		indicator_type_id = g_type_register_static (ibus_service_get_type (), "Indicator", &g_define_type_info, 0);
		g_once_init_leave (&indicator_type_id__volatile, indicator_type_id);
	}
	return indicator_type_id__volatile;
}


static void _vala_indicator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Indicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_INDICATOR, Indicator);
	switch (property_id) {
		case INDICATOR_ID_PROPERTY:
		g_value_set_string (value, indicator_get_id (self));
		break;
		case INDICATOR_CATEGORY_S_PROPERTY:
		g_value_set_string (value, indicator_get_category_s (self));
		break;
		case INDICATOR_STATUS_S_PROPERTY:
		g_value_set_string (value, indicator_get_status_s (self));
		break;
		case INDICATOR_ICON_NAME_PROPERTY:
		g_value_set_string (value, indicator_get_icon_name (self));
		break;
		case INDICATOR_ICON_DESC_PROPERTY:
		g_value_set_string (value, indicator_get_icon_desc (self));
		break;
		case INDICATOR_ATTENTION_ICON_NAME_PROPERTY:
		g_value_set_string (value, indicator_get_attention_icon_name (self));
		break;
		case INDICATOR_ATTENTION_ICON_DESC_PROPERTY:
		g_value_set_string (value, indicator_get_attention_icon_desc (self));
		break;
		case INDICATOR_TITLE_PROPERTY:
		g_value_set_string (value, indicator_get_title (self));
		break;
		case INDICATOR_ICON_THEME_PATH_PROPERTY:
		g_value_set_string (value, indicator_get_icon_theme_path (self));
		break;
		case INDICATOR_CONNECTED_PROPERTY:
		g_value_set_boolean (value, indicator_get_connected (self));
		break;
		case INDICATOR_LABEL_S_PROPERTY:
		g_value_set_string (value, indicator_get_label_s (self));
		break;
		case INDICATOR_LABEL_GUIDE_S_PROPERTY:
		g_value_set_string (value, indicator_get_label_guide_s (self));
		break;
		case INDICATOR_ORDERING_INDEX_PROPERTY:
		g_value_set_uint (value, indicator_get_ordering_index (self));
		break;
		case INDICATOR_ICON_VECTOR_PROPERTY:
		g_value_set_variant (value, indicator_get_icon_vector (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_indicator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Indicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_INDICATOR, Indicator);
	switch (property_id) {
		case INDICATOR_ID_PROPERTY:
		indicator_set_id (self, g_value_get_string (value));
		break;
		case INDICATOR_CATEGORY_S_PROPERTY:
		indicator_set_category_s (self, g_value_get_string (value));
		break;
		case INDICATOR_STATUS_S_PROPERTY:
		indicator_set_status_s (self, g_value_get_string (value));
		break;
		case INDICATOR_ICON_NAME_PROPERTY:
		indicator_set_icon_name (self, g_value_get_string (value));
		break;
		case INDICATOR_ICON_DESC_PROPERTY:
		indicator_set_icon_desc (self, g_value_get_string (value));
		break;
		case INDICATOR_ATTENTION_ICON_NAME_PROPERTY:
		indicator_set_attention_icon_name (self, g_value_get_string (value));
		break;
		case INDICATOR_ATTENTION_ICON_DESC_PROPERTY:
		indicator_set_attention_icon_desc (self, g_value_get_string (value));
		break;
		case INDICATOR_TITLE_PROPERTY:
		indicator_set_title (self, g_value_get_string (value));
		break;
		case INDICATOR_ICON_THEME_PATH_PROPERTY:
		indicator_set_icon_theme_path (self, g_value_get_string (value));
		break;
		case INDICATOR_CONNECTED_PROPERTY:
		indicator_set_connected (self, g_value_get_boolean (value));
		break;
		case INDICATOR_LABEL_S_PROPERTY:
		indicator_set_label_s (self, g_value_get_string (value));
		break;
		case INDICATOR_LABEL_GUIDE_S_PROPERTY:
		indicator_set_label_guide_s (self, g_value_get_string (value));
		break;
		case INDICATOR_ORDERING_INDEX_PROPERTY:
		indicator_set_ordering_index (self, g_value_get_uint (value));
		break;
		case INDICATOR_ICON_VECTOR_PROPERTY:
		indicator_set_icon_vector (self, g_value_get_variant (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



