/* iconwidget.c generated by valac 0.38.2, the Vala compiler
 * generated from iconwidget.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2011-2014 Peng Huang <shawn.p.huang@gmail.com>
 * Copyright(c) 2018 Takao Fujiwara <takao.fujiwara1@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define TYPE_THEMED_RGBA (themed_rgba_get_type ())
#define THEMED_RGBA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEMED_RGBA, ThemedRGBA))
#define THEMED_RGBA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEMED_RGBA, ThemedRGBAClass))
#define IS_THEMED_RGBA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEMED_RGBA))
#define IS_THEMED_RGBA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEMED_RGBA))
#define THEMED_RGBA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEMED_RGBA, ThemedRGBAClass))

typedef struct _ThemedRGBA ThemedRGBA;
typedef struct _ThemedRGBAClass ThemedRGBAClass;
typedef struct _ThemedRGBAPrivate ThemedRGBAPrivate;
enum  {
	THEMED_RGBA_DUMMY_PROPERTY,
	THEMED_RGBA_LAST_PROPERTY
};
static GParamSpec* themed_rgba_properties[THEMED_RGBA_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gtk_widget_path_unref0(var) ((var == NULL) ? NULL : (var = (gtk_widget_path_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecThemedRGBA ParamSpecThemedRGBA;

#define TYPE_ICON_WIDGET (icon_widget_get_type ())
#define ICON_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ICON_WIDGET, IconWidget))
#define ICON_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ICON_WIDGET, IconWidgetClass))
#define IS_ICON_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ICON_WIDGET))
#define IS_ICON_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ICON_WIDGET))
#define ICON_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ICON_WIDGET, IconWidgetClass))

typedef struct _IconWidget IconWidget;
typedef struct _IconWidgetClass IconWidgetClass;
typedef struct _IconWidgetPrivate IconWidgetPrivate;
enum  {
	ICON_WIDGET_DUMMY_PROPERTY,
	ICON_WIDGET_LAST_PROPERTY
};
static GParamSpec* icon_widget_properties[ICON_WIDGET_LAST_PROPERTY];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ThemedRGBA {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ThemedRGBAPrivate * priv;
};

struct _ThemedRGBAClass {
	GTypeClass parent_class;
	void (*finalize) (ThemedRGBA *self);
};

struct _ThemedRGBAPrivate {
	GdkRGBA* _normal_fg;
	GdkRGBA* _normal_bg;
	GdkRGBA* _selected_fg;
	GdkRGBA* _selected_bg;
	GtkStyleContext* m_style_context;
};

struct _ParamSpecThemedRGBA {
	GParamSpec parent_instance;
};

struct _IconWidget {
	GtkImage parent_instance;
	IconWidgetPrivate * priv;
};

struct _IconWidgetClass {
	GtkImageClass parent_class;
};


static gpointer themed_rgba_parent_class = NULL;
static gpointer icon_widget_parent_class = NULL;

gpointer themed_rgba_ref (gpointer instance);
void themed_rgba_unref (gpointer instance);
GParamSpec* param_spec_themed_rgba (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_themed_rgba (GValue* value, gpointer v_object);
void value_take_themed_rgba (GValue* value, gpointer v_object);
gpointer value_get_themed_rgba (const GValue* value);
GType themed_rgba_get_type (void) G_GNUC_CONST;
#define THEMED_RGBA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_THEMED_RGBA, ThemedRGBAPrivate))
static void themed_rgba_reset_rgba (ThemedRGBA* self);
ThemedRGBA* themed_rgba_new (GtkWidget* widget);
ThemedRGBA* themed_rgba_construct (GType object_type, GtkWidget* widget);
void themed_rgba_set_normal_fg (ThemedRGBA* self, GdkRGBA* value);
void themed_rgba_set_normal_bg (ThemedRGBA* self, GdkRGBA* value);
void themed_rgba_set_selected_fg (ThemedRGBA* self, GdkRGBA* value);
void themed_rgba_set_selected_bg (ThemedRGBA* self, GdkRGBA* value);
static void themed_rgba_get_rgba (ThemedRGBA* self);
static void __lambda4_ (ThemedRGBA* self);
static void ___lambda4__gtk_style_context_changed (GtkStyleContext* _sender, gpointer self);
GdkRGBA* themed_rgba_get_normal_fg (ThemedRGBA* self);
GdkRGBA* themed_rgba_get_normal_bg (ThemedRGBA* self);
GdkRGBA* themed_rgba_get_selected_fg (ThemedRGBA* self);
GdkRGBA* themed_rgba_get_selected_bg (ThemedRGBA* self);
static void themed_rgba_finalize (ThemedRGBA * obj);
GType icon_widget_get_type (void) G_GNUC_CONST;
IconWidget* icon_widget_new (const gchar* icon_name_or_path, GtkIconSize size);
IconWidget* icon_widget_construct (GType object_type, const gchar* icon_name_or_path, GtkIconSize size);


static void __lambda4_ (ThemedRGBA* self) {
	themed_rgba_get_rgba (self);
}


static void ___lambda4__gtk_style_context_changed (GtkStyleContext* _sender, gpointer self) {
	__lambda4_ ((ThemedRGBA*) self);
}


ThemedRGBA* themed_rgba_construct (GType object_type, GtkWidget* widget) {
	ThemedRGBA* self = NULL;
	GtkWidgetPath* widget_path = NULL;
	GtkWidgetPath* _tmp0_;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkWidget* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkStyleContext* _tmp7_;
	g_return_val_if_fail (widget != NULL, NULL);
	self = (ThemedRGBA*) g_type_create_instance (object_type);
	themed_rgba_set_normal_fg (self, NULL);
	themed_rgba_set_normal_bg (self, NULL);
	themed_rgba_set_selected_fg (self, NULL);
	themed_rgba_set_selected_bg (self, NULL);
	_tmp0_ = gtk_widget_path_new ();
	widget_path = _tmp0_;
	gtk_widget_path_append_type (widget_path, gtk_text_view_get_type ());
	_tmp1_ = gtk_style_context_new ();
	_g_object_unref0 (self->priv->m_style_context);
	self->priv->m_style_context = _tmp1_;
	_tmp2_ = self->priv->m_style_context;
	gtk_style_context_set_path (_tmp2_, widget_path);
	_tmp3_ = self->priv->m_style_context;
	gtk_style_context_add_class (_tmp3_, GTK_STYLE_CLASS_VIEW);
	_tmp4_ = self->priv->m_style_context;
	_tmp5_ = widget;
	_tmp6_ = gtk_widget_get_style_context (_tmp5_);
	gtk_style_context_set_parent (_tmp4_, _tmp6_);
	themed_rgba_get_rgba (self);
	_tmp7_ = self->priv->m_style_context;
	g_signal_connect (_tmp7_, "changed", (GCallback) ___lambda4__gtk_style_context_changed, self);
	_gtk_widget_path_unref0 (widget_path);
	return self;
}


ThemedRGBA* themed_rgba_new (GtkWidget* widget) {
	return themed_rgba_construct (TYPE_THEMED_RGBA, widget);
}


static void themed_rgba_reset_rgba (ThemedRGBA* self) {
	GdkRGBA* _tmp0_;
	GdkRGBA* _tmp2_;
	GdkRGBA* _tmp4_;
	GdkRGBA* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_normal_fg;
	if (_tmp0_ != NULL) {
		GdkRGBA* _tmp1_;
		_tmp1_ = self->priv->_normal_fg;
		gdk_rgba_free (_tmp1_);
		themed_rgba_set_normal_fg (self, NULL);
	}
	_tmp2_ = self->priv->_normal_bg;
	if (_tmp2_ != NULL) {
		GdkRGBA* _tmp3_;
		_tmp3_ = self->priv->_normal_bg;
		gdk_rgba_free (_tmp3_);
		themed_rgba_set_normal_bg (self, NULL);
	}
	_tmp4_ = self->priv->_selected_fg;
	if (_tmp4_ != NULL) {
		GdkRGBA* _tmp5_;
		_tmp5_ = self->priv->_selected_fg;
		gdk_rgba_free (_tmp5_);
		themed_rgba_set_selected_fg (self, NULL);
	}
	_tmp6_ = self->priv->_selected_bg;
	if (_tmp6_ != NULL) {
		GdkRGBA* _tmp7_;
		_tmp7_ = self->priv->_selected_bg;
		gdk_rgba_free (_tmp7_);
		themed_rgba_set_selected_bg (self, NULL);
	}
}


static void themed_rgba_get_rgba (ThemedRGBA* self) {
	GdkRGBA* normal_fg = NULL;
	GdkRGBA* normal_bg = NULL;
	GdkRGBA* selected_fg = NULL;
	GdkRGBA* selected_bg = NULL;
	GtkStyleContext* _tmp0_;
	GtkStyleContext* _tmp1_;
	gchar* bg_prop = NULL;
	gchar* _tmp2_;
	GtkStyleContext* _tmp3_;
	const gchar* _tmp4_;
	GtkStyleContext* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	GdkRGBA* _tmp10_;
	gdouble _tmp11_;
	GdkRGBA* _tmp12_;
	gdouble _tmp13_;
	GdkRGBA* _tmp31_;
	GdkRGBA* _tmp32_;
	GdkRGBA* _tmp33_;
	GdkRGBA* _tmp34_;
	g_return_if_fail (self != NULL);
	themed_rgba_reset_rgba (self);
	normal_fg = NULL;
	normal_bg = NULL;
	selected_fg = NULL;
	selected_bg = NULL;
	_tmp0_ = self->priv->m_style_context;
	gtk_style_context_get (_tmp0_, GTK_STATE_FLAG_NORMAL, "color", &normal_fg, NULL);
	_tmp1_ = self->priv->m_style_context;
	gtk_style_context_get (_tmp1_, GTK_STATE_FLAG_SELECTED, "color", &selected_fg, NULL);
	_tmp2_ = g_strdup ("background-color");
	bg_prop = _tmp2_;
	_tmp3_ = self->priv->m_style_context;
	_tmp4_ = bg_prop;
	gtk_style_context_get (_tmp3_, GTK_STATE_FLAG_NORMAL, _tmp4_, &normal_bg, NULL);
	_tmp5_ = self->priv->m_style_context;
	_tmp6_ = bg_prop;
	gtk_style_context_get (_tmp5_, GTK_STATE_FLAG_SELECTED, _tmp6_, &selected_bg, NULL);
	_tmp10_ = normal_bg;
	_tmp11_ = (*_tmp10_).red;
	_tmp12_ = selected_bg;
	_tmp13_ = (*_tmp12_).red;
	if (_tmp11_ == _tmp13_) {
		GdkRGBA* _tmp14_;
		gdouble _tmp15_;
		GdkRGBA* _tmp16_;
		gdouble _tmp17_;
		_tmp14_ = normal_bg;
		_tmp15_ = (*_tmp14_).green;
		_tmp16_ = selected_bg;
		_tmp17_ = (*_tmp16_).green;
		_tmp9_ = _tmp15_ == _tmp17_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		GdkRGBA* _tmp18_;
		gdouble _tmp19_;
		GdkRGBA* _tmp20_;
		gdouble _tmp21_;
		_tmp18_ = normal_bg;
		_tmp19_ = (*_tmp18_).blue;
		_tmp20_ = selected_bg;
		_tmp21_ = (*_tmp20_).blue;
		_tmp8_ = _tmp19_ == _tmp21_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		GdkRGBA* _tmp22_;
		gdouble _tmp23_;
		GdkRGBA* _tmp24_;
		gdouble _tmp25_;
		_tmp22_ = normal_bg;
		_tmp23_ = (*_tmp22_).alpha;
		_tmp24_ = selected_bg;
		_tmp25_ = (*_tmp24_).alpha;
		_tmp7_ = _tmp23_ == _tmp25_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		gchar* _tmp26_;
		GtkStyleContext* _tmp27_;
		const gchar* _tmp28_;
		GtkStyleContext* _tmp29_;
		const gchar* _tmp30_;
		gdk_rgba_free (normal_bg);
		normal_bg = NULL;
		gdk_rgba_free (normal_bg);
		normal_bg = NULL;
		_tmp26_ = g_strdup ("-gtk-secondary-caret-color");
		_g_free0 (bg_prop);
		bg_prop = _tmp26_;
		_tmp27_ = self->priv->m_style_context;
		_tmp28_ = bg_prop;
		gtk_style_context_get (_tmp27_, GTK_STATE_FLAG_NORMAL, _tmp28_, &normal_bg, NULL);
		_tmp29_ = self->priv->m_style_context;
		_tmp30_ = bg_prop;
		gtk_style_context_get (_tmp29_, GTK_STATE_FLAG_SELECTED, _tmp30_, &selected_bg, NULL);
	}
	_tmp31_ = normal_fg;
	themed_rgba_set_normal_fg (self, _tmp31_);
	_tmp32_ = normal_bg;
	themed_rgba_set_normal_bg (self, _tmp32_);
	_tmp33_ = selected_fg;
	themed_rgba_set_selected_fg (self, _tmp33_);
	_tmp34_ = selected_bg;
	themed_rgba_set_selected_bg (self, _tmp34_);
	_g_free0 (bg_prop);
}


GdkRGBA* themed_rgba_get_normal_fg (ThemedRGBA* self) {
	GdkRGBA* result;
	GdkRGBA* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_normal_fg;
	result = _tmp0_;
	return result;
}


void themed_rgba_set_normal_fg (ThemedRGBA* self, GdkRGBA* value) {
	GdkRGBA* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_normal_fg = _tmp0_;
}


GdkRGBA* themed_rgba_get_normal_bg (ThemedRGBA* self) {
	GdkRGBA* result;
	GdkRGBA* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_normal_bg;
	result = _tmp0_;
	return result;
}


void themed_rgba_set_normal_bg (ThemedRGBA* self, GdkRGBA* value) {
	GdkRGBA* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_normal_bg = _tmp0_;
}


GdkRGBA* themed_rgba_get_selected_fg (ThemedRGBA* self) {
	GdkRGBA* result;
	GdkRGBA* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_selected_fg;
	result = _tmp0_;
	return result;
}


void themed_rgba_set_selected_fg (ThemedRGBA* self, GdkRGBA* value) {
	GdkRGBA* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_selected_fg = _tmp0_;
}


GdkRGBA* themed_rgba_get_selected_bg (ThemedRGBA* self) {
	GdkRGBA* result;
	GdkRGBA* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_selected_bg;
	result = _tmp0_;
	return result;
}


void themed_rgba_set_selected_bg (ThemedRGBA* self, GdkRGBA* value) {
	GdkRGBA* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_selected_bg = _tmp0_;
}


static void value_themed_rgba_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_themed_rgba_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		themed_rgba_unref (value->data[0].v_pointer);
	}
}


static void value_themed_rgba_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = themed_rgba_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_themed_rgba_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_themed_rgba_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ThemedRGBA * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = themed_rgba_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_themed_rgba_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ThemedRGBA ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = themed_rgba_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_themed_rgba (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecThemedRGBA* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_THEMED_RGBA), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_themed_rgba (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_THEMED_RGBA), NULL);
	return value->data[0].v_pointer;
}


void value_set_themed_rgba (GValue* value, gpointer v_object) {
	ThemedRGBA * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_THEMED_RGBA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_THEMED_RGBA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		themed_rgba_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		themed_rgba_unref (old);
	}
}


void value_take_themed_rgba (GValue* value, gpointer v_object) {
	ThemedRGBA * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_THEMED_RGBA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_THEMED_RGBA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		themed_rgba_unref (old);
	}
}


static void themed_rgba_class_init (ThemedRGBAClass * klass) {
	themed_rgba_parent_class = g_type_class_peek_parent (klass);
	((ThemedRGBAClass *) klass)->finalize = themed_rgba_finalize;
	g_type_class_add_private (klass, sizeof (ThemedRGBAPrivate));
}


static void themed_rgba_instance_init (ThemedRGBA * self) {
	self->priv = THEMED_RGBA_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void themed_rgba_finalize (ThemedRGBA * obj) {
	ThemedRGBA * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_THEMED_RGBA, ThemedRGBA);
	g_signal_handlers_destroy (self);
	themed_rgba_reset_rgba (self);
	_g_object_unref0 (self->priv->m_style_context);
}


GType themed_rgba_get_type (void) {
	static volatile gsize themed_rgba_type_id__volatile = 0;
	if (g_once_init_enter (&themed_rgba_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_themed_rgba_init, value_themed_rgba_free_value, value_themed_rgba_copy_value, value_themed_rgba_peek_pointer, "p", value_themed_rgba_collect_value, "p", value_themed_rgba_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ThemedRGBAClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) themed_rgba_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ThemedRGBA), 0, (GInstanceInitFunc) themed_rgba_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType themed_rgba_type_id;
		themed_rgba_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ThemedRGBA", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&themed_rgba_type_id__volatile, themed_rgba_type_id);
	}
	return themed_rgba_type_id__volatile;
}


gpointer themed_rgba_ref (gpointer instance) {
	ThemedRGBA * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void themed_rgba_unref (gpointer instance) {
	ThemedRGBA * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		THEMED_RGBA_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


/**
     * IconWidget:
     * @icon_name_or_path: Can be a name or path but not stock id
     *     because gtk_icon_theme_load_icon() cannot fallback the
     *     stock id to a real file name against
     *     gtk_image_new_from_stock().
     * @size: #Gtk.IconSize
     */
static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


IconWidget* icon_widget_construct (GType object_type, const gchar* icon_name_or_path, GtkIconSize size) {
	IconWidget * self = NULL;
	GdkPixbuf* pixbuf = NULL;
	gint fixed_width = 0;
	gint fixed_height = 0;
	GtkIconSize _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GdkPixbuf* _tmp25_;
	gfloat width = 0.0F;
	GdkPixbuf* _tmp26_;
	gint _tmp27_;
	gfloat height = 0.0F;
	GdkPixbuf* _tmp28_;
	gint _tmp29_;
	gfloat _tmp30_ = 0.0F;
	gfloat _tmp31_;
	gfloat _tmp32_;
	gfloat scale = 0.0F;
	gint _tmp35_;
	gfloat _tmp36_;
	gfloat _tmp37_;
	gfloat _tmp38_;
	gfloat _tmp39_;
	GdkPixbuf* _tmp40_;
	gfloat _tmp41_;
	gfloat _tmp42_;
	GdkPixbuf* _tmp43_;
	GdkPixbuf* _tmp44_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (icon_name_or_path != NULL, NULL);
	self = (IconWidget*) g_object_new (object_type, NULL);
	pixbuf = NULL;
	_tmp0_ = size;
	gtk_icon_size_lookup (_tmp0_, &_tmp1_, &_tmp2_);
	fixed_width = _tmp1_;
	fixed_height = _tmp2_;
	{
		const gchar* _tmp3_;
		gchar _tmp4_;
		_tmp3_ = icon_name_or_path;
		_tmp4_ = string_get (_tmp3_, (glong) 0);
		if (_tmp4_ == '/') {
			GdkPixbuf* _tmp5_ = NULL;
			const gchar* _tmp6_;
			GdkPixbuf* _tmp7_;
			GdkPixbuf* _tmp8_;
			_tmp6_ = icon_name_or_path;
			_tmp7_ = gdk_pixbuf_new_from_file (_tmp6_, &_inner_error_);
			_tmp5_ = _tmp7_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch2_g_error;
			}
			_tmp8_ = _tmp5_;
			_tmp5_ = NULL;
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp8_;
			_g_object_unref0 (_tmp5_);
		} else {
			GtkIconTheme* theme = NULL;
			GtkIconTheme* _tmp9_;
			GtkIconTheme* _tmp10_;
			GdkPixbuf* _tmp11_ = NULL;
			GtkIconTheme* _tmp12_;
			const gchar* _tmp13_;
			gint _tmp14_;
			GdkPixbuf* _tmp15_;
			GdkPixbuf* _tmp16_;
			_tmp9_ = gtk_icon_theme_get_default ();
			_tmp10_ = _g_object_ref0 (_tmp9_);
			theme = _tmp10_;
			_tmp12_ = theme;
			_tmp13_ = icon_name_or_path;
			_tmp14_ = fixed_width;
			_tmp15_ = gtk_icon_theme_load_icon (_tmp12_, _tmp13_, _tmp14_, 0, &_inner_error_);
			_tmp11_ = _tmp15_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (theme);
				goto __catch2_g_error;
			}
			_tmp16_ = _tmp11_;
			_tmp11_ = NULL;
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp16_;
			_g_object_unref0 (_tmp11_);
			_g_object_unref0 (theme);
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GtkIconTheme* theme = NULL;
			GtkIconTheme* _tmp17_;
			GtkIconTheme* _tmp18_;
			GdkPixbuf* _tmp19_ = NULL;
			GtkIconTheme* _tmp20_;
			gint _tmp21_;
			GdkPixbuf* _tmp22_;
			GdkPixbuf* _tmp23_;
			_tmp17_ = gtk_icon_theme_get_default ();
			_tmp18_ = _g_object_ref0 (_tmp17_);
			theme = _tmp18_;
			_tmp20_ = theme;
			_tmp21_ = fixed_width;
			_tmp22_ = gtk_icon_theme_load_icon (_tmp20_, "ibus-engine", _tmp21_, 0, &_inner_error_);
			_tmp19_ = _tmp22_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (theme);
				goto __catch3_g_error;
			}
			_tmp23_ = _tmp19_;
			_tmp19_ = NULL;
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp23_;
			_g_object_unref0 (_tmp19_);
			_g_object_unref0 (theme);
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError* e = NULL;
			GtkIconSize _tmp24_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp24_ = size;
			gtk_image_set_from_icon_name ((GtkImage*) self, "image-missing", _tmp24_);
			_g_error_free0 (e);
			_g_error_free0 (e);
			_g_object_unref0 (pixbuf);
			return self;
		}
		__finally3:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_error_free0 (e);
			_g_error_free0 (e);
			_g_object_unref0 (pixbuf);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (pixbuf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp25_ = pixbuf;
	if (_tmp25_ == NULL) {
		_g_object_unref0 (pixbuf);
		return self;
	}
	_tmp26_ = pixbuf;
	_tmp27_ = gdk_pixbuf_get_width (_tmp26_);
	width = (gfloat) _tmp27_;
	_tmp28_ = pixbuf;
	_tmp29_ = gdk_pixbuf_get_height (_tmp28_);
	height = (gfloat) _tmp29_;
	_tmp31_ = width;
	_tmp32_ = height;
	if (_tmp31_ > _tmp32_) {
		gfloat _tmp33_;
		_tmp33_ = width;
		_tmp30_ = _tmp33_;
	} else {
		gfloat _tmp34_;
		_tmp34_ = height;
		_tmp30_ = _tmp34_;
	}
	_tmp35_ = fixed_width;
	scale = _tmp35_ / _tmp30_;
	_tmp36_ = width;
	_tmp37_ = scale;
	width = _tmp36_ * _tmp37_;
	_tmp38_ = height;
	_tmp39_ = scale;
	height = _tmp38_ * _tmp39_;
	_tmp40_ = pixbuf;
	_tmp41_ = width;
	_tmp42_ = height;
	_tmp43_ = gdk_pixbuf_scale_simple (_tmp40_, (gint) _tmp41_, (gint) _tmp42_, GDK_INTERP_BILINEAR);
	_g_object_unref0 (pixbuf);
	pixbuf = _tmp43_;
	_tmp44_ = pixbuf;
	gtk_image_set_from_pixbuf ((GtkImage*) self, _tmp44_);
	gtk_widget_show ((GtkWidget*) self);
	_g_object_unref0 (pixbuf);
	return self;
}


IconWidget* icon_widget_new (const gchar* icon_name_or_path, GtkIconSize size) {
	return icon_widget_construct (TYPE_ICON_WIDGET, icon_name_or_path, size);
}


static void icon_widget_class_init (IconWidgetClass * klass) {
	icon_widget_parent_class = g_type_class_peek_parent (klass);
}


static void icon_widget_instance_init (IconWidget * self) {
}


GType icon_widget_get_type (void) {
	static volatile gsize icon_widget_type_id__volatile = 0;
	if (g_once_init_enter (&icon_widget_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IconWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) icon_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IconWidget), 0, (GInstanceInitFunc) icon_widget_instance_init, NULL };
		GType icon_widget_type_id;
		icon_widget_type_id = g_type_register_static (gtk_image_get_type (), "IconWidget", &g_define_type_info, 0);
		g_once_init_leave (&icon_widget_type_id__volatile, icon_widget_type_id);
	}
	return icon_widget_type_id__volatile;
}



