/* emojierapp.c generated by valac 0.38.2, the Vala compiler
 * generated from emojierapp.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright (c) 2017 Peng Wu <alexepico@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <stdio.h>
#include <ibus.h>


#define TYPE_EMOJI_APPLICATION (emoji_application_get_type ())
#define EMOJI_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EMOJI_APPLICATION, EmojiApplication))
#define EMOJI_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EMOJI_APPLICATION, EmojiApplicationClass))
#define IS_EMOJI_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EMOJI_APPLICATION))
#define IS_EMOJI_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EMOJI_APPLICATION))
#define EMOJI_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EMOJI_APPLICATION, EmojiApplicationClass))

typedef struct _EmojiApplication EmojiApplication;
typedef struct _EmojiApplicationClass EmojiApplicationClass;
typedef struct _EmojiApplicationPrivate EmojiApplicationPrivate;

#define TYPE_IBUS_EMOJIER (ibus_emojier_get_type ())
#define IBUS_EMOJIER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IBUS_EMOJIER, IBusEmojier))
#define IBUS_EMOJIER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IBUS_EMOJIER, IBusEmojierClass))
#define IS_IBUS_EMOJIER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IBUS_EMOJIER))
#define IS_IBUS_EMOJIER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IBUS_EMOJIER))
#define IBUS_EMOJIER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IBUS_EMOJIER, IBusEmojierClass))

typedef struct _IBusEmojier IBusEmojier;
typedef struct _IBusEmojierClass IBusEmojierClass;
enum  {
	EMOJI_APPLICATION_DUMMY_PROPERTY,
	EMOJI_APPLICATION_LAST_PROPERTY
};
static GParamSpec* emoji_application_properties[EMOJI_APPLICATION_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GdkEvent_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEvent_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _EmojiApplication {
	GtkApplication parent_instance;
	EmojiApplicationPrivate * priv;
};

struct _EmojiApplicationClass {
	GtkApplicationClass parent_class;
};

struct _EmojiApplicationPrivate {
	IBusEmojier* m_emojier;
	GSettings* m_settings_emoji;
};


extern gchar* emoji_font;
gchar* emoji_font = NULL;
extern gchar* annotation_lang;
gchar* annotation_lang = NULL;
extern gboolean partial_match;
gboolean partial_match = FALSE;
extern gint partial_match_length;
gint partial_match_length = -1;
extern gint partial_match_condition;
gint partial_match_condition = -1;
static gpointer emoji_application_parent_class = NULL;

GType emoji_application_get_type (void) G_GNUC_CONST;
GType ibus_emojier_get_type (void) G_GNUC_CONST;
#define EMOJI_APPLICATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_EMOJI_APPLICATION, EmojiApplicationPrivate))
static EmojiApplication* emoji_application_new (void);
static EmojiApplication* emoji_application_construct (GType object_type);
static void emoji_application_show_dialog (EmojiApplication* self, GApplicationCommandLine* command_line);
IBusEmojier* ibus_emojier_new (void);
IBusEmojier* ibus_emojier_construct (GType object_type);
static void _vala_GdkEvent_free (GdkEvent* self);
gchar* ibus_emojier_run (IBusEmojier* self, const gchar* input_context_path, GdkEvent* event);
static void _vala_array_add1 (gchar** * array, int* length, int* size, gchar* value);
void emoji_application_activate_dialog (EmojiApplication* self, GApplicationCommandLine* command_line);
static gint _emoji_application_command_line (EmojiApplication* self, GApplicationCommandLine* command_line);
void ibus_emojier_set_emoji_font (const gchar* emoji_font);
gboolean ibus_emojier_is_running (IBusEmojier* self);
void ibus_emojier_present_centralize (IBusEmojier* self, GdkEvent* event);
void ibus_emojier_set_annotation_lang (const gchar* lang);
void ibus_emojier_set_partial_match (gboolean has_partial_match);
void ibus_emojier_set_partial_match_length (gint length);
void ibus_emojier_set_partial_match_condition (gint condition);
void ibus_emojier_set_favorites (gchar** unowned_favorites, int unowned_favorites_length1, gchar** unowned_favorite_annotations, int unowned_favorite_annotations_length1);
void ibus_emojier_load_unicode_dict (void);
static gint emoji_application_real_command_line (GApplication* base, GApplicationCommandLine* command_line);
gint emoji_application_main (gchar** args, int args_length1);
static void emoji_application_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static EmojiApplication* emoji_application_construct (GType object_type) {
	EmojiApplication * self = NULL;
	self = (EmojiApplication*) g_object_new (object_type, "application-id", "org.freedesktop.IBus.Panel.Emojier", "flags", G_APPLICATION_HANDLES_COMMAND_LINE, NULL);
	g_application_set_inactivity_timeout ((GApplication*) self, (guint) 100000);
	return self;
}


static EmojiApplication* emoji_application_new (void) {
	return emoji_application_construct (TYPE_EMOJI_APPLICATION);
}


static void _vala_GdkEvent_free (GdkEvent* self) {
	g_boxed_free (gdk_event_get_type (), self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_array_add1 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void emoji_application_show_dialog (EmojiApplication* self, GApplicationCommandLine* command_line) {
	IBusEmojier* _tmp0_;
	IBusEmojier* _tmp1_;
	GdkEvent* event = NULL;
	GdkEvent* _tmp2_;
	GdkEvent* _tmp3_;
	gchar* emoji = NULL;
	IBusEmojier* _tmp16_;
	GdkEvent* _tmp17_;
	gchar* _tmp18_;
	IBusEmojier* _tmp19_;
	const gchar* _tmp20_;
	GtkClipboard* clipboard = NULL;
	GtkClipboard* _tmp22_;
	GtkClipboard* _tmp23_;
	GtkClipboard* _tmp24_;
	const gchar* _tmp25_;
	GtkClipboard* _tmp26_;
	gchar** emojier_favorites = NULL;
	GSettings* _tmp27_;
	gchar** _tmp28_;
	gchar** _tmp29_;
	gint emojier_favorites_length1;
	gint _emojier_favorites_size_;
	gboolean has_favorite = FALSE;
	gchar** _tmp30_;
	gint _tmp30__length1;
	gboolean _tmp33_;
	GApplicationCommandLine* _tmp39_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (command_line != NULL);
	_tmp0_ = ibus_emojier_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->m_emojier);
	self->priv->m_emojier = _tmp0_;
	_tmp1_ = self->priv->m_emojier;
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp1_);
	_tmp2_ = gtk_get_current_event ();
	event = _tmp2_;
	_tmp3_ = event;
	if (_tmp3_ == NULL) {
		GdkEvent* _tmp4_;
		GdkEvent* _tmp5_;
		GdkEventKey* _tmp6_;
		GdkEventKey* _tmp7_;
		GdkEvent* _tmp8_;
		GdkEventKey* _tmp9_;
		GdkEventKey* _tmp10_;
		GdkWindow* _tmp11_;
		GdkEvent* _tmp12_;
		GdkEventKey* _tmp13_;
		GdkEventKey* _tmp14_;
		GdkWindow* _tmp15_;
		_tmp4_ = gdk_event_new (GDK_KEY_PRESS);
		__vala_GdkEvent_free0 (event);
		event = _tmp4_;
		_tmp5_ = event;
		_tmp6_ = (GdkEventKey *) (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp7_->time = (guint32) GDK_CURRENT_TIME;
		_tmp8_ = event;
		_tmp9_ = (GdkEventKey *) (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = gdk_get_default_root_window ();
		_tmp10_->window = _tmp11_;
		_tmp12_ = event;
		_tmp13_ = (GdkEventKey *) (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_->window;
		g_object_ref ((GObject*) _tmp15_);
	}
	_tmp16_ = self->priv->m_emojier;
	_tmp17_ = event;
	_tmp18_ = ibus_emojier_run (_tmp16_, "", _tmp17_);
	emoji = _tmp18_;
	_tmp19_ = self->priv->m_emojier;
	gtk_application_remove_window ((GtkApplication*) self, (GtkWindow*) _tmp19_);
	_tmp20_ = emoji;
	if (_tmp20_ == NULL) {
		GApplicationCommandLine* _tmp21_;
		_g_object_unref0 (self->priv->m_emojier);
		self->priv->m_emojier = NULL;
		_tmp21_ = command_line;
		g_application_command_line_print (_tmp21_, "%s\n", _ ("Canceled to choose an emoji."));
		_g_free0 (emoji);
		__vala_GdkEvent_free0 (event);
		return;
	}
	_tmp22_ = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
	_tmp23_ = _g_object_ref0 (_tmp22_);
	clipboard = _tmp23_;
	_tmp24_ = clipboard;
	_tmp25_ = emoji;
	gtk_clipboard_set_text (_tmp24_, _tmp25_, -1);
	_tmp26_ = clipboard;
	gtk_clipboard_store (_tmp26_);
	_tmp27_ = self->priv->m_settings_emoji;
	_tmp29_ = _tmp28_ = g_settings_get_strv (_tmp27_, "favorites");
	emojier_favorites = _tmp29_;
	emojier_favorites_length1 = _vala_array_length (_tmp28_);
	_emojier_favorites_size_ = emojier_favorites_length1;
	has_favorite = FALSE;
	_tmp30_ = emojier_favorites;
	_tmp30__length1 = emojier_favorites_length1;
	{
		gchar** favorite_collection = NULL;
		gint favorite_collection_length1 = 0;
		gint _favorite_collection_size_ = 0;
		gint favorite_it = 0;
		favorite_collection = _tmp30_;
		favorite_collection_length1 = _tmp30__length1;
		for (favorite_it = 0; favorite_it < _tmp30__length1; favorite_it = favorite_it + 1) {
			const gchar* favorite = NULL;
			favorite = favorite_collection[favorite_it];
			{
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				_tmp31_ = favorite;
				_tmp32_ = emoji;
				if (g_strcmp0 (_tmp31_, _tmp32_) == 0) {
					has_favorite = TRUE;
					break;
				}
			}
		}
	}
	_tmp33_ = has_favorite;
	if (!_tmp33_) {
		gchar** _tmp34_;
		gint _tmp34__length1;
		const gchar* _tmp35_;
		gchar* _tmp36_;
		GSettings* _tmp37_;
		gchar** _tmp38_;
		gint _tmp38__length1;
		_tmp34_ = emojier_favorites;
		_tmp34__length1 = emojier_favorites_length1;
		_tmp35_ = emoji;
		_tmp36_ = g_strdup (_tmp35_);
		_vala_array_add1 (&emojier_favorites, &emojier_favorites_length1, &_emojier_favorites_size_, _tmp36_);
		_tmp37_ = self->priv->m_settings_emoji;
		_tmp38_ = emojier_favorites;
		_tmp38__length1 = emojier_favorites_length1;
		g_settings_set_strv (_tmp37_, "favorites", _tmp38_);
	}
	_g_object_unref0 (self->priv->m_emojier);
	self->priv->m_emojier = NULL;
	_tmp39_ = command_line;
	g_application_command_line_print (_tmp39_, "%s\n", _ ("Copied an emoji to your clipboard."));
	emojier_favorites = (_vala_array_free (emojier_favorites, emojier_favorites_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (clipboard);
	_g_free0 (emoji);
	__vala_GdkEvent_free0 (event);
}


void emoji_application_activate_dialog (EmojiApplication* self, GApplicationCommandLine* command_line) {
	GApplicationCommandLine* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (command_line != NULL);
	g_application_hold ((GApplication*) self);
	_tmp0_ = command_line;
	emoji_application_show_dialog (self, _tmp0_);
	g_application_release ((GApplication*) self);
}


static gint _emoji_application_command_line (EmojiApplication* self, GApplicationCommandLine* command_line) {
	gint result = 0;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	static const GOptionEntry options[] = {{"font", (gchar) 0, 0, G_OPTION_ARG_STRING, &emoji_font, N_ ("\"FONT\" for emoji characters on emoji dialog"), N_ ("FONT")}, {"lang", (gchar) 0, 0, G_OPTION_ARG_STRING, &annotation_lang, N_ ("\"LANG\" for annotations on emoji dialog. E.g. \"en\""), N_ ("LANG")}, {"partial-match", (gchar) 0, 0, G_OPTION_ARG_NONE, &partial_match, N_ ("Emoji annotations can be match partially"), NULL}, {"partial-match-length", (gchar) 0, 0, G_OPTION_ARG_INT, &partial_match_length, N_ ("Match with the length of the specified integer"), NULL}, {"partial-match-condition", (gchar) 0, 0, G_OPTION_ARG_INT, &partial_match_condition, N_ ("Match with the condition of the specified integer"), NULL}, {NULL}};
	GOptionContext* option = NULL;
	GOptionContext* _tmp3_;
	GOptionContext* _tmp4_;
	gchar** args = NULL;
	GApplicationCommandLine* _tmp5_;
	gint _tmp6_;
	gchar** _tmp7_;
	gint args_length1;
	gint _args_size_;
	const gchar** _args = NULL;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar** _tmp9_;
	gint _args_length1;
	gint __args_size_;
	gboolean _tmp27_ = FALSE;
	IBusEmojier* _tmp28_;
	const gchar* _tmp37_;
	const gchar* _tmp40_;
	gboolean _tmp41_;
	gint _tmp42_;
	gint _tmp46_;
	const gchar* _tmp53_;
	GSettings* _tmp55_;
	gchar** _tmp56_;
	gchar** _tmp57_;
	gchar** _tmp58_;
	gint _tmp58__length1;
	GSettings* _tmp59_;
	gchar** _tmp60_;
	gchar** _tmp61_;
	gchar** _tmp62_;
	gint _tmp62__length1;
	GApplicationCommandLine* _tmp63_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (command_line != NULL, 0);
	_tmp0_ = self->priv->m_settings_emoji;
	_tmp1_ = g_settings_get_string (_tmp0_, "font");
	_tmp2_ = _tmp1_;
	ibus_emojier_set_emoji_font (_tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = g_option_context_new (NULL);
	option = _tmp3_;
	_tmp4_ = option;
	g_option_context_add_main_entries (_tmp4_, options, GETTEXT_PACKAGE);
	_tmp5_ = command_line;
	_tmp7_ = g_application_command_line_get_arguments (_tmp5_, &_tmp6_);
	args = _tmp7_;
	args_length1 = _tmp6_;
	_args_size_ = args_length1;
	_tmp8_ = args;
	_tmp8__length1 = args_length1;
	_tmp9_ = g_new0 (gchar*, _tmp8__length1 + 1);
	_args = _tmp9_;
	_args_length1 = _tmp8__length1;
	__args_size_ = _args_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				gint _tmp12_;
				gchar** _tmp13_;
				gint _tmp13__length1;
				const gchar** _tmp14_;
				gint _tmp14__length1;
				gint _tmp15_;
				gchar** _tmp16_;
				gint _tmp16__length1;
				gint _tmp17_;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp12_ = i;
				_tmp13_ = args;
				_tmp13__length1 = args_length1;
				if (!(_tmp12_ < _tmp13__length1)) {
					break;
				}
				_tmp14_ = _args;
				_tmp14__length1 = _args_length1;
				_tmp15_ = i;
				_tmp16_ = args;
				_tmp16__length1 = args_length1;
				_tmp17_ = i;
				_tmp18_ = _tmp16_[_tmp17_];
				_tmp14_[_tmp15_] = _tmp18_;
				_tmp19_ = _tmp14_[_tmp15_];
			}
		}
	}
	_g_free0 (emoji_font);
	emoji_font = NULL;
	_g_free0 (annotation_lang);
	annotation_lang = NULL;
	{
		gchar** tmp = NULL;
		const gchar** _tmp20_;
		gint _tmp20__length1;
		gint tmp_length1;
		gint _tmp_size_;
		GOptionContext* _tmp21_;
		_tmp20_ = _args;
		_tmp20__length1 = _args_length1;
		tmp = _tmp20_;
		tmp_length1 = _tmp20__length1;
		_tmp_size_ = tmp_length1;
		_tmp21_ = option;
		g_option_context_parse (_tmp21_, &tmp_length1, &tmp, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp22_ = 0;
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_args = (g_free (_args), NULL);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_option_context_free0 (option);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp22_;
		}
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp23_;
		GError* _tmp24_;
		const gchar* _tmp25_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp23_ = stderr;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->message;
		fprintf (_tmp23_, "%s\n", _tmp25_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_args = (g_free (_args), NULL);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_option_context_free0 (option);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp26_ = 0;
		_args = (g_free (_args), NULL);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_option_context_free0 (option);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp26_;
	}
	_tmp28_ = self->priv->m_emojier;
	if (_tmp28_ != NULL) {
		IBusEmojier* _tmp29_;
		gboolean _tmp30_;
		_tmp29_ = self->priv->m_emojier;
		_tmp30_ = ibus_emojier_is_running (_tmp29_);
		_tmp27_ = _tmp30_;
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		GdkEvent* event = NULL;
		GdkEvent* _tmp31_;
		GdkEvent* _tmp32_;
		GdkEventKey* _tmp33_;
		GdkEventKey* _tmp34_;
		IBusEmojier* _tmp35_;
		GdkEvent* _tmp36_;
		_tmp31_ = gdk_event_new (GDK_KEY_PRESS);
		event = _tmp31_;
		_tmp32_ = event;
		_tmp33_ = (GdkEventKey *) (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp34_->time = (guint32) GDK_CURRENT_TIME;
		_tmp35_ = self->priv->m_emojier;
		_tmp36_ = event;
		ibus_emojier_present_centralize (_tmp35_, _tmp36_);
		result = EXIT_SUCCESS;
		__vala_GdkEvent_free0 (event);
		_args = (g_free (_args), NULL);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_option_context_free0 (option);
		return result;
	}
	_tmp37_ = annotation_lang;
	if (_tmp37_ == NULL) {
		GSettings* _tmp38_;
		gchar* _tmp39_;
		_tmp38_ = self->priv->m_settings_emoji;
		_tmp39_ = g_settings_get_string (_tmp38_, "lang");
		_g_free0 (annotation_lang);
		annotation_lang = _tmp39_;
	}
	_tmp40_ = annotation_lang;
	ibus_emojier_set_annotation_lang (_tmp40_);
	_tmp41_ = partial_match;
	ibus_emojier_set_partial_match (_tmp41_);
	_tmp42_ = partial_match_length;
	if (_tmp42_ > 0) {
		gint _tmp43_;
		_tmp43_ = partial_match_length;
		ibus_emojier_set_partial_match_length (_tmp43_);
	} else {
		GSettings* _tmp44_;
		gint _tmp45_;
		_tmp44_ = self->priv->m_settings_emoji;
		_tmp45_ = g_settings_get_int (_tmp44_, "partial-match-length");
		ibus_emojier_set_partial_match_length (_tmp45_);
	}
	_tmp46_ = partial_match_condition;
	if (_tmp46_ > 2) {
		GSettings* _tmp47_;
		gint _tmp48_;
		g_warning ("emojierapp.vala:164: Need condition between 0 and 2.");
		_tmp47_ = self->priv->m_settings_emoji;
		_tmp48_ = g_settings_get_int (_tmp47_, "partial-match-condition");
		ibus_emojier_set_partial_match_condition (_tmp48_);
	} else {
		gint _tmp49_;
		_tmp49_ = partial_match_condition;
		if (_tmp49_ >= 0) {
			gint _tmp50_;
			_tmp50_ = partial_match_condition;
			ibus_emojier_set_partial_match_condition (_tmp50_);
		} else {
			GSettings* _tmp51_;
			gint _tmp52_;
			_tmp51_ = self->priv->m_settings_emoji;
			_tmp52_ = g_settings_get_int (_tmp51_, "partial-match-condition");
			ibus_emojier_set_partial_match_condition (_tmp52_);
		}
	}
	_tmp53_ = emoji_font;
	if (_tmp53_ != NULL) {
		const gchar* _tmp54_;
		_tmp54_ = emoji_font;
		ibus_emojier_set_emoji_font (_tmp54_);
	}
	_tmp55_ = self->priv->m_settings_emoji;
	_tmp57_ = _tmp56_ = g_settings_get_strv (_tmp55_, "favorites");
	_tmp58_ = _tmp57_;
	_tmp58__length1 = _vala_array_length (_tmp56_);
	_tmp59_ = self->priv->m_settings_emoji;
	_tmp61_ = _tmp60_ = g_settings_get_strv (_tmp59_, "favorite-annotations");
	_tmp62_ = _tmp61_;
	_tmp62__length1 = _vala_array_length (_tmp60_);
	ibus_emojier_set_favorites (_tmp58_, _vala_array_length (_tmp56_), _tmp62_, _vala_array_length (_tmp60_));
	_tmp62_ = (_vala_array_free (_tmp62_, _tmp62__length1, (GDestroyNotify) g_free), NULL);
	_tmp58_ = (_vala_array_free (_tmp58_, _tmp58__length1, (GDestroyNotify) g_free), NULL);
	ibus_emojier_load_unicode_dict ();
	_tmp63_ = command_line;
	emoji_application_activate_dialog (self, _tmp63_);
	result = EXIT_SUCCESS;
	_args = (g_free (_args), NULL);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	_g_option_context_free0 (option);
	return result;
}


static gint emoji_application_real_command_line (GApplication* base, GApplicationCommandLine* command_line) {
	EmojiApplication * self;
	gint result = 0;
	gint _result_ = 0;
	GApplicationCommandLine* _tmp0_;
	gint _tmp1_;
	self = (EmojiApplication*) base;
	g_return_val_if_fail (command_line != NULL, 0);
	g_application_hold ((GApplication*) self);
	_tmp0_ = command_line;
	_tmp1_ = _emoji_application_command_line (self, _tmp0_);
	_result_ = _tmp1_;
	g_application_release ((GApplication*) self);
	result = _result_;
	return result;
}


gint emoji_application_main (gchar** args, int args_length1) {
	gint result = 0;
	EmojiApplication* app = NULL;
	EmojiApplication* _tmp0_;
	gint status = 0;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gint _tmp2_;
	bindtextdomain (GETTEXT_PACKAGE, GLIB_LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	ibus_init ();
	gtk_init (&args_length1, &args);
	_tmp0_ = emoji_application_new ();
	app = _tmp0_;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	_tmp2_ = g_application_run ((GApplication*) app, _tmp1__length1, _tmp1_);
	status = _tmp2_;
	result = status;
	_g_object_unref0 (app);
	return result;
}


int main (int argc, char ** argv) {
	return emoji_application_main (argv, argc);
}


static void emoji_application_class_init (EmojiApplicationClass * klass) {
	emoji_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EmojiApplicationPrivate));
	((GApplicationClass *) klass)->command_line = (gint (*) (GApplication *, GApplicationCommandLine*)) emoji_application_real_command_line;
	G_OBJECT_CLASS (klass)->finalize = emoji_application_finalize;
}


static void emoji_application_instance_init (EmojiApplication * self) {
	GSettings* _tmp0_;
	self->priv = EMOJI_APPLICATION_GET_PRIVATE (self);
	_tmp0_ = g_settings_new ("org.freedesktop.ibus.panel.emoji");
	self->priv->m_settings_emoji = _tmp0_;
}


static void emoji_application_finalize (GObject * obj) {
	EmojiApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EMOJI_APPLICATION, EmojiApplication);
	_g_object_unref0 (self->priv->m_emojier);
	_g_object_unref0 (self->priv->m_settings_emoji);
	G_OBJECT_CLASS (emoji_application_parent_class)->finalize (obj);
}


GType emoji_application_get_type (void) {
	static volatile gsize emoji_application_type_id__volatile = 0;
	if (g_once_init_enter (&emoji_application_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EmojiApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) emoji_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EmojiApplication), 0, (GInstanceInitFunc) emoji_application_instance_init, NULL };
		GType emoji_application_type_id;
		emoji_application_type_id = g_type_register_static (gtk_application_get_type (), "EmojiApplication", &g_define_type_info, 0);
		g_once_init_leave (&emoji_application_type_id__volatile, emoji_application_type_id);
	}
	return emoji_application_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



