/* main.c generated by valac 0.38.2, the Vala compiler
 * generated from main.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2013 Peng Huang <shawn.p.huang@gmail.com>
 * Copyright(c) 2015-2017 Takao Fujiwara <takao.fujiwara1@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <ibus.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <stdio.h>
#include <gio/gio.h>
#include <locale.h>
#include <gobject/gvaluecollector.h>


#define TYPE_ENGINE_LIST (engine_list_get_type ())
#define ENGINE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENGINE_LIST, EngineList))
#define ENGINE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENGINE_LIST, EngineListClass))
#define IS_ENGINE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENGINE_LIST))
#define IS_ENGINE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENGINE_LIST))
#define ENGINE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENGINE_LIST, EngineListClass))

typedef struct _EngineList EngineList;
typedef struct _EngineListClass EngineListClass;
typedef struct _EngineListPrivate EngineListPrivate;
enum  {
	ENGINE_LIST_DUMMY_PROPERTY,
	ENGINE_LIST_LAST_PROPERTY
};
static GParamSpec* engine_list_properties[ENGINE_LIST_LAST_PROPERTY];
typedef struct _ParamSpecEngineList ParamSpecEngineList;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _engine_list_unref0(var) ((var == NULL) ? NULL : (var = (engine_list_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define TYPE_COMMAND_ENTRY (command_entry_get_type ())
typedef struct _CommandEntry CommandEntry;

struct _EngineList {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EngineListPrivate * priv;
	IBusEngineDesc** data;
	gint data_length1;
	gint _data_size_;
};

struct _EngineListClass {
	GTypeClass parent_class;
	void (*finalize) (EngineList *self);
};

struct _ParamSpecEngineList {
	GParamSpec parent_instance;
};

typedef gint (*EntryFunc) (gchar** argv, int argv_length1, void* user_data);
struct _CommandEntry {
	const gchar* name;
	const gchar* description;
	EntryFunc entry;
	gpointer entry_target;
};


extern gboolean name_only;
gboolean name_only = FALSE;
extern gboolean is_system;
gboolean is_system = FALSE;
extern gchar* cache_file;
gchar* cache_file = NULL;
static gpointer engine_list_parent_class = NULL;
extern gchar* program_name;
gchar* program_name = NULL;

#define IBUS_SCHEMAS_GENERAL "org.freedesktop.ibus.general"
#define IBUS_SCHEMAS_GENERAL_PANEL "org.freedesktop.ibus.general.panel"
#define IBUS_SCHEMAS_PANEL "org.freedesktop.ibus.panel"
gpointer engine_list_ref (gpointer instance);
void engine_list_unref (gpointer instance);
GParamSpec* param_spec_engine_list (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_engine_list (GValue* value, gpointer v_object);
void value_take_engine_list (GValue* value, gpointer v_object);
gpointer value_get_engine_list (const GValue* value);
GType engine_list_get_type (void) G_GNUC_CONST;
EngineList* engine_list_new (void);
EngineList* engine_list_construct (GType object_type);
static void engine_list_finalize (EngineList * obj);
IBusBus* get_bus (void);
gint list_engine (gchar** argv, int argv_length1);
static void _g_free0_ (gpointer var);
static void _engine_list_unref0_ (gpointer var);
static void _vala_array_add1 (IBusEngineDesc** * array, int* length, int* size, IBusEngineDesc* value);
gint exec_setxkbmap (IBusEngineDesc* engine);
static void _vala_array_add2 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add3 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add4 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add5 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add6 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add7 (gchar** * array, int* length, int* size, gchar* value);
static void _vala_array_add8 (gchar** * array, int* length, int* size, gchar* value);
gint get_set_engine (gchar** argv, int argv_length1);
gint message_watch (gchar** argv, int argv_length1);
gint restart_daemon (gchar** argv, int argv_length1);
gint exit_daemon (gchar** argv, int argv_length1);
gint print_version (gchar** argv, int argv_length1);
gint read_cache (gchar** argv, int argv_length1);
gint write_cache (gchar** argv, int argv_length1);
gint print_address (gchar** argv, int argv_length1);
gint read_config (gchar** argv, int argv_length1);
gint reset_config (gchar** argv, int argv_length1);
gint emoji_dialog (gchar** argv, int argv_length1);
gint print_help (gchar** argv, int argv_length1);
void print_usage (FILE* stream);
GType command_entry_get_type (void) G_GNUC_CONST;
CommandEntry* command_entry_dup (const CommandEntry* self);
void command_entry_free (CommandEntry* self);
static gint _get_set_engine_entry_func (gchar** argv, int argv_length1, gpointer self);
static gint _exit_daemon_entry_func (gchar** argv, int argv_length1, gpointer self);
static gint _list_engine_entry_func (gchar** argv, int argv_length1, gpointer self);
static gint _message_watch_entry_func (gchar** argv, int argv_length1, gpointer self);
static gint _restart_daemon_entry_func (gchar** argv, int argv_length1, gpointer self);
static gint _print_version_entry_func (gchar** argv, int argv_length1, gpointer self);
static gint _read_cache_entry_func (gchar** argv, int argv_length1, gpointer self);
static gint _write_cache_entry_func (gchar** argv, int argv_length1, gpointer self);
static gint _print_address_entry_func (gchar** argv, int argv_length1, gpointer self);
static gint _read_config_entry_func (gchar** argv, int argv_length1, gpointer self);
static gint _reset_config_entry_func (gchar** argv, int argv_length1, gpointer self);
static gint _emoji_dialog_entry_func (gchar** argv, int argv_length1, gpointer self);
static gint _print_help_entry_func (gchar** argv, int argv_length1, gpointer self);
gint _vala_main (gchar** argv, int argv_length1);
static gchar** _vala_array_dup1 (gchar** self, int length);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const gchar* IBUS_SCHEMAS[3] = {IBUS_SCHEMAS_GENERAL, IBUS_SCHEMAS_GENERAL_PANEL, IBUS_SCHEMAS_PANEL};
const CommandEntry commands[13] = {{"engine", N_ ("Set or get engine"), _get_set_engine_entry_func}, {"exit", N_ ("Exit ibus-daemon"), _exit_daemon_entry_func}, {"list-engine", N_ ("Show available engines"), _list_engine_entry_func}, {"watch", N_ ("(Not implemented)"), _message_watch_entry_func}, {"restart", N_ ("Restart ibus-daemon"), _restart_daemon_entry_func}, {"version", N_ ("Show version"), _print_version_entry_func}, {"read-cache", N_ ("Show the content of registry cache"), _read_cache_entry_func}, {"write-cache", N_ ("Create registry cache"), _write_cache_entry_func}, {"address", N_ ("Print the D-Bus address of ibus-daemon"), _print_address_entry_func}, {"read-config", N_ ("Show the configuration values"), _read_config_entry_func}, {"reset-config", N_ ("Reset the configuration values"), _reset_config_entry_func}, {"emoji", N_ ("Save emoji on dialog to clipboard "), _emoji_dialog_entry_func}, {"help", N_ ("Show this information"), _print_help_entry_func}};

EngineList* engine_list_construct (GType object_type) {
	EngineList* self = NULL;
	self = (EngineList*) g_type_create_instance (object_type);
	return self;
}


EngineList* engine_list_new (void) {
	return engine_list_construct (TYPE_ENGINE_LIST);
}


static void value_engine_list_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_engine_list_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		engine_list_unref (value->data[0].v_pointer);
	}
}


static void value_engine_list_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = engine_list_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_engine_list_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_engine_list_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		EngineList * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = engine_list_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_engine_list_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	EngineList ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = engine_list_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_engine_list (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecEngineList* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ENGINE_LIST), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_engine_list (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENGINE_LIST), NULL);
	return value->data[0].v_pointer;
}


void value_set_engine_list (GValue* value, gpointer v_object) {
	EngineList * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENGINE_LIST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENGINE_LIST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		engine_list_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		engine_list_unref (old);
	}
}


void value_take_engine_list (GValue* value, gpointer v_object) {
	EngineList * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENGINE_LIST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENGINE_LIST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		engine_list_unref (old);
	}
}


static void engine_list_class_init (EngineListClass * klass) {
	engine_list_parent_class = g_type_class_peek_parent (klass);
	((EngineListClass *) klass)->finalize = engine_list_finalize;
}


static void engine_list_instance_init (EngineList * self) {
	IBusEngineDesc** _tmp0_;
	_tmp0_ = g_new0 (IBusEngineDesc*, 0 + 1);
	self->data = _tmp0_;
	self->data_length1 = 0;
	self->_data_size_ = self->data_length1;
	self->ref_count = 1;
}


static void engine_list_finalize (EngineList * obj) {
	EngineList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ENGINE_LIST, EngineList);
	g_signal_handlers_destroy (self);
	self->data = (_vala_array_free (self->data, self->data_length1, (GDestroyNotify) g_object_unref), NULL);
}


GType engine_list_get_type (void) {
	static volatile gsize engine_list_type_id__volatile = 0;
	if (g_once_init_enter (&engine_list_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_engine_list_init, value_engine_list_free_value, value_engine_list_copy_value, value_engine_list_peek_pointer, "p", value_engine_list_collect_value, "p", value_engine_list_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (EngineListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) engine_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EngineList), 0, (GInstanceInitFunc) engine_list_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType engine_list_type_id;
		engine_list_type_id = g_type_register_fundamental (g_type_fundamental_next (), "EngineList", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&engine_list_type_id__volatile, engine_list_type_id);
	}
	return engine_list_type_id__volatile;
}


gpointer engine_list_ref (gpointer instance) {
	EngineList * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void engine_list_unref (gpointer instance) {
	EngineList * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ENGINE_LIST_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


IBusBus* get_bus (void) {
	IBusBus* result = NULL;
	IBusBus* bus = NULL;
	IBusBus* _tmp0_;
	IBusBus* _tmp1_;
	gboolean _tmp2_;
	_tmp0_ = ibus_bus_new ();
	g_object_ref_sink (_tmp0_);
	bus = _tmp0_;
	_tmp1_ = bus;
	_tmp2_ = ibus_bus_is_connected (_tmp1_);
	if (!_tmp2_) {
		result = NULL;
		_g_object_unref0 (bus);
		return result;
	}
	result = bus;
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _engine_list_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (engine_list_unref (var), NULL));
}


static gpointer _engine_list_ref0 (gpointer self) {
	return self ? engine_list_ref (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_array_add1 (IBusEngineDesc** * array, int* length, int* size, IBusEngineDesc* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (IBusEngineDesc*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gint list_engine (gchar** argv, int argv_length1) {
	gint result = 0;
	static const GOptionEntry options[] = {{"name-only", (gchar) 0, 0, G_OPTION_ARG_NONE, &name_only, N_ ("List engine name only"), NULL}, {NULL}};
	GOptionContext* option = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	IBusBus* bus = NULL;
	IBusBus* _tmp8_;
	IBusBus* _tmp9_;
	GList* engines = NULL;
	IBusBus* _tmp11_;
	GList* _tmp12_;
	gboolean _tmp13_;
	GHashTable* map = NULL;
	GHashFunc _tmp17_;
	GEqualFunc _tmp18_;
	GHashTable* _tmp19_;
	GList* _tmp20_;
	GHashTable* _tmp39_;
	GList* _tmp40_;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_option_context_new (NULL);
	option = _tmp0_;
	_tmp1_ = option;
	g_option_context_add_main_entries (_tmp1_, options, GETTEXT_PACKAGE);
	{
		GOptionContext* _tmp2_;
		_tmp2_ = option;
		g_option_context_parse (_tmp2_, &argv_length1, &argv, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp3_ = 0;
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (option);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp3_;
		}
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		fprintf (_tmp4_, "%s\n", _tmp6_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (option);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp7_ = 0;
		_g_option_context_free0 (option);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp7_;
	}
	_tmp8_ = get_bus ();
	bus = _tmp8_;
	_tmp9_ = bus;
	if (_tmp9_ == NULL) {
		FILE* _tmp10_;
		_tmp10_ = stderr;
		fprintf (_tmp10_, "%s", _ ("Can't connect to IBus.\n"));
		result = EXIT_FAILURE;
		_g_object_unref0 (bus);
		_g_option_context_free0 (option);
		return result;
	}
	_tmp11_ = bus;
	_tmp12_ = ibus_bus_list_engines (_tmp11_);
	engines = _tmp12_;
	_tmp13_ = name_only;
	if (_tmp13_) {
		GList* _tmp14_;
		_tmp14_ = engines;
		{
			GList* engine_collection = NULL;
			GList* engine_it = NULL;
			engine_collection = _tmp14_;
			for (engine_it = engine_collection; engine_it != NULL; engine_it = engine_it->next) {
				IBusEngineDesc* engine = NULL;
				engine = (IBusEngineDesc*) engine_it->data;
				{
					IBusEngineDesc* _tmp15_;
					const gchar* _tmp16_;
					_tmp15_ = engine;
					_tmp16_ = ibus_engine_desc_get_name (_tmp15_);
					g_print ("%s\n", _tmp16_);
				}
			}
		}
		result = EXIT_SUCCESS;
		_g_list_free0 (engines);
		_g_object_unref0 (bus);
		_g_option_context_free0 (option);
		return result;
	}
	_tmp17_ = g_str_hash;
	_tmp18_ = g_str_equal;
	_tmp19_ = g_hash_table_new_full (_tmp17_, _tmp18_, _g_free0_, _engine_list_unref0_);
	map = _tmp19_;
	_tmp20_ = engines;
	{
		GList* engine_collection = NULL;
		GList* engine_it = NULL;
		engine_collection = _tmp20_;
		for (engine_it = engine_collection; engine_it != NULL; engine_it = engine_it->next) {
			IBusEngineDesc* engine = NULL;
			engine = (IBusEngineDesc*) engine_it->data;
			{
				EngineList* list = NULL;
				GHashTable* _tmp21_;
				IBusEngineDesc* _tmp22_;
				const gchar* _tmp23_;
				gconstpointer _tmp24_;
				EngineList* _tmp25_;
				EngineList* _tmp26_;
				EngineList* _tmp34_;
				EngineList* _tmp35_;
				IBusEngineDesc** _tmp36_;
				gint _tmp36__length1;
				IBusEngineDesc* _tmp37_;
				IBusEngineDesc* _tmp38_;
				_tmp21_ = map;
				_tmp22_ = engine;
				_tmp23_ = ibus_engine_desc_get_language (_tmp22_);
				_tmp24_ = g_hash_table_lookup (_tmp21_, _tmp23_);
				_tmp25_ = _engine_list_ref0 ((EngineList*) _tmp24_);
				list = _tmp25_;
				_tmp26_ = list;
				if (_tmp26_ == NULL) {
					EngineList* _tmp27_;
					GHashTable* _tmp28_;
					IBusEngineDesc* _tmp29_;
					const gchar* _tmp30_;
					gchar* _tmp31_;
					EngineList* _tmp32_;
					EngineList* _tmp33_;
					_tmp27_ = engine_list_new ();
					_engine_list_unref0 (list);
					list = _tmp27_;
					_tmp28_ = map;
					_tmp29_ = engine;
					_tmp30_ = ibus_engine_desc_get_language (_tmp29_);
					_tmp31_ = g_strdup (_tmp30_);
					_tmp32_ = list;
					_tmp33_ = _engine_list_ref0 (_tmp32_);
					g_hash_table_insert (_tmp28_, _tmp31_, _tmp33_);
				}
				_tmp34_ = list;
				_tmp35_ = list;
				_tmp36_ = _tmp35_->data;
				_tmp36__length1 = _tmp35_->data_length1;
				_tmp37_ = engine;
				_tmp38_ = _g_object_ref0 (_tmp37_);
				_vala_array_add1 (&_tmp34_->data, &_tmp34_->data_length1, &_tmp34_->_data_size_, _tmp38_);
				_engine_list_unref0 (list);
			}
		}
	}
	_tmp39_ = map;
	_tmp40_ = g_hash_table_get_keys (_tmp39_);
	{
		GList* language_collection = NULL;
		GList* language_it = NULL;
		language_collection = _tmp40_;
		for (language_it = language_collection; language_it != NULL; language_it = language_it->next) {
			const gchar* language = NULL;
			language = (const gchar*) language_it->data;
			{
				EngineList* list = NULL;
				GHashTable* _tmp41_;
				const gchar* _tmp42_;
				gconstpointer _tmp43_;
				EngineList* _tmp44_;
				const gchar* _tmp45_;
				const gchar* _tmp46_;
				EngineList* _tmp47_;
				IBusEngineDesc** _tmp48_;
				gint _tmp48__length1;
				_tmp41_ = map;
				_tmp42_ = language;
				_tmp43_ = g_hash_table_lookup (_tmp41_, _tmp42_);
				_tmp44_ = _engine_list_ref0 ((EngineList*) _tmp43_);
				list = _tmp44_;
				_tmp45_ = language;
				_tmp46_ = ibus_get_language_name (_tmp45_);
				g_print (_ ("language: %s\n"), _tmp46_);
				_tmp47_ = list;
				_tmp48_ = _tmp47_->data;
				_tmp48__length1 = _tmp47_->data_length1;
				{
					IBusEngineDesc** engine_collection = NULL;
					gint engine_collection_length1 = 0;
					gint _engine_collection_size_ = 0;
					gint engine_it = 0;
					engine_collection = _tmp48_;
					engine_collection_length1 = _tmp48__length1;
					for (engine_it = 0; engine_it < _tmp48__length1; engine_it = engine_it + 1) {
						IBusEngineDesc* _tmp49_;
						IBusEngineDesc* engine = NULL;
						_tmp49_ = _g_object_ref0 (engine_collection[engine_it]);
						engine = _tmp49_;
						{
							IBusEngineDesc* _tmp50_;
							const gchar* _tmp51_;
							IBusEngineDesc* _tmp52_;
							const gchar* _tmp53_;
							_tmp50_ = engine;
							_tmp51_ = ibus_engine_desc_get_name (_tmp50_);
							_tmp52_ = engine;
							_tmp53_ = ibus_engine_desc_get_longname (_tmp52_);
							g_print ("  %s - %s\n", _tmp51_, _tmp53_);
							_g_object_unref0 (engine);
						}
					}
				}
				_engine_list_unref0 (list);
			}
		}
		_g_list_free0 (language_collection);
	}
	result = EXIT_SUCCESS;
	_g_hash_table_unref0 (map);
	_g_list_free0 (engines);
	_g_object_unref0 (bus);
	_g_option_context_free0 (option);
	return result;
}


static void _vala_array_add2 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add3 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add4 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add5 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add6 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add7 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add8 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gint exec_setxkbmap (IBusEngineDesc* engine) {
	gint result = 0;
	gchar* layout = NULL;
	IBusEngineDesc* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* variant = NULL;
	IBusEngineDesc* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* option = NULL;
	IBusEngineDesc* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* standard_error = NULL;
	gint exit_status = 0;
	gchar** args = NULL;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gint args_length1;
	gint _args_size_;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	const gchar* _tmp23_;
	gboolean _tmp31_ = FALSE;
	gboolean _tmp32_ = FALSE;
	const gchar* _tmp33_;
	gchar** _tmp43_;
	gint _tmp43__length1;
	gint _tmp55_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (engine != NULL, 0);
	_tmp0_ = engine;
	_tmp1_ = ibus_engine_desc_get_layout (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	layout = _tmp2_;
	_tmp3_ = engine;
	_tmp4_ = ibus_engine_desc_get_layout_variant (_tmp3_);
	_tmp5_ = g_strdup (_tmp4_);
	variant = _tmp5_;
	_tmp6_ = engine;
	_tmp7_ = ibus_engine_desc_get_layout_option (_tmp6_);
	_tmp8_ = g_strdup (_tmp7_);
	option = _tmp8_;
	standard_error = NULL;
	exit_status = 0;
	_tmp9_ = g_strdup ("setxkbmap");
	_tmp10_ = g_new0 (gchar*, 1 + 1);
	_tmp10_[0] = _tmp9_;
	args = _tmp10_;
	args_length1 = 1;
	_args_size_ = args_length1;
	_tmp13_ = layout;
	if (_tmp13_ != NULL) {
		const gchar* _tmp14_;
		_tmp14_ = layout;
		_tmp12_ = g_strcmp0 (_tmp14_, "") != 0;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		const gchar* _tmp15_;
		_tmp15_ = layout;
		_tmp11_ = g_strcmp0 (_tmp15_, "default") != 0;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		gchar** _tmp16_;
		gint _tmp16__length1;
		gchar* _tmp17_;
		gchar** _tmp18_;
		gint _tmp18__length1;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp16_ = args;
		_tmp16__length1 = args_length1;
		_tmp17_ = g_strdup ("-layout");
		_vala_array_add2 (&args, &args_length1, &_args_size_, _tmp17_);
		_tmp18_ = args;
		_tmp18__length1 = args_length1;
		_tmp19_ = layout;
		_tmp20_ = g_strdup (_tmp19_);
		_vala_array_add3 (&args, &args_length1, &_args_size_, _tmp20_);
	}
	_tmp23_ = variant;
	if (_tmp23_ != NULL) {
		const gchar* _tmp24_;
		_tmp24_ = variant;
		_tmp22_ = g_strcmp0 (_tmp24_, "") != 0;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		const gchar* _tmp25_;
		_tmp25_ = variant;
		_tmp21_ = g_strcmp0 (_tmp25_, "default") != 0;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		gchar** _tmp26_;
		gint _tmp26__length1;
		gchar* _tmp27_;
		gchar** _tmp28_;
		gint _tmp28__length1;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		_tmp26_ = args;
		_tmp26__length1 = args_length1;
		_tmp27_ = g_strdup ("-variant");
		_vala_array_add4 (&args, &args_length1, &_args_size_, _tmp27_);
		_tmp28_ = args;
		_tmp28__length1 = args_length1;
		_tmp29_ = variant;
		_tmp30_ = g_strdup (_tmp29_);
		_vala_array_add5 (&args, &args_length1, &_args_size_, _tmp30_);
	}
	_tmp33_ = option;
	if (_tmp33_ != NULL) {
		const gchar* _tmp34_;
		_tmp34_ = option;
		_tmp32_ = g_strcmp0 (_tmp34_, "") != 0;
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		const gchar* _tmp35_;
		_tmp35_ = option;
		_tmp31_ = g_strcmp0 (_tmp35_, "default") != 0;
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		gchar** _tmp36_;
		gint _tmp36__length1;
		gchar* _tmp37_;
		gchar** _tmp38_;
		gint _tmp38__length1;
		gchar* _tmp39_;
		gchar** _tmp40_;
		gint _tmp40__length1;
		const gchar* _tmp41_;
		gchar* _tmp42_;
		_tmp36_ = args;
		_tmp36__length1 = args_length1;
		_tmp37_ = g_strdup ("-option");
		_vala_array_add6 (&args, &args_length1, &_args_size_, _tmp37_);
		_tmp38_ = args;
		_tmp38__length1 = args_length1;
		_tmp39_ = g_strdup ("-option");
		_vala_array_add7 (&args, &args_length1, &_args_size_, _tmp39_);
		_tmp40_ = args;
		_tmp40__length1 = args_length1;
		_tmp41_ = option;
		_tmp42_ = g_strdup (_tmp41_);
		_vala_array_add8 (&args, &args_length1, &_args_size_, _tmp42_);
	}
	_tmp43_ = args;
	_tmp43__length1 = args_length1;
	if (_tmp43__length1 == 1) {
		result = EXIT_FAILURE;
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (standard_error);
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		return result;
	}
	{
		gboolean _tmp44_ = FALSE;
		gchar** _tmp45_;
		gint _tmp45__length1;
		gchar* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		gboolean _tmp48_;
		_tmp45_ = args;
		_tmp45__length1 = args_length1;
		_tmp48_ = g_spawn_sync (NULL, _tmp45_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_tmp46_, &_tmp47_, &_inner_error_);
		_g_free0 (standard_error);
		standard_error = _tmp46_;
		exit_status = _tmp47_;
		_tmp44_ = _tmp48_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp49_ = 0;
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch1_g_spawn_error;
			}
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (standard_error);
			_g_free0 (option);
			_g_free0 (variant);
			_g_free0 (layout);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp49_;
		}
		if (!_tmp44_) {
			IBusEngineDesc* _tmp50_;
			const gchar* _tmp51_;
			_tmp50_ = engine;
			_tmp51_ = ibus_engine_desc_get_layout (_tmp50_);
			g_warning ("main.vala:138: Switch xkb layout to %s failed.", _tmp51_);
			result = EXIT_FAILURE;
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (standard_error);
			_g_free0 (option);
			_g_free0 (variant);
			_g_free0 (layout);
			return result;
		}
	}
	goto __finally1;
	__catch1_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp52_;
		const gchar* _tmp53_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp52_ = e;
		_tmp53_ = _tmp52_->message;
		g_warning ("main.vala:143: Execute setxkbmap failed: %s", _tmp53_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (standard_error);
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp54_ = 0;
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (standard_error);
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp54_;
	}
	_tmp55_ = exit_status;
	if (_tmp55_ != 0) {
		const gchar* _tmp56_ = NULL;
		const gchar* _tmp57_;
		_tmp57_ = standard_error;
		_tmp56_ = _tmp57_;
		if (_tmp56_ == NULL) {
			_tmp56_ = "(null)";
		}
		g_warning ("main.vala:148: Execute setxkbmap failed: %s", _tmp56_);
		result = EXIT_FAILURE;
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (standard_error);
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		return result;
	}
	result = EXIT_SUCCESS;
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (standard_error);
	_g_free0 (option);
	_g_free0 (variant);
	_g_free0 (layout);
	return result;
}


gint get_set_engine (gchar** argv, int argv_length1) {
	gint result = 0;
	IBusBus* bus = NULL;
	IBusBus* _tmp0_;
	gchar* engine = NULL;
	gchar** _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp5_;
	IBusBus* _tmp12_;
	const gchar* _tmp13_;
	gboolean _tmp14_;
	IBusEngineDesc* desc = NULL;
	IBusBus* _tmp16_;
	IBusEngineDesc* _tmp17_;
	IBusEngineDesc* _tmp18_;
	GSettings* settings = NULL;
	GSettings* _tmp20_;
	GSettings* _tmp21_;
	gboolean _tmp22_;
	_tmp0_ = get_bus ();
	bus = _tmp0_;
	engine = NULL;
	_tmp1_ = argv;
	_tmp1__length1 = argv_length1;
	if (_tmp1__length1 > 1) {
		gchar** _tmp2_;
		gint _tmp2__length1;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = argv;
		_tmp2__length1 = argv_length1;
		_tmp3_ = _tmp2_[1];
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (engine);
		engine = _tmp4_;
	}
	_tmp5_ = engine;
	if (_tmp5_ == NULL) {
		IBusEngineDesc* desc = NULL;
		IBusBus* _tmp6_;
		IBusEngineDesc* _tmp7_;
		IBusEngineDesc* _tmp8_;
		IBusEngineDesc* _tmp10_;
		const gchar* _tmp11_;
		_tmp6_ = bus;
		_tmp7_ = ibus_bus_get_global_engine (_tmp6_);
		desc = _tmp7_;
		_tmp8_ = desc;
		if (_tmp8_ == NULL) {
			FILE* _tmp9_;
			_tmp9_ = stderr;
			fprintf (_tmp9_, "%s", _ ("No engine is set.\n"));
			result = EXIT_FAILURE;
			_g_object_unref0 (desc);
			_g_free0 (engine);
			_g_object_unref0 (bus);
			return result;
		}
		_tmp10_ = desc;
		_tmp11_ = ibus_engine_desc_get_name (_tmp10_);
		g_print ("%s\n", _tmp11_);
		result = EXIT_SUCCESS;
		_g_object_unref0 (desc);
		_g_free0 (engine);
		_g_object_unref0 (bus);
		return result;
	}
	_tmp12_ = bus;
	_tmp13_ = engine;
	_tmp14_ = ibus_bus_set_global_engine (_tmp12_, _tmp13_);
	if (!_tmp14_) {
		FILE* _tmp15_;
		_tmp15_ = stderr;
		fprintf (_tmp15_, "%s", _ ("Set global engine failed.\n"));
		result = EXIT_FAILURE;
		_g_free0 (engine);
		_g_object_unref0 (bus);
		return result;
	}
	_tmp16_ = bus;
	_tmp17_ = ibus_bus_get_global_engine (_tmp16_);
	desc = _tmp17_;
	_tmp18_ = desc;
	if (_tmp18_ == NULL) {
		FILE* _tmp19_;
		_tmp19_ = stderr;
		fprintf (_tmp19_, "%s", _ ("Get global engine failed.\n"));
		result = EXIT_FAILURE;
		_g_object_unref0 (desc);
		_g_free0 (engine);
		_g_object_unref0 (bus);
		return result;
	}
	_tmp20_ = g_settings_new (IBUS_SCHEMAS_GENERAL);
	settings = _tmp20_;
	_tmp21_ = settings;
	_tmp22_ = g_settings_get_boolean (_tmp21_, "use-system-keyboard-layout");
	if (!_tmp22_) {
		IBusEngineDesc* _tmp23_;
		gint _tmp24_;
		_tmp23_ = desc;
		_tmp24_ = exec_setxkbmap (_tmp23_);
		result = _tmp24_;
		_g_object_unref0 (settings);
		_g_object_unref0 (desc);
		_g_free0 (engine);
		_g_object_unref0 (bus);
		return result;
	}
	result = EXIT_SUCCESS;
	_g_object_unref0 (settings);
	_g_object_unref0 (desc);
	_g_free0 (engine);
	_g_object_unref0 (bus);
	return result;
}


gint message_watch (gchar** argv, int argv_length1) {
	gint result = 0;
	result = EXIT_SUCCESS;
	return result;
}


gint restart_daemon (gchar** argv, int argv_length1) {
	gint result = 0;
	IBusBus* bus = NULL;
	IBusBus* _tmp0_;
	IBusBus* _tmp1_;
	IBusBus* _tmp3_;
	_tmp0_ = get_bus ();
	bus = _tmp0_;
	_tmp1_ = bus;
	if (_tmp1_ == NULL) {
		FILE* _tmp2_;
		_tmp2_ = stderr;
		fprintf (_tmp2_, "%s", _ ("Can't connect to IBus.\n"));
		result = EXIT_FAILURE;
		_g_object_unref0 (bus);
		return result;
	}
	_tmp3_ = bus;
	ibus_bus_exit (_tmp3_, TRUE);
	result = EXIT_SUCCESS;
	_g_object_unref0 (bus);
	return result;
}


gint exit_daemon (gchar** argv, int argv_length1) {
	gint result = 0;
	IBusBus* bus = NULL;
	IBusBus* _tmp0_;
	IBusBus* _tmp1_;
	IBusBus* _tmp3_;
	_tmp0_ = get_bus ();
	bus = _tmp0_;
	_tmp1_ = bus;
	if (_tmp1_ == NULL) {
		FILE* _tmp2_;
		_tmp2_ = stderr;
		fprintf (_tmp2_, "%s", _ ("Can't connect to IBus.\n"));
		result = EXIT_FAILURE;
		_g_object_unref0 (bus);
		return result;
	}
	_tmp3_ = bus;
	ibus_bus_exit (_tmp3_, FALSE);
	result = EXIT_SUCCESS;
	_g_object_unref0 (bus);
	return result;
}


gint print_version (gchar** argv, int argv_length1) {
	gint result = 0;
	g_print ("IBus %s\n", PACKAGE_VERSION);
	result = EXIT_SUCCESS;
	return result;
}


gint read_cache (gchar** argv, int argv_length1) {
	gint result = 0;
	static const GOptionEntry options[] = {{"system", (gchar) 0, 0, G_OPTION_ARG_NONE, &is_system, N_ ("Read the system registry cache."), NULL}, {"file", (gchar) 0, 0, G_OPTION_ARG_STRING, &cache_file, N_ ("Read the registry cache FILE."), "FILE"}, {NULL}};
	GOptionContext* option = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	IBusRegistry* registry = NULL;
	IBusRegistry* _tmp8_;
	const gchar* _tmp9_;
	GString* output = NULL;
	GString* _tmp18_;
	IBusRegistry* _tmp19_;
	GString* _tmp20_;
	GString* _tmp21_;
	const gchar* _tmp22_;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_option_context_new (NULL);
	option = _tmp0_;
	_tmp1_ = option;
	g_option_context_add_main_entries (_tmp1_, options, GETTEXT_PACKAGE);
	{
		GOptionContext* _tmp2_;
		_tmp2_ = option;
		g_option_context_parse (_tmp2_, &argv_length1, &argv, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp3_ = 0;
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch2_g_option_error;
			}
			_g_option_context_free0 (option);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp3_;
		}
	}
	goto __finally2;
	__catch2_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		fprintf (_tmp4_, "%s\n", _tmp6_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (option);
		return result;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp7_ = 0;
		_g_option_context_free0 (option);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp7_;
	}
	_tmp8_ = ibus_registry_new ();
	g_object_ref_sink (_tmp8_);
	registry = _tmp8_;
	_tmp9_ = cache_file;
	if (_tmp9_ != NULL) {
		IBusRegistry* _tmp10_;
		const gchar* _tmp11_;
		gboolean _tmp12_;
		_tmp10_ = registry;
		_tmp11_ = cache_file;
		_tmp12_ = ibus_registry_load_cache_file (_tmp10_, _tmp11_);
		if (!_tmp12_) {
			FILE* _tmp13_;
			_tmp13_ = stderr;
			fprintf (_tmp13_, "%s", _ ("The registry cache is invalid.\n"));
			result = EXIT_FAILURE;
			_g_object_unref0 (registry);
			_g_option_context_free0 (option);
			return result;
		}
	} else {
		IBusRegistry* _tmp14_;
		gboolean _tmp15_;
		gboolean _tmp16_;
		_tmp14_ = registry;
		_tmp15_ = is_system;
		_tmp16_ = ibus_registry_load_cache (_tmp14_, !_tmp15_);
		if (!_tmp16_) {
			FILE* _tmp17_;
			_tmp17_ = stderr;
			fprintf (_tmp17_, "%s", _ ("The registry cache is invalid.\n"));
			result = EXIT_FAILURE;
			_g_object_unref0 (registry);
			_g_option_context_free0 (option);
			return result;
		}
	}
	_tmp18_ = g_string_new ("");
	output = _tmp18_;
	_tmp19_ = registry;
	_tmp20_ = output;
	ibus_registry_output (_tmp19_, _tmp20_, 1);
	_tmp21_ = output;
	_tmp22_ = _tmp21_->str;
	g_print ("%s\n", _tmp22_);
	result = EXIT_SUCCESS;
	_g_string_free0 (output);
	_g_object_unref0 (registry);
	_g_option_context_free0 (option);
	return result;
}


gint write_cache (gchar** argv, int argv_length1) {
	gint result = 0;
	static const GOptionEntry options[] = {{"system", (gchar) 0, 0, G_OPTION_ARG_NONE, &is_system, N_ ("Write the system registry cache."), NULL}, {"file", (gchar) 0, 0, G_OPTION_ARG_STRING, &cache_file, N_ ("Write the registry cache FILE."), "FILE"}, {NULL}};
	GOptionContext* option = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	IBusRegistry* registry = NULL;
	IBusRegistry* _tmp8_;
	IBusRegistry* _tmp9_;
	const gchar* _tmp10_;
	gint _tmp15_ = 0;
	IBusRegistry* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_option_context_new (NULL);
	option = _tmp0_;
	_tmp1_ = option;
	g_option_context_add_main_entries (_tmp1_, options, GETTEXT_PACKAGE);
	{
		GOptionContext* _tmp2_;
		_tmp2_ = option;
		g_option_context_parse (_tmp2_, &argv_length1, &argv, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp3_ = 0;
			if (_inner_error_->domain == G_OPTION_ERROR) {
				goto __catch3_g_option_error;
			}
			_g_option_context_free0 (option);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp3_;
		}
	}
	goto __finally3;
	__catch3_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		fprintf (_tmp4_, "%s\n", _tmp6_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (option);
		return result;
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp7_ = 0;
		_g_option_context_free0 (option);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp7_;
	}
	_tmp8_ = ibus_registry_new ();
	g_object_ref_sink (_tmp8_);
	registry = _tmp8_;
	_tmp9_ = registry;
	ibus_registry_load (_tmp9_);
	_tmp10_ = cache_file;
	if (_tmp10_ != NULL) {
		gint _tmp11_ = 0;
		IBusRegistry* _tmp12_;
		const gchar* _tmp13_;
		gboolean _tmp14_;
		_tmp12_ = registry;
		_tmp13_ = cache_file;
		_tmp14_ = ibus_registry_save_cache_file (_tmp12_, _tmp13_);
		if (_tmp14_) {
			_tmp11_ = EXIT_SUCCESS;
		} else {
			_tmp11_ = EXIT_FAILURE;
		}
		result = _tmp11_;
		_g_object_unref0 (registry);
		_g_option_context_free0 (option);
		return result;
	}
	_tmp16_ = registry;
	_tmp17_ = is_system;
	_tmp18_ = ibus_registry_save_cache (_tmp16_, !_tmp17_);
	if (_tmp18_) {
		_tmp15_ = EXIT_SUCCESS;
	} else {
		_tmp15_ = EXIT_FAILURE;
	}
	result = _tmp15_;
	_g_object_unref0 (registry);
	_g_option_context_free0 (option);
	return result;
}


gint print_address (gchar** argv, int argv_length1) {
	gint result = 0;
	gchar* address = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_;
	_tmp0_ = ibus_get_address ();
	_tmp1_ = g_strdup (_tmp0_);
	address = _tmp1_;
	_tmp3_ = address;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = address;
		_tmp2_ = _tmp4_;
	} else {
		_tmp2_ = "(null)";
	}
	g_print ("%s\n", _tmp2_);
	result = EXIT_SUCCESS;
	_g_free0 (address);
	return result;
}


gint read_config (gchar** argv, int argv_length1) {
	gint result = 0;
	GString* output = NULL;
	GString* _tmp0_;
	GString* _tmp18_;
	const gchar* _tmp19_;
	_tmp0_ = g_string_new ("");
	output = _tmp0_;
	{
		const gchar** schema_collection = NULL;
		gint schema_collection_length1 = 0;
		gint _schema_collection_size_ = 0;
		gint schema_it = 0;
		schema_collection = IBUS_SCHEMAS;
		schema_collection_length1 = G_N_ELEMENTS (IBUS_SCHEMAS);
		for (schema_it = 0; schema_it < G_N_ELEMENTS (IBUS_SCHEMAS); schema_it = schema_it + 1) {
			gchar* _tmp1_;
			gchar* schema = NULL;
			_tmp1_ = g_strdup (schema_collection[schema_it]);
			schema = _tmp1_;
			{
				GSettings* settings = NULL;
				const gchar* _tmp2_;
				GSettings* _tmp3_;
				GString* _tmp4_;
				const gchar* _tmp5_;
				GSettings* _tmp6_;
				gchar** _tmp7_;
				gchar** _tmp8_;
				_tmp2_ = schema;
				_tmp3_ = g_settings_new (_tmp2_);
				settings = _tmp3_;
				_tmp4_ = output;
				_tmp5_ = schema;
				g_string_append_printf (_tmp4_, "SCHEMA: %s\n", _tmp5_);
				_tmp6_ = settings;
				_tmp8_ = _tmp7_ = g_settings_list_keys (_tmp6_);
				{
					gchar** key_collection = NULL;
					gint key_collection_length1 = 0;
					gint _key_collection_size_ = 0;
					gint key_it = 0;
					key_collection = _tmp8_;
					key_collection_length1 = _vala_array_length (_tmp7_);
					for (key_it = 0; key_it < _vala_array_length (_tmp7_); key_it = key_it + 1) {
						gchar* _tmp9_;
						gchar* key = NULL;
						_tmp9_ = g_strdup (key_collection[key_it]);
						key = _tmp9_;
						{
							GVariant* variant = NULL;
							GSettings* _tmp10_;
							const gchar* _tmp11_;
							GVariant* _tmp12_;
							GString* _tmp13_;
							const gchar* _tmp14_;
							GVariant* _tmp15_;
							gchar* _tmp16_;
							gchar* _tmp17_;
							_tmp10_ = settings;
							_tmp11_ = key;
							_tmp12_ = g_settings_get_value (_tmp10_, _tmp11_);
							variant = _tmp12_;
							_tmp13_ = output;
							_tmp14_ = key;
							_tmp15_ = variant;
							_tmp16_ = g_variant_print (_tmp15_, TRUE);
							_tmp17_ = _tmp16_;
							g_string_append_printf (_tmp13_, "  %s: %s\n", _tmp14_, _tmp17_);
							_g_free0 (_tmp17_);
							_g_variant_unref0 (variant);
							_g_free0 (key);
						}
					}
					key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
				}
				_g_object_unref0 (settings);
				_g_free0 (schema);
			}
		}
	}
	_tmp18_ = output;
	_tmp19_ = _tmp18_->str;
	g_print ("%s", _tmp19_);
	result = EXIT_SUCCESS;
	_g_string_free0 (output);
	return result;
}


gint reset_config (gchar** argv, int argv_length1) {
	gint result = 0;
	g_print ("%s\n", _ ("Resetting…"));
	{
		const gchar** schema_collection = NULL;
		gint schema_collection_length1 = 0;
		gint _schema_collection_size_ = 0;
		gint schema_it = 0;
		schema_collection = IBUS_SCHEMAS;
		schema_collection_length1 = G_N_ELEMENTS (IBUS_SCHEMAS);
		for (schema_it = 0; schema_it < G_N_ELEMENTS (IBUS_SCHEMAS); schema_it = schema_it + 1) {
			gchar* _tmp0_;
			gchar* schema = NULL;
			_tmp0_ = g_strdup (schema_collection[schema_it]);
			schema = _tmp0_;
			{
				GSettings* settings = NULL;
				const gchar* _tmp1_;
				GSettings* _tmp2_;
				const gchar* _tmp3_;
				GSettings* _tmp4_;
				gchar** _tmp5_;
				gchar** _tmp6_;
				_tmp1_ = schema;
				_tmp2_ = g_settings_new (_tmp1_);
				settings = _tmp2_;
				_tmp3_ = schema;
				g_print ("SCHEMA: %s\n", _tmp3_);
				_tmp4_ = settings;
				_tmp6_ = _tmp5_ = g_settings_list_keys (_tmp4_);
				{
					gchar** key_collection = NULL;
					gint key_collection_length1 = 0;
					gint _key_collection_size_ = 0;
					gint key_it = 0;
					key_collection = _tmp6_;
					key_collection_length1 = _vala_array_length (_tmp5_);
					for (key_it = 0; key_it < _vala_array_length (_tmp5_); key_it = key_it + 1) {
						gchar* _tmp7_;
						gchar* key = NULL;
						_tmp7_ = g_strdup (key_collection[key_it]);
						key = _tmp7_;
						{
							const gchar* _tmp8_;
							GSettings* _tmp9_;
							const gchar* _tmp10_;
							_tmp8_ = key;
							g_print ("  %s\n", _tmp8_);
							_tmp9_ = settings;
							_tmp10_ = key;
							g_settings_reset (_tmp9_, _tmp10_);
							_g_free0 (key);
						}
					}
					key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
				}
				_g_object_unref0 (settings);
				_g_free0 (schema);
			}
		}
	}
	g_settings_sync ();
	g_print ("%s\n", _ ("Done"));
	result = EXIT_SUCCESS;
	return result;
}


gint emoji_dialog (gchar** argv, int argv_length1) {
	gint result = 0;
	gchar* cmd = NULL;
	gchar* _tmp0_;
	GFile* file = NULL;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gboolean _tmp4_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar** env = NULL;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint env_length1;
	gint _env_size_;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_strdup (LIBEXECDIR "/ibus-ui-emojier");
	cmd = _tmp0_;
	_tmp1_ = cmd;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	file = _tmp2_;
	_tmp3_ = file;
	_tmp4_ = g_file_query_exists (_tmp3_, NULL);
	if (!_tmp4_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("../ui/gtk3/ibus-ui-emojier");
		_g_free0 (cmd);
		cmd = _tmp5_;
	}
	_tmp6_ = argv;
	_tmp6__length1 = argv_length1;
	_tmp7_ = cmd;
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (_tmp6_[0]);
	_tmp6_[0] = _tmp8_;
	_tmp9_ = _tmp6_[0];
	_tmp11_ = _tmp10_ = g_get_environ ();
	env = _tmp11_;
	env_length1 = _vala_array_length (_tmp10_);
	_env_size_ = env_length1;
	{
		gchar** _tmp12_;
		gint _tmp12__length1;
		gchar** _tmp13_;
		gint _tmp13__length1;
		_tmp12_ = argv;
		_tmp12__length1 = argv_length1;
		_tmp13_ = env;
		_tmp13__length1 = env_length1;
		g_spawn_async (NULL, _tmp12_, _tmp13_, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gint _tmp14_ = 0;
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch4_g_spawn_error;
			}
			env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (file);
			_g_free0 (cmd);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp14_;
		}
	}
	goto __finally4;
	__catch4_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp15_;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = stderr;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		fprintf (_tmp15_, "%s\n", _tmp17_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (file);
		_g_free0 (cmd);
		return result;
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gint _tmp18_ = 0;
		env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (file);
		_g_free0 (cmd);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp18_;
	}
	result = EXIT_SUCCESS;
	env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (file);
	_g_free0 (cmd);
	return result;
}


gint print_help (gchar** argv, int argv_length1) {
	gint result = 0;
	FILE* _tmp0_;
	_tmp0_ = stdout;
	print_usage (_tmp0_);
	result = EXIT_SUCCESS;
	return result;
}


CommandEntry* command_entry_dup (const CommandEntry* self) {
	CommandEntry* dup;
	dup = g_new0 (CommandEntry, 1);
	memcpy (dup, self, sizeof (CommandEntry));
	return dup;
}


void command_entry_free (CommandEntry* self) {
	g_free (self);
}


GType command_entry_get_type (void) {
	static volatile gsize command_entry_type_id__volatile = 0;
	if (g_once_init_enter (&command_entry_type_id__volatile)) {
		GType command_entry_type_id;
		command_entry_type_id = g_boxed_type_register_static ("CommandEntry", (GBoxedCopyFunc) command_entry_dup, (GBoxedFreeFunc) command_entry_free);
		g_once_init_leave (&command_entry_type_id__volatile, command_entry_type_id);
	}
	return command_entry_type_id__volatile;
}


static gint _get_set_engine_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = get_set_engine (argv, argv_length1);
	return result;
}


static gint _exit_daemon_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = exit_daemon (argv, argv_length1);
	return result;
}


static gint _list_engine_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = list_engine (argv, argv_length1);
	return result;
}


static gint _message_watch_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = message_watch (argv, argv_length1);
	return result;
}


static gint _restart_daemon_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = restart_daemon (argv, argv_length1);
	return result;
}


static gint _print_version_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = print_version (argv, argv_length1);
	return result;
}


static gint _read_cache_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = read_cache (argv, argv_length1);
	return result;
}


static gint _write_cache_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = write_cache (argv, argv_length1);
	return result;
}


static gint _print_address_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = print_address (argv, argv_length1);
	return result;
}


static gint _read_config_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = read_config (argv, argv_length1);
	return result;
}


static gint _reset_config_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = reset_config (argv, argv_length1);
	return result;
}


static gint _emoji_dialog_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = emoji_dialog (argv, argv_length1);
	return result;
}


static gint _print_help_entry_func (gchar** argv, int argv_length1, gpointer self) {
	gint result;
	result = print_help (argv, argv_length1);
	return result;
}


void print_usage (FILE* stream) {
	FILE* _tmp0_;
	const gchar* _tmp1_;
	FILE* _tmp2_;
	g_return_if_fail (stream != NULL);
	_tmp0_ = stream;
	_tmp1_ = program_name;
	fprintf (_tmp0_, _ ("Usage: %s COMMAND [OPTION...]\n\n"), _tmp1_);
	_tmp2_ = stream;
	fprintf (_tmp2_, "%s", _ ("Commands:\n"));
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				FILE* _tmp6_;
				gint _tmp7_;
				CommandEntry _tmp8_;
				const gchar* _tmp9_;
				gint _tmp10_;
				CommandEntry _tmp11_;
				const gchar* _tmp12_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				if (!(_tmp5_ < G_N_ELEMENTS (commands))) {
					break;
				}
				_tmp6_ = stream;
				_tmp7_ = i;
				_tmp8_ = commands[_tmp7_];
				_tmp9_ = _tmp8_.name;
				_tmp10_ = i;
				_tmp11_ = commands[_tmp10_];
				_tmp12_ = _tmp11_.description;
				fprintf (_tmp6_, "  %-12s    %s\n", _tmp9_, g_dgettext (NULL, _tmp12_));
			}
		}
	}
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


gint _vala_main (gchar** argv, int argv_length1) {
	gint result = 0;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** new_argv = NULL;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar** _tmp7_;
	gint _tmp7__length1;
	gint new_argv_length1;
	gint _new_argv_size_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	const gchar* _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	FILE* _tmp27_;
	gchar** _tmp28_;
	gint _tmp28__length1;
	const gchar* _tmp29_;
	FILE* _tmp30_;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, GLIB_LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	ibus_init ();
	_tmp0_ = argv;
	_tmp0__length1 = argv_length1;
	_tmp1_ = _tmp0_[0];
	_tmp2_ = g_path_get_basename (_tmp1_);
	_g_free0 (program_name);
	program_name = _tmp2_;
	_tmp3_ = argv;
	_tmp3__length1 = argv_length1;
	if (_tmp3__length1 < 2) {
		FILE* _tmp4_;
		_tmp4_ = stderr;
		print_usage (_tmp4_);
		result = EXIT_FAILURE;
		return result;
	}
	_tmp5_ = argv;
	_tmp5__length1 = argv_length1;
	_tmp6_ = argv;
	_tmp6__length1 = argv_length1;
	_tmp7_ = ((_tmp5_ + 1) != NULL) ? _vala_array_dup1 (_tmp5_ + 1, _tmp6__length1 - 1) : ((gpointer) (_tmp5_ + 1));
	_tmp7__length1 = _tmp6__length1 - 1;
	new_argv = _tmp7_;
	new_argv_length1 = _tmp7__length1;
	_new_argv_size_ = new_argv_length1;
	_tmp8_ = new_argv;
	_tmp8__length1 = new_argv_length1;
	_tmp9_ = program_name;
	_tmp10_ = new_argv;
	_tmp10__length1 = new_argv_length1;
	_tmp11_ = _tmp10_[0];
	_tmp12_ = g_strdup_printf ("%s %s", _tmp9_, _tmp11_);
	_g_free0 (_tmp8_[0]);
	_tmp8_[0] = _tmp12_;
	_tmp13_ = _tmp8_[0];
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp14_ = FALSE;
			_tmp14_ = TRUE;
			while (TRUE) {
				gint _tmp16_;
				gint _tmp17_;
				CommandEntry _tmp18_;
				const gchar* _tmp19_;
				gchar** _tmp20_;
				gint _tmp20__length1;
				const gchar* _tmp21_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp14_ = FALSE;
				_tmp16_ = i;
				if (!(_tmp16_ < G_N_ELEMENTS (commands))) {
					break;
				}
				_tmp17_ = i;
				_tmp18_ = commands[_tmp17_];
				_tmp19_ = _tmp18_.name;
				_tmp20_ = argv;
				_tmp20__length1 = argv_length1;
				_tmp21_ = _tmp20_[1];
				if (g_strcmp0 (_tmp19_, _tmp21_) == 0) {
					gint _tmp22_;
					CommandEntry _tmp23_;
					EntryFunc _tmp24_;
					void* _tmp24__target;
					gchar** _tmp25_;
					gint _tmp25__length1;
					gint _tmp26_;
					_tmp22_ = i;
					_tmp23_ = commands[_tmp22_];
					_tmp24_ = _tmp23_.entry;
					_tmp24__target = _tmp23_.entry_target;
					_tmp25_ = new_argv;
					_tmp25__length1 = new_argv_length1;
					_tmp26_ = _tmp24_ (_tmp25_, _tmp25__length1, _tmp24__target);
					result = _tmp26_;
					new_argv = (_vala_array_free (new_argv, new_argv_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
			}
		}
	}
	_tmp27_ = stderr;
	_tmp28_ = argv;
	_tmp28__length1 = argv_length1;
	_tmp29_ = _tmp28_[1];
	fprintf (_tmp27_, _ ("%s is unknown command!\n"), _tmp29_);
	_tmp30_ = stderr;
	print_usage (_tmp30_);
	result = EXIT_FAILURE;
	new_argv = (_vala_array_free (new_argv, new_argv_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


int main (int argc, char ** argv) {
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



