/* switcher.c generated by valac 0.34.4, the Vala compiler
 * generated from switcher.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2011-2016 Peng Huang <shawn.p.huang@gmail.com>
 * Copyright(c) 2015-2017 Takao Fujiwara <takao.fujiwara1@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <ibus.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <atk/atk.h>
#include <pango/pango.h>
#include <cairo.h>
#include <float.h>
#include <math.h>


#define TYPE_SWITCHER (switcher_get_type ())
#define SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SWITCHER, Switcher))
#define SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SWITCHER, SwitcherClass))
#define IS_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SWITCHER))
#define IS_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SWITCHER))
#define SWITCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SWITCHER, SwitcherClass))

typedef struct _Switcher Switcher;
typedef struct _SwitcherClass SwitcherClass;
typedef struct _SwitcherPrivate SwitcherPrivate;

#define SWITCHER_TYPE_IBUS_ENGINE_BUTTON (switcher_ibus_engine_button_get_type ())
#define SWITCHER_IBUS_ENGINE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWITCHER_TYPE_IBUS_ENGINE_BUTTON, SwitcherIBusEngineButton))
#define SWITCHER_IBUS_ENGINE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWITCHER_TYPE_IBUS_ENGINE_BUTTON, SwitcherIBusEngineButtonClass))
#define SWITCHER_IS_IBUS_ENGINE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWITCHER_TYPE_IBUS_ENGINE_BUTTON))
#define SWITCHER_IS_IBUS_ENGINE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWITCHER_TYPE_IBUS_ENGINE_BUTTON))
#define SWITCHER_IBUS_ENGINE_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWITCHER_TYPE_IBUS_ENGINE_BUTTON, SwitcherIBusEngineButtonClass))

typedef struct _SwitcherIBusEngineButton SwitcherIBusEngineButton;
typedef struct _SwitcherIBusEngineButtonClass SwitcherIBusEngineButtonClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _Block9Data Block9Data;
#define __vala_GdkEventKey_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEventKey_free (var), NULL)))
typedef struct _SwitcherIBusEngineButtonPrivate SwitcherIBusEngineButtonPrivate;

#define TYPE_ICON_WIDGET (icon_widget_get_type ())
#define ICON_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ICON_WIDGET, IconWidget))
#define ICON_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ICON_WIDGET, IconWidgetClass))
#define IS_ICON_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ICON_WIDGET))
#define IS_ICON_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ICON_WIDGET))
#define ICON_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ICON_WIDGET, IconWidgetClass))

typedef struct _IconWidget IconWidget;
typedef struct _IconWidgetClass IconWidgetClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Switcher {
	GtkWindow parent_instance;
	SwitcherPrivate * priv;
};

struct _SwitcherClass {
	GtkWindowClass parent_class;
};

struct _SwitcherPrivate {
	GtkBox* m_box;
	GtkLabel* m_label;
	SwitcherIBusEngineButton** m_buttons;
	gint m_buttons_length1;
	gint _m_buttons_size_;
	IBusEngineDesc** m_engines;
	gint m_engines_length1;
	gint _m_engines_size_;
	guint m_selected_engine;
	guint m_keyval;
	guint m_modifiers;
	GdkModifierType m_primary_modifier;
	gboolean m_is_running;
	gchar* m_input_context_path;
	GMainLoop* m_loop;
	gint m_result;
	IBusEngineDesc* m_result_engine;
	guint m_popup_delay_time;
	guint m_popup_delay_time_id;
	gint m_root_x;
	gint m_root_y;
	GHashTable* m_xkb_languages;
};

struct _Block9Data {
	int _ref_count_;
	Switcher* self;
	gint index;
	SwitcherIBusEngineButton* button;
};

struct _SwitcherIBusEngineButton {
	GtkButton parent_instance;
	SwitcherIBusEngineButtonPrivate * priv;
};

struct _SwitcherIBusEngineButtonClass {
	GtkButtonClass parent_class;
};

struct _SwitcherIBusEngineButtonPrivate {
	gchar* _longname;
};


static gpointer switcher_parent_class = NULL;
static gpointer switcher_ibus_engine_button_parent_class = NULL;

GType switcher_get_type (void) G_GNUC_CONST;
static GType switcher_ibus_engine_button_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define SWITCHER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SWITCHER, SwitcherPrivate))
enum  {
	SWITCHER_DUMMY_PROPERTY
};
static void _g_free0_ (gpointer var);
Switcher* switcher_new (void);
Switcher* switcher_construct (GType object_type);
gint switcher_run (Switcher* self, guint keyval, guint state, GdkEvent* event, IBusEngineDesc** engines, int engines_length1, gint index, const gchar* input_context_path);
GdkModifierType keybinding_manager_get_primary_modifier (guint binding_mask);
#define KEYBINDING_MANAGER_MODIFIER_FILTER ((guint) (GDK_MODIFIER_MASK & (~(((((((((GDK_LOCK_MASK | GDK_MOD2_MASK) | GDK_BUTTON1_MASK) | GDK_BUTTON2_MASK) | GDK_BUTTON3_MASK) | GDK_BUTTON4_MASK) | GDK_BUTTON5_MASK) | GDK_SUPER_MASK) | GDK_HYPER_MASK) | GDK_META_MASK))))
static void switcher_update_engines (Switcher* self, IBusEngineDesc** engines, int engines_length1);
static const gchar* switcher_ibus_engine_button_get_longname (SwitcherIBusEngineButton* self);
static gboolean ___lambda22_ (Switcher* self);
static void switcher_restore_window_position (Switcher* self, const gchar* debug_str);
static gboolean ____lambda22__gsource_func (gpointer self);
static IBusEngineDesc** _vala_array_dup5 (IBusEngineDesc** self, int length);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static SwitcherIBusEngineButton* switcher_ibus_engine_button_new (IBusEngineDesc* engine, Switcher* switcher);
static SwitcherIBusEngineButton* switcher_ibus_engine_button_construct (GType object_type, IBusEngineDesc* engine, Switcher* switcher);
static gboolean _____lambda20_ (Block9Data* _data9_, GdkEventCrossing* e);
static gboolean ______lambda20__gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static gboolean _____lambda21_ (Block9Data* _data9_, GdkEventButton* e);
static gboolean ______lambda21__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void switcher_ibus_engine_button_set_longname (SwitcherIBusEngineButton* self, const gchar* value);
static void _vala_array_add24 (SwitcherIBusEngineButton*** array, int* length, int* size, SwitcherIBusEngineButton* value);
static void switcher_next_engine (Switcher* self);
static void switcher_previous_engine (Switcher* self);
static void switcher_real_show (GtkWidget* base);
static gboolean switcher_real_key_press_event (GtkWidget* base, GdkEventKey* e);
static GdkEventKey* _vala_GdkEventKey_copy (GdkEventKey* self);
static void _vala_GdkEventKey_free (GdkEventKey* self);
static gboolean switcher_real_key_release_event (GtkWidget* base, GdkEventKey* e);
gboolean keybinding_manager_primary_modifier_still_pressed (GdkEvent* event, guint primary_modifier);
void switcher_set_popup_delay_time (Switcher* self, guint popup_delay_time);
gchar* switcher_get_xkb_language (Switcher* self, IBusEngineDesc* engine);
gboolean switcher_is_running (Switcher* self);
gchar* switcher_get_input_context_path (Switcher* self);
IBusEngineDesc* switcher_get_selected_engine (Switcher* self);
void switcher_reset (Switcher* self);
#define SWITCHER_IBUS_ENGINE_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SWITCHER_TYPE_IBUS_ENGINE_BUTTON, SwitcherIBusEngineButtonPrivate))
enum  {
	SWITCHER_IBUS_ENGINE_BUTTON_DUMMY_PROPERTY,
	SWITCHER_IBUS_ENGINE_BUTTON_LONGNAME
};
GType icon_widget_get_type (void) G_GNUC_CONST;
IconWidget* icon_widget_new (const gchar* icon_name_or_path, GtkIconSize size);
IconWidget* icon_widget_construct (GType object_type, const gchar* icon_name_or_path, GtkIconSize size);
static gboolean switcher_ibus_engine_button_real_draw (GtkWidget* base, cairo_t* cr);
static void switcher_ibus_engine_button_finalize (GObject* obj);
static void _vala_switcher_ibus_engine_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_switcher_ibus_engine_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void switcher_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


Switcher* switcher_construct (GType object_type) {
	Switcher * self = NULL;
	GtkBox* vbox = NULL;
	GtkBox* _tmp0_ = NULL;
	GtkBox* _tmp1_ = NULL;
	GtkBox* _tmp2_ = NULL;
	GtkBox* _tmp3_ = NULL;
	GtkBox* _tmp4_ = NULL;
	GtkLabel* _tmp5_ = NULL;
	AtkObject* obj = NULL;
	GtkLabel* _tmp6_ = NULL;
	AtkObject* _tmp7_ = NULL;
	AtkObject* _tmp8_ = NULL;
	GtkLabel* _tmp9_ = NULL;
	GtkLabel* _tmp10_ = NULL;
	self = (Switcher*) g_object_new (object_type, "type", GTK_WINDOW_POPUP, "events", GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK, "window-position", GTK_WIN_POS_CENTER, "accept-focus", TRUE, "decorated", FALSE, "modal", TRUE, "focus-visible", TRUE, NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp0_);
	vbox = _tmp0_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) vbox);
	_tmp1_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->m_box);
	self->priv->m_box = _tmp1_;
	_tmp2_ = self->priv->m_box;
	gtk_widget_set_halign ((GtkWidget*) _tmp2_, GTK_ALIGN_CENTER);
	_tmp3_ = self->priv->m_box;
	gtk_widget_set_valign ((GtkWidget*) _tmp3_, GTK_ALIGN_CENTER);
	_tmp4_ = self->priv->m_box;
	gtk_box_pack_start (vbox, (GtkWidget*) _tmp4_, TRUE, TRUE, (guint) 0);
	_tmp5_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->m_label);
	self->priv->m_label = _tmp5_;
	_tmp6_ = self->priv->m_label;
	_tmp7_ = gtk_widget_get_accessible ((GtkWidget*) _tmp6_);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	obj = _tmp8_;
	atk_object_set_role (obj, ATK_ROLE_STATUSBAR);
	_tmp9_ = self->priv->m_label;
	gtk_misc_set_padding ((GtkMisc*) _tmp9_, 3, 3);
	_tmp10_ = self->priv->m_label;
	gtk_box_pack_end (vbox, (GtkWidget*) _tmp10_, FALSE, FALSE, (guint) 0);
	gtk_widget_grab_focus ((GtkWidget*) self);
	_g_object_unref0 (obj);
	_g_object_unref0 (vbox);
	return self;
}


Switcher* switcher_new (void) {
	return switcher_construct (TYPE_SWITCHER);
}


static gboolean ___lambda22_ (Switcher* self) {
	gboolean result = FALSE;
	switcher_restore_window_position (self, "timeout");
	result = FALSE;
	return result;
}


static gboolean ____lambda22__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda22_ ((Switcher*) self);
	return result;
}


gint switcher_run (Switcher* self, guint keyval, guint state, GdkEvent* event, IBusEngineDesc** engines, int engines_length1, gint index, const gchar* input_context_path) {
	gint result = 0;
	GMainLoop* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	IBusEngineDesc** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	GdkModifierType _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	IBusEngineDesc** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	GtkLabel* _tmp12_ = NULL;
	SwitcherIBusEngineButton** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gint _tmp14_ = 0;
	SwitcherIBusEngineButton* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	SwitcherIBusEngineButton** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	gint _tmp19_ = 0;
	SwitcherIBusEngineButton* _tmp20_ = NULL;
	GdkDevice* device = NULL;
	GdkEvent* _tmp21_ = NULL;
	GdkDevice* _tmp22_ = NULL;
	GdkDevice* _tmp23_ = NULL;
	GdkDevice* _tmp24_ = NULL;
	GdkDevice* keyboard = NULL;
	GdkDevice* pointer = NULL;
	GdkDevice* _tmp35_ = NULL;
	GdkInputSource _tmp36_ = 0;
	guint _tmp47_ = 0U;
	guint _tmp50_ = 0U;
	GdkGrabStatus status = 0;
	GdkDevice* _tmp53_ = NULL;
	GdkWindow* _tmp54_ = NULL;
	GdkGrabStatus _tmp55_ = 0;
	GdkGrabStatus _tmp56_ = 0;
	GdkDevice* _tmp58_ = NULL;
	GdkWindow* _tmp59_ = NULL;
	GdkGrabStatus _tmp60_ = 0;
	GdkGrabStatus _tmp61_ = 0;
	GMainLoop* _tmp63_ = NULL;
	GMainLoop* _tmp64_ = NULL;
	GdkDevice* _tmp65_ = NULL;
	GdkDevice* _tmp66_ = NULL;
	gint _tmp68_ = 0;
	IBusEngineDesc** _tmp69_ = NULL;
	gint _tmp69__length1 = 0;
	IBusEngineDesc** _tmp70_ = NULL;
	gint _tmp70__length1 = 0;
	gint _tmp71_ = 0;
	IBusEngineDesc* _tmp72_ = NULL;
	IBusEngineDesc* _tmp73_ = NULL;
	gint _tmp74_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (event != NULL, 0);
	g_return_val_if_fail (input_context_path != NULL, 0);
	_tmp0_ = self->priv->m_loop;
	_vala_assert (_tmp0_ == NULL, "m_loop == null");
	_tmp1_ = index;
	_tmp2_ = engines;
	_tmp2__length1 = engines_length1;
	_vala_assert (_tmp1_ < _tmp2__length1, "index < engines.length");
	self->priv->m_is_running = TRUE;
	_tmp3_ = keyval;
	self->priv->m_keyval = _tmp3_;
	_tmp4_ = state;
	self->priv->m_modifiers = _tmp4_;
	_tmp5_ = state;
	_tmp6_ = keybinding_manager_get_primary_modifier (_tmp5_ & KEYBINDING_MANAGER_MODIFIER_FILTER);
	self->priv->m_primary_modifier = _tmp6_;
	_tmp7_ = index;
	self->priv->m_result = _tmp7_;
	_tmp8_ = self->priv->m_result;
	self->priv->m_selected_engine = (guint) _tmp8_;
	_tmp9_ = input_context_path;
	_tmp10_ = g_strdup (_tmp9_);
	_g_free0 (self->priv->m_input_context_path);
	self->priv->m_input_context_path = _tmp10_;
	_g_object_unref0 (self->priv->m_result_engine);
	self->priv->m_result_engine = NULL;
	_tmp11_ = engines;
	_tmp11__length1 = engines_length1;
	switcher_update_engines (self, _tmp11_, _tmp11__length1);
	gtk_window_resize ((GtkWindow*) self, 1, 1);
	_tmp12_ = self->priv->m_label;
	_tmp13_ = self->priv->m_buttons;
	_tmp13__length1 = self->priv->m_buttons_length1;
	_tmp14_ = index;
	_tmp15_ = _tmp13_[_tmp14_];
	_tmp16_ = switcher_ibus_engine_button_get_longname (_tmp15_);
	_tmp17_ = _tmp16_;
	gtk_label_set_text (_tmp12_, _tmp17_);
	_tmp18_ = self->priv->m_buttons;
	_tmp18__length1 = self->priv->m_buttons_length1;
	_tmp19_ = index;
	_tmp20_ = _tmp18_[_tmp19_];
	gtk_widget_grab_focus ((GtkWidget*) _tmp20_);
	_tmp21_ = event;
	_tmp22_ = gdk_event_get_device (_tmp21_);
	_tmp23_ = _g_object_ref0 (_tmp22_);
	device = _tmp23_;
	_tmp24_ = device;
	if (_tmp24_ == NULL) {
		GdkDisplay* display = NULL;
		GdkDisplay* _tmp25_ = NULL;
		GdkDisplay* _tmp26_ = NULL;
		GdkDeviceManager* device_manager = NULL;
		GdkDisplay* _tmp27_ = NULL;
		GdkDeviceManager* _tmp28_ = NULL;
		GdkDeviceManager* _tmp29_ = NULL;
		GdkDeviceManager* _tmp30_ = NULL;
		GList* _tmp31_ = NULL;
		GList* _tmp32_ = NULL;
		gconstpointer _tmp33_ = NULL;
		GdkDevice* _tmp34_ = NULL;
		_tmp25_ = gtk_widget_get_display ((GtkWidget*) self);
		_tmp26_ = _g_object_ref0 (_tmp25_);
		display = _tmp26_;
		_tmp27_ = display;
		_tmp28_ = gdk_display_get_device_manager (_tmp27_);
		_tmp29_ = _g_object_ref0 (_tmp28_);
		device_manager = _tmp29_;
		_tmp30_ = device_manager;
		_tmp31_ = gdk_device_manager_list_devices (_tmp30_, GDK_DEVICE_TYPE_MASTER);
		_tmp32_ = _tmp31_;
		_tmp33_ = _tmp32_->data;
		_tmp34_ = _g_object_ref0 ((GdkDevice*) _tmp33_);
		_g_object_unref0 (device);
		device = _tmp34_;
		_g_list_free0 (_tmp32_);
		_g_object_unref0 (device_manager);
		_g_object_unref0 (display);
	}
	_tmp35_ = device;
	_tmp36_ = gdk_device_get_source (_tmp35_);
	if (_tmp36_ == GDK_SOURCE_KEYBOARD) {
		GdkDevice* _tmp37_ = NULL;
		GdkDevice* _tmp38_ = NULL;
		GdkDevice* _tmp39_ = NULL;
		GdkDevice* _tmp40_ = NULL;
		GdkDevice* _tmp41_ = NULL;
		_tmp37_ = device;
		_tmp38_ = _g_object_ref0 (_tmp37_);
		_g_object_unref0 (keyboard);
		keyboard = _tmp38_;
		_tmp39_ = device;
		_tmp40_ = gdk_device_get_associated_device (_tmp39_);
		_tmp41_ = _g_object_ref0 (_tmp40_);
		_g_object_unref0 (pointer);
		pointer = _tmp41_;
	} else {
		GdkDevice* _tmp42_ = NULL;
		GdkDevice* _tmp43_ = NULL;
		GdkDevice* _tmp44_ = NULL;
		GdkDevice* _tmp45_ = NULL;
		GdkDevice* _tmp46_ = NULL;
		_tmp42_ = device;
		_tmp43_ = _g_object_ref0 (_tmp42_);
		_g_object_unref0 (pointer);
		pointer = _tmp43_;
		_tmp44_ = device;
		_tmp45_ = gdk_device_get_associated_device (_tmp44_);
		_tmp46_ = _g_object_ref0 (_tmp45_);
		_g_object_unref0 (keyboard);
		keyboard = _tmp46_;
	}
	_tmp47_ = self->priv->m_popup_delay_time;
	if (_tmp47_ > ((guint) 0)) {
		gint _tmp48_ = 0;
		gint _tmp49_ = 0;
		gtk_window_get_position ((GtkWindow*) self, &_tmp48_, &_tmp49_);
		self->priv->m_root_x = _tmp48_;
		self->priv->m_root_y = _tmp49_;
		gtk_window_move ((GtkWindow*) self, -1000, -1000);
	}
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp50_ = self->priv->m_popup_delay_time;
	if (_tmp50_ > ((guint) 0)) {
		guint _tmp51_ = 0U;
		guint _tmp52_ = 0U;
		_tmp51_ = self->priv->m_popup_delay_time;
		_tmp52_ = g_timeout_add_full (G_PRIORITY_DEFAULT, _tmp51_, ____lambda22__gsource_func, g_object_ref (self), g_object_unref);
		self->priv->m_popup_delay_time_id = _tmp52_;
	}
	_tmp53_ = keyboard;
	_tmp54_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp55_ = gdk_device_grab (_tmp53_, _tmp54_, GDK_OWNERSHIP_NONE, TRUE, GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK, NULL, (guint32) GDK_CURRENT_TIME);
	status = _tmp55_;
	_tmp56_ = status;
	if (_tmp56_ != GDK_GRAB_SUCCESS) {
		GdkGrabStatus _tmp57_ = 0;
		_tmp57_ = status;
		g_warning ("switcher.vala:213: Grab keyboard failed! status = %d", (gint) _tmp57_);
	}
	_tmp58_ = pointer;
	_tmp59_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp60_ = gdk_device_grab (_tmp58_, _tmp59_, GDK_OWNERSHIP_NONE, TRUE, GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK, NULL, (guint32) GDK_CURRENT_TIME);
	status = _tmp60_;
	_tmp61_ = status;
	if (_tmp61_ != GDK_GRAB_SUCCESS) {
		GdkGrabStatus _tmp62_ = 0;
		_tmp62_ = status;
		g_warning ("switcher.vala:223: Grab pointer failed! status = %d", (gint) _tmp62_);
	}
	_tmp63_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->m_loop);
	self->priv->m_loop = _tmp63_;
	_tmp64_ = self->priv->m_loop;
	g_main_loop_run (_tmp64_);
	_g_main_loop_unref0 (self->priv->m_loop);
	self->priv->m_loop = NULL;
	_tmp65_ = keyboard;
	gdk_device_ungrab (_tmp65_, (guint32) GDK_CURRENT_TIME);
	_tmp66_ = pointer;
	gdk_device_ungrab (_tmp66_, (guint32) GDK_CURRENT_TIME);
	gtk_widget_hide ((GtkWidget*) self);
	while (TRUE) {
		gboolean _tmp67_ = FALSE;
		_tmp67_ = gtk_events_pending ();
		if (!_tmp67_) {
			break;
		}
		gtk_main_iteration ();
	}
	_tmp68_ = self->priv->m_result;
	_tmp69_ = self->priv->m_engines;
	_tmp69__length1 = self->priv->m_engines_length1;
	_vala_assert (_tmp68_ < _tmp69__length1, "m_result < m_engines.length");
	_tmp70_ = self->priv->m_engines;
	_tmp70__length1 = self->priv->m_engines_length1;
	_tmp71_ = self->priv->m_result;
	_tmp72_ = _tmp70_[_tmp71_];
	_tmp73_ = _g_object_ref0 (_tmp72_);
	_g_object_unref0 (self->priv->m_result_engine);
	self->priv->m_result_engine = _tmp73_;
	self->priv->m_is_running = FALSE;
	_tmp74_ = self->priv->m_result;
	result = _tmp74_;
	_g_object_unref0 (pointer);
	_g_object_unref0 (keyboard);
	_g_object_unref0 (device);
	return result;
}


static IBusEngineDesc** _vala_array_dup5 (IBusEngineDesc** self, int length) {
	IBusEngineDesc** result;
	int i;
	result = g_new0 (IBusEngineDesc*, length + 1);
	for (i = 0; i < length; i++) {
		IBusEngineDesc* _tmp0_ = NULL;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void block9_data_unref (void * _userdata_) {
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		Switcher* self;
		self = _data9_->self;
		_g_object_unref0 (_data9_->button);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}


static gboolean _____lambda20_ (Block9Data* _data9_, GdkEventCrossing* e) {
	Switcher* self;
	gboolean result = FALSE;
	SwitcherIBusEngineButton* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	self = _data9_->self;
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = _data9_->button;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
	_tmp1_ = _data9_->index;
	self->priv->m_selected_engine = (guint) _tmp1_;
	result = TRUE;
	return result;
}


static gboolean ______lambda20__gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = _____lambda20_ (self, event);
	return result;
}


static gboolean _____lambda21_ (Block9Data* _data9_, GdkEventButton* e) {
	Switcher* self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	guint _tmp1_ = 0U;
	GMainLoop* _tmp2_ = NULL;
	self = _data9_->self;
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = _data9_->index;
	self->priv->m_selected_engine = (guint) _tmp0_;
	_tmp1_ = self->priv->m_selected_engine;
	self->priv->m_result = (gint) _tmp1_;
	_tmp2_ = self->priv->m_loop;
	g_main_loop_quit (_tmp2_);
	result = TRUE;
	return result;
}


static gboolean ______lambda21__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = _____lambda21_ (self, event);
	return result;
}


static void _vala_array_add24 (SwitcherIBusEngineButton*** array, int* length, int* size, SwitcherIBusEngineButton* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (SwitcherIBusEngineButton*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void switcher_update_engines (Switcher* self, IBusEngineDesc** engines, int engines_length1) {
	SwitcherIBusEngineButton** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	SwitcherIBusEngineButton** _tmp3_ = NULL;
	IBusEngineDesc** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	IBusEngineDesc** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	IBusEngineDesc** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gint max_label_width = 0;
	GtkLabel* _tmp40_ = NULL;
	SwitcherIBusEngineButton** _tmp41_ = NULL;
	gint _tmp41__length1 = 0;
	SwitcherIBusEngineButton* _tmp42_ = NULL;
	const gchar* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	GtkLabel* _tmp45_ = NULL;
	GdkDisplay* display = NULL;
	GdkDisplay* _tmp46_ = NULL;
	GdkDisplay* _tmp47_ = NULL;
	GdkScreen* _tmp48_ = NULL;
	GdkDisplay* _tmp49_ = NULL;
	GdkScreen* screen = NULL;
	GdkScreen* _tmp52_ = NULL;
	gint screen_width = 0;
	GdkScreen* _tmp53_ = NULL;
	gboolean _tmp56_ = FALSE;
	gint _tmp57_ = 0;
	gint _tmp61_ = 0;
	gint _tmp62_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_buttons;
	_tmp0__length1 = self->priv->m_buttons_length1;
	{
		SwitcherIBusEngineButton** button_collection = NULL;
		gint button_collection_length1 = 0;
		gint _button_collection_size_ = 0;
		gint button_it = 0;
		button_collection = _tmp0_;
		button_collection_length1 = _tmp0__length1;
		for (button_it = 0; button_it < _tmp0__length1; button_it = button_it + 1) {
			SwitcherIBusEngineButton* _tmp1_ = NULL;
			SwitcherIBusEngineButton* button = NULL;
			_tmp1_ = _g_object_ref0 (button_collection[button_it]);
			button = _tmp1_;
			{
				SwitcherIBusEngineButton* _tmp2_ = NULL;
				_tmp2_ = button;
				gtk_widget_destroy ((GtkWidget*) _tmp2_);
				_g_object_unref0 (button);
			}
		}
	}
	_tmp3_ = g_new0 (SwitcherIBusEngineButton*, 0 + 1);
	self->priv->m_buttons = (_vala_array_free (self->priv->m_buttons, self->priv->m_buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->m_buttons = _tmp3_;
	self->priv->m_buttons_length1 = 0;
	self->priv->_m_buttons_size_ = self->priv->m_buttons_length1;
	_tmp4_ = engines;
	_tmp4__length1 = engines_length1;
	if (_tmp4_ == NULL) {
		IBusEngineDesc** _tmp5_ = NULL;
		_tmp5_ = g_new0 (IBusEngineDesc*, 0 + 1);
		self->priv->m_engines = (_vala_array_free (self->priv->m_engines, self->priv->m_engines_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_engines = _tmp5_;
		self->priv->m_engines_length1 = 0;
		self->priv->_m_engines_size_ = self->priv->m_engines_length1;
		return;
	}
	_tmp6_ = engines;
	_tmp6__length1 = engines_length1;
	_tmp7_ = (_tmp6_ != NULL) ? _vala_array_dup5 (_tmp6_, _tmp6__length1) : ((gpointer) _tmp6_);
	_tmp7__length1 = _tmp6__length1;
	self->priv->m_engines = (_vala_array_free (self->priv->m_engines, self->priv->m_engines_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->m_engines = _tmp7_;
	self->priv->m_engines_length1 = _tmp7__length1;
	self->priv->_m_engines_size_ = self->priv->m_engines_length1;
	max_label_width = 0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				Block9Data* _data9_;
				gint _tmp10_ = 0;
				IBusEngineDesc** _tmp11_ = NULL;
				gint _tmp11__length1 = 0;
				gint _tmp12_ = 0;
				IBusEngineDesc* engine = NULL;
				IBusEngineDesc** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp14_ = 0;
				IBusEngineDesc* _tmp15_ = NULL;
				IBusEngineDesc* _tmp16_ = NULL;
				IBusEngineDesc* _tmp17_ = NULL;
				SwitcherIBusEngineButton* _tmp18_ = NULL;
				gchar* longname = NULL;
				IBusEngineDesc* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				SwitcherIBusEngineButton* _tmp22_ = NULL;
				SwitcherIBusEngineButton* _tmp23_ = NULL;
				SwitcherIBusEngineButton* _tmp24_ = NULL;
				SwitcherIBusEngineButton* _tmp25_ = NULL;
				SwitcherIBusEngineButton* _tmp26_ = NULL;
				const gchar* _tmp27_ = NULL;
				GtkLabel* _tmp28_ = NULL;
				const gchar* _tmp29_ = NULL;
				gint width = 0;
				GtkLabel* _tmp30_ = NULL;
				gint _tmp31_ = 0;
				gint _tmp32_ = 0;
				gint _tmp33_ = 0;
				gint _tmp34_ = 0;
				GtkBox* _tmp35_ = NULL;
				SwitcherIBusEngineButton* _tmp36_ = NULL;
				SwitcherIBusEngineButton** _tmp37_ = NULL;
				gint _tmp37__length1 = 0;
				SwitcherIBusEngineButton* _tmp38_ = NULL;
				SwitcherIBusEngineButton* _tmp39_ = NULL;
				_data9_ = g_slice_new0 (Block9Data);
				_data9_->_ref_count_ = 1;
				_data9_->self = g_object_ref (self);
				if (!_tmp8_) {
					gint _tmp9_ = 0;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp10_ = i;
				_tmp11_ = self->priv->m_engines;
				_tmp11__length1 = self->priv->m_engines_length1;
				if (!(_tmp10_ < _tmp11__length1)) {
					block9_data_unref (_data9_);
					_data9_ = NULL;
					break;
				}
				_tmp12_ = i;
				_data9_->index = _tmp12_;
				_tmp13_ = self->priv->m_engines;
				_tmp13__length1 = self->priv->m_engines_length1;
				_tmp14_ = i;
				_tmp15_ = _tmp13_[_tmp14_];
				_tmp16_ = _g_object_ref0 (_tmp15_);
				engine = _tmp16_;
				_tmp17_ = engine;
				_tmp18_ = switcher_ibus_engine_button_new (_tmp17_, self);
				g_object_ref_sink (_tmp18_);
				_data9_->button = _tmp18_;
				_tmp19_ = engine;
				_tmp20_ = ibus_engine_desc_get_longname (_tmp19_);
				_tmp21_ = g_strdup (_tmp20_);
				longname = _tmp21_;
				_tmp22_ = _data9_->button;
				gtk_button_set_relief ((GtkButton*) _tmp22_, GTK_RELIEF_NONE);
				_tmp23_ = _data9_->button;
				gtk_widget_show ((GtkWidget*) _tmp23_);
				_tmp24_ = _data9_->button;
				g_signal_connect_data ((GtkWidget*) _tmp24_, "enter-notify-event", (GCallback) ______lambda20__gtk_widget_enter_notify_event, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
				_tmp25_ = _data9_->button;
				g_signal_connect_data ((GtkWidget*) _tmp25_, "button-press-event", (GCallback) ______lambda21__gtk_widget_button_press_event, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
				_tmp26_ = _data9_->button;
				_tmp27_ = longname;
				switcher_ibus_engine_button_set_longname (_tmp26_, _tmp27_);
				_tmp28_ = self->priv->m_label;
				_tmp29_ = longname;
				gtk_label_set_label (_tmp28_, _tmp29_);
				_tmp30_ = self->priv->m_label;
				gtk_widget_get_preferred_width ((GtkWidget*) _tmp30_, NULL, &_tmp31_);
				width = _tmp31_;
				_tmp32_ = max_label_width;
				_tmp33_ = width;
				_tmp34_ = MAX (_tmp32_, _tmp33_);
				max_label_width = _tmp34_;
				_tmp35_ = self->priv->m_box;
				_tmp36_ = _data9_->button;
				gtk_box_pack_start (_tmp35_, (GtkWidget*) _tmp36_, TRUE, TRUE, (guint) 0);
				_tmp37_ = self->priv->m_buttons;
				_tmp37__length1 = self->priv->m_buttons_length1;
				_tmp38_ = _data9_->button;
				_tmp39_ = _g_object_ref0 (_tmp38_);
				_vala_array_add24 (&self->priv->m_buttons, &self->priv->m_buttons_length1, &self->priv->_m_buttons_size_, _tmp39_);
				_g_free0 (longname);
				_g_object_unref0 (engine);
				block9_data_unref (_data9_);
				_data9_ = NULL;
			}
		}
	}
	_tmp40_ = self->priv->m_label;
	_tmp41_ = self->priv->m_buttons;
	_tmp41__length1 = self->priv->m_buttons_length1;
	_tmp42_ = _tmp41_[0];
	_tmp43_ = switcher_ibus_engine_button_get_longname (_tmp42_);
	_tmp44_ = _tmp43_;
	gtk_label_set_text (_tmp40_, _tmp44_);
	_tmp45_ = self->priv->m_label;
	gtk_label_set_ellipsize (_tmp45_, PANGO_ELLIPSIZE_END);
	_tmp46_ = gdk_display_get_default ();
	_tmp47_ = _g_object_ref0 (_tmp46_);
	display = _tmp47_;
	_tmp49_ = display;
	if (_tmp49_ != NULL) {
		GdkDisplay* _tmp50_ = NULL;
		GdkScreen* _tmp51_ = NULL;
		_tmp50_ = display;
		_tmp51_ = gdk_display_get_default_screen (_tmp50_);
		_tmp48_ = _tmp51_;
	} else {
		_tmp48_ = NULL;
	}
	_tmp52_ = _g_object_ref0 (_tmp48_);
	screen = _tmp52_;
	screen_width = 0;
	_tmp53_ = screen;
	if (_tmp53_ != NULL) {
		GdkScreen* _tmp54_ = NULL;
		gint _tmp55_ = 0;
		_tmp54_ = screen;
		_tmp55_ = gdk_screen_get_width (_tmp54_);
		screen_width = _tmp55_;
	}
	_tmp57_ = screen_width;
	if (_tmp57_ > 0) {
		gint _tmp58_ = 0;
		gint _tmp59_ = 0;
		_tmp58_ = max_label_width;
		_tmp59_ = screen_width;
		_tmp56_ = _tmp58_ > (_tmp59_ / 4);
	} else {
		_tmp56_ = FALSE;
	}
	if (_tmp56_) {
		gint _tmp60_ = 0;
		_tmp60_ = screen_width;
		max_label_width = _tmp60_ / 4;
	}
	_tmp61_ = max_label_width;
	max_label_width = _tmp61_ + 20;
	_tmp62_ = max_label_width;
	gtk_window_set_default_size ((GtkWindow*) self, _tmp62_, -1);
	_g_object_unref0 (screen);
	_g_object_unref0 (display);
}


static void switcher_next_engine (Switcher* self) {
	guint _tmp0_ = 0U;
	IBusEngineDesc** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	GtkLabel* _tmp3_ = NULL;
	SwitcherIBusEngineButton** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	guint _tmp5_ = 0U;
	SwitcherIBusEngineButton* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	SwitcherIBusEngineButton** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	guint _tmp10_ = 0U;
	SwitcherIBusEngineButton* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_selected_engine;
	_tmp1_ = self->priv->m_engines;
	_tmp1__length1 = self->priv->m_engines_length1;
	if (_tmp0_ == ((guint) (_tmp1__length1 - 1))) {
		self->priv->m_selected_engine = (guint) 0;
	} else {
		guint _tmp2_ = 0U;
		_tmp2_ = self->priv->m_selected_engine;
		self->priv->m_selected_engine = _tmp2_ + 1;
	}
	_tmp3_ = self->priv->m_label;
	_tmp4_ = self->priv->m_buttons;
	_tmp4__length1 = self->priv->m_buttons_length1;
	_tmp5_ = self->priv->m_selected_engine;
	_tmp6_ = _tmp4_[_tmp5_];
	_tmp7_ = switcher_ibus_engine_button_get_longname (_tmp6_);
	_tmp8_ = _tmp7_;
	gtk_label_set_text (_tmp3_, _tmp8_);
	_tmp9_ = self->priv->m_buttons;
	_tmp9__length1 = self->priv->m_buttons_length1;
	_tmp10_ = self->priv->m_selected_engine;
	_tmp11_ = _tmp9_[_tmp10_];
	gtk_window_set_focus ((GtkWindow*) self, (GtkWidget*) _tmp11_);
}


static void switcher_previous_engine (Switcher* self) {
	guint _tmp0_ = 0U;
	GtkLabel* _tmp3_ = NULL;
	SwitcherIBusEngineButton** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	guint _tmp5_ = 0U;
	SwitcherIBusEngineButton* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	SwitcherIBusEngineButton** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	guint _tmp10_ = 0U;
	SwitcherIBusEngineButton* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_selected_engine;
	if (_tmp0_ == ((guint) 0)) {
		IBusEngineDesc** _tmp1_ = NULL;
		gint _tmp1__length1 = 0;
		_tmp1_ = self->priv->m_engines;
		_tmp1__length1 = self->priv->m_engines_length1;
		self->priv->m_selected_engine = (guint) (_tmp1__length1 - 1);
	} else {
		guint _tmp2_ = 0U;
		_tmp2_ = self->priv->m_selected_engine;
		self->priv->m_selected_engine = _tmp2_ - 1;
	}
	_tmp3_ = self->priv->m_label;
	_tmp4_ = self->priv->m_buttons;
	_tmp4__length1 = self->priv->m_buttons_length1;
	_tmp5_ = self->priv->m_selected_engine;
	_tmp6_ = _tmp4_[_tmp5_];
	_tmp7_ = switcher_ibus_engine_button_get_longname (_tmp6_);
	_tmp8_ = _tmp7_;
	gtk_label_set_text (_tmp3_, _tmp8_);
	_tmp9_ = self->priv->m_buttons;
	_tmp9__length1 = self->priv->m_buttons_length1;
	_tmp10_ = self->priv->m_selected_engine;
	_tmp11_ = _tmp9_[_tmp10_];
	gtk_window_set_focus ((GtkWindow*) self, (GtkWidget*) _tmp11_);
}


static void switcher_restore_window_position (Switcher* self, const gchar* debug_str) {
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (debug_str != NULL);
	_tmp0_ = debug_str;
	_tmp1_ = self->priv->m_root_x;
	_tmp2_ = self->priv->m_root_y;
	g_debug ("switcher.vala:332: restore_window_position %s: (%ld, %ld)\n", _tmp0_, (glong) _tmp1_, (glong) _tmp2_);
	_tmp3_ = self->priv->m_popup_delay_time_id;
	if (_tmp3_ == ((guint) 0)) {
		return;
	}
	_tmp4_ = self->priv->m_popup_delay_time_id;
	g_source_remove (_tmp4_);
	self->priv->m_popup_delay_time_id = (guint) 0;
	_tmp5_ = self->priv->m_root_x;
	_tmp6_ = self->priv->m_root_y;
	gtk_window_move ((GtkWindow*) self, _tmp5_, _tmp6_);
}


static void switcher_real_show (GtkWidget* base) {
	Switcher * self;
	self = (Switcher*) base;
	GTK_WIDGET_CLASS (switcher_parent_class)->show ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow));
	gtk_window_set_focus_visible ((GtkWindow*) self, TRUE);
}


static GdkEventKey* _vala_GdkEventKey_copy (GdkEventKey* self) {
	return g_boxed_copy (gdk_event_get_type (), self);
}


static gpointer __vala_GdkEventKey_copy0 (gpointer self) {
	return self ? _vala_GdkEventKey_copy (self) : NULL;
}


static void _vala_GdkEventKey_free (GdkEventKey* self) {
	g_boxed_free (gdk_event_get_type (), self);
}


static gboolean switcher_real_key_press_event (GtkWidget* base, GdkEventKey* e) {
	Switcher * self;
	gboolean result = FALSE;
	gboolean retval = FALSE;
	GdkEventKey* pe = NULL;
	GdkEventKey* _tmp0_ = NULL;
	GdkEventKey* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	self = (Switcher*) base;
	g_return_val_if_fail (e != NULL, FALSE);
	retval = TRUE;
	_tmp0_ = e;
	_tmp1_ = __vala_GdkEventKey_copy0 (_tmp0_);
	pe = _tmp1_;
	_tmp2_ = self->priv->m_popup_delay_time;
	if (_tmp2_ > ((guint) 0)) {
		switcher_restore_window_position (self, "pressed");
	}
	{
		gboolean _tmp3_ = FALSE;
		_tmp3_ = TRUE;
		while (TRUE) {
			guint modifiers = 0U;
			GdkEventKey* _tmp4_ = NULL;
			GdkModifierType _tmp5_ = 0;
			gboolean _tmp6_ = FALSE;
			guint _tmp7_ = 0U;
			guint _tmp8_ = 0U;
			GdkEventKey* _tmp11_ = NULL;
			guint _tmp12_ = 0U;
			guint _tmp13_ = 0U;
			GdkEventKey* _tmp16_ = NULL;
			guint _tmp17_ = 0U;
			if (!_tmp3_) {
				if (!FALSE) {
					break;
				}
			}
			_tmp3_ = FALSE;
			_tmp4_ = pe;
			_tmp5_ = _tmp4_->state;
			modifiers = KEYBINDING_MANAGER_MODIFIER_FILTER & _tmp5_;
			_tmp7_ = modifiers;
			_tmp8_ = self->priv->m_modifiers;
			if (_tmp7_ != _tmp8_) {
				guint _tmp9_ = 0U;
				guint _tmp10_ = 0U;
				_tmp9_ = modifiers;
				_tmp10_ = self->priv->m_modifiers;
				_tmp6_ = _tmp9_ != (_tmp10_ | GDK_SHIFT_MASK);
			} else {
				_tmp6_ = FALSE;
			}
			if (_tmp6_) {
				break;
			}
			_tmp11_ = pe;
			_tmp12_ = _tmp11_->keyval;
			_tmp13_ = self->priv->m_keyval;
			if (_tmp12_ == _tmp13_) {
				guint _tmp14_ = 0U;
				guint _tmp15_ = 0U;
				_tmp14_ = modifiers;
				_tmp15_ = self->priv->m_modifiers;
				if (_tmp14_ == _tmp15_) {
					switcher_next_engine (self);
				} else {
					switcher_previous_engine (self);
				}
				break;
			}
			_tmp16_ = pe;
			_tmp17_ = _tmp16_->keyval;
			switch (_tmp17_) {
				case 0x08fb:
				case 0xff51:
				{
					switcher_previous_engine (self);
					break;
				}
				case 0x08fc:
				case 0xff52:
				{
					break;
				}
				case 0x08fd:
				case 0xff53:
				{
					switcher_next_engine (self);
					break;
				}
				case 0x08fe:
				case 0xff54:
				{
					break;
				}
				default:
				{
					GdkEventKey* _tmp18_ = NULL;
					guint _tmp19_ = 0U;
					_tmp18_ = pe;
					_tmp19_ = _tmp18_->keyval;
					g_debug ("switcher.vala:398: 0x%04x", _tmp19_);
					break;
				}
			}
		}
	}
	result = retval;
	__vala_GdkEventKey_free0 (pe);
	return result;
}


static gboolean switcher_real_key_release_event (GtkWidget* base, GdkEventKey* e) {
	Switcher * self;
	gboolean result = FALSE;
	GdkEventKey* pe = NULL;
	GdkEventKey* _tmp0_ = NULL;
	GdkEventKey* _tmp1_ = NULL;
	GdkEventKey* _tmp2_ = NULL;
	GdkModifierType _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	GMainLoop* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	GMainLoop* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	self = (Switcher*) base;
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = e;
	_tmp1_ = __vala_GdkEventKey_copy0 (_tmp0_);
	pe = _tmp1_;
	_tmp2_ = pe;
	_tmp3_ = self->priv->m_primary_modifier;
	_tmp4_ = keybinding_manager_primary_modifier_still_pressed ((GdkEvent*) _tmp2_, (guint) _tmp3_);
	if (_tmp4_) {
		result = TRUE;
		__vala_GdkEventKey_free0 (pe);
		return result;
	}
	_tmp5_ = self->priv->m_loop;
	if (_tmp5_ == NULL) {
		result = FALSE;
		__vala_GdkEventKey_free0 (pe);
		return result;
	}
	_tmp6_ = self->priv->m_popup_delay_time;
	if (_tmp6_ > ((guint) 0)) {
		guint _tmp7_ = 0U;
		_tmp7_ = self->priv->m_popup_delay_time_id;
		if (_tmp7_ != ((guint) 0)) {
			guint _tmp8_ = 0U;
			_tmp8_ = self->priv->m_popup_delay_time_id;
			g_source_remove (_tmp8_);
			self->priv->m_popup_delay_time_id = (guint) 0;
		}
	}
	_tmp9_ = self->priv->m_loop;
	g_main_loop_quit (_tmp9_);
	_tmp10_ = self->priv->m_selected_engine;
	self->priv->m_result = (gint) _tmp10_;
	result = TRUE;
	__vala_GdkEventKey_free0 (pe);
	return result;
}


void switcher_set_popup_delay_time (Switcher* self, guint popup_delay_time) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = popup_delay_time;
	self->priv->m_popup_delay_time = _tmp0_;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* str = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


gchar* switcher_get_xkb_language (Switcher* self, IBusEngineDesc* engine) {
	gchar* result = NULL;
	gchar* name = NULL;
	IBusEngineDesc* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* language = NULL;
	GHashTable* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gconstpointer _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	IBusEngineDesc* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gint length = 0;
	const gchar* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	const gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gint index = 0;
	GHashTable* _tmp20_ = NULL;
	GList* _tmp21_ = NULL;
	gint _tmp29_ = 0;
	GHashTable* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (engine != NULL, NULL);
	_tmp0_ = engine;
	_tmp1_ = ibus_engine_desc_get_name (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	name = _tmp2_;
	_tmp3_ = name;
	_tmp4_ = string_slice (_tmp3_, (glong) 0, (glong) 4);
	_tmp5_ = _tmp4_;
	_vala_assert (g_strcmp0 (_tmp5_, "xkb:") == 0, "name[0:4] == \"xkb:\"");
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->m_xkb_languages;
	_tmp7_ = name;
	_tmp8_ = g_hash_table_lookup (_tmp6_, _tmp7_);
	_tmp9_ = g_strdup ((const gchar*) _tmp8_);
	language = _tmp9_;
	_tmp10_ = language;
	if (_tmp10_ != NULL) {
		result = language;
		_g_free0 (name);
		return result;
	}
	_tmp11_ = engine;
	_tmp12_ = ibus_engine_desc_get_language (_tmp11_);
	_tmp13_ = g_strdup (_tmp12_);
	_g_free0 (language);
	language = _tmp13_;
	_tmp14_ = language;
	_tmp15_ = strlen (_tmp14_);
	_tmp16_ = _tmp15_;
	length = _tmp16_;
	_tmp17_ = length;
	if (_tmp17_ < 2) {
		result = language;
		_g_free0 (name);
		return result;
	}
	_tmp18_ = language;
	_tmp19_ = g_utf8_strup (_tmp18_, (gssize) -1);
	_g_free0 (language);
	language = _tmp19_;
	index = 0;
	_tmp20_ = self->priv->m_xkb_languages;
	_tmp21_ = g_hash_table_get_values (_tmp20_);
	{
		GList* saved_language_collection = NULL;
		GList* saved_language_it = NULL;
		saved_language_collection = _tmp21_;
		for (saved_language_it = saved_language_collection; saved_language_it != NULL; saved_language_it = saved_language_it->next) {
			const gchar* saved_language = NULL;
			saved_language = (const gchar*) saved_language_it->data;
			{
				const gchar* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				gint _tmp24_ = 0;
				gchar* _tmp25_ = NULL;
				gchar* _tmp26_ = NULL;
				gboolean _tmp27_ = FALSE;
				_tmp22_ = language;
				_tmp23_ = saved_language;
				_tmp24_ = length;
				_tmp25_ = string_slice (_tmp23_, (glong) 0, (glong) _tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = g_strcmp0 (_tmp22_, _tmp26_) == 0;
				_g_free0 (_tmp26_);
				if (_tmp27_) {
					gint _tmp28_ = 0;
					_tmp28_ = index;
					index = _tmp28_ + 1;
				}
			}
		}
		_g_list_free0 (saved_language_collection);
	}
	_tmp29_ = index;
	if (_tmp29_ > 0) {
		gunichar u = 0U;
		gint _tmp30_ = 0;
		const gchar* _tmp31_ = NULL;
		gunichar _tmp32_ = 0U;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		_tmp30_ = index;
		u = (gunichar) (0x2081 + _tmp30_);
		_tmp31_ = language;
		_tmp32_ = u;
		_tmp33_ = g_unichar_to_string (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = g_strdup_printf ("%s%s", _tmp31_, _tmp34_);
		_g_free0 (language);
		language = _tmp35_;
		_g_free0 (_tmp34_);
	}
	_tmp36_ = self->priv->m_xkb_languages;
	_tmp37_ = name;
	_tmp38_ = g_strdup (_tmp37_);
	_tmp39_ = language;
	_tmp40_ = g_strdup (_tmp39_);
	g_hash_table_insert (_tmp36_, _tmp38_, _tmp40_);
	result = language;
	_g_free0 (name);
	return result;
}


gboolean switcher_is_running (Switcher* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_is_running;
	result = _tmp0_;
	return result;
}


gchar* switcher_get_input_context_path (Switcher* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_input_context_path;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


IBusEngineDesc* switcher_get_selected_engine (Switcher* self) {
	IBusEngineDesc* result = NULL;
	IBusEngineDesc* _tmp0_ = NULL;
	IBusEngineDesc* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->m_result_engine;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


void switcher_reset (Switcher* self) {
	gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (self->priv->m_input_context_path);
	self->priv->m_input_context_path = _tmp0_;
	self->priv->m_result = -1;
	_g_object_unref0 (self->priv->m_result_engine);
	self->priv->m_result_engine = NULL;
}


static SwitcherIBusEngineButton* switcher_ibus_engine_button_construct (GType object_type, IBusEngineDesc* engine, Switcher* switcher) {
	SwitcherIBusEngineButton * self = NULL;
	IBusEngineDesc* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* name = NULL;
	IBusEngineDesc* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	g_return_val_if_fail (engine != NULL, NULL);
	g_return_val_if_fail (switcher != NULL, NULL);
	self = (SwitcherIBusEngineButton*) g_object_new (object_type, NULL);
	_tmp0_ = engine;
	_tmp1_ = ibus_engine_desc_get_longname (_tmp0_);
	switcher_ibus_engine_button_set_longname (self, _tmp1_);
	_tmp2_ = engine;
	_tmp3_ = ibus_engine_desc_get_name (_tmp2_);
	_tmp4_ = g_strdup (_tmp3_);
	name = _tmp4_;
	_tmp6_ = name;
	_tmp7_ = strlen (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ < 4) {
		_tmp5_ = TRUE;
	} else {
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		_tmp9_ = name;
		_tmp10_ = string_slice (_tmp9_, (glong) 0, (glong) 4);
		_tmp11_ = _tmp10_;
		_tmp5_ = g_strcmp0 (_tmp11_, "xkb:") != 0;
		_g_free0 (_tmp11_);
	}
	if (_tmp5_) {
		IconWidget* icon = NULL;
		IBusEngineDesc* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		IconWidget* _tmp14_ = NULL;
		IconWidget* _tmp15_ = NULL;
		IconWidget* _tmp16_ = NULL;
		IconWidget* _tmp17_ = NULL;
		_tmp12_ = engine;
		_tmp13_ = ibus_engine_desc_get_icon (_tmp12_);
		_tmp14_ = icon_widget_new (_tmp13_, GTK_ICON_SIZE_DIALOG);
		g_object_ref_sink (_tmp14_);
		icon = _tmp14_;
		_tmp15_ = icon;
		gtk_widget_set_halign ((GtkWidget*) _tmp15_, GTK_ALIGN_CENTER);
		_tmp16_ = icon;
		gtk_widget_set_valign ((GtkWidget*) _tmp16_, GTK_ALIGN_CENTER);
		_tmp17_ = icon;
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp17_);
		_g_object_unref0 (icon);
	} else {
		gchar* language = NULL;
		Switcher* _tmp18_ = NULL;
		IBusEngineDesc* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		GtkLabel* label = NULL;
		const gchar* _tmp21_ = NULL;
		GtkLabel* _tmp22_ = NULL;
		GtkLabel* _tmp23_ = NULL;
		GtkLabel* _tmp24_ = NULL;
		gchar* language_font = NULL;
		gchar* _tmp25_ = NULL;
		gchar* markup = NULL;
		const gchar* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		gchar* _tmp28_ = NULL;
		GtkLabel* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		gint fixed_width = 0;
		gint fixed_height = 0;
		gint _tmp31_ = 0;
		gint _tmp32_ = 0;
		GtkLabel* _tmp33_ = NULL;
		gint _tmp34_ = 0;
		gint _tmp35_ = 0;
		GtkLabel* _tmp36_ = NULL;
		_tmp18_ = switcher;
		_tmp19_ = engine;
		_tmp20_ = switcher_get_xkb_language (_tmp18_, _tmp19_);
		language = _tmp20_;
		_tmp21_ = language;
		_tmp22_ = (GtkLabel*) gtk_label_new (_tmp21_);
		g_object_ref_sink (_tmp22_);
		label = _tmp22_;
		_tmp23_ = label;
		gtk_widget_set_halign ((GtkWidget*) _tmp23_, GTK_ALIGN_CENTER);
		_tmp24_ = label;
		gtk_widget_set_valign ((GtkWidget*) _tmp24_, GTK_ALIGN_CENTER);
		_tmp25_ = g_strdup ("Monospace Bold 16");
		language_font = _tmp25_;
		_tmp26_ = language_font;
		_tmp27_ = language;
		_tmp28_ = g_strdup_printf ("<span font=\"%s\">%s</span>", _tmp26_, _tmp27_);
		markup = _tmp28_;
		_tmp29_ = label;
		_tmp30_ = markup;
		gtk_label_set_markup (_tmp29_, _tmp30_);
		gtk_icon_size_lookup (GTK_ICON_SIZE_DIALOG, &_tmp31_, &_tmp32_);
		fixed_width = _tmp31_;
		fixed_height = _tmp32_;
		_tmp33_ = label;
		_tmp34_ = fixed_width;
		_tmp35_ = fixed_height;
		gtk_widget_set_size_request ((GtkWidget*) _tmp33_, _tmp34_, _tmp35_);
		_tmp36_ = label;
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp36_);
		_g_free0 (markup);
		_g_free0 (language_font);
		_g_object_unref0 (label);
		_g_free0 (language);
	}
	_g_free0 (name);
	return self;
}


static SwitcherIBusEngineButton* switcher_ibus_engine_button_new (IBusEngineDesc* engine, Switcher* switcher) {
	return switcher_ibus_engine_button_construct (SWITCHER_TYPE_IBUS_ENGINE_BUTTON, engine, switcher);
}


static gboolean switcher_ibus_engine_button_real_draw (GtkWidget* base, cairo_t* cr) {
	SwitcherIBusEngineButton * self;
	gboolean result = FALSE;
	cairo_t* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	self = (SwitcherIBusEngineButton*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = cr;
	GTK_WIDGET_CLASS (switcher_ibus_engine_button_parent_class)->draw ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_button_get_type (), GtkButton), _tmp0_);
	g_object_get ((GtkWidget*) self, "is-focus", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		cairo_t* _tmp3_ = NULL;
		cairo_t* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		cairo_t* _tmp7_ = NULL;
		cairo_t* _tmp8_ = NULL;
		cairo_t* _tmp9_ = NULL;
		_tmp3_ = cr;
		cairo_save (_tmp3_);
		_tmp4_ = cr;
		_tmp5_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
		_tmp6_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
		cairo_rectangle (_tmp4_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp5_, (gdouble) _tmp6_);
		_tmp7_ = cr;
		cairo_set_source_rgba (_tmp7_, 0.0, 0.0, 1.0, 0.1);
		_tmp8_ = cr;
		cairo_fill (_tmp8_);
		_tmp9_ = cr;
		cairo_restore (_tmp9_);
	}
	result = TRUE;
	return result;
}


static const gchar* switcher_ibus_engine_button_get_longname (SwitcherIBusEngineButton* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_longname;
	result = _tmp0_;
	return result;
}


static void switcher_ibus_engine_button_set_longname (SwitcherIBusEngineButton* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_longname);
	self->priv->_longname = _tmp1_;
	g_object_notify ((GObject *) self, "longname");
}


static void switcher_ibus_engine_button_class_init (SwitcherIBusEngineButtonClass * klass) {
	switcher_ibus_engine_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SwitcherIBusEngineButtonPrivate));
	((GtkWidgetClass *) klass)->draw = switcher_ibus_engine_button_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_switcher_ibus_engine_button_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_switcher_ibus_engine_button_set_property;
	G_OBJECT_CLASS (klass)->finalize = switcher_ibus_engine_button_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHER_IBUS_ENGINE_BUTTON_LONGNAME, g_param_spec_string ("longname", "longname", "longname", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void switcher_ibus_engine_button_instance_init (SwitcherIBusEngineButton * self) {
	self->priv = SWITCHER_IBUS_ENGINE_BUTTON_GET_PRIVATE (self);
}


static void switcher_ibus_engine_button_finalize (GObject* obj) {
	SwitcherIBusEngineButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHER_TYPE_IBUS_ENGINE_BUTTON, SwitcherIBusEngineButton);
	_g_free0 (self->priv->_longname);
	G_OBJECT_CLASS (switcher_ibus_engine_button_parent_class)->finalize (obj);
}


static GType switcher_ibus_engine_button_get_type (void) {
	static volatile gsize switcher_ibus_engine_button_type_id__volatile = 0;
	if (g_once_init_enter (&switcher_ibus_engine_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SwitcherIBusEngineButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switcher_ibus_engine_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwitcherIBusEngineButton), 0, (GInstanceInitFunc) switcher_ibus_engine_button_instance_init, NULL };
		GType switcher_ibus_engine_button_type_id;
		switcher_ibus_engine_button_type_id = g_type_register_static (gtk_button_get_type (), "SwitcherIBusEngineButton", &g_define_type_info, 0);
		g_once_init_leave (&switcher_ibus_engine_button_type_id__volatile, switcher_ibus_engine_button_type_id);
	}
	return switcher_ibus_engine_button_type_id__volatile;
}


static void _vala_switcher_ibus_engine_button_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SwitcherIBusEngineButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHER_TYPE_IBUS_ENGINE_BUTTON, SwitcherIBusEngineButton);
	switch (property_id) {
		case SWITCHER_IBUS_ENGINE_BUTTON_LONGNAME:
		g_value_set_string (value, switcher_ibus_engine_button_get_longname (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_switcher_ibus_engine_button_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SwitcherIBusEngineButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHER_TYPE_IBUS_ENGINE_BUTTON, SwitcherIBusEngineButton);
	switch (property_id) {
		case SWITCHER_IBUS_ENGINE_BUTTON_LONGNAME:
		switcher_ibus_engine_button_set_longname (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void switcher_class_init (SwitcherClass * klass) {
	switcher_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SwitcherPrivate));
	((GtkWidgetClass *) klass)->show = switcher_real_show;
	((GtkWidgetClass *) klass)->key_press_event = switcher_real_key_press_event;
	((GtkWidgetClass *) klass)->key_release_event = switcher_real_key_release_event;
	G_OBJECT_CLASS (klass)->finalize = switcher_finalize;
}


static void switcher_instance_init (Switcher * self) {
	SwitcherIBusEngineButton** _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GHashFunc _tmp2_ = NULL;
	GEqualFunc _tmp3_ = NULL;
	GHashTable* _tmp4_ = NULL;
	self->priv = SWITCHER_GET_PRIVATE (self);
	_tmp0_ = g_new0 (SwitcherIBusEngineButton*, 0 + 1);
	self->priv->m_buttons = _tmp0_;
	self->priv->m_buttons_length1 = 0;
	self->priv->_m_buttons_size_ = self->priv->m_buttons_length1;
	self->priv->m_is_running = FALSE;
	_tmp1_ = g_strdup ("");
	self->priv->m_input_context_path = _tmp1_;
	self->priv->m_result = -1;
	self->priv->m_result_engine = NULL;
	self->priv->m_popup_delay_time = (guint) 0;
	self->priv->m_popup_delay_time_id = (guint) 0;
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, _g_free0_, _g_free0_);
	self->priv->m_xkb_languages = _tmp4_;
}


static void switcher_finalize (GObject* obj) {
	Switcher * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SWITCHER, Switcher);
	_g_object_unref0 (self->priv->m_box);
	_g_object_unref0 (self->priv->m_label);
	self->priv->m_buttons = (_vala_array_free (self->priv->m_buttons, self->priv->m_buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->m_engines = (_vala_array_free (self->priv->m_engines, self->priv->m_engines_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_free0 (self->priv->m_input_context_path);
	_g_main_loop_unref0 (self->priv->m_loop);
	_g_object_unref0 (self->priv->m_result_engine);
	_g_hash_table_unref0 (self->priv->m_xkb_languages);
	G_OBJECT_CLASS (switcher_parent_class)->finalize (obj);
}


GType switcher_get_type (void) {
	static volatile gsize switcher_type_id__volatile = 0;
	if (g_once_init_enter (&switcher_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SwitcherClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switcher_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Switcher), 0, (GInstanceInitFunc) switcher_instance_init, NULL };
		GType switcher_type_id;
		switcher_type_id = g_type_register_static (gtk_window_get_type (), "Switcher", &g_define_type_info, 0);
		g_once_init_leave (&switcher_type_id__volatile, switcher_type_id);
	}
	return switcher_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



