/* panel.c generated by valac 0.18.1, the Vala compiler
 * generated from panel.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2011 Peng Huang <shawn.p.huang@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <ibus.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <signal.h>
#include <sys/types.h>
#include <config.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>


#define TYPE_PANEL (panel_get_type ())
#define PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PANEL, Panel))
#define PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PANEL, PanelClass))
#define IS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PANEL))
#define IS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PANEL))
#define PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PANEL, PanelClass))

typedef struct _Panel Panel;
typedef struct _PanelClass PanelClass;
typedef struct _PanelPrivate PanelPrivate;

#define TYPE_CANDIDATE_PANEL (candidate_panel_get_type ())
#define CANDIDATE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANDIDATE_PANEL, CandidatePanel))
#define CANDIDATE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANDIDATE_PANEL, CandidatePanelClass))
#define IS_CANDIDATE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANDIDATE_PANEL))
#define IS_CANDIDATE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANDIDATE_PANEL))
#define CANDIDATE_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANDIDATE_PANEL, CandidatePanelClass))

typedef struct _CandidatePanel CandidatePanel;
typedef struct _CandidatePanelClass CandidatePanelClass;

#define TYPE_SWITCHER (switcher_get_type ())
#define SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SWITCHER, Switcher))
#define SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SWITCHER, SwitcherClass))
#define IS_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SWITCHER))
#define IS_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SWITCHER))
#define SWITCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SWITCHER, SwitcherClass))

typedef struct _Switcher Switcher;
typedef struct _SwitcherClass SwitcherClass;

#define TYPE_PROPERTY_MANAGER (property_manager_get_type ())
#define PROPERTY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_MANAGER, PropertyManager))
#define PROPERTY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_MANAGER, PropertyManagerClass))
#define IS_PROPERTY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_MANAGER))
#define IS_PROPERTY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_MANAGER))
#define PROPERTY_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_MANAGER, PropertyManagerClass))

typedef struct _PropertyManager PropertyManager;
typedef struct _PropertyManagerClass PropertyManagerClass;

#define PANEL_TYPE_KEYBINDING (panel_keybinding_get_type ())
#define PANEL_KEYBINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANEL_TYPE_KEYBINDING, PanelKeybinding))
#define PANEL_KEYBINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PANEL_TYPE_KEYBINDING, PanelKeybindingClass))
#define PANEL_IS_KEYBINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANEL_TYPE_KEYBINDING))
#define PANEL_IS_KEYBINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PANEL_TYPE_KEYBINDING))
#define PANEL_KEYBINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PANEL_TYPE_KEYBINDING, PanelKeybindingClass))

typedef struct _PanelKeybinding PanelKeybinding;
typedef struct _PanelKeybindingClass PanelKeybindingClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _property_manager_unref0(var) ((var == NULL) ? NULL : (var = (property_manager_unref (var), NULL)))
#define __g_list_free__panel_keybinding_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__panel_keybinding_unref0_ (var), NULL)))

#define TYPE_KEYBINDING_MANAGER (keybinding_manager_get_type ())
#define KEYBINDING_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEYBINDING_MANAGER, KeybindingManager))
#define KEYBINDING_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEYBINDING_MANAGER, KeybindingManagerClass))
#define IS_KEYBINDING_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEYBINDING_MANAGER))
#define IS_KEYBINDING_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEYBINDING_MANAGER))
#define KEYBINDING_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEYBINDING_MANAGER, KeybindingManagerClass))

typedef struct _KeybindingManager KeybindingManager;
typedef struct _KeybindingManagerClass KeybindingManagerClass;
#define _panel_keybinding_unref0(var) ((var == NULL) ? NULL : (var = (panel_keybinding_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block4Data Block4Data;

#define TYPE_ICON_WIDGET (icon_widget_get_type ())
#define ICON_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ICON_WIDGET, IconWidget))
#define ICON_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ICON_WIDGET, IconWidgetClass))
#define IS_ICON_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ICON_WIDGET))
#define IS_ICON_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ICON_WIDGET))
#define ICON_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ICON_WIDGET, IconWidgetClass))

typedef struct _IconWidget IconWidget;
typedef struct _IconWidgetClass IconWidgetClass;
#define _gtk_icon_info_free0(var) ((var == NULL) ? NULL : (var = (gtk_icon_info_free (var), NULL)))
typedef struct _PanelKeybindingPrivate PanelKeybindingPrivate;
typedef struct _PanelParamSpecKeybinding PanelParamSpecKeybinding;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Panel {
	IBusPanelService parent_instance;
	PanelPrivate * priv;
};

struct _PanelClass {
	IBusPanelServiceClass parent_class;
};

struct _PanelPrivate {
	IBusBus* m_bus;
	IBusConfig* m_config;
	GtkStatusIcon* m_status_icon;
	GtkMenu* m_ime_menu;
	GtkMenu* m_sys_menu;
	IBusEngineDesc** m_engines;
	gint m_engines_length1;
	gint _m_engines_size_;
	CandidatePanel* m_candidate_panel;
	Switcher* m_switcher;
	PropertyManager* m_property_manager;
	GPid m_setup_pid;
	GtkAboutDialog* m_about_dialog;
	GtkCssProvider* m_css_provider;
	gint m_switcher_delay_time;
	GList* m_keybindings;
};

typedef void (*KeybindingManagerKeybindingHandlerFunc) (GdkEvent* event, void* user_data);
struct _Block4Data {
	int _ref_count_;
	Panel * self;
	IBusEngineDesc* e;
};

struct _PanelKeybinding {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PanelKeybindingPrivate * priv;
};

struct _PanelKeybindingClass {
	GTypeClass parent_class;
	void (*finalize) (PanelKeybinding *self);
};

struct _PanelKeybindingPrivate {
	guint _keysym;
	GdkModifierType _modifiers;
	gboolean _reverse;
};

struct _PanelParamSpecKeybinding {
	GParamSpec parent_instance;
};


static gpointer panel_parent_class = NULL;
static gpointer panel_keybinding_parent_class = NULL;

GType panel_get_type (void) G_GNUC_CONST;
GType candidate_panel_get_type (void) G_GNUC_CONST;
GType switcher_get_type (void) G_GNUC_CONST;
gpointer property_manager_ref (gpointer instance);
void property_manager_unref (gpointer instance);
GParamSpec* param_spec_property_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_property_manager (GValue* value, gpointer v_object);
void value_take_property_manager (GValue* value, gpointer v_object);
gpointer value_get_property_manager (const GValue* value);
GType property_manager_get_type (void) G_GNUC_CONST;
static gpointer panel_keybinding_ref (gpointer instance);
static void panel_keybinding_unref (gpointer instance);
static GParamSpec* panel_param_spec_keybinding (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void panel_value_set_keybinding (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void panel_value_take_keybinding (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer panel_value_get_keybinding (const GValue* value) G_GNUC_UNUSED;
static GType panel_keybinding_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define PANEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PANEL, PanelPrivate))
enum  {
	PANEL_DUMMY_PROPERTY
};
static void panel_unbind_switch_shortcut (Panel* self);
static void _panel_keybinding_unref0_ (gpointer var);
static void _g_list_free__panel_keybinding_unref0_ (GList* self);
#define PANEL_ACCELERATOR_SWITCH_IME_FOREWARD "<Control>space"
Panel* panel_new (IBusBus* bus);
Panel* panel_construct (GType object_type, IBusBus* bus);
static void panel_status_icon_popup_menu_cb (Panel* self, GtkStatusIcon* status_icon, guint button, guint activate_time);
static void _panel_status_icon_popup_menu_cb_gtk_status_icon_popup_menu (GtkStatusIcon* _sender, guint button, guint activate_time, gpointer self);
static void panel_status_icon_activate_cb (Panel* self, GtkStatusIcon* status_icon);
static void _panel_status_icon_activate_cb_gtk_status_icon_activate (GtkStatusIcon* _sender, gpointer self);
CandidatePanel* candidate_panel_new (void);
CandidatePanel* candidate_panel_construct (GType object_type);
static void __lambda23_ (Panel* self, CandidatePanel* w);
static void ___lambda23__candidate_panel_page_up (CandidatePanel* _sender, gpointer self);
static void __lambda24_ (Panel* self, CandidatePanel* w);
static void ___lambda24__candidate_panel_page_down (CandidatePanel* _sender, gpointer self);
Switcher* switcher_new (void);
Switcher* switcher_construct (GType object_type);
static void panel_bind_switch_shortcut (Panel* self, GVariant* variant);
void switcher_set_popup_delay_time (Switcher* self, guint popup_delay_time);
PropertyManager* property_manager_new (void);
PropertyManager* property_manager_construct (GType object_type);
static void __lambda27_ (Panel* self, const gchar* k, gint s);
static void ___lambda27__property_manager_property_activate (PropertyManager* _sender, const gchar* key, gint state, gpointer self);
GType keybinding_manager_get_type (void) G_GNUC_CONST;
static void panel_keybinding_manager_bind (Panel* self, KeybindingManager* keybinding_manager, const gchar* accelerator);
static PanelKeybinding* panel_keybinding_new (guint keysym, GdkModifierType modifiers, gboolean reverse);
static PanelKeybinding* panel_keybinding_construct (GType object_type, guint keysym, GdkModifierType modifiers, gboolean reverse);
gboolean keybinding_manager_bind (KeybindingManager* self, guint keysym, GdkModifierType modifiers, KeybindingManagerKeybindingHandlerFunc handler, void* handler_target);
static void __lambda25_ (Panel* self, GdkEvent* e);
static void panel_handle_engine_switch (Panel* self, GdkEvent* event, gboolean revert);
static void ___lambda25__keybinding_manager_keybinding_handler_func (GdkEvent* event, gpointer self);
static void __lambda26_ (Panel* self, GdkEvent* e);
static void ___lambda26__keybinding_manager_keybinding_handler_func (GdkEvent* event, gpointer self);
static void _vala_array_add14 (gchar*** array, int* length, int* size, gchar* value);
KeybindingManager* keybinding_manager_get_instance (void);
void keybinding_manager_unbind (KeybindingManager* self, guint keysym, GdkModifierType modifiers);
static guint panel_keybinding_get_keysym (PanelKeybinding* self);
static GdkModifierType panel_keybinding_get_modifiers (PanelKeybinding* self);
static void panel_set_custom_font (Panel* self);
static void panel_set_switcher_delay_time (Panel* self, GVariant* variant);
void panel_set_config (Panel* self, IBusConfig* config);
static void panel_config_value_changed_cb (Panel* self, IBusConfig* config, const gchar* section, const gchar* name, GVariant* variant);
static void _panel_config_value_changed_cb_ibus_config_value_changed (IBusConfig* _sender, const gchar* section, const gchar* name, GVariant* value, gpointer self);
static void panel_update_engines (Panel* self, GVariant* var_engines, GVariant* var_order);
static void panel_exec_setxkbmap (Panel* self, IBusEngineDesc* engine);
static void _vala_array_add15 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add16 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add17 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add18 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add19 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add20 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add21 (gchar*** array, int* length, int* size, gchar* value);
static void panel_switch_engine (Panel* self, gint i, gboolean force);
#define KEYBINDING_MANAGER_MODIFIER_FILTER ((guint) (GDK_MODIFIER_MASK & (~(((((((((GDK_LOCK_MASK | GDK_MOD2_MASK) | GDK_BUTTON1_MASK) | GDK_BUTTON2_MASK) | GDK_BUTTON3_MASK) | GDK_BUTTON4_MASK) | GDK_BUTTON5_MASK) | GDK_SUPER_MASK) | GDK_HYPER_MASK) | GDK_META_MASK))))
GdkModifierType keybinding_manager_get_primary_modifier (guint binding_mask);
gboolean keybinding_manager_primary_modifier_still_pressed (GdkEvent* event, guint primary_modifier);
gint switcher_run (Switcher* self, guint keyval, guint state, GdkEvent* event, IBusEngineDesc** engines, int engines_length1, gint index);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static void _vala_array_add22 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add23 (gchar*** array, int* length, int* size, gchar* value);
static IBusEngineDesc** _vala_array_dup3 (IBusEngineDesc** self, int length);
static IBusEngineDesc** _vala_array_dup4 (IBusEngineDesc** self, int length);
static void panel_show_setup_dialog (Panel* self);
static void __lambda18_ (Panel* self, GPid pid, gint state);
static void ___lambda18__gchild_watch_func (GPid pid, gint status, gpointer self);
static void panel_show_about_dialog (Panel* self);
static void ___lambda17_ (Panel* self, GtkMenuItem* i);
static void ____lambda17__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void ___lambda19_ (Panel* self, GtkMenuItem* i);
static void ____lambda19__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void ___lambda20_ (Panel* self, GtkMenuItem* i);
static void ____lambda20__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void ___lambda21_ (Panel* self, GtkMenuItem* i);
static void ____lambda21__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _gtk_status_icon_position_menu_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self);
gint property_manager_create_menu_items (PropertyManager* self, GtkMenu* menu);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
IconWidget* icon_widget_new (const gchar* icon_name_or_path, GtkIconSize size);
IconWidget* icon_widget_construct (GType object_type, const gchar* icon_name_or_path, GtkIconSize size);
GType icon_widget_get_type (void) G_GNUC_CONST;
static void ____lambda22_ (Block4Data* _data4_, GtkMenuItem* item);
static void _____lambda22__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void panel_real_set_cursor_location (IBusPanelService* base, gint x, gint y, gint width, gint height);
void candidate_panel_set_cursor_location (CandidatePanel* self, gint x, gint y, gint width, gint height);
static void panel_real_focus_in (IBusPanelService* base, const gchar* input_context_path);
static void panel_real_focus_out (IBusPanelService* base, const gchar* input_context_path);
static void panel_real_register_properties (IBusPanelService* base, IBusPropList* props);
void property_manager_set_properties (PropertyManager* self, IBusPropList* props);
static void panel_real_update_property (IBusPanelService* base, IBusProperty* prop);
void property_manager_update_property (PropertyManager* self, IBusProperty* prop);
static void panel_real_update_preedit_text (IBusPanelService* base, IBusText* text, guint cursor_pos, gboolean visible);
void candidate_panel_set_preedit_text (CandidatePanel* self, IBusText* text, guint cursor);
static void panel_real_hide_preedit_text (IBusPanelService* base);
static void panel_real_update_auxiliary_text (IBusPanelService* base, IBusText* text, gboolean visible);
void candidate_panel_set_auxiliary_text (CandidatePanel* self, IBusText* text);
static void panel_real_hide_auxiliary_text (IBusPanelService* base);
static void panel_real_update_lookup_table (IBusPanelService* base, IBusLookupTable* table, gboolean visible);
void candidate_panel_set_lookup_table (CandidatePanel* self, IBusLookupTable* table);
static void panel_real_hide_lookup_table (IBusPanelService* base);
static void panel_real_state_changed (IBusPanelService* base);
static void _vala_array_add24 (gchar*** array, int* length, int* size, gchar* value);
#define PANEL_KEYBINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), PANEL_TYPE_KEYBINDING, PanelKeybindingPrivate))
enum  {
	PANEL_KEYBINDING_DUMMY_PROPERTY
};
static void panel_keybinding_set_keysym (PanelKeybinding* self, guint value);
static void panel_keybinding_set_modifiers (PanelKeybinding* self, GdkModifierType value);
static void panel_keybinding_set_reverse (PanelKeybinding* self, gboolean value);
static gboolean panel_keybinding_get_reverse (PanelKeybinding* self);
static void panel_keybinding_finalize (PanelKeybinding* obj);
static void panel_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _panel_keybinding_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (panel_keybinding_unref (var), NULL));
}


static void _g_list_free__panel_keybinding_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _panel_keybinding_unref0_, NULL);
	g_list_free (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _panel_status_icon_popup_menu_cb_gtk_status_icon_popup_menu (GtkStatusIcon* _sender, guint button, guint activate_time, gpointer self) {
	panel_status_icon_popup_menu_cb (self, _sender, button, activate_time);
}


static void _panel_status_icon_activate_cb_gtk_status_icon_activate (GtkStatusIcon* _sender, gpointer self) {
	panel_status_icon_activate_cb (self, _sender);
}


static void __lambda23_ (Panel* self, CandidatePanel* w) {
	g_return_if_fail (w != NULL);
	ibus_panel_service_page_up ((IBusPanelService*) self);
}


static void ___lambda23__candidate_panel_page_up (CandidatePanel* _sender, gpointer self) {
	__lambda23_ (self, _sender);
}


static void __lambda24_ (Panel* self, CandidatePanel* w) {
	g_return_if_fail (w != NULL);
	ibus_panel_service_page_down ((IBusPanelService*) self);
}


static void ___lambda24__candidate_panel_page_down (CandidatePanel* _sender, gpointer self) {
	__lambda24_ (self, _sender);
}


static void __lambda27_ (Panel* self, const gchar* k, gint s) {
	const gchar* _tmp0_;
	gint _tmp1_;
	g_return_if_fail (k != NULL);
	_tmp0_ = k;
	_tmp1_ = s;
	ibus_panel_service_property_activate ((IBusPanelService*) self, _tmp0_, (guint) _tmp1_);
}


static void ___lambda27__property_manager_property_activate (PropertyManager* _sender, const gchar* key, gint state, gpointer self) {
	__lambda27_ (self, key, state);
}


Panel* panel_construct (GType object_type, IBusBus* bus) {
	Panel * self = NULL;
	IBusBus* _tmp0_;
	gboolean _tmp1_ = FALSE;
	IBusBus* _tmp2_;
	GDBusConnection* _tmp3_ = NULL;
	IBusBus* _tmp4_;
	IBusBus* _tmp5_;
	GtkStatusIcon* _tmp6_;
	GtkStatusIcon* _tmp7_;
	GtkStatusIcon* _tmp8_;
	GtkStatusIcon* _tmp9_;
	GtkStatusIcon* _tmp10_;
	GtkStatusIcon* _tmp11_;
	CandidatePanel* _tmp12_;
	CandidatePanel* _tmp13_;
	CandidatePanel* _tmp14_;
	Switcher* _tmp15_;
	gint _tmp16_;
	PropertyManager* _tmp19_;
	PropertyManager* _tmp20_;
	g_return_val_if_fail (bus != NULL, NULL);
	_tmp0_ = bus;
	_tmp1_ = ibus_bus_is_connected (_tmp0_);
	_vala_assert (_tmp1_, "bus.is_connected()");
	_tmp2_ = bus;
	_tmp3_ = ibus_bus_get_connection (_tmp2_);
	self = (Panel*) g_object_new (object_type, "connection", _tmp3_, "object-path", "/org/freedesktop/IBus/Panel", NULL);
	_tmp4_ = bus;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->m_bus);
	self->priv->m_bus = _tmp5_;
	_tmp6_ = gtk_status_icon_new ();
	_g_object_unref0 (self->priv->m_status_icon);
	self->priv->m_status_icon = _tmp6_;
	_tmp7_ = self->priv->m_status_icon;
	gtk_status_icon_set_name (_tmp7_, "ibus-ui-gtk");
	_tmp8_ = self->priv->m_status_icon;
	gtk_status_icon_set_title (_tmp8_, "IBus Panel");
	_tmp9_ = self->priv->m_status_icon;
	g_signal_connect_object (_tmp9_, "popup-menu", (GCallback) _panel_status_icon_popup_menu_cb_gtk_status_icon_popup_menu, self, 0);
	_tmp10_ = self->priv->m_status_icon;
	g_signal_connect_object (_tmp10_, "activate", (GCallback) _panel_status_icon_activate_cb_gtk_status_icon_activate, self, 0);
	_tmp11_ = self->priv->m_status_icon;
	gtk_status_icon_set_from_icon_name (_tmp11_, "ibus-keyboard");
	_tmp12_ = candidate_panel_new ();
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->m_candidate_panel);
	self->priv->m_candidate_panel = _tmp12_;
	_tmp13_ = self->priv->m_candidate_panel;
	g_signal_connect_object (_tmp13_, "page-up", (GCallback) ___lambda23__candidate_panel_page_up, self, 0);
	_tmp14_ = self->priv->m_candidate_panel;
	g_signal_connect_object (_tmp14_, "page-down", (GCallback) ___lambda24__candidate_panel_page_down, self, 0);
	_tmp15_ = switcher_new ();
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->m_switcher);
	self->priv->m_switcher = _tmp15_;
	panel_bind_switch_shortcut (self, NULL);
	_tmp16_ = self->priv->m_switcher_delay_time;
	if (_tmp16_ >= 0) {
		Switcher* _tmp17_;
		gint _tmp18_;
		_tmp17_ = self->priv->m_switcher;
		_tmp18_ = self->priv->m_switcher_delay_time;
		switcher_set_popup_delay_time (_tmp17_, (guint) _tmp18_);
	}
	_tmp19_ = property_manager_new ();
	_property_manager_unref0 (self->priv->m_property_manager);
	self->priv->m_property_manager = _tmp19_;
	_tmp20_ = self->priv->m_property_manager;
	g_signal_connect_object (_tmp20_, "property-activate", (GCallback) ___lambda27__property_manager_property_activate, self, 0);
	g_signal_emit_by_name ((IBusPanelService*) self, "state-changed");
	return self;
}


Panel* panel_new (IBusBus* bus) {
	return panel_construct (TYPE_PANEL, bus);
}


static gpointer _panel_keybinding_ref0 (gpointer self) {
	return self ? panel_keybinding_ref (self) : NULL;
}


static void __lambda25_ (Panel* self, GdkEvent* e) {
	GdkEvent* _tmp0_;
	g_return_if_fail (e != NULL);
	_tmp0_ = e;
	panel_handle_engine_switch (self, _tmp0_, FALSE);
}


static void ___lambda25__keybinding_manager_keybinding_handler_func (GdkEvent* event, gpointer self) {
	__lambda25_ (self, event);
}


static void __lambda26_ (Panel* self, GdkEvent* e) {
	GdkEvent* _tmp0_;
	g_return_if_fail (e != NULL);
	_tmp0_ = e;
	panel_handle_engine_switch (self, _tmp0_, TRUE);
}


static void ___lambda26__keybinding_manager_keybinding_handler_func (GdkEvent* event, gpointer self) {
	__lambda26_ (self, event);
}


static void panel_keybinding_manager_bind (Panel* self, KeybindingManager* keybinding_manager, const gchar* accelerator) {
	guint switch_keysym;
	GdkModifierType switch_modifiers;
	GdkModifierType reverse_modifier;
	PanelKeybinding* keybinding = NULL;
	const gchar* _tmp0_;
	guint _tmp1_ = 0U;
	GdkModifierType _tmp2_ = 0;
	static const GdkModifierType VIRTUAL_MODIFIERS = (GDK_SUPER_MASK | GDK_HYPER_MASK) | GDK_META_MASK;
	GdkModifierType _tmp3_;
	gboolean _tmp6_ = FALSE;
	guint _tmp7_;
	gboolean _tmp9_;
	guint _tmp11_;
	GdkModifierType _tmp12_;
	PanelKeybinding* _tmp13_;
	PanelKeybinding* _tmp14_;
	PanelKeybinding* _tmp15_;
	KeybindingManager* _tmp16_;
	guint _tmp17_;
	GdkModifierType _tmp18_;
	GdkModifierType _tmp19_;
	GdkModifierType _tmp20_;
	GdkModifierType _tmp21_;
	GdkModifierType _tmp22_;
	guint _tmp23_;
	GdkModifierType _tmp24_;
	PanelKeybinding* _tmp25_;
	PanelKeybinding* _tmp26_;
	PanelKeybinding* _tmp27_;
	KeybindingManager* _tmp28_;
	guint _tmp29_;
	GdkModifierType _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (keybinding_manager != NULL);
	switch_keysym = (guint) 0;
	switch_modifiers = 0;
	reverse_modifier = GDK_SHIFT_MASK;
	_tmp0_ = accelerator;
	gtk_accelerator_parse (_tmp0_, &_tmp1_, &_tmp2_);
	switch_keysym = _tmp1_;
	switch_modifiers = _tmp2_;
	_tmp3_ = switch_modifiers;
	if ((_tmp3_ & VIRTUAL_MODIFIERS) != 0) {
		GdkKeymap* _tmp4_ = NULL;
		GdkModifierType _tmp5_;
		_tmp4_ = gdk_keymap_get_default ();
		gdk_keymap_map_virtual_modifiers (_tmp4_, &switch_modifiers);
		_tmp5_ = switch_modifiers;
		switch_modifiers = _tmp5_ & (~VIRTUAL_MODIFIERS);
	}
	_tmp7_ = switch_keysym;
	if (_tmp7_ == ((guint) 0)) {
		GdkModifierType _tmp8_;
		_tmp8_ = switch_modifiers;
		_tmp6_ = _tmp8_ == 0;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp9_ = _tmp6_;
	if (_tmp9_) {
		const gchar* _tmp10_;
		_tmp10_ = accelerator;
		g_warning ("panel.vala:126: Parse accelerator '%s' failed!", _tmp10_);
		_panel_keybinding_unref0 (keybinding);
		return;
	}
	_tmp11_ = switch_keysym;
	_tmp12_ = switch_modifiers;
	_tmp13_ = panel_keybinding_new (_tmp11_, _tmp12_, FALSE);
	_panel_keybinding_unref0 (keybinding);
	keybinding = _tmp13_;
	_tmp14_ = keybinding;
	_tmp15_ = _panel_keybinding_ref0 (_tmp14_);
	self->priv->m_keybindings = g_list_append (self->priv->m_keybindings, _tmp15_);
	_tmp16_ = keybinding_manager;
	_tmp17_ = switch_keysym;
	_tmp18_ = switch_modifiers;
	keybinding_manager_bind (_tmp16_, _tmp17_, _tmp18_, ___lambda25__keybinding_manager_keybinding_handler_func, self);
	_tmp19_ = switch_modifiers;
	_tmp20_ = reverse_modifier;
	if ((_tmp19_ & _tmp20_) != 0) {
		_panel_keybinding_unref0 (keybinding);
		return;
	}
	_tmp21_ = switch_modifiers;
	_tmp22_ = reverse_modifier;
	switch_modifiers = _tmp21_ | _tmp22_;
	_tmp23_ = switch_keysym;
	_tmp24_ = switch_modifiers;
	_tmp25_ = panel_keybinding_new (_tmp23_, _tmp24_, TRUE);
	_panel_keybinding_unref0 (keybinding);
	keybinding = _tmp25_;
	_tmp26_ = keybinding;
	_tmp27_ = _panel_keybinding_ref0 (_tmp26_);
	self->priv->m_keybindings = g_list_append (self->priv->m_keybindings, _tmp27_);
	_tmp28_ = keybinding_manager;
	_tmp29_ = switch_keysym;
	_tmp30_ = switch_modifiers;
	keybinding_manager_bind (_tmp28_, _tmp29_, _tmp30_, ___lambda26__keybinding_manager_keybinding_handler_func, self);
	_panel_keybinding_unref0 (keybinding);
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static void _vala_array_add14 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void panel_bind_switch_shortcut (Panel* self, GVariant* variant) {
	gchar** _tmp0_ = NULL;
	gchar** accelerators;
	gint accelerators_length1;
	gint _accelerators_size_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GVariant* var_trigger;
	gboolean _tmp3_ = FALSE;
	GVariant* _tmp4_;
	gboolean _tmp6_;
	GVariant* _tmp9_;
	KeybindingManager* _tmp15_ = NULL;
	KeybindingManager* keybinding_manager;
	gchar** _tmp16_;
	gint _tmp16__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	accelerators = _tmp0_;
	accelerators_length1 = 0;
	_accelerators_size_ = accelerators_length1;
	_tmp1_ = variant;
	_tmp2_ = _g_variant_ref0 (_tmp1_);
	var_trigger = _tmp2_;
	_tmp4_ = var_trigger;
	if (_tmp4_ == NULL) {
		IBusConfig* _tmp5_;
		_tmp5_ = self->priv->m_config;
		_tmp3_ = _tmp5_ != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	_tmp6_ = _tmp3_;
	if (_tmp6_) {
		IBusConfig* _tmp7_;
		GVariant* _tmp8_ = NULL;
		_tmp7_ = self->priv->m_config;
		_tmp8_ = ibus_config_get_value (_tmp7_, "general/hotkey", "triggers");
		_g_variant_unref0 (var_trigger);
		var_trigger = _tmp8_;
	}
	_tmp9_ = var_trigger;
	if (_tmp9_ != NULL) {
		GVariant* _tmp10_;
		size_t _tmp11_;
		gchar** _tmp12_ = NULL;
		_tmp10_ = var_trigger;
		_tmp12_ = g_variant_dup_strv (_tmp10_, &_tmp11_);
		accelerators = (_vala_array_free (accelerators, accelerators_length1, (GDestroyNotify) g_free), NULL);
		accelerators = _tmp12_;
		accelerators_length1 = _tmp11_;
		_accelerators_size_ = accelerators_length1;
	} else {
		gchar** _tmp13_;
		gint _tmp13__length1;
		gchar* _tmp14_;
		_tmp13_ = accelerators;
		_tmp13__length1 = accelerators_length1;
		_tmp14_ = g_strdup (PANEL_ACCELERATOR_SWITCH_IME_FOREWARD);
		_vala_array_add14 (&accelerators, &accelerators_length1, &_accelerators_size_, _tmp14_);
	}
	_tmp15_ = keybinding_manager_get_instance ();
	keybinding_manager = _tmp15_;
	_tmp16_ = accelerators;
	_tmp16__length1 = accelerators_length1;
	{
		gchar** accelerator_collection = NULL;
		gint accelerator_collection_length1 = 0;
		gint _accelerator_collection_size_ = 0;
		gint accelerator_it = 0;
		accelerator_collection = _tmp16_;
		accelerator_collection_length1 = _tmp16__length1;
		for (accelerator_it = 0; accelerator_it < _tmp16__length1; accelerator_it = accelerator_it + 1) {
			gchar* _tmp17_;
			gchar* accelerator = NULL;
			_tmp17_ = g_strdup (accelerator_collection[accelerator_it]);
			accelerator = _tmp17_;
			{
				KeybindingManager* _tmp18_;
				const gchar* _tmp19_;
				_tmp18_ = keybinding_manager;
				_tmp19_ = accelerator;
				panel_keybinding_manager_bind (self, _tmp18_, _tmp19_);
				_g_free0 (accelerator);
			}
		}
	}
	_g_object_unref0 (keybinding_manager);
	_g_variant_unref0 (var_trigger);
	accelerators = (_vala_array_free (accelerators, accelerators_length1, (GDestroyNotify) g_free), NULL);
}


static void panel_unbind_switch_shortcut (Panel* self) {
	KeybindingManager* _tmp0_ = NULL;
	KeybindingManager* keybinding_manager;
	GList* _tmp1_;
	GList* keybindings;
	g_return_if_fail (self != NULL);
	_tmp0_ = keybinding_manager_get_instance ();
	keybinding_manager = _tmp0_;
	_tmp1_ = self->priv->m_keybindings;
	keybindings = _tmp1_;
	while (TRUE) {
		GList* _tmp2_;
		GList* _tmp3_;
		gconstpointer _tmp4_;
		PanelKeybinding* _tmp5_;
		PanelKeybinding* keybinding;
		KeybindingManager* _tmp6_;
		PanelKeybinding* _tmp7_;
		guint _tmp8_;
		guint _tmp9_;
		PanelKeybinding* _tmp10_;
		GdkModifierType _tmp11_;
		GdkModifierType _tmp12_;
		GList* _tmp13_;
		GList* _tmp14_;
		_tmp2_ = keybindings;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = keybindings;
		_tmp4_ = _tmp3_->data;
		_tmp5_ = _panel_keybinding_ref0 ((PanelKeybinding*) _tmp4_);
		keybinding = _tmp5_;
		_tmp6_ = keybinding_manager;
		_tmp7_ = keybinding;
		_tmp8_ = panel_keybinding_get_keysym (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = keybinding;
		_tmp11_ = panel_keybinding_get_modifiers (_tmp10_);
		_tmp12_ = _tmp11_;
		keybinding_manager_unbind (_tmp6_, _tmp9_, _tmp12_);
		_tmp13_ = keybindings;
		_tmp14_ = _tmp13_->next;
		keybindings = _tmp14_;
		_panel_keybinding_unref0 (keybinding);
	}
	__g_list_free__panel_keybinding_unref0_0 (self->priv->m_keybindings);
	self->priv->m_keybindings = NULL;
	_g_object_unref0 (keybinding_manager);
}


static void panel_set_custom_font (Panel* self) {
	GdkDisplay* _tmp0_ = NULL;
	GdkDisplay* _tmp1_;
	GdkDisplay* display;
	GdkScreen* _tmp2_ = NULL;
	GdkDisplay* _tmp3_;
	GdkScreen* _tmp6_;
	GdkScreen* _tmp7_;
	GdkScreen* screen;
	GdkScreen* _tmp8_;
	gboolean use_custom_font;
	IBusConfig* _tmp9_;
	GVariant* _tmp10_ = NULL;
	GVariant* var_use_custom_font;
	GVariant* _tmp11_;
	GtkCssProvider* _tmp14_;
	gboolean _tmp17_;
	gchar* font_name;
	IBusConfig* _tmp18_;
	GVariant* _tmp19_ = NULL;
	GVariant* var_custom_font;
	GVariant* _tmp20_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* data_format;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_ = NULL;
	gchar* data;
	GtkCssProvider* _tmp28_;
	GdkScreen* _tmp34_;
	GtkCssProvider* _tmp35_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	_tmp3_ = display;
	if (_tmp3_ != NULL) {
		GdkDisplay* _tmp4_;
		GdkScreen* _tmp5_ = NULL;
		_tmp4_ = display;
		_tmp5_ = gdk_display_get_default_screen (_tmp4_);
		_tmp2_ = _tmp5_;
	} else {
		_tmp2_ = NULL;
	}
	_tmp6_ = _tmp2_;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	screen = _tmp7_;
	_tmp8_ = screen;
	if (_tmp8_ == NULL) {
		g_warning ("panel.vala:198: Could not open display.");
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		return;
	}
	use_custom_font = FALSE;
	_tmp9_ = self->priv->m_config;
	_tmp10_ = ibus_config_get_value (_tmp9_, "panel", "use_custom_font");
	var_use_custom_font = _tmp10_;
	_tmp11_ = var_use_custom_font;
	if (_tmp11_ != NULL) {
		GVariant* _tmp12_;
		gboolean _tmp13_ = FALSE;
		_tmp12_ = var_use_custom_font;
		_tmp13_ = g_variant_get_boolean (_tmp12_);
		use_custom_font = _tmp13_;
	}
	_tmp14_ = self->priv->m_css_provider;
	if (_tmp14_ != NULL) {
		GdkScreen* _tmp15_;
		GtkCssProvider* _tmp16_;
		_tmp15_ = screen;
		_tmp16_ = self->priv->m_css_provider;
		gtk_style_context_remove_provider_for_screen (_tmp15_, (GtkStyleProvider*) _tmp16_);
		_g_object_unref0 (self->priv->m_css_provider);
		self->priv->m_css_provider = NULL;
	}
	_tmp17_ = use_custom_font;
	if (_tmp17_ == FALSE) {
		_g_variant_unref0 (var_use_custom_font);
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		return;
	}
	font_name = NULL;
	_tmp18_ = self->priv->m_config;
	_tmp19_ = ibus_config_get_value (_tmp18_, "panel", "custom_font");
	var_custom_font = _tmp19_;
	_tmp20_ = var_custom_font;
	if (_tmp20_ != NULL) {
		GVariant* _tmp21_;
		gchar* _tmp22_ = NULL;
		_tmp21_ = var_custom_font;
		_tmp22_ = g_variant_dup_string (_tmp21_, NULL);
		_g_free0 (font_name);
		font_name = _tmp22_;
	}
	_tmp23_ = font_name;
	if (_tmp23_ == NULL) {
		g_warning ("panel.vala:228: No config panel:custom_font.");
		_g_variant_unref0 (var_custom_font);
		_g_free0 (font_name);
		_g_variant_unref0 (var_use_custom_font);
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		return;
	}
	_tmp24_ = g_strdup ("GtkLabel { font: %s; }");
	data_format = _tmp24_;
	_tmp25_ = data_format;
	_tmp26_ = font_name;
	_tmp27_ = g_strdup_printf (_tmp25_, _tmp26_);
	data = _tmp27_;
	_tmp28_ = gtk_css_provider_new ();
	_g_object_unref0 (self->priv->m_css_provider);
	self->priv->m_css_provider = _tmp28_;
	{
		GtkCssProvider* _tmp29_;
		const gchar* _tmp30_;
		_tmp29_ = self->priv->m_css_provider;
		_tmp30_ = data;
		gtk_css_provider_load_from_data (_tmp29_, _tmp30_, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp31_;
		GError* _tmp32_;
		const gchar* _tmp33_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp31_ = font_name;
		_tmp32_ = e;
		_tmp33_ = _tmp32_->message;
		g_warning ("panel.vala:239: Failed css_provider_from_data: %s: %s", _tmp31_, _tmp33_);
		_g_error_free0 (e);
		_g_free0 (data);
		_g_free0 (data_format);
		_g_variant_unref0 (var_custom_font);
		_g_free0 (font_name);
		_g_variant_unref0 (var_use_custom_font);
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		return;
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_free0 (data);
		_g_free0 (data_format);
		_g_variant_unref0 (var_custom_font);
		_g_free0 (font_name);
		_g_variant_unref0 (var_use_custom_font);
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp34_ = screen;
	_tmp35_ = self->priv->m_css_provider;
	gtk_style_context_add_provider_for_screen (_tmp34_, (GtkStyleProvider*) _tmp35_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_g_free0 (data);
	_g_free0 (data_format);
	_g_variant_unref0 (var_custom_font);
	_g_free0 (font_name);
	_g_variant_unref0 (var_use_custom_font);
	_g_object_unref0 (screen);
	_g_object_unref0 (display);
}


static void panel_set_switcher_delay_time (Panel* self, GVariant* variant) {
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* var_switcher_delay_time;
	GVariant* _tmp2_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	gint32 _tmp7_ = 0;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = variant;
	_tmp1_ = _g_variant_ref0 (_tmp0_);
	var_switcher_delay_time = _tmp1_;
	_tmp2_ = var_switcher_delay_time;
	if (_tmp2_ == NULL) {
		IBusConfig* _tmp3_;
		GVariant* _tmp4_ = NULL;
		_tmp3_ = self->priv->m_config;
		_tmp4_ = ibus_config_get_value (_tmp3_, "general", "switcher-delay-time");
		_g_variant_unref0 (var_switcher_delay_time);
		var_switcher_delay_time = _tmp4_;
	}
	_tmp5_ = var_switcher_delay_time;
	if (_tmp5_ == NULL) {
		_g_variant_unref0 (var_switcher_delay_time);
		return;
	}
	_tmp6_ = var_switcher_delay_time;
	_tmp7_ = g_variant_get_int32 (_tmp6_);
	self->priv->m_switcher_delay_time = (gint) _tmp7_;
	_tmp8_ = self->priv->m_switcher_delay_time;
	if (_tmp8_ >= 0) {
		Switcher* _tmp9_;
		gint _tmp10_;
		_tmp9_ = self->priv->m_switcher;
		_tmp10_ = self->priv->m_switcher_delay_time;
		switcher_set_popup_delay_time (_tmp9_, (guint) _tmp10_);
	}
	_g_variant_unref0 (var_switcher_delay_time);
}


static void _panel_config_value_changed_cb_ibus_config_value_changed (IBusConfig* _sender, const gchar* section, const gchar* name, GVariant* value, gpointer self) {
	panel_config_value_changed_cb (self, _sender, section, name, value);
}


void panel_set_config (Panel* self, IBusConfig* config) {
	IBusConfig* _tmp0_;
	IBusConfig* _tmp4_;
	IBusConfig* _tmp5_;
	IBusConfig* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (config != NULL);
	_tmp0_ = self->priv->m_config;
	if (_tmp0_ != NULL) {
		IBusConfig* _tmp1_;
		guint _tmp2_ = 0U;
		IBusConfig* _tmp3_;
		_tmp1_ = self->priv->m_config;
		g_signal_parse_name ("value-changed", ibus_config_get_type (), &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _panel_config_value_changed_cb_ibus_config_value_changed, self);
		_tmp3_ = self->priv->m_config;
		ibus_config_watch (_tmp3_, NULL, NULL);
		_g_object_unref0 (self->priv->m_config);
		self->priv->m_config = NULL;
	}
	_tmp4_ = config;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->m_config);
	self->priv->m_config = _tmp5_;
	_tmp6_ = self->priv->m_config;
	if (_tmp6_ != NULL) {
		IBusConfig* _tmp7_;
		IBusConfig* _tmp8_;
		IBusConfig* _tmp9_;
		IBusConfig* _tmp10_;
		IBusConfig* _tmp11_;
		IBusConfig* _tmp12_;
		IBusConfig* _tmp13_;
		IBusConfig* _tmp14_;
		GVariant* _tmp15_ = NULL;
		GVariant* _tmp16_;
		IBusConfig* _tmp17_;
		GVariant* _tmp18_ = NULL;
		GVariant* _tmp19_;
		_tmp7_ = self->priv->m_config;
		g_signal_connect_object (_tmp7_, "value-changed", (GCallback) _panel_config_value_changed_cb_ibus_config_value_changed, self, 0);
		_tmp8_ = self->priv->m_config;
		ibus_config_watch (_tmp8_, "general", "preload_engines");
		_tmp9_ = self->priv->m_config;
		ibus_config_watch (_tmp9_, "general", "engines_order");
		_tmp10_ = self->priv->m_config;
		ibus_config_watch (_tmp10_, "general", "switcher_delay_time");
		_tmp11_ = self->priv->m_config;
		ibus_config_watch (_tmp11_, "general/hotkey", "triggers");
		_tmp12_ = self->priv->m_config;
		ibus_config_watch (_tmp12_, "panel", "custom_font");
		_tmp13_ = self->priv->m_config;
		ibus_config_watch (_tmp13_, "panel", "use_custom_font");
		_tmp14_ = self->priv->m_config;
		_tmp15_ = ibus_config_get_value (_tmp14_, "general", "preload_engines");
		_tmp16_ = _tmp15_;
		_tmp17_ = self->priv->m_config;
		_tmp18_ = ibus_config_get_value (_tmp17_, "general", "engines_order");
		_tmp19_ = _tmp18_;
		panel_update_engines (self, _tmp16_, _tmp19_);
		_g_variant_unref0 (_tmp19_);
		_g_variant_unref0 (_tmp16_);
		panel_unbind_switch_shortcut (self);
		panel_bind_switch_shortcut (self, NULL);
		panel_set_switcher_delay_time (self, NULL);
	} else {
		panel_update_engines (self, NULL, NULL);
	}
	panel_set_custom_font (self);
}


static void _vala_array_add15 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add16 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add17 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add18 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add19 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add20 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add21 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void panel_exec_setxkbmap (Panel* self, IBusEngineDesc* engine) {
	IBusEngineDesc* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* layout;
	IBusEngineDesc* _tmp3_;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* variant;
	IBusEngineDesc* _tmp6_;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* option;
	gchar* standard_error;
	gint exit_status;
	gchar* _tmp9_;
	gchar** _tmp10_ = NULL;
	gchar** args;
	gint args_length1;
	gint _args_size_;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_;
	gboolean _tmp15_;
	gboolean _tmp17_;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	const gchar* _tmp25_;
	gboolean _tmp27_;
	gboolean _tmp29_;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	const gchar* _tmp37_;
	gboolean _tmp39_;
	gboolean _tmp41_;
	gchar** _tmp49_;
	gint _tmp49__length1;
	gint _tmp59_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = engine;
	_tmp1_ = ibus_engine_desc_get_layout (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	layout = _tmp2_;
	_tmp3_ = engine;
	_tmp4_ = ibus_engine_desc_get_layout_variant (_tmp3_);
	_tmp5_ = g_strdup (_tmp4_);
	variant = _tmp5_;
	_tmp6_ = engine;
	_tmp7_ = ibus_engine_desc_get_layout_option (_tmp6_);
	_tmp8_ = g_strdup (_tmp7_);
	option = _tmp8_;
	standard_error = NULL;
	exit_status = 0;
	_tmp9_ = g_strdup ("setxkbmap");
	_tmp10_ = g_new0 (gchar*, 1 + 1);
	_tmp10_[0] = _tmp9_;
	args = _tmp10_;
	args_length1 = 1;
	_args_size_ = args_length1;
	_tmp13_ = layout;
	if (_tmp13_ != NULL) {
		const gchar* _tmp14_;
		_tmp14_ = layout;
		_tmp12_ = g_strcmp0 (_tmp14_, "") != 0;
	} else {
		_tmp12_ = FALSE;
	}
	_tmp15_ = _tmp12_;
	if (_tmp15_) {
		const gchar* _tmp16_;
		_tmp16_ = layout;
		_tmp11_ = g_strcmp0 (_tmp16_, "default") != 0;
	} else {
		_tmp11_ = FALSE;
	}
	_tmp17_ = _tmp11_;
	if (_tmp17_) {
		gchar** _tmp18_;
		gint _tmp18__length1;
		gchar* _tmp19_;
		gchar** _tmp20_;
		gint _tmp20__length1;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp18_ = args;
		_tmp18__length1 = args_length1;
		_tmp19_ = g_strdup ("-layout");
		_vala_array_add15 (&args, &args_length1, &_args_size_, _tmp19_);
		_tmp20_ = args;
		_tmp20__length1 = args_length1;
		_tmp21_ = layout;
		_tmp22_ = g_strdup (_tmp21_);
		_vala_array_add16 (&args, &args_length1, &_args_size_, _tmp22_);
	}
	_tmp25_ = variant;
	if (_tmp25_ != NULL) {
		const gchar* _tmp26_;
		_tmp26_ = variant;
		_tmp24_ = g_strcmp0 (_tmp26_, "") != 0;
	} else {
		_tmp24_ = FALSE;
	}
	_tmp27_ = _tmp24_;
	if (_tmp27_) {
		const gchar* _tmp28_;
		_tmp28_ = variant;
		_tmp23_ = g_strcmp0 (_tmp28_, "default") != 0;
	} else {
		_tmp23_ = FALSE;
	}
	_tmp29_ = _tmp23_;
	if (_tmp29_) {
		gchar** _tmp30_;
		gint _tmp30__length1;
		gchar* _tmp31_;
		gchar** _tmp32_;
		gint _tmp32__length1;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		_tmp30_ = args;
		_tmp30__length1 = args_length1;
		_tmp31_ = g_strdup ("-variant");
		_vala_array_add17 (&args, &args_length1, &_args_size_, _tmp31_);
		_tmp32_ = args;
		_tmp32__length1 = args_length1;
		_tmp33_ = variant;
		_tmp34_ = g_strdup (_tmp33_);
		_vala_array_add18 (&args, &args_length1, &_args_size_, _tmp34_);
	}
	_tmp37_ = option;
	if (_tmp37_ != NULL) {
		const gchar* _tmp38_;
		_tmp38_ = option;
		_tmp36_ = g_strcmp0 (_tmp38_, "") != 0;
	} else {
		_tmp36_ = FALSE;
	}
	_tmp39_ = _tmp36_;
	if (_tmp39_) {
		const gchar* _tmp40_;
		_tmp40_ = option;
		_tmp35_ = g_strcmp0 (_tmp40_, "default") != 0;
	} else {
		_tmp35_ = FALSE;
	}
	_tmp41_ = _tmp35_;
	if (_tmp41_) {
		gchar** _tmp42_;
		gint _tmp42__length1;
		gchar* _tmp43_;
		gchar** _tmp44_;
		gint _tmp44__length1;
		gchar* _tmp45_;
		gchar** _tmp46_;
		gint _tmp46__length1;
		const gchar* _tmp47_;
		gchar* _tmp48_;
		_tmp42_ = args;
		_tmp42__length1 = args_length1;
		_tmp43_ = g_strdup ("-option");
		_vala_array_add19 (&args, &args_length1, &_args_size_, _tmp43_);
		_tmp44_ = args;
		_tmp44__length1 = args_length1;
		_tmp45_ = g_strdup ("-option");
		_vala_array_add20 (&args, &args_length1, &_args_size_, _tmp45_);
		_tmp46_ = args;
		_tmp46__length1 = args_length1;
		_tmp47_ = option;
		_tmp48_ = g_strdup (_tmp47_);
		_vala_array_add21 (&args, &args_length1, &_args_size_, _tmp48_);
	}
	_tmp49_ = args;
	_tmp49__length1 = args_length1;
	if (_tmp49__length1 == 1) {
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (standard_error);
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		return;
	}
	{
		gchar** _tmp50_;
		gint _tmp50__length1;
		gchar* _tmp51_ = NULL;
		gint _tmp52_ = 0;
		gboolean _tmp53_ = FALSE;
		gboolean _tmp54_;
		_tmp50_ = args;
		_tmp50__length1 = args_length1;
		_tmp53_ = g_spawn_sync (NULL, _tmp50_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_tmp51_, &_tmp52_, &_inner_error_);
		_g_free0 (standard_error);
		standard_error = _tmp51_;
		exit_status = _tmp52_;
		_tmp54_ = _tmp53_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch3_g_spawn_error;
			}
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (standard_error);
			_g_free0 (option);
			_g_free0 (variant);
			_g_free0 (layout);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		if (!_tmp54_) {
			IBusEngineDesc* _tmp55_;
			const gchar* _tmp56_ = NULL;
			_tmp55_ = engine;
			_tmp56_ = ibus_engine_desc_get_layout (_tmp55_);
			g_warning ("panel.vala:329: Switch xkb layout to %s failed.", _tmp56_);
		}
	}
	goto __finally3;
	__catch3_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp57_;
		const gchar* _tmp58_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp57_ = e;
		_tmp58_ = _tmp57_->message;
		g_warning ("panel.vala:333: Execute setxkbmap failed: %s", _tmp58_);
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (standard_error);
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp59_ = exit_status;
	if (_tmp59_ != 0) {
		const gchar* _tmp60_;
		gchar* _tmp61_;
		gchar* _tmp62_;
		const gchar* _tmp63_;
		const gchar* _tmp65_;
		_tmp60_ = standard_error;
		_tmp61_ = g_strdup (_tmp60_);
		_tmp62_ = _tmp61_;
		_tmp63_ = _tmp62_;
		if (_tmp63_ == NULL) {
			gchar* _tmp64_;
			_tmp64_ = g_strdup ("(null)");
			_g_free0 (_tmp62_);
			_tmp62_ = _tmp64_;
		}
		_tmp65_ = _tmp62_;
		g_warning ("panel.vala:337: Execute setxkbmap failed: %s", _tmp65_);
		_g_free0 (_tmp62_);
	}
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (standard_error);
	_g_free0 (option);
	_g_free0 (variant);
	_g_free0 (layout);
}


static void panel_switch_engine (Panel* self, gint i, gboolean force) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gboolean _tmp4_;
	gboolean _tmp5_ = FALSE;
	gint _tmp6_;
	gboolean _tmp8_;
	IBusEngineDesc** _tmp9_;
	gint _tmp9__length1;
	gint _tmp10_;
	IBusEngineDesc* _tmp11_;
	IBusEngineDesc* _tmp12_;
	IBusEngineDesc* engine;
	IBusBus* _tmp13_;
	IBusEngineDesc* _tmp14_;
	const gchar* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	IBusEngineDesc* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp1_ = i;
	if (_tmp1_ >= 0) {
		gint _tmp2_;
		IBusEngineDesc** _tmp3_;
		gint _tmp3__length1;
		_tmp2_ = i;
		_tmp3_ = self->priv->m_engines;
		_tmp3__length1 = self->priv->m_engines_length1;
		_tmp0_ = _tmp2_ < _tmp3__length1;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	_vala_assert (_tmp4_, "i >= 0 && i < m_engines.length");
	_tmp6_ = i;
	if (_tmp6_ == 0) {
		gboolean _tmp7_;
		_tmp7_ = force;
		_tmp5_ = !_tmp7_;
	} else {
		_tmp5_ = FALSE;
	}
	_tmp8_ = _tmp5_;
	if (_tmp8_) {
		return;
	}
	_tmp9_ = self->priv->m_engines;
	_tmp9__length1 = self->priv->m_engines_length1;
	_tmp10_ = i;
	_tmp11_ = _tmp9_[_tmp10_];
	_tmp12_ = _g_object_ref0 (_tmp11_);
	engine = _tmp12_;
	_tmp13_ = self->priv->m_bus;
	_tmp14_ = engine;
	_tmp15_ = ibus_engine_desc_get_name (_tmp14_);
	_tmp16_ = ibus_bus_set_global_engine (_tmp13_, _tmp15_);
	if (!_tmp16_) {
		IBusEngineDesc* _tmp17_;
		const gchar* _tmp18_ = NULL;
		_tmp17_ = engine;
		_tmp18_ = ibus_engine_desc_get_name (_tmp17_);
		g_warning ("panel.vala:351: Switch engine to %s failed.", _tmp18_);
		_g_object_unref0 (engine);
		return;
	}
	_tmp19_ = engine;
	panel_exec_setxkbmap (self, _tmp19_);
	_g_object_unref0 (engine);
}


static void panel_config_value_changed_cb (Panel* self, IBusConfig* config, const gchar* section, const gchar* name, GVariant* variant) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp3_;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	gboolean _tmp8_;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_;
	gboolean _tmp16_;
	gboolean _tmp17_ = FALSE;
	const gchar* _tmp18_;
	gboolean _tmp20_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (config != NULL);
	g_return_if_fail (section != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (variant != NULL);
	_tmp1_ = section;
	if (g_strcmp0 (_tmp1_, "general") == 0) {
		const gchar* _tmp2_;
		_tmp2_ = name;
		_tmp0_ = g_strcmp0 (_tmp2_, "preload_engines") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		GVariant* _tmp4_;
		_tmp4_ = variant;
		panel_update_engines (self, _tmp4_, NULL);
		return;
	}
	_tmp6_ = section;
	if (g_strcmp0 (_tmp6_, "general/hotkey") == 0) {
		const gchar* _tmp7_;
		_tmp7_ = name;
		_tmp5_ = g_strcmp0 (_tmp7_, "triggers") == 0;
	} else {
		_tmp5_ = FALSE;
	}
	_tmp8_ = _tmp5_;
	if (_tmp8_) {
		GVariant* _tmp9_;
		panel_unbind_switch_shortcut (self);
		_tmp9_ = variant;
		panel_bind_switch_shortcut (self, _tmp9_);
		return;
	}
	_tmp11_ = section;
	if (g_strcmp0 (_tmp11_, "panel") == 0) {
		gboolean _tmp12_ = FALSE;
		const gchar* _tmp13_;
		gboolean _tmp15_;
		_tmp13_ = name;
		if (g_strcmp0 (_tmp13_, "custom_font") == 0) {
			_tmp12_ = TRUE;
		} else {
			const gchar* _tmp14_;
			_tmp14_ = name;
			_tmp12_ = g_strcmp0 (_tmp14_, "use_custom_font") == 0;
		}
		_tmp15_ = _tmp12_;
		_tmp10_ = _tmp15_;
	} else {
		_tmp10_ = FALSE;
	}
	_tmp16_ = _tmp10_;
	if (_tmp16_) {
		panel_set_custom_font (self);
		return;
	}
	_tmp18_ = section;
	if (g_strcmp0 (_tmp18_, "general") == 0) {
		const gchar* _tmp19_;
		_tmp19_ = name;
		_tmp17_ = g_strcmp0 (_tmp19_, "switcher_delay_time") == 0;
	} else {
		_tmp17_ = FALSE;
	}
	_tmp20_ = _tmp17_;
	if (_tmp20_) {
		GVariant* _tmp21_;
		_tmp21_ = variant;
		panel_set_switcher_delay_time (self, _tmp21_);
		return;
	}
}


static void panel_handle_engine_switch (Panel* self, GdkEvent* event, gboolean revert) {
	IBusEngineDesc** _tmp0_;
	gint _tmp0__length1;
	GdkEvent* _tmp1_;
	GdkEventKey _tmp2_;
	guint _tmp3_;
	guint keyval;
	GdkEvent* _tmp4_;
	GdkEventKey _tmp5_;
	GdkModifierType _tmp6_;
	guint modifiers;
	GdkEvent* _tmp7_;
	GdkEventKey _tmp8_;
	GdkModifierType _tmp9_;
	GdkModifierType _tmp10_ = 0;
	guint primary_modifiers;
	GdkEvent* _tmp11_;
	guint _tmp12_;
	gboolean _tmp13_ = FALSE;
	gboolean pressed;
	gboolean _tmp14_;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_;
	gboolean _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = self->priv->m_engines;
	_tmp0__length1 = self->priv->m_engines_length1;
	if (_tmp0__length1 <= 1) {
		return;
	}
	_tmp1_ = event;
	_tmp2_ = _tmp1_->key;
	_tmp3_ = _tmp2_.keyval;
	keyval = _tmp3_;
	_tmp4_ = event;
	_tmp5_ = _tmp4_->key;
	_tmp6_ = _tmp5_.state;
	modifiers = KEYBINDING_MANAGER_MODIFIER_FILTER & _tmp6_;
	_tmp7_ = event;
	_tmp8_ = _tmp7_->key;
	_tmp9_ = _tmp8_.state;
	_tmp10_ = keybinding_manager_get_primary_modifier ((guint) _tmp9_);
	primary_modifiers = (guint) _tmp10_;
	_tmp11_ = event;
	_tmp12_ = primary_modifiers;
	_tmp13_ = keybinding_manager_primary_modifier_still_pressed (_tmp11_, _tmp12_);
	pressed = _tmp13_;
	_tmp14_ = revert;
	if (_tmp14_) {
		guint _tmp15_;
		_tmp15_ = modifiers;
		modifiers = _tmp15_ & (~GDK_SHIFT_MASK);
	}
	_tmp17_ = pressed;
	if (_tmp17_) {
		gint _tmp18_;
		_tmp18_ = self->priv->m_switcher_delay_time;
		_tmp16_ = _tmp18_ >= 0;
	} else {
		_tmp16_ = FALSE;
	}
	_tmp19_ = _tmp16_;
	if (_tmp19_) {
		gint _tmp20_ = 0;
		gboolean _tmp21_;
		gint _tmp23_;
		gint i;
		Switcher* _tmp24_;
		guint _tmp25_;
		guint _tmp26_;
		GdkEvent* _tmp27_;
		IBusEngineDesc** _tmp28_;
		gint _tmp28__length1;
		gint _tmp29_;
		gint _tmp30_ = 0;
		gint _tmp31_;
		_tmp21_ = revert;
		if (_tmp21_) {
			IBusEngineDesc** _tmp22_;
			gint _tmp22__length1;
			_tmp22_ = self->priv->m_engines;
			_tmp22__length1 = self->priv->m_engines_length1;
			_tmp20_ = _tmp22__length1 - 1;
		} else {
			_tmp20_ = 1;
		}
		_tmp23_ = _tmp20_;
		i = _tmp23_;
		_tmp24_ = self->priv->m_switcher;
		_tmp25_ = keyval;
		_tmp26_ = modifiers;
		_tmp27_ = event;
		_tmp28_ = self->priv->m_engines;
		_tmp28__length1 = self->priv->m_engines_length1;
		_tmp29_ = i;
		_tmp30_ = switcher_run (_tmp24_, _tmp25_, _tmp26_, _tmp27_, _tmp28_, _tmp28__length1, _tmp29_);
		i = _tmp30_;
		_tmp31_ = i;
		if (_tmp31_ < 0) {
			g_debug ("panel.vala:407: switch cancelled");
		} else {
			gint _tmp32_;
			IBusEngineDesc** _tmp33_;
			gint _tmp33__length1;
			gint _tmp34_;
			_tmp32_ = i;
			_tmp33_ = self->priv->m_engines;
			_tmp33__length1 = self->priv->m_engines_length1;
			_vala_assert (_tmp32_ < _tmp33__length1, "i < m_engines.length");
			_tmp34_ = i;
			panel_switch_engine (self, _tmp34_, FALSE);
		}
	} else {
		gint _tmp35_ = 0;
		gboolean _tmp36_;
		gint _tmp38_;
		gint i;
		gint _tmp39_;
		_tmp36_ = revert;
		if (_tmp36_) {
			IBusEngineDesc** _tmp37_;
			gint _tmp37__length1;
			_tmp37_ = self->priv->m_engines;
			_tmp37__length1 = self->priv->m_engines_length1;
			_tmp35_ = _tmp37__length1 - 1;
		} else {
			_tmp35_ = 1;
		}
		_tmp38_ = _tmp35_;
		i = _tmp38_;
		_tmp39_ = i;
		panel_switch_engine (self, _tmp39_, FALSE);
	}
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void _vala_array_add22 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add23 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static IBusEngineDesc** _vala_array_dup3 (IBusEngineDesc** self, int length) {
	IBusEngineDesc** result;
	int i;
	result = g_new0 (IBusEngineDesc*, length + 1);
	for (i = 0; i < length; i++) {
		IBusEngineDesc* _tmp0_;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static IBusEngineDesc** _vala_array_dup4 (IBusEngineDesc** self, int length) {
	IBusEngineDesc** result;
	int i;
	result = g_new0 (IBusEngineDesc*, length + 1);
	for (i = 0; i < length; i++) {
		IBusEngineDesc* _tmp0_;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void panel_update_engines (Panel* self, GVariant* var_engines, GVariant* var_order) {
	gchar** engine_names;
	gint engine_names_length1;
	gint _engine_names_size_;
	GVariant* _tmp0_;
	gboolean _tmp4_ = FALSE;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gboolean _tmp7_;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gint __tmp10__size_ = 0;
	GVariant* _tmp11_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gchar** order_names;
	gint order_names_length1;
	gint _order_names_size_;
	gchar** _tmp17_ = NULL;
	gchar** names;
	gint names_length1;
	gint _names_size_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	gchar** _tmp25_;
	gint _tmp25__length1;
	IBusBus* _tmp32_;
	gchar** _tmp33_;
	gint _tmp33__length1;
	IBusEngineDesc** _tmp34_;
	IBusEngineDesc** _tmp35_ = NULL;
	IBusEngineDesc** engines;
	gint engines_length1;
	gint _engines_size_;
	IBusEngineDesc** _tmp36_;
	gint _tmp36__length1;
	g_return_if_fail (self != NULL);
	engine_names = NULL;
	engine_names_length1 = 0;
	_engine_names_size_ = engine_names_length1;
	_tmp0_ = var_engines;
	if (_tmp0_ != NULL) {
		GVariant* _tmp1_;
		size_t _tmp2_;
		gchar** _tmp3_ = NULL;
		_tmp1_ = var_engines;
		_tmp3_ = g_variant_dup_strv (_tmp1_, &_tmp2_);
		engine_names = (_vala_array_free (engine_names, engine_names_length1, (GDestroyNotify) g_free), NULL);
		engine_names = _tmp3_;
		engine_names_length1 = _tmp2_;
		_engine_names_size_ = engine_names_length1;
	}
	_tmp5_ = engine_names;
	_tmp5__length1 = engine_names_length1;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		gchar** _tmp6_;
		gint _tmp6__length1;
		_tmp6_ = engine_names;
		_tmp6__length1 = engine_names_length1;
		_tmp4_ = _tmp6__length1 == 0;
	}
	_tmp7_ = _tmp4_;
	if (_tmp7_) {
		gchar* _tmp8_;
		gchar** _tmp9_ = NULL;
		_tmp8_ = g_strdup ("xkb:us::eng");
		_tmp9_ = g_new0 (gchar*, 1 + 1);
		_tmp9_[0] = _tmp8_;
		engine_names = (_vala_array_free (engine_names, engine_names_length1, (GDestroyNotify) g_free), NULL);
		engine_names = _tmp9_;
		engine_names_length1 = 1;
		_engine_names_size_ = engine_names_length1;
	}
	_tmp11_ = var_order;
	if (_tmp11_ != NULL) {
		GVariant* _tmp12_;
		size_t _tmp13_;
		gchar** _tmp14_ = NULL;
		_tmp12_ = var_order;
		_tmp14_ = g_variant_dup_strv (_tmp12_, &_tmp13_);
		_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
		_tmp10_ = _tmp14_;
		_tmp10__length1 = _tmp13_;
		__tmp10__size_ = _tmp10__length1;
	} else {
		_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
		_tmp10_ = NULL;
		_tmp10__length1 = 0;
		__tmp10__size_ = _tmp10__length1;
	}
	_tmp15_ = _tmp10_;
	_tmp15__length1 = _tmp10__length1;
	_tmp16_ = (_tmp15_ != NULL) ? _vala_array_dup2 (_tmp15_, _tmp15__length1) : ((gpointer) _tmp15_);
	_tmp16__length1 = _tmp15__length1;
	order_names = _tmp16_;
	order_names_length1 = _tmp16__length1;
	_order_names_size_ = order_names_length1;
	_tmp17_ = g_new0 (gchar*, 0 + 1);
	names = _tmp17_;
	names_length1 = 0;
	_names_size_ = names_length1;
	_tmp18_ = order_names;
	_tmp18__length1 = order_names_length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp18_;
		name_collection_length1 = _tmp18__length1;
		for (name_it = 0; name_it < _tmp18__length1; name_it = name_it + 1) {
			gchar* _tmp19_;
			gchar* name = NULL;
			_tmp19_ = g_strdup (name_collection[name_it]);
			name = _tmp19_;
			{
				const gchar* _tmp20_;
				gchar** _tmp21_;
				gint _tmp21__length1;
				_tmp20_ = name;
				_tmp21_ = engine_names;
				_tmp21__length1 = engine_names_length1;
				if (_vala_string_array_contains (_tmp21_, _tmp21__length1, _tmp20_)) {
					gchar** _tmp22_;
					gint _tmp22__length1;
					const gchar* _tmp23_;
					gchar* _tmp24_;
					_tmp22_ = names;
					_tmp22__length1 = names_length1;
					_tmp23_ = name;
					_tmp24_ = g_strdup (_tmp23_);
					_vala_array_add22 (&names, &names_length1, &_names_size_, _tmp24_);
				}
				_g_free0 (name);
			}
		}
	}
	_tmp25_ = engine_names;
	_tmp25__length1 = engine_names_length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp25_;
		name_collection_length1 = _tmp25__length1;
		for (name_it = 0; name_it < _tmp25__length1; name_it = name_it + 1) {
			gchar* _tmp26_;
			gchar* name = NULL;
			_tmp26_ = g_strdup (name_collection[name_it]);
			name = _tmp26_;
			{
				const gchar* _tmp27_;
				gchar** _tmp28_;
				gint _tmp28__length1;
				gchar** _tmp29_;
				gint _tmp29__length1;
				const gchar* _tmp30_;
				gchar* _tmp31_;
				_tmp27_ = name;
				_tmp28_ = names;
				_tmp28__length1 = names_length1;
				if (_vala_string_array_contains (_tmp28_, _tmp28__length1, _tmp27_)) {
					_g_free0 (name);
					continue;
				}
				_tmp29_ = names;
				_tmp29__length1 = names_length1;
				_tmp30_ = name;
				_tmp31_ = g_strdup (_tmp30_);
				_vala_array_add23 (&names, &names_length1, &_names_size_, _tmp31_);
				_g_free0 (name);
			}
		}
	}
	_tmp32_ = self->priv->m_bus;
	_tmp33_ = names;
	_tmp33__length1 = names_length1;
	_tmp35_ = _tmp34_ = ibus_bus_get_engines_by_names (_tmp32_, _tmp33_);
	engines = _tmp35_;
	engines_length1 = _vala_array_length (_tmp34_);
	_engines_size_ = engines_length1;
	_tmp36_ = self->priv->m_engines;
	_tmp36__length1 = self->priv->m_engines_length1;
	if (_tmp36__length1 == 0) {
		IBusEngineDesc** _tmp37_;
		gint _tmp37__length1;
		IBusEngineDesc** _tmp38_;
		gint _tmp38__length1;
		_tmp37_ = engines;
		_tmp37__length1 = engines_length1;
		_tmp38_ = (_tmp37_ != NULL) ? _vala_array_dup3 (_tmp37_, _tmp37__length1) : ((gpointer) _tmp37_);
		_tmp38__length1 = _tmp37__length1;
		self->priv->m_engines = (_vala_array_free (self->priv->m_engines, self->priv->m_engines_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_engines = _tmp38_;
		self->priv->m_engines_length1 = _tmp38__length1;
		self->priv->_m_engines_size_ = self->priv->m_engines_length1;
		panel_switch_engine (self, 0, TRUE);
	} else {
		IBusEngineDesc** _tmp39_;
		gint _tmp39__length1;
		IBusEngineDesc* _tmp40_;
		IBusEngineDesc* _tmp41_;
		IBusEngineDesc* current_engine;
		IBusEngineDesc** _tmp42_;
		gint _tmp42__length1;
		IBusEngineDesc** _tmp43_;
		gint _tmp43__length1;
		gint i = 0;
		_tmp39_ = self->priv->m_engines;
		_tmp39__length1 = self->priv->m_engines_length1;
		_tmp40_ = _tmp39_[0];
		_tmp41_ = _g_object_ref0 (_tmp40_);
		current_engine = _tmp41_;
		_tmp42_ = engines;
		_tmp42__length1 = engines_length1;
		_tmp43_ = (_tmp42_ != NULL) ? _vala_array_dup4 (_tmp42_, _tmp42__length1) : ((gpointer) _tmp42_);
		_tmp43__length1 = _tmp42__length1;
		self->priv->m_engines = (_vala_array_free (self->priv->m_engines, self->priv->m_engines_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_engines = _tmp43_;
		self->priv->m_engines_length1 = _tmp43__length1;
		self->priv->_m_engines_size_ = self->priv->m_engines_length1;
		{
			gboolean _tmp44_;
			i = 0;
			_tmp44_ = TRUE;
			while (TRUE) {
				gboolean _tmp45_;
				gint _tmp47_;
				IBusEngineDesc** _tmp48_;
				gint _tmp48__length1;
				IBusEngineDesc* _tmp49_;
				const gchar* _tmp50_ = NULL;
				IBusEngineDesc** _tmp51_;
				gint _tmp51__length1;
				gint _tmp52_;
				IBusEngineDesc* _tmp53_;
				const gchar* _tmp54_ = NULL;
				_tmp45_ = _tmp44_;
				if (!_tmp45_) {
					gint _tmp46_;
					_tmp46_ = i;
					i = _tmp46_ + 1;
				}
				_tmp44_ = FALSE;
				_tmp47_ = i;
				_tmp48_ = self->priv->m_engines;
				_tmp48__length1 = self->priv->m_engines_length1;
				if (!(_tmp47_ < _tmp48__length1)) {
					break;
				}
				_tmp49_ = current_engine;
				_tmp50_ = ibus_engine_desc_get_name (_tmp49_);
				_tmp51_ = engines;
				_tmp51__length1 = engines_length1;
				_tmp52_ = i;
				_tmp53_ = _tmp51_[_tmp52_];
				_tmp54_ = ibus_engine_desc_get_name (_tmp53_);
				if (g_strcmp0 (_tmp50_, _tmp54_) == 0) {
					gint _tmp55_;
					_tmp55_ = i;
					panel_switch_engine (self, _tmp55_, FALSE);
					_g_object_unref0 (current_engine);
					engines = (_vala_array_free (engines, engines_length1, (GDestroyNotify) g_object_unref), NULL);
					names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
					order_names = (_vala_array_free (order_names, order_names_length1, (GDestroyNotify) g_free), NULL);
					_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
					engine_names = (_vala_array_free (engine_names, engine_names_length1, (GDestroyNotify) g_free), NULL);
					return;
				}
			}
		}
		panel_switch_engine (self, 0, TRUE);
		_g_object_unref0 (current_engine);
	}
	engines = (_vala_array_free (engines, engines_length1, (GDestroyNotify) g_object_unref), NULL);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	order_names = (_vala_array_free (order_names, order_names_length1, (GDestroyNotify) g_free), NULL);
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
	engine_names = (_vala_array_free (engine_names, engine_names_length1, (GDestroyNotify) g_free), NULL);
}


static void __lambda18_ (Panel* self, GPid pid, gint state) {
	GPid _tmp0_;
	GPid _tmp1_;
	GPid _tmp2_;
	_tmp0_ = pid;
	_tmp1_ = self->priv->m_setup_pid;
	if (_tmp0_ != _tmp1_) {
		return;
	}
	self->priv->m_setup_pid = (GPid) 0;
	_tmp2_ = pid;
	g_spawn_close_pid (_tmp2_);
}


static void ___lambda18__gchild_watch_func (GPid pid, gint status, gpointer self) {
	__lambda18_ (self, pid, status);
}


static void panel_show_setup_dialog (Panel* self) {
	GPid _tmp0_;
	gchar* _tmp3_ = NULL;
	gchar* binary;
	GPid _tmp13_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_setup_pid;
	if (_tmp0_ != ((GPid) 0)) {
		GPid _tmp1_;
		gint _tmp2_ = 0;
		_tmp1_ = self->priv->m_setup_pid;
		_tmp2_ = kill ((pid_t) _tmp1_, SIGUSR1);
		if (_tmp2_ == 0) {
			return;
		}
		self->priv->m_setup_pid = (GPid) 0;
	}
	_tmp3_ = g_build_filename (BINDIR, "ibus-setup", NULL);
	binary = _tmp3_;
	{
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar** _tmp7_ = NULL;
		gchar** _tmp8_;
		gint _tmp8__length1;
		GPid _tmp9_ = 0;
		_tmp4_ = binary;
		_tmp5_ = g_strdup (_tmp4_);
		_tmp6_ = g_strdup ("ibus-setup");
		_tmp7_ = g_new0 (gchar*, 2 + 1);
		_tmp7_[0] = _tmp5_;
		_tmp7_[1] = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp8__length1 = 2;
		g_spawn_async (NULL, _tmp8_, NULL, G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp9_, &_inner_error_);
		self->priv->m_setup_pid = _tmp9_;
		_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch4_g_spawn_error;
			}
			_g_free0 (binary);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally4;
	__catch4_g_spawn_error:
	{
		GError* e = NULL;
		const gchar* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = binary;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_warning ("panel.vala:479: Execute %s failed! %s", _tmp10_, _tmp12_);
		self->priv->m_setup_pid = (GPid) 0;
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_free0 (binary);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp13_ = self->priv->m_setup_pid;
	g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp13_, ___lambda18__gchild_watch_func, g_object_ref (self), g_object_unref);
	_g_free0 (binary);
}


static void panel_show_about_dialog (Panel* self) {
	GtkAboutDialog* _tmp0_;
	GtkAboutDialog* _tmp24_;
	gboolean _tmp25_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_about_dialog;
	if (_tmp0_ == NULL) {
		GtkAboutDialog* _tmp1_;
		GtkAboutDialog* _tmp2_;
		GtkAboutDialog* _tmp3_;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* copyright;
		GtkAboutDialog* _tmp6_;
		const gchar* _tmp7_;
		GtkAboutDialog* _tmp8_;
		GtkAboutDialog* _tmp9_;
		const gchar* _tmp10_ = NULL;
		GtkAboutDialog* _tmp11_;
		GtkAboutDialog* _tmp12_;
		gchar* _tmp13_;
		gchar** _tmp14_ = NULL;
		gchar** _tmp15_;
		gint _tmp15__length1;
		GtkAboutDialog* _tmp16_;
		gchar* _tmp17_;
		gchar** _tmp18_ = NULL;
		gchar** _tmp19_;
		gint _tmp19__length1;
		GtkAboutDialog* _tmp20_;
		const gchar* _tmp21_ = NULL;
		GtkAboutDialog* _tmp22_;
		GtkAboutDialog* _tmp23_;
		_tmp1_ = (GtkAboutDialog*) gtk_about_dialog_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->m_about_dialog);
		self->priv->m_about_dialog = _tmp1_;
		_tmp2_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_program_name (_tmp2_, "IBus");
		_tmp3_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_version (_tmp3_, PACKAGE_VERSION);
		_tmp4_ = _ ("Copyright (c) 2007-2012 Peng Huang\n" "Copyright (c) 2007-2010 Red Hat, Inc.\n");
		_tmp5_ = g_strdup (_tmp4_);
		copyright = _tmp5_;
		_tmp6_ = self->priv->m_about_dialog;
		_tmp7_ = copyright;
		gtk_about_dialog_set_copyright (_tmp6_, _tmp7_);
		_tmp8_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_license (_tmp8_, "LGPL");
		_tmp9_ = self->priv->m_about_dialog;
		_tmp10_ = _ ("IBus is an intelligent input bus for Linux/Unix.");
		gtk_about_dialog_set_comments (_tmp9_, _tmp10_);
		_tmp11_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_website (_tmp11_, "http://code.google.com/p/ibus");
		_tmp12_ = self->priv->m_about_dialog;
		_tmp13_ = g_strdup ("Peng Huang <shawn.p.huang@gmail.com>");
		_tmp14_ = g_new0 (gchar*, 1 + 1);
		_tmp14_[0] = _tmp13_;
		_tmp15_ = _tmp14_;
		_tmp15__length1 = 1;
		gtk_about_dialog_set_authors (_tmp12_, _tmp15_);
		_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_free), NULL);
		_tmp16_ = self->priv->m_about_dialog;
		_tmp17_ = g_strdup ("Peng Huang <shawn.p.huang@gmail.com>");
		_tmp18_ = g_new0 (gchar*, 1 + 1);
		_tmp18_[0] = _tmp17_;
		_tmp19_ = _tmp18_;
		_tmp19__length1 = 1;
		gtk_about_dialog_set_documenters (_tmp16_, _tmp19_);
		_tmp19_ = (_vala_array_free (_tmp19_, _tmp19__length1, (GDestroyNotify) g_free), NULL);
		_tmp20_ = self->priv->m_about_dialog;
		_tmp21_ = _ ("translator-credits");
		gtk_about_dialog_set_translator_credits (_tmp20_, _tmp21_);
		_tmp22_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_logo_icon_name (_tmp22_, "ibus");
		_tmp23_ = self->priv->m_about_dialog;
		gtk_window_set_icon_name ((GtkWindow*) _tmp23_, "ibus");
		_g_free0 (copyright);
	}
	_tmp24_ = self->priv->m_about_dialog;
	_tmp25_ = gtk_widget_get_visible ((GtkWidget*) _tmp24_);
	if (!_tmp25_) {
		GtkAboutDialog* _tmp26_;
		GtkAboutDialog* _tmp27_;
		_tmp26_ = self->priv->m_about_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp26_);
		_tmp27_ = self->priv->m_about_dialog;
		gtk_widget_hide ((GtkWidget*) _tmp27_);
	} else {
		GtkAboutDialog* _tmp28_;
		_tmp28_ = self->priv->m_about_dialog;
		gtk_window_present ((GtkWindow*) _tmp28_);
	}
}


static void ___lambda17_ (Panel* self, GtkMenuItem* i) {
	g_return_if_fail (i != NULL);
	panel_show_setup_dialog (self);
}


static void ____lambda17__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	___lambda17_ (self, _sender);
}


static void ___lambda19_ (Panel* self, GtkMenuItem* i) {
	g_return_if_fail (i != NULL);
	panel_show_about_dialog (self);
}


static void ____lambda19__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	___lambda19_ (self, _sender);
}


static void ___lambda20_ (Panel* self, GtkMenuItem* i) {
	IBusBus* _tmp0_;
	g_return_if_fail (i != NULL);
	_tmp0_ = self->priv->m_bus;
	ibus_bus_exit (_tmp0_, TRUE);
}


static void ____lambda20__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	___lambda20_ (self, _sender);
}


static void ___lambda21_ (Panel* self, GtkMenuItem* i) {
	IBusBus* _tmp0_;
	g_return_if_fail (i != NULL);
	_tmp0_ = self->priv->m_bus;
	ibus_bus_exit (_tmp0_, FALSE);
}


static void ____lambda21__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	___lambda21_ (self, _sender);
}


static void _gtk_status_icon_position_menu_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self) {
	gtk_status_icon_position_menu (menu, x, y, push_in, self);
}


static void panel_status_icon_popup_menu_cb (Panel* self, GtkStatusIcon* status_icon, guint button, guint activate_time) {
	GtkMenu* _tmp0_;
	GtkMenu* _tmp24_;
	GtkStatusIcon* _tmp25_;
	guint32 _tmp26_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (status_icon != NULL);
	_tmp0_ = self->priv->m_sys_menu;
	if (_tmp0_ == NULL) {
		GtkImageMenuItem* item = NULL;
		GtkMenu* _tmp1_;
		GtkImageMenuItem* _tmp2_;
		GtkImageMenuItem* _tmp3_;
		GtkMenu* _tmp4_;
		GtkImageMenuItem* _tmp5_;
		GtkImageMenuItem* _tmp6_;
		GtkImageMenuItem* _tmp7_;
		GtkMenu* _tmp8_;
		GtkImageMenuItem* _tmp9_;
		GtkMenu* _tmp10_;
		GtkSeparatorMenuItem* _tmp11_;
		GtkSeparatorMenuItem* _tmp12_;
		GtkImageMenuItem* _tmp13_;
		GtkImageMenuItem* _tmp14_;
		const gchar* _tmp15_ = NULL;
		GtkImageMenuItem* _tmp16_;
		GtkMenu* _tmp17_;
		GtkImageMenuItem* _tmp18_;
		GtkImageMenuItem* _tmp19_;
		GtkImageMenuItem* _tmp20_;
		GtkMenu* _tmp21_;
		GtkImageMenuItem* _tmp22_;
		GtkMenu* _tmp23_;
		_tmp1_ = (GtkMenu*) gtk_menu_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->m_sys_menu);
		self->priv->m_sys_menu = _tmp1_;
		_tmp2_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_PREFERENCES, NULL);
		g_object_ref_sink (_tmp2_);
		_g_object_unref0 (item);
		item = _tmp2_;
		_tmp3_ = item;
		g_signal_connect_object ((GtkMenuItem*) _tmp3_, "activate", (GCallback) ____lambda17__gtk_menu_item_activate, self, 0);
		_tmp4_ = self->priv->m_sys_menu;
		_tmp5_ = item;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp4_, (GtkWidget*) ((GtkMenuItem*) _tmp5_));
		_tmp6_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_ABOUT, NULL);
		g_object_ref_sink (_tmp6_);
		_g_object_unref0 (item);
		item = _tmp6_;
		_tmp7_ = item;
		g_signal_connect_object ((GtkMenuItem*) _tmp7_, "activate", (GCallback) ____lambda19__gtk_menu_item_activate, self, 0);
		_tmp8_ = self->priv->m_sys_menu;
		_tmp9_ = item;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp8_, (GtkWidget*) ((GtkMenuItem*) _tmp9_));
		_tmp10_ = self->priv->m_sys_menu;
		_tmp11_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
		g_object_ref_sink (_tmp11_);
		_tmp12_ = _tmp11_;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp10_, (GtkWidget*) ((GtkMenuItem*) _tmp12_));
		_g_object_unref0 (_tmp12_);
		_tmp13_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_REFRESH, NULL);
		g_object_ref_sink (_tmp13_);
		_g_object_unref0 (item);
		item = _tmp13_;
		_tmp14_ = item;
		_tmp15_ = _ ("Restart");
		gtk_menu_item_set_label ((GtkMenuItem*) _tmp14_, _tmp15_);
		_tmp16_ = item;
		g_signal_connect_object ((GtkMenuItem*) _tmp16_, "activate", (GCallback) ____lambda20__gtk_menu_item_activate, self, 0);
		_tmp17_ = self->priv->m_sys_menu;
		_tmp18_ = item;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp17_, (GtkWidget*) ((GtkMenuItem*) _tmp18_));
		_tmp19_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_QUIT, NULL);
		g_object_ref_sink (_tmp19_);
		_g_object_unref0 (item);
		item = _tmp19_;
		_tmp20_ = item;
		g_signal_connect_object ((GtkMenuItem*) _tmp20_, "activate", (GCallback) ____lambda21__gtk_menu_item_activate, self, 0);
		_tmp21_ = self->priv->m_sys_menu;
		_tmp22_ = item;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp21_, (GtkWidget*) ((GtkMenuItem*) _tmp22_));
		_tmp23_ = self->priv->m_sys_menu;
		gtk_widget_show_all ((GtkWidget*) _tmp23_);
		_g_object_unref0 (item);
	}
	_tmp24_ = self->priv->m_sys_menu;
	_tmp25_ = self->priv->m_status_icon;
	_tmp26_ = gtk_get_current_event_time ();
	gtk_menu_popup (_tmp24_, NULL, NULL, _gtk_status_icon_position_menu_gtk_menu_position_func, _tmp25_, (guint) 0, _tmp26_);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		Panel * self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->e);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static void ____lambda22_ (Block4Data* _data4_, GtkMenuItem* item) {
	Panel * self;
	self = _data4_->self;
	g_return_if_fail (item != NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				IBusEngineDesc** _tmp4_;
				gint _tmp4__length1;
				IBusEngineDesc* _tmp5_;
				IBusEngineDesc** _tmp6_;
				gint _tmp6__length1;
				gint _tmp7_;
				IBusEngineDesc* _tmp8_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->priv->m_engines;
				_tmp4__length1 = self->priv->m_engines_length1;
				if (!(_tmp3_ < _tmp4__length1)) {
					break;
				}
				_tmp5_ = _data4_->e;
				_tmp6_ = self->priv->m_engines;
				_tmp6__length1 = self->priv->m_engines_length1;
				_tmp7_ = i;
				_tmp8_ = _tmp6_[_tmp7_];
				if (_tmp5_ == _tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					panel_switch_engine (self, _tmp9_, FALSE);
					break;
				}
			}
		}
	}
}


static void _____lambda22__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	____lambda22_ (self, _sender);
}


static void panel_status_icon_activate_cb (Panel* self, GtkStatusIcon* status_icon) {
	GtkMenu* _tmp0_;
	PropertyManager* _tmp1_;
	GtkMenu* _tmp2_;
	GtkMenu* _tmp3_;
	GtkSeparatorMenuItem* _tmp4_;
	GtkSeparatorMenuItem* _tmp5_;
	IBusEngineDesc** _tmp6_;
	gint _tmp6__length1;
	GtkMenu* _tmp33_;
	GtkMenu* _tmp34_;
	GtkMenu* _tmp35_;
	GtkStatusIcon* _tmp36_;
	guint32 _tmp37_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (status_icon != NULL);
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->m_ime_menu);
	self->priv->m_ime_menu = _tmp0_;
	_tmp1_ = self->priv->m_property_manager;
	_tmp2_ = self->priv->m_ime_menu;
	property_manager_create_menu_items (_tmp1_, _tmp2_);
	_tmp3_ = self->priv->m_ime_menu;
	_tmp4_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp3_, (GtkWidget*) ((GtkMenuItem*) _tmp5_));
	_g_object_unref0 (_tmp5_);
	_tmp6_ = self->priv->m_engines;
	_tmp6__length1 = self->priv->m_engines_length1;
	{
		IBusEngineDesc** engine_collection = NULL;
		gint engine_collection_length1 = 0;
		gint _engine_collection_size_ = 0;
		gint engine_it = 0;
		engine_collection = _tmp6_;
		engine_collection_length1 = _tmp6__length1;
		for (engine_it = 0; engine_it < _tmp6__length1; engine_it = engine_it + 1) {
			IBusEngineDesc* _tmp7_;
			IBusEngineDesc* engine = NULL;
			_tmp7_ = _g_object_ref0 (engine_collection[engine_it]);
			engine = _tmp7_;
			{
				Block4Data* _data4_;
				IBusEngineDesc* _tmp8_;
				const gchar* _tmp9_ = NULL;
				gchar* _tmp10_;
				gchar* language;
				IBusEngineDesc* _tmp11_;
				const gchar* _tmp12_ = NULL;
				gchar* _tmp13_;
				gchar* longname;
				const gchar* _tmp14_;
				const gchar* _tmp15_ = NULL;
				const gchar* _tmp16_;
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_;
				GtkImageMenuItem* _tmp19_;
				GtkImageMenuItem* _tmp20_;
				GtkImageMenuItem* item;
				IBusEngineDesc* _tmp21_;
				const gchar* _tmp22_ = NULL;
				IBusEngineDesc* _tmp28_;
				IBusEngineDesc* _tmp29_;
				GtkImageMenuItem* _tmp30_;
				GtkMenu* _tmp31_;
				GtkImageMenuItem* _tmp32_;
				_data4_ = g_slice_new0 (Block4Data);
				_data4_->_ref_count_ = 1;
				_data4_->self = g_object_ref (self);
				_tmp8_ = engine;
				_tmp9_ = ibus_engine_desc_get_language (_tmp8_);
				_tmp10_ = g_strdup (_tmp9_);
				language = _tmp10_;
				_tmp11_ = engine;
				_tmp12_ = ibus_engine_desc_get_longname (_tmp11_);
				_tmp13_ = g_strdup (_tmp12_);
				longname = _tmp13_;
				_tmp14_ = language;
				_tmp15_ = ibus_get_language_name (_tmp14_);
				_tmp16_ = longname;
				_tmp17_ = g_strdup_printf ("%s - %s", _tmp15_, _tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_label (_tmp18_);
				g_object_ref_sink (_tmp19_);
				_tmp20_ = _tmp19_;
				_g_free0 (_tmp18_);
				item = _tmp20_;
				_tmp21_ = engine;
				_tmp22_ = ibus_engine_desc_get_icon (_tmp21_);
				if (g_strcmp0 (_tmp22_, "") != 0) {
					IBusEngineDesc* _tmp23_;
					const gchar* _tmp24_ = NULL;
					IconWidget* _tmp25_;
					IconWidget* icon;
					GtkImageMenuItem* _tmp26_;
					IconWidget* _tmp27_;
					_tmp23_ = engine;
					_tmp24_ = ibus_engine_desc_get_icon (_tmp23_);
					_tmp25_ = icon_widget_new (_tmp24_, GTK_ICON_SIZE_MENU);
					g_object_ref_sink (_tmp25_);
					icon = _tmp25_;
					_tmp26_ = item;
					_tmp27_ = icon;
					gtk_image_menu_item_set_image (_tmp26_, (GtkWidget*) _tmp27_);
					_g_object_unref0 (icon);
				}
				_tmp28_ = engine;
				_tmp29_ = _g_object_ref0 (_tmp28_);
				_data4_->e = _tmp29_;
				_tmp30_ = item;
				g_signal_connect_data ((GtkMenuItem*) _tmp30_, "activate", (GCallback) _____lambda22__gtk_menu_item_activate, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
				_tmp31_ = self->priv->m_ime_menu;
				_tmp32_ = item;
				gtk_container_add ((GtkContainer*) _tmp31_, (GtkWidget*) _tmp32_);
				_g_object_unref0 (item);
				_g_free0 (longname);
				_g_free0 (language);
				_g_object_unref0 (engine);
				block4_data_unref (_data4_);
				_data4_ = NULL;
			}
		}
	}
	_tmp33_ = self->priv->m_ime_menu;
	gtk_widget_show_all ((GtkWidget*) _tmp33_);
	_tmp34_ = self->priv->m_ime_menu;
	gtk_menu_shell_set_take_focus ((GtkMenuShell*) _tmp34_, FALSE);
	_tmp35_ = self->priv->m_ime_menu;
	_tmp36_ = self->priv->m_status_icon;
	_tmp37_ = gtk_get_current_event_time ();
	gtk_menu_popup (_tmp35_, NULL, NULL, _gtk_status_icon_position_menu_gtk_menu_position_func, _tmp36_, (guint) 0, _tmp37_);
}


static void panel_real_set_cursor_location (IBusPanelService* base, gint x, gint y, gint width, gint height) {
	Panel * self;
	CandidatePanel* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_candidate_panel;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = width;
	_tmp4_ = height;
	candidate_panel_set_cursor_location (_tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
}


static void panel_real_focus_in (IBusPanelService* base, const gchar* input_context_path) {
	Panel * self;
	self = (Panel*) base;
	g_return_if_fail (input_context_path != NULL);
}


static void panel_real_focus_out (IBusPanelService* base, const gchar* input_context_path) {
	Panel * self;
	self = (Panel*) base;
	g_return_if_fail (input_context_path != NULL);
}


static void panel_real_register_properties (IBusPanelService* base, IBusPropList* props) {
	Panel * self;
	PropertyManager* _tmp0_;
	IBusPropList* _tmp1_;
	self = (Panel*) base;
	g_return_if_fail (props != NULL);
	_tmp0_ = self->priv->m_property_manager;
	_tmp1_ = props;
	property_manager_set_properties (_tmp0_, _tmp1_);
}


static void panel_real_update_property (IBusPanelService* base, IBusProperty* prop) {
	Panel * self;
	PropertyManager* _tmp0_;
	IBusProperty* _tmp1_;
	self = (Panel*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = self->priv->m_property_manager;
	_tmp1_ = prop;
	property_manager_update_property (_tmp0_, _tmp1_);
}


static void panel_real_update_preedit_text (IBusPanelService* base, IBusText* text, guint cursor_pos, gboolean visible) {
	Panel * self;
	gboolean _tmp0_;
	self = (Panel*) base;
	g_return_if_fail (text != NULL);
	_tmp0_ = visible;
	if (_tmp0_) {
		CandidatePanel* _tmp1_;
		IBusText* _tmp2_;
		guint _tmp3_;
		_tmp1_ = self->priv->m_candidate_panel;
		_tmp2_ = text;
		_tmp3_ = cursor_pos;
		candidate_panel_set_preedit_text (_tmp1_, _tmp2_, _tmp3_);
	} else {
		CandidatePanel* _tmp4_;
		_tmp4_ = self->priv->m_candidate_panel;
		candidate_panel_set_preedit_text (_tmp4_, NULL, (guint) 0);
	}
}


static void panel_real_hide_preedit_text (IBusPanelService* base) {
	Panel * self;
	CandidatePanel* _tmp0_;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_candidate_panel;
	candidate_panel_set_preedit_text (_tmp0_, NULL, (guint) 0);
}


static void panel_real_update_auxiliary_text (IBusPanelService* base, IBusText* text, gboolean visible) {
	Panel * self;
	IBusText* _tmp0_ = NULL;
	gboolean _tmp1_;
	CandidatePanel* _tmp3_;
	IBusText* _tmp4_;
	self = (Panel*) base;
	g_return_if_fail (text != NULL);
	_tmp1_ = visible;
	if (_tmp1_) {
		IBusText* _tmp2_;
		_tmp2_ = text;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp3_ = self->priv->m_candidate_panel;
	_tmp4_ = _tmp0_;
	candidate_panel_set_auxiliary_text (_tmp3_, _tmp4_);
}


static void panel_real_hide_auxiliary_text (IBusPanelService* base) {
	Panel * self;
	CandidatePanel* _tmp0_;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_candidate_panel;
	candidate_panel_set_auxiliary_text (_tmp0_, NULL);
}


static void panel_real_update_lookup_table (IBusPanelService* base, IBusLookupTable* table, gboolean visible) {
	Panel * self;
	IBusLookupTable* _tmp0_ = NULL;
	gboolean _tmp1_;
	CandidatePanel* _tmp3_;
	IBusLookupTable* _tmp4_;
	self = (Panel*) base;
	g_return_if_fail (table != NULL);
	_tmp1_ = visible;
	if (_tmp1_) {
		IBusLookupTable* _tmp2_;
		_tmp2_ = table;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp3_ = self->priv->m_candidate_panel;
	_tmp4_ = _tmp0_;
	candidate_panel_set_lookup_table (_tmp3_, _tmp4_);
}


static void panel_real_hide_lookup_table (IBusPanelService* base) {
	Panel * self;
	CandidatePanel* _tmp0_;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_candidate_panel;
	candidate_panel_set_lookup_table (_tmp0_, NULL);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void _vala_array_add24 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void panel_real_state_changed (IBusPanelService* base) {
	Panel * self;
	gchar* _tmp0_;
	gchar* icon_name;
	IBusBus* _tmp1_;
	IBusEngineDesc* _tmp2_ = NULL;
	IBusEngineDesc* _tmp3_;
	IBusEngineDesc* engine;
	IBusEngineDesc* _tmp4_;
	const gchar* _tmp8_;
	gchar _tmp9_ = '\0';
	IBusEngineDesc* _tmp22_;
	gint i = 0;
	gint _tmp34_;
	gint _tmp35_;
	IBusEngineDesc** _tmp36_;
	gint _tmp36__length1;
	IBusEngineDesc** _tmp49_;
	gint _tmp49__length1;
	IBusEngineDesc* _tmp50_;
	IBusEngineDesc* _tmp51_;
	IBusEngineDesc* _tmp52_;
	gchar** _tmp53_ = NULL;
	gchar** names;
	gint names_length1;
	gint _names_size_;
	IBusEngineDesc** _tmp54_;
	gint _tmp54__length1;
	IBusConfig* _tmp60_;
	self = (Panel*) base;
	_tmp0_ = g_strdup ("ibus-keyboard");
	icon_name = _tmp0_;
	_tmp1_ = self->priv->m_bus;
	_tmp2_ = ibus_bus_get_global_engine (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	engine = _tmp3_;
	_tmp4_ = engine;
	if (_tmp4_ != NULL) {
		IBusEngineDesc* _tmp5_;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		_tmp5_ = engine;
		_tmp6_ = ibus_engine_desc_get_icon (_tmp5_);
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (icon_name);
		icon_name = _tmp7_;
	}
	_tmp8_ = icon_name;
	_tmp9_ = string_get (_tmp8_, (glong) 0);
	if (_tmp9_ == '/') {
		GtkStatusIcon* _tmp10_;
		const gchar* _tmp11_;
		_tmp10_ = self->priv->m_status_icon;
		_tmp11_ = icon_name;
		gtk_status_icon_set_from_file (_tmp10_, _tmp11_);
	} else {
		GtkIconTheme* _tmp12_ = NULL;
		GtkIconTheme* _tmp13_;
		GtkIconTheme* theme;
		GtkIconTheme* _tmp14_;
		const gchar* _tmp15_;
		GtkIconInfo* _tmp16_ = NULL;
		GtkIconInfo* _tmp17_;
		gboolean _tmp18_;
		_tmp12_ = gtk_icon_theme_get_default ();
		_tmp13_ = _g_object_ref0 (_tmp12_);
		theme = _tmp13_;
		_tmp14_ = theme;
		_tmp15_ = icon_name;
		_tmp16_ = gtk_icon_theme_lookup_icon (_tmp14_, _tmp15_, 48, 0);
		_tmp17_ = _tmp16_;
		_tmp18_ = _tmp17_ != NULL;
		_gtk_icon_info_free0 (_tmp17_);
		if (_tmp18_) {
			GtkStatusIcon* _tmp19_;
			const gchar* _tmp20_;
			_tmp19_ = self->priv->m_status_icon;
			_tmp20_ = icon_name;
			gtk_status_icon_set_from_icon_name (_tmp19_, _tmp20_);
		} else {
			GtkStatusIcon* _tmp21_;
			_tmp21_ = self->priv->m_status_icon;
			gtk_status_icon_set_from_icon_name (_tmp21_, "ibus-engine");
		}
		_g_object_unref0 (theme);
	}
	_tmp22_ = engine;
	if (_tmp22_ == NULL) {
		_g_object_unref0 (engine);
		_g_free0 (icon_name);
		return;
	}
	{
		gboolean _tmp23_;
		i = 0;
		_tmp23_ = TRUE;
		while (TRUE) {
			gboolean _tmp24_;
			gint _tmp26_;
			IBusEngineDesc** _tmp27_;
			gint _tmp27__length1;
			IBusEngineDesc** _tmp28_;
			gint _tmp28__length1;
			gint _tmp29_;
			IBusEngineDesc* _tmp30_;
			const gchar* _tmp31_ = NULL;
			IBusEngineDesc* _tmp32_;
			const gchar* _tmp33_ = NULL;
			_tmp24_ = _tmp23_;
			if (!_tmp24_) {
				gint _tmp25_;
				_tmp25_ = i;
				i = _tmp25_ + 1;
			}
			_tmp23_ = FALSE;
			_tmp26_ = i;
			_tmp27_ = self->priv->m_engines;
			_tmp27__length1 = self->priv->m_engines_length1;
			if (!(_tmp26_ < _tmp27__length1)) {
				break;
			}
			_tmp28_ = self->priv->m_engines;
			_tmp28__length1 = self->priv->m_engines_length1;
			_tmp29_ = i;
			_tmp30_ = _tmp28_[_tmp29_];
			_tmp31_ = ibus_engine_desc_get_name (_tmp30_);
			_tmp32_ = engine;
			_tmp33_ = ibus_engine_desc_get_name (_tmp32_);
			if (g_strcmp0 (_tmp31_, _tmp33_) == 0) {
				break;
			}
		}
	}
	_tmp34_ = i;
	if (_tmp34_ == 0) {
		_g_object_unref0 (engine);
		_g_free0 (icon_name);
		return;
	}
	_tmp35_ = i;
	_tmp36_ = self->priv->m_engines;
	_tmp36__length1 = self->priv->m_engines_length1;
	if (_tmp35_ >= _tmp36__length1) {
		_g_object_unref0 (engine);
		_g_free0 (icon_name);
		return;
	}
	{
		gint _tmp37_;
		gint j;
		_tmp37_ = i;
		j = _tmp37_;
		{
			gboolean _tmp38_;
			_tmp38_ = TRUE;
			while (TRUE) {
				gboolean _tmp39_;
				gint _tmp41_;
				IBusEngineDesc** _tmp42_;
				gint _tmp42__length1;
				gint _tmp43_;
				IBusEngineDesc** _tmp44_;
				gint _tmp44__length1;
				gint _tmp45_;
				IBusEngineDesc* _tmp46_;
				IBusEngineDesc* _tmp47_;
				IBusEngineDesc* _tmp48_;
				_tmp39_ = _tmp38_;
				if (!_tmp39_) {
					gint _tmp40_;
					_tmp40_ = j;
					j = _tmp40_ - 1;
				}
				_tmp38_ = FALSE;
				_tmp41_ = j;
				if (!(_tmp41_ > 0)) {
					break;
				}
				_tmp42_ = self->priv->m_engines;
				_tmp42__length1 = self->priv->m_engines_length1;
				_tmp43_ = j;
				_tmp44_ = self->priv->m_engines;
				_tmp44__length1 = self->priv->m_engines_length1;
				_tmp45_ = j;
				_tmp46_ = _tmp44_[_tmp45_ - 1];
				_tmp47_ = _g_object_ref0 (_tmp46_);
				_g_object_unref0 (_tmp42_[_tmp43_]);
				_tmp42_[_tmp43_] = _tmp47_;
				_tmp48_ = _tmp42_[_tmp43_];
			}
		}
	}
	_tmp49_ = self->priv->m_engines;
	_tmp49__length1 = self->priv->m_engines_length1;
	_tmp50_ = engine;
	_tmp51_ = _g_object_ref0 (_tmp50_);
	_g_object_unref0 (_tmp49_[0]);
	_tmp49_[0] = _tmp51_;
	_tmp52_ = _tmp49_[0];
	_tmp53_ = g_new0 (gchar*, 0 + 1);
	names = _tmp53_;
	names_length1 = 0;
	_names_size_ = names_length1;
	_tmp54_ = self->priv->m_engines;
	_tmp54__length1 = self->priv->m_engines_length1;
	{
		IBusEngineDesc** desc_collection = NULL;
		gint desc_collection_length1 = 0;
		gint _desc_collection_size_ = 0;
		gint desc_it = 0;
		desc_collection = _tmp54_;
		desc_collection_length1 = _tmp54__length1;
		for (desc_it = 0; desc_it < _tmp54__length1; desc_it = desc_it + 1) {
			IBusEngineDesc* _tmp55_;
			IBusEngineDesc* desc = NULL;
			_tmp55_ = _g_object_ref0 (desc_collection[desc_it]);
			desc = _tmp55_;
			{
				gchar** _tmp56_;
				gint _tmp56__length1;
				IBusEngineDesc* _tmp57_;
				const gchar* _tmp58_ = NULL;
				gchar* _tmp59_;
				_tmp56_ = names;
				_tmp56__length1 = names_length1;
				_tmp57_ = desc;
				_tmp58_ = ibus_engine_desc_get_name (_tmp57_);
				_tmp59_ = g_strdup (_tmp58_);
				_vala_array_add24 (&names, &names_length1, &_names_size_, _tmp59_);
				_g_object_unref0 (desc);
			}
		}
	}
	_tmp60_ = self->priv->m_config;
	if (_tmp60_ != NULL) {
		IBusConfig* _tmp61_;
		gchar** _tmp62_;
		gint _tmp62__length1;
		GVariant* _tmp63_;
		GVariant* _tmp64_;
		_tmp61_ = self->priv->m_config;
		_tmp62_ = names;
		_tmp62__length1 = names_length1;
		_tmp63_ = g_variant_new_strv (_tmp62_, _tmp62__length1);
		g_variant_ref_sink (_tmp63_);
		_tmp64_ = _tmp63_;
		ibus_config_set_value (_tmp61_, "general", "engines_order", _tmp64_);
		_g_variant_unref0 (_tmp64_);
	}
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (engine);
	_g_free0 (icon_name);
}


static PanelKeybinding* panel_keybinding_construct (GType object_type, guint keysym, GdkModifierType modifiers, gboolean reverse) {
	PanelKeybinding* self = NULL;
	guint _tmp0_;
	GdkModifierType _tmp1_;
	gboolean _tmp2_;
	self = (PanelKeybinding*) g_type_create_instance (object_type);
	_tmp0_ = keysym;
	panel_keybinding_set_keysym (self, _tmp0_);
	_tmp1_ = modifiers;
	panel_keybinding_set_modifiers (self, _tmp1_);
	_tmp2_ = reverse;
	panel_keybinding_set_reverse (self, _tmp2_);
	return self;
}


static PanelKeybinding* panel_keybinding_new (guint keysym, GdkModifierType modifiers, gboolean reverse) {
	return panel_keybinding_construct (PANEL_TYPE_KEYBINDING, keysym, modifiers, reverse);
}


static guint panel_keybinding_get_keysym (PanelKeybinding* self) {
	guint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_keysym;
	result = _tmp0_;
	return result;
}


static void panel_keybinding_set_keysym (PanelKeybinding* self, guint value) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_keysym = _tmp0_;
}


static GdkModifierType panel_keybinding_get_modifiers (PanelKeybinding* self) {
	GdkModifierType result;
	GdkModifierType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_modifiers;
	result = _tmp0_;
	return result;
}


static void panel_keybinding_set_modifiers (PanelKeybinding* self, GdkModifierType value) {
	GdkModifierType _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_modifiers = _tmp0_;
}


static gboolean panel_keybinding_get_reverse (PanelKeybinding* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_reverse;
	result = _tmp0_;
	return result;
}


static void panel_keybinding_set_reverse (PanelKeybinding* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_reverse = _tmp0_;
}


static void panel_value_keybinding_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void panel_value_keybinding_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		panel_keybinding_unref (value->data[0].v_pointer);
	}
}


static void panel_value_keybinding_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = panel_keybinding_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer panel_value_keybinding_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* panel_value_keybinding_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		PanelKeybinding* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = panel_keybinding_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* panel_value_keybinding_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PanelKeybinding** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = panel_keybinding_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* panel_param_spec_keybinding (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	PanelParamSpecKeybinding* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PANEL_TYPE_KEYBINDING), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer panel_value_get_keybinding (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PANEL_TYPE_KEYBINDING), NULL);
	return value->data[0].v_pointer;
}


static void panel_value_set_keybinding (GValue* value, gpointer v_object) {
	PanelKeybinding* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PANEL_TYPE_KEYBINDING));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PANEL_TYPE_KEYBINDING));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		panel_keybinding_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		panel_keybinding_unref (old);
	}
}


static void panel_value_take_keybinding (GValue* value, gpointer v_object) {
	PanelKeybinding* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PANEL_TYPE_KEYBINDING));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PANEL_TYPE_KEYBINDING));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		panel_keybinding_unref (old);
	}
}


static void panel_keybinding_class_init (PanelKeybindingClass * klass) {
	panel_keybinding_parent_class = g_type_class_peek_parent (klass);
	PANEL_KEYBINDING_CLASS (klass)->finalize = panel_keybinding_finalize;
	g_type_class_add_private (klass, sizeof (PanelKeybindingPrivate));
}


static void panel_keybinding_instance_init (PanelKeybinding * self) {
	self->priv = PANEL_KEYBINDING_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void panel_keybinding_finalize (PanelKeybinding* obj) {
	PanelKeybinding * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANEL_TYPE_KEYBINDING, PanelKeybinding);
}


static GType panel_keybinding_get_type (void) {
	static volatile gsize panel_keybinding_type_id__volatile = 0;
	if (g_once_init_enter (&panel_keybinding_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { panel_value_keybinding_init, panel_value_keybinding_free_value, panel_value_keybinding_copy_value, panel_value_keybinding_peek_pointer, "p", panel_value_keybinding_collect_value, "p", panel_value_keybinding_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PanelKeybindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) panel_keybinding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PanelKeybinding), 0, (GInstanceInitFunc) panel_keybinding_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType panel_keybinding_type_id;
		panel_keybinding_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PanelKeybinding", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&panel_keybinding_type_id__volatile, panel_keybinding_type_id);
	}
	return panel_keybinding_type_id__volatile;
}


static gpointer panel_keybinding_ref (gpointer instance) {
	PanelKeybinding* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void panel_keybinding_unref (gpointer instance) {
	PanelKeybinding* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PANEL_KEYBINDING_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void panel_class_init (PanelClass * klass) {
	panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PanelPrivate));
	IBUS_PANEL_SERVICE_CLASS (klass)->set_cursor_location = panel_real_set_cursor_location;
	IBUS_PANEL_SERVICE_CLASS (klass)->focus_in = panel_real_focus_in;
	IBUS_PANEL_SERVICE_CLASS (klass)->focus_out = panel_real_focus_out;
	IBUS_PANEL_SERVICE_CLASS (klass)->register_properties = panel_real_register_properties;
	IBUS_PANEL_SERVICE_CLASS (klass)->update_property = panel_real_update_property;
	IBUS_PANEL_SERVICE_CLASS (klass)->update_preedit_text = panel_real_update_preedit_text;
	IBUS_PANEL_SERVICE_CLASS (klass)->hide_preedit_text = panel_real_hide_preedit_text;
	IBUS_PANEL_SERVICE_CLASS (klass)->update_auxiliary_text = panel_real_update_auxiliary_text;
	IBUS_PANEL_SERVICE_CLASS (klass)->hide_auxiliary_text = panel_real_hide_auxiliary_text;
	IBUS_PANEL_SERVICE_CLASS (klass)->update_lookup_table = panel_real_update_lookup_table;
	IBUS_PANEL_SERVICE_CLASS (klass)->hide_lookup_table = panel_real_hide_lookup_table;
	IBUS_PANEL_SERVICE_CLASS (klass)->state_changed = panel_real_state_changed;
	G_OBJECT_CLASS (klass)->finalize = panel_finalize;
}


static void panel_instance_init (Panel * self) {
	IBusEngineDesc** _tmp0_ = NULL;
	self->priv = PANEL_GET_PRIVATE (self);
	_tmp0_ = g_new0 (IBusEngineDesc*, 0 + 1);
	self->priv->m_engines = _tmp0_;
	self->priv->m_engines_length1 = 0;
	self->priv->_m_engines_size_ = self->priv->m_engines_length1;
	self->priv->m_setup_pid = (GPid) 0;
	self->priv->m_switcher_delay_time = 400;
	self->priv->m_keybindings = NULL;
}


static void panel_finalize (GObject* obj) {
	Panel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PANEL, Panel);
	panel_unbind_switch_shortcut (self);
	_g_object_unref0 (self->priv->m_bus);
	_g_object_unref0 (self->priv->m_config);
	_g_object_unref0 (self->priv->m_status_icon);
	_g_object_unref0 (self->priv->m_ime_menu);
	_g_object_unref0 (self->priv->m_sys_menu);
	self->priv->m_engines = (_vala_array_free (self->priv->m_engines, self->priv->m_engines_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->m_candidate_panel);
	_g_object_unref0 (self->priv->m_switcher);
	_property_manager_unref0 (self->priv->m_property_manager);
	_g_object_unref0 (self->priv->m_about_dialog);
	_g_object_unref0 (self->priv->m_css_provider);
	__g_list_free__panel_keybinding_unref0_0 (self->priv->m_keybindings);
	G_OBJECT_CLASS (panel_parent_class)->finalize (obj);
}


GType panel_get_type (void) {
	static volatile gsize panel_type_id__volatile = 0;
	if (g_once_init_enter (&panel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Panel), 0, (GInstanceInitFunc) panel_instance_init, NULL };
		GType panel_type_id;
		panel_type_id = g_type_register_static (ibus_panel_service_get_type (), "Panel", &g_define_type_info, 0);
		g_once_init_leave (&panel_type_id__volatile, panel_type_id);
	}
	return panel_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



