/* panel.c generated by valac 0.18.0, the Vala compiler
 * generated from panel.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2011 Peng Huang <shawn.p.huang@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <ibus.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <config.h>
#include <glib/gi18n-lib.h>


#define TYPE_PANEL (panel_get_type ())
#define PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PANEL, Panel))
#define PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PANEL, PanelClass))
#define IS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PANEL))
#define IS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PANEL))
#define PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PANEL, PanelClass))

typedef struct _Panel Panel;
typedef struct _PanelClass PanelClass;
typedef struct _PanelPrivate PanelPrivate;

#define TYPE_CANDIDATE_PANEL (candidate_panel_get_type ())
#define CANDIDATE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANDIDATE_PANEL, CandidatePanel))
#define CANDIDATE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANDIDATE_PANEL, CandidatePanelClass))
#define IS_CANDIDATE_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANDIDATE_PANEL))
#define IS_CANDIDATE_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANDIDATE_PANEL))
#define CANDIDATE_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANDIDATE_PANEL, CandidatePanelClass))

typedef struct _CandidatePanel CandidatePanel;
typedef struct _CandidatePanelClass CandidatePanelClass;

#define TYPE_SWITCHER (switcher_get_type ())
#define SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SWITCHER, Switcher))
#define SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SWITCHER, SwitcherClass))
#define IS_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SWITCHER))
#define IS_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SWITCHER))
#define SWITCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SWITCHER, SwitcherClass))

typedef struct _Switcher Switcher;
typedef struct _SwitcherClass SwitcherClass;

#define TYPE_PROPERTY_MANAGER (property_manager_get_type ())
#define PROPERTY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_MANAGER, PropertyManager))
#define PROPERTY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_MANAGER, PropertyManagerClass))
#define IS_PROPERTY_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_MANAGER))
#define IS_PROPERTY_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_MANAGER))
#define PROPERTY_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_MANAGER, PropertyManagerClass))

typedef struct _PropertyManager PropertyManager;
typedef struct _PropertyManagerClass PropertyManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _property_manager_unref0(var) ((var == NULL) ? NULL : (var = (property_manager_unref (var), NULL)))

#define TYPE_KEYBINDING_MANAGER (keybinding_manager_get_type ())
#define KEYBINDING_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEYBINDING_MANAGER, KeybindingManager))
#define KEYBINDING_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEYBINDING_MANAGER, KeybindingManagerClass))
#define IS_KEYBINDING_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEYBINDING_MANAGER))
#define IS_KEYBINDING_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEYBINDING_MANAGER))
#define KEYBINDING_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEYBINDING_MANAGER, KeybindingManagerClass))

typedef struct _KeybindingManager KeybindingManager;
typedef struct _KeybindingManagerClass KeybindingManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block4Data Block4Data;

#define TYPE_ICON_WIDGET (icon_widget_get_type ())
#define ICON_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ICON_WIDGET, IconWidget))
#define ICON_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ICON_WIDGET, IconWidgetClass))
#define IS_ICON_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ICON_WIDGET))
#define IS_ICON_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ICON_WIDGET))
#define ICON_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ICON_WIDGET, IconWidgetClass))

typedef struct _IconWidget IconWidget;
typedef struct _IconWidgetClass IconWidgetClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Panel {
	IBusPanelService parent_instance;
	PanelPrivate * priv;
};

struct _PanelClass {
	IBusPanelServiceClass parent_class;
};

struct _PanelPrivate {
	IBusBus* m_bus;
	IBusConfig* m_config;
	GtkStatusIcon* m_status_icon;
	GtkMenu* m_ime_menu;
	GtkMenu* m_sys_menu;
	IBusEngineDesc** m_engines;
	gint m_engines_length1;
	gint _m_engines_size_;
	CandidatePanel* m_candidate_panel;
	Switcher* m_switcher;
	PropertyManager* m_property_manager;
	GPid m_setup_pid;
	GtkAboutDialog* m_about_dialog;
	GtkCssProvider* m_css_provider;
	gint m_switcher_delay_time;
	guint m_switch_keysym;
	GdkModifierType m_switch_modifiers;
};

typedef void (*KeybindingManagerKeybindingHandlerFunc) (GdkEvent* event, void* user_data);
struct _Block4Data {
	int _ref_count_;
	Panel * self;
	IBusEngineDesc* e;
};


static gpointer panel_parent_class = NULL;

GType panel_get_type (void) G_GNUC_CONST;
GType candidate_panel_get_type (void) G_GNUC_CONST;
GType switcher_get_type (void) G_GNUC_CONST;
gpointer property_manager_ref (gpointer instance);
void property_manager_unref (gpointer instance);
GParamSpec* param_spec_property_manager (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_property_manager (GValue* value, gpointer v_object);
void value_take_property_manager (GValue* value, gpointer v_object);
gpointer value_get_property_manager (const GValue* value);
GType property_manager_get_type (void) G_GNUC_CONST;
#define PANEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PANEL, PanelPrivate))
enum  {
	PANEL_DUMMY_PROPERTY
};
static void panel_unbind_switch_shortcut (Panel* self);
#define PANEL_ACCELERATOR_SWITCH_IME_FOREWARD "<Control>space"
Panel* panel_new (IBusBus* bus);
Panel* panel_construct (GType object_type, IBusBus* bus);
static void panel_status_icon_popup_menu_cb (Panel* self, GtkStatusIcon* status_icon, guint button, guint activate_time);
static void _panel_status_icon_popup_menu_cb_gtk_status_icon_popup_menu (GtkStatusIcon* _sender, guint button, guint activate_time, gpointer self);
static void panel_status_icon_activate_cb (Panel* self, GtkStatusIcon* status_icon);
static void _panel_status_icon_activate_cb_gtk_status_icon_activate (GtkStatusIcon* _sender, gpointer self);
CandidatePanel* candidate_panel_new (void);
CandidatePanel* candidate_panel_construct (GType object_type);
static void __lambda23_ (Panel* self, CandidatePanel* w);
static void ___lambda23__candidate_panel_page_up (CandidatePanel* _sender, gpointer self);
static void __lambda24_ (Panel* self, CandidatePanel* w);
static void ___lambda24__candidate_panel_page_down (CandidatePanel* _sender, gpointer self);
Switcher* switcher_new (void);
Switcher* switcher_construct (GType object_type);
static void panel_bind_switch_shortcut (Panel* self);
void switcher_set_popup_delay_time (Switcher* self, guint popup_delay_time);
PropertyManager* property_manager_new (void);
PropertyManager* property_manager_construct (GType object_type);
static void __lambda27_ (Panel* self, const gchar* k, gint s);
static void ___lambda27__property_manager_property_activate (PropertyManager* _sender, const gchar* key, gint state, gpointer self);
GType keybinding_manager_get_type (void) G_GNUC_CONST;
KeybindingManager* keybinding_manager_get_instance (void);
gboolean keybinding_manager_bind (KeybindingManager* self, guint keysym, GdkModifierType modifiers, KeybindingManagerKeybindingHandlerFunc handler, void* handler_target);
static void __lambda25_ (Panel* self, GdkEvent* e);
static void panel_handle_engine_switch (Panel* self, GdkEvent* event, gboolean revert);
static void ___lambda25__keybinding_manager_keybinding_handler_func (GdkEvent* event, gpointer self);
static void __lambda26_ (Panel* self, GdkEvent* e);
static void ___lambda26__keybinding_manager_keybinding_handler_func (GdkEvent* event, gpointer self);
void keybinding_manager_unbind (KeybindingManager* self, guint keysym, GdkModifierType modifiers);
static void panel_set_custom_font (Panel* self);
static void panel_set_switcher_delay_time (Panel* self, GVariant* variant);
void panel_set_config (Panel* self, IBusConfig* config);
static void panel_config_value_changed_cb (Panel* self, IBusConfig* config, const gchar* section, const gchar* name, GVariant* variant);
static void _panel_config_value_changed_cb_ibus_config_value_changed (IBusConfig* _sender, const gchar* section, const gchar* name, GVariant* value, gpointer self);
static void panel_update_engines (Panel* self, GVariant* var_engines, GVariant* var_order);
static void panel_exec_setxkbmap (Panel* self, IBusEngineDesc* engine);
static void _vala_array_add14 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add15 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add16 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add17 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add18 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add19 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add20 (gchar*** array, int* length, int* size, gchar* value);
static void panel_switch_engine (Panel* self, gint i, gboolean force);
GdkModifierType keybinding_manager_get_primary_modifier (guint binding_mask);
gboolean keybinding_manager_primary_modifier_still_pressed (GdkEvent* event, guint primary_modifier);
gint switcher_run (Switcher* self, guint keyval, guint state, GdkEvent* event, IBusEngineDesc** engines, int engines_length1, gint index);
static gchar** _vala_array_dup2 (gchar** self, int length);
static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle);
static void _vala_array_add21 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add22 (gchar*** array, int* length, int* size, gchar* value);
static IBusEngineDesc** _vala_array_dup3 (IBusEngineDesc** self, int length);
static IBusEngineDesc** _vala_array_dup4 (IBusEngineDesc** self, int length);
static void panel_show_setup_dialog (Panel* self);
static void __lambda18_ (Panel* self, GPid pid, gint state);
static void ___lambda18__gchild_watch_func (GPid pid, gint status, gpointer self);
static void panel_show_about_dialog (Panel* self);
static void ___lambda17_ (Panel* self, GtkMenuItem* i);
static void ____lambda17__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void ___lambda19_ (Panel* self, GtkMenuItem* i);
static void ____lambda19__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void ___lambda20_ (Panel* self, GtkMenuItem* i);
static void ____lambda20__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void ___lambda21_ (Panel* self, GtkMenuItem* i);
static void ____lambda21__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _gtk_status_icon_position_menu_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self);
gint property_manager_create_menu_items (PropertyManager* self, GtkMenu* menu);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
IconWidget* icon_widget_new (const gchar* icon, gint size);
IconWidget* icon_widget_construct (GType object_type, const gchar* icon, gint size);
GType icon_widget_get_type (void) G_GNUC_CONST;
static void ____lambda22_ (Block4Data* _data4_, GtkMenuItem* item);
static void _____lambda22__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void panel_real_set_cursor_location (IBusPanelService* base, gint x, gint y, gint width, gint height);
void candidate_panel_set_cursor_location (CandidatePanel* self, gint x, gint y, gint width, gint height);
static void panel_real_focus_in (IBusPanelService* base, const gchar* input_context_path);
static void panel_real_focus_out (IBusPanelService* base, const gchar* input_context_path);
static void panel_real_register_properties (IBusPanelService* base, IBusPropList* props);
void property_manager_set_properties (PropertyManager* self, IBusPropList* props);
static void panel_real_update_property (IBusPanelService* base, IBusProperty* prop);
void property_manager_update_property (PropertyManager* self, IBusProperty* prop);
static void panel_real_update_preedit_text (IBusPanelService* base, IBusText* text, guint cursor_pos, gboolean visible);
void candidate_panel_set_preedit_text (CandidatePanel* self, IBusText* text, guint cursor);
static void panel_real_hide_preedit_text (IBusPanelService* base);
static void panel_real_update_auxiliary_text (IBusPanelService* base, IBusText* text, gboolean visible);
void candidate_panel_set_auxiliary_text (CandidatePanel* self, IBusText* text);
static void panel_real_hide_auxiliary_text (IBusPanelService* base);
static void panel_real_update_lookup_table (IBusPanelService* base, IBusLookupTable* table, gboolean visible);
void candidate_panel_set_lookup_table (CandidatePanel* self, IBusLookupTable* table);
static void panel_real_hide_lookup_table (IBusPanelService* base);
static void panel_real_state_changed (IBusPanelService* base);
static void _vala_array_add23 (gchar*** array, int* length, int* size, gchar* value);
static void panel_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _panel_status_icon_popup_menu_cb_gtk_status_icon_popup_menu (GtkStatusIcon* _sender, guint button, guint activate_time, gpointer self) {
	panel_status_icon_popup_menu_cb (self, _sender, button, activate_time);
}


static void _panel_status_icon_activate_cb_gtk_status_icon_activate (GtkStatusIcon* _sender, gpointer self) {
	panel_status_icon_activate_cb (self, _sender);
}


static void __lambda23_ (Panel* self, CandidatePanel* w) {
	g_return_if_fail (w != NULL);
	ibus_panel_service_page_up ((IBusPanelService*) self);
}


static void ___lambda23__candidate_panel_page_up (CandidatePanel* _sender, gpointer self) {
	__lambda23_ (self, _sender);
}


static void __lambda24_ (Panel* self, CandidatePanel* w) {
	g_return_if_fail (w != NULL);
	ibus_panel_service_page_down ((IBusPanelService*) self);
}


static void ___lambda24__candidate_panel_page_down (CandidatePanel* _sender, gpointer self) {
	__lambda24_ (self, _sender);
}


static void __lambda27_ (Panel* self, const gchar* k, gint s) {
	const gchar* _tmp0_;
	gint _tmp1_;
	g_return_if_fail (k != NULL);
	_tmp0_ = k;
	_tmp1_ = s;
	ibus_panel_service_property_activate ((IBusPanelService*) self, _tmp0_, (guint) _tmp1_);
}


static void ___lambda27__property_manager_property_activate (PropertyManager* _sender, const gchar* key, gint state, gpointer self) {
	__lambda27_ (self, key, state);
}


Panel* panel_construct (GType object_type, IBusBus* bus) {
	Panel * self = NULL;
	IBusBus* _tmp0_;
	gboolean _tmp1_ = FALSE;
	IBusBus* _tmp2_;
	GDBusConnection* _tmp3_ = NULL;
	IBusBus* _tmp4_;
	IBusBus* _tmp5_;
	GtkStatusIcon* _tmp6_;
	GtkStatusIcon* _tmp7_;
	GtkStatusIcon* _tmp8_;
	GtkStatusIcon* _tmp9_;
	GtkStatusIcon* _tmp10_;
	GtkStatusIcon* _tmp11_;
	CandidatePanel* _tmp12_;
	CandidatePanel* _tmp13_;
	CandidatePanel* _tmp14_;
	Switcher* _tmp15_;
	gint _tmp16_;
	PropertyManager* _tmp19_;
	PropertyManager* _tmp20_;
	g_return_val_if_fail (bus != NULL, NULL);
	_tmp0_ = bus;
	_tmp1_ = ibus_bus_is_connected (_tmp0_);
	_vala_assert (_tmp1_, "bus.is_connected()");
	_tmp2_ = bus;
	_tmp3_ = ibus_bus_get_connection (_tmp2_);
	self = (Panel*) g_object_new (object_type, "connection", _tmp3_, "object-path", "/org/freedesktop/IBus/Panel", NULL);
	_tmp4_ = bus;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->m_bus);
	self->priv->m_bus = _tmp5_;
	_tmp6_ = gtk_status_icon_new ();
	_g_object_unref0 (self->priv->m_status_icon);
	self->priv->m_status_icon = _tmp6_;
	_tmp7_ = self->priv->m_status_icon;
	gtk_status_icon_set_name (_tmp7_, "ibus-ui-gtk");
	_tmp8_ = self->priv->m_status_icon;
	gtk_status_icon_set_title (_tmp8_, "IBus Panel");
	_tmp9_ = self->priv->m_status_icon;
	g_signal_connect_object (_tmp9_, "popup-menu", (GCallback) _panel_status_icon_popup_menu_cb_gtk_status_icon_popup_menu, self, 0);
	_tmp10_ = self->priv->m_status_icon;
	g_signal_connect_object (_tmp10_, "activate", (GCallback) _panel_status_icon_activate_cb_gtk_status_icon_activate, self, 0);
	_tmp11_ = self->priv->m_status_icon;
	gtk_status_icon_set_from_icon_name (_tmp11_, "ibus-keyboard");
	_tmp12_ = candidate_panel_new ();
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->m_candidate_panel);
	self->priv->m_candidate_panel = _tmp12_;
	_tmp13_ = self->priv->m_candidate_panel;
	g_signal_connect_object (_tmp13_, "page-up", (GCallback) ___lambda23__candidate_panel_page_up, self, 0);
	_tmp14_ = self->priv->m_candidate_panel;
	g_signal_connect_object (_tmp14_, "page-down", (GCallback) ___lambda24__candidate_panel_page_down, self, 0);
	_tmp15_ = switcher_new ();
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->m_switcher);
	self->priv->m_switcher = _tmp15_;
	panel_bind_switch_shortcut (self);
	_tmp16_ = self->priv->m_switcher_delay_time;
	if (_tmp16_ >= 0) {
		Switcher* _tmp17_;
		gint _tmp18_;
		_tmp17_ = self->priv->m_switcher;
		_tmp18_ = self->priv->m_switcher_delay_time;
		switcher_set_popup_delay_time (_tmp17_, (guint) _tmp18_);
	}
	_tmp19_ = property_manager_new ();
	_property_manager_unref0 (self->priv->m_property_manager);
	self->priv->m_property_manager = _tmp19_;
	_tmp20_ = self->priv->m_property_manager;
	g_signal_connect_object (_tmp20_, "property-activate", (GCallback) ___lambda27__property_manager_property_activate, self, 0);
	g_signal_emit_by_name ((IBusPanelService*) self, "state-changed");
	return self;
}


Panel* panel_new (IBusBus* bus) {
	return panel_construct (TYPE_PANEL, bus);
}


static void __lambda25_ (Panel* self, GdkEvent* e) {
	GdkEvent* _tmp0_;
	g_return_if_fail (e != NULL);
	_tmp0_ = e;
	panel_handle_engine_switch (self, _tmp0_, FALSE);
}


static void ___lambda25__keybinding_manager_keybinding_handler_func (GdkEvent* event, gpointer self) {
	__lambda25_ (self, event);
}


static void __lambda26_ (Panel* self, GdkEvent* e) {
	GdkEvent* _tmp0_;
	g_return_if_fail (e != NULL);
	_tmp0_ = e;
	panel_handle_engine_switch (self, _tmp0_, TRUE);
}


static void ___lambda26__keybinding_manager_keybinding_handler_func (GdkEvent* event, gpointer self) {
	__lambda26_ (self, event);
}


static void panel_bind_switch_shortcut (Panel* self) {
	KeybindingManager* _tmp0_ = NULL;
	KeybindingManager* keybinding_manager;
	gchar* _tmp1_;
	gchar* accelerator;
	const gchar* _tmp2_;
	guint _tmp3_ = 0U;
	GdkModifierType _tmp4_ = 0;
	static const GdkModifierType VIRTUAL_MODIFIERS = (GDK_SUPER_MASK | GDK_HYPER_MASK) | GDK_META_MASK;
	GdkModifierType _tmp5_;
	gboolean _tmp8_ = FALSE;
	guint _tmp9_;
	gboolean _tmp11_;
	KeybindingManager* _tmp13_;
	guint _tmp14_;
	GdkModifierType _tmp15_;
	GdkModifierType _tmp16_;
	KeybindingManager* _tmp17_;
	guint _tmp18_;
	GdkModifierType _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = keybinding_manager_get_instance ();
	keybinding_manager = _tmp0_;
	_tmp1_ = g_strdup (PANEL_ACCELERATOR_SWITCH_IME_FOREWARD);
	accelerator = _tmp1_;
	_tmp2_ = accelerator;
	gtk_accelerator_parse (_tmp2_, &_tmp3_, &_tmp4_);
	self->priv->m_switch_keysym = _tmp3_;
	self->priv->m_switch_modifiers = _tmp4_;
	_tmp5_ = self->priv->m_switch_modifiers;
	if ((_tmp5_ & VIRTUAL_MODIFIERS) != 0) {
		GdkKeymap* _tmp6_ = NULL;
		GdkModifierType _tmp7_;
		_tmp6_ = gdk_keymap_get_default ();
		gdk_keymap_map_virtual_modifiers (_tmp6_, &self->priv->m_switch_modifiers);
		_tmp7_ = self->priv->m_switch_modifiers;
		self->priv->m_switch_modifiers = _tmp7_ & (~VIRTUAL_MODIFIERS);
	}
	_tmp9_ = self->priv->m_switch_keysym;
	if (_tmp9_ == ((guint) 0)) {
		GdkModifierType _tmp10_;
		_tmp10_ = self->priv->m_switch_modifiers;
		_tmp8_ = _tmp10_ == 0;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp11_ = _tmp8_;
	if (_tmp11_) {
		const gchar* _tmp12_;
		_tmp12_ = accelerator;
		g_warning ("panel.vala:109: Parse accelerator '%s' failed!", _tmp12_);
		_g_free0 (accelerator);
		_g_object_unref0 (keybinding_manager);
		return;
	}
	_tmp13_ = keybinding_manager;
	_tmp14_ = self->priv->m_switch_keysym;
	_tmp15_ = self->priv->m_switch_modifiers;
	keybinding_manager_bind (_tmp13_, _tmp14_, _tmp15_, ___lambda25__keybinding_manager_keybinding_handler_func, self);
	_tmp16_ = self->priv->m_switch_modifiers;
	if ((_tmp16_ & GDK_SHIFT_MASK) != 0) {
		_g_free0 (accelerator);
		_g_object_unref0 (keybinding_manager);
		return;
	}
	_tmp17_ = keybinding_manager;
	_tmp18_ = self->priv->m_switch_keysym;
	_tmp19_ = self->priv->m_switch_modifiers;
	keybinding_manager_bind (_tmp17_, _tmp18_, _tmp19_ | GDK_SHIFT_MASK, ___lambda26__keybinding_manager_keybinding_handler_func, self);
	_g_free0 (accelerator);
	_g_object_unref0 (keybinding_manager);
}


static void panel_unbind_switch_shortcut (Panel* self) {
	KeybindingManager* _tmp0_ = NULL;
	KeybindingManager* keybinding_manager;
	gboolean _tmp1_ = FALSE;
	guint _tmp2_;
	gboolean _tmp4_;
	KeybindingManager* _tmp5_;
	guint _tmp6_;
	GdkModifierType _tmp7_;
	KeybindingManager* _tmp8_;
	guint _tmp9_;
	GdkModifierType _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = keybinding_manager_get_instance ();
	keybinding_manager = _tmp0_;
	_tmp2_ = self->priv->m_switch_keysym;
	if (_tmp2_ == ((guint) 0)) {
		GdkModifierType _tmp3_;
		_tmp3_ = self->priv->m_switch_modifiers;
		_tmp1_ = _tmp3_ == 0;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp4_ = _tmp1_;
	if (_tmp4_) {
		_g_object_unref0 (keybinding_manager);
		return;
	}
	_tmp5_ = keybinding_manager;
	_tmp6_ = self->priv->m_switch_keysym;
	_tmp7_ = self->priv->m_switch_modifiers;
	keybinding_manager_unbind (_tmp5_, _tmp6_, _tmp7_);
	_tmp8_ = keybinding_manager;
	_tmp9_ = self->priv->m_switch_keysym;
	_tmp10_ = self->priv->m_switch_modifiers;
	keybinding_manager_unbind (_tmp8_, _tmp9_, _tmp10_ | GDK_SHIFT_MASK);
	self->priv->m_switch_keysym = (guint) 0;
	self->priv->m_switch_modifiers = 0;
	_g_object_unref0 (keybinding_manager);
}


static void panel_set_custom_font (Panel* self) {
	GdkDisplay* _tmp0_ = NULL;
	GdkDisplay* _tmp1_;
	GdkDisplay* display;
	GdkScreen* _tmp2_ = NULL;
	GdkDisplay* _tmp3_;
	GdkScreen* _tmp6_;
	GdkScreen* _tmp7_;
	GdkScreen* screen;
	GdkScreen* _tmp8_;
	gboolean use_custom_font;
	IBusConfig* _tmp9_;
	GVariant* _tmp10_ = NULL;
	GVariant* var_use_custom_font;
	GVariant* _tmp11_;
	GtkCssProvider* _tmp14_;
	gboolean _tmp17_;
	gchar* font_name;
	IBusConfig* _tmp18_;
	GVariant* _tmp19_ = NULL;
	GVariant* var_custom_font;
	GVariant* _tmp20_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* data_format;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_ = NULL;
	gchar* data;
	GtkCssProvider* _tmp28_;
	GdkScreen* _tmp34_;
	GtkCssProvider* _tmp35_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gdk_display_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	display = _tmp1_;
	_tmp3_ = display;
	if (_tmp3_ != NULL) {
		GdkDisplay* _tmp4_;
		GdkScreen* _tmp5_ = NULL;
		_tmp4_ = display;
		_tmp5_ = gdk_display_get_default_screen (_tmp4_);
		_tmp2_ = _tmp5_;
	} else {
		_tmp2_ = NULL;
	}
	_tmp6_ = _tmp2_;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	screen = _tmp7_;
	_tmp8_ = screen;
	if (_tmp8_ == NULL) {
		g_warning ("panel.vala:145: Could not open display.");
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		return;
	}
	use_custom_font = FALSE;
	_tmp9_ = self->priv->m_config;
	_tmp10_ = ibus_config_get_value (_tmp9_, "panel", "use_custom_font");
	var_use_custom_font = _tmp10_;
	_tmp11_ = var_use_custom_font;
	if (_tmp11_ != NULL) {
		GVariant* _tmp12_;
		gboolean _tmp13_ = FALSE;
		_tmp12_ = var_use_custom_font;
		_tmp13_ = g_variant_get_boolean (_tmp12_);
		use_custom_font = _tmp13_;
	}
	_tmp14_ = self->priv->m_css_provider;
	if (_tmp14_ != NULL) {
		GdkScreen* _tmp15_;
		GtkCssProvider* _tmp16_;
		_tmp15_ = screen;
		_tmp16_ = self->priv->m_css_provider;
		gtk_style_context_remove_provider_for_screen (_tmp15_, (GtkStyleProvider*) _tmp16_);
		_g_object_unref0 (self->priv->m_css_provider);
		self->priv->m_css_provider = NULL;
	}
	_tmp17_ = use_custom_font;
	if (_tmp17_ == FALSE) {
		_g_variant_unref0 (var_use_custom_font);
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		return;
	}
	font_name = NULL;
	_tmp18_ = self->priv->m_config;
	_tmp19_ = ibus_config_get_value (_tmp18_, "panel", "custom_font");
	var_custom_font = _tmp19_;
	_tmp20_ = var_custom_font;
	if (_tmp20_ != NULL) {
		GVariant* _tmp21_;
		gchar* _tmp22_ = NULL;
		_tmp21_ = var_custom_font;
		_tmp22_ = g_variant_dup_string (_tmp21_, NULL);
		_g_free0 (font_name);
		font_name = _tmp22_;
	}
	_tmp23_ = font_name;
	if (_tmp23_ == NULL) {
		g_warning ("panel.vala:175: No config panel:custom_font.");
		_g_variant_unref0 (var_custom_font);
		_g_free0 (font_name);
		_g_variant_unref0 (var_use_custom_font);
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		return;
	}
	_tmp24_ = g_strdup ("GtkLabel { font: %s; }");
	data_format = _tmp24_;
	_tmp25_ = data_format;
	_tmp26_ = font_name;
	_tmp27_ = g_strdup_printf (_tmp25_, _tmp26_);
	data = _tmp27_;
	_tmp28_ = gtk_css_provider_new ();
	_g_object_unref0 (self->priv->m_css_provider);
	self->priv->m_css_provider = _tmp28_;
	{
		GtkCssProvider* _tmp29_;
		const gchar* _tmp30_;
		_tmp29_ = self->priv->m_css_provider;
		_tmp30_ = data;
		gtk_css_provider_load_from_data (_tmp29_, _tmp30_, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp31_;
		GError* _tmp32_;
		const gchar* _tmp33_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp31_ = font_name;
		_tmp32_ = e;
		_tmp33_ = _tmp32_->message;
		g_warning ("panel.vala:186: Failed css_provider_from_data: %s: %s", _tmp31_, _tmp33_);
		_g_error_free0 (e);
		_g_free0 (data);
		_g_free0 (data_format);
		_g_variant_unref0 (var_custom_font);
		_g_free0 (font_name);
		_g_variant_unref0 (var_use_custom_font);
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		return;
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_free0 (data);
		_g_free0 (data_format);
		_g_variant_unref0 (var_custom_font);
		_g_free0 (font_name);
		_g_variant_unref0 (var_use_custom_font);
		_g_object_unref0 (screen);
		_g_object_unref0 (display);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp34_ = screen;
	_tmp35_ = self->priv->m_css_provider;
	gtk_style_context_add_provider_for_screen (_tmp34_, (GtkStyleProvider*) _tmp35_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_g_free0 (data);
	_g_free0 (data_format);
	_g_variant_unref0 (var_custom_font);
	_g_free0 (font_name);
	_g_variant_unref0 (var_use_custom_font);
	_g_object_unref0 (screen);
	_g_object_unref0 (display);
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static void panel_set_switcher_delay_time (Panel* self, GVariant* variant) {
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* var_switcher_delay_time;
	GVariant* _tmp2_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	gint32 _tmp7_ = 0;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = variant;
	_tmp1_ = _g_variant_ref0 (_tmp0_);
	var_switcher_delay_time = _tmp1_;
	_tmp2_ = var_switcher_delay_time;
	if (_tmp2_ == NULL) {
		IBusConfig* _tmp3_;
		GVariant* _tmp4_ = NULL;
		_tmp3_ = self->priv->m_config;
		_tmp4_ = ibus_config_get_value (_tmp3_, "general", "switcher-delay-time");
		_g_variant_unref0 (var_switcher_delay_time);
		var_switcher_delay_time = _tmp4_;
	}
	_tmp5_ = var_switcher_delay_time;
	if (_tmp5_ == NULL) {
		_g_variant_unref0 (var_switcher_delay_time);
		return;
	}
	_tmp6_ = var_switcher_delay_time;
	_tmp7_ = g_variant_get_int32 (_tmp6_);
	self->priv->m_switcher_delay_time = (gint) _tmp7_;
	_tmp8_ = self->priv->m_switcher_delay_time;
	if (_tmp8_ >= 0) {
		Switcher* _tmp9_;
		gint _tmp10_;
		_tmp9_ = self->priv->m_switcher;
		_tmp10_ = self->priv->m_switcher_delay_time;
		switcher_set_popup_delay_time (_tmp9_, (guint) _tmp10_);
	}
	_g_variant_unref0 (var_switcher_delay_time);
}


static void _panel_config_value_changed_cb_ibus_config_value_changed (IBusConfig* _sender, const gchar* section, const gchar* name, GVariant* value, gpointer self) {
	panel_config_value_changed_cb (self, _sender, section, name, value);
}


void panel_set_config (Panel* self, IBusConfig* config) {
	IBusConfig* _tmp0_;
	IBusConfig* _tmp4_;
	IBusConfig* _tmp5_;
	IBusConfig* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (config != NULL);
	_tmp0_ = self->priv->m_config;
	if (_tmp0_ != NULL) {
		IBusConfig* _tmp1_;
		guint _tmp2_ = 0U;
		IBusConfig* _tmp3_;
		_tmp1_ = self->priv->m_config;
		g_signal_parse_name ("value-changed", ibus_config_get_type (), &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _panel_config_value_changed_cb_ibus_config_value_changed, self);
		_tmp3_ = self->priv->m_config;
		ibus_config_watch (_tmp3_, NULL, NULL);
		_g_object_unref0 (self->priv->m_config);
		self->priv->m_config = NULL;
	}
	_tmp4_ = config;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->m_config);
	self->priv->m_config = _tmp5_;
	_tmp6_ = self->priv->m_config;
	if (_tmp6_ != NULL) {
		IBusConfig* _tmp7_;
		IBusConfig* _tmp8_;
		IBusConfig* _tmp9_;
		IBusConfig* _tmp10_;
		IBusConfig* _tmp11_;
		IBusConfig* _tmp12_;
		IBusConfig* _tmp13_;
		GVariant* _tmp14_ = NULL;
		GVariant* _tmp15_;
		IBusConfig* _tmp16_;
		GVariant* _tmp17_ = NULL;
		GVariant* _tmp18_;
		_tmp7_ = self->priv->m_config;
		g_signal_connect_object (_tmp7_, "value-changed", (GCallback) _panel_config_value_changed_cb_ibus_config_value_changed, self, 0);
		_tmp8_ = self->priv->m_config;
		ibus_config_watch (_tmp8_, "general", "preload_engines");
		_tmp9_ = self->priv->m_config;
		ibus_config_watch (_tmp9_, "general", "engines_order");
		_tmp10_ = self->priv->m_config;
		ibus_config_watch (_tmp10_, "general", "switcher_delay_time");
		_tmp11_ = self->priv->m_config;
		ibus_config_watch (_tmp11_, "panel", "custom_font");
		_tmp12_ = self->priv->m_config;
		ibus_config_watch (_tmp12_, "panel", "use_custom_font");
		_tmp13_ = self->priv->m_config;
		_tmp14_ = ibus_config_get_value (_tmp13_, "general", "preload_engines");
		_tmp15_ = _tmp14_;
		_tmp16_ = self->priv->m_config;
		_tmp17_ = ibus_config_get_value (_tmp16_, "general", "engines_order");
		_tmp18_ = _tmp17_;
		panel_update_engines (self, _tmp15_, _tmp18_);
		_g_variant_unref0 (_tmp18_);
		_g_variant_unref0 (_tmp15_);
		panel_set_switcher_delay_time (self, NULL);
	} else {
		panel_update_engines (self, NULL, NULL);
	}
	panel_set_custom_font (self);
}


static void _vala_array_add14 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add15 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add16 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add17 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add18 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add19 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add20 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void panel_exec_setxkbmap (Panel* self, IBusEngineDesc* engine) {
	IBusEngineDesc* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* layout;
	IBusEngineDesc* _tmp3_;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* variant;
	IBusEngineDesc* _tmp6_;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* option;
	gchar* standard_error;
	gint exit_status;
	gchar* _tmp9_;
	gchar** _tmp10_ = NULL;
	gchar** args;
	gint args_length1;
	gint _args_size_;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_;
	gboolean _tmp15_;
	gboolean _tmp17_;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	const gchar* _tmp25_;
	gboolean _tmp27_;
	gboolean _tmp29_;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	const gchar* _tmp37_;
	gboolean _tmp39_;
	gboolean _tmp41_;
	gchar** _tmp49_;
	gint _tmp49__length1;
	gint _tmp59_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (engine != NULL);
	_tmp0_ = engine;
	_tmp1_ = ibus_engine_desc_get_layout (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	layout = _tmp2_;
	_tmp3_ = engine;
	_tmp4_ = ibus_engine_desc_get_layout_variant (_tmp3_);
	_tmp5_ = g_strdup (_tmp4_);
	variant = _tmp5_;
	_tmp6_ = engine;
	_tmp7_ = ibus_engine_desc_get_layout_option (_tmp6_);
	_tmp8_ = g_strdup (_tmp7_);
	option = _tmp8_;
	standard_error = NULL;
	exit_status = 0;
	_tmp9_ = g_strdup ("setxkbmap");
	_tmp10_ = g_new0 (gchar*, 1 + 1);
	_tmp10_[0] = _tmp9_;
	args = _tmp10_;
	args_length1 = 1;
	_args_size_ = args_length1;
	_tmp13_ = layout;
	if (_tmp13_ != NULL) {
		const gchar* _tmp14_;
		_tmp14_ = layout;
		_tmp12_ = g_strcmp0 (_tmp14_, "") != 0;
	} else {
		_tmp12_ = FALSE;
	}
	_tmp15_ = _tmp12_;
	if (_tmp15_) {
		const gchar* _tmp16_;
		_tmp16_ = layout;
		_tmp11_ = g_strcmp0 (_tmp16_, "default") != 0;
	} else {
		_tmp11_ = FALSE;
	}
	_tmp17_ = _tmp11_;
	if (_tmp17_) {
		gchar** _tmp18_;
		gint _tmp18__length1;
		gchar* _tmp19_;
		gchar** _tmp20_;
		gint _tmp20__length1;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp18_ = args;
		_tmp18__length1 = args_length1;
		_tmp19_ = g_strdup ("-layout");
		_vala_array_add14 (&args, &args_length1, &_args_size_, _tmp19_);
		_tmp20_ = args;
		_tmp20__length1 = args_length1;
		_tmp21_ = layout;
		_tmp22_ = g_strdup (_tmp21_);
		_vala_array_add15 (&args, &args_length1, &_args_size_, _tmp22_);
	}
	_tmp25_ = variant;
	if (_tmp25_ != NULL) {
		const gchar* _tmp26_;
		_tmp26_ = variant;
		_tmp24_ = g_strcmp0 (_tmp26_, "") != 0;
	} else {
		_tmp24_ = FALSE;
	}
	_tmp27_ = _tmp24_;
	if (_tmp27_) {
		const gchar* _tmp28_;
		_tmp28_ = variant;
		_tmp23_ = g_strcmp0 (_tmp28_, "default") != 0;
	} else {
		_tmp23_ = FALSE;
	}
	_tmp29_ = _tmp23_;
	if (_tmp29_) {
		gchar** _tmp30_;
		gint _tmp30__length1;
		gchar* _tmp31_;
		gchar** _tmp32_;
		gint _tmp32__length1;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		_tmp30_ = args;
		_tmp30__length1 = args_length1;
		_tmp31_ = g_strdup ("-variant");
		_vala_array_add16 (&args, &args_length1, &_args_size_, _tmp31_);
		_tmp32_ = args;
		_tmp32__length1 = args_length1;
		_tmp33_ = variant;
		_tmp34_ = g_strdup (_tmp33_);
		_vala_array_add17 (&args, &args_length1, &_args_size_, _tmp34_);
	}
	_tmp37_ = option;
	if (_tmp37_ != NULL) {
		const gchar* _tmp38_;
		_tmp38_ = option;
		_tmp36_ = g_strcmp0 (_tmp38_, "") != 0;
	} else {
		_tmp36_ = FALSE;
	}
	_tmp39_ = _tmp36_;
	if (_tmp39_) {
		const gchar* _tmp40_;
		_tmp40_ = option;
		_tmp35_ = g_strcmp0 (_tmp40_, "default") != 0;
	} else {
		_tmp35_ = FALSE;
	}
	_tmp41_ = _tmp35_;
	if (_tmp41_) {
		gchar** _tmp42_;
		gint _tmp42__length1;
		gchar* _tmp43_;
		gchar** _tmp44_;
		gint _tmp44__length1;
		gchar* _tmp45_;
		gchar** _tmp46_;
		gint _tmp46__length1;
		const gchar* _tmp47_;
		gchar* _tmp48_;
		_tmp42_ = args;
		_tmp42__length1 = args_length1;
		_tmp43_ = g_strdup ("-option");
		_vala_array_add18 (&args, &args_length1, &_args_size_, _tmp43_);
		_tmp44_ = args;
		_tmp44__length1 = args_length1;
		_tmp45_ = g_strdup ("-option");
		_vala_array_add19 (&args, &args_length1, &_args_size_, _tmp45_);
		_tmp46_ = args;
		_tmp46__length1 = args_length1;
		_tmp47_ = option;
		_tmp48_ = g_strdup (_tmp47_);
		_vala_array_add20 (&args, &args_length1, &_args_size_, _tmp48_);
	}
	_tmp49_ = args;
	_tmp49__length1 = args_length1;
	if (_tmp49__length1 == 1) {
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (standard_error);
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		return;
	}
	{
		gchar** _tmp50_;
		gint _tmp50__length1;
		gchar* _tmp51_ = NULL;
		gint _tmp52_ = 0;
		gboolean _tmp53_ = FALSE;
		gboolean _tmp54_;
		_tmp50_ = args;
		_tmp50__length1 = args_length1;
		_tmp53_ = g_spawn_sync (NULL, _tmp50_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_tmp51_, &_tmp52_, &_inner_error_);
		_g_free0 (standard_error);
		standard_error = _tmp51_;
		exit_status = _tmp52_;
		_tmp54_ = _tmp53_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch3_g_spawn_error;
			}
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (standard_error);
			_g_free0 (option);
			_g_free0 (variant);
			_g_free0 (layout);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		if (!_tmp54_) {
			IBusEngineDesc* _tmp55_;
			const gchar* _tmp56_ = NULL;
			_tmp55_ = engine;
			_tmp56_ = ibus_engine_desc_get_layout (_tmp55_);
			g_warning ("panel.vala:273: Switch xkb layout to %s failed.", _tmp56_);
		}
	}
	goto __finally3;
	__catch3_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp57_;
		const gchar* _tmp58_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp57_ = e;
		_tmp58_ = _tmp57_->message;
		g_warning ("panel.vala:277: Execute setxkbmap failed: %s", _tmp58_);
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (standard_error);
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp59_ = exit_status;
	if (_tmp59_ != 0) {
		const gchar* _tmp60_;
		gchar* _tmp61_;
		gchar* _tmp62_;
		const gchar* _tmp63_;
		const gchar* _tmp65_;
		_tmp60_ = standard_error;
		_tmp61_ = g_strdup (_tmp60_);
		_tmp62_ = _tmp61_;
		_tmp63_ = _tmp62_;
		if (_tmp63_ == NULL) {
			gchar* _tmp64_;
			_tmp64_ = g_strdup ("(null)");
			_g_free0 (_tmp62_);
			_tmp62_ = _tmp64_;
		}
		_tmp65_ = _tmp62_;
		g_warning ("panel.vala:281: Execute setxkbmap failed: %s", _tmp65_);
		_g_free0 (_tmp62_);
	}
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (standard_error);
	_g_free0 (option);
	_g_free0 (variant);
	_g_free0 (layout);
}


static void panel_switch_engine (Panel* self, gint i, gboolean force) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gboolean _tmp4_;
	gboolean _tmp5_ = FALSE;
	gint _tmp6_;
	gboolean _tmp8_;
	IBusEngineDesc** _tmp9_;
	gint _tmp9__length1;
	gint _tmp10_;
	IBusEngineDesc* _tmp11_;
	IBusEngineDesc* _tmp12_;
	IBusEngineDesc* engine;
	IBusBus* _tmp13_;
	IBusEngineDesc* _tmp14_;
	const gchar* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	IBusEngineDesc* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp1_ = i;
	if (_tmp1_ >= 0) {
		gint _tmp2_;
		IBusEngineDesc** _tmp3_;
		gint _tmp3__length1;
		_tmp2_ = i;
		_tmp3_ = self->priv->m_engines;
		_tmp3__length1 = self->priv->m_engines_length1;
		_tmp0_ = _tmp2_ < _tmp3__length1;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	_vala_assert (_tmp4_, "i >= 0 && i < m_engines.length");
	_tmp6_ = i;
	if (_tmp6_ == 0) {
		gboolean _tmp7_;
		_tmp7_ = force;
		_tmp5_ = !_tmp7_;
	} else {
		_tmp5_ = FALSE;
	}
	_tmp8_ = _tmp5_;
	if (_tmp8_) {
		return;
	}
	_tmp9_ = self->priv->m_engines;
	_tmp9__length1 = self->priv->m_engines_length1;
	_tmp10_ = i;
	_tmp11_ = _tmp9_[_tmp10_];
	_tmp12_ = _g_object_ref0 (_tmp11_);
	engine = _tmp12_;
	_tmp13_ = self->priv->m_bus;
	_tmp14_ = engine;
	_tmp15_ = ibus_engine_desc_get_name (_tmp14_);
	_tmp16_ = ibus_bus_set_global_engine (_tmp13_, _tmp15_);
	if (!_tmp16_) {
		IBusEngineDesc* _tmp17_;
		const gchar* _tmp18_ = NULL;
		_tmp17_ = engine;
		_tmp18_ = ibus_engine_desc_get_name (_tmp17_);
		g_warning ("panel.vala:295: Switch engine to %s failed.", _tmp18_);
		_g_object_unref0 (engine);
		return;
	}
	_tmp19_ = engine;
	panel_exec_setxkbmap (self, _tmp19_);
	_g_object_unref0 (engine);
}


static void panel_config_value_changed_cb (Panel* self, IBusConfig* config, const gchar* section, const gchar* name, GVariant* variant) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp3_;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp6_;
	gboolean _tmp11_;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_;
	gboolean _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (config != NULL);
	g_return_if_fail (section != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (variant != NULL);
	_tmp1_ = section;
	if (g_strcmp0 (_tmp1_, "general") == 0) {
		const gchar* _tmp2_;
		_tmp2_ = name;
		_tmp0_ = g_strcmp0 (_tmp2_, "preload_engines") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		GVariant* _tmp4_;
		_tmp4_ = variant;
		panel_update_engines (self, _tmp4_, NULL);
		return;
	}
	_tmp6_ = section;
	if (g_strcmp0 (_tmp6_, "panel") == 0) {
		gboolean _tmp7_ = FALSE;
		const gchar* _tmp8_;
		gboolean _tmp10_;
		_tmp8_ = name;
		if (g_strcmp0 (_tmp8_, "custom_font") == 0) {
			_tmp7_ = TRUE;
		} else {
			const gchar* _tmp9_;
			_tmp9_ = name;
			_tmp7_ = g_strcmp0 (_tmp9_, "use_custom_font") == 0;
		}
		_tmp10_ = _tmp7_;
		_tmp5_ = _tmp10_;
	} else {
		_tmp5_ = FALSE;
	}
	_tmp11_ = _tmp5_;
	if (_tmp11_) {
		panel_set_custom_font (self);
		return;
	}
	_tmp13_ = section;
	if (g_strcmp0 (_tmp13_, "general") == 0) {
		const gchar* _tmp14_;
		_tmp14_ = name;
		_tmp12_ = g_strcmp0 (_tmp14_, "switcher_delay_time") == 0;
	} else {
		_tmp12_ = FALSE;
	}
	_tmp15_ = _tmp12_;
	if (_tmp15_) {
		GVariant* _tmp16_;
		_tmp16_ = variant;
		panel_set_switcher_delay_time (self, _tmp16_);
	}
}


static void panel_handle_engine_switch (Panel* self, GdkEvent* event, gboolean revert) {
	IBusEngineDesc** _tmp0_;
	gint _tmp0__length1;
	GdkEvent* _tmp1_;
	GdkEventKey _tmp2_;
	GdkModifierType _tmp3_;
	GdkModifierType _tmp4_ = 0;
	guint primary_modifiers;
	GdkEvent* _tmp5_;
	guint _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean pressed;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_;
	gboolean _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = self->priv->m_engines;
	_tmp0__length1 = self->priv->m_engines_length1;
	if (_tmp0__length1 <= 1) {
		return;
	}
	_tmp1_ = event;
	_tmp2_ = _tmp1_->key;
	_tmp3_ = _tmp2_.state;
	_tmp4_ = keybinding_manager_get_primary_modifier ((guint) _tmp3_);
	primary_modifiers = (guint) _tmp4_;
	_tmp5_ = event;
	_tmp6_ = primary_modifiers;
	_tmp7_ = keybinding_manager_primary_modifier_still_pressed (_tmp5_, _tmp6_);
	pressed = _tmp7_;
	_tmp9_ = pressed;
	if (_tmp9_) {
		gint _tmp10_;
		_tmp10_ = self->priv->m_switcher_delay_time;
		_tmp8_ = _tmp10_ >= 0;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp11_ = _tmp8_;
	if (_tmp11_) {
		gint _tmp12_ = 0;
		gboolean _tmp13_;
		gint _tmp15_;
		gint i;
		Switcher* _tmp16_;
		guint _tmp17_;
		GdkModifierType _tmp18_;
		GdkEvent* _tmp19_;
		IBusEngineDesc** _tmp20_;
		gint _tmp20__length1;
		gint _tmp21_;
		gint _tmp22_ = 0;
		gint _tmp23_;
		_tmp13_ = revert;
		if (_tmp13_) {
			IBusEngineDesc** _tmp14_;
			gint _tmp14__length1;
			_tmp14_ = self->priv->m_engines;
			_tmp14__length1 = self->priv->m_engines_length1;
			_tmp12_ = _tmp14__length1 - 1;
		} else {
			_tmp12_ = 1;
		}
		_tmp15_ = _tmp12_;
		i = _tmp15_;
		_tmp16_ = self->priv->m_switcher;
		_tmp17_ = self->priv->m_switch_keysym;
		_tmp18_ = self->priv->m_switch_modifiers;
		_tmp19_ = event;
		_tmp20_ = self->priv->m_engines;
		_tmp20__length1 = self->priv->m_engines_length1;
		_tmp21_ = i;
		_tmp22_ = switcher_run (_tmp16_, _tmp17_, (guint) _tmp18_, _tmp19_, _tmp20_, _tmp20__length1, _tmp21_);
		i = _tmp22_;
		_tmp23_ = i;
		if (_tmp23_ < 0) {
			g_debug ("panel.vala:337: switch cancelled");
		} else {
			gint _tmp24_;
			IBusEngineDesc** _tmp25_;
			gint _tmp25__length1;
			gint _tmp26_;
			_tmp24_ = i;
			_tmp25_ = self->priv->m_engines;
			_tmp25__length1 = self->priv->m_engines_length1;
			_vala_assert (_tmp24_ < _tmp25__length1, "i < m_engines.length");
			_tmp26_ = i;
			panel_switch_engine (self, _tmp26_, FALSE);
		}
	} else {
		gint _tmp27_ = 0;
		gboolean _tmp28_;
		gint _tmp30_;
		gint i;
		gint _tmp31_;
		_tmp28_ = revert;
		if (_tmp28_) {
			IBusEngineDesc** _tmp29_;
			gint _tmp29__length1;
			_tmp29_ = self->priv->m_engines;
			_tmp29__length1 = self->priv->m_engines_length1;
			_tmp27_ = _tmp29__length1 - 1;
		} else {
			_tmp27_ = 1;
		}
		_tmp30_ = _tmp27_;
		i = _tmp30_;
		_tmp31_ = i;
		panel_switch_engine (self, _tmp31_, FALSE);
	}
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gboolean _vala_string_array_contains (gchar** stack, int stack_length, gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


static void _vala_array_add21 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add22 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static IBusEngineDesc** _vala_array_dup3 (IBusEngineDesc** self, int length) {
	IBusEngineDesc** result;
	int i;
	result = g_new0 (IBusEngineDesc*, length + 1);
	for (i = 0; i < length; i++) {
		IBusEngineDesc* _tmp0_;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static IBusEngineDesc** _vala_array_dup4 (IBusEngineDesc** self, int length) {
	IBusEngineDesc** result;
	int i;
	result = g_new0 (IBusEngineDesc*, length + 1);
	for (i = 0; i < length; i++) {
		IBusEngineDesc* _tmp0_;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void panel_update_engines (Panel* self, GVariant* var_engines, GVariant* var_order) {
	gchar** engine_names;
	gint engine_names_length1;
	gint _engine_names_size_;
	GVariant* _tmp0_;
	gboolean _tmp4_ = FALSE;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gboolean _tmp7_;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gint __tmp10__size_ = 0;
	GVariant* _tmp11_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gchar** order_names;
	gint order_names_length1;
	gint _order_names_size_;
	gchar** _tmp17_ = NULL;
	gchar** names;
	gint names_length1;
	gint _names_size_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	gchar** _tmp25_;
	gint _tmp25__length1;
	IBusBus* _tmp32_;
	gchar** _tmp33_;
	gint _tmp33__length1;
	IBusEngineDesc** _tmp34_;
	IBusEngineDesc** _tmp35_ = NULL;
	IBusEngineDesc** engines;
	gint engines_length1;
	gint _engines_size_;
	IBusEngineDesc** _tmp36_;
	gint _tmp36__length1;
	g_return_if_fail (self != NULL);
	engine_names = NULL;
	engine_names_length1 = 0;
	_engine_names_size_ = engine_names_length1;
	_tmp0_ = var_engines;
	if (_tmp0_ != NULL) {
		GVariant* _tmp1_;
		size_t _tmp2_;
		gchar** _tmp3_ = NULL;
		_tmp1_ = var_engines;
		_tmp3_ = g_variant_dup_strv (_tmp1_, &_tmp2_);
		engine_names = (_vala_array_free (engine_names, engine_names_length1, (GDestroyNotify) g_free), NULL);
		engine_names = _tmp3_;
		engine_names_length1 = _tmp2_;
		_engine_names_size_ = engine_names_length1;
	}
	_tmp5_ = engine_names;
	_tmp5__length1 = engine_names_length1;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		gchar** _tmp6_;
		gint _tmp6__length1;
		_tmp6_ = engine_names;
		_tmp6__length1 = engine_names_length1;
		_tmp4_ = _tmp6__length1 == 0;
	}
	_tmp7_ = _tmp4_;
	if (_tmp7_) {
		gchar* _tmp8_;
		gchar** _tmp9_ = NULL;
		_tmp8_ = g_strdup ("xkb:us::eng");
		_tmp9_ = g_new0 (gchar*, 1 + 1);
		_tmp9_[0] = _tmp8_;
		engine_names = (_vala_array_free (engine_names, engine_names_length1, (GDestroyNotify) g_free), NULL);
		engine_names = _tmp9_;
		engine_names_length1 = 1;
		_engine_names_size_ = engine_names_length1;
	}
	_tmp11_ = var_order;
	if (_tmp11_ != NULL) {
		GVariant* _tmp12_;
		size_t _tmp13_;
		gchar** _tmp14_ = NULL;
		_tmp12_ = var_order;
		_tmp14_ = g_variant_dup_strv (_tmp12_, &_tmp13_);
		_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
		_tmp10_ = _tmp14_;
		_tmp10__length1 = _tmp13_;
		__tmp10__size_ = _tmp10__length1;
	} else {
		_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
		_tmp10_ = NULL;
		_tmp10__length1 = 0;
		__tmp10__size_ = _tmp10__length1;
	}
	_tmp15_ = _tmp10_;
	_tmp15__length1 = _tmp10__length1;
	_tmp16_ = (_tmp15_ != NULL) ? _vala_array_dup2 (_tmp15_, _tmp15__length1) : ((gpointer) _tmp15_);
	_tmp16__length1 = _tmp15__length1;
	order_names = _tmp16_;
	order_names_length1 = _tmp16__length1;
	_order_names_size_ = order_names_length1;
	_tmp17_ = g_new0 (gchar*, 0 + 1);
	names = _tmp17_;
	names_length1 = 0;
	_names_size_ = names_length1;
	_tmp18_ = order_names;
	_tmp18__length1 = order_names_length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp18_;
		name_collection_length1 = _tmp18__length1;
		for (name_it = 0; name_it < _tmp18__length1; name_it = name_it + 1) {
			gchar* _tmp19_;
			gchar* name = NULL;
			_tmp19_ = g_strdup (name_collection[name_it]);
			name = _tmp19_;
			{
				const gchar* _tmp20_;
				gchar** _tmp21_;
				gint _tmp21__length1;
				_tmp20_ = name;
				_tmp21_ = engine_names;
				_tmp21__length1 = engine_names_length1;
				if (_vala_string_array_contains (_tmp21_, _tmp21__length1, _tmp20_)) {
					gchar** _tmp22_;
					gint _tmp22__length1;
					const gchar* _tmp23_;
					gchar* _tmp24_;
					_tmp22_ = names;
					_tmp22__length1 = names_length1;
					_tmp23_ = name;
					_tmp24_ = g_strdup (_tmp23_);
					_vala_array_add21 (&names, &names_length1, &_names_size_, _tmp24_);
				}
				_g_free0 (name);
			}
		}
	}
	_tmp25_ = engine_names;
	_tmp25__length1 = engine_names_length1;
	{
		gchar** name_collection = NULL;
		gint name_collection_length1 = 0;
		gint _name_collection_size_ = 0;
		gint name_it = 0;
		name_collection = _tmp25_;
		name_collection_length1 = _tmp25__length1;
		for (name_it = 0; name_it < _tmp25__length1; name_it = name_it + 1) {
			gchar* _tmp26_;
			gchar* name = NULL;
			_tmp26_ = g_strdup (name_collection[name_it]);
			name = _tmp26_;
			{
				const gchar* _tmp27_;
				gchar** _tmp28_;
				gint _tmp28__length1;
				gchar** _tmp29_;
				gint _tmp29__length1;
				const gchar* _tmp30_;
				gchar* _tmp31_;
				_tmp27_ = name;
				_tmp28_ = names;
				_tmp28__length1 = names_length1;
				if (_vala_string_array_contains (_tmp28_, _tmp28__length1, _tmp27_)) {
					_g_free0 (name);
					continue;
				}
				_tmp29_ = names;
				_tmp29__length1 = names_length1;
				_tmp30_ = name;
				_tmp31_ = g_strdup (_tmp30_);
				_vala_array_add22 (&names, &names_length1, &_names_size_, _tmp31_);
				_g_free0 (name);
			}
		}
	}
	_tmp32_ = self->priv->m_bus;
	_tmp33_ = names;
	_tmp33__length1 = names_length1;
	_tmp35_ = _tmp34_ = ibus_bus_get_engines_by_names (_tmp32_, _tmp33_);
	engines = _tmp35_;
	engines_length1 = _vala_array_length (_tmp34_);
	_engines_size_ = engines_length1;
	_tmp36_ = self->priv->m_engines;
	_tmp36__length1 = self->priv->m_engines_length1;
	if (_tmp36__length1 == 0) {
		IBusEngineDesc** _tmp37_;
		gint _tmp37__length1;
		IBusEngineDesc** _tmp38_;
		gint _tmp38__length1;
		_tmp37_ = engines;
		_tmp37__length1 = engines_length1;
		_tmp38_ = (_tmp37_ != NULL) ? _vala_array_dup3 (_tmp37_, _tmp37__length1) : ((gpointer) _tmp37_);
		_tmp38__length1 = _tmp37__length1;
		self->priv->m_engines = (_vala_array_free (self->priv->m_engines, self->priv->m_engines_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_engines = _tmp38_;
		self->priv->m_engines_length1 = _tmp38__length1;
		self->priv->_m_engines_size_ = self->priv->m_engines_length1;
		panel_switch_engine (self, 0, TRUE);
	} else {
		IBusEngineDesc** _tmp39_;
		gint _tmp39__length1;
		IBusEngineDesc* _tmp40_;
		IBusEngineDesc* _tmp41_;
		IBusEngineDesc* current_engine;
		IBusEngineDesc** _tmp42_;
		gint _tmp42__length1;
		IBusEngineDesc** _tmp43_;
		gint _tmp43__length1;
		gint i = 0;
		_tmp39_ = self->priv->m_engines;
		_tmp39__length1 = self->priv->m_engines_length1;
		_tmp40_ = _tmp39_[0];
		_tmp41_ = _g_object_ref0 (_tmp40_);
		current_engine = _tmp41_;
		_tmp42_ = engines;
		_tmp42__length1 = engines_length1;
		_tmp43_ = (_tmp42_ != NULL) ? _vala_array_dup4 (_tmp42_, _tmp42__length1) : ((gpointer) _tmp42_);
		_tmp43__length1 = _tmp42__length1;
		self->priv->m_engines = (_vala_array_free (self->priv->m_engines, self->priv->m_engines_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_engines = _tmp43_;
		self->priv->m_engines_length1 = _tmp43__length1;
		self->priv->_m_engines_size_ = self->priv->m_engines_length1;
		{
			gboolean _tmp44_;
			i = 0;
			_tmp44_ = TRUE;
			while (TRUE) {
				gboolean _tmp45_;
				gint _tmp47_;
				IBusEngineDesc** _tmp48_;
				gint _tmp48__length1;
				IBusEngineDesc* _tmp49_;
				const gchar* _tmp50_ = NULL;
				IBusEngineDesc** _tmp51_;
				gint _tmp51__length1;
				gint _tmp52_;
				IBusEngineDesc* _tmp53_;
				const gchar* _tmp54_ = NULL;
				_tmp45_ = _tmp44_;
				if (!_tmp45_) {
					gint _tmp46_;
					_tmp46_ = i;
					i = _tmp46_ + 1;
				}
				_tmp44_ = FALSE;
				_tmp47_ = i;
				_tmp48_ = self->priv->m_engines;
				_tmp48__length1 = self->priv->m_engines_length1;
				if (!(_tmp47_ < _tmp48__length1)) {
					break;
				}
				_tmp49_ = current_engine;
				_tmp50_ = ibus_engine_desc_get_name (_tmp49_);
				_tmp51_ = engines;
				_tmp51__length1 = engines_length1;
				_tmp52_ = i;
				_tmp53_ = _tmp51_[_tmp52_];
				_tmp54_ = ibus_engine_desc_get_name (_tmp53_);
				if (g_strcmp0 (_tmp50_, _tmp54_) == 0) {
					gint _tmp55_;
					_tmp55_ = i;
					panel_switch_engine (self, _tmp55_, FALSE);
					_g_object_unref0 (current_engine);
					engines = (_vala_array_free (engines, engines_length1, (GDestroyNotify) g_object_unref), NULL);
					names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
					order_names = (_vala_array_free (order_names, order_names_length1, (GDestroyNotify) g_free), NULL);
					_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
					engine_names = (_vala_array_free (engine_names, engine_names_length1, (GDestroyNotify) g_free), NULL);
					return;
				}
			}
		}
		panel_switch_engine (self, 0, TRUE);
		_g_object_unref0 (current_engine);
	}
	engines = (_vala_array_free (engines, engines_length1, (GDestroyNotify) g_object_unref), NULL);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	order_names = (_vala_array_free (order_names, order_names_length1, (GDestroyNotify) g_free), NULL);
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
	engine_names = (_vala_array_free (engine_names, engine_names_length1, (GDestroyNotify) g_free), NULL);
}


static void __lambda18_ (Panel* self, GPid pid, gint state) {
	GPid _tmp0_;
	GPid _tmp1_;
	GPid _tmp2_;
	_tmp0_ = pid;
	_tmp1_ = self->priv->m_setup_pid;
	if (_tmp0_ != _tmp1_) {
		return;
	}
	self->priv->m_setup_pid = (GPid) 0;
	_tmp2_ = pid;
	g_spawn_close_pid (_tmp2_);
}


static void ___lambda18__gchild_watch_func (GPid pid, gint status, gpointer self) {
	__lambda18_ (self, pid, status);
}


static void panel_show_setup_dialog (Panel* self) {
	GPid _tmp0_;
	gchar* _tmp3_ = NULL;
	gchar* binary;
	GPid _tmp13_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_setup_pid;
	if (_tmp0_ != ((GPid) 0)) {
		GPid _tmp1_;
		gint _tmp2_ = 0;
		_tmp1_ = self->priv->m_setup_pid;
		_tmp2_ = kill ((pid_t) _tmp1_, SIGUSR1);
		if (_tmp2_ == 0) {
			return;
		}
		self->priv->m_setup_pid = (GPid) 0;
	}
	_tmp3_ = g_build_filename (BINDIR, "ibus-setup", NULL);
	binary = _tmp3_;
	{
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar** _tmp7_ = NULL;
		gchar** _tmp8_;
		gint _tmp8__length1;
		GPid _tmp9_ = 0;
		_tmp4_ = binary;
		_tmp5_ = g_strdup (_tmp4_);
		_tmp6_ = g_strdup ("ibus-setup");
		_tmp7_ = g_new0 (gchar*, 2 + 1);
		_tmp7_[0] = _tmp5_;
		_tmp7_[1] = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp8__length1 = 2;
		g_spawn_async (NULL, _tmp8_, NULL, G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_tmp9_, &_inner_error_);
		self->priv->m_setup_pid = _tmp9_;
		_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch4_g_spawn_error;
			}
			_g_free0 (binary);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally4;
	__catch4_g_spawn_error:
	{
		GError* e = NULL;
		const gchar* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = binary;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_warning ("panel.vala:409: Execute %s failed! %s", _tmp10_, _tmp12_);
		self->priv->m_setup_pid = (GPid) 0;
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_free0 (binary);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp13_ = self->priv->m_setup_pid;
	g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp13_, ___lambda18__gchild_watch_func, g_object_ref (self), g_object_unref);
	_g_free0 (binary);
}


static void panel_show_about_dialog (Panel* self) {
	GtkAboutDialog* _tmp0_;
	GtkAboutDialog* _tmp24_;
	gboolean _tmp25_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_about_dialog;
	if (_tmp0_ == NULL) {
		GtkAboutDialog* _tmp1_;
		GtkAboutDialog* _tmp2_;
		GtkAboutDialog* _tmp3_;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* copyright;
		GtkAboutDialog* _tmp6_;
		const gchar* _tmp7_;
		GtkAboutDialog* _tmp8_;
		GtkAboutDialog* _tmp9_;
		const gchar* _tmp10_ = NULL;
		GtkAboutDialog* _tmp11_;
		GtkAboutDialog* _tmp12_;
		gchar* _tmp13_;
		gchar** _tmp14_ = NULL;
		gchar** _tmp15_;
		gint _tmp15__length1;
		GtkAboutDialog* _tmp16_;
		gchar* _tmp17_;
		gchar** _tmp18_ = NULL;
		gchar** _tmp19_;
		gint _tmp19__length1;
		GtkAboutDialog* _tmp20_;
		const gchar* _tmp21_ = NULL;
		GtkAboutDialog* _tmp22_;
		GtkAboutDialog* _tmp23_;
		_tmp1_ = (GtkAboutDialog*) gtk_about_dialog_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->m_about_dialog);
		self->priv->m_about_dialog = _tmp1_;
		_tmp2_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_program_name (_tmp2_, "IBus");
		_tmp3_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_version (_tmp3_, PACKAGE_VERSION);
		_tmp4_ = _ ("Copyright (c) 2007-2012 Peng Huang\n" "Copyright (c) 2007-2010 Red Hat, Inc.\n");
		_tmp5_ = g_strdup (_tmp4_);
		copyright = _tmp5_;
		_tmp6_ = self->priv->m_about_dialog;
		_tmp7_ = copyright;
		gtk_about_dialog_set_copyright (_tmp6_, _tmp7_);
		_tmp8_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_license (_tmp8_, "LGPL");
		_tmp9_ = self->priv->m_about_dialog;
		_tmp10_ = _ ("IBus is an intelligent input bus for Linux/Unix.");
		gtk_about_dialog_set_comments (_tmp9_, _tmp10_);
		_tmp11_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_website (_tmp11_, "http://code.google.com/p/ibus");
		_tmp12_ = self->priv->m_about_dialog;
		_tmp13_ = g_strdup ("Peng Huang <shawn.p.huang@gmail.com>");
		_tmp14_ = g_new0 (gchar*, 1 + 1);
		_tmp14_[0] = _tmp13_;
		_tmp15_ = _tmp14_;
		_tmp15__length1 = 1;
		gtk_about_dialog_set_authors (_tmp12_, _tmp15_);
		_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_free), NULL);
		_tmp16_ = self->priv->m_about_dialog;
		_tmp17_ = g_strdup ("Peng Huang <shawn.p.huang@gmail.com>");
		_tmp18_ = g_new0 (gchar*, 1 + 1);
		_tmp18_[0] = _tmp17_;
		_tmp19_ = _tmp18_;
		_tmp19__length1 = 1;
		gtk_about_dialog_set_documenters (_tmp16_, _tmp19_);
		_tmp19_ = (_vala_array_free (_tmp19_, _tmp19__length1, (GDestroyNotify) g_free), NULL);
		_tmp20_ = self->priv->m_about_dialog;
		_tmp21_ = _ ("translator-credits");
		gtk_about_dialog_set_translator_credits (_tmp20_, _tmp21_);
		_tmp22_ = self->priv->m_about_dialog;
		gtk_about_dialog_set_logo_icon_name (_tmp22_, "ibus");
		_tmp23_ = self->priv->m_about_dialog;
		gtk_window_set_icon_name ((GtkWindow*) _tmp23_, "ibus");
		_g_free0 (copyright);
	}
	_tmp24_ = self->priv->m_about_dialog;
	_tmp25_ = gtk_widget_get_visible ((GtkWidget*) _tmp24_);
	if (!_tmp25_) {
		GtkAboutDialog* _tmp26_;
		GtkAboutDialog* _tmp27_;
		_tmp26_ = self->priv->m_about_dialog;
		gtk_dialog_run ((GtkDialog*) _tmp26_);
		_tmp27_ = self->priv->m_about_dialog;
		gtk_widget_hide ((GtkWidget*) _tmp27_);
	} else {
		GtkAboutDialog* _tmp28_;
		_tmp28_ = self->priv->m_about_dialog;
		gtk_window_present ((GtkWindow*) _tmp28_);
	}
}


static void ___lambda17_ (Panel* self, GtkMenuItem* i) {
	g_return_if_fail (i != NULL);
	panel_show_setup_dialog (self);
}


static void ____lambda17__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	___lambda17_ (self, _sender);
}


static void ___lambda19_ (Panel* self, GtkMenuItem* i) {
	g_return_if_fail (i != NULL);
	panel_show_about_dialog (self);
}


static void ____lambda19__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	___lambda19_ (self, _sender);
}


static void ___lambda20_ (Panel* self, GtkMenuItem* i) {
	IBusBus* _tmp0_;
	g_return_if_fail (i != NULL);
	_tmp0_ = self->priv->m_bus;
	ibus_bus_exit (_tmp0_, TRUE);
}


static void ____lambda20__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	___lambda20_ (self, _sender);
}


static void ___lambda21_ (Panel* self, GtkMenuItem* i) {
	IBusBus* _tmp0_;
	g_return_if_fail (i != NULL);
	_tmp0_ = self->priv->m_bus;
	ibus_bus_exit (_tmp0_, FALSE);
}


static void ____lambda21__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	___lambda21_ (self, _sender);
}


static void _gtk_status_icon_position_menu_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self) {
	gtk_status_icon_position_menu (menu, x, y, push_in, self);
}


static void panel_status_icon_popup_menu_cb (Panel* self, GtkStatusIcon* status_icon, guint button, guint activate_time) {
	GtkMenu* _tmp0_;
	GtkMenu* _tmp24_;
	GtkStatusIcon* _tmp25_;
	guint32 _tmp26_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (status_icon != NULL);
	_tmp0_ = self->priv->m_sys_menu;
	if (_tmp0_ == NULL) {
		GtkImageMenuItem* item = NULL;
		GtkMenu* _tmp1_;
		GtkImageMenuItem* _tmp2_;
		GtkImageMenuItem* _tmp3_;
		GtkMenu* _tmp4_;
		GtkImageMenuItem* _tmp5_;
		GtkImageMenuItem* _tmp6_;
		GtkImageMenuItem* _tmp7_;
		GtkMenu* _tmp8_;
		GtkImageMenuItem* _tmp9_;
		GtkMenu* _tmp10_;
		GtkSeparatorMenuItem* _tmp11_;
		GtkSeparatorMenuItem* _tmp12_;
		GtkImageMenuItem* _tmp13_;
		GtkImageMenuItem* _tmp14_;
		const gchar* _tmp15_ = NULL;
		GtkImageMenuItem* _tmp16_;
		GtkMenu* _tmp17_;
		GtkImageMenuItem* _tmp18_;
		GtkImageMenuItem* _tmp19_;
		GtkImageMenuItem* _tmp20_;
		GtkMenu* _tmp21_;
		GtkImageMenuItem* _tmp22_;
		GtkMenu* _tmp23_;
		_tmp1_ = (GtkMenu*) gtk_menu_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->m_sys_menu);
		self->priv->m_sys_menu = _tmp1_;
		_tmp2_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_PREFERENCES, NULL);
		g_object_ref_sink (_tmp2_);
		_g_object_unref0 (item);
		item = _tmp2_;
		_tmp3_ = item;
		g_signal_connect_object ((GtkMenuItem*) _tmp3_, "activate", (GCallback) ____lambda17__gtk_menu_item_activate, self, 0);
		_tmp4_ = self->priv->m_sys_menu;
		_tmp5_ = item;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp4_, (GtkWidget*) ((GtkMenuItem*) _tmp5_));
		_tmp6_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_ABOUT, NULL);
		g_object_ref_sink (_tmp6_);
		_g_object_unref0 (item);
		item = _tmp6_;
		_tmp7_ = item;
		g_signal_connect_object ((GtkMenuItem*) _tmp7_, "activate", (GCallback) ____lambda19__gtk_menu_item_activate, self, 0);
		_tmp8_ = self->priv->m_sys_menu;
		_tmp9_ = item;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp8_, (GtkWidget*) ((GtkMenuItem*) _tmp9_));
		_tmp10_ = self->priv->m_sys_menu;
		_tmp11_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
		g_object_ref_sink (_tmp11_);
		_tmp12_ = _tmp11_;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp10_, (GtkWidget*) ((GtkMenuItem*) _tmp12_));
		_g_object_unref0 (_tmp12_);
		_tmp13_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_REFRESH, NULL);
		g_object_ref_sink (_tmp13_);
		_g_object_unref0 (item);
		item = _tmp13_;
		_tmp14_ = item;
		_tmp15_ = _ ("Restart");
		gtk_menu_item_set_label ((GtkMenuItem*) _tmp14_, _tmp15_);
		_tmp16_ = item;
		g_signal_connect_object ((GtkMenuItem*) _tmp16_, "activate", (GCallback) ____lambda20__gtk_menu_item_activate, self, 0);
		_tmp17_ = self->priv->m_sys_menu;
		_tmp18_ = item;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp17_, (GtkWidget*) ((GtkMenuItem*) _tmp18_));
		_tmp19_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_QUIT, NULL);
		g_object_ref_sink (_tmp19_);
		_g_object_unref0 (item);
		item = _tmp19_;
		_tmp20_ = item;
		g_signal_connect_object ((GtkMenuItem*) _tmp20_, "activate", (GCallback) ____lambda21__gtk_menu_item_activate, self, 0);
		_tmp21_ = self->priv->m_sys_menu;
		_tmp22_ = item;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp21_, (GtkWidget*) ((GtkMenuItem*) _tmp22_));
		_tmp23_ = self->priv->m_sys_menu;
		gtk_widget_show_all ((GtkWidget*) _tmp23_);
		_g_object_unref0 (item);
	}
	_tmp24_ = self->priv->m_sys_menu;
	_tmp25_ = self->priv->m_status_icon;
	_tmp26_ = gtk_get_current_event_time ();
	gtk_menu_popup (_tmp24_, NULL, NULL, _gtk_status_icon_position_menu_gtk_menu_position_func, _tmp25_, (guint) 0, _tmp26_);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		Panel * self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->e);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static void ____lambda22_ (Block4Data* _data4_, GtkMenuItem* item) {
	Panel * self;
	self = _data4_->self;
	g_return_if_fail (item != NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				IBusEngineDesc** _tmp4_;
				gint _tmp4__length1;
				IBusEngineDesc* _tmp5_;
				IBusEngineDesc** _tmp6_;
				gint _tmp6__length1;
				gint _tmp7_;
				IBusEngineDesc* _tmp8_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = self->priv->m_engines;
				_tmp4__length1 = self->priv->m_engines_length1;
				if (!(_tmp3_ < _tmp4__length1)) {
					break;
				}
				_tmp5_ = _data4_->e;
				_tmp6_ = self->priv->m_engines;
				_tmp6__length1 = self->priv->m_engines_length1;
				_tmp7_ = i;
				_tmp8_ = _tmp6_[_tmp7_];
				if (_tmp5_ == _tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					panel_switch_engine (self, _tmp9_, FALSE);
					break;
				}
			}
		}
	}
}


static void _____lambda22__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	____lambda22_ (self, _sender);
}


static void panel_status_icon_activate_cb (Panel* self, GtkStatusIcon* status_icon) {
	GtkMenu* _tmp0_;
	PropertyManager* _tmp1_;
	GtkMenu* _tmp2_;
	GtkMenu* _tmp3_;
	GtkSeparatorMenuItem* _tmp4_;
	GtkSeparatorMenuItem* _tmp5_;
	gint width = 0;
	gint height = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	IBusEngineDesc** _tmp8_;
	gint _tmp8__length1;
	GtkMenu* _tmp36_;
	GtkMenu* _tmp37_;
	GtkMenu* _tmp38_;
	GtkStatusIcon* _tmp39_;
	guint32 _tmp40_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (status_icon != NULL);
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->m_ime_menu);
	self->priv->m_ime_menu = _tmp0_;
	_tmp1_ = self->priv->m_property_manager;
	_tmp2_ = self->priv->m_ime_menu;
	property_manager_create_menu_items (_tmp1_, _tmp2_);
	_tmp3_ = self->priv->m_ime_menu;
	_tmp4_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp3_, (GtkWidget*) ((GtkMenuItem*) _tmp5_));
	_g_object_unref0 (_tmp5_);
	gtk_icon_size_lookup (GTK_ICON_SIZE_MENU, &_tmp6_, &_tmp7_);
	width = _tmp6_;
	height = _tmp7_;
	_tmp8_ = self->priv->m_engines;
	_tmp8__length1 = self->priv->m_engines_length1;
	{
		IBusEngineDesc** engine_collection = NULL;
		gint engine_collection_length1 = 0;
		gint _engine_collection_size_ = 0;
		gint engine_it = 0;
		engine_collection = _tmp8_;
		engine_collection_length1 = _tmp8__length1;
		for (engine_it = 0; engine_it < _tmp8__length1; engine_it = engine_it + 1) {
			IBusEngineDesc* _tmp9_;
			IBusEngineDesc* engine = NULL;
			_tmp9_ = _g_object_ref0 (engine_collection[engine_it]);
			engine = _tmp9_;
			{
				Block4Data* _data4_;
				IBusEngineDesc* _tmp10_;
				const gchar* _tmp11_ = NULL;
				gchar* _tmp12_;
				gchar* language;
				IBusEngineDesc* _tmp13_;
				const gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
				gchar* longname;
				const gchar* _tmp16_;
				const gchar* _tmp17_ = NULL;
				const gchar* _tmp18_;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_;
				GtkImageMenuItem* _tmp21_;
				GtkImageMenuItem* _tmp22_;
				GtkImageMenuItem* item;
				IBusEngineDesc* _tmp23_;
				const gchar* _tmp24_ = NULL;
				IBusEngineDesc* _tmp31_;
				IBusEngineDesc* _tmp32_;
				GtkImageMenuItem* _tmp33_;
				GtkMenu* _tmp34_;
				GtkImageMenuItem* _tmp35_;
				_data4_ = g_slice_new0 (Block4Data);
				_data4_->_ref_count_ = 1;
				_data4_->self = g_object_ref (self);
				_tmp10_ = engine;
				_tmp11_ = ibus_engine_desc_get_language (_tmp10_);
				_tmp12_ = g_strdup (_tmp11_);
				language = _tmp12_;
				_tmp13_ = engine;
				_tmp14_ = ibus_engine_desc_get_longname (_tmp13_);
				_tmp15_ = g_strdup (_tmp14_);
				longname = _tmp15_;
				_tmp16_ = language;
				_tmp17_ = ibus_get_language_name (_tmp16_);
				_tmp18_ = longname;
				_tmp19_ = g_strdup_printf ("%s - %s", _tmp17_, _tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_label (_tmp20_);
				g_object_ref_sink (_tmp21_);
				_tmp22_ = _tmp21_;
				_g_free0 (_tmp20_);
				item = _tmp22_;
				_tmp23_ = engine;
				_tmp24_ = ibus_engine_desc_get_icon (_tmp23_);
				if (g_strcmp0 (_tmp24_, "") != 0) {
					IBusEngineDesc* _tmp25_;
					const gchar* _tmp26_ = NULL;
					gint _tmp27_;
					IconWidget* _tmp28_;
					IconWidget* icon;
					GtkImageMenuItem* _tmp29_;
					IconWidget* _tmp30_;
					_tmp25_ = engine;
					_tmp26_ = ibus_engine_desc_get_icon (_tmp25_);
					_tmp27_ = width;
					_tmp28_ = icon_widget_new (_tmp26_, _tmp27_);
					g_object_ref_sink (_tmp28_);
					icon = _tmp28_;
					_tmp29_ = item;
					_tmp30_ = icon;
					gtk_image_menu_item_set_image (_tmp29_, (GtkWidget*) _tmp30_);
					_g_object_unref0 (icon);
				}
				_tmp31_ = engine;
				_tmp32_ = _g_object_ref0 (_tmp31_);
				_data4_->e = _tmp32_;
				_tmp33_ = item;
				g_signal_connect_data ((GtkMenuItem*) _tmp33_, "activate", (GCallback) _____lambda22__gtk_menu_item_activate, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
				_tmp34_ = self->priv->m_ime_menu;
				_tmp35_ = item;
				gtk_container_add ((GtkContainer*) _tmp34_, (GtkWidget*) _tmp35_);
				_g_object_unref0 (item);
				_g_free0 (longname);
				_g_free0 (language);
				_g_object_unref0 (engine);
				block4_data_unref (_data4_);
				_data4_ = NULL;
			}
		}
	}
	_tmp36_ = self->priv->m_ime_menu;
	gtk_widget_show_all ((GtkWidget*) _tmp36_);
	_tmp37_ = self->priv->m_ime_menu;
	gtk_menu_shell_set_take_focus ((GtkMenuShell*) _tmp37_, FALSE);
	_tmp38_ = self->priv->m_ime_menu;
	_tmp39_ = self->priv->m_status_icon;
	_tmp40_ = gtk_get_current_event_time ();
	gtk_menu_popup (_tmp38_, NULL, NULL, _gtk_status_icon_position_menu_gtk_menu_position_func, _tmp39_, (guint) 0, _tmp40_);
}


static void panel_real_set_cursor_location (IBusPanelService* base, gint x, gint y, gint width, gint height) {
	Panel * self;
	CandidatePanel* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_candidate_panel;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = width;
	_tmp4_ = height;
	candidate_panel_set_cursor_location (_tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
}


static void panel_real_focus_in (IBusPanelService* base, const gchar* input_context_path) {
	Panel * self;
	self = (Panel*) base;
	g_return_if_fail (input_context_path != NULL);
}


static void panel_real_focus_out (IBusPanelService* base, const gchar* input_context_path) {
	Panel * self;
	self = (Panel*) base;
	g_return_if_fail (input_context_path != NULL);
}


static void panel_real_register_properties (IBusPanelService* base, IBusPropList* props) {
	Panel * self;
	PropertyManager* _tmp0_;
	IBusPropList* _tmp1_;
	self = (Panel*) base;
	g_return_if_fail (props != NULL);
	_tmp0_ = self->priv->m_property_manager;
	_tmp1_ = props;
	property_manager_set_properties (_tmp0_, _tmp1_);
}


static void panel_real_update_property (IBusPanelService* base, IBusProperty* prop) {
	Panel * self;
	PropertyManager* _tmp0_;
	IBusProperty* _tmp1_;
	self = (Panel*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = self->priv->m_property_manager;
	_tmp1_ = prop;
	property_manager_update_property (_tmp0_, _tmp1_);
}


static void panel_real_update_preedit_text (IBusPanelService* base, IBusText* text, guint cursor_pos, gboolean visible) {
	Panel * self;
	gboolean _tmp0_;
	self = (Panel*) base;
	g_return_if_fail (text != NULL);
	_tmp0_ = visible;
	if (_tmp0_) {
		CandidatePanel* _tmp1_;
		IBusText* _tmp2_;
		guint _tmp3_;
		_tmp1_ = self->priv->m_candidate_panel;
		_tmp2_ = text;
		_tmp3_ = cursor_pos;
		candidate_panel_set_preedit_text (_tmp1_, _tmp2_, _tmp3_);
	} else {
		CandidatePanel* _tmp4_;
		_tmp4_ = self->priv->m_candidate_panel;
		candidate_panel_set_preedit_text (_tmp4_, NULL, (guint) 0);
	}
}


static void panel_real_hide_preedit_text (IBusPanelService* base) {
	Panel * self;
	CandidatePanel* _tmp0_;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_candidate_panel;
	candidate_panel_set_preedit_text (_tmp0_, NULL, (guint) 0);
}


static void panel_real_update_auxiliary_text (IBusPanelService* base, IBusText* text, gboolean visible) {
	Panel * self;
	IBusText* _tmp0_ = NULL;
	gboolean _tmp1_;
	CandidatePanel* _tmp3_;
	IBusText* _tmp4_;
	self = (Panel*) base;
	g_return_if_fail (text != NULL);
	_tmp1_ = visible;
	if (_tmp1_) {
		IBusText* _tmp2_;
		_tmp2_ = text;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp3_ = self->priv->m_candidate_panel;
	_tmp4_ = _tmp0_;
	candidate_panel_set_auxiliary_text (_tmp3_, _tmp4_);
}


static void panel_real_hide_auxiliary_text (IBusPanelService* base) {
	Panel * self;
	CandidatePanel* _tmp0_;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_candidate_panel;
	candidate_panel_set_auxiliary_text (_tmp0_, NULL);
}


static void panel_real_update_lookup_table (IBusPanelService* base, IBusLookupTable* table, gboolean visible) {
	Panel * self;
	IBusLookupTable* _tmp0_ = NULL;
	gboolean _tmp1_;
	CandidatePanel* _tmp3_;
	IBusLookupTable* _tmp4_;
	self = (Panel*) base;
	g_return_if_fail (table != NULL);
	_tmp1_ = visible;
	if (_tmp1_) {
		IBusLookupTable* _tmp2_;
		_tmp2_ = table;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = NULL;
	}
	_tmp3_ = self->priv->m_candidate_panel;
	_tmp4_ = _tmp0_;
	candidate_panel_set_lookup_table (_tmp3_, _tmp4_);
}


static void panel_real_hide_lookup_table (IBusPanelService* base) {
	Panel * self;
	CandidatePanel* _tmp0_;
	self = (Panel*) base;
	_tmp0_ = self->priv->m_candidate_panel;
	candidate_panel_set_lookup_table (_tmp0_, NULL);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void _vala_array_add23 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void panel_real_state_changed (IBusPanelService* base) {
	Panel * self;
	gchar* _tmp0_;
	gchar* icon_name;
	IBusBus* _tmp1_;
	IBusEngineDesc* _tmp2_ = NULL;
	IBusEngineDesc* _tmp3_;
	IBusEngineDesc* engine;
	IBusEngineDesc* _tmp4_;
	const gchar* _tmp8_;
	gchar _tmp9_ = '\0';
	IBusEngineDesc* _tmp14_;
	gint i = 0;
	gint _tmp26_;
	gint _tmp27_;
	IBusEngineDesc** _tmp28_;
	gint _tmp28__length1;
	IBusEngineDesc** _tmp41_;
	gint _tmp41__length1;
	IBusEngineDesc* _tmp42_;
	IBusEngineDesc* _tmp43_;
	IBusEngineDesc* _tmp44_;
	gchar** _tmp45_ = NULL;
	gchar** names;
	gint names_length1;
	gint _names_size_;
	IBusEngineDesc** _tmp46_;
	gint _tmp46__length1;
	IBusConfig* _tmp52_;
	self = (Panel*) base;
	_tmp0_ = g_strdup ("ibus-keyboard");
	icon_name = _tmp0_;
	_tmp1_ = self->priv->m_bus;
	_tmp2_ = ibus_bus_get_global_engine (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	engine = _tmp3_;
	_tmp4_ = engine;
	if (_tmp4_ != NULL) {
		IBusEngineDesc* _tmp5_;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		_tmp5_ = engine;
		_tmp6_ = ibus_engine_desc_get_icon (_tmp5_);
		_tmp7_ = g_strdup (_tmp6_);
		_g_free0 (icon_name);
		icon_name = _tmp7_;
	}
	_tmp8_ = icon_name;
	_tmp9_ = string_get (_tmp8_, (glong) 0);
	if (_tmp9_ == '/') {
		GtkStatusIcon* _tmp10_;
		const gchar* _tmp11_;
		_tmp10_ = self->priv->m_status_icon;
		_tmp11_ = icon_name;
		gtk_status_icon_set_from_file (_tmp10_, _tmp11_);
	} else {
		GtkStatusIcon* _tmp12_;
		const gchar* _tmp13_;
		_tmp12_ = self->priv->m_status_icon;
		_tmp13_ = icon_name;
		gtk_status_icon_set_from_icon_name (_tmp12_, _tmp13_);
	}
	_tmp14_ = engine;
	if (_tmp14_ == NULL) {
		_g_object_unref0 (engine);
		_g_free0 (icon_name);
		return;
	}
	{
		gboolean _tmp15_;
		i = 0;
		_tmp15_ = TRUE;
		while (TRUE) {
			gboolean _tmp16_;
			gint _tmp18_;
			IBusEngineDesc** _tmp19_;
			gint _tmp19__length1;
			IBusEngineDesc** _tmp20_;
			gint _tmp20__length1;
			gint _tmp21_;
			IBusEngineDesc* _tmp22_;
			const gchar* _tmp23_ = NULL;
			IBusEngineDesc* _tmp24_;
			const gchar* _tmp25_ = NULL;
			_tmp16_ = _tmp15_;
			if (!_tmp16_) {
				gint _tmp17_;
				_tmp17_ = i;
				i = _tmp17_ + 1;
			}
			_tmp15_ = FALSE;
			_tmp18_ = i;
			_tmp19_ = self->priv->m_engines;
			_tmp19__length1 = self->priv->m_engines_length1;
			if (!(_tmp18_ < _tmp19__length1)) {
				break;
			}
			_tmp20_ = self->priv->m_engines;
			_tmp20__length1 = self->priv->m_engines_length1;
			_tmp21_ = i;
			_tmp22_ = _tmp20_[_tmp21_];
			_tmp23_ = ibus_engine_desc_get_name (_tmp22_);
			_tmp24_ = engine;
			_tmp25_ = ibus_engine_desc_get_name (_tmp24_);
			if (g_strcmp0 (_tmp23_, _tmp25_) == 0) {
				break;
			}
		}
	}
	_tmp26_ = i;
	if (_tmp26_ == 0) {
		_g_object_unref0 (engine);
		_g_free0 (icon_name);
		return;
	}
	_tmp27_ = i;
	_tmp28_ = self->priv->m_engines;
	_tmp28__length1 = self->priv->m_engines_length1;
	if (_tmp27_ >= _tmp28__length1) {
		_g_object_unref0 (engine);
		_g_free0 (icon_name);
		return;
	}
	{
		gint _tmp29_;
		gint j;
		_tmp29_ = i;
		j = _tmp29_;
		{
			gboolean _tmp30_;
			_tmp30_ = TRUE;
			while (TRUE) {
				gboolean _tmp31_;
				gint _tmp33_;
				IBusEngineDesc** _tmp34_;
				gint _tmp34__length1;
				gint _tmp35_;
				IBusEngineDesc** _tmp36_;
				gint _tmp36__length1;
				gint _tmp37_;
				IBusEngineDesc* _tmp38_;
				IBusEngineDesc* _tmp39_;
				IBusEngineDesc* _tmp40_;
				_tmp31_ = _tmp30_;
				if (!_tmp31_) {
					gint _tmp32_;
					_tmp32_ = j;
					j = _tmp32_ - 1;
				}
				_tmp30_ = FALSE;
				_tmp33_ = j;
				if (!(_tmp33_ > 0)) {
					break;
				}
				_tmp34_ = self->priv->m_engines;
				_tmp34__length1 = self->priv->m_engines_length1;
				_tmp35_ = j;
				_tmp36_ = self->priv->m_engines;
				_tmp36__length1 = self->priv->m_engines_length1;
				_tmp37_ = j;
				_tmp38_ = _tmp36_[_tmp37_ - 1];
				_tmp39_ = _g_object_ref0 (_tmp38_);
				_g_object_unref0 (_tmp34_[_tmp35_]);
				_tmp34_[_tmp35_] = _tmp39_;
				_tmp40_ = _tmp34_[_tmp35_];
			}
		}
	}
	_tmp41_ = self->priv->m_engines;
	_tmp41__length1 = self->priv->m_engines_length1;
	_tmp42_ = engine;
	_tmp43_ = _g_object_ref0 (_tmp42_);
	_g_object_unref0 (_tmp41_[0]);
	_tmp41_[0] = _tmp43_;
	_tmp44_ = _tmp41_[0];
	_tmp45_ = g_new0 (gchar*, 0 + 1);
	names = _tmp45_;
	names_length1 = 0;
	_names_size_ = names_length1;
	_tmp46_ = self->priv->m_engines;
	_tmp46__length1 = self->priv->m_engines_length1;
	{
		IBusEngineDesc** desc_collection = NULL;
		gint desc_collection_length1 = 0;
		gint _desc_collection_size_ = 0;
		gint desc_it = 0;
		desc_collection = _tmp46_;
		desc_collection_length1 = _tmp46__length1;
		for (desc_it = 0; desc_it < _tmp46__length1; desc_it = desc_it + 1) {
			IBusEngineDesc* _tmp47_;
			IBusEngineDesc* desc = NULL;
			_tmp47_ = _g_object_ref0 (desc_collection[desc_it]);
			desc = _tmp47_;
			{
				gchar** _tmp48_;
				gint _tmp48__length1;
				IBusEngineDesc* _tmp49_;
				const gchar* _tmp50_ = NULL;
				gchar* _tmp51_;
				_tmp48_ = names;
				_tmp48__length1 = names_length1;
				_tmp49_ = desc;
				_tmp50_ = ibus_engine_desc_get_name (_tmp49_);
				_tmp51_ = g_strdup (_tmp50_);
				_vala_array_add23 (&names, &names_length1, &_names_size_, _tmp51_);
				_g_object_unref0 (desc);
			}
		}
	}
	_tmp52_ = self->priv->m_config;
	if (_tmp52_ != NULL) {
		IBusConfig* _tmp53_;
		gchar** _tmp54_;
		gint _tmp54__length1;
		GVariant* _tmp55_;
		GVariant* _tmp56_;
		_tmp53_ = self->priv->m_config;
		_tmp54_ = names;
		_tmp54__length1 = names_length1;
		_tmp55_ = g_variant_new_strv (_tmp54_, _tmp54__length1);
		g_variant_ref_sink (_tmp55_);
		_tmp56_ = _tmp55_;
		ibus_config_set_value (_tmp53_, "general", "engines_order", _tmp56_);
		_g_variant_unref0 (_tmp56_);
	}
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (engine);
	_g_free0 (icon_name);
}


static void panel_class_init (PanelClass * klass) {
	panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PanelPrivate));
	IBUS_PANEL_SERVICE_CLASS (klass)->set_cursor_location = panel_real_set_cursor_location;
	IBUS_PANEL_SERVICE_CLASS (klass)->focus_in = panel_real_focus_in;
	IBUS_PANEL_SERVICE_CLASS (klass)->focus_out = panel_real_focus_out;
	IBUS_PANEL_SERVICE_CLASS (klass)->register_properties = panel_real_register_properties;
	IBUS_PANEL_SERVICE_CLASS (klass)->update_property = panel_real_update_property;
	IBUS_PANEL_SERVICE_CLASS (klass)->update_preedit_text = panel_real_update_preedit_text;
	IBUS_PANEL_SERVICE_CLASS (klass)->hide_preedit_text = panel_real_hide_preedit_text;
	IBUS_PANEL_SERVICE_CLASS (klass)->update_auxiliary_text = panel_real_update_auxiliary_text;
	IBUS_PANEL_SERVICE_CLASS (klass)->hide_auxiliary_text = panel_real_hide_auxiliary_text;
	IBUS_PANEL_SERVICE_CLASS (klass)->update_lookup_table = panel_real_update_lookup_table;
	IBUS_PANEL_SERVICE_CLASS (klass)->hide_lookup_table = panel_real_hide_lookup_table;
	IBUS_PANEL_SERVICE_CLASS (klass)->state_changed = panel_real_state_changed;
	G_OBJECT_CLASS (klass)->finalize = panel_finalize;
}


static void panel_instance_init (Panel * self) {
	IBusEngineDesc** _tmp0_ = NULL;
	self->priv = PANEL_GET_PRIVATE (self);
	_tmp0_ = g_new0 (IBusEngineDesc*, 0 + 1);
	self->priv->m_engines = _tmp0_;
	self->priv->m_engines_length1 = 0;
	self->priv->_m_engines_size_ = self->priv->m_engines_length1;
	self->priv->m_setup_pid = (GPid) 0;
	self->priv->m_switcher_delay_time = 400;
	self->priv->m_switch_keysym = (guint) 0;
	self->priv->m_switch_modifiers = 0;
}


static void panel_finalize (GObject* obj) {
	Panel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PANEL, Panel);
	panel_unbind_switch_shortcut (self);
	_g_object_unref0 (self->priv->m_bus);
	_g_object_unref0 (self->priv->m_config);
	_g_object_unref0 (self->priv->m_status_icon);
	_g_object_unref0 (self->priv->m_ime_menu);
	_g_object_unref0 (self->priv->m_sys_menu);
	self->priv->m_engines = (_vala_array_free (self->priv->m_engines, self->priv->m_engines_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->m_candidate_panel);
	_g_object_unref0 (self->priv->m_switcher);
	_property_manager_unref0 (self->priv->m_property_manager);
	_g_object_unref0 (self->priv->m_about_dialog);
	_g_object_unref0 (self->priv->m_css_provider);
	G_OBJECT_CLASS (panel_parent_class)->finalize (obj);
}


GType panel_get_type (void) {
	static volatile gsize panel_type_id__volatile = 0;
	if (g_once_init_enter (&panel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Panel), 0, (GInstanceInitFunc) panel_instance_init, NULL };
		GType panel_type_id;
		panel_type_id = g_type_register_static (ibus_panel_service_get_type (), "Panel", &g_define_type_info, 0);
		g_once_init_leave (&panel_type_id__volatile, panel_type_id);
	}
	return panel_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



